/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfluentReplicaFetcherTierStateMachine;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LeaderHwChange;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ResizableArray;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001\u0002\u0017.\u0001IB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"I!\n\u0001B\u0001B\u0003%1J\u0014\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u00115\u0004!\u0011!Q\u0001\n9D\u0001\"\u001d\u0001\u0003\u0002\u0003\u0006IA\u001d\u0005\tq\u0002\u0011\t\u0011)A\u0005s\"Iq\u0010\u0001B\u0001B\u0003%\u0011\u0011\u0001\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t\u0019\u0004C\u0004\u00026\u0001\u0001\u000b\u0011\u0002$\t\u0013\u0005]\u0002A1A\u0005\n\u0005e\u0002bBA\u001e\u0001\u0001\u0006I!\u001e\u0005\u000b\u0003{\u0001!\u0019!C\u0001[\u0005}\u0002\u0002CA+\u0001\u0001\u0006I!!\u0011\t\u0013\u0005]\u0003A1A\u0005R\u0005e\u0003\u0002CA1\u0001\u0001\u0006I!a\u0017\t\u0013\u0005\r\u0004A1A\u0005R\u0005e\u0003\u0002CA3\u0001\u0001\u0006I!a\u0017\t\u000f\u0005\u001d\u0004\u0001\"\u0015\u0002j!9\u0011\u0011\u000f\u0001\u0005R\u0005M\u0004bBA?\u0001\u0011E\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011KAC\u0011\u001d\t)\n\u0001C)\u0003/Cq!!+\u0001\t\u0003\nY\u000bC\u0004\u0002.\u0002!\t%a,\t\u000f\u0005E\u0006\u0001\"\u0011\u00020\"9\u00111\u0017\u0001\u0005B\u0005U\u0006\u0002CAr\u0001\u0011\u0005Q&a,\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\"9\u00111 \u0001\u0005B\u0005u\bb\u0002B\u0007\u0001\u0011E!q\u0002\u0005\b\u00053\u0001A\u0011\u000bB\u000e\u00115\u0011\u0019\u0003\u0001I\u0001\u0004\u0003\u0005I\u0011\u0002B\u0013\u001d\u001eI!qE\u0017\u0002\u0002#\u0005!\u0011\u0006\u0004\tY5\n\t\u0011#\u0001\u0003,!9\u00111\u0003\u0015\u0005\u0002\tM\u0002\"\u0003B\u001bQE\u0005I\u0011\u0001B\u001c\u0011%\u0011i\u0005KI\u0001\n\u0003\u0011yE\u0001\u000bSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003]=\naa]3sm\u0016\u0014(\"\u0001\u0019\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\r\t\u0003iUj\u0011!L\u0005\u0003m5\u0012Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0003oC6,\u0007CA\u001dC\u001d\tQ\u0004\t\u0005\u0002<}5\tAH\u0003\u0002>c\u00051AH]8pizR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011IP\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"a\u0012%\u000e\u0003yJ!!\u0013 \u0003\u0007%sG/\u0001\u0004mK\u0006$WM\u001d\t\u0003i1K!!T\u0017\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oi&\u0011!*N\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003iEK!AU\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u0011M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\"\u0001N+\n\u0005Yk#\u0001\u0005$bS2,G\rU1si&$\u0018n\u001c8t\u0003A\u0001\u0018-^:fIB\u000b'\u000f^5uS>t7\u000f\u0005\u000253&\u0011!,\f\u0002\u0011!\u0006,8/\u001a3QCJ$\u0018\u000e^5p]N\f!#\u001a=q_:,g\u000e^5bY\n\u000b7m[8gMB\u0011QlZ\u0007\u0002=*\u0011q\fY\u0001\u0006kRLGn\u001d\u0006\u0003C\n\faaY8n[>t'B\u0001\u0019d\u0015\t!W-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0006\u0019qN]4\n\u0005!t&AE#ya>tWM\u001c;jC2\u0014\u0015mY6pM\u001a\f!B]3qY&\u001c\u0017-T4s!\t!4.\u0003\u0002m[\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007C\u0001\u001bp\u0013\t\u0001XF\u0001\u0007SKBd\u0017nY1Rk>$\u0018-A\u0007m_\u001e\u001cuN\u001c;fqR|\u0005\u000f\u001e\t\u0004\u000fN,\u0018B\u0001;?\u0005\u0019y\u0005\u000f^5p]B\u0011QL^\u0005\u0003oz\u0013!\u0002T8h\u0007>tG/\u001a=u\u0003=)\u0007\u0010\u001e:b\u001b\u0016$(/[2UC\u001e\u001c\b\u0003\u0002>~qaj\u0011a\u001f\u0006\u0003yz\n!bY8mY\u0016\u001cG/[8o\u0013\tq8PA\u0002NCB\fq#\\3uC\u0012\fG/\u0019,feNLwN\\*vaBd\u0017.\u001a:\u0011\u000b\u001d\u000b\u0019!a\u0002\n\u0007\u0005\u0015aHA\u0005Gk:\u001cG/[8oaA!\u0011\u0011BA\b\u001b\t\tYAC\u0002b\u0003\u001bQ!A\f2\n\t\u0005E\u00111\u0002\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u00061A(\u001b8jiz\"\"$a\u0006\u0002\u001a\u0005m\u0011QDA\u0010\u0003C\t\u0019#!\n\u0002(\u0005%\u00121FA\u0017\u0003_\u0001\"\u0001\u000e\u0001\t\u000b]j\u0001\u0019\u0001\u001d\t\u000b\u0015k\u0001\u0019\u0001$\t\u000b)k\u0001\u0019A&\t\u000b=k\u0001\u0019\u0001)\t\u000bMk\u0001\u0019\u0001+\t\u000b]k\u0001\u0019\u0001-\t\u000bmk\u0001\u0019\u0001/\t\u000b%l\u0001\u0019\u00016\t\u000b5l\u0001\u0019\u00018\t\u000fEl\u0001\u0013!a\u0001e\"9\u00010\u0004I\u0001\u0002\u0004I\bBB@\u000e\u0001\u0004\t\t!A\u0005sKBd\u0017nY1JIV\ta)\u0001\u0006sKBd\u0017nY1JI\u0002\n!\u0002\\8h\u0007>tG/\u001a=u+\u0005)\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\na\u0004]1si&$\u0018n\u001c8t/&$\bNT3x\u0011&<\u0007nV1uKJl\u0017M]6\u0016\u0005\u0005\u0005\u0003CBA\"\u0003\u0013\ni%\u0004\u0002\u0002F)\u0019\u0011qI>\u0002\u000f5,H/\u00192mK&!\u00111JA#\u0005\u0019\u0011UO\u001a4feB!\u0011qJA)\u001b\u0005\u0001\u0017bAA*A\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\b9beRLG/[8og^KG\u000f\u001b(fo\"Kw\r[,bi\u0016\u0014X.\u0019:lA\u0005y\u0012n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005m\u0003cA$\u0002^%\u0019\u0011q\f \u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0013n](gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007nU;qa>\u0014H/\u001a3!\u0003e!(/\u00198tSRLwN\u001c+p!V\u001c\bnU;qa>\u0014H/\u001a3\u00025Q\u0014\u0018M\\:ji&|g\u000eV8QkND7+\u001e9q_J$X\r\u001a\u0011\u0002\u00171\fG/Z:u\u000bB|7\r\u001b\u000b\u0005\u0003W\ni\u0007E\u0002Hg\u001aCq!a\u001c\u0019\u0001\u0004\ti%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0002\u001d1|wm\u0015;beR|eMZ:fiR!\u0011QOA>!\r9\u0015qO\u0005\u0004\u0003sr$\u0001\u0002'p]\u001eDq!a\u001c\u001a\u0001\u0004\ti%\u0001\u0007m_\u001e,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002v\u0005\u0005\u0005bBA85\u0001\u0007\u0011QJ\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBAD\u0003\u001f\u000b\t\n\u0005\u0003Hg\u0006%\u0005\u0003BA\u0005\u0003\u0017KA!!$\u0002\f\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBA87\u0001\u0007\u0011Q\n\u0005\u0007\u0003'[\u0002\u0019\u0001$\u0002\u000b\u0015\u0004xn\u00195\u00023\rDWmY6q_&tGOU3d_Z,'/_(gMN,Go\u001d\u000b\u0005\u00033\u000by\nE\u0002H\u00037K1!!(?\u0005\u0011)f.\u001b;\t\u000f\u0005\u0005F\u00041\u0001\u0002$\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0005\u0004\u0002D\u0005\u0015\u0016QJ\u0005\u0005\u0003O\u000b)EA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\u0018\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\tY&A\u0007bo\u0006LGo\u00155vi\u0012|wO\u001c\u000b\u0003\u00033\u000ba\u0001Z8X_J\\\u0017\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0006\u00028\u00065\u0017qZAj\u0003/\u0004BaR:\u0002:B!\u00111XAe\u001b\t\tiL\u0003\u0003\u0002@\u0006\u0005\u0017a\u00017pO*!\u00111YAc\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002H\n\fqa\u001d;pe\u0006<W-\u0003\u0003\u0002L\u0006u&!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002p\u0001\u0002\r!!\u0014\t\u000f\u0005E\u0007\u00051\u0001\u0002v\u0005Ya-\u001a;dQ>3gm]3u\u0011\u0019\t)\u000e\ta\u0001\r\u0006!\u0002/\u0019:uSRLwN\u001c'fC\u0012,'/\u00129pG\"Dq!!7!\u0001\u0004\tY.A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003;\fy.D\u0001\u0001\u0013\r\t\t/\u000e\u0002\n\r\u0016$8\r\u001b#bi\u0006\fAdY8na2,G/\u001a#fY\u0006LX\r\u001a$fi\u000eD'+Z9vKN$8/A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u00033\u000bI/!?\t\u000f\u0005-(\u00051\u0001\u0002n\u00069!/Z2pe\u0012\u001c\b\u0003BAx\u0003kl!!!=\u000b\u0007\u0005M\b-\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003o\f\tPA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003_\u0012\u0003\u0019AA'\u0003!!(/\u001e8dCR,GCBA.\u0003\u007f\u0014\u0019\u0001C\u0004\u0003\u0002\r\u0002\r!!\u0014\u0002\u0005Q\u0004\bb\u0002B\u0003G\u0001\u0007!qA\u0001\u0016_\u001a47/\u001a;UeVt7-\u0019;j_:\u001cF/\u0019;f!\r!$\u0011B\u0005\u0004\u0005\u0017i#!F(gMN,G\u000f\u0016:v]\u000e\fG/[8o'R\fG/Z\u0001\rI>$&/\u001e8dCRLwN\u001c\u000b\t\u00037\u0012\tBa\u0005\u0003\u0016!9!\u0011\u0001\u0013A\u0002\u00055\u0003b\u0002B\u0003I\u0001\u0007!q\u0001\u0005\b\u0005/!\u0003\u0019AA.\u0003!I7/T5se>\u0014\u0018a\u0006;sk:\u001c\u0017\r^3Gk2d\u00170\u00118e'R\f'\u000f^!u)\u0019\tIJ!\b\u0003 !9\u0011qN\u0013A\u0002\u00055\u0003b\u0002B\u0011K\u0001\u0007\u0011QO\u0001\u0007_\u001a47/\u001a;\u0002\u0019M,\b/\u001a:%Y\u0016\fG-\u001a:\u0016\u0003-\u000bACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$\u0007C\u0001\u001b)'\rA#Q\u0006\t\u0004\u000f\n=\u0012b\u0001B\u0019}\t1\u0011I\\=SK\u001a$\"A!\u000b\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132aU\u0011!\u0011\b\u0016\u0004e\nm2F\u0001B\u001f!\u0011\u0011yD!\u0013\u000e\u0005\t\u0005#\u0002\u0002B\"\u0005\u000b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001dc(\u0001\u0006b]:|G/\u0019;j_:LAAa\u0013\u0003B\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132cU\u0011!\u0011\u000b\u0016\u0004s\nm\u0002")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final int replicaId;
    private final LogContext logContext;
    private final Buffer<TopicPartition> partitionsWithNewHighWatermark;
    private final boolean isOffsetForLeaderEpochSupported;
    private final boolean transitionToPushSupported;

    public static Map<String, String> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public static Option<LogContext> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ LeaderEndPoint super$leader() {
        return super.leader();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    public Buffer<TopicPartition> partitionsWithNewHighWatermark() {
        return this.partitionsWithNewHighWatermark;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean transitionToPushSupported() {
        return this.transitionToPushSupported;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public void checkpointRecoveryOffsets(ArrayBuffer<TopicPartition> topicPartitions) {
        if (topicPartitions.isEmpty()) {
            return;
        }
        ArrayBuffer affectedLogs = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$1(this, affectedLogs, tp);
            return BoxedUnit.UNIT;
        });
        ((ResizableArray)((SeqLike)affectedLogs.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.parentDirFile(), ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            ReplicaFetcherThread.$anonfun$checkpointRecoveryOffsets$4(this, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean initiateShutdown() {
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                super.leader().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.super$leader()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
        return justShutdown;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            super.leader().close();
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.super$leader()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            return;
        }
    }

    @Override
    public void doWork() {
        super.doWork();
        this.completeDelayedFetchRequests();
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, int partitionLeaderEpoch, FetchResponseData.PartitionData partitionData) {
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        Option<LogAppendInfo> logAppendInfo = this.replicaMgr.appendRecordsToFollowerReplica(topicPartition, fetchOffset, AppendOrigin.REPLICATION, -1L, Optional.of(Predef$.MODULE$.int2Integer(partitionLeaderEpoch)), records, partitionData.highWatermark(), Optional.of(BoxesRunTime.boxToLong((long)partitionData.logStartOffset())), this.quota);
        if (logAppendInfo.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaFetcherThread.$anonfun$processPartitionData$1(x$2)))) {
            this.partitionsWithNewHighWatermark().$plus$eq((Object)topicPartition);
        }
        if (records.sizeInBytes() > 0) {
            this.brokerTopicStats().topicStats(topicPartition.topic()).totalFollowerFetchRequestRate().mark();
            this.brokerTopicStats().allTopicsStats().totalFollowerFetchRequestRate().mark();
        }
        return logAppendInfo;
    }

    public void completeDelayedFetchRequests() {
        if (this.partitionsWithNewHighWatermark().nonEmpty()) {
            this.replicaMgr.completeDelayedFetchRequests((Seq<TopicPartition>)this.partitionsWithNewHighWatermark().toSeq());
            this.partitionsWithNewHighWatermark().clear();
            return;
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (((MetadataVersion)this.metadataVersionSupplier.apply()).fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(412).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
            return;
        }
    }

    @Override
    public boolean truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        return this.doTruncation(tp, offsetTruncationState, false);
    }

    public boolean doTruncation(TopicPartition tp, OffsetTruncationState offsetTruncationState, boolean isMirror) {
        Partition partition = this.replicaMgr.getPartitionOrException(tp);
        AbstractLog log = partition.localLogOrException();
        if (offsetTruncationState.offset() < log.highWatermark()) {
            if (!partition.isUncleanLeader()) {
                if (partition.isActiveLinkDestinationLeader()) {
                    this.replicaMgr.clusterLinkTruncationBelowHWM().mark();
                } else {
                    this.replicaMgr.truncationBelowHWM().mark();
                }
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").append(log.highWatermark()).toString());
        }
        if (isMirror) {
            partition.truncateMirrorTo(offsetTruncationState.offset(), false, false, true);
        } else {
            partition.truncateTo(offsetTruncationState.offset(), false, false);
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, false, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$1(ReplicaFetcherThread $this, ArrayBuffer affectedLogs$1, TopicPartition tp) {
        Option<AbstractLog> log = $this.replicaMgr.getLog(tp);
        if (log != null) {
            log.foreach((Function1 & Serializable & scala.Serializable)l -> affectedLogs$1.$plus$eq(l));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$checkpointRecoveryOffsets$4(ReplicaFetcherThread $this, File dir) {
        $this.replicaMgr.logManager().checkpointRecoveryOffsetsInDir(dir);
    }

    public static final /* synthetic */ boolean $anonfun$processPartitionData$1(LogAppendInfo x$2) {
        LeaderHwChange leaderHwChange = x$2.leaderHwChange();
        LeaderHwChange leaderHwChange2 = LeaderHwChange.INCREASED;
        return !(leaderHwChange != null ? !leaderHwChange.equals(leaderHwChange2) : leaderHwChange2 != null);
    }

    public ReplicaFetcherThread(String name, int fetcherId, LeaderEndPoint leader, KafkaConfig brokerConfig, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicaQuota quota, Option<LogContext> logContextOpt, Map<String, String> extraMetricTags, Function0<MetadataVersion> metadataVersionSupplier) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, new ConfluentReplicaFetcherTierStateMachine(leader, replicaMgr, exponentialBackoff), false, replicaMgr.brokerTopicStats(), extraMetricTags);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = (LogContext)logContextOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> new LogContext(new StringBuilder(51).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(this.super$leader().brokerEndPoint().id()).append(", fetcherId=").append($this.fetcherId).append("] ").toString()));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.partitionsWithNewHighWatermark = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.isOffsetForLeaderEpochSupported = ((MetadataVersion)metadataVersionSupplier.apply()).isOffsetForLeaderEpochSupported();
        this.transitionToPushSupported = true;
    }
}

