/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.Constants$;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.QuotaType;
import kafka.server.QuotaType$ClusterLinkReplication$;
import kafka.server.QuotaType$FollowerReplication$;
import kafka.server.ReplicaQuota;
import kafka.server.SensorAccess;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.config.ReplicationQuotaManagerConfig;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005]h\u0001B\u0014)\u00015B\u0001\"\u0011\u0001\u0003\u0006\u0004%\tA\u0011\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u0007\"Aq\n\u0001BC\u0002\u0013%\u0001\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003R\u0011%I\u0006A!b\u0001\n#A#\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003\\\u0011!y\u0006A!b\u0001\n\u0013\u0001\u0007\u0002\u00034\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u000b\u001d\u0004A\u0011\u00015\t\u000f9\u0004!\u0019!C\u0005_\"1A\u0010\u0001Q\u0001\nADq! \u0001C\u0002\u0013%a\u0010C\u0004\u00020\u0001\u0001\u000b\u0011B@\t\u0017\u0005E\u0002\u00011AA\u0002\u0013%\u00111\u0007\u0005\f\u0003w\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0004C\u0006\u0002J\u0001\u0001\r\u0011!Q!\n\u0005U\u0002\"CA&\u0001\t\u0007I\u0011BA'\u0011!\tY\u0006\u0001Q\u0001\n\u0005=\u0003\"CA/\u0001\t\u0007I\u0011BA0\u0011!\t9\u0007\u0001Q\u0001\n\u0005\u0005\u0004BCA5\u0001\t\u0007I\u0011\u0001\u0016\u0002l!A\u0011Q\u000f\u0001!\u0002\u0013\ti\u0007C\u0004\u0002x\u0001!\t!!\u001f\t\u000f\u0005u\u0004\u0001\"\u0003\u0002\u0000!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u00037\u0003A\u0011AAO\u0011\u001d\tI\u000b\u0001C\u0001\u0003WCq!!.\u0001\t\u0003\t9\fC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005}\u0006\u0001\"\u0001\u0002B\"9\u0011q\u0019\u0001\u0005\u0002\u0005%\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!!;\u0001\t\u0003\n9\fC\u0004\u0002l\u0002!I!!\"\t\u000f\u00055\b\u0001\"\u0001\u0002p\n9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0006\u0003S)\naa]3sm\u0016\u0014(\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001M)\u0001A\f\u001b;}A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0005e2$a\u0002'pO\u001eLgn\u001a\t\u0003wqj\u0011\u0001K\u0005\u0003{!\u0012ABU3qY&\u001c\u0017-U;pi\u0006\u0004\"aO \n\u0005\u0001C#A\b#jg.,6/Y4f\u0005\u0006\u001cX\r\u001a+ie>$H\u000f\\3MSN$XM\\3s\u0003\u0019\u0019wN\u001c4jOV\t1\t\u0005\u0002E\u00196\tQI\u0003\u0002B\r*\u0011\u0011f\u0012\u0006\u0003W!S!!\u0013&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0015aA8sO&\u0011Q*\u0012\u0002\u001e%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013aB7fiJL7m]\u000b\u0002#B\u0011!KV\u0007\u0002'*\u0011q\n\u0016\u0006\u0003+\u001e\u000baaY8n[>t\u0017BA,T\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\ncV|G/\u0019+za\u0016,\u0012a\u0017\t\u0003wqK!!\u0018\u0015\u0003\u0013E+x\u000e^1UsB,\u0017AC9v_R\fG+\u001f9fA\u0005!A/[7f+\u0005\t\u0007C\u00012e\u001b\u0005\u0019'BA\u001cU\u0013\t)7M\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013A\u0002\u001fj]&$h\bF\u0003jU.dW\u000e\u0005\u0002<\u0001!)\u0011)\u0003a\u0001\u0007\")q*\u0003a\u0001#\")\u0011,\u0003a\u00017\")q,\u0003a\u0001C\u0006!An\\2l+\u0005\u0001\bCA9{\u001b\u0005\u0011(BA:u\u0003\u0015awnY6t\u0015\t)h/\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u001e=\u0002\tU$\u0018\u000e\u001c\u0006\u0002s\u0006!!.\u0019<b\u0013\tY(O\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003\u0015awnY6!\u0003M!\bN]8ui2,G\rU1si&$\u0018n\u001c8t+\u0005y\b\u0003CA\u0001\u0003\u0007\t9!!\b\u000e\u0003QL1!!\u0002u\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u0013\t9B\u0004\u0003\u0002\f\u0005M\u0001cAA\u0007a5\u0011\u0011q\u0002\u0006\u0004\u0003#a\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u0016A\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000baA1\u0011qDA\u0013\u0003Si!!!\t\u000b\u0007\u0005\r\u0002'\u0001\u0006d_2dWm\u0019;j_:LA!a\n\u0002\"\t\u00191+Z9\u0011\u0007=\nY#C\u0002\u0002.A\u00121!\u00138u\u0003Q!\bN]8ui2,G\rU1si&$\u0018n\u001c8tA\u0005)\u0011/^8uCV\u0011\u0011Q\u0007\t\u0004%\u0006]\u0012bAA\u001d'\n)\u0011+^8uC\u0006I\u0011/^8uC~#S-\u001d\u000b\u0005\u0003\u007f\t)\u0005E\u00020\u0003\u0003J1!a\u00111\u0005\u0011)f.\u001b;\t\u0013\u0005\u001ds\"!AA\u0002\u0005U\u0012a\u0001=%c\u00051\u0011/^8uC\u0002\nA#\u00197m%\u0016\u0004H.[2bgRC'o\u001c;uY\u0016$WCAA(!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA+i\u00061\u0011\r^8nS\u000eLA!!\u0017\u0002T\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fQ#\u00197m%\u0016\u0004H.[2bgRC'o\u001c;uY\u0016$\u0007%\u0001\u0007tK:\u001cxN]!dG\u0016\u001c8/\u0006\u0002\u0002bA\u00191(a\u0019\n\u0007\u0005\u0015\u0004F\u0001\u0007TK:\u001cxN]!dG\u0016\u001c8/A\u0007tK:\u001cxN]!dG\u0016\u001c8\u000fI\u0001\u000fe\u0006$X-T3ue&\u001cg*Y7f+\t\ti\u0007\u0005\u0003\u0002p\u0005ET\"\u0001+\n\u0007\u0005MDK\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\fqB]1uK6+GO]5d\u001d\u0006lW\rI\u0001\fkB$\u0017\r^3Rk>$\u0018\r\u0006\u0003\u0002@\u0005m\u0004bBA\u0019/\u0001\u0007\u0011QG\u0001\u000eI>,\u0006\u000fZ1uKF+x\u000e^1\u0015\t\u0005}\u0012\u0011\u0011\u0005\b\u0003cA\u0002\u0019AA\u001b\u0003=I7/U;pi\u0006,\u0005pY3fI\u0016$WCAAD!\ry\u0013\u0011R\u0005\u0004\u0003\u0017\u0003$a\u0002\"p_2,\u0017M\\\u0001\fSN$\u0006N]8ui2,G\r\u0006\u0003\u0002\b\u0006E\u0005bBAJ5\u0001\u0007\u0011QS\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\ty'a&\n\u0007\u0005eEK\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\rI,7m\u001c:e)\u0011\ty$a(\t\u000f\u0005\u00056\u00041\u0001\u0002$\u0006)a/\u00197vKB\u0019q&!*\n\u0007\u0005\u001d\u0006G\u0001\u0003M_:<\u0017!D7be.$\u0006N]8ui2,G\r\u0006\u0004\u0002@\u00055\u0016\u0011\u0017\u0005\b\u0003_c\u0002\u0019AA\u0004\u0003\u0015!x\u000e]5d\u0011\u001d\t\u0019\f\ba\u0001\u0003;\t!\u0002]1si&$\u0018n\u001c8t\u0003Mi\u0017M]6Ce>\\WM\u001d+ie>$H\u000f\\3e)\t\ty$\u0001\bsK6|g/\u001a+ie>$H\u000f\\3\u0015\t\u0005}\u0012Q\u0018\u0005\b\u0003_s\u0002\u0019AA\u0004\u0003Q\u0011X-\\8wK\n\u0013xn[3s)\"\u0014x\u000e\u001e;mKR!\u0011qHAb\u0011\u001d\t)m\ba\u0001\u0003\u000f\u000bQB]3tKR$\u0006N]8ui2,\u0017AC;qa\u0016\u0014(i\\;oIV\u0011\u00111U\u0001\u0015O\u0016$\u0018+^8uC6+GO]5d\u0007>tg-[4\u0015\t\u0005=\u0017Q\u001b\t\u0004%\u0006E\u0017bAAj'\naQ*\u001a;sS\u000e\u001cuN\u001c4jO\"9\u0011\u0011G\u0011A\u0002\u0005U\u0012AB:f]N|'\u000f\u0006\u0002\u0002\\B\u0019!+!8\n\u0007\u0005}7K\u0001\u0004TK:\u001cxN]\u0001\u0013Q\u0006tG\r\\3ESN\\7\u000b]1dK2{w\u000f\u0006\u0003\u0002@\u0005\u0015\bbBAtG\u0001\u0007\u00111U\u0001\u0019G\u0006\u0004\b/\u001a3Rk>$\u0018-\u00138CsR,7\u000fU3s'\u0016\u001c\u0017\u0001\u00075b]\u0012dW\rR5tWN\u0003\u0018mY3SK\u000e|g/\u001a:fI\u0006\t\u0002.Y:ESN\\G\u000b\u001b:piRd\u0017N\\4\u0002'\u001d,GO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;\u0016\u0005\u0005E\bcA\u0018\u0002t&\u0019\u0011Q\u001f\u0019\u0003\r\u0011{WO\u00197f\u0001")
public class ReplicationQuotaManager
implements Logging,
ReplicaQuota,
DiskUsageBasedThrottleListener {
    private final ReplicationQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType quotaType;
    private final Time time;
    private final ReentrantReadWriteLock lock;
    private final ConcurrentHashMap<String, Seq<Object>> throttledPartitions;
    private Quota quota;
    private final AtomicBoolean allReplicasThrottled;
    private final SensorAccess sensorAccess;
    private final MetricName rateMetricName;
    private final AtomicReference<Option<Object>> lastSignalledQuotaOptRef;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public void markReplicaThrottle() {
        ReplicaQuota.markReplicaThrottle$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
        return this.lastSignalledQuotaOptRef;
    }

    @Override
    public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
        this.lastSignalledQuotaOptRef = x$1;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ReplicationQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public QuotaType quotaType() {
        return this.quotaType;
    }

    private Time time() {
        return this.time;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private ConcurrentHashMap<String, Seq<Object>> throttledPartitions() {
        return this.throttledPartitions;
    }

    private Quota quota() {
        return this.quota;
    }

    private void quota_$eq(Quota x$1) {
        this.quota = x$1;
    }

    private AtomicBoolean allReplicasThrottled() {
        return this.allReplicasThrottled;
    }

    private SensorAccess sensorAccess() {
        return this.sensorAccess;
    }

    public MetricName rateMetricName() {
        return this.rateMetricName;
    }

    public void updateQuota(Quota quota) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("updateQuota requested for ").append(this.quotaType()).append(" from ").append(this.quota()).append(" to ").append(quota).toString());
        if (this.hasDiskThrottling() && this.lastSignalledQuotaOptRef().get().isDefined()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can't update replication throttle since disk throttling is currently active!");
            return;
        }
        this.doUpdateQuota(quota);
    }

    private void doUpdateQuota(Quota quota) {
        CoreUtils$.MODULE$.inWriteLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.quota_$eq(quota);
            KafkaMetric metric = (KafkaMetric)this.metrics().metrics().get(this.rateMetricName());
            if (metric != null) {
                metric.config(this.getQuotaMetricConfig(quota));
                return;
            }
        });
    }

    @Override
    public boolean isQuotaExceeded() {
        try {
            this.sensor().checkQuotas();
        }
        catch (QuotaViolationException qve) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append(this.quotaType()).append(": Quota violated for sensor (").append(this.sensor().name()).append("), metric: (").append(qve.metric().metricName()).append("), ").append("metric-value: (").append(qve.value()).append("), bound: (").append(qve.bound()).append(")").toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        Seq<Object> partitions = this.throttledPartitions().get(topicPartition.topic());
        if (partitions == null || partitions.isEmpty()) {
            return this.allReplicasThrottled().get();
        }
        return partitions == Constants$.MODULE$.AllReplicas() || partitions.contains((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()));
    }

    @Override
    public void record(long value) {
        this.sensor().record((double)value, this.time().milliseconds(), false);
    }

    public void markThrottled(String topic, Seq<Object> partitions) {
        this.throttledPartitions().put(topic, partitions);
    }

    public void markBrokerThrottled() {
        this.allReplicasThrottled().set(true);
    }

    public void removeThrottle(String topic) {
        this.throttledPartitions().remove(topic);
    }

    public void removeBrokerThrottle(boolean resetThrottle) {
        boolean throttleEnabled = resetThrottle ? this.config().allReplicasThrottled : false;
        this.allReplicasThrottled().set(throttleEnabled);
    }

    public long upperBound() {
        return BoxesRunTime.unboxToLong(CoreUtils$.MODULE$.inReadLock(this.lock(), (JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            if (this.quota() != null) {
                return (long)this.quota().bound();
            }
            return Long.MAX_VALUE;
        }));
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds, TimeUnit.SECONDS).samples(this.config().numQuotaSamples).quota(quota);
    }

    private Sensor sensor() {
        return this.sensorAccess().getOrCreate(this.quotaType().toString(), 3600L, (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(this.rateMetricName(), (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota()));
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
        if (this.hasDiskThrottling()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Updating {} quota (due to low disk) to: {}", new Object[]{this.quotaType(), BoxesRunTime.boxToLong((long)cappedQuotaInBytesPerSec)});
            }
            this.doUpdateQuota(Quota.upperBound((double)cappedQuotaInBytesPerSec));
            this.markBrokerThrottled();
            return;
        }
    }

    @Override
    public void handleDiskSpaceRecovered() {
        if (this.hasDiskThrottling()) {
            long resetQuota = this.config().quotaBytesPerSecondDefault;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Resetting {} quota (due to low disk) to: {}", new Object[]{this.quotaType(), BoxesRunTime.boxToLong((long)resetQuota)});
            }
            this.doUpdateQuota(Quota.upperBound((double)resetQuota));
            this.removeBrokerThrottle(true);
            return;
        }
    }

    private boolean hasDiskThrottling() {
        block3: {
            block2: {
                QuotaType quotaType = this.quotaType();
                QuotaType$FollowerReplication$ quotaType$FollowerReplication$ = QuotaType$FollowerReplication$.MODULE$;
                if (!(quotaType == null ? quotaType$FollowerReplication$ != null : !quotaType.equals(quotaType$FollowerReplication$))) break block2;
                QuotaType quotaType2 = this.quotaType();
                QuotaType$ClusterLinkReplication$ quotaType$ClusterLinkReplication$ = QuotaType$ClusterLinkReplication$.MODULE$;
                if (quotaType2 != null ? !quotaType2.equals(quotaType$ClusterLinkReplication$) : quotaType$ClusterLinkReplication$ != null) break block3;
            }
            return true;
        }
        return false;
    }

    public double getBrokerQuotaLimit() {
        return this.quota().bound();
    }

    public ReplicationQuotaManager(ReplicationQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.time = time;
        Logging.$init$(this);
        ReplicaQuota.$init$(this);
        DiskUsageBasedThrottleListener.$init$(this);
        this.lock = new ReentrantReadWriteLock();
        this.throttledPartitions = new ConcurrentHashMap();
        this.allReplicasThrottled = new AtomicBoolean(config.allReplicasThrottled);
        this.sensorAccess = new SensorAccess(this.lock(), metrics);
        this.rateMetricName = metrics.metricName("byte-rate", quotaType.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(quotaType).toString());
        this.updateQuota(Quota.upperBound((double)config.quotaBytesPerSecondDefault));
    }
}

