/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.google.common.base.Throwables;
import com.typesafe.scalalogging.Logger;
import io.confluent.flink.apiserver.client.ApiException;
import io.confluent.flink.apiserver.client.model.CoreV1Environment;
import io.confluent.flink.apiserver.client.model.CoreV1OrgList;
import java.io.EOFException;
import java.io.Serializable;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionSpec;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.RegionalLkcMetadata;
import kafka.server.RegionalMetadataClient$;
import kafka.server.RegionalNetworkMetadata;
import kafka.server.RmClientCommandOptions;
import kafka.server.RmRegionalMetadataClient;
import kafka.server.Subscription;
import kafka.server.Subscription$SubscriptionFactory$;
import kafka.server.Watch;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class RmRegionalMetadataClient$
implements Logging {
    public static RmRegionalMetadataClient$ MODULE$;
    private final int kafka$server$RmRegionalMetadataClient$$maxRetries;
    private final Function1<Throwable, Object> retryOnConnectionError;
    private final Set<String> mtSkuSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new RmRegionalMetadataClient$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int kafka$server$RmRegionalMetadataClient$$maxRetries() {
        return this.kafka$server$RmRegionalMetadataClient$$maxRetries;
    }

    public Function1<Throwable, Object> retryOnConnectionError() {
        return this.retryOnConnectionError;
    }

    public Set<String> mtSkuSet() {
        return this.mtSkuSet;
    }

    private boolean isConnectionException(ApiException e) {
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        return rootCause instanceof SocketException || rootCause instanceof SocketTimeoutException || rootCause instanceof EOFException;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args);
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(33).append("Error while executing RM client: ").append(e.getMessage()).toString());
                e.printStackTrace();
                exitCode = 1;
            }
        }
        finally {
            Exit.exit((int)exitCode);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args) {
        RmClientCommandOptions opts = new RmClientCommandOptions(args);
        opts.checkArgs();
        Properties properties = Utils.loadProps((String)((String)opts.options.valueOf(opts.brokerConfigOpt())));
        KafkaConfig brokerConfig = KafkaConfig$.MODULE$.fromProps(properties);
        try (RmRegionalMetadataClient rmRegionalMetadataClient = new RmRegionalMetadataClient(brokerConfig);){
            try {
                System.out.println("Configuring RM Regional Metadata Client");
                rmRegionalMetadataClient.configure(brokerConfig.values());
                System.out.println("Configured RM Regional Metadata Client");
                if (opts.options.has((OptionSpec)opts.watchOpt())) {
                    void newSimpleWatch_endOfSnapshotHandler;
                    System.out.println("Configuring Watch");
                    Subscription<CoreV1Environment> subscription = Subscription$SubscriptionFactory$.MODULE$.newEnvSubscriptionBuilder(true).build();
                    Function1 & Serializable & scala.Serializable errorHandler = (Function1 & Serializable & scala.Serializable)e -> {
                        throw e;
                    };
                    Function1 & Serializable & scala.Serializable changeHandler = (Function1 & Serializable & scala.Serializable)env -> {
                        System.out.println(env);
                        return BoxedUnit.UNIT;
                    };
                    CountDownLatch snapshotEnd = new CountDownLatch(1);
                    JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        System.out.println("End of snapshot");
                        snapshotEnd.countDown();
                    };
                    if (RegionalMetadataClient$.MODULE$ == null) {
                        throw null;
                    }
                    Watch envWatch = new Watch<T>(changeHandler, errorHandler, (Function0)newSimpleWatch_endOfSnapshotHandler){
                        private final Function1 changeHandler$1;
                        private final Function1 errorHandler$1;
                        private final Function0 endOfSnapshotHandler$1;

                        public void onCreated(T obj) {
                            this.changeHandler$1.apply(obj);
                        }

                        public void onUpdated(T obj) {
                            this.changeHandler$1.apply(obj);
                        }

                        public void onDeleted(T obj) {
                            this.changeHandler$1.apply(obj);
                        }

                        public void onError(Throwable throwable) {
                            this.errorHandler$1.apply((Object)throwable);
                        }

                        public void onEndOfSnapshot() {
                            this.endOfSnapshotHandler$1.apply$mcV$sp();
                        }
                        {
                            this.changeHandler$1 = changeHandler$1;
                            this.errorHandler$1 = errorHandler$1;
                            this.endOfSnapshotHandler$1 = endOfSnapshotHandler$1;
                        }
                    };
                    AutoCloseable watch = rmRegionalMetadataClient.watch(subscription, envWatch);
                    System.out.println("Watch configured, sleeping for 30 seconds");
                    snapshotEnd.await(30L, TimeUnit.SECONDS);
                    watch.close();
                } else if (opts.options.has((OptionSpec)opts.lkcOpt())) {
                    System.out.println(new StringBuilder(40).append("Getting LKC metadata for orgId: ").append(opts.options.valueOf(opts.orgIdOpt())).append(" lkcId: ").append(opts.options.valueOf(opts.lkcIdOpt())).toString());
                    CompletableFuture<Option<RegionalLkcMetadata>> lkc = rmRegionalMetadataClient.getLkcMetadata((String)opts.options.valueOf(opts.orgIdOpt()), (String)opts.options.valueOf(opts.lkcIdOpt()));
                    if (lkc.get().isDefined()) {
                        RegionalLkcMetadata value = (RegionalLkcMetadata)lkc.get().get();
                        System.out.println(new StringBuilder(10).append("LKC found=").append(value).toString());
                    } else {
                        System.out.println("No LKC found");
                    }
                } else if (opts.options.has((OptionSpec)opts.networkOpt())) {
                    System.out.println(new StringBuilder(56).append("Getting Network metadata for orgId: ").append(opts.options.valueOf(opts.orgIdOpt())).append(" envId: ").append(opts.options.valueOf(opts.envIdOpt())).append(" networkId: ").append(opts.options.valueOf(opts.networkIdOpt())).toString());
                    CompletableFuture<Option<RegionalNetworkMetadata>> network = rmRegionalMetadataClient.getNetworkMetadata((String)opts.options.valueOf(opts.orgIdOpt()), (String)opts.options.valueOf(opts.envIdOpt()), (String)opts.options.valueOf(opts.networkIdOpt()));
                    if (network.get().isDefined()) {
                        RegionalNetworkMetadata value = (RegionalNetworkMetadata)network.get().get();
                        System.out.println(new StringBuilder(14).append("Network found=").append(value).toString());
                    } else {
                        System.out.println("No Network found");
                    }
                } else {
                    CoreV1OrgList orgList = rmRegionalMetadataClient.coreApi().listCoreV1Orgs(null, null, null, null, null);
                    System.out.println(orgList.getItems());
                }
            }
            catch (Throwable e2) {
                Predef$.MODULE$.println((Object)"Error while issuing request");
                throw e2;
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$retryOnConnectionError$1(Throwable e) {
        return e instanceof ApiException && MODULE$.isConnectionException((ApiException)e);
    }

    private RmRegionalMetadataClient$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.kafka$server$RmRegionalMetadataClient$$maxRetries = 5;
        this.retryOnConnectionError = (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)RmRegionalMetadataClient$.$anonfun$retryOnConnectionError$1(e));
        this.mtSkuSet = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ENTERPRISE", "BASIC", "STANDARD"}));
    }
}

