/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kafka.metrics.LinuxCpuMetricsCollector;
import kafka.metrics.LinuxCpuMetricsCollector$;
import kafka.metrics.LinuxDiskMetricsCollector;
import kafka.metrics.LinuxFileMetricsCollector;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.Cell;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.metrics.LinuxIoMetricsCollector;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.math.Ordering;

public final class Server$ {
    public static Server$ MODULE$;
    private final String MetricsPrefix;
    private final String ClusterIdLabel;
    private final String BrokerIdLabel;
    private final String NodeIdLabel;
    private final String CellIdLabel;
    private final String ProcessRoleLabel;

    static {
        new Server$();
    }

    public String MetricsPrefix() {
        return this.MetricsPrefix;
    }

    public String ClusterIdLabel() {
        return this.ClusterIdLabel;
    }

    public String BrokerIdLabel() {
        return this.BrokerIdLabel;
    }

    public String NodeIdLabel() {
        return this.NodeIdLabel;
    }

    public String CellIdLabel() {
        return this.CellIdLabel;
    }

    public String ProcessRoleLabel() {
        return this.ProcessRoleLabel;
    }

    public Metrics initializeMetrics(KafkaConfig config, Time time, String clusterId) {
        KafkaMetricsContext metricsContext = this.createKafkaMetricsContext(config, clusterId);
        return this.buildMetrics(config, time, metricsContext);
    }

    public Tuple3<LinuxIoMetricsCollector, LinuxCpuMetricsCollector, Option<LinuxDiskMetricsCollector>> maybeRegisterLinuxMetrics(KafkaConfig config, Time time, Logger logger) {
        None$ none$;
        LinuxIoMetricsCollector linuxIoMetricsCollector = new LinuxIoMetricsCollector("/proc", time);
        linuxIoMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        new LinuxFileMetricsCollector("/proc", logger).maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        LinuxCpuMetricsCollector linuxCPUMetricsCollector = new LinuxCpuMetricsCollector("/proc", time, logger, LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$4(), LinuxCpuMetricsCollector$.MODULE$.$lessinit$greater$default$5());
        linuxCPUMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
        if (Predef$.MODULE$.Boolean2boolean(config.confluentConfig().confluentInternalMetricsEnable())) {
            LinuxDiskMetricsCollector linuxDiskMetricsCollector = new LinuxDiskMetricsCollector(config, "/proc", time, logger);
            linuxDiskMetricsCollector.maybeRegisterMetrics(KafkaYammerMetrics.defaultRegistry());
            none$ = new Some((Object)linuxDiskMetricsCollector);
        } else {
            none$ = None$.MODULE$;
        }
        None$ linuxDiskMetricsCollectorOpt = none$;
        return new Tuple3((Object)linuxIoMetricsCollector, (Object)linuxCPUMetricsCollector, (Object)linuxDiskMetricsCollectorOpt);
    }

    private Metrics buildMetrics(KafkaConfig config, Time time, KafkaMetricsContext metricsContext) {
        MetricConfig metricConfig = this.buildMetricsConfig(config);
        return new Metrics(metricConfig, new ArrayList(), time, true, (MetricsContext)metricsContext);
    }

    public MetricConfig buildMetricsConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public KafkaMetricsContext createKafkaMetricsContext(KafkaConfig config, String clusterId) {
        HashMap<String, Object> contextLabels = new HashMap<String, Object>();
        contextLabels.put(this.ClusterIdLabel(), clusterId);
        if (config.usesSelfManagedQuorum()) {
            contextLabels.put(this.NodeIdLabel(), Integer.toString(config.nodeId()));
        } else {
            contextLabels.put(this.BrokerIdLabel(), Integer.toString(config.brokerId()));
        }
        if (config.cellsImplicitCreation()) {
            contextLabels.put(this.CellIdLabel(), Integer.toString(Cell.getImplicitBrokerCellId((int)config.brokerId(), (int)config.cellDefaultSize())));
        }
        contextLabels.putAll(config.originalsWithPrefix("metrics.context."));
        contextLabels.put("resource.type", "kafka");
        contextLabels.put("resource.version", AppInfoParser.getVersion());
        contextLabels.put("resource.commit.id", AppInfoParser.getCommitId());
        if (config.processRoles().nonEmpty()) {
            String roles = ((TraversableOnce)((SetLike)config.processRoles().map((Function1 & Serializable & scala.Serializable)role -> role.toString(), Set$.MODULE$.canBuildFrom())).toSeq().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
            contextLabels.put(this.ProcessRoleLabel(), roles);
        }
        return new KafkaMetricsContext(this.MetricsPrefix(), contextLabels);
    }

    private Server$() {
        MODULE$ = this;
        this.MetricsPrefix = "kafka.server";
        this.ClusterIdLabel = "kafka.cluster.id";
        this.BrokerIdLabel = "kafka.broker.id";
        this.NodeIdLabel = "kafka.node.id";
        this.CellIdLabel = "kafka.cell.id";
        this.ProcessRoleLabel = "kafka.process.roles";
    }
}

