/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.builders;

import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.availability.BrokerHealthManager;
import kafka.log.LogManager;
import kafka.log.remote.RemoteLogManager;
import kafka.server.ActionQueue;
import kafka.server.AddPartitionsToTxnManager;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedDeleteRecords;
import kafka.server.DelayedElectLeader;
import kafka.server.DelayedFetch;
import kafka.server.DelayedListOffsets;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedProduce;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents;
import kafka.server.link.ClusterLinkFactory;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.server.common.DirectoryEventHandler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import scala.Function0;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class ReplicaManagerBuilder {
    private KafkaConfig config = null;
    private Metrics metrics = null;
    private Time time = Time.SYSTEM;
    private Scheduler scheduler = null;
    private LogManager logManager = null;
    private QuotaFactory.QuotaManagers quotaManagers = null;
    private MetadataCache metadataCache = null;
    private LogDirFailureChannel logDirFailureChannel = null;
    private AlterPartitionManager alterPartitionManager = null;
    private ActionQueue actionQueue = null;
    private Supplier<BrokerState> brokerState = null;
    private BrokerTopicStats brokerTopicStats = null;
    private AtomicBoolean isShuttingDown = new AtomicBoolean(false);
    private Optional<RemoteLogManager> remoteLogManager = Optional.empty();
    private Optional<KafkaZkClient> zkClient = Optional.empty();
    private Optional<DelayedOperationPurgatory<DelayedProduce>> delayedProducePurgatory = Optional.empty();
    private Optional<DelayedOperationPurgatory<DelayedFetch>> delayedFetchPurgatory = Optional.empty();
    private Optional<DelayedOperationPurgatory<DelayedDeleteRecords>> delayedDeleteRecordsPurgatory = Optional.empty();
    private Optional<DelayedOperationPurgatory<DelayedElectLeader>> delayedElectLeaderPurgatory = Optional.empty();
    private Optional<DelayedOperationPurgatory<DelayedListOffsets>> delayedListOffsetsPurgatory = Optional.empty();
    private TierReplicaComponents tierReplicaComponents = TierReplicaComponents.EMPTY();
    private Optional<ClusterLinkFactory.LinkManager> clusterLinkManager = Optional.empty();
    private Optional<String> threadNamePrefix = Optional.empty();
    private Long brokerEpoch = -1L;
    private Optional<AddPartitionsToTxnManager> addPartitionsToTxnManager = Optional.empty();
    private DirectoryEventHandler directoryEventHandler = DirectoryEventHandler.NOOP;

    public ReplicaManagerBuilder setConfig(KafkaConfig config) {
        this.config = config;
        return this;
    }

    public ReplicaManagerBuilder setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ReplicaManagerBuilder setTime(Time time) {
        this.time = time;
        return this;
    }

    public ReplicaManagerBuilder setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public ReplicaManagerBuilder setLogManager(LogManager logManager) {
        this.logManager = logManager;
        return this;
    }

    public ReplicaManagerBuilder setQuotaManagers(QuotaFactory.QuotaManagers quotaManagers) {
        this.quotaManagers = quotaManagers;
        return this;
    }

    public ReplicaManagerBuilder setMetadataCache(MetadataCache metadataCache) {
        this.metadataCache = metadataCache;
        return this;
    }

    public ReplicaManagerBuilder setLogDirFailureChannel(LogDirFailureChannel logDirFailureChannel) {
        this.logDirFailureChannel = logDirFailureChannel;
        return this;
    }

    public ReplicaManagerBuilder setAlterPartitionManager(AlterPartitionManager alterPartitionManager) {
        this.alterPartitionManager = alterPartitionManager;
        return this;
    }

    public ReplicaManagerBuilder setActionQueue(ActionQueue actionQueue) {
        this.actionQueue = actionQueue;
        return this;
    }

    public ReplicaManagerBuilder setBrokerTopicStats(BrokerTopicStats brokerTopicStats) {
        this.brokerTopicStats = brokerTopicStats;
        return this;
    }

    public ReplicaManagerBuilder setBrokerState(Supplier<BrokerState> brokerState) {
        this.brokerState = brokerState;
        return this;
    }

    public ReplicaManagerBuilder setZkClient(KafkaZkClient zkClient) {
        this.zkClient = Optional.of(zkClient);
        return this;
    }

    public ReplicaManagerBuilder setDelayedProducePurgatory(DelayedOperationPurgatory<DelayedProduce> delayedProducePurgatory) {
        this.delayedProducePurgatory = Optional.of(delayedProducePurgatory);
        return this;
    }

    public ReplicaManagerBuilder setDelayedFetchPurgatory(DelayedOperationPurgatory<DelayedFetch> delayedFetchPurgatory) {
        this.delayedFetchPurgatory = Optional.of(delayedFetchPurgatory);
        return this;
    }

    public ReplicaManagerBuilder setDelayedDeleteRecordsPurgatory(DelayedOperationPurgatory<DelayedDeleteRecords> delayedDeleteRecordsPurgatory) {
        this.delayedDeleteRecordsPurgatory = Optional.of(delayedDeleteRecordsPurgatory);
        return this;
    }

    public ReplicaManagerBuilder setDelayedElectLeaderPurgatoryParam(DelayedOperationPurgatory<DelayedElectLeader> delayedElectLeaderPurgatory) {
        this.delayedElectLeaderPurgatory = Optional.of(delayedElectLeaderPurgatory);
        return this;
    }

    public ReplicaManagerBuilder setDelayedListOffsetsPurgatory(DelayedOperationPurgatory<DelayedListOffsets> delayedListOffsetsPurgatory) {
        this.delayedListOffsetsPurgatory = Optional.of(delayedListOffsetsPurgatory);
        return this;
    }

    public ReplicaManagerBuilder setTierReplicaComponents(TierReplicaComponents tierReplicaComponents) {
        this.tierReplicaComponents = tierReplicaComponents;
        return this;
    }

    public ReplicaManagerBuilder setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = Optional.of(threadNamePrefix);
        return this;
    }

    public ReplicaManagerBuilder setBrokerEpoch(long brokerEpoch) {
        this.brokerEpoch = brokerEpoch;
        return this;
    }

    public ReplicaManagerBuilder setAddPartitionsToTransactionManager(AddPartitionsToTxnManager addPartitionsToTxnManager) {
        this.addPartitionsToTxnManager = Optional.of(addPartitionsToTxnManager);
        return this;
    }

    public ReplicaManagerBuilder setDirectoryEventHandler(DirectoryEventHandler directoryEventHandler) {
        this.directoryEventHandler = directoryEventHandler;
        return this;
    }

    public ReplicaManager build() {
        if (this.config == null) {
            this.config = new KafkaConfig(Collections.emptyMap());
        }
        if (this.logManager == null) {
            throw new RuntimeException("You must set logManager");
        }
        if (this.metadataCache == null) {
            throw new RuntimeException("You must set metadataCache");
        }
        if (this.logDirFailureChannel == null) {
            throw new RuntimeException("You must set logDirFailureChannel");
        }
        if (this.alterPartitionManager == null) {
            throw new RuntimeException("You must set alterIsrManager");
        }
        if (this.actionQueue == null) {
            throw new RuntimeException("You must set actionQueue");
        }
        if (this.brokerState == null) {
            throw new RuntimeException("You must set brokerState");
        }
        if (this.brokerTopicStats == null) {
            this.brokerTopicStats = new BrokerTopicStats(false, this.config.remoteLogManagerConfig().isRemoteStorageSystemEnabled());
        }
        if (this.metrics == null) {
            this.metrics = new Metrics();
        }
        return new ReplicaManager(this.config, this.metrics, this.time, this.scheduler, this.logManager, this.quotaManagers, this.metadataCache, this.logDirFailureChannel, this.alterPartitionManager, this.actionQueue, this.brokerTopicStats, (Function0<BrokerState>)((Function0)() -> this.brokerState.get()), (Option<KafkaZkClient>)OptionConverters.toScala(this.zkClient), (Option<DelayedOperationPurgatory<DelayedProduce>>)OptionConverters.toScala(this.delayedProducePurgatory), (Option<DelayedOperationPurgatory<DelayedFetch>>)OptionConverters.toScala(this.delayedFetchPurgatory), (Option<DelayedOperationPurgatory<DelayedDeleteRecords>>)OptionConverters.toScala(this.delayedDeleteRecordsPurgatory), (Option<DelayedOperationPurgatory<DelayedElectLeader>>)OptionConverters.toScala(this.delayedElectLeaderPurgatory), (Option<DelayedOperationPurgatory<DelayedListOffsets>>)OptionConverters.toScala(this.delayedListOffsetsPurgatory), this.tierReplicaComponents, (Option<ClusterLinkFactory.LinkManager>)OptionConverters.toScala(this.clusterLinkManager), (Option<String>)OptionConverters.toScala(this.threadNamePrefix), (Option<BrokerHealthManager>)OptionConverters.toScala(Optional.empty()), (Function0<Object>)((Function0)() -> this.brokerEpoch), (Option<AddPartitionsToTxnManager>)OptionConverters.toScala(this.addPartitionsToTxnManager), this.directoryEventHandler);
    }
}

