/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import kafka.server.FetchConnectionsMode$;
import kafka.server.FetchConnectionsMode$Combined$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkFilterJson$;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.TopicConfigSyncIncludeValidator$;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.config.ServerConfigs;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ClusterLinkConfig$ {
    public static ClusterLinkConfig$ MODULE$;
    private final String LinkModeProp;
    private final String LinkModeDoc;
    private final String ConnectionModeProp;
    private final String ConnectionModeDoc;
    private final String LocalPrefix;
    private final String LocalListenerNameProp;
    private final String LocalListenerNameDoc;
    private final String ReverseConnectionSetupTimeoutMsProp;
    private final String ReverseConnectionSetupTimeoutMsDoc;
    private final String RemoteLinkConnectionModeProp;
    private final String RemoteLinkConnectionModeDoc;
    private final String FetcherThreadPoolModeProp;
    private final String FetcherThreadPoolModeDoc;
    private final String NumClusterLinkFetchersProp;
    private final String NumClusterLinkFetchersDoc;
    private final String RetryTimeoutMsProp;
    private final String RetryTimeoutMsDoc;
    private final String ClusterLinkPausedProp;
    private final String ClusterLinkPausedDoc;
    private final String ClusterLinkPrefixProp;
    private final String ClusterLinkPrefixDoc;
    private final String ConsumerOffsetSyncEnableProp;
    private final String ConsumerOffsetSyncEnableDoc;
    private final String ConsumerGroupPrefixEnableProp;
    private final String ConsumerGroupPrefixEnableDoc;
    private final String ConsumerOffsetSyncMsProp;
    private final String ConsumerOffsetSyncMsDoc;
    private final String ConsumerOffsetGroupFiltersProp;
    private final String ConsumerOffsetGroupFiltersDoc;
    private final String AclSyncEnableProp;
    private final String AclSyncEnableDoc;
    private final String AclFiltersProp;
    private final String AclFiltersDoc;
    private final String AclSyncMsProp;
    private final String AclSyncMsDoc;
    private final String TopicConfigSyncIncludeProp;
    private final String TopicConfigSyncIncludeDoc;
    private final String TopicConfigSyncMsProp;
    private final String TopicConfigSyncMsDoc;
    private final String AutoMirroringEnableProp;
    private final String AutoMirroringEnableDoc;
    private final String TopicFiltersProp;
    private final String TopicFiltersDoc;
    private final String MirrorStartOffsetSpecProp;
    private final String MirrorStartOffsetSpecDoc;
    private final String MaxMessageSizeProp;
    private final String MaxMessageSizeDoc;
    private final String AvailabilityCheckMsProp;
    private final String AvailabilityCheckMsDoc;
    private final String AvailabilityCheckConsecutiveFailureThresholdProp;
    private final String AvailabilityCheckConsecutiveFailureThresholdDoc;
    private final String LinkFetcherFlowControlProp;
    private final String LinkFetcherFlowControlDoc;
    private final String LinkFetcherMaxLaggingPartitionsProp;
    private final String LinkFetcherMaxLaggingPartitionsDoc;
    private final String LinkFetcherLaggingPartitionMsProp;
    private final String LinkFetcherLaggingPartitionMsDoc;
    private final String LinkFetcherEnforceMaxLaggingPartitionMsProp;
    private final String LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    private final String LinkFetcherDegradedPartitionMonitorMsProp;
    private final String LinkFetcherDegradedPartitionMonitorMsDoc;
    private final String ClientsMaxIdleMsProp;
    private final String ClientsMaxIdleMsDoc;
    private final String LinkFetcherAutoTuneEnableProp;
    private final String LinkFetcherAutoTuneEnableDoc;
    private final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp;
    private final String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc;
    private final String LinkFetcherAutoTuneIncreaseThroughputPercentageProp;
    private final String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc;
    private final String LinkFetcherAutoTuneMaxConnectionPercentageProp;
    private final String LinkFetcherAutoTuneMaxConnectionPercentageDoc;
    private final String ReplicaSocketReceiveBufferBytesDoc;
    private final String BootstrapServersOverrideProp;
    private final String BootstrapServersOverrideDoc;
    private final String AllowTruncationBelowHWMProp;
    private final String AllowTruncationBelowHWMDoc;
    private final Set<String> ReplicationProps;
    private final int MaxMessageSizeUnlimited;
    private final Set<String> PeriodicTaskProps;
    private final Set<String> NonReconfigurableProps;
    private final Set<String> SslKeystoreConfigs;
    private final Set<String> SslTruststoreConfigs;
    private final Set<String> ProviderConfigs;
    private final Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs;
    private final ConfigDef configDef;

    static {
        new ClusterLinkConfig$();
    }

    public String LinkModeProp() {
        return this.LinkModeProp;
    }

    public String LinkModeDoc() {
        return this.LinkModeDoc;
    }

    public String ConnectionModeProp() {
        return this.ConnectionModeProp;
    }

    public String ConnectionModeDoc() {
        return this.ConnectionModeDoc;
    }

    public String LocalPrefix() {
        return this.LocalPrefix;
    }

    public String LocalListenerNameProp() {
        return this.LocalListenerNameProp;
    }

    public String LocalListenerNameDoc() {
        return this.LocalListenerNameDoc;
    }

    public String ReverseConnectionSetupTimeoutMsProp() {
        return this.ReverseConnectionSetupTimeoutMsProp;
    }

    public String ReverseConnectionSetupTimeoutMsDoc() {
        return this.ReverseConnectionSetupTimeoutMsDoc;
    }

    public String RemoteLinkConnectionModeProp() {
        return this.RemoteLinkConnectionModeProp;
    }

    public String RemoteLinkConnectionModeDoc() {
        return this.RemoteLinkConnectionModeDoc;
    }

    public String FetcherThreadPoolModeProp() {
        return this.FetcherThreadPoolModeProp;
    }

    public String FetcherThreadPoolModeDoc() {
        return this.FetcherThreadPoolModeDoc;
    }

    public String NumClusterLinkFetchersProp() {
        return this.NumClusterLinkFetchersProp;
    }

    public String NumClusterLinkFetchersDoc() {
        return this.NumClusterLinkFetchersDoc;
    }

    public String RetryTimeoutMsProp() {
        return this.RetryTimeoutMsProp;
    }

    public String RetryTimeoutMsDoc() {
        return this.RetryTimeoutMsDoc;
    }

    public String ClusterLinkPausedProp() {
        return this.ClusterLinkPausedProp;
    }

    public String ClusterLinkPausedDoc() {
        return this.ClusterLinkPausedDoc;
    }

    public String ClusterLinkPrefixProp() {
        return this.ClusterLinkPrefixProp;
    }

    public String ClusterLinkPrefixDoc() {
        return this.ClusterLinkPrefixDoc;
    }

    public String ConsumerOffsetSyncEnableProp() {
        return this.ConsumerOffsetSyncEnableProp;
    }

    public String ConsumerOffsetSyncEnableDoc() {
        return this.ConsumerOffsetSyncEnableDoc;
    }

    public String ConsumerGroupPrefixEnableProp() {
        return this.ConsumerGroupPrefixEnableProp;
    }

    public String ConsumerGroupPrefixEnableDoc() {
        return this.ConsumerGroupPrefixEnableDoc;
    }

    public String ConsumerOffsetSyncMsProp() {
        return this.ConsumerOffsetSyncMsProp;
    }

    public String ConsumerOffsetSyncMsDoc() {
        return this.ConsumerOffsetSyncMsDoc;
    }

    public String ConsumerOffsetGroupFiltersProp() {
        return this.ConsumerOffsetGroupFiltersProp;
    }

    public String ConsumerOffsetGroupFiltersDoc() {
        return this.ConsumerOffsetGroupFiltersDoc;
    }

    public String AclSyncEnableProp() {
        return this.AclSyncEnableProp;
    }

    public String AclSyncEnableDoc() {
        return this.AclSyncEnableDoc;
    }

    public String AclFiltersProp() {
        return this.AclFiltersProp;
    }

    public String AclFiltersDoc() {
        return this.AclFiltersDoc;
    }

    public String AclSyncMsProp() {
        return this.AclSyncMsProp;
    }

    public String AclSyncMsDoc() {
        return this.AclSyncMsDoc;
    }

    public String TopicConfigSyncIncludeProp() {
        return this.TopicConfigSyncIncludeProp;
    }

    public String TopicConfigSyncIncludeDoc() {
        return this.TopicConfigSyncIncludeDoc;
    }

    public String TopicConfigSyncMsProp() {
        return this.TopicConfigSyncMsProp;
    }

    public String TopicConfigSyncMsDoc() {
        return this.TopicConfigSyncMsDoc;
    }

    public String AutoMirroringEnableProp() {
        return this.AutoMirroringEnableProp;
    }

    public String AutoMirroringEnableDoc() {
        return this.AutoMirroringEnableDoc;
    }

    public String TopicFiltersProp() {
        return this.TopicFiltersProp;
    }

    public String TopicFiltersDoc() {
        return this.TopicFiltersDoc;
    }

    public String MirrorStartOffsetSpecProp() {
        return this.MirrorStartOffsetSpecProp;
    }

    public String MirrorStartOffsetSpecDoc() {
        return this.MirrorStartOffsetSpecDoc;
    }

    public String MaxMessageSizeProp() {
        return this.MaxMessageSizeProp;
    }

    public String MaxMessageSizeDoc() {
        return this.MaxMessageSizeDoc;
    }

    public String AvailabilityCheckMsProp() {
        return this.AvailabilityCheckMsProp;
    }

    public String AvailabilityCheckMsDoc() {
        return this.AvailabilityCheckMsDoc;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdProp() {
        return this.AvailabilityCheckConsecutiveFailureThresholdProp;
    }

    public String AvailabilityCheckConsecutiveFailureThresholdDoc() {
        return this.AvailabilityCheckConsecutiveFailureThresholdDoc;
    }

    public String LinkFetcherFlowControlProp() {
        return this.LinkFetcherFlowControlProp;
    }

    public String LinkFetcherFlowControlDoc() {
        return this.LinkFetcherFlowControlDoc;
    }

    public String LinkFetcherMaxLaggingPartitionsProp() {
        return this.LinkFetcherMaxLaggingPartitionsProp;
    }

    public String LinkFetcherMaxLaggingPartitionsDoc() {
        return this.LinkFetcherMaxLaggingPartitionsDoc;
    }

    public String LinkFetcherLaggingPartitionMsProp() {
        return this.LinkFetcherLaggingPartitionMsProp;
    }

    public String LinkFetcherLaggingPartitionMsDoc() {
        return this.LinkFetcherLaggingPartitionMsDoc;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsProp() {
        return this.LinkFetcherEnforceMaxLaggingPartitionMsProp;
    }

    public String LinkFetcherEnforceMaxLaggingPartitionMsDoc() {
        return this.LinkFetcherEnforceMaxLaggingPartitionMsDoc;
    }

    public String LinkFetcherDegradedPartitionMonitorMsProp() {
        return this.LinkFetcherDegradedPartitionMonitorMsProp;
    }

    public String LinkFetcherDegradedPartitionMonitorMsDoc() {
        return this.LinkFetcherDegradedPartitionMonitorMsDoc;
    }

    public String ClientsMaxIdleMsProp() {
        return this.ClientsMaxIdleMsProp;
    }

    public String ClientsMaxIdleMsDoc() {
        return this.ClientsMaxIdleMsDoc;
    }

    public String LinkFetcherAutoTuneEnableProp() {
        return this.LinkFetcherAutoTuneEnableProp;
    }

    public String LinkFetcherAutoTuneEnableDoc() {
        return this.LinkFetcherAutoTuneEnableDoc;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp() {
        return this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp;
    }

    public String LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc() {
        return this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageProp() {
        return this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp;
    }

    public String LinkFetcherAutoTuneIncreaseThroughputPercentageDoc() {
        return this.LinkFetcherAutoTuneIncreaseThroughputPercentageDoc;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageProp() {
        return this.LinkFetcherAutoTuneMaxConnectionPercentageProp;
    }

    public String LinkFetcherAutoTuneMaxConnectionPercentageDoc() {
        return this.LinkFetcherAutoTuneMaxConnectionPercentageDoc;
    }

    public String ReplicaSocketReceiveBufferBytesDoc() {
        return this.ReplicaSocketReceiveBufferBytesDoc;
    }

    public String BootstrapServersOverrideProp() {
        return this.BootstrapServersOverrideProp;
    }

    public String BootstrapServersOverrideDoc() {
        return this.BootstrapServersOverrideDoc;
    }

    public String AllowTruncationBelowHWMProp() {
        return this.AllowTruncationBelowHWMProp;
    }

    public String AllowTruncationBelowHWMDoc() {
        return this.AllowTruncationBelowHWMDoc;
    }

    public Set<String> ReplicationProps() {
        return this.ReplicationProps;
    }

    public int MaxMessageSizeUnlimited() {
        return this.MaxMessageSizeUnlimited;
    }

    public Set<String> PeriodicTaskProps() {
        return this.PeriodicTaskProps;
    }

    public Set<String> NonReconfigurableProps() {
        return this.NonReconfigurableProps;
    }

    public Set<String> SslKeystoreConfigs() {
        return this.SslKeystoreConfigs;
    }

    public Set<String> SslTruststoreConfigs() {
        return this.SslTruststoreConfigs;
    }

    public Set<String> ProviderConfigs() {
        return this.ProviderConfigs;
    }

    public Set<String> kafka$server$link$ClusterLinkConfig$$RetentionConfigs() {
        return this.kafka$server$link$ClusterLinkConfig$$RetentionConfigs;
    }

    public boolean needsConnectionResetOnUpdate(String configName) {
        return !this.configKeys().contains((Object)configName) || configName.startsWith(this.LocalPrefix()) || configName.equals("security.protocol") || configName.startsWith("ssl.") || configName.startsWith("sasl.");
    }

    public void main(String[] args) {
        Predef$.MODULE$.println((Object)this.configDef().toHtml());
    }

    public ConfigDef configDef() {
        return this.configDef;
    }

    private ConfigDef createClusterLinkConfigDef() {
        ConfigDef configDef = new ConfigDef().define(this.LinkModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault().name(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values())).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.LinkModeDoc()).define(this.ConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((TraversableOnce)((SeqLike)ConnectionMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$18 -> ((ConnectionMode)x$18).name(), Seq$.MODULE$.canBuildFrom())).$colon$plus(null, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.ConnectionModeDoc()).define(this.LocalListenerNameProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, this.LocalListenerNameDoc()).define(this.ReverseConnectionSetupTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.between((Number)Predef$.MODULE$.int2Integer(1000), (Number)Predef$.MODULE$.int2Integer(Integer.MAX_VALUE)), ConfigDef.Importance.LOW, this.ReverseConnectionSetupTimeoutMsDoc()).define(this.NumClusterLinkFetchersProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers()), ConfigDef.Importance.LOW, this.NumClusterLinkFetchersDoc()).define(this.FetcherThreadPoolModeProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.FetcherThreadPoolModeDefault().name(), ConfigDef.Importance.LOW, this.FetcherThreadPoolModeDoc()).define(this.ClusterLinkPausedProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ClusterLinkPausedDoc()).define(this.ClusterLinkPrefixProp(), ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, this.ClusterLinkPrefixDoc()).define(this.ConsumerOffsetSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncEnableDoc()).define(this.ConsumerGroupPrefixEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.ConsumerGroupPrefixEnableDefault()), ConfigDef.Importance.LOW, this.ConsumerGroupPrefixEnableDoc()).define(this.ConsumerOffsetSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault()), ConfigDef.Importance.LOW, this.ConsumerOffsetSyncMsDoc()).define(this.ConsumerOffsetGroupFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.GROUP_VALIDATOR(), ConfigDef.Importance.LOW, this.ConsumerOffsetGroupFiltersDoc()).define(this.RetryTimeoutMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs()), ConfigDef.Importance.MEDIUM, this.RetryTimeoutMsDoc()).define(this.AclSyncEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AclSyncEnableDoc()).define(this.AclFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)AclJson$.MODULE$.VALIDATOR(), ConfigDef.Importance.LOW, this.AclFiltersDoc()).define(this.AclSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault()), ConfigDef.Importance.LOW, this.AclSyncMsDoc()).define(this.TopicConfigSyncIncludeProp(), ConfigDef.Type.LIST, ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault(), TopicConfigSyncIncludeValidator$.MODULE$.ConfigDefValidator(), ConfigDef.Importance.LOW, this.TopicConfigSyncIncludeDoc()).define(this.TopicConfigSyncMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault()), ConfigDef.Importance.LOW, this.TopicConfigSyncMsDoc()).define(this.AutoMirroringEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)false), ConfigDef.Importance.LOW, this.AutoMirroringEnableDoc()).define(this.TopicFiltersProp(), ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)ClusterLinkFilterJson$.MODULE$.TOPIC_VALIDATOR(), ConfigDef.Importance.LOW, this.TopicFiltersDoc()).define(this.MirrorStartOffsetSpecProp(), ConfigDef.Type.STRING, (Object)ClusterLinkConfigDefaults$.MODULE$.MirrorStartOffsetSpec(), ConfigDef.Importance.LOW, this.MirrorStartOffsetSpecDoc()).define(this.MaxMessageSizeProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)this.MaxMessageSizeUnlimited()), ConfigDef.Importance.LOW, this.MaxMessageSizeDoc()).define(this.AvailabilityCheckMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckMsDoc()).define(this.AvailabilityCheckConsecutiveFailureThresholdProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckConsecutiveFailureThresholdDefault()), ConfigDef.Importance.LOW, this.AvailabilityCheckConsecutiveFailureThresholdProp()).define("bootstrap.servers", ConfigDef.Type.LIST, Collections.emptyList(), (ConfigDef.Validator)new ConfigDef.NonNullValidator(), ConfigDef.Importance.HIGH, "A list of host/port pairs used to establish the initial connection to the Kafka cluster. Clients use this list to bootstrap and discover the full set of Kafka brokers. While the order of servers in the list does not matter, we recommend including more than one server to ensure resilience if any servers are down. This list does not need to contain the entire set of brokers, as Kafka clients automatically manage and update connections to the cluster efficiently. This list must be in the form <code>host1:port1,host2:port2,...</code>.").defineInternal(this.BootstrapServersOverrideProp(), ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, this.BootstrapServersOverrideDoc()).define("client.dns.lookup", ConfigDef.Type.STRING, (Object)ClientDnsLookup.USE_ALL_DNS_IPS.toString(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{ClientDnsLookup.USE_ALL_DNS_IPS.toString(), ClientDnsLookup.RESOLVE_CANONICAL_BOOTSTRAP_SERVERS_ONLY.toString()}), ConfigDef.Importance.MEDIUM, "Controls how the client uses DNS lookups. If set to <code>use_all_dns_ips</code>, connect to each returned IP address in sequence until a successful connection is established. After a disconnection, the next IP is used. Once all IPs have been used once, the client resolves the IP(s) from the hostname again (both the JVM and the OS cache DNS name lookups, however). If set to <code>resolve_canonical_bootstrap_servers_only</code>, resolve each bootstrap address into a list of canonical names. After the bootstrap phase, this behaves the same as <code>use_all_dns_ips</code>.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define("replica.socket.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)30000), ConfigDef.Importance.LOW, "replica.socket.timeout.ms").define("request.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)30000), ConfigDef.Importance.LOW, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ConnectionsMaxIdleMs()), ConfigDef.Importance.LOW, "Idle connections timeout: the server socket processor threads close the connections that idle more than this").define("socket.connection.setup.timeout.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ServerConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("socket.connection.setup.timeout.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ServerConfigs.SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS), ConfigDef.Importance.LOW, "The amount of time the client will wait for the socket connection to be established. If the connection is not built before the timeout elapses, clients will close the socket channel. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>socket.connection.setup.timeout.max.ms</code> value.").define("replica.socket.receive.buffer.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaSocketReceiveBufferBytes()), ConfigDef.Importance.LOW, this.ReplicaSocketReceiveBufferBytesDoc()).define("replica.fetch.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The number of bytes of messages to attempt to fetch for each partition. This is not an absolute maximum, if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("replica.fetch.wait.max.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)500), ConfigDef.Importance.LOW, "The maximum wait time for each fetcher request issued by follower replicas. This value should always be less than the replica.lag.time.max.ms at all times to prevent frequent shrinking of ISR for low throughput topics").define("replica.fetch.backoff.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1000), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait when fetch partition error occurs. The backoff increases exponentially for each consecutive failure up to replica.fetch.backoff.ms").define("confluent.replica.fetch.backoff.max.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1000), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds to wait when fetch partition fails repeatedly. If provided, the backoff will increase exponentially for each consecutive failure, up to this maximum.").define("replica.fetch.min.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.LOW, "Minimum bytes expected for each fetch response. If not enough bytes, wait up to <code>replica.fetch.wait.max.ms</code> (broker config).").define("replica.fetch.response.max.bytes", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchResponseMaxBytes()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Maximum bytes expected for the entire fetch response. Records are fetched in batches, and if the first record batch in the first non-empty partition of the fetch is larger than this value, the record batch will still be returned to ensure that progress can be made. As such, this is not an absolute maximum. The maximum record batch size accepted by the broker is defined via <code>message.max.bytes</code> (broker config) or <code>max.message.bytes</code> (topic config).").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios. This value is the initial backoff value and will increase exponentially for each failed request, up to the <code>retry.backoff.max.ms</code> value.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker. This value is the initial backoff value and will increase exponentially for each consecutive connection failure, up to the <code>reconnect.backoff.max.ms</code> value.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToLong((long)ClusterLinkConfigDefaults$.MODULE$.ReconnectBackoffMaxMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("default.api.timeout.ms", ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.DefaultApiTimeoutMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, "Specifies the timeout (in milliseconds) for client APIs. This configuration is used as the default timeout for all client operations that do not specify a <code>timeout</code> parameter.").define(this.LinkFetcherMaxLaggingPartitionsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherMaxLaggingPartitions()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-1)), ConfigDef.Importance.LOW, this.LinkFetcherMaxLaggingPartitionsDoc()).define(this.LinkFetcherLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherLaggingPartitionMsDoc()).define(this.LinkFetcherEnforceMaxLaggingPartitionMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherEnforceMaxLaggingPartitionMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherEnforceMaxLaggingPartitionMsDoc()).define(this.AllowTruncationBelowHWMProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.AllowTruncationBelowHWM()), ConfigDef.Importance.LOW, this.AllowTruncationBelowHWMDoc()).defineInternal(this.LinkFetcherDegradedPartitionMonitorMsProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherDegradedPartitionMonitorMs()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(0)), ConfigDef.Importance.LOW, this.LinkFetcherDegradedPartitionMonitorMsDoc()).defineInternal(this.LinkFetcherFlowControlProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherFlowControl()), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(-2)), ConfigDef.Importance.LOW, this.LinkFetcherFlowControlDoc()).defineInternal(this.RemoteLinkConnectionModeProp(), ConfigDef.Type.STRING, null, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])((String[])((TraversableOnce)((SeqLike)ConnectionMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$19 -> ((ConnectionMode)x$19).name(), Seq$.MODULE$.canBuildFrom())).$colon$plus(null, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))), ConfigDef.Importance.LOW, this.RemoteLinkConnectionModeDoc()).defineInternal("confluent.replica.fetch.connections.mode", ConfigDef.Type.STRING, (Object)FetchConnectionsMode$Combined$.MODULE$.value(), (ConfigDef.Validator)ConfigDef.ValidString.in((String[])FetchConnectionsMode$.MODULE$.validValues()), ConfigDef.Importance.LOW, "Mode of how replicas are distributed among fetcher threads. <code>combined</code>: replicas will be added to default fetcher threads and no extra in-sync fetcher threads will be created. Fetch request connections will have combined in-sync and out-of-sync replicas.<code>isolated</code>: replicas will be added to default fetcher threads initially. When a replica becomes in-sync, it will be migrated to a new in-sync fetcher thread thus not blocked by out-of-sync replicas in a fetch request.").defineInternal(this.ClientsMaxIdleMsProp(), ConfigDef.Type.LONG, (Object)ClusterLinkConfigDefaults$.MODULE$.ClientsMaxIdleMs(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)Predef$.MODULE$.int2Integer(1)), ConfigDef.Importance.LOW, this.ClientsMaxIdleMsDoc()).defineInternal(this.LinkFetcherAutoTuneEnableProp(), ConfigDef.Type.BOOLEAN, (Object)BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneEnable()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneEnableDoc()).defineInternal(this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneDecreaseThroughputThresholdBytes()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc()).defineInternal(this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneIncreaseThroughputPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneIncreaseThroughputPercentageDoc()).defineInternal(this.LinkFetcherAutoTuneMaxConnectionPercentageProp(), ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)ClusterLinkConfigDefaults$.MODULE$.LinkFetcherAutoTuneMaxConnectionPercentage()), ConfigDef.Importance.LOW, this.LinkFetcherAutoTuneMaxConnectionPercentageDoc()).withClientSslSupport().withClientSaslSupport();
        return this.addLocalClientSecurityConfigs(configDef);
    }

    private ConfigDef addLocalClientSecurityConfigs(ConfigDef configDef) {
        String localDoc = new StringBuilder(133).append("This security configuration with '").append(this.LocalPrefix()).append("' prefix is applied to clients connecting ").append("locally to the source cluster of a source initiated link.").toString();
        ObjectRef newConfigDef = ObjectRef.create((Object)configDef.define(new StringBuilder(17).append(this.LocalPrefix()).append("security.protocol").toString(), ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, new StringBuilder(0).append(CommonClientConfigs.SECURITY_PROTOCOL_DOC).append(localDoc).toString()));
        new ConfigDef().withClientSslSupport().withClientSaslSupport().configKeys().forEach((name, key) -> {
            newConfigDef$1.elem = ((ConfigDef)newConfigDef$1.elem).define(new StringBuilder(0).append(MODULE$.LocalPrefix()).append((String)name).toString(), key.type, key.defaultValue, key.validator, key.importance, new StringBuilder(1).append(key.documentation).append(" ").append(localDoc).toString(), key.group, key.orderInGroup, key.width, key.displayName, key.dependents, key.recommender);
        });
        return (ConfigDef)newConfigDef.elem;
    }

    public Seq<String> configNames() {
        return (Seq)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(this.configDef().names()).asScala()).toSeq().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Map<String, ConfigDef.ConfigKey> configKeys() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.configDef().configKeys()).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<ConfigDef.Type> configType(String name) {
        return Option$.MODULE$.apply(this.configDef().configKeys().get(name)).map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.type);
    }

    public Optional<ConfigDef.Type> configTypeAsJava(String name) {
        return OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(this.configType(name)));
    }

    public ConfigDef configDefCopy() {
        return new ConfigDef(this.configDef());
    }

    public ClusterLinkConfig create(java.util.Map<?, ?> props, Option<KafkaConfig> brokerConfig, boolean validate) {
        try {
            Properties properties;
            ClusterLinkConfig.LinkMode linkMode = (ClusterLinkConfig.LinkMode)Option$.MODULE$.apply(props.get(this.LinkModeProp())).map((Function1 & Serializable & scala.Serializable)m -> ClusterLinkConfig.LinkMode.fromString((String)m.toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault());
            ConnectionMode connectionMode = props.containsKey(this.ConnectionModeProp()) ? ConnectionMode$.MODULE$.fromString(props.get(this.ConnectionModeProp()).toString()) : this.defaultConnectionMode(linkMode);
            ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
            if (!(connectionMode != null ? !connectionMode.equals(connectionMode$Inbound$) : connectionMode$Inbound$ != null) && linkMode.mayActAsDestination()) {
                Properties newProps = new Properties();
                props.forEach((k, v) -> newProps.setProperty(k.toString(), v.toString()));
                newProps.setProperty("bootstrap.servers", "localhost:0");
                properties = newProps;
            } else {
                properties = props;
            }
            Properties configProps = properties;
            return new ClusterLinkConfig(configProps, brokerConfig, validate);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            throw invalidConfigurationException;
        }
        catch (ConfigException e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append((Object)e).toString());
        }
        catch (Exception e) {
            throw new InvalidConfigurationException(new StringBuilder(30).append("Invalid cluster link configs: ").append(e).toString(), (Throwable)e);
        }
    }

    public boolean create$default$3() {
        return true;
    }

    public ClusterLinkConfig configsWithOverrides(ClusterLinkConfig clusterLinkConfig, java.util.Map<String, Object> configOverrides) {
        java.util.Map originalsCopy = clusterLinkConfig.originals();
        originalsCopy.putAll(configOverrides);
        return new ClusterLinkConfig(originalsCopy, clusterLinkConfig.brokerConfig(), false);
    }

    public void kafka$server$link$ClusterLinkConfig$$validateClusterLinkPrefix(String clusterLinkPrefix) {
        int maxLength = 12;
        if (clusterLinkPrefix.length() > maxLength) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Cluster link prefix exceeds maximum size of '").append(maxLength).append("' characters").toString());
        }
        if (!Topic.containsValidPattern((String)clusterLinkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(67).append("Cluster link prefix '").append(clusterLinkPrefix).append("' is illegal, valid characters: [a-zA-Z0-9._-]").toString());
        }
    }

    public ConnectionMode defaultConnectionMode(ClusterLinkConfig.LinkMode linkMode) {
        if (linkMode.mayActAsDestination()) {
            return ConnectionMode$Outbound$.MODULE$;
        }
        return ConnectionMode$Inbound$.MODULE$;
    }

    private ClusterLinkConfig.LinkMode clusterLinkMode(java.util.Map<String, String> configs) {
        return (ClusterLinkConfig.LinkMode)Option$.MODULE$.apply((Object)configs.get(this.LinkModeProp())).map((Function1 & Serializable & scala.Serializable)x$1 -> ClusterLinkConfig.LinkMode.fromString((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ClusterLinkConfigDefaults$.MODULE$.LinkModeDefault());
    }

    public ConnectionMode clusterLinkConnectionMode(java.util.Map<String, String> configs) {
        return (ConnectionMode)Option$.MODULE$.apply((Object)configs.get(this.ConnectionModeProp())).map((Function1 & Serializable & scala.Serializable)mode -> ConnectionMode$.MODULE$.fromString((String)mode)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.defaultConnectionMode(MODULE$.clusterLinkMode(configs)));
    }

    public OffsetSpec offsetSpecFromString(String offsetSpecValue) {
        if (offsetSpecValue == null || offsetSpecValue.equalsIgnoreCase("earliest")) {
            return OffsetSpec.earliest();
        }
        if (offsetSpecValue.equalsIgnoreCase("latest")) {
            return OffsetSpec.latest();
        }
        try {
            return OffsetSpec.forTimestamp((long)Utils.getDateTime((String)offsetSpecValue));
        }
        catch (Throwable e) {
            throw new InvalidConfigurationException(new StringBuilder(25).append("Invalid config value ").append(this.MirrorStartOffsetSpecProp()).append("=").append(offsetSpecValue).append(" : ").append(e).toString(), e);
        }
    }

    private ClusterLinkConfig$() {
        MODULE$ = this;
        this.LinkModeProp = "link.mode";
        this.LinkModeDoc = new StringBuilder(121).append("Mode that indicates if this cluster is configured to be the source or destination of the cluster link.").append(" Valid values are ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ClusterLinkConfig.LinkMode.values())).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).append(".").toString();
        this.ConnectionModeProp = "connection.mode";
        this.ConnectionModeDoc = new StringBuilder(490).append("Connection mode that indicates if outbound connections are established by this cluster for").append(" the cluster link. Valid values are ").append(ConnectionMode$.MODULE$.values().map((Function1 & Serializable & scala.Serializable)x$16 -> ((ConnectionMode)x$16).name(), Seq$.MODULE$.canBuildFrom())).append(". By default, destination cluster creates").append(" outbound connections and source cluster accepts inbound connections. Connection and security configuration should be").append(" provided for the cluster that establishes outbound connections. Security configuration to establish local connections").append(" should also be provided with prefix 'local.' for source clusters with connection mode ").append(ConnectionMode$Outbound$.MODULE$.name()).append(".").toString();
        this.LocalPrefix = "local.";
        this.LocalListenerNameProp = "local.listener.name";
        this.LocalListenerNameDoc = new StringBuilder(383).append("Name of the local listener on the source cluster used for local cluster link connection requests.").append(" Cluster link connections are added to this listener if '").append(this.LinkModeProp()).append("=").append(ClusterLinkConfig.LinkMode.SOURCE.name()).append("' and '").append(this.ConnectionModeProp()).append("=").append(ConnectionMode$Outbound$.MODULE$.name()).append("'.").append(" Security configuration options for creating local connections on this listener should be configured with the prefix '").append(this.LocalPrefix()).append("'.").append(" By default, the listener on which the source link was created will be used as the local listener.").toString();
        this.ReverseConnectionSetupTimeoutMsProp = "reverse.connection.setup.timeout.ms";
        this.ReverseConnectionSetupTimeoutMsDoc = "Timeout in milliseconds to wait for response of reverse connection requests for source initiated links. This limits the amount of time before a retry when brokers fail or are restarted.";
        this.RemoteLinkConnectionModeProp = "remote.link.connection.mode";
        this.RemoteLinkConnectionModeDoc = "Connection mode used by the remote link of a bi-directional link";
        this.FetcherThreadPoolModeProp = "fetcher.thread.pool.mode";
        this.FetcherThreadPoolModeDoc = new StringBuilder(98).append(KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeDoc()).append(" If the property is not configured at link level then the broker property `").append(KafkaConfig$.MODULE$.ClusterLinkFetcherThreadPoolModeProp()).append("` will be used instead.").toString();
        this.NumClusterLinkFetchersProp = "num.cluster.link.fetchers";
        this.NumClusterLinkFetchersDoc = new StringBuilder(315).append("Number of fetchers used to replicate messages from source brokers in cluster links.").append(" This is the maximum number of connections between each broker pair. If '").append(this.FetcherThreadPoolModeProp()).append("=").append(ClusterLinkConfig.FetcherThreadPoolMode.LINK).append("',").append(" this is the maximum number of fetcher threads for the link, if '").append(this.FetcherThreadPoolModeProp()).append("=").append(ClusterLinkConfig.FetcherThreadPoolMode.ENDPOINT).append("',").append(" this is the maximum number of fetcher threads for connections between each broker pair.").toString();
        this.RetryTimeoutMsProp = "cluster.link.retry.timeout.ms";
        this.RetryTimeoutMsDoc = "The number of milliseconds after which failures are no longer retried and partitions are marked as failed. If the source topic is deleted and recreated within this timeout, the link may contain records from the old as well as the new topic.";
        this.ClusterLinkPausedProp = "cluster.link.paused";
        this.ClusterLinkPausedDoc = "Whether all activity over the cluster link is paused.";
        this.ClusterLinkPrefixProp = "cluster.link.prefix";
        this.ClusterLinkPrefixDoc = new StringBuilder(212).append("The prefix value that will be applied to the name of the resources created by the cluster link. Some examples are mirror topic name and consumer group id.").append(" Topics that begin with '_confluent' will not be mirrored.").toString();
        this.ConsumerOffsetSyncEnableProp = "consumer.offset.sync.enable";
        this.ConsumerOffsetSyncEnableDoc = "Whether or not to migrate consumer offsets from the source cluster.";
        this.ConsumerGroupPrefixEnableProp = "consumer.group.prefix.enable";
        this.ConsumerGroupPrefixEnableDoc = "Whether to apply the cluster link prefix to consumer groups.";
        this.ConsumerOffsetSyncMsProp = "consumer.offset.sync.ms";
        this.ConsumerOffsetSyncMsDoc = "How often to sync consumer offsets.";
        this.ConsumerOffsetGroupFiltersProp = "consumer.offset.group.filters";
        this.ConsumerOffsetGroupFiltersDoc = "JSON to denote the list of consumer groups to be migrated.";
        this.AclSyncEnableProp = "acl.sync.enable";
        this.AclSyncEnableDoc = "Whether or not to migrate ACLs";
        this.AclFiltersProp = "acl.filters";
        this.AclFiltersDoc = "JSON to denote the list of ACLs to be migrated.";
        this.AclSyncMsProp = "acl.sync.ms";
        this.AclSyncMsDoc = "How often to refresh the ACLs.";
        this.TopicConfigSyncIncludeProp = "topic.config.sync.include";
        this.TopicConfigSyncIncludeDoc = "The list of topic configs to sync from the source topic.";
        this.TopicConfigSyncMsProp = "topic.config.sync.ms";
        this.TopicConfigSyncMsDoc = "How often to refresh the topic configs.";
        this.AutoMirroringEnableProp = "auto.create.mirror.topics.enable";
        this.AutoMirroringEnableDoc = "Whether or not to automatically create mirror topics";
        this.TopicFiltersProp = "auto.create.mirror.topics.filters";
        this.TopicFiltersDoc = "JSON to denote the list of source topics to automatically create mirror topics from";
        this.MirrorStartOffsetSpecProp = "mirror.start.offset.spec";
        this.MirrorStartOffsetSpecDoc = "Start offset spec that determines the offset from which mirroring starts for new topics. The value may be \"earliest\", \"latest\" or a timestamp in ISO8601 format \"YYYY-MM-DDTHH:mm:SS.sss\". By default, mirroring starts from the earliest available offset.";
        this.MaxMessageSizeProp = "max.message.size";
        this.MaxMessageSizeDoc = new StringBuilder(947).append("The largest record batch size allowed by Kafka (after compression if compression is enabled). If this is increased and there are consumers older than 0.10.2, the consumers' fetch size must also be increased so that they can fetch record batches this large. In the latest message format version, records are always grouped into batches for efficiency. In previous message format versions, uncompressed records are not grouped into batches and this limit only applies to a single record in that case.").append(" The setting on the cluster link defines the largest record batch size").append(" that may be replicated from the source cluster. If larger records are found on a source partition, the mirror topic will be moved").append(" to failed state. Note that the maximum configured for the source topic is not applied during cluster link replication,").append(" but the setting is sync'ed to the mirror topic to ensure that the same config applies after failover. Default value is unlimited.").toString();
        this.AvailabilityCheckMsProp = "availability.check.ms";
        this.AvailabilityCheckMsDoc = "How often to send a request to source cluster to check source cluster availability.";
        this.AvailabilityCheckConsecutiveFailureThresholdProp = "availability.check.consecutive.failure.threshold";
        this.AvailabilityCheckConsecutiveFailureThresholdDoc = "The upper-bound of the consecutive failures beyond which the availability checker will report the link as unavailable.";
        this.LinkFetcherFlowControlProp = "link.fetcher.flow.control";
        this.LinkFetcherFlowControlDoc = "The flow control approach used by cluster linking fetcher";
        this.LinkFetcherMaxLaggingPartitionsProp = "link.fetcher.max.lagging.partitions";
        this.LinkFetcherMaxLaggingPartitionsDoc = "Maximum number of lagging partitions. The limit is enforced periodically by the fetcher. If set to -1, the limit is not enforced.";
        this.LinkFetcherLaggingPartitionMsProp = "link.fetcher.lagging.partition.ms";
        this.LinkFetcherLaggingPartitionMsDoc = "When a partition last caught up time is more than this time, the partition is considered a lagging partition.";
        this.LinkFetcherEnforceMaxLaggingPartitionMsProp = "link.fetcher.enforce.max.lagging.partitions.ms";
        this.LinkFetcherEnforceMaxLaggingPartitionMsDoc = "The periodic interval where link fetcher will run periodic tasks like enforcing the limit on number of lagging partitions.";
        this.LinkFetcherDegradedPartitionMonitorMsProp = "link.fetcher.degraded.partition.monitor.ms";
        this.LinkFetcherDegradedPartitionMonitorMsDoc = "The periodic interval at which link fetcher verifies the status of degraded partitions.";
        this.ClientsMaxIdleMsProp = "clients.max.idle.ms";
        this.ClientsMaxIdleMsDoc = "The interval in milliseconds after which idle cluster link clients and associated threads are closed.";
        this.LinkFetcherAutoTuneEnableProp = "link.fetcher.auto.tune.num.fetchers.enable";
        this.LinkFetcherAutoTuneEnableDoc = "If true, enable auto tuning number of cluster link fetchers.";
        this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp = "link.fetcher.auto.tune.decrease.throughput.threshold.bytes";
        this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesDoc = "If the cluster link throughput is below this value and there is no lagging partition, auto tuning will reduce the number of cluster link fetchers";
        this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp = "link.fetcher.auto.tune.increase.throughput.percentage";
        this.LinkFetcherAutoTuneIncreaseThroughputPercentageDoc = "After increasing the number of cluster link fetchers, auto tuning expects the throughput to increase at least this percentage before further increases the number of cluster link fetchers.";
        this.LinkFetcherAutoTuneMaxConnectionPercentageProp = "link.fetcher.auto.tune.max.connection.percentage";
        this.LinkFetcherAutoTuneMaxConnectionPercentageDoc = "When the active number of cluster link connections exceeds this percentage of maximum allowed cluster link connections, auto tuning will stop increasing the number of cluster link fetchers.";
        this.ReplicaSocketReceiveBufferBytesDoc = "The socket receive buffer size for cluster linking connections. The receive buffer size will be limited by a defined maximum value. If set to -1, the kernel will auto tune the receive buffer size up to a defined maximum value.";
        this.BootstrapServersOverrideProp = "bootstrap.servers.override";
        this.BootstrapServersOverrideDoc = "A list of overridden bootstrap servers to use for establishing the initial connection to the Kafka cluster if present instead of bootstrap.servers provided by the customer.";
        this.AllowTruncationBelowHWMProp = "allow.truncation.below.high.watermark";
        this.AllowTruncationBelowHWMDoc = "If true, allow cluster link to truncate the mirror topic partitions below high watermark.";
        this.ReplicationProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.AllowTruncationBelowHWMProp(), this.NumClusterLinkFetchersProp(), this.FetcherThreadPoolModeProp(), this.RetryTimeoutMsProp(), this.LinkFetcherFlowControlProp(), this.LinkFetcherMaxLaggingPartitionsProp(), this.LinkFetcherLaggingPartitionMsProp(), this.MaxMessageSizeProp(), "replica.socket.timeout.ms", "replica.socket.receive.buffer.bytes", "replica.fetch.max.bytes", "replica.fetch.wait.max.ms", "replica.fetch.backoff.ms", "confluent.replica.fetch.backoff.max.ms", "replica.fetch.min.bytes", "replica.fetch.response.max.bytes", "confluent.replica.fetch.connections.mode"}));
        this.MaxMessageSizeUnlimited = Integer.MAX_VALUE;
        this.PeriodicTaskProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ConsumerOffsetSyncEnableProp(), this.ConsumerOffsetSyncMsProp(), this.ConsumerOffsetGroupFiltersProp(), this.AclSyncEnableProp(), this.AclFiltersProp(), this.AclSyncMsProp(), this.TopicConfigSyncMsProp(), this.AutoMirroringEnableProp(), this.TopicFiltersProp(), this.AvailabilityCheckMsProp(), this.AvailabilityCheckConsecutiveFailureThresholdProp(), this.LinkFetcherEnforceMaxLaggingPartitionMsProp(), this.LinkFetcherDegradedPartitionMonitorMsProp(), this.ClientsMaxIdleMsProp(), this.LinkFetcherAutoTuneEnableProp(), this.LinkFetcherAutoTuneDecreaseThroughputThresholdBytesProp(), this.LinkFetcherAutoTuneIncreaseThroughputPercentageProp(), this.LinkFetcherAutoTuneMaxConnectionPercentageProp()}));
        this.NonReconfigurableProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.LinkModeProp(), this.ConnectionModeProp(), this.ClusterLinkPrefixProp(), this.ConsumerGroupPrefixEnableProp(), this.RemoteLinkConnectionModeProp()}));
        this.SslKeystoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.keystore.location", "ssl.keystore.password", "ssl.key.password", "ssl.keystore.type", "ssl.keystore.certificate.chain", "ssl.keystore.key"}));
        this.SslTruststoreConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.truststore.location", "ssl.truststore.password", "ssl.truststore.type", "ssl.truststore.certificates"}));
        this.ProviderConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ssl.provider", "security.providers"}));
        this.kafka$server$link$ClusterLinkConfig$$RetentionConfigs = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"retention.ms", "retention.bytes"}));
        this.configDef = this.createClusterLinkConfigDef();
    }
}

