/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkBatchAdmin;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkScheduler$;
import kafka.server.link.ClusterLinkSyncOffsets$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.CommittedOffsetTopicPartition;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.ExcessiveLoggingHandler$;
import kafka.server.link.FilterType$;
import kafka.server.link.GroupClusterLinkFilter;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.LocalMirrorTopic;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.RegularTopic;
import kafka.server.link.RemoteLinkMetadata;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorTopic;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicType$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeMirrorsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsSpec;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r5t!\u0002\u001d:\u0011\u0003\u0001e!\u0002\":\u0011\u0003\u0019\u0005\"\u0002&\u0002\t\u0003Y\u0005b\u0002'\u0002\u0005\u0004%\t!\u0014\u0005\u0007#\u0006\u0001\u000b\u0011\u0002(\t\u000fI\u000b!\u0019!C\u0001'\"1\u0011-\u0001Q\u0001\nQ+AAY\u0001\u0001G\u001a)!)\u000f\u0001\u0002\u0010!Q\u0011q\u0004\u0005\u0003\u0006\u0004%\t!!\t\t\u0015\u0005%\u0002B!A!\u0002\u0013\t\u0019\u0003\u0003\u0006\u0002,!\u0011)\u0019!C\u0001\u0003[A!\"!\u000e\t\u0005\u0003\u0005\u000b\u0011BA\u0018\u0011)\t9\u0004\u0003B\u0001B\u0003%\u0011\u0011\b\u0005\u000b\u0003\u000bB!\u0011!Q\u0001\n\u0005\u001d\u0003BCA'\u0011\t\u0005\t\u0015!\u0003\u0002H!Q\u0011q\n\u0005\u0003\u0002\u0003\u0006I!!\u0015\t\u0019\u0005]\u0003B!A!\u0002\u0013\tI&!\u001a\t\u0019\u0005\u001d\u0004B!A!\u0002\u0013\tI'!\u001d\t\r)CA\u0011AA:\u0011%\t9\t\u0003a\u0001\n\u0013\tI\tC\u0005\u0002\u0012\"\u0001\r\u0011\"\u0003\u0002\u0014\"A\u0011q\u0014\u0005!B\u0013\tY\t\u0003\u0005\u0002\"\"\u0001\r\u0011\"\u0003N\u0011%\t\u0019\u000b\u0003a\u0001\n\u0013\t)\u000bC\u0004\u0002*\"\u0001\u000b\u0015\u0002(\t\u0013\u0005-\u0006\u00021A\u0005\n\u00055\u0006\"CA^\u0011\u0001\u0007I\u0011BA_\u0011!\t\t\r\u0003Q!\n\u0005=\u0006\"CAb\u0011\u0001\u0007I\u0011BAc\u0011%\ty\r\u0003a\u0001\n\u0013\t\t\u000e\u0003\u0005\u0002V\"\u0001\u000b\u0015BAd\u0011%\ty\u000e\u0003b\u0001\n\u0013\t\t\u000f\u0003\u0005\u0002j\"\u0001\u000b\u0011BAr\u0011\u001d\tY\u000f\u0003C)\u0003[DqAa\u0001\t\t\u0013\u0011)\u0001C\u0004\u0003\u0012!!IAa\u0005\t\u000f\t]\u0001\u0002\"\u0003\u0003\u001a!9!Q\u0007\u0005\u0005\n\t]\u0002b\u0002B#\u0011\u0011%!q\t\u0005\b\u0005+BA\u0011\u0002B,\u0011\u001d\u0011)\u0007\u0003C\u0005\u0005OBqAa\u001c\t\t\u0013\u0011\t\bC\u0004\u0003v!!IAa\u001e\t\u000f\t\u001d\u0005\u0002\"\u0003\u0003\n\"9!Q\u0013\u0005\u0005\n\t]\u0005b\u0002Bc\u0011\u0011%!q\u0019\u0005\b\u0005GDA\u0011\u0002Bs\u0011\u001d\u00119\u0010\u0003C\u0005\u0005sDqaa\u0001\t\t\u0013\u0019)\u0001C\u0004\u0004\u0018!!Ia!\u0007\t\u000f\r5\u0002\u0002\"\u0003\u00040!9!Q\u000f\u0005\u0005\u0012\r%\u0003bBB-\u0011\u0011%11\f\u0005\b\u0007;BA\u0011KB0\u0011\u001d\u0019I\u0007\u0003C!\u0007W\nac\u00117vgR,'\u000fT5oWNKhnY(gMN,Go\u001d\u0006\u0003um\nA\u0001\\5oW*\u0011A(P\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003y\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002B\u00035\t\u0011H\u0001\fDYV\u001cH/\u001a:MS:\\7+\u001f8d\u001f\u001a47/\u001a;t'\t\tA\t\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u000b\u0001\u0005T5ti\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;CCR\u001c\u0007nU5{KV\ta\n\u0005\u0002F\u001f&\u0011\u0001K\u0012\u0002\u0004\u0013:$\u0018!\t'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3u\u0005\u0006$8\r[*ju\u0016\u0004\u0013a\u0007'jgR|eMZ:fiN4uN]!mYB\u000b'\u000f^5uS>t7/F\u0001U!\t)v,D\u0001W\u0015\t9\u0006,A\u0003bI6LgN\u0003\u0002Z5\u000691\r\\5f]R\u001c(B\u0001 \\\u0015\taV,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0006\u0019qN]4\n\u0005\u00014&\u0001\b'jgR\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ugN\u0003XmY\u0001\u001d\u0019&\u001cHo\u00144gg\u0016$8OR8s\u00032d\u0007+\u0019:uSRLwN\\:!\u00055yeMZ:fi\u001a+H/\u001e:fgB!Am\u001b8r\u001d\t)\u0017\u000e\u0005\u0002g\r6\tqM\u0003\u0002i\u007f\u00051AH]8pizJ!A\u001b$\u0002\rA\u0013X\rZ3g\u0013\taWNA\u0002NCBT!A\u001b$\u0011\u0005\u0005{\u0017B\u00019:\u00051i\u0015\r^2iK\u0012<%o\\;q!\r\u0011Xo^\u0007\u0002g*\u0011AOW\u0001\u0007G>lWn\u001c8\n\u0005Y\u001c(aC&bM.\fg)\u001e;ve\u0016\u0004R\u0001_?\u007f\u0003\u0007i\u0011!\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u00017z!\t\u0011x0C\u0002\u0002\u0002M\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tI\u0001W\u0001\tG>t7/^7fe&!\u0011QBA\u0004\u0005EyeMZ:fi\u0006sG-T3uC\u0012\fG/Y\n\u0004\u0011\u0005E\u0001\u0003BA\n\u00033q1!QA\u000b\u0013\r\t9\"O\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\t\u0005m\u0011Q\u0004\u0002\r!\u0016\u0014\u0018n\u001c3jGR\u000b7o\u001b\u0006\u0004\u0003/I\u0014!D2mS\u0016tG/T1oC\u001e,'/\u0006\u0002\u0002$A\u0019\u0011)!\n\n\u0007\u0005\u001d\u0012H\u0001\u000fDYV\u001cH/\u001a:MS:\\G)Z:u\u00072LWM\u001c;NC:\fw-\u001a:\u0002\u001d\rd\u0017.\u001a8u\u001b\u0006t\u0017mZ3sA\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0006\u0002\u00020A\u0019\u0011)!\r\n\u0007\u0005M\u0012H\u0001\u000eDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018-T1oC\u001e,'/\u0001\tnKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u0005AA.\u001b8l\t\u0006$\u0018\r\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty$P\u0001\u0003u.LA!a\u0011\u0002>\ty1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0006sK6|G/Z!e[&t\u0007cA!\u0002J%\u0019\u00111J\u001d\u0003+\rcWo\u001d;fe2Kgn\u001b\"bi\u000eD\u0017\tZ7j]\u0006QAn\\2bY\u0006#W.\u001b8\u0002\u000f5,GO]5dgB\u0019\u0011)a\u0015\n\u0007\u0005U\u0013H\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001\u0002;j[\u0016\u0004B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?\u001a\u0018!B;uS2\u001c\u0018\u0002BA2\u0003;\u0012A\u0001V5nK&!\u0011qKA\r\u0003\u0015\tXo\u001c;b!\u0011\tY'!\u001c\u000e\u0003mJ1!a\u001c<\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0003\u0003\u0002h\u0005eACEA;\u0003o\nI(a\u001f\u0002~\u0005}\u0014\u0011QAB\u0003\u000b\u0003\"!\u0011\u0005\t\u000f\u0005}1\u00031\u0001\u0002$!9\u00111F\nA\u0002\u0005=\u0002bBA\u001c'\u0001\u0007\u0011\u0011\b\u0005\b\u0003\u000b\u001a\u0002\u0019AA$\u0011\u001d\tie\u0005a\u0001\u0003\u000fBq!a\u0014\u0014\u0001\u0004\t\t\u0006C\u0004\u0002XM\u0001\r!!\u0017\t\u000f\u0005\u001d4\u00031\u0001\u0002j\u000511m\u001c8gS\u001e,\"!a#\u0011\u0007\u0005\u000bi)C\u0002\u0002\u0010f\u0012\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0005\u0003+\u000bY\nE\u0002F\u0003/K1!!'G\u0005\u0011)f.\u001b;\t\u0013\u0005uU#!AA\u0002\u0005-\u0015a\u0001=%c\u000591m\u001c8gS\u001e\u0004\u0013\u0001\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8h\u0003Q!\u0018m]6t\u001fV$8\u000f^1oI&twm\u0018\u0013fcR!\u0011QSAT\u0011!\ti\nGA\u0001\u0002\u0004q\u0015!\u0005;bg.\u001cx*\u001e;ti\u0006tG-\u001b8hA\u0005\u0011\"/Z7pi\u0016d\u0015N\\6NKR\fG-\u0019;b+\t\ty\u000bE\u0003F\u0003c\u000b),C\u0002\u00024\u001a\u0013aa\u00149uS>t\u0007cA!\u00028&\u0019\u0011\u0011X\u001d\u0003%I+Wn\u001c;f\u0019&t7.T3uC\u0012\fG/Y\u0001\u0017e\u0016lw\u000e^3MS:\\W*\u001a;bI\u0006$\u0018m\u0018\u0013fcR!\u0011QSA`\u0011%\tijGA\u0001\u0002\u0004\ty+A\nsK6|G/\u001a'j].lU\r^1eCR\f\u0007%\u0001\u0005uCN\\G)Z:d+\t\t9\rE\u0003F\u0003c\u000bI\rE\u0002B\u0003\u0017L1!!4:\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0017\u0001\u0004;bg.$Um]2`I\u0015\fH\u0003BAK\u0003'D\u0011\"!(\u001f\u0003\u0003\u0005\r!a2\u0002\u0013Q\f7o\u001b#fg\u000e\u0004\u0003fA\u0010\u0002ZB\u0019Q)a7\n\u0007\u0005ugI\u0001\u0005w_2\fG/\u001b7f\u0003Y!Wm]2sS\n,W*\u001b:s_J\u001cx\n\u001d;j_:\u001cXCAAr!\r)\u0016Q]\u0005\u0004\u0003O4&A\u0006#fg\u000e\u0014\u0018NY3NSJ\u0014xN]:PaRLwN\\:\u0002/\u0011,7o\u0019:jE\u0016l\u0015N\u001d:peN|\u0005\u000f^5p]N\u0004\u0013a\u0001:v]R\u0011\u0011q\u001e\t\u0005\u0003c\fyP\u0004\u0003\u0002t\u0006Ua\u0002BA{\u0003{tA!a>\u0002|:\u0019a-!?\n\u0003yJ!\u0001P\u001f\n\u0005iZ\u0014\u0002\u0002B\u0001\u0003;\u0011!\u0002V1tWJ+7/\u001e7u\u0003-\u0019\u0018P\\2PM\u001a\u001cX\r^:\u0015\t\u0005=(q\u0001\u0005\b\u0005\u0013\u0019\u0003\u0019\u0001B\u0006\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\t\u0005E(QB\u0005\u0005\u0005\u001f\tiBA\u0006UCN\\7i\u001c8uKb$\u0018A\f;ss&s\u0017\u000e^5bY&TXMU3n_R,W*\u001b:s_J\u001c\u0016P\\2j]\u001e\fe\u000eZ*z]\u000e|eMZ:fiN$B!a<\u0003\u0016!9!\u0011\u0002\u0013A\u0002\t-\u0011a\u00115b]\u0012dW\rR3tGJL'-Z\"p]\u001aLwm\u001d*fgB|gn]3U_&s\u0017\u000e^5bY&TXMU3n_R,W*\u001b:s_J\u001c\u0016P\\2j]\u001e\fe\u000eZ*z]\u000e$\u0002\"a<\u0003\u001c\tu!1\u0006\u0005\b\u0005\u0013)\u0003\u0019\u0001B\u0006\u0011\u001d\u0011y\"\na\u0001\u0005C\t\u0001B]3t_V\u00148-\u001a\t\u0005\u0005G\u00119#\u0004\u0002\u0003&)\u0019\u0011qQ:\n\t\t%\"Q\u0005\u0002\u000f\u0007>tg-[4SKN|WO]2f\u0011\u001d\u0011i#\na\u0001\u0005_\taA]3tk2$\bcA+\u00032%\u0019!1\u0007,\u0003+\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON\u0014Vm];mi\u0006q\u0002.\u00198eY\u0016d\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f]:SKN,H\u000e\u001e\u000b\u0007\u0003_\u0014IDa\u000f\t\u000f\t%a\u00051\u0001\u0003\f!9!Q\b\u0014A\u0002\t}\u0012\u0001\u00077jgR\u001cuN\\:v[\u0016\u0014xI]8vaN\u0014Vm];miB\u0019QK!\u0011\n\u0007\t\rcK\u0001\rMSN$8i\u001c8tk6,'o\u0012:pkB\u001c(+Z:vYR\fA\u0003[1oI2,g)\u001b7uKJ,Gm\u0012:pkB\u001cHCBAx\u0005\u0013\u0012Y\u0005C\u0004\u0003\n\u001d\u0002\rAa\u0003\t\u000f\t5s\u00051\u0001\u0003P\u0005qa-\u001b7uKJ,Gm\u0012:pkB\u001c\b\u0003\u00023\u0003R9L1Aa\u0015n\u0005\r\u0019V\r^\u0001\u0015M&dG/\u001a:D_:\u001cX/\\3s\u000fJ|W\u000f]:\u0015\t\t=#\u0011\f\u0005\b\u00057B\u0003\u0019\u0001B/\u0003\u00199'o\\;qgB)AM!\u0015\u0003`A\u0019AM!\u0019\n\u0007\t\rTN\u0001\u0004TiJLgnZ\u0001\u001dY&\u001cH\u000fR3ti\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;t)\u0011\u0011IG!\u001c\u0011\u0007\t-tAD\u0002\u0002t\u0002AqAa\u0017*\u0001\u0004\u0011y%\u0001\u0010mSN$8k\\;sG\u0016\u001cuN\\:v[\u0016\u0014xI]8va>3gm]3ugR!!\u0011\u000eB:\u0011\u001d\u0011YF\u000ba\u0001\u0005\u001f\n\u0001\u0004\\5ti\u000e{gn];nKJ<%o\\;q\u001f\u001a47/\u001a;t)!\u0011IG!\u001f\u0003|\tu\u0004b\u0002B.W\u0001\u0007!q\n\u0005\u0007/.\u0002\r!a\u0012\t\u000f\t}4\u00061\u0001\u0003\u0002\u0006A\u0011n]*pkJ\u001cW\rE\u0002F\u0005\u0007K1A!\"G\u0005\u001d\u0011un\u001c7fC:\f!\u0004[1oI2,7k\\;sG\u0016\fe\u000e\u001a#fgR|eMZ:fiN$\u0002\"a<\u0003\f\n5%\u0011\u0013\u0005\b\u0005\u0013a\u0003\u0019\u0001B\u0006\u0011\u001d\u0011y\t\fa\u0001\u0005S\n1c]8ve\u000e,wJ\u001a4tKR4U\u000f^;sKNDqAa%-\u0001\u0004\u0011I'A\teKN$xJ\u001a4tKR4U\u000f^;sKN\f\u0001'\\1q)>\u0004\u0018n\u0019)beRLG/[8o)>\u001cu.\\7jiR,Gm\u00144gg\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>tGC\u0002BM\u0005G\u0013Y\u000b\u0005\u0004eW\n}#1\u0014\t\u0007I.\u0014i*a\u0001\u0011\u0007\u0005\u0013y*C\u0002\u0003\"f\u0012QdQ8n[&$H/\u001a3PM\u001a\u001cX\r\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005Kk\u0003\u0019\u0001BT\u00035\u0019x.\u001e:dK>3gm]3ugB)Am\u001b8\u0003*B)Am\u001b@\u0002\u0004!9\u00111V\u0017A\u0002\t5\u0006cB#\u00030\nM&1Y\u0005\u0004\u0005c3%A\u0002+va2,'\u0007\u0005\u0004eW\n}#Q\u0017\t\u0005\u0005o\u0013iLD\u0002V\u0005sK1Aa/W\u0003Yi\u0015N\u001d:peR{\u0007/[2EKN\u001c'/\u001b9uS>t\u0017\u0002\u0002B`\u0005\u0003\u0014Qa\u0015;bi\u0016T1Aa/W!\u0015)\u0015\u0011\u0017B0\u0003UA\u0017M\u001c3mK\u0012+7o\u0019:jE\u0016l\u0015N\u001d:peN$B\"a<\u0003J\n-'Q\u001aBi\u0005?DqA!\u0003/\u0001\u0004\u0011Y\u0001C\u0004\u0003&:\u0002\rAa*\t\u000f\t=g\u00061\u0001\u0003(\u0006YA-Z:u\u001f\u001a47/\u001a;t\u0011\u001d\u0011\u0019N\fa\u0001\u0005+\fQ\u0003Z3tGJL'-Z'jeJ|'o\u001d$viV\u0014X\r\u0005\u0004eW\n}#q\u001b\t\u0005eV\u0014I\u000eE\u0002V\u00057L1A!8W\u0005Yi\u0015N\u001d:peR{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007b\u0002Bq]\u0001\u0007!1Y\u0001\re\u0016lw\u000e^3Qe\u00164\u0017\u000e_\u0001 i>\u001cu.\\7jiR,Gm\u00144gg\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>tGC\u0003BO\u0005O\u0014YOa<\u0003v\"1!\u0011^\u0018A\u00029\fQa\u001a:pkBDaA!<0\u0001\u0004q\u0018A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005c|\u0003\u0019\u0001Bz\u0003Y\u0011X-\\8uK6K'O]8s)>\u0004\u0018nY*uCR,\u0007#B#\u00022\nU\u0006b\u0002Bq_\u0001\u0007!1Y\u0001\u000eG>lW.\u001b;PM\u001a\u001cX\r^:\u0015\u0011\u0005=(1 B\u007f\u0005\u007fDqA!\u00031\u0001\u0004\u0011Y\u0001C\u0004\u0003&B\u0002\rA!'\t\u000f\t=\u0007\u00071\u0001\u0004\u0002A1Am\u001bB0\u0005S\u000b\u0001\u0006[1oI2,G)Z:uS:\fG/[8o\u00072,8\u000f^3s\u0007>lW.\u001b;uK\u0012|eMZ:fiN$\u0002\"a<\u0004\b\r%1Q\u0003\u0005\b\u0005\u0013\t\u0004\u0019\u0001B\u0006\u0011\u001d\u0019Y!\ra\u0001\u0007\u001b\tQbY8n[&$(+Z:vYR\u001c\bC\u00023l\u0005?\u001ay\u0001E\u0002V\u0007#I1aa\u0005W\u0005}\tE\u000e^3s\u0007>t7/^7fe\u001e\u0013x.\u001e9PM\u001a\u001cX\r^:SKN,H\u000e\u001e\u0005\b\u0005K\u000b\u0004\u0019\u0001BM\u0003\u001dygMZ:fiN$\u0002ba\u0007\u0004&\r\u001d21\u0006\t\b\u000b\n=&\u0011VB\u000f!\u0015)\u0015\u0011WB\u0010!\r\t5\u0011E\u0005\u0004\u0007GI$a\u0005+bg.,%O]8s\u0007>$W-\u00118e\u001bN<\u0007b\u0002Bue\u0001\u0007!q\f\u0005\u0007\u0007S\u0011\u0004\u0019A9\u0002\r\u0019,H/\u001e:f\u0011\u001d\u0011yH\ra\u0001\u0005\u0003\u000b\u0011c\u001c4gg\u0016$h)\u001a;dQ\u001a\u000b\u0017\u000e\\3e)\u0019\t)j!\r\u00044!9!qP\u001aA\u0002\t\u0005\u0005bBB\u001bg\u0001\u00071qG\u0001\u0002KB!1\u0011HB\"\u001d\u0011\u0019Yda\u0010\u000f\u0007\u0019\u001ci$C\u0001H\u0013\r\u0019\tER\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0019)ea\u0012\u0003\u0013QC'o\\<bE2,'bAB!\rR111JB)\u0007'\u00022!VB'\u0013\r\u0019yE\u0016\u0002\u001f\u0019&\u001cHoQ8ogVlWM]$s_V\u0004xJ\u001a4tKR\u001c(+Z:vYRDaa\u0016\u001bA\u0002\u0005\u001d\u0003bBB+i\u0001\u00071qK\u0001\u000bOJ|W\u000f]*qK\u000e\u001c\b#\u0002=~\u0005?\"\u0016\u0001I2p]\u001aLw-\u001e:fIR{\u0017J\\2mk\u0012,'+Z7pi\u0016l\u0015N\u001d:peN,\"A!!\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005U5\u0011\r\u0005\b\u0005[1\u0004\u0019AB2!\u0011\t\tp!\u001a\n\t\r\u001d\u0014Q\u0004\u0002\u0014\u0007>l\u0007\u000f\\3uK\u0012$\u0016m]6SKN,H\u000e^\u0001\u0010i\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]R\u0011\u0011q\u0019")
public class ClusterLinkSyncOffsets
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkDestClientManager clientManager;
    private final ClusterLinkMetadataManager metadataManager;
    private final ClusterLinkData linkData;
    private final ClusterLinkBatchAdmin remoteAdmin;
    private final ClusterLinkBatchAdmin localAdmin;
    private final ClusterLinkMetrics metrics;
    private ClusterLinkConfig config;
    private int tasksOutstanding;
    private Option<RemoteLinkMetadata> remoteLinkMetadata;
    private volatile Option<TaskDescription> taskDesc;
    private final DescribeMirrorsOptions describeMirrorsOptions;

    public static ListConsumerGroupOffsetsSpec ListOffsetsForAllPartitions() {
        return ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions();
    }

    public static int ListConsumerGroupOffsetBatchSize() {
        return ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize();
    }

    public ClusterLinkDestClientManager clientManager() {
        return this.clientManager;
    }

    public ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ClusterLinkConfig config() {
        return this.config;
    }

    private void config_$eq(ClusterLinkConfig x$1) {
        this.config = x$1;
    }

    private int tasksOutstanding() {
        return this.tasksOutstanding;
    }

    private void tasksOutstanding_$eq(int x$1) {
        this.tasksOutstanding = x$1;
    }

    private Option<RemoteLinkMetadata> remoteLinkMetadata() {
        return this.remoteLinkMetadata;
    }

    private void remoteLinkMetadata_$eq(Option<RemoteLinkMetadata> x$1) {
        this.remoteLinkMetadata = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    private DescribeMirrorsOptions describeMirrorsOptions() {
        return this.describeMirrorsOptions;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.config_$eq(this.clientManager().currentConfig());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName()) && this.config().consumerOffsetSyncEnable()) {
            ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
            if (this.tasksOutstanding() != 0) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Number of outstanding tasks was ").append(this.tasksOutstanding()).append(" at the beginning of run. Resetting to 0 and continuing on.").toString());
                this.tasksOutstanding_$eq(0);
            }
            if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isEmpty()) {
                return this.tryInitializeRemoteMirrorSyncingAndSyncOffsets(taskContext);
            }
            return this.syncOffsets(taskContext);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$);
    }

    private ClusterLinkScheduler.TaskResult syncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        if (this.config().consumerGroupFilters().isEmpty()) {
            String errMsg = new StringBuilder(91).append(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()).append(" is true but no consumer group filters are ").append("specified. No consumer offsets will be migrated.").toString();
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            TaskErrorCodeAndMsg err = new TaskErrorCodeAndMsg(MisconfigurationTaskErrorCode$.MODULE$, errMsg);
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)err, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())));
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempting to retrieve consumer groups from source cluster");
        ListConsumerGroupsResult listConsumerGroupsResult = this.remoteAdmin.listConsumerGroups();
        this.scheduleWhenComplete(listConsumerGroupsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleListConsumerGroupsResult((ClusterLinkScheduler.TaskContext)tc, listConsumerGroupsResult);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult tryInitializeRemoteMirrorSyncingAndSyncOffsets(ClusterLinkScheduler.TaskContext taskContext) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, this.linkData.linkName());
        DescribeConfigsResult result = this.remoteAdmin.describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)resource, (List)Nil$.MODULE$)).asJava());
        this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            return this.handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync((ClusterLinkScheduler.TaskContext)tc, resource, result);
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync(ClusterLinkScheduler.TaskContext taskContext, ConfigResource resource, DescribeConfigsResult result) {
        void var7_7;
        void var6_6;
        KafkaFuture configFuture = (KafkaFuture)result.values().get(resource);
        if (configFuture == null) {
            throw new IllegalStateException(new StringBuilder(37).append("Failed to find link ").append(this.linkData.linkName()).append(" in the response.").toString());
        }
        Tuple2 tuple2 = this.liftedTree1$1(configFuture);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Option configOpt = (Option)tuple2._1();
        Seq errs = (Seq)tuple2._2();
        void configOpt2 = var6_6;
        void errs2 = var7_7;
        configOpt2.foreach((Function1 & Serializable & scala.Serializable)linkConfig -> {
            ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$2(this, linkConfig);
            return BoxedUnit.UNIT;
        });
        return this.syncOffsets(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)errs2, Seq$.MODULE$.canBuildFrom()))));
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkScheduler.TaskResult handleListConsumerGroupsResult(ClusterLinkScheduler.TaskContext taskContext, ListConsumerGroupsResult listConsumerGroupsResult) {
        void var5_5;
        void var4_4;
        Tuple2 tuple2 = this.liftedTree2$1(listConsumerGroupsResult, taskContext);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Collection consumerGroupListing = (Collection)tuple2._1();
        Option errOpt = (Option)tuple2._2();
        void consumerGroupListing2 = var4_4;
        void errOpt2 = var5_5;
        if (errOpt2 instanceof Some) {
            return (ClusterLinkScheduler.TaskResult)((Some)errOpt2).value();
        }
        if (None$.MODULE$.equals(errOpt2)) {
            scala.collection.immutable.Set<MatchedGroup> filteredGroups = this.filterConsumerGroups((scala.collection.immutable.Set<String>)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)consumerGroupListing2).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.groupId(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet());
            return this.handleFilteredGroups(taskContext, filteredGroups);
        }
        throw new MatchError((Object)errOpt2);
    }

    private ClusterLinkScheduler.TaskResult handleFilteredGroups(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Set<MatchedGroup> filteredGroups) {
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures = this.listDestConsumerGroupOffsets(filteredGroups);
        scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures = this.listSourceConsumerGroupOffsets(filteredGroups);
        if (sourceOffsetFutures.nonEmpty()) {
            Iterable futures = (Iterable)sourceOffsetFutures.values().$plus$plus((GenTraversableOnce)destOffsetFutures.values(), scala.collection.Iterable$.MODULE$.canBuildFrom());
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])futures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleSourceAndDestOffsets((ClusterLinkScheduler.TaskContext)tc, sourceOffsetFutures, destOffsetFutures);
            }, taskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<MatchedGroup> filterConsumerGroups(scala.collection.immutable.Set<String> groups) {
        void var5_5;
        void var4_4;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Filtering consumer groups ").append(groups).append(" to match consumer group JSON").toString());
        Option<String> clusterLinkPrefix = Predef$.MODULE$.Boolean2boolean(this.config().clusterLinkPrefixConsumerGroupEnable()) ? this.config().clusterLinkPrefix() : None$.MODULE$;
        Tuple2<scala.collection.immutable.Set<MatchedGroup>, Seq<ClusterLinkFilterInfo>> tuple2 = ClusterLinkUtils$.MODULE$.doFilterGroups(groups, this.config().consumerGroupFilters(), this.linkData.tenantPrefix(), clusterLinkPrefix, this.config().linkMode());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)tuple2._1();
        Seq unusedFilters = (Seq)tuple2._2();
        void filtered2 = var4_4;
        var5_5.foreach((Function1 & Serializable & scala.Serializable)unusedFilter -> {
            ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$2(this, unusedFilter);
            return BoxedUnit.UNIT;
        });
        this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ClusterLinkSyncOffsets.$anonfun$filterConsumerGroups$4((scala.collection.immutable.Set)filtered2)));
        return filtered2;
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listDestConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.localAdmin, false);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listSourceConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups) {
        return this.listConsumerGroupOffsets(groups, this.remoteAdmin, true);
    }

    private scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> listConsumerGroupOffsets(scala.collection.immutable.Set<MatchedGroup> groups, ClusterLinkBatchAdmin admin, boolean isSource) {
        String targetCluster = isSource ? "source" : "destination";
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster).append(" cluster for following consumer groups: ").append(groups).toString());
        scala.collection.mutable.Map groupFutures = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            groups.grouped(ClusterLinkSyncOffsets$.MODULE$.ListConsumerGroupOffsetBatchSize()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$2(this, targetCluster, admin, groupFutures, batch);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable ex) {
            this.offsetFetchFailed(isSource, ex);
        }
        return groupFutures.toMap(Predef$.MODULE$.$conforms());
    }

    private ClusterLinkScheduler.TaskResult handleSourceAndDestOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> sourceOffsetFutures, scala.collection.immutable.Map<MatchedGroup, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>> destOffsetFutures) {
        scala.collection.immutable.Map sourceGroupToOffsets = (scala.collection.immutable.Map)sourceOffsetFutures.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), true)), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map sourceOffsets = (scala.collection.immutable.Map)sourceGroupToOffsets.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq sourceErrs = (Seq)((TraversableLike)((MapLike)sourceGroupToOffsets.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).values().toSeq().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.nonEmpty()))).map((Function1 & Serializable & scala.Serializable)x$9 -> (TaskErrorCodeAndMsg)x$9.get(), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map destGroupToOffsets = (scala.collection.immutable.Map)destOffsetFutures.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(groupAndOffsetInfo._1()), this.offsets(((MatchedGroup)groupAndOffsetInfo._1()).name(), (KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>>)((KafkaFuture)groupAndOffsetInfo._2()), false)), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map destOffsets = (scala.collection.immutable.Map)destGroupToOffsets.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._1()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        Seq destErrs = (Seq)((TraversableLike)((MapLike)destGroupToOffsets.map((Function1 & Serializable & scala.Serializable)groupAndOffsetInfo -> new Tuple2(groupAndOffsetInfo._1(), ((Tuple2)groupAndOffsetInfo._2())._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).values().toSeq().filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.nonEmpty()))).map((Function1 & Serializable & scala.Serializable)x$11 -> (TaskErrorCodeAndMsg)x$11.get(), Seq$.MODULE$.canBuildFrom());
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)((TraversableLike)taskContext.errs().$plus$plus((GenTraversableOnce)sourceErrs, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)destErrs, Seq$.MODULE$.canBuildFrom())));
        if (this.configuredToIncludeRemoteMirrors() && this.remoteLinkMetadata().isDefined()) {
            Option<String> remotePrefix = ((RemoteLinkMetadata)this.remoteLinkMetadata().get()).remotePrefix();
            scala.collection.immutable.Set topics = (scala.collection.immutable.Set)((scala.collection.immutable.MapLike)sourceOffsets.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (scala.collection.immutable.Map)x$12._2(), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).keySet().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.topic(), Set$.MODULE$.canBuildFrom());
            DescribeMirrorsResult describeMirrorsResult = this.remoteAdmin.describeActiveMirrors((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)topics).asJava(), this.describeMirrorsOptions());
            this.scheduleWhenComplete(describeMirrorsResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> {
                this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
                return this.handleDescribeMirrors((ClusterLinkScheduler.TaskContext)tc, (scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)destOffsets, (scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>>)((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(describeMirrorsResult.result()).asScala()).toMap(Predef$.MODULE$.$conforms()), remotePrefix);
            }, newTaskContext));
            this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
            return ClusterLinkScheduler$.MODULE$.inProgressTask(newTaskContext.errs());
        }
        return this.commitOffsets(newTaskContext, this.mapTopicPartitionToCommittedOffsetTopicPartition((scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)None$.MODULE$)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
    }

    private scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> mapTopicPartitionToCommittedOffsetTopicPartition(scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>> remoteLinkMetadata) {
        return (scala.collection.immutable.Map)sourceOffsets.map((Function1 & Serializable & scala.Serializable)groupToTopicPartitionToOffsetMetadata -> {
            scala.collection.immutable.Map mappedTopicPartitionAndOffsetMetadataMap = (scala.collection.immutable.Map)((TraversableLike)groupToTopicPartitionToOffsetMetadata._2()).map((Function1 & Serializable & scala.Serializable)topicPartitionToOffsetMetadata -> {
                TopicPartition topicPartition = (TopicPartition)topicPartitionToOffsetMetadata._1();
                String sourceTopicName = topicPartition.topic();
                return new Tuple2((Object)this.toCommittedOffsetTopicPartition((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1(), topicPartition, (Option<MirrorTopicDescription.State>)((MapLike)remoteLinkMetadata._1()).get((Object)sourceTopicName), (Option<String>)((Option)remoteLinkMetadata._2())), topicPartitionToOffsetMetadata._2());
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new Tuple2((Object)((MatchedGroup)groupToTopicPartitionToOffsetMetadata._1()).name(), (Object)mappedTopicPartitionAndOffsetMetadataMap);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    private ClusterLinkScheduler.TaskResult handleDescribeMirrors(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<MatchedGroup, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets, scala.collection.immutable.Map<String, KafkaFuture<MirrorTopicDescription>> describeMirrorsFuture, Option<String> remotePrefix) {
        scala.collection.immutable.Map describeMirrorAndErrors = (scala.collection.immutable.Map)describeMirrorsFuture.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 tuple2;
                String topic = (String)x0$1._1();
                try {
                    MirrorTopicDescription mirrorTopicDescription = (MirrorTopicDescription)((KafkaFuture)x0$1._2()).get();
                    if (mirrorTopicDescription != null) {
                        return new Tuple2((Object)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)mirrorTopicDescription)), (Object)None$.MODULE$);
                    }
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                }
                catch (ExecutionException ex) {
                    KafkaException kafkaException;
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to describe remote mirror.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
                    Throwable throwable = ex.getCause();
                    Some taskErrorCodeAndMsg = throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authentication issues.")) : (throwable instanceof AuthorizationException ? new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to describe remote mirror due to authorization issues.")) : (throwable instanceof ClusterLinkNotFoundException ? None$.MODULE$ : new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to describe remote mirror for an unknown reason."))));
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)taskErrorCodeAndMsg);
                }
                return tuple2;
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map remoteMirrors = (scala.collection.immutable.Map)((scala.collection.immutable.Map)((TraversableLike)describeMirrorAndErrors.filter((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$4(x$14)))).map((Function1 & Serializable & scala.Serializable)x$15 -> (Tuple2)((Option)x$15._1()).get(), scala.collection.immutable.Map$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String topic = (String)x0$2._1();
                MirrorTopicDescription desc = (MirrorTopicDescription)x0$2._2();
                if (desc.linkName().equals($this.linkData.linkName()) && desc.clusterLinkId().equals((Object)$this.linkData.linkId())) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)desc.state())));
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Filtering out ").append(topic).append(" from a different link ").append(desc.linkName()).append(" ").append(desc.clusterLinkId()).append(".").toString());
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return this.commitOffsets(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((GenTraversableOnce)((TraversableOnce)((TraversableLike)describeMirrorAndErrors.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeMirrors$8(x$16)))).map((Function1 & Serializable & scala.Serializable)x$17 -> (TaskErrorCodeAndMsg)((Option)x$17._2()).get(), Iterable$.MODULE$.canBuildFrom())).toSeq(), Seq$.MODULE$.canBuildFrom()))), this.mapTopicPartitionToCommittedOffsetTopicPartition(sourceOffsets, (Tuple2<scala.collection.immutable.Map<String, MirrorTopicDescription.State>, Option<String>>)new Tuple2((Object)remoteMirrors, remotePrefix)), (scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)destOffsets.map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2((Object)((MatchedGroup)kv._1()).name(), kv._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom())));
    }

    private CommittedOffsetTopicPartition toCommittedOffsetTopicPartition(MatchedGroup group, TopicPartition topicPartition, Option<MirrorTopicDescription.State> remoteMirrorTopicState, Option<String> remotePrefix) {
        boolean isRemoteMirror = remoteMirrorTopicState.isDefined();
        Option localMirrorTopicsState = this.metadataManager().mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicPartition.topic()})))).get((Object)topicPartition.topic());
        boolean isLocalMirror = localMirrorTopicsState.isDefined();
        if (isRemoteMirror && isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isLocalMirror) {
            return new LocalMirrorTopic(topicPartition, (Option<TopicLinkState>)new Some((Object)((ClusterLinkTopicState)localMirrorTopicsState.get()).state()), group);
        }
        if (isRemoteMirror) {
            return new RemoteMirrorTopic(topicPartition, (MirrorTopicDescription.State)remoteMirrorTopicState.get(), this.linkData, this.config().clusterLinkPrefix(), remotePrefix, group);
        }
        return new RegularTopic(topicPartition);
    }

    private ClusterLinkScheduler.TaskResult commitOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets, scala.collection.immutable.Map<String, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> destOffsets) {
        scala.collection.immutable.Map commitResults = (scala.collection.immutable.Map)sourceOffsets.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                scala.collection.immutable.Map map;
                String consumerGroup = (String)x0$1._1();
                scala.collection.immutable.Map offsetMetadata = (scala.collection.immutable.Map)x0$1._2();
                Option option = destOffsets.get((Object)consumerGroup);
                if (option instanceof Some) {
                    map = (scala.collection.immutable.Map)((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    map = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError((Object)option);
                }
                scala.collection.immutable.Map destTopicPartition = map;
                scala.collection.immutable.Map offsetsToCommit = (scala.collection.immutable.Map)offsetMetadata.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$2(this, consumerGroup, destTopicPartition, x0$2)));
                if (offsetsToCommit.nonEmpty()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Committing offsets on destination cluster for consumer group ").append(consumerGroup).append(": ").append(offsetsToCommit).toString());
                    scala.collection.immutable.Map offsetAndMetadataToCommit = (scala.collection.immutable.Map)offsetsToCommit.map((Function1 & Serializable & scala.Serializable)keyVal -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((CommittedOffsetTopicPartition)keyVal._1()).destTopic()), keyVal._2()), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)consumerGroup), (Object)$this.localAdmin.alterConsumerGroupOffsets(consumerGroup, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetAndMetadataToCommit).asJava()))));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError(null);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        if (commitResults.nonEmpty()) {
            return this.handleDestinationClusterCommittedOffsets(taskContext, (scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult>)commitResults, sourceOffsets);
        }
        return ClusterLinkScheduler$.MODULE$.completedTask(taskContext.errs());
    }

    private ClusterLinkScheduler.TaskResult handleDestinationClusterCommittedOffsets(ClusterLinkScheduler.TaskContext taskContext, scala.collection.immutable.Map<String, AlterConsumerGroupOffsetsResult> commitResults, scala.collection.immutable.Map<String, scala.collection.immutable.Map<CommittedOffsetTopicPartition, OffsetAndMetadata>> sourceOffsets) {
        KafkaFuture allCommitFutures = KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])((TraversableOnce)commitResults.values().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.all(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class))));
        this.scheduleWhenComplete(allCommitFutures, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable & scala.Serializable)tc -> {
            this.tasksOutstanding_$eq(this.tasksOutstanding() - 1);
            ExcessiveLoggingHandler excessiveLoggingHandler = ExcessiveLoggingHandler$.MODULE$.apply(ExcessiveLoggingHandler$.MODULE$.apply$default$1(), ExcessiveLoggingHandler$.MODULE$.apply$default$2(), ExcessiveLoggingHandler$.MODULE$.apply$default$3());
            scala.collection.immutable.Iterable errs = (scala.collection.immutable.Iterable)commitResults.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String group = (String)x0$1._1();
                    try {
                        ((AlterConsumerGroupOffsetsResult)x0$1._2()).all().get();
                        ((IterableLike)sourceOffsets.apply((Object)group)).foreach((Function1 & Serializable & scala.Serializable)topicPartitionAndOffsetMetadata -> {
                            ClusterLinkSyncOffsets.$anonfun$handleDestinationClusterCommittedOffsets$4(this, group, topicPartitionAndOffsetMetadata);
                            return BoxedUnit.UNIT;
                        });
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    catch (ExecutionException ex) {
                        KafkaException kafkaException;
                        Throwable throwable = ex.getCause();
                        if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                            String errMsg = new StringBuilder(98).append("Unable to commit offsets for group ").append(group).append(" on the destination due to authentication issues on the broker.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, errMsg)));
                        }
                        if (throwable instanceof UnknownMemberIdException) {
                            String errMsg = new StringBuilder(132).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster because there are active members on the destination already.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(ConsumerGroupInUseTaskErrorCode$.MODULE$, errMsg)));
                        }
                        if (throwable instanceof GroupAuthorizationException) {
                            GroupAuthorizationException groupAuthorizationException = (GroupAuthorizationException)throwable;
                            String errMsg = new StringBuilder(296).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster due to group authorization issues on the broker.").append(" Please add READ ACLs for the consumer group. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString();
                            excessiveLoggingHandler.handle((Throwable)groupAuthorizationException, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(70).append("Unable to commit offsets for group ").append(group).append(" due to group authorization issues.").toString())));
                        }
                        if (throwable instanceof TopicAuthorizationException) {
                            String errMsg = new StringBuilder(303).append("Unable to commit offsets for consumer group ").append(group).append(" on the destination cluster due to topic authorization issues on the broker.").append(" Please add READ ACLs for the topics being migrated. This action is taken by the inter-broker principal defined in the broker ").append("configuration so ACLs should be added for this principal.").toString();
                            excessiveLoggingHandler.handle(ex, this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(70).append("Unable to commit offsets for group ").append(group).append(" due to topic authorization issues.").toString())));
                        }
                        if (throwable instanceof UnknownTopicOrPartitionException) {
                            String errMsg = new StringBuilder(102).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster due to unknown topic or partition.").toString();
                            excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply((Object)ex.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ex), this, errMsg);
                            $this.metrics.consumerOffsetCommitFailedSensor().record();
                            return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(UnknownTopicOrPartitionErrorCode$.MODULE$, errMsg)));
                        }
                        String errMsg = new StringBuilder(90).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster for an unknown reason.").toString();
                        excessiveLoggingHandler.handle((Throwable)Option$.MODULE$.apply((Object)ex.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ex), this, errMsg);
                        $this.metrics.consumerOffsetCommitFailedSensor().record();
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
                    }
                    catch (Throwable ex) {
                        String errMsg = new StringBuilder(99).append("Unable to commit offsets for consumer group ").append(group).append(" on destination cluster due to an unexpected exception.").toString();
                        excessiveLoggingHandler.handle(ex, this, errMsg);
                        $this.metrics.consumerOffsetCommitFailedSensor().record();
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg)));
                    }
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom());
            return ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)tc.errs().$plus$plus((GenTraversableOnce)errs, Seq$.MODULE$.canBuildFrom())));
        }, taskContext));
        this.tasksOutstanding_$eq(this.tasksOutstanding() + 1);
        return ClusterLinkScheduler$.MODULE$.inProgressTask(taskContext.errs());
    }

    private Tuple2<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>, Option<TaskErrorCodeAndMsg>> offsets(String group, KafkaFuture<java.util.Map<TopicPartition, OffsetAndMetadata>> future, boolean isSource) {
        try {
            return new Tuple2((Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)future.get()).asScala()).map((Function1 & Serializable & scala.Serializable)topicPartitionAndOffsetMetadata -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartitionAndOffsetMetadata._1()), topicPartitionAndOffsetMetadata._2()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            Throwable throwable;
            KafkaException kafkaException2;
            Throwable throwable2;
            this.offsetFetchFailed(isSource, ex);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Failed to get offsets for group ").append(group).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> ex);
            TaskErrorCodeAndMsg taskErrorCodeAndMsg = isSource ? ((throwable2 = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException2 = (KafkaException)throwable2) ? new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, new StringBuilder(90).append("Failed to get offsets for group ").append(group).append(" on the source due to authentication issues with the link.").toString()) : (throwable2 instanceof AuthorizationException ? new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, new StringBuilder(89).append("Failed to get offsets for group ").append(group).append(" on the source due to authorization issues with the link.").toString()) : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(69).append("Failed to get offsets for group ").append(group).append(" on the source for an unknown reason.").toString()))) : ((throwable = ex.getCause()) instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable) ? new TaskErrorCodeAndMsg(BrokerAuthenticationTaskErrorCode$.MODULE$, new StringBuilder(95).append("Failed to get offsets for group ").append(group).append(" on the destination due to authentication issues on the broker.").toString()) : (throwable instanceof AuthorizationException ? new TaskErrorCodeAndMsg(BrokerAuthorizationTaskErrorCode$.MODULE$, new StringBuilder(94).append("Failed to get offsets for group ").append(group).append(" on the destination due to authorization issues on the broker.").toString()) : new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(74).append("Failed to get offsets for group ").append(group).append(" on the destination for an unknown reason.").toString())));
            TaskErrorCodeAndMsg err = taskErrorCodeAndMsg;
            return new Tuple2((Object)Predef$.MODULE$.Map().empty(), (Object)new Some((Object)err));
        }
    }

    private void offsetFetchFailed(boolean isSource, Throwable e) {
        if (isSource) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Unable to list consumer group offsets on source cluster. Offsets will not be migrated. ").append(e).toString());
            this.metrics.listConsumerGroupOffsetsFromSourceFailedSensor().record();
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(110).append("Unable to list consumer group offsets on destination cluster. All available source offsets will be committed. ").append(e).toString());
        this.metrics.listConsumerGroupOffsetsFromDestinationFailedSensor().record();
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(ClusterLinkBatchAdmin admin, java.util.Map<String, ListConsumerGroupOffsetsSpec> groupSpecs) {
        return admin.listConsumerGroupOffsets(groupSpecs);
    }

    private boolean configuredToIncludeRemoteMirrors() {
        return this.config().linkMode().equals((Object)ClusterLinkConfig.LinkMode.BIDIRECTIONAL) && this.config().consumerGroupFilters().exists((Function1 & Serializable & scala.Serializable)groupFiltersJson -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$1(this, groupFiltersJson)));
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager().isLinkCoordinator(this.linkData.linkName())) {
            if (this.config().consumerOffsetSyncEnable()) {
                this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkSyncOffsetsTaskType$.MODULE$, false, "run the consumer offsets sync task"));
                return;
            }
            this.taskDesc_$eq((Option<TaskDescription>)new Some((Object)new TaskDescription(NotConfiguredTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$)));
            return;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
    }

    @Override
    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(KafkaFuture configFuture$1) {
        try {
            return new Tuple2((Object)new Some(configFuture$1.get()), (Object)Nil$.MODULE$);
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(81).append("Failed to get remote link config on the remote cluster for bi-directional link ").append($this.linkData.linkName()).append(". ").append(ex).toString());
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authentication issues."), (List)Nil$.MODULE$));
            }
            if (throwable instanceof AuthorizationException) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Failed to get remote link config due to authorization issues."), (List)Nil$.MODULE$));
            }
            if (throwable instanceof ClusterLinkNotFoundException) {
                return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(RemoteLinkNotFoundTaskErrorCode$.MODULE$, "Failed to get remote link config due to link not being found on the remote cluster."), (List)Nil$.MODULE$));
            }
            return new Tuple2((Object)None$.MODULE$, (Object)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to get remote link config for an unknown reason."), (List)Nil$.MODULE$));
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$4(String x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$2(ClusterLinkSyncOffsets $this, Config linkConfig) {
        ConfigEntry prefix = linkConfig.get(ClusterLinkConfig$.MODULE$.ClusterLinkPrefixProp());
        Option remotePrefix = Option$.MODULE$.apply((Object)prefix).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$4(x$3))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$handleDescribeConfigsResponseToInitializeRemoteMirrorSyncingAndSync$5(x$4)));
        $this.remoteLinkMetadata_$eq((Option<RemoteLinkMetadata>)new Some((Object)new RemoteLinkMetadata((Option<String>)remotePrefix)));
    }

    private final /* synthetic */ Tuple2 liftedTree2$1(ListConsumerGroupsResult listConsumerGroupsResult$2, ClusterLinkScheduler.TaskContext taskContext$1) {
        try {
            Collection result = (Collection)listConsumerGroupsResult$2.all().get();
            return new Tuple2((Object)result, (Object)None$.MODULE$);
        }
        catch (ExecutionException ex) {
            KafkaException kafkaException;
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Unable to list consumer group offsets. Offsets will not be migrated. ").append(ex).toString());
            this.metrics.listConsumerGroupsFromSourceFailedSensor().record();
            Throwable throwable = ex.getCause();
            if (throwable instanceof KafkaException && ClusterLinkUtils$.MODULE$.isAuthenticationException(kafkaException = (KafkaException)throwable)) {
                return new Tuple2(null, (Object)new Some((Object)ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext$1.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authentication issues."), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())))));
            }
            if (throwable instanceof AuthorizationException) {
                return new Tuple2(null, (Object)new Some((Object)ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext$1.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, "Unable to list consumer groups due to authorization issues."), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())))));
            }
            return new Tuple2(null, (Object)new Some((Object)ClusterLinkScheduler$.MODULE$.completedTask((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext$1.errs().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Unable to list consumer groups for an unknown reason."), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())))));
        }
    }

    public static final /* synthetic */ void $anonfun$filterConsumerGroups$2(ClusterLinkSyncOffsets $this, ClusterLinkFilterInfo unusedFilter) {
        String string = unusedFilter.configuredFilter().filterType();
        String string2 = "EXCLUDE";
        if (string == null || !string.equals(string2)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(199).append("The filter ").append(unusedFilter).append(" does not match any consumer group. This filter may not be ").append("required or the groups it referred to may not have the correct DESCRIBE ACL ").append("for the cluster link principal on the source cluster.").toString());
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$filterConsumerGroups$4(scala.collection.immutable.Set filtered$1) {
        return new StringBuilder(26).append("Filtered consumer groups: ").append(filtered$1).toString();
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$5(ListConsumerGroupOffsetsResult result$2, scala.collection.mutable.Map groupFutures$1, MatchedGroup group) {
        Option$.MODULE$.apply((Object)result$2.partitionsToOffsetAndMetadata(group.name())).foreach((Function1 & Serializable & scala.Serializable)offsets -> (scala.collection.mutable.Map)groupFutures$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), offsets)));
    }

    public static final /* synthetic */ void $anonfun$listConsumerGroupOffsets$2(ClusterLinkSyncOffsets $this, String targetCluster$1, ClusterLinkBatchAdmin admin$1, scala.collection.mutable.Map groupFutures$1, scala.collection.immutable.Set batch) {
        $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Listing consumer group offsets on ").append(targetCluster$1).append(" cluster for following consumer groups: ").append(batch).toString());
        java.util.Map groupMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)batch.map((Function1 & Serializable & scala.Serializable)g -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)g.name()), (Object)ClusterLinkSyncOffsets$.MODULE$.ListOffsetsForAllPartitions()), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        ListConsumerGroupOffsetsResult result = $this.listConsumerGroupOffsets(admin$1, groupMap);
        batch.foreach((Function1 & Serializable & scala.Serializable)group -> {
            ClusterLinkSyncOffsets.$anonfun$listConsumerGroupOffsets$5(result, groupFutures$1, group);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$4(Tuple2 x$14) {
        return ((Option)x$14._1()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeMirrors$8(Tuple2 x$16) {
        return ((Option)x$16._2()).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$commitOffsets$3(CommittedOffsetTopicPartition tp$1, String reason$1) {
        return new StringBuilder(36).append("Not committing offsets for ").append(tp$1).append(" because ").append(reason$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$commitOffsets$5(OffsetAndMetadata sourceOffset$1, OffsetAndMetadata destOffset) {
        return destOffset != null && destOffset.offset() == sourceOffset$1.offset();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$commitOffsets$2(ClusterLinkSyncOffsets $this, String consumerGroup$1, scala.collection.immutable.Map destTopicPartition$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            void var7_7;
            CommittedOffsetTopicPartition tp = (CommittedOffsetTopicPartition)x0$2._1();
            OffsetAndMetadata sourceOffset = (OffsetAndMetadata)x0$2._2();
            Tuple2<Object, String> tuple2 = tp.shouldSync();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            boolean shouldSync = tuple2._1$mcZ$sp();
            String reason = (String)tuple2._2();
            if (var7_7 == false) {
                void var8_8;
                $this.trace((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> ClusterLinkSyncOffsets.$anonfun$commitOffsets$3(tp, (String)var8_8)));
                return false;
            }
            if (sourceOffset == null) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("Not committing offsets for ").append(tp).append(" since no committed offset exists on the source cluster for ").append(consumerGroup$1).toString());
                return false;
            }
            if (destTopicPartition$1.get((Object)tp.destTopic()).exists((Function1 & Serializable & scala.Serializable)destOffset -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$commitOffsets$5(sourceOffset, destOffset)))) {
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Not committing offsets for ").append(tp).append(" since offset=").append(sourceOffset).append(" is already committed on the destination.").toString());
                return false;
            }
            return true;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$handleDestinationClusterCommittedOffsets$4(ClusterLinkSyncOffsets $this, String group$2, Tuple2 topicPartitionAndOffsetMetadata) {
        if (((CommittedOffsetTopicPartition)topicPartitionAndOffsetMetadata._1()).shouldSync()._1$mcZ$sp()) {
            $this.metrics.consumerOffsetCommitSensor().record();
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Committed offsets on destination cluster for consumer group ").append(group$2).toString());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$2(ClusterLinkSyncOffsets $this, GroupClusterLinkFilter filter) {
        return FilterType$.MODULE$.fromString(filter.filterType()).contains((Object)FilterType$.MODULE$.INCLUDE()) && filter.effectiveTopicTypes($this.config().linkMode()).contains((Object)TopicType$.MODULE$.REMOTE_MIRROR());
    }

    public static final /* synthetic */ boolean $anonfun$configuredToIncludeRemoteMirrors$1(ClusterLinkSyncOffsets $this, GroupFilterJson groupFiltersJson) {
        return groupFiltersJson.filters().exists((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncOffsets.$anonfun$configuredToIncludeRemoteMirrors$2($this, filter)));
    }

    public ClusterLinkSyncOffsets(ClusterLinkDestClientManager clientManager, ClusterLinkMetadataManager metadataManager, ClusterLinkData linkData, ClusterLinkBatchAdmin remoteAdmin, ClusterLinkBatchAdmin localAdmin, ClusterLinkMetrics metrics, Time time, ClusterLinkRequestQuota quota) {
        this.clientManager = clientManager;
        this.metadataManager = metadataManager;
        this.linkData = linkData;
        this.remoteAdmin = remoteAdmin;
        this.localAdmin = localAdmin;
        this.metrics = metrics;
        super(clientManager.scheduler(), "ClusterLinkSyncOffsets", Predef$.MODULE$.Integer2int(clientManager.currentConfig().consumerOffsetSyncMs()), time, quota);
        this.config = clientManager.currentConfig();
        this.tasksOutstanding = 0;
        this.remoteLinkMetadata = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(4).append("[").append(this.getClass().getSimpleName()).append("-").append(linkData.linkName()).append("] ").toString());
        this.taskDesc = None$.MODULE$;
        this.describeMirrorsOptions = new DescribeMirrorsOptions().linkNames(Collections.singleton(linkData.linkName())).states(Collections.singleton(MirrorTopicDescription.State.ACTIVE.name()));
    }
}

