/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import kafka.server.link.AclLimitExceededTaskErrorCode$;
import kafka.server.link.ActiveTaskState$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.BrokerAuthenticationTaskErrorCode$;
import kafka.server.link.BrokerAuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkAutoMirroringTaskType$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAclsTaskType$;
import kafka.server.link.ClusterLinkSyncOffsetsTaskType$;
import kafka.server.link.ClusterLinkSyncTopicConfigsTaskType$;
import kafka.server.link.ConsumerGroupInUseTaskErrorCode$;
import kafka.server.link.InErrorTaskState$;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidRequestErrorCode$;
import kafka.server.link.InvalidTopicTaskErrorCode$;
import kafka.server.link.LinkCoordinatorNotEnabledTaskErrorCode$;
import kafka.server.link.LinkFailedTaskState$;
import kafka.server.link.LinkNotFoundTaskErrorCode$;
import kafka.server.link.LinkPausedTaskState$;
import kafka.server.link.LinkUnavailableTaskState$;
import kafka.server.link.MisconfigurationTaskErrorCode$;
import kafka.server.link.NoErrorCode$;
import kafka.server.link.NotConfiguredTaskState$;
import kafka.server.link.PolicyViolationTaskErrorCode$;
import kafka.server.link.RemoteLinkNotFoundTaskErrorCode$;
import kafka.server.link.RemoteMirrorNotFoundTaskErrorCode$;
import kafka.server.link.SecurityDisabledTaskErrorCode$;
import kafka.server.link.SuppressedErrorsErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCode;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TaskState;
import kafka.server.link.TaskType;
import kafka.server.link.TopicExistsTaskErrorCode$;
import kafka.server.link.UnknownTaskState$;
import kafka.server.link.UnknownTopicOrPartitionErrorCode$;
import org.apache.kafka.clients.admin.ClusterLinkTaskDescription;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class ClusterLinkTask$ {
    public static ClusterLinkTask$ MODULE$;

    static {
        new ClusterLinkTask$();
    }

    public boolean isRetriableException(Throwable ex) {
        if (ex instanceof RetriableException) {
            return true;
        }
        if (ex instanceof AuthorizationException) {
            return true;
        }
        if (ex != null) {
            return false;
        }
        throw new MatchError(null);
    }

    public Option<TaskDescription> handleResult(ClusterLinkScheduler.CompletedTaskResult result, ClusterLinkFactory.LinkMetrics metrics, TaskType taskType, boolean isMirrorStateTransition, String description) {
        if (result.errs().isEmpty() && result.ex().isEmpty()) {
            metrics.clusterLinkTaskActiveSensor(taskType, isMirrorStateTransition).record();
            return new Some((Object)new TaskDescription(ActiveTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)Nil$.MODULE$));
        }
        Seq errs = (Seq)result.errs().$plus$plus((GenTraversableOnce)result.ex().map((Function1 & Serializable & scala.Serializable)x$1 -> new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, new StringBuilder(33).append("Failed to ").append(description).append(" for an unknown reason.").toString()), (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        errs.foreach((Function1 & Serializable & scala.Serializable)err -> {
            ClusterLinkTask$.$anonfun$handleResult$3(metrics, taskType, isMirrorStateTransition, err);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)new TaskDescription(InErrorTaskState$.MODULE$, (Seq<TaskErrorCodeAndMsg>)errs));
    }

    public ClusterLinkTaskDescription.ClusterLinkTaskState toAdminClientState(TaskState state) {
        if (ActiveTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.ACTIVE;
        }
        if (InErrorTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.IN_ERROR;
        }
        if (NotConfiguredTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.NOT_CONFIGURED;
        }
        if (UnknownTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.UNKNOWN;
        }
        if (LinkFailedTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_FAILED;
        }
        if (LinkUnavailableTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_UNAVAILABLE;
        }
        if (LinkPausedTaskState$.MODULE$.equals(state)) {
            return ClusterLinkTaskDescription.ClusterLinkTaskState.LINK_PAUSED;
        }
        throw new IllegalStateException(new StringBuilder(17).append("Unexpected state ").append(state.name()).toString());
    }

    public ClusterLinkTaskError toAdminClientError(TaskErrorCode errorCode, String errMsg) {
        ClusterLinkTaskError.ClusterLinkTaskErrorCode clusterLinkTaskErrorCode;
        if (NoErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.NO_ERROR;
        } else if (InternalTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INTERNAL_ERROR;
        } else if (AuthenticationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHENTICATION_ERROR;
        } else if (BrokerAuthenticationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.BROKER_AUTHENTICATION_ERROR;
        } else if (MisconfigurationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.MISCONFIGURATION_ERROR;
        } else if (RemoteLinkNotFoundTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.REMOTE_LINK_NOT_FOUND_ERROR;
        } else if (RemoteMirrorNotFoundTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.REMOTE_MIRROR_NOT_FOUND_ERROR;
        } else if (LinkNotFoundTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.LINK_NOT_FOUND_ERROR;
        } else if (ConsumerGroupInUseTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.CONSUMER_GROUP_IN_USE_ERROR;
        } else if (AuthorizationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.AUTHORIZATION_ERROR;
        } else if (BrokerAuthorizationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.BROKER_AUTHORIZATION_ERROR;
        } else if (SecurityDisabledTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.SECURITY_DISABLED_ERROR;
        } else if (TopicExistsTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.TOPIC_EXISTS_ERROR;
        } else if (InvalidTopicTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INVALID_TOPIC;
        } else if (PolicyViolationTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.POLICY_VIOLATION_ERROR;
        } else if (LinkCoordinatorNotEnabledTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.LINK_COORDINATOR_NOT_ENABLED_ERROR;
        } else if (AclLimitExceededTaskErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.ACL_LIMIT_EXCEEDED;
        } else if (UnknownTopicOrPartitionErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.UNKNOWN_TOPIC_OR_PARTITION_ERROR;
        } else if (InvalidRequestErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.INVALID_REQUEST_ERROR;
        } else if (SuppressedErrorsErrorCode$.MODULE$.equals(errorCode)) {
            clusterLinkTaskErrorCode = ClusterLinkTaskError.ClusterLinkTaskErrorCode.SUPPRESSED_ERRORS;
        } else {
            throw new IllegalStateException(new StringBuilder(22).append("Unexpected error code ").append(errorCode.name()).toString());
        }
        ClusterLinkTaskError.ClusterLinkTaskErrorCode adminClientErrCode = clusterLinkTaskErrorCode;
        return new ClusterLinkTaskError(adminClientErrCode, errMsg);
    }

    public String toAdminClientTaskName(TaskType taskType) {
        if (ClusterLinkSyncOffsetsTaskType$.MODULE$.equals(taskType)) {
            return "ConsumerOffsetSync";
        }
        if (ClusterLinkSyncAclsTaskType$.MODULE$.equals(taskType)) {
            return "AclSync";
        }
        if (ClusterLinkAutoMirroringTaskType$.MODULE$.equals(taskType)) {
            return "AutoCreateMirror";
        }
        if (ClusterLinkSyncTopicConfigsTaskType$.MODULE$.equals(taskType)) {
            return "TopicConfigsSync";
        }
        throw new IllegalStateException(new StringBuilder(21).append("Unexpected task type ").append(taskType).toString());
    }

    public static final /* synthetic */ void $anonfun$handleResult$3(ClusterLinkFactory.LinkMetrics metrics$1, TaskType taskType$1, boolean isMirrorStateTransition$1, TaskErrorCodeAndMsg err) {
        metrics$1.clusterLinkTaskInErrorSensor(taskType$1, isMirrorStateTransition$1, err.code()).record();
    }

    private ClusterLinkTask$() {
        MODULE$ = this;
    }
}

