/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingMirror$;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkPendingRestoreMirror$;
import kafka.server.link.TopicLinkPendingSetupForRestoreMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkPendingSynchronizeMirror$;
import kafka.server.link.TopicLinkState;
import kafka.server.link.TopicLinkState$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeBoolean$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class ClusterLinkTopicState$ {
    public static ClusterLinkTopicState$ MODULE$;

    static {
        new ClusterLinkTopicState$();
    }

    public String toJsonString(ClusterLinkTopicState state) {
        return Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)state.state().name()), CollectionConverters$.MODULE$.mapAsJavaMapConverter(state.toMap()).asJava())}))).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public ClusterLinkTopicState fromJsonString(String json) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(json);
        if (option instanceof Some) {
            void var8_9;
            void var7_8;
            void var6_6;
            JsonObject jsonObj = ((JsonValue)((Some)option).value()).asJsonObject();
            List entries = (List)((TraversableLike)TopicLinkState$.MODULE$.states().map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), jsonObj.get(key.name())), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$2(x$2)));
            if (entries.size() != 1) {
                throw new IllegalStateException("Invalid cluster link topic state(s)");
            }
            Tuple2 tuple2 = (Tuple2)entries.head();
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicLinkState k = (TopicLinkState)tuple2._1();
            JsonObject jsonObject = ((JsonValue)((Option)tuple2._2()).get()).asJsonObject();
            void key2 = var6_6;
            JsonObject jsonOpt = jsonObject;
            void key3 = var7_8;
            void jsonOpt2 = var8_9;
            if (TopicLinkMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1 & Serializable & scala.Serializable)x$6 -> (Seq)x$6.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$9(x$7))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.Mirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), stoppedSequenceNumber, timeMs, (Seq<Object>)mirrorStartOffsets);
            }
            if (TopicLinkPausedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean linkLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("link_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean topicLevel = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("topic_level").to(DecodeJson$DecodeBoolean$.MODULE$));
                boolean wasFailed = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("was_failed").to(DecodeJson$DecodeBoolean$.MODULE$));
                TopicLinkState previousState = this.topicLinkState((Option<String>)jsonOpt2.get("previous_state").map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.to(DecodeJson$DecodeString$.MODULE$)), wasFailed ? TopicLinkFailedMirror$.MODULE$ : TopicLinkMirror$.MODULE$);
                TopicLinkState pendingSynchronizeNextState = this.topicLinkState((Option<String>)jsonOpt2.get("pending_synchronize_next_state").map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.to(DecodeJson$DecodeString$.MODULE$)), null);
                MirrorTopicError error = this.mirrorTopicError((JsonObject)jsonOpt2, wasFailed);
                Seq mirrorStartOffsets = (Seq)jsonOpt2.get("mirror_start_offsets").map((Function1 & Serializable & scala.Serializable)x$10 -> (Seq)x$10.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$15(x$11))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PausedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), linkLevel, topicLevel, previousState, pendingSynchronizeNextState, error, stoppedSequenceNumber, timeMs, (Seq<Object>)mirrorStartOffsets);
            }
            if (TopicLinkFailedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError((JsonObject)jsonOpt2, true);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$17(x$12))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), error, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                boolean synchronize = BoxesRunTime.unboxToBoolean((Object)jsonOpt2.apply("synchronize").to(DecodeJson$DecodeBoolean$.MODULE$));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$19(x$13))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingStoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), synchronize, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkStoppedMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq logEndOffsets = (Seq)jsonOpt2.apply("log_end_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                Seq stoppedEpochs = (Seq)jsonOpt2.get("stopped_epochs").map((Function1 & Serializable & scala.Serializable)x$14 -> (Seq)x$14.to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$23(x$15))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.StoppedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), (Seq<Object>)logEndOffsets, (Seq<Object>)stoppedEpochs, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                String nextState = jsonOpt2.apply("next_state").to(DecodeJson$DecodeString$.MODULE$);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$25(x$16))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), nextState, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                TopicLinkState remoteMirrorNextState = this.topicLinkState((Option<String>)jsonOpt2.get("remote_mirror_next_state").map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.to(DecodeJson$DecodeString$.MODULE$)), null);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$28(x$18))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), remoteMirrorNextState, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingRepairMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                MirrorTopicError error = this.mirrorTopicError((JsonObject)jsonOpt2, true);
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$30(x$19))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingRepairMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), error, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingSetupForRestoreMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq truncationOffsets = (Seq)jsonOpt2.apply("truncation_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                Seq truncationEpochs = (Seq)jsonOpt2.apply("truncation_epochs").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeInt$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$32(x$20))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingSetupForRestoreMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), (Seq<Object>)truncationEpochs, (Seq<Object>)truncationOffsets, stoppedSequenceNumber, timeMs);
            }
            if (TopicLinkPendingRestoreMirror$.MODULE$.equals(key3)) {
                ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
                long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
                String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
                UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
                Seq mirrorStartOffsets = (Seq)jsonOpt2.apply("mirror_start_offsets").to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeLong$.MODULE$, Predef$.MODULE$.fallbackStringCanBuildFrom()));
                long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$34(x$21))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                return new ClusterLinkTopicState.PendingRestoreMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), (Seq<Object>)mirrorStartOffsets, stoppedSequenceNumber, timeMs);
            }
            ClusterLinkTopicState$.validateVersion$1(1, BoxesRunTime.unboxToInt((Object)jsonOpt2.apply("version").to(DecodeJson$DecodeInt$.MODULE$)));
            long timeMs = BoxesRunTime.unboxToLong((Object)jsonOpt2.apply("time_ms").to(DecodeJson$DecodeLong$.MODULE$));
            String linkName = jsonOpt2.apply("link_name").to(DecodeJson$DecodeString$.MODULE$);
            UUID linkId = UUID.fromString(jsonOpt2.apply("link_id").to(DecodeJson$DecodeString$.MODULE$));
            long stoppedSequenceNumber = BoxesRunTime.unboxToLong((Object)jsonOpt2.get("stopped_sequence_number").map((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromJsonString$36(x$22))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new ClusterLinkTopicState.FailedMirror(linkName, CoreUtils$.MODULE$.toKafkaUUID(linkId), ClusterLinkTopicState$.sourceTopicId$1((JsonObject)jsonOpt2), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, stoppedSequenceNumber, timeMs);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException(new StringBuilder(26).append("Invalid topic state JSON: ").append(json).toString());
        }
        throw new MatchError(option);
    }

    public Option<Tuple2<String, String>> sourceTopicIdOption(Uuid sourceTopicId) {
        Uuid uuid = sourceTopicId;
        Uuid uuid2 = Uuid.ZERO_UUID;
        if (!(uuid != null ? !uuid.equals(uuid2) : uuid2 != null)) {
            return None$.MODULE$;
        }
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source_topic_id"), (Object)sourceTopicId.toString()));
    }

    public MirrorTopicError mirrorTopicError(JsonObject jsonOpt, boolean failed) {
        return MirrorTopicError.forCode((short)((short)BoxesRunTime.unboxToInt((Object)jsonOpt.get("mirror_topic_error").map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToInteger((int)ClusterLinkTopicState$.$anonfun$mirrorTopicError$1(x$23))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> MirrorTopicError.NOT_SET.code()))), (boolean)failed);
    }

    public TopicLinkState topicLinkState(Option<String> persistedState, TopicLinkState defaultValue) {
        if (persistedState instanceof Some) {
            String state = (String)((Some)persistedState).value();
            try {
                return TopicLinkState$.MODULE$.fromString(state);
            }
            catch (Exception exception) {
                return TopicLinkFailedMirror$.MODULE$;
            }
        }
        if (None$.MODULE$.equals(persistedState)) {
            return defaultValue;
        }
        throw new MatchError(persistedState);
    }

    public boolean hasFailed(TopicLinkState state) {
        block3: {
            block2: {
                TopicLinkState topicLinkState = state;
                TopicLinkFailedMirror$ topicLinkFailedMirror$ = TopicLinkFailedMirror$.MODULE$;
                if (!(topicLinkState == null ? topicLinkFailedMirror$ != null : !topicLinkState.equals(topicLinkFailedMirror$))) break block2;
                TopicLinkState topicLinkState2 = state;
                TopicLinkPendingRepairMirror$ topicLinkPendingRepairMirror$ = TopicLinkPendingRepairMirror$.MODULE$;
                if (topicLinkState2 != null ? !topicLinkState2.equals(topicLinkPendingRepairMirror$) : topicLinkPendingRepairMirror$ != null) break block3;
            }
            return true;
        }
        return false;
    }

    public ClusterLinkTopicState apply(MirrorTopic mirrorTopic) {
        String linkName = mirrorTopic.linkName();
        MirrorTopic.State state = mirrorTopic.mirrorState();
        if (MirrorTopic.State.MIRROR.equals(state)) {
            Nil$ mirrorStartOffsets = mirrorTopic.mirrorStartOffsets() != null ? (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopic.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24), Buffer$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            return new ClusterLinkTopicState.Mirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.timeMs(), (Seq<Object>)mirrorStartOffsets);
        }
        if (MirrorTopic.State.PAUSED.equals(state)) {
            MirrorTopic.PausedMirrorTopic pausedMirror = (MirrorTopic.PausedMirrorTopic)mirrorTopic;
            Nil$ mirrorStartOffsets = pausedMirror.mirrorStartOffsets() != null ? (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pausedMirror.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToLong((long)x$25), Buffer$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            TopicLinkState prevState = this.topicLinkState((Option<String>)new Some((Object)pausedMirror.prevToPausedState().stateName()), TopicLinkFailedMirror$.MODULE$);
            TopicLinkState pendingSynchronizeNextState = pausedMirror.pendingSynchronizeNextState() != null ? this.topicLinkState((Option<String>)new Some((Object)pausedMirror.pendingSynchronizeNextState().stateName()), null) : null;
            return new ClusterLinkTopicState.PausedMirror(linkName, mirrorTopic.linkId(), pausedMirror.sourceTopicId(), pausedMirror.linkLevel(), pausedMirror.topicLevel(), prevState, pendingSynchronizeNextState, MirrorTopicError.errorOrDefault((MirrorTopicError)pausedMirror.mirrorTopicError(), (boolean)this.hasFailed(prevState)), pausedMirror.stoppedSequenceNumber(), pausedMirror.timeMs(), (Seq<Object>)mirrorStartOffsets);
        }
        if (MirrorTopic.State.PENDING_STOPPED.equals(state)) {
            MirrorTopic.PendingStoppedMirrorTopic pendingStoppedMirror = (MirrorTopic.PendingStoppedMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.PendingStoppedMirror(linkName, mirrorTopic.linkId(), pendingStoppedMirror.sourceTopicId(), pendingStoppedMirror.promoted(), pendingStoppedMirror.stoppedSequenceNumber(), pendingStoppedMirror.timeMs());
        }
        if (MirrorTopic.State.STOPPED.equals(state)) {
            MirrorTopic.StoppedMirrorTopic stoppedMirror = (MirrorTopic.StoppedMirrorTopic)mirrorTopic;
            Nil$ stoppedLogEndOffsets = stoppedMirror.mirrorStoppedOffsets() != null ? (Seq)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(stoppedMirror.mirrorStoppedOffsets()).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(x$26)), List$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            Nil$ stoppedEpochs = stoppedMirror.mirrorStoppedEpochs() != null ? (Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(stoppedMirror.mirrorStoppedEpochs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToInteger((int)x$27), Buffer$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
            return new ClusterLinkTopicState.StoppedMirror(linkName, mirrorTopic.linkId(), stoppedMirror.sourceTopicId(), (Seq<Object>)stoppedLogEndOffsets, (Seq<Object>)stoppedEpochs, stoppedMirror.stoppedSequenceNumber(), stoppedMirror.timeMs());
        }
        if (MirrorTopic.State.FAILED.equals(state)) {
            return new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.errorOrDefault((MirrorTopicError)mirrorTopic.mirrorTopicError(), (boolean)true), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.timeMs());
        }
        if (MirrorTopic.State.PENDING_MIRROR.equals(state)) {
            MirrorTopic.PendingMirrorTopic pendingMirror = (MirrorTopic.PendingMirrorTopic)mirrorTopic;
            return new ClusterLinkTopicState.PendingMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), pendingMirror.nextState().stateName(), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.timeMs());
        }
        if (MirrorTopic.State.PENDING_SYNCHRONIZE.equals(state)) {
            TopicLinkState remoteMirrorNextState;
            MirrorTopic.PendingSynchronizeMirrorTopic pendingSynchronizeMirror = (MirrorTopic.PendingSynchronizeMirrorTopic)mirrorTopic;
            if (pendingSynchronizeMirror.remoteMirrorNextState() == null) {
                throw new IllegalStateException("Null remote mirror next state found for PendingSynchronizeMirror");
            }
            TopicLinkState topicLinkState = remoteMirrorNextState = this.topicLinkState((Option<String>)Option$.MODULE$.apply((Object)pendingSynchronizeMirror.remoteMirrorNextState().stateName()), TopicLinkFailedMirror$.MODULE$);
            TopicLinkMirror$ topicLinkMirror$ = TopicLinkMirror$.MODULE$;
            if (topicLinkState == null ? topicLinkMirror$ != null : !topicLinkState.equals(topicLinkMirror$)) {
                TopicLinkState topicLinkState2 = remoteMirrorNextState;
                TopicLinkPausedMirror$ topicLinkPausedMirror$ = TopicLinkPausedMirror$.MODULE$;
                if (topicLinkState2 == null ? topicLinkPausedMirror$ != null : !topicLinkState2.equals(topicLinkPausedMirror$)) {
                    throw new IllegalStateException(new StringBuilder(73).append("Found unsupported remote mirror next state for PendingSynchronizeMirror: ").append(remoteMirrorNextState).toString());
                }
            }
            return new ClusterLinkTopicState.PendingSynchronizeMirror(linkName, mirrorTopic.linkId(), pendingSynchronizeMirror.sourceTopicId(), remoteMirrorNextState, pendingSynchronizeMirror.stoppedSequenceNumber(), pendingSynchronizeMirror.timeMs());
        }
        if (MirrorTopic.State.PENDING_REPAIR.equals(state)) {
            return new ClusterLinkTopicState.PendingRepairMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.errorOrDefault((MirrorTopicError)mirrorTopic.mirrorTopicError(), (boolean)true), mirrorTopic.stoppedSequenceNumber(), mirrorTopic.timeMs());
        }
        if (MirrorTopic.State.PENDING_SETUP_FOR_RESTORE.equals(state)) {
            MirrorTopic.PendingSetupForRestoreMirrorTopic pendingSetupForRestoreMirror = (MirrorTopic.PendingSetupForRestoreMirrorTopic)mirrorTopic;
            if (pendingSetupForRestoreMirror.truncationOffsets() == null) {
                throw new IllegalStateException("Null truncation offsets found for PendingSetupForRestoreMirror");
            }
            if (pendingSetupForRestoreMirror.truncationEpochs() == null) {
                throw new IllegalStateException("Null truncation epochs found for PendingSetupForRestoreMirror");
            }
            return new ClusterLinkTopicState.PendingSetupForRestoreMirror(linkName, mirrorTopic.linkId(), pendingSetupForRestoreMirror.sourceTopicId(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pendingSetupForRestoreMirror.truncationEpochs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28), Buffer$.MODULE$.canBuildFrom())), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pendingSetupForRestoreMirror.truncationOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToLong((long)x$29), Buffer$.MODULE$.canBuildFrom())), pendingSetupForRestoreMirror.stoppedSequenceNumber(), pendingSetupForRestoreMirror.timeMs());
        }
        if (MirrorTopic.State.PENDING_RESTORE.equals(state)) {
            MirrorTopic.PendingRestoreMirrorTopic pendingRestoreMirror = (MirrorTopic.PendingRestoreMirrorTopic)mirrorTopic;
            if (pendingRestoreMirror.mirrorStartOffsets() == null) {
                throw new IllegalStateException("Null mirror start offsets found for PendingRestoreMirror");
            }
            return new ClusterLinkTopicState.PendingRestoreMirror(linkName, mirrorTopic.linkId(), pendingRestoreMirror.sourceTopicId(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(pendingRestoreMirror.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToLong((long)x$30), Buffer$.MODULE$.canBuildFrom())), pendingRestoreMirror.stoppedSequenceNumber(), pendingRestoreMirror.timeMs());
        }
        return new ClusterLinkTopicState.FailedMirror(linkName, mirrorTopic.linkId(), mirrorTopic.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, mirrorTopic.stoppedSequenceNumber(), mirrorTopic.timeMs());
    }

    public Option<ClusterLinkTopicState> fromMirrorTopicState(UpdateMetadataRequest.MirrorTopicState mirrorTopicState) {
        return Option$.MODULE$.apply((Object)mirrorTopicState).flatMap((Function1 & Serializable & scala.Serializable)state -> {
            None$ none$;
            try {
                TopicLinkState topicLinkState = TopicLinkState$.MODULE$.fromString(state.state());
                if (TopicLinkMirror$.MODULE$.equals(topicLinkState)) {
                    none$ = new Some((Object)new ClusterLinkTopicState.Mirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), 0L, mirrorTopicState.timeMs(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToLong((long)x$31), Buffer$.MODULE$.canBuildFrom()))));
                } else if (TopicLinkPausedMirror$.MODULE$.equals(topicLinkState)) {
                    String string = mirrorTopicState.previousState();
                    String string2 = TopicLinkFailedMirror$.MODULE$.name();
                    boolean wasFailed = !(string != null ? !string.equals(string2) : string2 != null);
                    none$ = new Some((Object)new ClusterLinkTopicState.PausedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.linkLevelPause(), mirrorTopicState.topicLevelPause(), MODULE$.topicLinkState((Option<String>)Option$.MODULE$.apply((Object)mirrorTopicState.previousState()), TopicLinkFailedMirror$.MODULE$), MODULE$.topicLinkState((Option<String>)new Some((Object)mirrorTopicState.nextState()), null), MirrorTopicError.forCode((short)mirrorTopicState.mirrorTopicError(), (boolean)wasFailed), 0L, mirrorTopicState.timeMs(), (Seq<Object>)((Seq)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToLong((long)x$32), Buffer$.MODULE$.canBuildFrom()))));
                } else if (TopicLinkFailedMirror$.MODULE$.equals(topicLinkState)) {
                    none$ = new Some((Object)new ClusterLinkTopicState.FailedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), MirrorTopicError.forCode((short)mirrorTopicState.mirrorTopicError(), (boolean)true), 0L, mirrorTopicState.timeMs()));
                } else if (TopicLinkPendingStoppedMirror$.MODULE$.equals(topicLinkState)) {
                    none$ = new Some((Object)new ClusterLinkTopicState.PendingStoppedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.promoted(), 0L, mirrorTopicState.timeMs()));
                } else if (TopicLinkStoppedMirror$.MODULE$.equals(topicLinkState)) {
                    none$ = new Some((Object)new ClusterLinkTopicState.StoppedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.stoppedLogEndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$4(x$33)), Buffer$.MODULE$.canBuildFrom())).toSeq(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.stoppedEpochs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToInteger((int)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$5(x$34)), Buffer$.MODULE$.canBuildFrom())).toSeq(), 0L, mirrorTopicState.timeMs()));
                } else if (TopicLinkPendingMirror$.MODULE$.equals(topicLinkState)) {
                    none$ = new Some((Object)new ClusterLinkTopicState.PendingMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), mirrorTopicState.nextState(), 0L, mirrorTopicState.timeMs()));
                } else if (TopicLinkPendingSynchronizeMirror$.MODULE$.equals(topicLinkState)) {
                    TopicLinkState remoteMirrorNextState;
                    if (mirrorTopicState.nextState() == null) {
                        throw new IllegalStateException("Null remote mirror next state found for PendingSynchronizeMirror");
                    }
                    TopicLinkState topicLinkState2 = remoteMirrorNextState = MODULE$.topicLinkState((Option<String>)Option$.MODULE$.apply((Object)mirrorTopicState.nextState()), TopicLinkFailedMirror$.MODULE$);
                    TopicLinkMirror$ topicLinkMirror$ = TopicLinkMirror$.MODULE$;
                    if (topicLinkState2 == null ? topicLinkMirror$ != null : !topicLinkState2.equals(topicLinkMirror$)) {
                        TopicLinkState topicLinkState3 = remoteMirrorNextState;
                        TopicLinkPausedMirror$ topicLinkPausedMirror$ = TopicLinkPausedMirror$.MODULE$;
                        if (topicLinkState3 == null ? topicLinkPausedMirror$ != null : !topicLinkState3.equals(topicLinkPausedMirror$)) {
                            throw new IllegalStateException(new StringBuilder(73).append("Found unsupported remote mirror next state for PendingSynchronizeMirror: ").append(remoteMirrorNextState).toString());
                        }
                    }
                    none$ = new Some((Object)new ClusterLinkTopicState.PendingSynchronizeMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), remoteMirrorNextState, 0L, mirrorTopicState.timeMs()));
                } else {
                    none$ = TopicLinkPendingRepairMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingRepairMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), MirrorTopicError.forCode((short)mirrorTopicState.mirrorTopicError(), (boolean)true), 0L, mirrorTopicState.timeMs())) : (TopicLinkPendingSetupForRestoreMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingSetupForRestoreMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.stoppedEpochs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToInteger((int)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$6(x$35)), Buffer$.MODULE$.canBuildFrom())).toSeq(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.stoppedLogEndOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$7(x$36)), Buffer$.MODULE$.canBuildFrom())).toSeq(), 0L, mirrorTopicState.timeMs())) : (TopicLinkPendingRestoreMirror$.MODULE$.equals(topicLinkState) ? new Some((Object)new ClusterLinkTopicState.PendingRestoreMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), (Seq<Object>)((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mirrorTopicState.mirrorStartOffsets()).asScala()).map((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToLong((long)ClusterLinkTopicState$.$anonfun$fromMirrorTopicState$8(x$37)), Buffer$.MODULE$.canBuildFrom())).toSeq(), 0L, mirrorTopicState.timeMs())) : new Some((Object)new ClusterLinkTopicState.FailedMirror(mirrorTopicState.clusterLinkName(), mirrorTopicState.clusterLinkId(), mirrorTopicState.sourceTopicId(), MirrorTopicError.UNSUPPORTED_MIRROR_STATE, 0L, mirrorTopicState.timeMs()))));
                }
            }
            catch (Throwable throwable) {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$2(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    private static final void validateVersion$1(int expectedVersion, int actualVersion) {
        if (expectedVersion != actualVersion) {
            throw new IllegalStateException(new StringBuilder(40).append("Unexpected version '").append(expectedVersion).append("', actual version '").append(actualVersion).append("'").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$fromJsonString$4(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    private static final Uuid sourceTopicId$1(JsonObject jsonOpt$1) {
        return (Uuid)jsonOpt$1.get("source_topic_id").map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.to(DecodeJson$DecodeString$.MODULE$)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkTopicState$.$anonfun$fromJsonString$4(x$5))).map((Function1 & Serializable & scala.Serializable)x$1 -> Uuid.fromString((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$9(JsonValue x$7) {
        return BoxesRunTime.unboxToLong((Object)x$7.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$15(JsonValue x$11) {
        return BoxesRunTime.unboxToLong((Object)x$11.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$17(JsonValue x$12) {
        return BoxesRunTime.unboxToLong((Object)x$12.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$19(JsonValue x$13) {
        return BoxesRunTime.unboxToLong((Object)x$13.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$23(JsonValue x$15) {
        return BoxesRunTime.unboxToLong((Object)x$15.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$25(JsonValue x$16) {
        return BoxesRunTime.unboxToLong((Object)x$16.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$28(JsonValue x$18) {
        return BoxesRunTime.unboxToLong((Object)x$18.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$30(JsonValue x$19) {
        return BoxesRunTime.unboxToLong((Object)x$19.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$32(JsonValue x$20) {
        return BoxesRunTime.unboxToLong((Object)x$20.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$34(JsonValue x$21) {
        return BoxesRunTime.unboxToLong((Object)x$21.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromJsonString$36(JsonValue x$22) {
        return BoxesRunTime.unboxToLong((Object)x$22.to(DecodeJson$DecodeLong$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$mirrorTopicError$1(JsonValue x$23) {
        return BoxesRunTime.unboxToInt((Object)x$23.to(DecodeJson$DecodeInt$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$fromMirrorTopicState$4(Long x$33) {
        return BoxesRunTime.unboxToLong((Object)x$33);
    }

    public static final /* synthetic */ int $anonfun$fromMirrorTopicState$5(Integer x$34) {
        return BoxesRunTime.unboxToInt((Object)x$34);
    }

    public static final /* synthetic */ int $anonfun$fromMirrorTopicState$6(Integer x$35) {
        return BoxesRunTime.unboxToInt((Object)x$35);
    }

    public static final /* synthetic */ long $anonfun$fromMirrorTopicState$7(Long x$36) {
        return BoxesRunTime.unboxToLong((Object)x$36);
    }

    public static final /* synthetic */ long $anonfun$fromMirrorTopicState$8(Long x$37) {
        return BoxesRunTime.unboxToLong((Object)x$37);
    }

    private ClusterLinkTopicState$() {
        MODULE$ = this;
    }
}

