/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigEncoder;
import kafka.server.link.ClusterLinkConfigProvider;
import kafka.server.link.ClusterLinkConfigProvider$;
import kafka.server.link.Encoder;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\t\u0013\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b[\u0001\u0001\r\u0011\"\u0003/\u0011\u001dq\u0004\u00011A\u0005\n}Ba!\u0012\u0001!B\u0013y\u0003\"\u0002&\u0001\t\u0003Y\u0005\"\u0002,\u0001\t\u00039\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u00021\u0001\t\u0003\t\u0007\"\u00022\u0001\t\u0003\u0019\u0007\"\u00025\u0001\t\u0013I\u0007\"B<\u0001\t#Ah\u0001\u0002@\u0001\t}D!\"a\u0007\u000e\u0005\u0003\u0005\u000b\u0011BA\u000f\u0011)\ti$\u0004B\u0001B\u0003%\u0011q\b\u0005\u0007S5!\t!!\u0013\u0003/M+7-\u001e:f\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014(BA\n\u0015\u0003\u0011a\u0017N\\6\u000b\u0005U1\u0012AB:feZ,'OC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EI\u0007\u0002%%\u00111E\u0005\u0002\u0019\u00072,8\u000f^3s\u0019&t7nQ8oM&<WI\\2pI\u0016\u0014\u0018\u0001\u00042s_.,'oQ8oM&<\u0007C\u0001\u0014(\u001b\u0005!\u0012B\u0001\u0015\u0015\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\rqJg.\u001b;?)\tYC\u0006\u0005\u0002\"\u0001!)AE\u0001a\u0001K\u0005AQM\\2pI\u0016\u00148/F\u00010!\r\u0001\u0004h\u000f\b\u0003cYr!AM\u001b\u000e\u0003MR!\u0001\u000e\r\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012BA\u001c\u001d\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u000f\u001e\u0003\u0007M+\u0017O\u0003\u000289A\u0011\u0011\u0005P\u0005\u0003{I\u0011q!\u00128d_\u0012,'/\u0001\u0007f]\u000e|G-\u001a:t?\u0012*\u0017\u000f\u0006\u0002A\u0007B\u00111$Q\u0005\u0003\u0005r\u0011A!\u00168ji\"9A\tBA\u0001\u0002\u0004y\u0013a\u0001=%c\u0005IQM\\2pI\u0016\u00148\u000f\t\u0015\u0003\u000b\u001d\u0003\"a\u0007%\n\u0005%c\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\r\u0015t7m\u001c3f)\taE\u000b\u0005\u0002N%6\taJ\u0003\u0002P!\u0006!Q\u000f^5m\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0003V\r\u0001\u0007A*A\u0005mS:\\\u0007K]8qg\u00061A-Z2pI\u0016$\"\u0001\u0014-\t\u000be;\u0001\u0019\u0001'\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paN\fQ\"\\1zE\u0016\u0014V-\u001a8d_\u0012,GC\u0001/`!\rYR\fT\u0005\u0003=r\u0011aa\u00149uS>t\u0007\"B-\t\u0001\u0004a\u0015A\u0006:f[>4Xm\u00147e'\u0016\u001c'/\u001a;F]\u000e|G-\u001a:\u0015\u0003\u0001\u000b\u0011c\u00197vgR,'\u000fT5oW\u000e{gNZ5h)\t!w\r\u0005\u0002\"K&\u0011aM\u0005\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0007\"B-\u000b\u0001\u0004a\u0015A\u00059s_ZLG-\u001a:Qe>\u0004XM\u001d;jKN$2A[;w!\u0011i5.\\7\n\u00051t%aA'baB\u0011aN\u001d\b\u0003_B\u0004\"A\r\u000f\n\u0005Ed\u0012A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!\u001d\u000f\t\u000be[\u0001\u0019\u0001'\t\u000b\u0011Z\u0001\u0019A\u0013\u0002\u001d5\f\u0017PY3TK:\u001c\u0018\u000e^5wKR\u0011\u0011\u0010 \t\u00037iL!a\u001f\u000f\u0003\u000f\t{w\u000e\\3b]\")Q\u0010\u0004a\u0001[\u0006Q1m\u001c8gS\u001et\u0015-\\3\u0003\u001d\u0011+7m\u001c3j]\u001e\u001cuN\u001c4jON\u0019Q\"!\u0001\u0011\t\u0005\r\u0011qC\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u000511m\u001c8gS\u001eTA!a\u0003\u0002\u000e\u000511m\\7n_:T1aFA\b\u0015\u0011\t\t\"a\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)\"A\u0002pe\u001eLA!!\u0007\u0002\u0006\tq\u0011IY:ue\u0006\u001cGoQ8oM&<\u0017!\u00029s_B\u001c\bGBA\u0010\u0003K\tI\u0004\u0005\u0004NW\u0006\u0005\u0012q\u0007\t\u0005\u0003G\t)\u0003\u0004\u0001\u0005\u0017\u0005\u001db\"!A\u0001\u0002\u000b\u0005\u0011\u0011\u0006\u0002\u0004?\u0012\n\u0014\u0003BA\u0016\u0003c\u00012aGA\u0017\u0013\r\ty\u0003\b\u0002\b\u001d>$\b.\u001b8h!\rY\u00121G\u0005\u0004\u0003ka\"aA!osB!\u00111EA\u001d\t-\tYDDA\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}##'A\nd_:4\u0017n\u001a)s_ZLG-\u001a:Qe>\u00048\u000f\r\u0003\u0002B\u0005\u0015\u0003#B'l[\u0006\r\u0003\u0003BA\u0012\u0003\u000b\"1\"a\u0012\u0010\u0003\u0003\u0005\tQ!\u0001\u0002*\t\u0019q\fJ\u001a\u0015\r\u0005-\u0013qJA/!\r\ti%D\u0007\u0002\u0001!9\u00111\u0004\tA\u0002\u0005E\u0003GBA*\u0003/\nY\u0006\u0005\u0004NW\u0006U\u0013\u0011\f\t\u0005\u0003G\t9\u0006\u0002\u0007\u0002(\u0005=\u0013\u0011!A\u0001\u0006\u0003\tI\u0003\u0005\u0003\u0002$\u0005mC\u0001DA\u001e\u0003\u001f\n\t\u0011!A\u0003\u0002\u0005%\u0002bBA\u001f!\u0001\u0007\u0011q\f\u0019\u0005\u0003C\n)\u0007E\u0003NW6\f\u0019\u0007\u0005\u0003\u0002$\u0005\u0015D\u0001DA$\u0003;\n\t\u0011!A\u0003\u0002\u0005%\u0002")
public class SecureLinkConfigEncoder
implements ClusterLinkConfigEncoder {
    private final KafkaConfig brokerConfig;
    private volatile Seq<Encoder> encoders;

    private Seq<Encoder> encoders() {
        return this.encoders;
    }

    private void encoders_$eq(Seq<Encoder> x$1) {
        this.encoders = x$1;
    }

    @Override
    public Properties encode(Properties linkProps) {
        Properties props = new Properties();
        Map sensitiveProps = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(linkProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                if (this.maybeSensitive(k)) {
                    sensitiveProps.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v));
                    return props.put(k, new StringBuilder(4).append("$").append("{").append(ClusterLinkConfigProvider$.MODULE$.ProviderName()).append(":").append(k).append("}").toString());
                }
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        if (sensitiveProps.nonEmpty()) {
            if (this.encoders().isEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(95).append("password.encoder.secret").append(" must be configured for cluster linking with sensitive or custom configs").toString());
            }
            this.encoders().foreach((Function1 & Serializable & scala.Serializable)encoder -> {
                SecureLinkConfigEncoder.$anonfun$encode$2(props, sensitiveProps, encoder);
                return BoxedUnit.UNIT;
            });
        }
        return props;
    }

    @Override
    public Properties decode(Properties persistentProps) {
        java.util.Map<String, String> providerProps = this.providerProperties(persistentProps, this.brokerConfig);
        Properties encodedProps = new Properties();
        persistentProps.entrySet().stream().filter(e -> {
            Object k = e.getKey();
            String string = "config.providers";
            return k != null && k.equals(string) || !providerProps.containsKey(e.getKey());
        }).forEach(e -> encodedProps.put(e.getKey(), e.getValue()));
        Properties decodedProps = new Properties();
        new DecodingConfig(encodedProps, providerProps).originals().forEach((k, v) -> decodedProps.put(k, v));
        return decodedProps;
    }

    @Override
    public Option<Properties> maybeReencode(Properties persistentProps) {
        if (persistentProps.keySet().stream().noneMatch(k -> this.maybeSensitive(k.toString()))) {
            return None$.MODULE$;
        }
        int numEncryptedSecrets = ClusterLinkConfigProvider$.MODULE$.EncryptedSecretPrefixes().count((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$maybeReencode$2(persistentProps, prefix)));
        int numCurrentSecretsInUse = this.encoders().count((Function1 & Serializable & scala.Serializable)encoder -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$maybeReencode$4(persistentProps, encoder)));
        int numOldCipherAlgorithmInUse = this.encoders().count((Function1 & Serializable & scala.Serializable)encoder -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$maybeReencode$6(persistentProps, encoder)));
        if (numEncryptedSecrets != this.encoders().size() || numCurrentSecretsInUse != this.encoders().size() || numOldCipherAlgorithmInUse > 0) {
            return new Some((Object)this.encode(this.decode(persistentProps)));
        }
        return None$.MODULE$;
    }

    @Override
    public void removeOldSecretEncoder() {
        this.encoders_$eq(ClusterLinkConfigProvider$.MODULE$.createEncoders(this.brokerConfig.values(), false));
    }

    @Override
    public ClusterLinkConfig clusterLinkConfig(Properties persistentProps) {
        Properties decodedProps = this.decode(persistentProps);
        return ClusterLinkConfig$.MODULE$.create(decodedProps, (Option<KafkaConfig>)new Some((Object)this.brokerConfig), false);
    }

    private java.util.Map<String, String> providerProperties(Properties persistentProps, KafkaConfig brokerConfig) {
        if (brokerConfig.passwordEncoderSecret().nonEmpty()) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("config.providers", ClusterLinkConfigProvider$.MODULE$.ProviderName());
            props.put(new StringBuilder(23).append("config.providers").append(".").append(ClusterLinkConfigProvider$.MODULE$.ProviderName()).append(".class").toString(), ClusterLinkConfigProvider.class.getName());
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(ConfigDef.convertToStringMapWithPasswordValues(brokerConfig.values())).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$providerProperties$1(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    String v = (String)x0$1._2();
                    return props.put(new StringBuilder(0).append(ClusterLinkConfigProvider$.MODULE$.ProviderParamPrefix()).append(k).toString(), v);
                }
                throw new MatchError(null);
            });
            ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$providerProperties$3(x$3)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 != null) {
                    String k = (String)x0$2._1();
                    String v = (String)x0$2._2();
                    return props.put(k, v);
                }
                throw new MatchError(null);
            });
            return props;
        }
        return Collections.emptyMap();
    }

    public boolean maybeSensitive(String configName) {
        Option<ConfigDef.Type> propType = ClusterLinkConfig$.MODULE$.configType(configName);
        return propType.isEmpty() || propType.contains((Object)ConfigDef.Type.PASSWORD);
    }

    public static final /* synthetic */ void $anonfun$encode$3(Encoder encoder$1, Properties props$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            encoder$1.addEncodedProp(k, new Password(v), props$1);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$encode$2(Properties props$1, Map sensitiveProps$1, Encoder encoder) {
        encoder.addEncodedProp("", encoder.secret(), props$1);
        sensitiveProps$1.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            SecureLinkConfigEncoder.$anonfun$encode$3(encoder, props$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$maybeReencode$3(String prefix$1, Tuple2 x$1) {
        return ((String)x$1._1()).startsWith(new StringBuilder(0).append(ClusterLinkConfigProvider$.MODULE$.ProviderParamPrefix()).append(prefix$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$maybeReencode$2(Properties persistentProps$1, String prefix) {
        return ((IterableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(persistentProps$1).asScala()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SecureLinkConfigEncoder.$anonfun$maybeReencode$3(prefix, x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$maybeReencode$4(Properties persistentProps$1, Encoder encoder) {
        return ClusterLinkConfigProvider$.MODULE$.EncryptedSecretPrefixes().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)encoder.usesEncoderSecret(persistentProps$1.getProperty(new StringBuilder(0).append(ClusterLinkConfigProvider$.MODULE$.ProviderParamPrefix()).append(prefix).toString()))));
    }

    public static final /* synthetic */ boolean $anonfun$maybeReencode$6(Properties persistentProps$1, Encoder encoder) {
        return ClusterLinkConfigProvider$.MODULE$.EncryptedSecretPrefixes().exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)encoder.usesEncoderSecretWithOldCipherAlgorithm(persistentProps$1.getProperty(new StringBuilder(0).append(ClusterLinkConfigProvider$.MODULE$.ProviderParamPrefix()).append(prefix).toString()))));
    }

    public static final /* synthetic */ boolean $anonfun$providerProperties$1(Tuple2 x$2) {
        return ((String)x$2._1()).startsWith("password.encoder.");
    }

    public static final /* synthetic */ boolean $anonfun$providerProperties$3(Tuple2 x$3) {
        return ((String)x$3._1()).startsWith(ClusterLinkConfigProvider$.MODULE$.ProviderParamPrefix());
    }

    public SecureLinkConfigEncoder(KafkaConfig brokerConfig) {
        this.brokerConfig = brokerConfig;
        this.encoders = ClusterLinkConfigProvider$.MODULE$.createEncoders(brokerConfig.values(), ClusterLinkConfigProvider$.MODULE$.createEncoders$default$2());
    }

    private class DecodingConfig
    extends AbstractConfig {
        public /* synthetic */ SecureLinkConfigEncoder kafka$server$link$SecureLinkConfigEncoder$DecodingConfig$$$outer() {
            return SecureLinkConfigEncoder.this;
        }

        public DecodingConfig(java.util.Map<?, ?> props, java.util.Map<String, ?> configProviderProps) {
            if (SecureLinkConfigEncoder.this == null) {
                throw null;
            }
            super(new ConfigDef(), props, configProviderProps, false);
        }
    }
}

