/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import kafka.server.CachedControllerId;
import kafka.server.KRaftCachedControllerId$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftImageMetadataCache;
import kafka.utils.Logging;
import org.apache.kafka.admin.BrokerMetadata;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.DescribeClientQuotasRequestData;
import org.apache.kafka.common.message.DescribeClientQuotasResponseData;
import org.apache.kafka.common.message.DescribeTopicPartitionsResponseData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsRequestData;
import org.apache.kafka.common.message.DescribeUserScramCredentialsResponseData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.FinalizedFeatures;
import org.apache.kafka.server.common.KRaftVersion;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dc\u0001B\u001f?\u0001\u0015C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t1\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003\\\u0011\u0015\u0011\b\u0001\"\u0001t\u0011\u001d9\b\u00011A\u0005\naD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u001b\u0001\u0001\u0015)\u0003z\u0011\u001d\t9\u0002\u0001C\u0005\u00033Aq!a\u0016\u0001\t\u0003\tI\u0006C\u0004\u0002\\\u0001!I!!\u0018\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011q\u001e\u0001\u0005\n\u0005E\bb\u0002B\u0003\u0001\u0011%!q\u0001\u0005\b\u0005/\u0001A\u0011\u0002B\r\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\u000e\u0001\t\u0003\u00129\u0004C\u0005\u0003\\\u0001\t\n\u0011\"\u0001\u0003^!I!1\u000f\u0001\u0012\u0002\u0013\u0005!Q\f\u0005\b\u0005k\u0002A\u0011\tB<\u0011\u001d\u0011y\b\u0001C!\u0005\u0003CqAa)\u0001\t\u0003\u0012)\u000bC\u0004\u00032\u0002!\tEa-\t\u000f\tu\u0006\u0001\"\u0011\u0003@\"9!Q\u0019\u0001\u0005B\t\u001d\u0007b\u0002Bj\u0001\u0011\u0005#Q\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011\u001d\u0011y\u000e\u0001C\u0001\u0005CDqA!:\u0001\t\u0003\u00129\u000fC\u0004\u0003f\u0002!IAa?\t\u000f\t}\b\u0001\"\u0011\u0004\u0002!91q\u0001\u0001\u0005B\r%\u0001bBB\n\u0001\u0011\u00053Q\u0003\u0005\b\u00073\u0001A\u0011IB\u000e\u0011\u001d\u0019\t\u0003\u0001C!\u0007GAqaa\u000f\u0001\t\u0003\u0019i\u0004C\u0004\u0004B\u0001!\tea\u0011\t\u000f\r%\u0003\u0001\"\u0011\u0004L!91\u0011\u000b\u0001\u0005B\rM\u0003bBB,\u0001\u0011\u00053\u0011\f\u0005\b\u0007;\u0002A\u0011IB0\u0011\u001d\u00199\u0007\u0001C!\u0007SBqaa\u001d\u0001\t\u0003\u001a)\bC\u0004\u0004\u0002\u0002!\tea!\t\u000f\r\u0015\u0005\u0001\"\u0003\u0004\b\"911\u0012\u0001\u0005\u0002\r5\u0005bBBM\u0001\u0011\u000531\u0014\u0005\b\u0007S\u0003A\u0011IBV\u0011\u001d\u0019I\u000b\u0001C!\u0007_Cqaa-\u0001\t\u0003\u001a)\fC\u0004\u0004<\u0002!\t!!\u0017\t\u000f\ru\u0006\u0001\"\u0011\u0004@\"91Q\u001b\u0001\u0005B\r]\u0007bBBu\u0001\u0011\u000531\u001e\u0005\b\u0007w\u0004A\u0011IB\u007f\u0011\u001d!)\u0001\u0001C!\t\u000fAq\u0001b\u0004\u0001\t\u0003\"\t\u0002C\u0004\u0005\u0016\u0001!\t\u0005b\u0006\t\u000f\u00115\u0002\u0001\"\u0011\u00050!9A1\t\u0001\u0005B\u0011\u0015#AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016T!a\u0010!\u0002\u00115,G/\u00193bi\u0006T!!\u0011\"\u0002\rM,'O^3s\u0015\u0005\u0019\u0015!B6bM.\f7\u0001A\n\u0005\u0001\u0019c\u0005\u000b\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005J\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001b:k\u0011AP\u0005\u0003\u001fz\u0012qc\u0013*bMRLU.Y4f\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\u00055\u000b\u0016B\u0001*?\u0005A\u0019uN\u001c4jOJ+\u0007o\\:ji>\u0014\u00180\u0001\u0005ce>\\WM]%e+\u0005)\u0006CA$W\u0013\t9\u0006JA\u0002J]R\f\u0011B\u0019:pW\u0016\u0014\u0018\n\u001a\u0011\u0002)-\u0014\u0018M\u001a;WKJ\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005Y\u0006c\u0001/dK6\tQL\u0003\u0002_?\u0006Aa-\u001e8di&|gN\u0003\u0002aC\u0006!Q\u000f^5m\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z/\u0003\u0011M+\b\u000f\u001d7jKJ\u0004\"AZ8\u000e\u0003\u001dT!\u0001[5\u0002\r\r|W.\\8o\u0015\t\t%N\u0003\u0002DW*\u0011A.\\\u0001\u0007CB\f7\r[3\u000b\u00039\f1a\u001c:h\u0013\t\u0001xM\u0001\u0007L%\u00064GOV3sg&|g.A\u000ble\u00064GOV3sg&|gnU;qa2LWM\u001d\u0011\u0002\rqJg.\u001b;?)\r!XO\u001e\t\u0003\u001b\u0002AQaU\u0003A\u0002UCQ!W\u0003A\u0002m\u000bQbX2veJ,g\u000e^%nC\u001e,W#A=\u0011\u0005ilX\"A>\u000b\u0005qT\u0017!B5nC\u001e,\u0017B\u0001@|\u00055iU\r^1eCR\f\u0017*\\1hK\u0006\trlY;se\u0016tG/S7bO\u0016|F%Z9\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004\u000f\u0006\u0015\u0011bAA\u0004\u0011\n!QK\\5u\u0011!\tYaBA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005qqlY;se\u0016tG/S7bO\u0016\u0004\u0003f\u0001\u0005\u0002\u0012A\u0019q)a\u0005\n\u0007\u0005U\u0001J\u0001\u0005w_2\fG/\u001b7f\u0003ai\u0017-\u001f2f\r&dG/\u001a:BY&4XMU3qY&\u001c\u0017m\u001d\u000b\u000b\u00037\ty#!\r\u0002<\u00055\u0003CBA\u000f\u0003?\t\u0019#D\u0001`\u0013\r\t\tc\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tI#Y\u0001\u0005Y\u0006tw-\u0003\u0003\u0002.\u0005\u001d\"aB%oi\u0016<WM\u001d\u0005\u0006y&\u0001\r!\u001f\u0005\b\u0003gI\u0001\u0019AA\u001b\u0003\u001d\u0011'o\\6feN\u0004BaRA\u001c+&\u0019\u0011\u0011\b%\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005u\u0012\u00021\u0001\u0002@\u0005aA.[:uK:,'OT1nKB!\u0011\u0011IA%\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013a\u00028fi^|'o\u001b\u0006\u0003Q*LA!a\u0013\u0002D\taA*[:uK:,'OT1nK\"9\u0011qJ\u0005A\u0002\u0005E\u0013A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\bcA$\u0002T%\u0019\u0011Q\u000b%\u0003\u000f\t{w\u000e\\3b]\u0006a1-\u001e:sK:$\u0018*\\1hKR\t\u00110\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0003?\n\u0019+!*\u0002:\u0006m\u0016q\u0018\t\u0006\u000f\u0006\u0005\u0014QM\u0005\u0004\u0003GB%AB(qi&|g\u000e\u0005\u0004\u0002h\u0005]\u0014Q\u0010\b\u0005\u0003S\n\u0019H\u0004\u0003\u0002l\u0005ETBAA7\u0015\r\ty\u0007R\u0001\u0007yI|w\u000e\u001e \n\u0003%K1!!\u001eI\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u001f\u0002|\tA\u0011\n^3sCR|'OC\u0002\u0002v!\u0003B!a \u0002\u001e:!\u0011\u0011QAL\u001d\u0011\t\u0019)a%\u000f\t\u0005\u0015\u0015\u0011\u0013\b\u0005\u0003\u000f\u000byI\u0004\u0003\u0002\n\u00065e\u0002BA6\u0003\u0017K\u0011A\\\u0005\u0003Y6L!aQ6\n\u0005!T\u0017\u0002BAK\u0003\u000f\nq!\\3tg\u0006<W-\u0003\u0003\u0002\u001a\u0006m\u0015\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u0002\u0016\u0006\u001d\u0013\u0002BAP\u0003C\u0013\u0011$T3uC\u0012\fG/\u0019*fgB|gn]3QCJ$\u0018\u000e^5p]*!\u0011\u0011TAN\u0011\u0015a8\u00021\u0001z\u0011\u001d\t9k\u0003a\u0001\u0003S\u000b\u0011\u0002^8qS\u000et\u0015-\\3\u0011\t\u0005-\u00161\u0017\b\u0005\u0003[\u000by\u000bE\u0002\u0002l!K1!!-I\u0003\u0019\u0001&/\u001a3fM&!\u0011QWA\\\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0017%\t\u000f\u0005u2\u00021\u0001\u0002@!9\u0011QX\u0006A\u0002\u0005E\u0013!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiNDq!!1\f\u0001\u0004\t\t&A\rfeJ|'/\u00168bm\u0006LG.\u00192mK2K7\u000f^3oKJ\u001c\u0018\u0001L4fiB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018MR8s\t\u0016\u001c8M]5cKR{\u0007/[2SKN\u0004xN\\:f)1\t9-!9\u0002d\u0006\u0015\u0018q]Av!\u00199\u0015\u0011ZAg+&\u0019\u00111\u001a%\u0003\rQ+\b\u000f\\33!\u00159\u0015\u0011MAh!\u0019\t9'!5\u0002T&!\u0011\u0011EA>!\u0011\t).a7\u000f\t\u0005\u0005\u0015q[\u0005\u0005\u00033\fY*A\u0012EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019)beRLG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\n\t\u0005u\u0017q\u001c\u0002)\t\u0016\u001c8M]5cKR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c\u0006\u0005\u00033\fY\nC\u0003}\u0019\u0001\u0007\u0011\u0010C\u0004\u0002(2\u0001\r!!+\t\u000f\u0005uB\u00021\u0001\u0002@!1\u0011\u0011\u001e\u0007A\u0002U\u000b!b\u001d;beRLe\u000eZ3y\u0011\u0019\ti\u000f\u0004a\u0001+\u0006AQ.\u0019=D_VtG/\u0001\nhKR|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006\u001cH\u0003CA\u000e\u0003g\f)Pa\u0001\t\u000bql\u0001\u0019A=\t\u000f\u0005]X\u00021\u0001\u0002z\u0006I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003w\fy0\u0004\u0002\u0002~*\u0011qH[\u0005\u0005\u0005\u0003\tiPA\u000bQCJ$\u0018\u000e^5p]J+w-[:ue\u0006$\u0018n\u001c8\t\u000f\u0005uR\u00021\u0001\u0002@\u0005\u0001\u0012n\u001d*fa2L7-Y(gM2Lg.\u001a\u000b\t\u0003#\u0012IAa\u0003\u0003\u000e!9\u0011q\u001f\bA\u0002\u0005e\bbBA\u001f\u001d\u0001\u0007\u0011q\b\u0005\b\u0005\u001fq\u0001\u0019\u0001B\t\u0003\u0019\u0011'o\\6feB!\u00111 B\n\u0013\u0011\u0011)\"!@\u0003%\t\u0013xn[3s%\u0016<\u0017n\u001d;sCRLwN\\\u0001\u0016SN\u0014V\r\u001d7jG\u0006Len\u00144gY&tW\rR5s)\u0019\t\tFa\u0007\u0003\u001e!9!qB\bA\u0002\tE\u0001bBA|\u001f\u0001\u0007\u0011\u0011`\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$\u0002Ba\t\u0003.\t=\"1\u0007\t\u0006\u000f\u0006\u0005$Q\u0005\t\u0005\u0005O\u0011I#\u0004\u0002\u0002H%!!1FA$\u0005\u0011qu\u000eZ3\t\u000bq\u0004\u0002\u0019A=\t\r\tE\u0002\u00031\u0001V\u0003\tIG\rC\u0004\u0002>A\u0001\r!a\u0010\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fGC\u0003B\u001d\u0005\u0017\u0012)Fa\u0016\u0003ZA1!1\bB!\u0005\u000bj!A!\u0010\u000b\u0007\t}\u0002*\u0001\u0006d_2dWm\u0019;j_:LAAa\u0011\u0003>\t\u00191+Z9\u0011\t\u0005}$qI\u0005\u0005\u0005\u0013\n\tKA\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR{\u0007/[2\t\u000f\t5\u0013\u00031\u0001\u0003P\u00051Ao\u001c9jGN\u0004bAa\u000f\u0003R\u0005%\u0016\u0002\u0002B*\u0005{\u00111aU3u\u0011\u001d\ti$\u0005a\u0001\u0003\u007fA\u0011\"!0\u0012!\u0003\u0005\r!!\u0015\t\u0013\u0005\u0005\u0017\u0003%AA\u0002\u0005E\u0013AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTC\u0001B0U\u0011\t\tF!\u0019,\u0005\t\r\u0004\u0003\u0002B3\u0005_j!Aa\u001a\u000b\t\t%$1N\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u001cI\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005c\u00129GA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nAbZ3u\u00032dGk\u001c9jGN$BAa\u0014\u0003z!9!1\u0010\u000bA\u0002\tu\u0014a\u0004;f]\u0006tG\u000f\u0015:fM&Dx\n\u001d;\u0011\u000b\u001d\u000b\t'!+\u0002Q\u001d,G\u000fV8qS\u000elU\r^1eCR\fgi\u001c:EKN\u001c'/\u001b2f)>\u0004\u0018n\u0019*fgB|gn]3\u0015\u0019\t\r%1\u0012BH\u0005#\u0013YJa(\u0011\t\t\u0015%qQ\u0007\u0003\u00037KAA!#\u0002\u001c\n\u0019C)Z:de&\u0014W\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d*fgB|gn]3ECR\f\u0007b\u0002B'+\u0001\u0007!Q\u0012\t\u0007\u0003O\n9(!+\t\u000f\u0005uR\u00031\u0001\u0002@!9!1S\u000bA\u0002\tU\u0015\u0001\u0007;pa&\u001c\u0007+\u0019:uSRLwN\\*uCJ$\u0018J\u001c3fqB1qIa&\u0002*VK1A!'I\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0003\u001eV\u0001\r!V\u0001\u001a[\u0006D\u0018.\\;n\u001dVl'-\u001a:PMB\u000b'\u000f^5uS>t7\u000fC\u0004\u0003\"V\u0001\r!!\u0015\u00025%<gn\u001c:f)>\u0004\u0018nY:XSRDW\t_2faRLwN\\:\u0002%\u001d,G\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0005O\u0013y\u000b\u0005\u0004\u0003<\tE#\u0011\u0016\t\u0005\u0005O\u0011Y+\u0003\u0003\u0003.\u0006\u001d#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003O3\u0002\u0019AAU\u0003)9W\r\u001e+pa&\u001c\u0017\n\u001a\u000b\u0005\u0005k\u0013Y\f\u0005\u0003\u0003(\t]\u0016\u0002\u0002B]\u0003\u000f\u0012A!V;jI\"9\u0011qU\fA\u0002\u0005%\u0016\u0001D4fiR{\u0007/[2OC6,G\u0003\u0002B?\u0005\u0003DqAa1\u0019\u0001\u0004\u0011),A\u0004u_BL7-\u00133\u0002\u0019\u001d,G\u000fV8qS\u000e$\u0016\u0010]3\u0015\t\t%'\u0011\u001b\t\u0006\u000f\u0006\u0005$1\u001a\t\u0005\u0005O\u0011i-\u0003\u0003\u0003P\u0006\u001d#!\u0003+pa&\u001cG+\u001f9f\u0011\u001d\t9+\u0007a\u0001\u0003S\u000ba\u0002[1t\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0002R\t]\u0007\"B*\u001b\u0001\u0004)\u0016AD5t\u0005J|7.\u001a:GK:\u001cW\r\u001a\u000b\u0005\u0003#\u0012i\u000eC\u0003T7\u0001\u0007Q+\u0001\u000bjg\n\u0013xn[3s'\",H\u000f^5oO\u0012{wO\u001c\u000b\u0005\u0003#\u0012\u0019\u000fC\u0003T9\u0001\u0007Q+A\bhKR\fE.\u001b<f\u0005J|7.\u001a:t)\t\u0011I\u000f\u0005\u0004\u0002h\t-(q^\u0005\u0005\u0005[\fYH\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\u0011\tPa>\u000e\u0005\tM(b\u0001B{U\u0006)\u0011\rZ7j]&!!\u0011 Bz\u00059\u0011%o\\6fe6+G/\u00193bi\u0006$BA!;\u0003~\")AP\ba\u0001s\u0006\u0011r-\u001a;BY&4XM\u0011:pW\u0016\u0014hj\u001c3f)\u0019\u0011\u0019ca\u0001\u0004\u0006!)1k\ba\u0001+\"9\u0011QH\u0010A\u0002\u0005}\u0012!D4fi\n\u0013xn[3s)\u0006<7\u000f\u0006\u0003\u0004\f\rE\u0001\u0003\u0003B\u001e\u0007\u001b\tI+!+\n\t\r=!Q\b\u0002\u0004\u001b\u0006\u0004\b\"B*!\u0001\u0004)\u0016aD4fi\n\u0013xn[3s\u0007\u0016dG.\u00133\u0015\u0007U\u001b9\u0002C\u0003TC\u0001\u0007Q+A\nhKR\fE.\u001b<f\u0005J|7.\u001a:O_\u0012,7\u000f\u0006\u0003\u0004\u001e\r}\u0001C\u0002B\u001e\u0005\u0003\u0012)\u0003C\u0004\u0002>\t\u0002\r!a\u0010\u0002!\u001d,G\u000fU1si&$\u0018n\u001c8J]\u001a|GCBB\u0013\u0007k\u00199\u0004E\u0003H\u0003C\u001a9\u0003\u0005\u0003\u0004*\r=b\u0002BAA\u0007WIAa!\f\u0002\u001c\u0006IR\u000b\u001d3bi\u0016lU\r^1eCR\f'+Z9vKN$H)\u0019;b\u0013\u0011\u0019\tda\r\u00039U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>t7\u000b^1uK*!1QFAN\u0011\u001d\t9k\ta\u0001\u0003SCaa!\u000f$\u0001\u0004)\u0016a\u00039beRLG/[8o\u0013\u0012\f\u0011cZ3u!\u0006\u0014H/\u001b;j_:LeNZ8t)\t\u0019y\u0004\u0005\u0004\u0003<\t\u00053qE\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0015\t\r\u00153q\t\t\u0005\u000f\u0006\u0005T\u000bC\u0004\u0002(\u0016\u0002\r!!+\u0002\u001fQ|\u0007/[2OC6,7\u000fV8JIN$\"a!\u0014\u0011\u0011\u0005u1qJAU\u0005kK1aa\u0004`\u0003=!x\u000e]5d\u0013\u0012\u001cHk\u001c(b[\u0016\u001cHCAB+!!\tiba\u0014\u00036\u0006%\u0016a\u0003;pa&\u001c\u0017\nZ%oM>$\"aa\u0017\u0011\u000f\u001d\u000bIm!\u0014\u0004V\u0005Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA!1EB1\u0007G\u001a)\u0007C\u0004\u0002(&\u0002\r!!+\t\r\re\u0012\u00061\u0001V\u0011\u001d\ti$\u000ba\u0001\u0003\u007f\tAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u0004l\r54\u0011\u000f\t\b\u0005w\u0019i!\u0016B\u0013\u0011\u001d\u0019yG\u000ba\u0001\u0005S\u000b!\u0001\u001e9\t\u000f\u0005u\"\u00061\u0001\u0002@\u0005yq-\u001a;D_:$(o\u001c7mKJLE-\u0006\u0002\u0004xA)q)!\u0019\u0004zA!11PB?\u001b\u0005\u0001\u0015bAB@\u0001\n\u00112)Y2iK\u0012\u001cuN\u001c;s_2dWM]%e\u0003Y9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6fe&#WCAB#\u0003Q9W\r\u001e*b]\u0012|W.\u00117jm\u0016\u0014%o\\6feR!1QIBE\u0011\u0015aX\u00061\u0001z\u0003M9W\r^!mSZ,'I]8lKJ,\u0005o\\2i)\u0011\u0019yia&\u0011\u000b\u001d\u000b\tg!%\u0011\u0007\u001d\u001b\u0019*C\u0002\u0004\u0016\"\u0013A\u0001T8oO\")1K\fa\u0001+\u0006\u0011r-\u001a;DYV\u001cH/\u001a:NKR\fG-\u0019;b)\u0019\u0019ija)\u0004(B!!qEBP\u0013\u0011\u0019\t+a\u0012\u0003\u000f\rcWo\u001d;fe\"91QU\u0018A\u0002\u0005%\u0016!C2mkN$XM]%e\u0011\u001d\tid\fa\u0001\u0003\u007f\t\u0001bY8oi\u0006Lgn\u001d\u000b\u0005\u0003#\u001ai\u000bC\u0004\u0002(B\u0002\r!!+\u0015\t\u0005E3\u0011\u0017\u0005\b\u0007_\n\u0004\u0019\u0001BU\u0003!\u0019X\r^%nC\u001e,G\u0003BA\u0002\u0007oCaa!/3\u0001\u0004I\u0018\u0001\u00038fo&k\u0017mZ3\u0002\u0011\u001d,G/S7bO\u0016\faaY8oM&<G\u0003BBa\u0007\u000f\u0004B!!\b\u0004D&\u00191QY0\u0003\u0015A\u0013x\u000e]3si&,7\u000fC\u0004\u0004JR\u0002\raa3\u0002\u001d\r|gNZ5h%\u0016\u001cx.\u001e:dKB!1QZBi\u001b\t\u0019yM\u0003\u0003\u0004>\u0006\u001d\u0013\u0002BBj\u0007\u001f\u0014abQ8oM&<'+Z:pkJ\u001cW-\u0001\u000beKN\u001c'/\u001b2f\u00072LWM\u001c;Rk>$\u0018m\u001d\u000b\u0005\u00073\u001cy\u000e\u0005\u0003\u0003\u0006\u000em\u0017\u0002BBo\u00037\u0013\u0001\u0005R3tGJL'-Z\"mS\u0016tG/U;pi\u0006\u001c(+Z:q_:\u001cX\rR1uC\"91\u0011]\u001bA\u0002\r\r\u0018a\u0002:fcV,7\u000f\u001e\t\u0005\u0005\u000b\u001b)/\u0003\u0003\u0004h\u0006m%a\b#fg\u000e\u0014\u0018NY3DY&,g\u000e^)v_R\f7OU3rk\u0016\u001cH\u000fR1uC\u0006AB-Z:de&\u0014WmU2sC6\u001c%/\u001a3f]RL\u0017\r\\:\u0015\t\r581\u001f\t\u0005\u0005\u000b\u001by/\u0003\u0003\u0004r\u0006m%\u0001\u000b#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fgB|gn]3ECR\f\u0007bBBqm\u0001\u00071Q\u001f\t\u0005\u0005\u000b\u001b90\u0003\u0003\u0004z\u0006m%a\n#fg\u000e\u0014\u0018NY3Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d*fcV,7\u000f\u001e#bi\u0006\fq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\u000b\u0003\u0007\u007f\u00042A\u001aC\u0001\u0013\r!\u0019a\u001a\u0002\u0010\u001b\u0016$\u0018\rZ1uCZ+'o]5p]\u0006Aa-Z1ukJ,7\u000f\u0006\u0002\u0005\nA\u0019a\rb\u0003\n\u0007\u00115qMA\tGS:\fG.\u001b>fI\u001a+\u0017\r^;sKN\f\u0001#[:Ce>\\WM\u001d#fOJ\fG-\u001a3\u0015\t\u0005EC1\u0003\u0005\u0006'f\u0002\r!V\u0001\u001aSN\u0014%o\\6fe\u000e{W\u000e]8oK:$H)Z4sC\u0012,G\r\u0006\u0004\u0002R\u0011eA1\u0004\u0005\u0006'j\u0002\r!\u0016\u0005\b\t;Q\u0004\u0019\u0001C\u0010\u0003%\u0019w.\u001c9p]\u0016tG\u000f\u0005\u0003\u0005\"\u0011%RB\u0001C\u0012\u0015\u0011\u0011)\u0010\"\n\u000b\u0007\u0011\u001d\".A\u0004dY&,g\u000e^:\n\t\u0011-B1\u0005\u0002\u0010\u0005J|7.\u001a:D_6\u0004xN\\3oi\u0006\u0001R.\u001b:s_J$v\u000e]5d'R\fG/\u001a\u000b\u0005\tc!y\u0004E\u0003H\u0003C\"\u0019\u0004\u0005\u0003\u00056\u0011mRB\u0001C\u001c\u0015\r!I\u0004Q\u0001\u0005Y&t7.\u0003\u0003\u0005>\u0011]\"!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/\u001a\u0005\b\t\u0003Z\u0004\u0019AAU\u0003\u0015!x\u000e]5d\u0003Ya\u0017N\\6D_>\u0014H-\u001b8bi>\u0014XI\\1cY\u0016$WCAA)\u0001")
public class KRaftMetadataCache
implements KRaftImageMetadataCache {
    private final int brokerId;
    private final Supplier<KRaftVersion> kraftVersionSupplier;
    private volatile MetadataImage _currentImage;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public Properties topicConfig(String topicName) {
        return ConfigRepository.topicConfig$(this, topicName);
    }

    @Override
    public Properties brokerConfig(int brokerId) {
        return ConfigRepository.brokerConfig$(this, brokerId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public int brokerId() {
        return this.brokerId;
    }

    public Supplier<KRaftVersion> kraftVersionSupplier() {
        return this.kraftVersionSupplier;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private java.util.List<Integer> maybeFilterAliveReplicas(MetadataImage image, int[] brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return Replicas.toList((int[])brokers);
        }
        ArrayList<Integer> res = new ArrayList<Integer>(brokers.length);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokers)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Option$.MODULE$.apply((Object)image.cluster().broker(brokerId)).foreach((Function1 & Serializable & scala.Serializable)b -> {
            if (!b.fenced() && b.listeners().containsKey(listenerName.value())) {
                return BoxesRunTime.boxToBoolean((boolean)res.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }));
        return res;
    }

    @Override
    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topicName, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            if (((Object)BoxesRunTime.boxToByte((byte)topic.topicType())).equals(BoxesRunTime.boxToByte((byte)TopicType.VIRTUAL.id()))) {
                int n;
                Option option2 = this.getAliveBrokers().toSeq().headOption();
                if (None$.MODULE$.equals(option2)) {
                    n = -1;
                } else if (option2 instanceof Some) {
                    n = ((BrokerMetadata)((Some)option2).value()).id;
                } else {
                    throw new MatchError((Object)option2);
                }
                int virtualTopicLeaderId = n;
                return Option$.MODULE$.apply((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetadataResponseData.MetadataResponsePartition[]{new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(0).setLeaderId(virtualTopicLeaderId).setLeaderEpoch(-1).setReplicaNodes(Collections.emptyList()).setObservers(Collections.emptyList()).setIsrNodes(Collections.emptyList()).setOfflineReplicas(Collections.emptyList())})));
            }
            return new Some((Object)((GenSetLike)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().entrySet()).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                Integer partitionId = (Integer)entry.getKey();
                PartitionRegistration partition = (PartitionRegistration)entry.getValue();
                java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partition.observers, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr, listenerName, errorUnavailableEndpoints);
                java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partition, listenerName);
                Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leader, listenerName);
                if (None$.MODULE$.equals(maybeLeader)) {
                    Errors errors;
                    if (!image.cluster().brokers().containsKey(BoxesRunTime.boxToInteger((int)partition.leader))) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": leader not available").toString());
                        errors = Errors.LEADER_NOT_AVAILABLE;
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition$1.leader).toString());
                        errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                if (maybeLeader instanceof Some) {
                    Errors errors;
                    Node leader = (Node)((Some)maybeLeader).value();
                    if (filteredReplicas.size() < partition.replicas.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.replicas)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else if (filteredIsr.size() < partition.isr.length) {
                        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(101).append("Error while fetching metadata for ").append(topicName).append("-").append(partitionId).append(": in sync replica information not available for ").append("following brokers ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition$1.isr)).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1))))).mkString(",")).toString());
                        errors = Errors.REPLICA_NOT_AVAILABLE;
                    } else {
                        errors = Errors.NONE;
                    }
                    Errors error = errors;
                    return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(Predef$.MODULE$.Integer2int(partitionId)).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch).setReplicaNodes(filteredReplicas).setObservers(filteredObservers).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
                }
                throw new MatchError(maybeLeader);
            }, Set$.MODULE$.canBuildFrom())).iterator());
        }
        throw new MatchError((Object)option);
    }

    private Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> getPartitionMetadataForDescribeTopicResponse(MetadataImage image, String topicName, ListenerName listenerName, int startIndex, int maxCount) {
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)-1));
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            ListBuffer result = new ListBuffer();
            java.util.Set partitions = topic.partitions().keySet();
            int upperIndex = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(topic.partitions().size()), startIndex + maxCount);
            int nextIndex = upperIndex < partitions.size() ? upperIndex : -1;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startIndex), upperIndex).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> {
                PartitionRegistration partitionRegistration = (PartitionRegistration)topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId));
                if (partitionRegistration != null) {
                    java.util.List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partitionRegistration.replicas, listenerName, false);
                    java.util.List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partitionRegistration.isr, listenerName, false);
                    java.util.List<Integer> filteredObservers = this.maybeFilterAliveReplicas(image, partitionRegistration.observers, listenerName, false);
                    java.util.List<Integer> offlineReplicas = this.getOfflineReplicas(image, partitionRegistration, listenerName);
                    Option<Node> maybeLeader = this.getAliveEndpoint(image, partitionRegistration.leader, listenerName);
                    if (None$.MODULE$.equals(maybeLeader)) {
                        result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition[]{new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(-1).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr))}));
                        return;
                    }
                    if (maybeLeader instanceof Some) {
                        Node leader = (Node)((Some)maybeLeader).value();
                        result.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition[]{new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition().setPartitionIndex(partitionId).setLeaderId(leader.id()).setLeaderEpoch(partitionRegistration.leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setObservers(filteredObservers).setOfflineReplicas(offlineReplicas).setEligibleLeaderReplicas(Replicas.toList((int[])partitionRegistration.elr)).setLastKnownElr(Replicas.toList((int[])partitionRegistration.lastKnownElr))}));
                        return;
                    }
                    throw new MatchError(maybeLeader);
                }
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("The partition ").append(partitionId).append(" does not exist for ").append(topicName).toString());
            });
            return new Tuple2((Object)new Some((Object)result.toList()), (Object)BoxesRunTime.boxToInteger((int)nextIndex));
        }
        throw new MatchError((Object)option);
    }

    private java.util.List<Integer> getOfflineReplicas(MetadataImage image, PartitionRegistration partition, ListenerName listenerName) {
        ArrayList<Integer> offlineReplicas = new ArrayList<Integer>(0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1 & Serializable & scala.Serializable)brokerId -> KRaftMetadataCache.$anonfun$getOfflineReplicas$1(this, image, offlineReplicas, partition, listenerName, BoxesRunTime.unboxToInt((Object)brokerId)));
        return offlineReplicas;
    }

    private boolean isReplicaOffline(PartitionRegistration partition, ListenerName listenerName, BrokerRegistration broker) {
        return broker.fenced() || !broker.listeners().containsKey(listenerName.value()) || this.isReplicaInOfflineDir(broker, partition);
    }

    private boolean isReplicaInOfflineDir(BrokerRegistration broker, PartitionRegistration partition) {
        return !broker.hasOnlineDir(partition.directory(broker.id()));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)image.cluster().broker(id)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$1.node(listenerName.value()))));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> {
            TopicImage topicImage = image.topics().getTopic(topic);
            return new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)Option$.MODULE$.apply((Object)topicImage.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()).setTopicType(topicImage.topicType());
        })), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics(Option<String> tenantPrefixOpt) {
        if (None$.MODULE$.equals(tenantPrefixOpt)) {
            return (Set)CollectionConverters$.MODULE$.asScalaSetConverter(this._currentImage().topics().topicsByName().keySet()).asScala();
        }
        if (tenantPrefixOpt instanceof Some) {
            String tenantName = (String)((Some)tenantPrefixOpt).value();
            return (Set)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)this._currentImage().topics().topicsByTenant(tenantName)).asScala();
        }
        throw new MatchError(tenantPrefixOpt);
    }

    @Override
    public DescribeTopicPartitionsResponseData getTopicMetadataForDescribeTopicResponse(Iterator<String> topics, ListenerName listenerName, Function1<String, Object> topicPartitionStartIndex, int maximumNumberOfPartitions, boolean ignoreTopicsWithExceptions) {
        MetadataImage image = this._currentImage();
        IntRef remaining = IntRef.create((int)maximumNumberOfPartitions);
        DescribeTopicPartitionsResponseData result = new DescribeTopicPartitionsResponseData();
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topics.foreach((Function1 & Serializable & scala.Serializable)topicName -> {
            if (remaining$1.elem > 0) {
                void var9_9;
                Tuple2<Option<List<DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponsePartition>>, Object> tuple2 = this.getPartitionMetadataForDescribeTopicResponse(image, (String)topicName, listenerName, BoxesRunTime.unboxToInt((Object)topicPartitionStartIndex.apply(topicName)), remaining$1.elem);
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Option partitionResponse = (Option)tuple2._1();
                int n = tuple2._2$mcI$sp();
                var9_9.map((Function1 & Serializable & scala.Serializable)partitions -> {
                    KRaftMetadataCache.$anonfun$getTopicMetadataForDescribeTopicResponse$3(topicName, image, result, n, remaining, partitions);
                    return BoxedUnit.UNIT;
                });
                if (!ignoreTopicsWithExceptions && var9_9.isEmpty()) {
                    Errors errors;
                    try {
                        Topic.validate((String)topicName);
                        errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
                    }
                    catch (InvalidTopicException invalidTopicException) {
                        errors = Errors.INVALID_TOPIC_EXCEPTION;
                    }
                    Errors error = errors;
                    return BoxesRunTime.boxToBoolean((boolean)result.topics().add((ImplicitLinkedHashCollection.Element)new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(error.code()).setName(topicName).setTopicId(this.getTopicId((String)topicName)).setIsInternal(Topic.isInternal((String)topicName))));
                }
                return BoxedUnit.UNIT;
            }
            if (remaining$1.elem == 0) {
                result.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName).setPartitionIndex(0));
                throw Breaks$.MODULE$.break();
            }
            return BoxedUnit.UNIT;
        }));
        return result;
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return scala.collection.Set$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return (Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(topic.partitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> new TopicPartition(topicName, Predef$.MODULE$.Integer2int(x$3)), Set$.MODULE$.canBuildFrom());
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Uuid getTopicId(String topicName) {
        return (Uuid)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsByName()).asScala()).get((Object)topicName).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID);
    }

    @Override
    public Option<String> getTopicName(Uuid topicId) {
        return ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this._currentImage().topics().topicsById()).asScala()).get((Object)topicId).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.name());
    }

    @Override
    public Option<TopicType> getTopicType(String topicName) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return Option$.MODULE$.empty();
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            return Option$.MODULE$.apply((Object)TopicType.forId((byte)topic.topicType()));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$hasAliveBroker$1(x$6))) == 1;
    }

    public boolean isBrokerFenced(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.fenced())) == 1;
    }

    public boolean isBrokerShuttingDown(int brokerId) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId))).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.inControlledShutdown())) == 1;
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return this.getAliveBrokers(this._currentImage());
    }

    private Iterable<BrokerMetadata> getAliveBrokers(MetadataImage image) {
        return (Iterable)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(image.cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.fenced()))).map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.fenced())).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$11.node(listenerName.value()))));
    }

    @Override
    public Map<String, String> getBrokerTags(int brokerId) {
        return Map$.MODULE$.empty();
    }

    @Override
    public int getBrokerCellId(int brokerId) {
        return this._currentImage().cells().getBrokerCellId(brokerId);
    }

    public Seq<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this._currentImage().cluster().brokers().values()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.fenced()))).flatMap((Function1 & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(x$13.node(listenerName.value())))), Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topicName, int partitionId) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)))).flatMap((Function1 & Serializable & scala.Serializable)partition -> new Some((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(-1).setLeader(partition.leader).setLeaderEpoch(partition.leaderEpoch).setIsr(Replicas.toList((int[])partition.isr)).setZkVersion(partition.partitionEpoch).setReplicas(Replicas.toList((int[])partition.replicas)).setObservers(Replicas.toList((int[])partition.observers))));
    }

    @Override
    public Seq<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfos() {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this._currentImage().topics().topicsByName().values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)img -> (scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(img.partitions().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionId -> (UpdateMetadataRequestData.UpdateMetadataPartitionState)this.getPartitionInfo(img.name(), Predef$.MODULE$.Integer2int(partitionId)).orNull(Predef$.MODULE$.$conforms()), Set$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$getPartitionInfos$3(p)))).toSeq();
    }

    @Override
    public Option<Object> numPartitions(String topicName) {
        return Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(topicName)).map((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToInteger((int)KRaftMetadataCache.$anonfun$numPartitions$1(topic)));
    }

    @Override
    public java.util.Map<String, Uuid> topicNamesToIds() {
        return this._currentImage().topics().topicNameToIdView();
    }

    @Override
    public java.util.Map<Uuid, String> topicIdsToNames() {
        return this._currentImage().topics().topicIdToNameView();
    }

    @Override
    public Tuple2<java.util.Map<String, Uuid>, java.util.Map<Uuid, String>> topicIdInfo() {
        MetadataImage image = this._currentImage();
        return new Tuple2((Object)image.topics().topicNameToIdView(), (Object)image.topics().topicIdToNameView());
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topicName, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        Option option = Option$.MODULE$.apply((Object)image.topics().getTopic(topicName));
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            TopicImage topic = (TopicImage)((Some)option).value();
            Option option2 = Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)partitionId)));
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                PartitionRegistration partition = (PartitionRegistration)((Some)option2).value();
                Option option3 = Option$.MODULE$.apply((Object)image.cluster().broker(partition.leader));
                if (None$.MODULE$.equals(option3)) {
                    return new Some((Object)Node.noNode());
                }
                if (option3 instanceof Some) {
                    BrokerRegistration broker = (BrokerRegistration)((Some)option3).value();
                    return new Some((Object)broker.node(listenerName.value()).orElse(Node.noNode()));
                }
                throw new MatchError((Object)option3);
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    @Override
    public Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        scala.collection.mutable.HashMap result = new scala.collection.mutable.HashMap();
        Option$.MODULE$.apply((Object)image.topics().getTopic(tp.topic())).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$1(tp, image, listenerName, result, topic);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    @Override
    public Option<CachedControllerId> getControllerId() {
        return this.getRandomAliveBroker(this._currentImage()).map((Function1)KRaftCachedControllerId$.MODULE$);
    }

    @Override
    public Option<Object> getRandomAliveBrokerId() {
        return this.getRandomAliveBroker(this._currentImage());
    }

    private Option<Object> getRandomAliveBroker(MetadataImage image) {
        List aliveBrokers = this.getAliveBrokers(image).toList();
        if (aliveBrokers.isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)((BrokerMetadata)aliveBrokers.apply((int)ThreadLocalRandom.current().nextInt((int)aliveBrokers.size()))).id));
    }

    public Option<Object> getAliveBrokerEpoch(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).filterNot((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.fenced())).map((Function1 & Serializable & scala.Serializable)brokerRegistration -> BoxesRunTime.boxToLong((long)brokerRegistration.epoch()));
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.cluster().brokers().values().forEach(broker -> {
            if (!broker.fenced()) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(broker.node(listenerName.value()))).foreach((Function1 & Serializable & scala.Serializable)node -> nodes.put(Predef$.MODULE$.int2Integer(broker.id()), node));
                return;
            }
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.topics().topicsByName().values().forEach(topic -> topic.partitions().forEach((key, value) -> {
            partitionInfos.add(new PartitionInfo(topic.name(), Predef$.MODULE$.Integer2int(key), KRaftMetadataCache.node$1(value.leader, nodes), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value.replicas)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(value.isr)).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)replica), nodes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Node.class))), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.getOfflineReplicas(image, (PartitionRegistration)value, listenerName)).asScala()).map((Function1 & Serializable & scala.Serializable)replica -> KRaftMetadataCache.node$1(Predef$.MODULE$.Integer2int(replica), nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)topic.name())) {
                internalTopics.add(topic.name());
                return;
            }
        }));
        Node controllerNode = KRaftMetadataCache.node$1(BoxesRunTime.unboxToInt((Object)this.getRandomAliveBroker(image).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1)), nodes);
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, controllerNode);
    }

    @Override
    public boolean contains(String topicName) {
        return this._currentImage().topics().topicsByName().containsKey((Object)topicName);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        Option option = Option$.MODULE$.apply((Object)this._currentImage().topics().getTopic(tp.topic()));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return ((TopicImage)((Some)option).value()).partitions().containsKey(BoxesRunTime.boxToInteger((int)tp.partition()));
        }
        throw new MatchError((Object)option);
    }

    @Override
    public void setImage(MetadataImage newImage) {
        this._currentImage_$eq(newImage);
    }

    public MetadataImage getImage() {
        return this._currentImage();
    }

    @Override
    public Properties config(ConfigResource configResource) {
        return this._currentImage().configs().configProperties(configResource);
    }

    @Override
    public DescribeClientQuotasResponseData describeClientQuotas(DescribeClientQuotasRequestData request) {
        return this._currentImage().clientQuotas().describe(request);
    }

    @Override
    public DescribeUserScramCredentialsResponseData describeScramCredentials(DescribeUserScramCredentialsRequestData request) {
        return this._currentImage().scram().describe(request);
    }

    @Override
    public MetadataVersion metadataVersion() {
        return this._currentImage().features().metadataVersion();
    }

    @Override
    public FinalizedFeatures features() {
        MetadataImage image = this._currentImage();
        HashMap<String, Short> finalizedFeatures = new HashMap<String, Short>(image.features().finalizedVersions());
        short kraftVersionLevel = this.kraftVersionSupplier().get().featureLevel();
        if (kraftVersionLevel > 0) {
            finalizedFeatures.put("kraft.version", Predef$.MODULE$.short2Short(kraftVersionLevel));
        }
        return new FinalizedFeatures(image.features().metadataVersion(), finalizedFeatures, image.highestOffsetAndEpoch().offset(), true);
    }

    @Override
    public boolean isBrokerDegraded(int brokerId) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable & scala.Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerDegraded$1(registration)));
    }

    @Override
    public boolean isBrokerComponentDegraded(int brokerId, BrokerComponent component) {
        return Option$.MODULE$.apply((Object)this._currentImage().cluster().broker(brokerId)).exists((Function1 & Serializable & scala.Serializable)registration -> BoxesRunTime.boxToBoolean((boolean)KRaftMetadataCache.$anonfun$isBrokerComponentDegraded$1(component, registration)));
    }

    @Override
    public Option<ClusterLinkTopicState> mirrorTopicState(String topic) {
        TopicImage topicImage = this._currentImage().topics().getTopic(topic);
        if (topicImage == null) {
            return None$.MODULE$;
        }
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(topicImage.mirrorTopic())).map((Function1 & Serializable & scala.Serializable)state -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)state));
    }

    @Override
    public boolean linkCoordinatorEnabled() {
        return true;
    }

    public static final /* synthetic */ Object $anonfun$getOfflineReplicas$1(KRaftMetadataCache $this, MetadataImage image$4, ArrayList offlineReplicas$1, PartitionRegistration partition$2, ListenerName listenerName$4, int brokerId) {
        Option option = Option$.MODULE$.apply((Object)image$4.cluster().broker(brokerId));
        if (None$.MODULE$.equals(option)) {
            return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
        }
        if (option instanceof Some) {
            BrokerRegistration broker = (BrokerRegistration)((Some)option).value();
            if ($this.isReplicaOffline(partition$2, listenerName$4, broker)) {
                return BoxesRunTime.boxToBoolean((boolean)offlineReplicas$1.add(Predef$.MODULE$.int2Integer(brokerId)));
            }
            return BoxedUnit.UNIT;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadataForDescribeTopicResponse$3(String topicName$3, MetadataImage image$6, DescribeTopicPartitionsResponseData result$2, int nextPartition$1, IntRef remaining$1, List partitions) {
        DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic response = new DescribeTopicPartitionsResponseData.DescribeTopicPartitionsResponseTopic().setErrorCode(Errors.NONE.code()).setName(topicName$3).setTopicId((Uuid)Option$.MODULE$.apply((Object)image$6.topics().getTopic(topicName$3).id()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topicName$3)).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions).asJava());
        result$2.topics().add((ImplicitLinkedHashCollection.Element)response);
        if (nextPartition$1 != -1) {
            result$2.setNextCursor(new DescribeTopicPartitionsResponseData.Cursor().setTopicName(topicName$3).setPartitionIndex(nextPartition$1));
            throw Breaks$.MODULE$.break();
        }
        remaining$1.elem -= partitions.size();
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveBroker$1(BrokerRegistration x$6) {
        return !x$6.fenced();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionInfos$3(UpdateMetadataRequestData.UpdateMetadataPartitionState p) {
        return p != null;
    }

    public static final /* synthetic */ int $anonfun$numPartitions$1(TopicImage topic) {
        return topic.partitions().size();
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$2(MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, PartitionRegistration partition) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partition.replicas)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)replicaId -> {
            BrokerRegistration broker = image$7.cluster().broker(replicaId);
            if (broker != null && !broker.fenced()) {
                broker.node(listenerName$10.value()).ifPresent(node -> {
                    if (!node.isEmpty()) {
                        result$3.put((Object)BoxesRunTime.boxToInteger((int)replicaId), node);
                        return;
                    }
                });
                return;
            }
        });
    }

    public static final /* synthetic */ void $anonfun$getPartitionReplicaEndpoints$1(TopicPartition tp$1, MetadataImage image$7, ListenerName listenerName$10, scala.collection.mutable.HashMap result$3, TopicImage topic) {
        Option$.MODULE$.apply(topic.partitions().get(BoxesRunTime.boxToInteger((int)tp$1.partition()))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            KRaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$2(image$7, listenerName$10, result$3, partition);
            return BoxedUnit.UNIT;
        });
    }

    private static final Node node$1(int id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(BoxesRunTime.boxToInteger((int)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerDegraded$1(BrokerRegistration registration) {
        return !registration.degradedComponents().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isBrokerComponentDegraded$1(BrokerComponent component$1, BrokerRegistration registration) {
        return registration.degradedComponents().stream().anyMatch(degradedComponent -> {
            BrokerComponent brokerComponent = degradedComponent.component();
            return !(brokerComponent != null ? !brokerComponent.equals(component$1) : component$1 != null);
        });
    }

    public KRaftMetadataCache(int brokerId, Supplier<KRaftVersion> kraftVersionSupplier) {
        this.brokerId = brokerId;
        this.kraftVersionSupplier = kraftVersionSupplier;
        Logging.$init$(this);
        ConfigRepository.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this._currentImage = MetadataImage.EMPTY;
    }
}

