/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.backupObjectLifecycle;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.ConfigException;

public class LifecycleManagerConfig {
    public final Supplier<Map<String, Object>> interBrokerClientConfigs;
    public final String clusterId;
    public final int brokerId;
    public final Short tierMetadataNumPartitions;
    public final Long tierMetadataMaxPollMs;
    public final Supplier<Boolean> customLifecycleManagerEnabled;
    public final Supplier<Integer> customLifecycleManagerFrequencyInMs;
    public final Supplier<Integer> maxBackupInDays;
    public final Supplier<String> topicRetentionToBackupInDays;
    public final Supplier<InternalAdmin> internalAdmin;
    public final Supplier<Long> minDelayInMs;
    public final Supplier<Integer> threadPoolSize;
    public final Supplier<Integer> tierTopicSnapshotRetentionHours;
    public final Supplier<Integer> listObjectThreadPoolSize;

    public LifecycleManagerConfig(KafkaConfig config, String clusterId, Supplier<Map<String, Object>> interBrokerClientConfigs, Supplier<InternalAdmin> internalAdmin) {
        this.interBrokerClientConfigs = interBrokerClientConfigs;
        this.clusterId = clusterId;
        this.customLifecycleManagerEnabled = () -> config.confluentConfig().customLifecycleManagerEnabled();
        this.brokerId = config.brokerId();
        this.tierMetadataNumPartitions = config.confluentConfig().tierMetadataNumPartitions();
        this.tierMetadataMaxPollMs = config.confluentConfig().tierMetadataMaxPollMs();
        this.customLifecycleManagerFrequencyInMs = () -> config.confluentConfig().customLifecycleManagerFrequencyInHours() * 60 * 60 * 1000;
        this.maxBackupInDays = () -> config.confluentConfig().clmMaxBackupInDays();
        this.topicRetentionToBackupInDays = () -> config.confluentConfig().clmTopicRetentionInDaysToBackupInDays();
        this.internalAdmin = internalAdmin;
        this.minDelayInMs = () -> TimeUnit.MILLISECONDS.convert(config.confluentConfig().clmMinDelayInMinutes().intValue(), TimeUnit.MINUTES);
        this.threadPoolSize = () -> config.confluentConfig().clmThreadPoolSize();
        this.tierTopicSnapshotRetentionHours = () -> config.confluentConfig().tierTopicSnapshotsRetentionHours();
        this.listObjectThreadPoolSize = () -> config.confluentConfig().clmListObjectThreadPoolSize();
    }

    public static TreeMap<Long, Integer> parseRetentionToBackupConfig(String config) {
        TreeMap<Long, Integer> retentionToBackup = new TreeMap<Long, Integer>();
        config = LifecycleManagerConfig.trimAndCheckEmpty(config);
        for (String token : config.split(",")) {
            String[] kvPair = token.split(":");
            if (kvPair.length != 2) {
                throw new ConfigException("Provide config string as comma separated key value pairs. Example 1:1,2:2,3:3");
            }
            Long retentionInDays = Long.parseLong(kvPair[0]);
            int backupInDays = Integer.parseInt(kvPair[1]);
            if (retentionInDays < -1L) {
                throw new ConfigException("Topic Retention cannot be less than -1");
            }
            if (retentionToBackup.containsKey(retentionInDays)) {
                throw new ConfigException("Configuration cannot allow duplicate entries");
            }
            if (backupInDays < 0) {
                throw new ConfigException("Backup duration cannot be less than zero");
            }
            retentionToBackup.put(retentionInDays, backupInDays);
        }
        if (!retentionToBackup.containsKey(0L)) {
            retentionToBackup.put(0L, 0);
        }
        if (!retentionToBackup.containsKey(-1L)) {
            retentionToBackup.put(-1L, retentionToBackup.lastEntry().getValue());
        }
        LifecycleManagerConfig.ensureBackupIncreasesMonotonically(retentionToBackup);
        return retentionToBackup;
    }

    private static void ensureBackupIncreasesMonotonically(TreeMap<Long, Integer> retentionToBackup) {
        Integer backupForTopicWithInfiniteRetention;
        Integer prevValue = Integer.MIN_VALUE;
        for (Map.Entry<Long, Integer> entry : retentionToBackup.entrySet()) {
            if (entry.getKey() == -1L) continue;
            if (entry.getValue() < prevValue) {
                throw new ConfigException("Backup duration must monotonically increase with topic retention");
            }
            prevValue = entry.getValue();
        }
        if (retentionToBackup.containsKey(-1L) && (backupForTopicWithInfiniteRetention = retentionToBackup.get(-1L)) < prevValue) {
            throw new ConfigException("Backup duration must monotonically increase with topic retention");
        }
    }

    private static String trimAndCheckEmpty(String config) {
        if ((config = config.trim()).startsWith("\"")) {
            config = config.substring(1);
        }
        if (config.endsWith("\"")) {
            config = config.substring(0, config.length() - 1);
        }
        if (config.isEmpty()) {
            throw new ConfigException("Configuration string cannot be empty");
        }
        return config;
    }
}

