/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.encryption;

import com.google.common.io.BaseEncoding;
import com.google.crypto.tink.CleartextKeysetHandle;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.proto.Keyset;
import java.util.Arrays;
import kafka.tier.store.encryption.Util;

public final class CleartextDataKey {
    private final byte[] rawKeyMaterial;

    CleartextDataKey(KeysetHandle dataKeySetHandle) {
        Keyset cleartext = CleartextKeysetHandle.getKeyset((KeysetHandle)dataKeySetHandle);
        this.rawKeyMaterial = Util.extractRawAes256GCMKey(cleartext);
    }

    byte[] rawKeyMaterial() {
        return this.rawKeyMaterial;
    }

    public String base64Encoded() {
        BaseEncoding encoding = BaseEncoding.base64();
        return encoding.encode(this.rawKeyMaterial);
    }

    public String toString() {
        return "DecryptedDataKey";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CleartextDataKey that = (CleartextDataKey)o;
        return Arrays.equals(this.rawKeyMaterial, that.rawKeyMaterial);
    }

    public int hashCode() {
        return Arrays.hashCode(this.rawKeyMaterial);
    }
}

