/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.state.SegmentAndMetadataLayout;
import kafka.tier.state.SegmentState;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentDescriptionWrapper;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;
import kafka.utils.CoreUtils;

public class ObjectMetadata
implements ObjectStoreMetadata {
    private static final int CURRENT_KEY_PATH_VERSION = 0;
    private static final Set<FragmentType> VALID_FRAGMENT_TYPES_FOR_SEGMENT_METADATA = new HashSet<FragmentType>(Arrays.asList(FragmentType.HEADER, FragmentType.SEGMENT, FragmentType.OFFSET_INDEX, FragmentType.TIMESTAMP_INDEX, FragmentType.TRANSACTION_INDEX, FragmentType.PRODUCER_STATE, FragmentType.EPOCH_STATE));
    private final TopicIdPartition topicIdPartition;
    private final UUID objectId;
    private final int tierEpoch;
    private final long baseOffset;
    private final boolean hasAbortedTxns;
    private final boolean hasProducerState;
    private final boolean hasEpochState;
    private final int version = 0;
    private final OpaqueData opaqueData;
    private final SegmentAndMetadataLayout segmentAndMetadataLayout;

    public ObjectMetadata(TopicIdPartition topicIdPartition, UUID objectId, int tierEpoch, long baseOffset, boolean hasAbortedTxns, boolean hasProducerState, boolean hasEpochState, OpaqueData opaqueData, SegmentAndMetadataLayout segmentAndMetadataLayout) {
        this.topicIdPartition = topicIdPartition;
        this.objectId = objectId;
        this.tierEpoch = tierEpoch;
        this.baseOffset = baseOffset;
        this.hasAbortedTxns = hasAbortedTxns;
        this.hasProducerState = hasProducerState;
        this.hasEpochState = hasEpochState;
        this.opaqueData = opaqueData;
        this.segmentAndMetadataLayout = segmentAndMetadataLayout;
    }

    public ObjectMetadata(TierSegmentUploadInitiate uploadInitiate) {
        this(uploadInitiate.topicIdPartition(), uploadInitiate.objectId(), uploadInitiate.tierEpoch(), uploadInitiate.baseOffset(), uploadInitiate.hasAbortedTxns(), uploadInitiate.hasProducerState(), uploadInitiate.hasEpochState(), uploadInitiate.opaqueData(), uploadInitiate.segmentAndMetadataLayout().orElse(null));
    }

    public ObjectMetadata(TierObjectMetadata metadata) {
        this(metadata.topicIdPartition(), metadata.objectId(), metadata.tierEpoch(), metadata.baseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData(), metadata.segmentAndMetadataLayout());
    }

    public ObjectMetadata(TopicIdPartition topicIdPartition, SegmentState metadata) {
        this(topicIdPartition, metadata.objectId(), metadata.tierEpoch(), metadata.keyBaseOffset(), metadata.hasAbortedTxns(), metadata.hasProducerState(), metadata.hasEpochState(), metadata.opaqueData(), metadata.segmentAndMetadataLayout().orElse(null));
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public UUID objectId() {
        return this.objectId;
    }

    public String objectIdAsBase64() {
        return CoreUtils.uuidToBase64(this.objectId());
    }

    public int tierEpoch() {
        return this.tierEpoch;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public boolean hasAbortedTxns() {
        return this.hasAbortedTxns;
    }

    public boolean hasProducerState() {
        return this.hasProducerState;
    }

    public boolean hasEpochState() {
        return this.hasEpochState;
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadataVersion", Integer.toString(0));
        metadata.put("topic", this.topicIdPartition().topic());
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return this.opaqueData;
    }

    public Optional<SegmentAndMetadataLayout> segmentAndMetadataLayout() {
        return Optional.ofNullable(this.segmentAndMetadataLayout);
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (!VALID_FRAGMENT_TYPES_FOR_SEGMENT_METADATA.contains((Object)fragmentType)) {
            throw new UnsupportedOperationException(String.format("ObjectMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        if (this.segmentAndMetadataLayout == null) {
            ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
            return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
        }
        Optional<FragmentDescriptionWrapper> fragmentDescriptionOpt = this.segmentAndMetadataLayout.getSegmentFragmentDescription(fragmentType);
        return fragmentDescriptionOpt.map(fragmentDescription -> new FragmentLocation(this.toPath(keyPrefix, fragmentDescription.objectType()), fragmentDescription.objectType(), fragmentDescription.filePosition(), fragmentDescription.filePosition() + (long)fragmentDescription.size()));
    }

    public Optional<ObjectType> objectTypeForFragment(FragmentType fragmentType) {
        Optional<ObjectType> objectTypeOpt = this.segmentAndMetadataLayout().flatMap(layout -> layout.getSegmentFragmentDescription(fragmentType)).map(FragmentDescriptionWrapper::objectType);
        if (!objectTypeOpt.isPresent()) {
            return ObjectType.getDefaultObjectTypeForFragmentType(fragmentType);
        }
        return objectTypeOpt;
    }

    public boolean isCombinedObject(String prefix) {
        return this.toFragmentLocation(prefix, FragmentType.SEGMENT).map(location -> location.objectType().equals((Object)ObjectType.SEGMENT_WITH_METADATA)).orElse(false);
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.TOPIC.prefix + "/" + this.objectIdAsBase64() + "/" + this.topicIdPartition().topicIdAsBase64() + "/" + this.topicIdPartition().partition() + "/" + MergedLog.filenamePrefixFromOffset(this.baseOffset()) + "_" + this.tierEpoch() + "_v" + 0 + "." + objectType.suffix();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectMetadata that = (ObjectMetadata)o;
        return this.tierEpoch == that.tierEpoch && this.baseOffset == that.baseOffset && Objects.equals(this.topicIdPartition, that.topicIdPartition) && Objects.equals(this.objectId, that.objectId) && this.hasAbortedTxns == that.hasAbortedTxns && this.hasProducerState == that.hasProducerState && this.hasEpochState == that.hasEpochState && 0 == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition, this.objectId, this.tierEpoch, this.baseOffset, this.hasAbortedTxns, this.hasProducerState, this.hasEpochState);
    }

    public String toString() {
        return "ObjectMetadata(topic=" + this.topicIdPartition + ", objectIdAsBase64=" + this.objectIdAsBase64() + ", tierEpoch=" + this.tierEpoch + ", baseOffset=" + this.baseOffset + ", hasAbortedTxns=" + this.hasAbortedTxns + ", hasProducerState=" + this.hasProducerState + ", hasEpochState=" + this.hasEpochState + ", segmentAndMetadataLayout=" + this.segmentAndMetadataLayout + ')';
    }
}

