/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.FileTierPartitionStateSnapshotObject;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class TierPartitionStateSnapshotMetadata
implements ObjectStoreMetadata {
    private static final int CURRENT_KEY_PATH_VERSION = 0;
    private final TopicIdPartition topicIdPartition;
    private final FileTierPartitionStateSnapshotObject snapshotObject;
    private final int version = 0;

    public TierPartitionStateSnapshotMetadata(TopicIdPartition topicIdPartition, FileTierPartitionStateSnapshotObject snapshotObject) {
        this.topicIdPartition = topicIdPartition;
        this.snapshotObject = snapshotObject;
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public FileTierPartitionStateSnapshotObject snapshotObject() {
        return this.snapshotObject;
    }

    public int version() {
        return 0;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_PARTITION_STATE_METADATA_SNAPSHOT) {
            throw new UnsupportedOperationException(String.format("TierPartitionStateSnapshotMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return TierPartitionStateSnapshotMetadata.pathPrefix(keyPrefix, this.topicIdPartition) + this.snapshotObject.encodeSnapshotName() + "_v" + 0 + "." + objectType.suffix();
    }

    public static String pathPrefix(String keyPrefix, TopicIdPartition topicIdPartition) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_PARTITION_STATE_METADATA_SNAPSHOT.prefix() + "/" + topicIdPartition.topicIdAsBase64() + "/" + topicIdPartition.partition() + "/";
    }

    public static String extractEncodedName(String snapshotPath) {
        String[] tokens = snapshotPath.split("/");
        String snapshotNameWithSuffix = tokens[tokens.length - 1];
        return snapshotNameWithSuffix.split("_v0")[0];
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadataVersion", Integer.toString(0));
        metadata.put("topic", this.topicIdPartition().topic());
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierPartitionStateSnapshotMetadata that = (TierPartitionStateSnapshotMetadata)o;
        return Objects.equals(this.topicIdPartition, that.topicIdPartition) && this.snapshotObject.equals(that.snapshotObject) && 0 == that.version;
    }

    public int hashCode() {
        return Objects.hash(this.topicIdPartition, this.snapshotObject, 0);
    }

    public String toString() {
        return "TierPartitionStateSnapshotMetadata{topicIdPartition=" + this.topicIdPartition + ", snapshotObject=" + this.snapshotObject + ", version=" + 0 + '}';
    }
}

