/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store.objects.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kafka.tier.snapshot.TierTopicSnapshotObject;
import kafka.tier.store.OpaqueData;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.FragmentLocation;
import kafka.tier.store.objects.FragmentType;
import kafka.tier.store.objects.ObjectType;
import kafka.tier.store.objects.metadata.ObjectStoreMetadata;

public class TierTopicSnapshotMetadata
implements ObjectStoreMetadata {
    private static final int CURRENT_KEY_PATH_VERSION = 0;
    private final TierTopicSnapshotObject snapshotObject;
    private final int version = 0;

    public TierTopicSnapshotMetadata(TierTopicSnapshotObject snapshotObject) {
        this.snapshotObject = snapshotObject;
    }

    public TierTopicSnapshotObject snapshotObject() {
        return this.snapshotObject;
    }

    public int version() {
        return 0;
    }

    @Override
    public Optional<FragmentLocation> toFragmentLocation(String keyPrefix, FragmentType fragmentType) {
        if (fragmentType != FragmentType.TIER_TOPIC_SNAPSHOT) {
            throw new UnsupportedOperationException(String.format("TierTopicSnapshotMetadata cannot get FragmentLocation for fragment type of type %s", fragmentType.name()));
        }
        ObjectType defaultObjectType = ObjectType.getDefaultObjectTypeForFragmentType(fragmentType).get();
        return Optional.of(new FragmentLocation(this.toPath(keyPrefix, defaultObjectType), defaultObjectType));
    }

    private String toPath(String keyPrefix, ObjectType objectType) {
        return TierTopicSnapshotMetadata.pathPrefix(keyPrefix) + "/" + this.snapshotObject.encodeSnapshotName() + "_v" + 0 + "." + objectType.suffix();
    }

    public static String pathPrefix(String keyPrefix) {
        return keyPrefix + TierObjectStore.DataTypePathPrefix.TIER_TOPIC_SNAPSHOT.prefix();
    }

    public static TierTopicSnapshotMetadata fromPath(String fileName) {
        String prefixDelimiter = TierObjectStore.DataTypePathPrefix.TIER_TOPIC_SNAPSHOT.prefix() + "/";
        String[] prefix = fileName.split(prefixDelimiter, 2);
        String suffixDelimiter = "_v";
        String[] suffix = prefix[1].split(suffixDelimiter);
        TierTopicSnapshotObject snapshotObject = TierTopicSnapshotObject.decodeSnapshotName(suffix[0]);
        return new TierTopicSnapshotMetadata(snapshotObject);
    }

    @Override
    public Map<String, String> objectMetadata(Optional<String> clusterIdOpt, Optional<Integer> brokerIdOpt) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("metadataVersion", Integer.toString(0));
        metadata.put("epoch", Integer.toString(this.snapshotObject.currentEpochAndSeqNumber().epoch()));
        clusterIdOpt.ifPresent(clusterId -> metadata.put("clusterId", (String)clusterId));
        brokerIdOpt.ifPresent(brokerId -> metadata.put("brokerId", Integer.toString(brokerId)));
        return metadata;
    }

    @Override
    public OpaqueData opaqueData() {
        return OpaqueData.ZEROED;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TierTopicSnapshotMetadata that = (TierTopicSnapshotMetadata)o;
        return 0 == that.version && Objects.equals(this.snapshotObject, that.snapshotObject);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotObject, 0);
    }

    public String toString() {
        return "TierTopicSnapshotMetadata{snapshotObject=" + this.snapshotObject + ", version=" + 0 + '}';
    }
}

