/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.compaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.PriorityQueue;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.tasks.compaction.CompactionSummarizer$;
import kafka.tier.tasks.compaction.CompactionSummaryEntry;
import kafka.tier.tasks.compaction.CompactionTask;
import kafka.tier.tasks.compaction.TierLogToClean;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0006\r\u0001UA\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003D\u0001\u0011\u0005A\tC\u0003_\u0001\u0011%qlB\u0004~\u0019\u0005\u0005\t\u0012\u0001@\u0007\u000f-a\u0011\u0011!E\u0001\u007f\"1A\b\u0003C\u0001\u0003\u0003A\u0011\"a\u0001\t#\u0003%\t!!\u0002\u0003)\r{W\u000e]1di&|gnU;n[\u0006\u0014\u0018N_3s\u0015\tia\"\u0001\u0006d_6\u0004\u0018m\u0019;j_:T!a\u0004\t\u0002\u000bQ\f7o[:\u000b\u0005E\u0011\u0012\u0001\u0002;jKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}\u0011\u0012!B;uS2\u001c\u0018BA\u0011\u001f\u0005\u001daunZ4j]\u001e\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002%O5\tQE\u0003\u0002'%\u000511/\u001a:wKJL!\u0001K\u0013\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u000611m\u001c8gS\u001e\u0004\"aK\u0017\u000e\u00031R!!\u000b\b\n\u00059b#a\u0004+jKJ$\u0016m]6t\u0007>tg-[4\u0002\tQLW.\u001a\t\u0003cij\u0011A\r\u0006\u0003?MR!\u0001N\u001b\u0002\r\r|W.\\8o\u0015\t\u0019bG\u0003\u00028q\u00051\u0011\r]1dQ\u0016T\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\u0011q\u0004)\u0011\"\u0011\u0005}\u0002Q\"\u0001\u0007\t\u000b\t\"\u0001\u0019A\u0012\t\u000b%\"\u0001\u0019\u0001\u0016\t\u000f=\"\u0001\u0013!a\u0001a\u0005!Bn\\4D_6\u0004\u0018m\u0019;j_:\u001cV/\\7bef$\"!\u0012)\u0011\u0005\u0019keBA$L!\tA\u0005$D\u0001J\u0015\tQE#\u0001\u0004=e>|GOP\u0005\u0003\u0019b\ta\u0001\u0015:fI\u00164\u0017B\u0001(P\u0005\u0019\u0019FO]5oO*\u0011A\n\u0007\u0005\u0006#\u0016\u0001\rAU\u0001\u0010G>l\u0007/Y2uS>tG+Y:lgB\u00191\u000bW.\u000f\u0005Q3fB\u0001%V\u0013\u0005I\u0012BA,\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\t1K7\u000f\u001e\u0006\u0003/b\u0001\"a\u0010/\n\u0005uc!AD\"p[B\f7\r^5p]R\u000b7o[\u0001\u001faJLg\u000e\u001e+paR+gnQ8na\u0006\u001cG/[8o/>\u00148\u000e\\8bIN,\"\u0001\u0019;\u0015\u0005\u0015\u000b\u0007\"\u00022\u0007\u0001\u0004\u0019\u0017A\u00019r!\r!\u0017n[\u0007\u0002K*\u0011amZ\u0001\u0005kRLGNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005),'!\u0004)sS>\u0014\u0018\u000e^=Rk\u0016,X\r\u0005\u0003@Y:\u0014\u0018BA7\r\u0005Y\u0019u.\u001c9bGRLwN\\*v[6\f'/_#oiJL\bCA8q\u001b\u0005\u0001\u0012BA9\u0011\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002ti2\u0001A!B;\u0007\u0005\u00041(!\u0001,\u0012\u0005]T\bCA\fy\u0013\tI\bDA\u0004O_RD\u0017N\\4\u0011\u0005]Y\u0018B\u0001?\u0019\u0005\r\te._\u0001\u0015\u0007>l\u0007/Y2uS>t7+^7nCJL'0\u001a:\u0011\u0005}B1C\u0001\u0005\u0017)\u0005q\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\b)\u001a\u0001'!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class CompactionSummarizer
implements Logging {
    private final ReplicaManager replicaManager;
    private final TierTasksConfig config;
    private final Time time;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$3() {
        return CompactionSummarizer$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String logCompactionSummary(List<CompactionTask> compactionTasks) {
        PriorityQueue maxCompactionDelaySortedSummary = new PriorityQueue((o1, o2) -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(o2.value())).compareTo(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong(o1.value()))));
        PriorityQueue expectedCompactionEfficiencySortedSummary = new PriorityQueue((o1, o2) -> Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(o1.value())).compareTo(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble(o2.value()))));
        long now = this.time.milliseconds();
        compactionTasks.foreach((Function1 & Serializable & scala.Serializable)task -> task.maybeUpdateLogToClean($this.replicaManager, now, $this.config.logCleanupIntervalMs()).map((Function1 & Serializable & scala.Serializable)tierLogToClean -> BoxesRunTime.boxToBoolean((boolean)CompactionSummarizer.$anonfun$logCompactionSummary$4(maxCompactionDelaySortedSummary, expectedCompactionEfficiencySortedSummary, tierLogToClean))));
        if (!maxCompactionDelaySortedSummary.isEmpty() && !expectedCompactionEfficiencySortedSummary.isEmpty()) {
            String compactionSummary = new StringBuilder(161).append("Compaction Workload Summary for Broker ").append(this.config.brokerId()).append(":\n").append("\tTopic Partitions With Highest Max Compaction Delay (ms):\n").append(this.printTopTenCompactionWorkloads(maxCompactionDelaySortedSummary)).append("\tTopic Partitions With Lowest Expected Compaction Efficiency:\n").append(this.printTopTenCompactionWorkloads(expectedCompactionEfficiencySortedSummary)).toString();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> compactionSummary);
            return compactionSummary;
        }
        return "";
    }

    private <V> String printTopTenCompactionWorkloads(PriorityQueue<CompactionSummaryEntry<TopicIdPartition, V>> pq) {
        ArrayList<CompactionSummaryEntry> entries = new ArrayList<CompactionSummaryEntry>();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.apply(pq.poll()).foreach((Function1 & Serializable & scala.Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)entries.add(entry))));
        scala.collection.mutable.StringBuilder output = new scala.collection.mutable.StringBuilder();
        entries.forEach(entry -> output.append(new StringBuilder(6).append("\t\t").append(entry.key()).append("   ").append(entry.value()).append("\n").toString()));
        return output.toString();
    }

    public static final /* synthetic */ boolean $anonfun$logCompactionSummary$4(PriorityQueue maxCompactionDelaySortedSummary$1, PriorityQueue expectedCompactionEfficiencySortedSummary$1, TierLogToClean tierLogToClean) {
        TopicIdPartition topicIdPartition = (TopicIdPartition)tierLogToClean.topicIdPartition().get();
        CompactionSummaryEntry<TopicIdPartition, Object> maxCompactionDelayEntry = new CompactionSummaryEntry<TopicIdPartition, Object>(topicIdPartition, tierLogToClean.thresholdMaxCompactionDelayMs().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        CompactionSummaryEntry<TopicIdPartition, Double> expectedCompactionEfficiencyEntry = new CompactionSummaryEntry<TopicIdPartition, Double>(topicIdPartition, BoxesRunTime.boxToDouble((double)tierLogToClean.expectedCompactionEfficiency()));
        maxCompactionDelaySortedSummary$1.add(maxCompactionDelayEntry);
        return expectedCompactionEfficiencySortedSummary$1.add(expectedCompactionEfficiencyEntry);
    }

    public CompactionSummarizer(ReplicaManager replicaManager, TierTasksConfig config, Time time) {
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
    }
}

