/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kafka.log.AbstractLog;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.exceptions.TierDeletionFailedException;
import kafka.tier.exceptions.TierDeletionFencedException;
import kafka.tier.exceptions.TierDeletionFencedException$;
import kafka.tier.exceptions.TierDeletionRestoreFencedException;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.objects.metadata.ObjectMetadata;
import kafka.tier.store.objects.metadata.TierPartitionStateSnapshotMetadata;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DeletionTask$
implements Logging {
    public static DeletionTask$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DeletionTask$();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return DeletionTask.class.getName();
    }

    public void kafka$tier$tasks$delete$DeletionTask$$garbageCollectAllSnapshots(TopicIdPartition topicIdPartition, TierObjectStore tierObjectStore) {
        String snapshotPrefix = TierPartitionStateSnapshotMetadata.pathPrefix("", topicIdPartition);
        List<TierObjectStore.KeyAndVersion> snapshotsToDelete = tierObjectStore.listObject(snapshotPrefix, false).keySet().stream().map(snapshotPath -> new TierObjectStore.KeyAndVersion((String)snapshotPath)).collect(Collectors.toList());
        if (snapshotsToDelete.isEmpty()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(DeletionTask$.$anonfun$garbageCollectAllSnapshots$2(topicIdPartition)));
                return;
            }
            return;
        }
        StringBuilder sb = new StringBuilder(new java.lang.StringBuilder(66).append("Following snapshots are to be deleted for the deleted partition: ").append(topicIdPartition).append("\n").toString());
        snapshotsToDelete.forEach(kv -> sb.append(kv.key()).append(" "));
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(sb.toString()));
        }
        tierObjectStore.deleteVersions(snapshotsToDelete);
    }

    public String kafka$tier$tasks$delete$DeletionTask$$printableSegmentDeletions(Iterable<ObjectMetadata> toDelete) {
        return ((TraversableOnce)toDelete.map((Function1 & Serializable & scala.Serializable)metadata -> new Tuple2((Object)BoxesRunTime.boxToLong((long)metadata.baseOffset()), (Object)metadata.objectIdAsBase64()), Iterable$.MODULE$.canBuildFrom())).mkString(",");
    }

    public long getDelayFromLogConfig(Option<AbstractLog> log) {
        return BoxesRunTime.unboxToLong((Object)log.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.config().fileDeleteDelayMs)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public Future<BoxedUnit> writeDeletionInitiatedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, Optional<OffsetAndEpoch> stateOffset, ObjectMetadata segment, Time time, ExecutionContext ec) {
        TierSegmentDeleteInitiate marker = new TierSegmentDeleteInitiate(segment.topicIdPartition(), leaderEpoch, segment.objectId(), stateOffset);
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writeDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, Optional<OffsetAndEpoch> stateOffset, ObjectMetadata objectMetadata, Time time, ExecutionContext ec) {
        TierSegmentDeleteComplete marker = new TierSegmentDeleteComplete(objectMetadata.topicIdPartition(), leaderEpoch, objectMetadata.objectId(), stateOffset);
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writePartitionDeletionCompletedMarker(TierTopicAppender tierTopicAppender, int leaderEpoch, TopicIdPartition topicIdPartition, Time time, ExecutionContext ec) {
        TierPartitionDeleteComplete marker = new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID());
        return this.writeMarker(tierTopicAppender, marker, time, ec);
    }

    public Future<BoxedUnit> writeMarker(TierTopicAppender tierTopicAppender, AbstractTierMetadata marker, Time time, ExecutionContext ec) {
        long startTimeMs = time.milliseconds();
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$1(marker)));
        }
        return FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(tierTopicAppender.addMetadata(marker))).map((Function1 & Serializable & scala.Serializable)appendResult -> {
            DeletionTask$.$anonfun$writeMarker$2(marker, time, startTimeMs, appendResult);
            return BoxedUnit.UNIT;
        }, ec);
    }

    public static final /* synthetic */ String $anonfun$garbageCollectAllSnapshots$2(TopicIdPartition topicIdPartition$2) {
        return new java.lang.StringBuilder(48).append("No snapshot to delete for the deleted partition ").append(topicIdPartition$2).toString();
    }

    public static final /* synthetic */ String $anonfun$writeMarker$1(AbstractTierMetadata marker$1) {
        return new java.lang.StringBuilder(14).append("Emitting ").append(marker$1).append(" for ").append(marker$1.topicIdPartition()).toString();
    }

    public static final /* synthetic */ String $anonfun$writeMarker$3(AbstractTierMetadata marker$1, Time time$2, long startTimeMs$1) {
        return new java.lang.StringBuilder(21).append("Completed ").append(marker$1).append(" for ").append(marker$1.topicIdPartition()).append(" in ").append(time$2.milliseconds() - startTimeMs$1).append("ms").toString();
    }

    public static final /* synthetic */ String $anonfun$writeMarker$4(AbstractTierMetadata marker$1) {
        return new java.lang.StringBuilder(63).append("Stopping state machine for ").append(marker$1.topicIdPartition()).append(" as attempt to transition was fenced").toString();
    }

    public static final /* synthetic */ String $anonfun$writeMarker$5(AbstractTierMetadata marker$1) {
        return new java.lang.StringBuilder(59).append("Stopping state machine for ").append(marker$1.topicIdPartition()).append(" as attempt to transition failed").toString();
    }

    public static final /* synthetic */ void $anonfun$writeMarker$2(AbstractTierMetadata marker$1, Time time$2, long startTimeMs$1, TierPartitionState.AppendResult appendResult) {
        if (((Object)((Object)TierPartitionState.AppendResult.ACCEPTED)).equals((Object)appendResult)) {
            DeletionTask$ deletionTask$ = MODULE$;
            if (deletionTask$ == null) {
                throw null;
            }
            DeletionTask$ info_this = deletionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$3(marker$1, time$2, startTimeMs$1)));
                return;
            }
            return;
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FENCED)).equals((Object)appendResult)) {
            DeletionTask$ deletionTask$ = MODULE$;
            if (deletionTask$ == null) {
                throw null;
            }
            DeletionTask$ info_this = deletionTask$;
            if (info_this.logger().underlying().isInfoEnabled()) {
                info_this.logger().underlying().info(info_this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$4(marker$1)));
            }
            throw new TierDeletionFencedException(marker$1.topicIdPartition(), TierDeletionFencedException$.MODULE$.$lessinit$greater$default$2());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.FAILED)).equals((Object)appendResult)) {
            DeletionTask$ deletionTask$ = MODULE$;
            if (deletionTask$ == null) {
                throw null;
            }
            DeletionTask$ warn_this = deletionTask$;
            if (warn_this.logger().underlying().isWarnEnabled()) {
                warn_this.logger().underlying().warn(warn_this.msgWithLogIdent(DeletionTask$.$anonfun$writeMarker$5(marker$1)));
            }
            throw new TierDeletionFailedException(marker$1.topicIdPartition());
        }
        if (((Object)((Object)TierPartitionState.AppendResult.RESTORE_FENCED)).equals((Object)appendResult)) {
            throw new TierDeletionRestoreFencedException(marker$1.topicIdPartition());
        }
        throw new IllegalStateException(new java.lang.StringBuilder(31).append("Unexpected append result for ").append(marker$1.topicIdPartition()).append(": ").append((Object)appendResult).toString());
    }

    private DeletionTask$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

