/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$;
import kafka.network.ConnectionQuotas;
import kafka.network.ConnectionQuotasTest$ListenerDesc$;
import kafka.network.Processor$;
import kafka.network.TooManyConnectionsException;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntegralProxy;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.hashing.MurmurHash3$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001\u0002\u001a4\u0001aBQa\u0010\u0001\u0005\u0002\u0001Cqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004S\u0001\u0001\u0006I!\u0012\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u001d\ty\t\u0001Q\u0001\nUC\u0011\"!%\u0001\u0005\u0004%I!a%\t\u0011\u0005]\u0006\u0001)A\u0005\u0003+C\u0001\"!/\u0001\u0005\u0004%Ia \u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002\u0002!A\u0011Q\u0018\u0001C\u0002\u0013%q\u0010\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA\u0001\r\u0011)\u0007\u0001\u00114\t\u0011Yd!Q3A\u0005\u0002]D\u0001\" \u0007\u0003\u0012\u0003\u0006I\u0001\u001f\u0005\t}2\u0011)\u001a!C\u0001\u007f\"Q\u0011Q\u0002\u0007\u0003\u0012\u0003\u0006I!!\u0001\t\r}bA\u0011AA\b\u0011\u001d\t)\u0002\u0004C!\u0003/A\u0011\"a\n\r\u0003\u0003%\t!!\u000b\t\u0013\u0005=B\"%A\u0005\u0002\u0005E\u0002\"CA$\u0019E\u0005I\u0011AA%\u0011%\ti\u0005DA\u0001\n\u0003\ny\u0005C\u0005\u0002R1\t\t\u0011\"\u0001\u0002T!I\u00111\f\u0007\u0002\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003Sb\u0011\u0011!C!\u0003WB\u0011\"a\u001d\r\u0003\u0003%\t!!\u001e\t\u0013\u0005}D\"!A\u0005B\u0005\u0005\u0005\"CAC\u0019\u0005\u0005I\u0011IAD\u0011%\tI\tDA\u0001\n\u0003\nYiB\u0005\u0002B\u0002\t\t\u0011#\u0001\u0002D\u001aAQ\rAA\u0001\u0012\u0003\t)\r\u0003\u0004@?\u0011\u0005\u0011Q\u001c\u0005\n\u0003+y\u0012\u0011!C#\u0003?D\u0011\"!9 \u0003\u0003%\t)a9\t\u0013\u0005%x$!A\u0005\u0002\u0006-\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011)\u0003\u0001C\u0001\u0005\u001fAqAa\f\u0001\t\u0003\u0011y\u0001C\u0004\u0003:\u0001!\tAa\u0004\t\u000f\tu\u0002\u0001\"\u0001\u0003\u0010!9!\u0011\t\u0001\u0005\u0002\t=\u0001b\u0002B#\u0001\u0011\u0005!q\u0002\u0005\b\u0005\u0013\u0002A\u0011\u0001B\b\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fBqAa\u001b\u0001\t\u0013\u0011i\u0007C\u0005\u0003\u0004\u0002\t\n\u0011\"\u0003\u0003\u0006\"9!1\u000e\u0001\u0005\n\t%\u0005b\u0002BL\u0001\u0011%!\u0011\u0014\u0002\u0015\u0007>tg.Z2uS>t\u0017+^8uCN$Vm\u001d;\u000b\u0005Q*\u0014a\u00028fi^|'o\u001b\u0006\u0002m\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u0011\t\u0003\u0005\u0002i\u0011aM\u0001\u0005i&lW-F\u0001F!\t1\u0005+D\u0001H\u0015\tA\u0015*A\u0003vi&d7O\u0003\u0002K\u0017\u000611m\\7n_:T!A\u000e'\u000b\u00055s\u0015AB1qC\u000eDWMC\u0001P\u0003\ry'oZ\u0005\u0003#\u001e\u0013\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\nY&\u001cH/\u001a8feN,\u0012!\u0016\t\u0005-f[6-D\u0001X\u0015\tA6(\u0001\u0006d_2dWm\u0019;j_:L!AW,\u0003\u00075\u000b\u0007\u000f\u0005\u0002]C6\tQL\u0003\u0002_?\u0006!A.\u00198h\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\rM#(/\u001b8h!\t!G\"D\u0001\u0001\u00051a\u0015n\u001d;f]\u0016\u0014H)Z:d'\u0011a\u0011h\u001a6\u0011\u0005iB\u0017BA5<\u0005\u001d\u0001&o\u001c3vGR\u0004\"a[:\u000f\u00051\fhBA7q\u001b\u0005q'BA88\u0003\u0019a$o\\8u}%\tA(\u0003\u0002sw\u00059\u0001/Y2lC\u001e,\u0017B\u0001;v\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u00118(\u0001\u0007mSN$XM\\3s\u001d\u0006lW-F\u0001y!\tI80D\u0001{\u0015\t!\u0014*\u0003\u0002}u\naA*[:uK:,'OT1nK\u0006iA.[:uK:,'OT1nK\u0002\n\u0011\u0002Z3gCVdG/\u00139\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001dq,A\u0002oKRLA!a\u0003\u0002\u0006\tY\u0011J\\3u\u0003\u0012$'/Z:t\u0003)!WMZ1vYRL\u0005\u000f\t\u000b\u0006G\u0006E\u00111\u0003\u0005\u0006mF\u0001\r\u0001\u001f\u0005\u0007}F\u0001\r!!\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0007\u0011\t\u0005m\u00111\u0005\b\u0005\u0003;\ty\u0002\u0005\u0002nw%\u0019\u0011\u0011E\u001e\u0002\rA\u0013X\rZ3g\u0013\r\u0011\u0017Q\u0005\u0006\u0004\u0003CY\u0014\u0001B2paf$RaYA\u0016\u0003[AqA^\n\u0011\u0002\u0003\u0007\u0001\u0010\u0003\u0005\u007f'A\u0005\t\u0019AA\u0001\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\r+\u0007a\f)d\u000b\u0002\u00028A!\u0011\u0011HA\"\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012!C;oG\",7m[3e\u0015\r\t\teO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA#\u0003w\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0013+\t\u0005\u0005\u0011QG\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003m\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0016\u0011\u0007i\n9&C\u0002\u0002Zm\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0018\u0002fA\u0019!(!\u0019\n\u0007\u0005\r4HA\u0002B]fD\u0011\"a\u001a\u0019\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0007E\u0003W\u0003_\ny&C\u0002\u0002r]\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qOA?!\rQ\u0014\u0011P\u0005\u0004\u0003wZ$a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003OR\u0012\u0011!a\u0001\u0003?\n!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR\u00191,a!\t\u0013\u0005\u001d4$!AA\u0002\u0005U\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0013AB3rk\u0006d7\u000f\u0006\u0003\u0002x\u00055\u0005\"CA4;\u0005\u0005\t\u0019AA0\u0003)a\u0017n\u001d;f]\u0016\u00148\u000fI\u0001\u0015E2|7m[3e!\u0016\u00148-\u001a8u\u001b\u0016$XM]:\u0016\u0005\u0005U\u0005\u0003CAL\u0003;\u000bI\"a(\u000e\u0005\u0005e%bAAN/\u00069Q.\u001e;bE2,\u0017b\u0001.\u0002\u001aB!\u0011\u0011UAZ\u001b\t\t\u0019K\u0003\u0003\u0002&\u0006\u001d\u0016\u0001B2pe\u0016TA!!+\u0002,\u00069Q.\u001a;sS\u000e\u001c(\u0002BAW\u0003_\u000ba!_1n[\u0016\u0014(BAAY\u0003\r\u0019w.\\\u0005\u0005\u0003k\u000b\u0019KA\u0003NKR,'/A\u000bcY>\u001c7.\u001a3QKJ\u001cWM\u001c;NKR,'o\u001d\u0011\u0002\u0013-twn\u001e8I_N$\u0018AC6o_^t\u0007j\\:uA\u0005YQO\\6o_^t\u0007j\\:u\u00031)hn\u001b8po:Dun\u001d;!\u00031a\u0015n\u001d;f]\u0016\u0014H)Z:d!\t!wdE\u0003 \u0003\u000f\f\u0019\u000e\u0005\u0005\u0002J\u0006=\u00070!\u0001d\u001b\t\tYMC\u0002\u0002Nn\nqA];oi&lW-\u0003\u0003\u0002R\u0006-'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011Q[An\u001b\t\t9NC\u0002\u0002Z~\u000b!![8\n\u0007Q\f9\u000e\u0006\u0002\u0002DR\t1,A\u0003baBd\u0017\u0010F\u0003d\u0003K\f9\u000fC\u0003wE\u0001\u0007\u0001\u0010\u0003\u0004\u007fE\u0001\u0007\u0011\u0011A\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\ti/!?\u0011\u000bi\ny/a=\n\u0007\u0005E8H\u0001\u0004PaRLwN\u001c\t\u0007u\u0005U\b0!\u0001\n\u0007\u0005]8H\u0001\u0004UkBdWM\r\u0005\t\u0003w\u001c\u0013\u0011!a\u0001G\u0006\u0019\u0001\u0010\n\u0019\u0002M\t\u0014xn[3s!J|\u0007o],ji\"$UMZ1vYR\u001cuN\u001c8fGRLwN\u001c'j[&$8/\u0006\u0002\u0003\u0002A!!1\u0001B\u0005\u001b\t\u0011)AC\u0002\u0003\b}\u000bA!\u001e;jY&!!1\u0002B\u0003\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0003\u0005#\u00012A\u000fB\n\u0013\r\u0011)b\u000f\u0002\u0005+:LG\u000fK\u0002&\u00053\u0001BAa\u0007\u0003\"5\u0011!Q\u0004\u0006\u0004\u0005?q\u0015!\u00026v]&$\u0018\u0002\u0002B\u0012\u0005;\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007\u0019\u0012I\u0003\u0005\u0003\u0003\u001c\t-\u0012\u0002\u0002B\u0017\u0005;\u0011Q!\u00114uKJ\fq\u0003^3ti\u001a\u000b\u0017\u000e\\,iK:tu\u000eT5ti\u0016tWM]:)\u0007\u001d\u0012\u0019\u0004\u0005\u0003\u0003\u001c\tU\u0012\u0002\u0002B\u001c\u0005;\u0011A\u0001V3ti\u0006iB/Z:u\r\u0006LG\u000eR3de\u0016lWM\u001c;G_J,fn\u001b8po:L\u0005\u000fK\u0002)\u0005g\tq\u0004^3ti:{7i\u001c8oK\u000e$\u0018n\u001c8MS6LGo\u001d\"z\t\u00164\u0017-\u001e7uQ\rI#1G\u0001\u0018i\u0016\u001cH/T1y\u0007>tg.Z2uS>t7\u000fU3s\u0013BD3A\u000bB\u001a\u0003\u0001\"Xm\u001d;NCb\u0014%o\\6fe^KG-Z\"p]:,7\r^5p]2KW.\u001b;)\u0007-\u0012\u0019$A\u0010uKN$X*\u0019=MSN$XM\\3s\u0007>tg.Z2uS>tG*[7jiND3\u0001\fB\u001a\u0003U\tG\r\u001a'jgR,g.\u001a:t\u0003:$g+\u001a:jMf$bA!\u0005\u0003R\t\u0005\u0004b\u0002B*[\u0001\u0007!QK\u0001\u0007G>tg-[4\u0011\t\t]#QL\u0007\u0003\u00053R1Aa\u00176\u0003\u0019\u0019XM\u001d<fe&!!q\fB-\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u000f\t\rT\u00061\u0001\u0003f\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0004\u0005\n\u001d\u0014b\u0001B5g\t\u00012i\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u0001\u0012C\u000e\u001cW\r\u001d;D_:tWm\u0019;j_:\u001cHC\u0003B\t\u0005_\u0012\tH!\u001e\u0003\u0000!9!1\r\u0018A\u0002\t\u0015\u0004B\u0002B:]\u0001\u00071-\u0001\u0007mSN$XM\\3s\t\u0016\u001c8\rC\u0004\u0003x9\u0002\rA!\u001f\u0002\u001d9,XnQ8o]\u0016\u001cG/[8ogB\u0019!Ha\u001f\n\u0007\tu4H\u0001\u0003M_:<\u0007\"\u0003BA]A\u0005\t\u0019\u0001B=\u00039!\u0018.\\3J]R,'O^1m\u001bN\f1$Y2dKB$8i\u001c8oK\u000e$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TC\u0001BDU\u0011\u0011I(!\u000e\u0015\u0019\tE!1\u0012BG\u0005\u001f\u0013\u0019J!&\t\u000f\t\r\u0004\u00071\u0001\u0003f!)a\u000f\ra\u0001q\"9!\u0011\u0013\u0019A\u0002\u0005\u0005\u0011aB1eIJ,7o\u001d\u0005\b\u0005o\u0002\u0004\u0019\u0001B=\u0011\u001d\u0011\t\t\ra\u0001\u0005s\nQ$Y2dKB$8i\u001c8oK\u000e$\u0018n\u001c8t\u0003\n|g/Z%q\u0019&l\u0017\u000e\u001e\u000b\t\u0005#\u0011YJ!(\u0003 \"9!1M\u0019A\u0002\t\u0015\u0004B\u0002B:c\u0001\u00071\rC\u0004\u0003xE\u0002\rA!\u001f")
public class ConnectionQuotasTest {
    private volatile ConnectionQuotasTest$ListenerDesc$ ListenerDesc$module;
    private final MockTime time = new MockTime();
    private final Map<String, ListenerDesc> listeners;
    private final scala.collection.mutable.Map<String, Meter> blockedPercentMeters;
    private final InetAddress knownHost;
    private final InetAddress unknownHost;

    public ConnectionQuotasTest$ListenerDesc$ ListenerDesc() {
        if (this.ListenerDesc$module == null) {
            this.ListenerDesc$lzycompute$1();
        }
        return this.ListenerDesc$module;
    }

    private MockTime time() {
        return this.time;
    }

    private Map<String, ListenerDesc> listeners() {
        return this.listeners;
    }

    private scala.collection.mutable.Map<String, Meter> blockedPercentMeters() {
        return this.blockedPercentMeters;
    }

    private InetAddress knownHost() {
        return this.knownHost;
    }

    private InetAddress unknownHost() {
        return this.unknownHost;
    }

    /*
     * WARNING - void declaration
     */
    public Properties brokerPropsWithDefaultConnectionLimits() {
        void var1_23;
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, x$2, bl, bl2, 0, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "EXTERNAL://localhost:0,REPLICATION://localhost:1,ADMIN://localhost:2");
        props.put(KafkaConfig$.MODULE$.InterBrokerListenerNameProp(), "REPLICATION");
        props.put(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "EXTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,ADMIN:PLAINTEXT");
        return var1_23;
    }

    @Before
    public void setUp() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.listeners().keys().foreach((Function1 & Serializable)name -> {
            String string;
            Object[] objectArray = new Tuple2[1];
            String string2 = string = Processor$.MODULE$.ListenerMetricTag();
            string = null;
            String $minus$greater$extension_$this = string2;
            Object var2_3 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, name);
            return this.blockedPercentMeters().put(name, (Object)KafkaMetricsGroup.newMeter$((KafkaMetricsGroup)KafkaMetricsGroup$.MODULE$, (String)new StringBuilder(14).append((String)name).append("BlockedPercent").toString(), (String)"blocked time", (TimeUnit)TimeUnit.NANOSECONDS, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))));
        });
    }

    @After
    public void tearDown() {
        TestUtils$.MODULE$.clearYammerMetrics();
        this.blockedPercentMeters().clear();
    }

    @Test
    public void testFailWhenNoListeners() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            ListenerDesc listener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
            executor.submit(() -> Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> connectionQuotas.inc(listener.listenerName(), listener.defaultIp(), (Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91))).get(5L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testFailDecrementForUnknownIp() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), this.unknownHost()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
    }

    @Test
    public void testNoConnectionLimitsByDefault() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(this.brokerPropsWithDefaultConnectionLimits());
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            int numConnections = 10000;
            ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, numConnections, 0L)))).foreach((Function1 & Serializable)x$1 -> x$1.get(10L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testNoConnectionLimitsByDefault$4(numConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        int maxConnectionsPerIp = 17;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), ((Object)maxConnectionsPerIp).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            ListenerDesc externalListener = (ListenerDesc)this.listeners().apply((Object)"EXTERNAL");
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener, maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnectionsAboveIpLimit(connectionQuotas, externalListener, 2L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp + 2), (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener.listenerName(), this.knownHost(), maxConnectionsPerIp, 0L)).get(5L, TimeUnit.SECONDS);
            int n = 0;
            int until$extension_end = 4;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    connectionQuotas.dec(externalListener.listenerName(), externalListener.defaultIp());
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var9_9 = null;
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)(maxConnectionsPerIp - 2), (long)connectionQuotas.get(externalListener.defaultIp()));
            executor.submit(() -> this.acceptConnections(connectionQuotas, externalListener, 2L, 0L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(externalListener).append(":").toString(), (long)maxConnectionsPerIp, (long)connectionQuotas.get(externalListener.defaultIp()));
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testMaxBrokerWideConnectionLimit() {
        int maxConnections = 800;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)maxConnections).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), maxConnections, 1L)).get(5L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)connectionQuotas.get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
            Assert.assertEquals((long)0L, (long)((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count());
            Assert.assertFalse((String)"Total number of connections is exactly the maximum.", (boolean)connectionQuotas.maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
            Future<?> future = executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"EXTERNAL"), 1L, 0L));
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            this.time().sleep(3L);
            connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
            future.get(1L, TimeUnit.SECONDS);
            Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(this.listeners().apply((Object)"EXTERNAL")).append(":").toString(), (long)maxConnections, (long)connectionQuotas.get(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp()));
            Assert.assertTrue((String)"Expected BlockedPercentMeter metric to be recorded", (((Meter)this.blockedPercentMeters().apply((Object)"EXTERNAL")).count() > 0L ? 1 : 0) != 0);
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L)).get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((String)"Expected the number of connections to exceed the maximum.", (boolean)connectionQuotas.maxConnectionsExceeded(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName()));
            Future<?> future1 = executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"ADMIN"), 1L, 0L));
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future1.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)this.listeners().apply((Object)"REPLICATION"), 1L, 0L)).get(5L, TimeUnit.SECONDS);
            int n = 0;
            int until$extension_end = 2;
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var10_10 = null;
            Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future1.get(100L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            connectionQuotas.dec(((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).listenerName(), ((ListenerDesc)this.listeners().apply((Object)"EXTERNAL")).defaultIp());
            future1.get(1L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMaxListenerConnectionLimits() {
        void $minus$greater$extension_y;
        int maxConnections = 800;
        int listenerMaxConnections = 200;
        Properties props = this.brokerPropsWithDefaultConnectionLimits();
        props.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), ((Object)maxConnections).toString());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ConnectionQuotas connectionQuotas = new ConnectionQuotas(config, (Time)this.time());
        this.addListenersAndVerify(config, connectionQuotas);
        Object[] objectArray = new Tuple2[1];
        String string = ((Object)listenerMaxConnections).toString();
        String $minus$greater$extension_$this = KafkaConfig$.MODULE$.MaxConnectionsProp();
        Object var10_7 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        java.util.Map listenerConfig = AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava();
        this.listeners().values().foreach((Function1 & Serializable)listener -> {
            ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$1(connectionQuotas, listenerConfig, listener);
            return BoxedUnit.UNIT;
        });
        ExecutorService executor = Executors.newFixedThreadPool(this.listeners().size());
        try {
            ((Iterable)this.listeners().values().map((Function1 & Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, listenerMaxConnections, 0L)))).foreach((Function1 & Serializable)x$4 -> x$4.get(5L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$5(listenerMaxConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
            Iterable overLimitFutures = (Iterable)this.listeners().values().map((Function1 & Serializable)listener -> executor.submit(() -> this.acceptConnections(connectionQuotas, (ListenerDesc)listener, 1L, 0L)));
            overLimitFutures.foreach((Function1 & Serializable)future -> (TimeoutException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> future.get(1L, TimeUnit.SECONDS), ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297)));
            this.listeners().values().foreach((Function1 & Serializable)listener -> {
                connectionQuotas.dec(listener.listenerName(), listener.defaultIp());
                return BoxedUnit.UNIT;
            });
            overLimitFutures.foreach((Function1 & Serializable)x$5 -> x$5.get(5L, TimeUnit.SECONDS));
            this.listeners().values().foreach((Function1 & Serializable)listener -> {
                ConnectionQuotasTest.$anonfun$testMaxListenerConnectionLimits$12(listenerMaxConnections, connectionQuotas, listener);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void addListenersAndVerify(KafkaConfig config, ConnectionQuotas connectionQuotas) {
        this.listeners().foreach((Function1 & Serializable)x0$1 -> {
            ConnectionQuotasTest.$anonfun$addListenersAndVerify$1(connectionQuotas, config, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections, long timeIntervalMs) {
        this.acceptConnections(connectionQuotas, listenerDesc.listenerName(), listenerDesc.defaultIp(), numConnections, timeIntervalMs);
    }

    private void acceptConnections(ConnectionQuotas connectionQuotas, ListenerName listenerName, InetAddress address, long numConnections, long timeIntervalMs) {
        IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)numConnections).foreach$mVc$sp((Function1)(JFunction1.mcVJ.sp & Serializable)x$6 -> {
            connectionQuotas.inc(listenerName, address, (Meter)this.blockedPercentMeters().apply((Object)listenerName.value()));
            this.time().sleep(timeIntervalMs);
        });
    }

    private long acceptConnections$default$4() {
        return 0L;
    }

    private void acceptConnectionsAboveIpLimit(ConnectionQuotas connectionQuotas, ListenerDesc listenerDesc, long numConnections) {
        ListenerName listenerName = listenerDesc.listenerName();
        IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)numConnections).foreach((Function1 & Serializable)i -> ConnectionQuotasTest.$anonfun$acceptConnectionsAboveIpLimit$1(this, connectionQuotas, listenerName, listenerDesc, BoxesRunTime.unboxToLong((Object)i)));
    }

    private final void ListenerDesc$lzycompute$1() {
        synchronized (this) {
            if (this.ListenerDesc$module == null) {
                this.ListenerDesc$module = new ConnectionQuotasTest$ListenerDesc$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testNoConnectionLimitsByDefault$4(int numConnections$1, ConnectionQuotas connectionQuotas$3, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)numConnections$1, (long)connectionQuotas$3.get(listener.defaultIp()));
        connectionQuotas$3.dec(listener.listenerName(), listener.defaultIp());
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)(numConnections$1 - 1), (long)connectionQuotas$3.get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$1(ConnectionQuotas connectionQuotas$6, java.util.Map listenerConfig$1, ListenerDesc listener) {
        ((ConnectionQuotas.ListenerConnectionQuota)connectionQuotas$6.maxConnectionsPerListener().apply((Object)listener.listenerName())).configure(listenerConfig$1);
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$5(int listenerMaxConnections$1, ConnectionQuotas connectionQuotas$6, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)connectionQuotas$6.get(listener.defaultIp()));
        Assert.assertFalse((String)new StringBuilder(62).append("Total number of connections on ").append(listener).append(" should be exactly the maximum.").toString(), (boolean)connectionQuotas$6.maxConnectionsExceeded(listener.listenerName()));
    }

    public static final /* synthetic */ void $anonfun$testMaxListenerConnectionLimits$12(int listenerMaxConnections$1, ConnectionQuotas connectionQuotas$6, ListenerDesc listener) {
        Assert.assertEquals((String)new StringBuilder(26).append("Number of connections on ").append(listener).append(":").toString(), (long)listenerMaxConnections$1, (long)connectionQuotas$6.get(listener.defaultIp()));
    }

    public static final /* synthetic */ void $anonfun$addListenersAndVerify$1(ConnectionQuotas connectionQuotas$7, KafkaConfig config$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String name = (String)x0$1._1();
            ListenerDesc listener = (ListenerDesc)x0$1._2();
            connectionQuotas$7.addListener(config$1, listener.listenerName());
            Assert.assertFalse((String)new StringBuilder(72).append("Should not exceed max connection limit on ").append(name).append(" listener after initialization").toString(), (boolean)connectionQuotas$7.maxConnectionsExceeded(listener.listenerName()));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ TooManyConnectionsException $anonfun$acceptConnectionsAboveIpLimit$1(ConnectionQuotasTest $this, ConnectionQuotas connectionQuotas$9, ListenerName listenerName$2, ListenerDesc listenerDesc$1, long i) {
        return (TooManyConnectionsException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> connectionQuotas$9.inc(listenerName$2, listenerDesc$1.defaultIp(), (Meter)$this.blockedPercentMeters().apply((Object)listenerName$2.value())), ClassTag$.MODULE$.apply(TooManyConnectionsException.class), new Position("ConnectionQuotasTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionQuotasTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Object[] objectArray = new Tuple2[3];
        ListenerDesc $minus$greater$extension_y3 = new ListenerDesc(this, new ListenerName("EXTERNAL"), InetAddress.getByName("192.168.1.1"));
        String $minus$greater$extension_$this = "EXTERNAL";
        Object var1_2 = null;
        Object var2_1 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        ListenerDesc listenerDesc = new ListenerDesc(this, new ListenerName("ADMIN"), InetAddress.getByName("192.168.1.2"));
        String $minus$greater$extension_$this2 = "ADMIN";
        Object var3_4 = null;
        listenerDesc = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ListenerDesc listenerDesc2 = new ListenerDesc(this, new ListenerName("REPLICATION"), InetAddress.getByName("192.168.1.3"));
        String $minus$greater$extension_$this3 = "REPLICATION";
        Object var5_6 = null;
        listenerDesc2 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        this.listeners = (Map)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.blockedPercentMeters = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.knownHost = InetAddress.getByName("192.168.10.0");
        this.unknownHost = InetAddress.getByName("192.168.2.0");
    }

    public class ListenerDesc
    implements Product,
    Serializable {
        private final ListenerName listenerName;
        private final InetAddress defaultIp;
        public final /* synthetic */ ConnectionQuotasTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public ListenerName listenerName() {
            return this.listenerName;
        }

        public InetAddress defaultIp() {
            return this.defaultIp;
        }

        public String toString() {
            return new StringBuilder(20).append("(listener=").append(this.listenerName().value()).append(", client=").append(this.defaultIp().getHostAddress()).append(")").toString();
        }

        public ListenerDesc copy(ListenerName listenerName, InetAddress defaultIp) {
            return new ListenerDesc(this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer(), listenerName, defaultIp);
        }

        public ListenerName copy$default$1() {
            return this.listenerName();
        }

        public InetAddress copy$default$2() {
            return this.defaultIp();
        }

        public String productPrefix() {
            return "ListenerDesc";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.listenerName();
                }
                case 1: {
                    return this.defaultIp();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ListenerDesc;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "listenerName";
                }
                case 1: {
                    return "defaultIp";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return MurmurHash3$.MODULE$.productHash((Product)this, -889275714, false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ListenerDesc)) return false;
            if (((ListenerDesc)x$1).kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() != this.kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ListenerDesc listenerDesc = (ListenerDesc)x$1;
            ListenerName listenerName = this.listenerName();
            ListenerName listenerName2 = listenerDesc.listenerName();
            if (listenerName == null) {
                if (listenerName2 != null) {
                    return false;
                }
            } else if (!listenerName.equals(listenerName2)) return false;
            InetAddress inetAddress = this.defaultIp();
            InetAddress inetAddress2 = listenerDesc.defaultIp();
            if (inetAddress == null) {
                if (inetAddress2 != null) {
                    return false;
                }
            } else if (!((Object)inetAddress).equals(inetAddress2)) return false;
            if (!listenerDesc.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConnectionQuotasTest kafka$network$ConnectionQuotasTest$ListenerDesc$$$outer() {
            return this.$outer;
        }

        public ListenerDesc(ConnectionQuotasTest $outer, ListenerName listenerName, InetAddress defaultIp) {
            this.listenerName = listenerName;
            this.defaultIp = defaultIp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

