/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.Set;
import kafka.admin.BrokerApiVersionsCommand$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005y2A\u0001B\u0003\u0001\u0015!)\u0011\u0003\u0001C\u0001%!)Q\u0003\u0001C\u0001-!)Q\u0005\u0001C\u0001M\ta\"I]8lKJ\f\u0005/\u001b,feNLwN\\:D_6l\u0017M\u001c3UKN$(B\u0001\u0004\b\u0003\u0015\tG-\\5o\u0015\u0005A\u0011!B6bM.\f7\u0001A\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q!AD\u0004\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003!5\u0011acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003M\u0001\"\u0001\u0006\u0001\u000e\u0003\u0015\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002/A\u0019\u0001$H\u0010\u000e\u0003eQ!AG\u000e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq\u0012DA\u0002TKF\u0004\"\u0001I\u0012\u000e\u0003\u0005R!AI\u0004\u0002\rM,'O^3s\u0013\t!\u0013EA\u0006LC\u001a\\\u0017mQ8oM&<\u0017AI2iK\u000e\\'I]8lKJ\f\u0005/\u001b,feNLwN\\\"p[6\fg\u000eZ(viB,H\u000fF\u0001(!\tA\u0013&D\u0001\u001c\u0013\tQ3D\u0001\u0003V]&$\bFA\u0002-!\tic'D\u0001/\u0015\ty\u0003'A\u0002ba&T!!\r\u001a\u0002\u000f),\b/\u001b;fe*\u00111\u0007N\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002k\u0005\u0019qN]4\n\u0005]r#\u0001\u0002+fgRDCaA\u001d={A\u0011QFO\u0005\u0003w9\u0012q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0001")
public class BrokerApiVersionsCommandTest
extends KafkaServerTestHarness {
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> {
            props.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), "CONTROLLER");
            props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), "CONTROLLER:PLAINTEXT,PLAINTEXT:PLAINTEXT");
            props.setProperty("listeners", "PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
            props.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), "PLAINTEXT://localhost:0,CONTROLLER://localhost:0");
            return props;
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    @Timeout(value=120L)
    @Test
    public void checkBrokerApiVersionCommandOutput() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, StandardCharsets.UTF_8.name());
        BrokerApiVersionsCommand$.MODULE$.execute(new String[]{"--bootstrap-server", this.brokerList()}, printStream);
        String content = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
        Iterator lineIter = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])content.split("\n")));
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)new StringBuilder(24).append(this.brokerList()).append(" (id: 0 rack: null) -> (").toString(), (Object)lineIter.next());
        NodeApiVersions nodeApiVersions = NodeApiVersions.create();
        scala.collection.mutable.Set enabledApis = CollectionConverters$.MODULE$.SetHasAsScala((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER)).asScala();
        enabledApis.foreach((Function1 & Serializable)apiKey -> {
            BrokerApiVersionsCommandTest.$anonfun$checkBrokerApiVersionCommandOutput$1(nodeApiVersions, enabledApis, lineIter, apiKey);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)")", (Object)lineIter.next());
        Assertions.assertFalse((boolean)lineIter.hasNext());
    }

    public static final /* synthetic */ void $anonfun$checkBrokerApiVersionCommandOutput$1(NodeApiVersions nodeApiVersions$1, scala.collection.mutable.Set enabledApis$1, Iterator lineIter$1, ApiKeys apiKey) {
        ApiVersionsResponseData.ApiVersion apiVersion = nodeApiVersions$1.apiVersion(apiKey);
        Assertions.assertNotNull((Object)apiVersion);
        String versionRangeStr = apiVersion.minVersion() == apiVersion.maxVersion() ? Short.toString(apiVersion.minVersion()) : new StringBuilder(4).append(apiVersion.minVersion()).append(" to ").append(apiVersion.maxVersion()).toString();
        short usableVersion = nodeApiVersions$1.latestUsableVersion(apiKey);
        ApiKeys apiKeys = apiKey;
        Object object = enabledApis$1.last();
        String terminator = !(apiKeys != null ? !apiKeys.equals(object) : object != null) ? "" : ",";
        String line = new StringBuilder(16).append("\t").append(apiKey.name).append("(").append(apiKey.id).append("): ").append(versionRangeStr).append(" [usable: ").append(usableVersion).append("]").append(terminator).toString();
        Assertions.assertTrue((boolean)lineIter$1.hasNext());
        Assertions.assertEquals((Object)line, (Object)lineIter$1.next());
    }
}

