/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.admin.PreferredReplicaLeaderElectionCommand$;
import kafka.admin.PreferredReplicaLeaderElectionCommandTestAuthorizer;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0013&\u0001)BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001A\u0002\u0013\u0005A\bC\u0004L\u0001\u0001\u0007I\u0011\u0001'\t\rM\u0003\u0001\u0015)\u0003>\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0011%\ty\u0002AI\u0001\n\u0013\t\t\u0003\u0003\u0004d\u0001\u0011%\u0011q\u0007\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\ty\u0006\u0001C\u0005\u0003CBq!!\u001a\u0001\t\u0013\t9\u0007C\u0005\u0002v\u0001\t\n\u0011\"\u0003\u0002x!9\u00111\u0010\u0001\u0005\n\u0005u\u0004\"CAB\u0001E\u0005I\u0011BAC\u0011%\tI\t\u0001b\u0001\n\u0003\tY\tC\u0004\u0002\u000e\u0002\u0001\u000b\u0011\u0002:\t\u0013\u0005=\u0005A1A\u0005\u0002\u0005E\u0005\u0002CAO\u0001\u0001\u0006I!a%\t\u0013\u0005}\u0005A1A\u0005\u0002\u0005\u0005\u0006\u0002CAR\u0001\u0001\u0006I!!\u0003\t\u0013\u0005\u0015\u0006A1A\u0005\u0002\u0005\u001d\u0006\u0002CAW\u0001\u0001\u0006I!!+\t\r\u0005=\u0006\u0001\"\u0001V\u0011\u0019\tI\f\u0001C\u0001+\"1\u0011Q\u0018\u0001\u0005\u0002UCq!!1\u0001\t\u0013\t\u0019\r\u0003\u0004\u0002\\\u0002!\t!\u0016\u0005\u0007\u0003?\u0004A\u0011A+\t\r\u0005\r\b\u0001\"\u0001V\u0011\u0019\t9\u000f\u0001C\u0001+\"1\u00111\u001e\u0001\u0005\u0002UCa!a<\u0001\t\u0003)\u0006BBAz\u0001\u0011\u0005Q\u000b\u0003\u0004\u0002x\u0002!\t!\u0016\u0005\u0007\u0003w\u0004A\u0011A+\u0003SA\u0013XMZ3se\u0016$'+\u001a9mS\u000e\fG*Z1eKJ,E.Z2uS>t7i\\7nC:$G+Z:u\u0015\t1s%A\u0003bI6LgNC\u0001)\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u00162!\tas&D\u0001.\u0015\tqs%\u0001\u0002{W&\u0011\u0001'\f\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005I*T\"A\u001a\u000b\u0005Q:\u0013!B;uS2\u001c\u0018B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005i\u0002Q\"A\u0013\u0002\u000fM,'O^3sgV\tQ\bE\u0002?\u0007\u0016k\u0011a\u0010\u0006\u0003\u0001\u0006\u000b!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#@\u0005\r\u0019V-\u001d\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u001e\naa]3sm\u0016\u0014\u0018B\u0001&H\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003\u001bF\u0003\"AT(\u000e\u0003\u0005K!\u0001U!\u0003\tUs\u0017\u000e\u001e\u0005\b%\u000e\t\t\u00111\u0001>\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001NQ\t)q\u000b\u0005\u0002YC6\t\u0011L\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0005qk\u0016a\u00026va&$XM\u001d\u0006\u0003=~\u000bQA[;oSRT\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012Z\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\rde\u0016\fG/\u001a+fgR$v\u000e]5d\u0003:$7\t\\;ti\u0016\u0014H\u0003B'f\u0003\u001fAQA\u001a\u0004A\u0002\u001d\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003i_J\\hBA5n!\tQ\u0017)D\u0001l\u0015\ta\u0017&\u0001\u0004=e>|GOP\u0005\u0003]\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u00019r\u0005\ri\u0015\r\u001d\u0006\u0003]\u0006\u0003\"a]=\u000e\u0003QT!!\u001e<\u0002\r\r|W.\\8o\u0015\tAsO\u0003\u0002y?\u00061\u0011\r]1dQ\u0016L!A\u001f;\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B)A0a\u0001\u0002\n9\u0011Qp \b\u0003UzL\u0011AQ\u0005\u0004\u0003\u0003\t\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003\u000b\t9A\u0001\u0003MSN$(bAA\u0001\u0003B\u0019a*a\u0003\n\u0007\u00055\u0011IA\u0002J]RD\u0011\"!\u0005\u0007!\u0003\u0005\r!a\u0005\u0002\u0015\u0005,H\u000f[8sSj,'\u000fE\u0003O\u0003+\tI\"C\u0002\u0002\u0018\u0005\u0013aa\u00149uS>t\u0007c\u00015\u0002\u001c%\u0019\u0011QD9\u0003\rM#(/\u001b8h\u0003\r\u001a'/Z1uKR+7\u000f\u001e+pa&\u001c\u0017I\u001c3DYV\u001cH/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\t+\t\u0005M\u0011QE\u0016\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011G!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0005-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKR)Q*!\u000f\u0002>!1\u00111\b\u0005A\u0002\u001d\f\u0001\u0004]1si&$\u0018n\u001c8t\u0003:$\u0017i]:jO:lWM\u001c;t\u0011\u001d\ty\u0004\u0003a\u0001\u0003\u0003\nQB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u001c\b\u0003\u0002 D\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003vi&d'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001\u00042pk:\u001cWmU3sm\u0016\u0014H#B'\u0002X\u0005m\u0003bBA-\u0013\u0001\u0007\u0011\u0011B\u0001\ri\u0006\u0014x-\u001a;TKJ4XM\u001d\u0005\u0007\u0003;J\u0001\u0019\u0001:\u0002\u0013A\f'\u000f^5uS>t\u0017!D4fi\u000e{g\u000e\u001e:pY2,'\u000f\u0006\u0002\u0002dA!a*!\u0006F\u0003-\tw/Y5u\u0019\u0016\fG-\u001a:\u0015\r\u0005%\u0011\u0011NA6\u0011\u001517\u00021\u0001s\u0011%\tig\u0003I\u0001\u0002\u0004\ty'A\u0005uS6,w.\u001e;NgB\u0019a*!\u001d\n\u0007\u0005M\u0014I\u0001\u0003M_:<\u0017!F1xC&$H*Z1eKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003sRC!a\u001c\u0002&\u0005y!m\\8ugR\u0014\u0018\r]*feZ,'\u000f\u0006\u0003\u0002\u001a\u0005}\u0004\"CAA\u001bA\u0005\t\u0019AA\u0005\u0003\u0019\u0011'o\\6fe\u0006I\"m\\8ugR\u0014\u0018\r]*feZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t9I\u000b\u0003\u0002\n\u0005\u0015\u0012!\u0004;fgR\u0004\u0016M\u001d;ji&|g.F\u0001s\u00039!Xm\u001d;QCJ$\u0018\u000e^5p]\u0002\nq\u0003^3tiB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0016\u0005\u0005M\u0005CBAK\u00037\u000bI!\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T \u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA\u0003\u0003/\u000b\u0001\u0004^3tiB\u000b'\u000f^5uS>t\u0017i]:jO:lWM\u001c;!\u0003q!Xm\u001d;QCJ$\u0018\u000e^5p]B\u0013XMZ3se\u0016$G*Z1eKJ,\"!!\u0003\u0002;Q,7\u000f\u001e)beRLG/[8o!J,g-\u001a:sK\u0012dU-\u00193fe\u0002\n!\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3BgNLwM\\7f]R,\"!!+\u0011\u000f\u0005U\u00151\u0016:\u0002\u0014&\u0019\u0001/a&\u00027Q,7\u000f\u001e)beRLG/[8o\u0003:$\u0017i]:jO:lWM\u001c;!\u0003a!Xm\u001d;Nk2$\u0018\u000e\u001d7f\u0005J|7.\u001a:t\u000f&4XM\u001c\u0015\u0004/\u0005M\u0006c\u0001-\u00026&\u0019\u0011qW-\u0003\tQ+7\u000f^\u0001\u0017i\u0016\u001cH/\u00138wC2LGM\u0011:pW\u0016\u0014x)\u001b<f]\"\u001a\u0001$a-\u0002+Q,7\u000f\u001e(p!\u0006\u0014H/\u001b;j_:\u001cx)\u001b<f]\"\u001a\u0011$a-\u0002\u0015Q|'j]8o\r&dW\r\u0006\u0003\u0002F\u0006E\u0007\u0003BAd\u0003\u001bl!!!3\u000b\t\u0005-\u00171J\u0001\u0003S>LA!a4\u0002J\n!a)\u001b7f\u0011\u001d\t\u0019N\u0007a\u0001\u0003+\f!\u0002]1si&$\u0018n\u001c8t!\u0011A\u0017q\u001b:\n\u0007\u0005e\u0017OA\u0002TKR\f1\u0004^3tiNKgn\u001a7fi>t\u0007+\u0019:uSRLwN\\$jm\u0016t\u0007fA\u000e\u00024\u0006)B/Z:u)>\u0004\u0018n\u0019#pKNtu\u000e^#ySN$\bf\u0001\u000f\u00024\u0006!C/Z:u\u001bVdG/\u001b9mKB\u000b'\u000f^5uS>t7oU1nK\u0006\u001b8/[4o[\u0016tG\u000fK\u0002\u001e\u0003g\u000b\u0001\u0003^3ti:{w\u000e]#mK\u000e$\u0018n\u001c8)\u0007y\t\u0019,A\u0010uKN$x+\u001b;i\u001f\u001a4G.\u001b8f!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006D3aHAZ\u0003-!Xm\u001d;US6,w.\u001e;)\u0007\u0001\n\u0019,\u0001\tuKN$\u0018)\u001e;iu\u001a\u000b\u0017\u000e\\;sK\"\u001a\u0011%a-\u00029Q,7\u000f\u001e)sK\u001a,'O]3e%\u0016\u0004H.[2b\u0015N|g\u000eR1uC\"\u001a!%a-\u0002CQ,7\u000f\u001e\"bg&\u001c\u0007K]3gKJ\u0014X\r\u001a*fa2L7-Y#mK\u000e$\u0018n\u001c8)\u0007\r\n\u0019\f")
public class PreferredReplicaLeaderElectionCommandTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final TopicPartition testPartition = new TopicPartition("test", 0);
    private final List<Object> testPartitionAssignment = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
    private final int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)this.testPartitionAssignment().head());
    private final scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.testPartition()), this.testPartitionAssignment())}));

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> topicPartition, Option<String> authorizer) {
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1);
        brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("auto.leader.rebalance.enable", "false"));
        if (authorizer instanceof Some) {
            String className = (String)((Some)authorizer).value();
            brokerConfigs.foreach((Function1 & Serializable)p -> p.setProperty("authorizer.class.name", className));
        } else if (!None$.MODULE$.equals(authorizer)) {
            throw new MatchError(authorizer);
        }
        this.createTestTopicAndCluster(topicPartition, brokerConfigs);
    }

    private void createTestTopicAndCluster(scala.collection.immutable.Map<TopicPartition, List<Object>> partitionsAndAssignments, Seq<Properties> brokerConfigs) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable)b -> {
            void createServer_time;
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time time3 = time2;
            KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(b);
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
        partitionsAndAssignments.foreach((Function1 & Serializable)x0$1 -> {
            PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$4(this, x0$1);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$5(this, partitionsAndAssignments)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Replicas for topic test not created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private Option<String> createTestTopicAndCluster$default$2() {
        return None$.MODULE$;
    }

    private void bounceServer(int targetServer, TopicPartition partition) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Shutting down server ").append(targetServer).append(" so a non-preferred replica becomes leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).shutdown();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Starting server ").append(targetServer).append(" now that a non-preferred replica is leader").toString());
        ((KafkaServer)this.servers().apply(targetServer)).startup();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$3(this, partition, targetServer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$6(partition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private Option<KafkaServer> getController() {
        return this.servers().find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$getController$1(p)));
    }

    private int awaitLeader(TopicPartition topicPartition, long timeoutMs) {
        Option option;
        long l = 100L;
        long awaitValue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!(option = PreferredReplicaLeaderElectionCommandTest.$anonfun$awaitLeader$1(this, topicPartition)).isDefined()) {
            if (System.currentTimeMillis() > awaitValue_waitUntilTrue_startTime + timeoutMs) {
                Assertions.fail((String)PreferredReplicaLeaderElectionCommandTest.$anonfun$awaitLeader$3(topicPartition));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeoutMs), l));
        }
        return BoxesRunTime.unboxToInt((Object)option.get());
    }

    private long awaitLeader$default$2() {
        return 15000L;
    }

    private String bootstrapServer(int broker) {
        int port = ((KafkaServer)this.servers().apply(broker)).socketServer().boundPort(ListenerName.normalised((String)"PLAINTEXT"));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Server bound to port ").append(port).toString());
        return new StringBuilder(10).append("localhost:").append(port).toString();
    }

    private int bootstrapServer$default$1() {
        return 0;
    }

    public TopicPartition testPartition() {
        return this.testPartition;
    }

    public List<Object> testPartitionAssignment() {
        return this.testPartitionAssignment;
    }

    public int testPartitionPreferredLeader() {
        return this.testPartitionPreferredLeader;
    }

    public scala.collection.immutable.Map<TopicPartition, List<Object>> testPartitionAndAssignment() {
        return this.testPartitionAndAssignment;
    }

    @Test
    public void testMultipleBrokersGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", new StringBuilder(1).append(this.bootstrapServer(1)).append(",").append(this.bootstrapServer(0)).toString()}, 30000);
        Assertions.assertEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
    }

    @Test
    public void testInvalidBrokerGiven() {
        Assertions.assertTrue((boolean)(((AdminCommandFailedException)Assertions.assertThrows(AdminCommandFailedException.class, () -> PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", "example.com:1234"}, 1000))).getCause() instanceof TimeoutException));
    }

    @Test
    public void testNoPartitionsGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0)}, 30000);
        Assertions.assertEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
    }

    /*
     * WARNING - void declaration
     */
    private File toJsonFile(scala.collection.immutable.Set<TopicPartition> partitions) {
        void var2_2;
        File jsonFile = File.createTempFile("preferredreplicaelection", ".js");
        jsonFile.deleteOnExit();
        String jsonString = TestUtils$.MODULE$.stringifyTopicPartitions(partitions);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(12).append("Using json: ").append(jsonString).toString());
        Files.write(Paths.get(jsonFile.getAbsolutePath(), new String[0]), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return var2_2;
    }

    @Test
    public void testSingletonPartitionGiven() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
        }
        finally {
            jsonFile.delete();
        }
        Assertions.assertEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
    }

    @Test
    public void testTopicDoesNotExist() {
        TopicPartition nonExistentPartition = new TopicPartition("does.not.exist", 0);
        List nonExistentPartitionAssignment = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        scala.collection.immutable.Map nonExistentPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)nonExistentPartition), (Object)nonExistentPartitionAssignment)}));
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)nonExistentPartitionAndAssignment.keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                Assertions.assertTrue((boolean)(adminCommandFailedException.getSuppressed()[0] instanceof UnknownTopicOrPartitionException));
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testMultiplePartitionsSameAssignment() {
        TopicPartition testPartitionA = new TopicPartition("testA", 0);
        TopicPartition testPartitionB = new TopicPartition("testB", 0);
        List testPartitionAssignment = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        int testPartitionPreferredLeader = BoxesRunTime.unboxToInt((Object)testPartitionAssignment.head());
        scala.collection.immutable.Map testPartitionAndAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionA), (Object)testPartitionAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)testPartitionB), (Object)testPartitionAssignment)}));
        this.createTestTopicAndCluster((scala.collection.immutable.Map<TopicPartition, List<Object>>)testPartitionAndAssignment, (Option<String>)None$.MODULE$);
        this.bounceServer(testPartitionPreferredLeader, testPartitionA);
        Assertions.assertNotEquals((int)testPartitionPreferredLeader, (int)this.awaitLeader(testPartitionA, 15000L));
        Assertions.assertNotEquals((int)testPartitionPreferredLeader, (int)this.awaitLeader(testPartitionB, 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)testPartitionAndAssignment.keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
        }
        finally {
            jsonFile.delete();
        }
        Assertions.assertEquals((int)testPartitionPreferredLeader, (int)this.awaitLeader(testPartitionA, 15000L));
        Assertions.assertEquals((int)testPartitionPreferredLeader, (int)this.awaitLeader(testPartitionB, 15000L));
    }

    @Test
    public void testNoopElection() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        Assertions.assertEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
            Assertions.assertEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testWithOfflinePreferredReplica() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)leader);
        ((KafkaServer)this.servers().apply(this.testPartitionPreferredLeader())).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
                Assertions.fail();
            }
            catch (AdminCommandFailedException e) {
                Assertions.assertEquals((Object)"1 preferred replica(s) could not be elected", (Object)e.getMessage());
                Throwable suppressed = e.getSuppressed()[0];
                Assertions.assertTrue((boolean)(suppressed instanceof PreferredLeaderNotAvailableException));
                Assertions.assertTrue((boolean)suppressed.getMessage().contains("Failed to elect leader for partition test-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"), (String)suppressed.getMessage());
                Assertions.assertEquals((int)leader, (int)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testTimeout() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)None$.MODULE$);
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)leader);
        int controller = ((KafkaServer)this.getController().get()).config().brokerId();
        ((KafkaServer)this.servers().apply(controller)).shutdown();
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(controller), "--path-to-json-file", jsonFile.getAbsolutePath()}, 2000);
                Assertions.fail();
            }
            catch (AdminCommandFailedException e) {
                Assertions.assertEquals((Object)"Timeout waiting for election results", (Object)e.getMessage());
                Assertions.assertEquals((int)leader, (int)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testAuthzFailure() {
        this.createTestTopicAndCluster(this.testPartitionAndAssignment(), (Option<String>)new Some((Object)PreferredReplicaLeaderElectionCommandTestAuthorizer.class.getName()));
        this.bounceServer(this.testPartitionPreferredLeader(), this.testPartition());
        int leader = this.awaitLeader(this.testPartition(), 15000L);
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)leader);
        Assertions.assertNotEquals((int)this.testPartitionPreferredLeader(), (int)this.awaitLeader(this.testPartition(), 15000L));
        File jsonFile = this.toJsonFile((scala.collection.immutable.Set<TopicPartition>)this.testPartitionAndAssignment().keySet());
        try {
            try {
                PreferredReplicaLeaderElectionCommand$.MODULE$.run(new String[]{"--bootstrap-server", this.bootstrapServer(0), "--path-to-json-file", jsonFile.getAbsolutePath()}, 30000);
                Assertions.fail();
            }
            catch (AdminCommandFailedException e) {
                Assertions.assertEquals((Object)"Not authorized to perform leader election", (Object)e.getMessage());
                Assertions.assertTrue((boolean)(e.getCause() instanceof ClusterAuthorizationException));
                Assertions.assertEquals((int)leader, (int)this.awaitLeader(this.testPartition(), 15000L));
            }
        }
        finally {
            jsonFile.delete();
        }
    }

    @Test
    public void testPreferredReplicaJsonData() {
        scala.collection.immutable.Set partitionsForPreferredReplicaElection = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("test", 1), new TopicPartition("test2", 1)}));
        PreferredReplicaLeaderElectionCommand$.MODULE$.writePreferredReplicaElectionData(this.zkClient(), (Set)partitionsForPreferredReplicaElection);
        scala.collection.immutable.Set partitionsUndergoingPreferredReplicaElection = this.zkClient().getPreferredReplicaElection();
        Assertions.assertEquals((Object)partitionsForPreferredReplicaElection, (Object)partitionsUndergoingPreferredReplicaElection, (String)"Preferred replica election ser-de failed");
    }

    @Test
    public void testBasicPreferredReplicaElection() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        None$ none$5;
        scala.collection.immutable.Map expectedReplicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}));
        String topic = "test";
        int partition = 0;
        int preferredReplica = 0;
        scala.collection.immutable.Map brokerRack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2")}));
        String x$2 = this.zkConnect();
        boolean bl = true;
        None$ none$6 = none$5 = None$.MODULE$;
        none$5 = null;
        None$ x$6 = none$6;
        None$ none$7 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$7 = none$7;
        None$ none$8 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$8;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 1;
        boolean bl6 = false;
        int n2 = 1;
        short s2 = 1;
        Seq serverConfigs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, x$2, false, bl, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl2, bl3, bl4, bl5, (Map<Object, String>)brokerRack, n, bl6, n2, s2).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$18 = new Properties();
        boolean x$20 = qual$1.createTopicWithAssignment$default$4();
        boolean x$21 = qual$1.createTopicWithAssignment$default$5();
        qual$1.createTopicWithAssignment(topic, x$18, (Map)expectedReplicaAssignment, x$20, x$21);
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)serverConfigs.reverse()).map((Function1 & Serializable)s -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer((KafkaConfig)s, createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
        })));
        KafkaZkClient x$22 = this.zkClient();
        None$ x$25 = None$.MODULE$;
        long l = 30000L;
        None$ none$9 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$27 = none$9;
        int currentLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$22, topic, partition, l, (Option<Object>)x$25, (Option<Object>)x$27);
        new PreferredReplicaLeaderElectionCommand(this.zkClient(), (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, partition)}))).moveLeaderToPreferredReplica();
        KafkaZkClient x$28 = this.zkClient();
        Some x$31 = new Some((Object)BoxesRunTime.boxToInteger((int)currentLeader));
        long l2 = 30000L;
        None$ none$10 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$33 = none$10;
        int newLeader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$28, topic, partition, l2, (Option<Object>)x$31, (Option<Object>)x$33);
        Assertions.assertEquals((int)preferredReplica, (int)newLeader, (String)"Preferred replica election failed");
    }

    public static final /* synthetic */ void $anonfun$createTestTopicAndCluster$4(PreferredReplicaLeaderElectionCommandTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            List assignment = (List)x0$1._2();
            $this.zkClient().createTopicAssignment(tp.topic(), (Option)new Some((Object)Uuid.randomUuid()), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)assignment)})));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$7(KafkaServer server$1, Tuple2 partitionAndAssignment) {
        LogManager qual$1 = server$1.getLogManager();
        TopicPartition x$1 = (TopicPartition)partitionAndAssignment._1();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(x$1, x$2).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$createTestTopicAndCluster$5(PreferredReplicaLeaderElectionCommandTest $this, scala.collection.immutable.Map partitionsAndAssignments$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)partitionsAndAssignments$1.forall((Function1 & Serializable)partitionAndAssignment -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$createTestTopicAndCluster$7(server, partitionAndAssignment)))));
    }

    public static final /* synthetic */ String $anonfun$createTestTopicAndCluster$8() {
        return "Replicas for topic test not created";
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$5(int targetServer$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState) {
        return partitionState.isr().contains(BoxesRunTime.boxToInteger((int)targetServer$1));
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$4(TopicPartition partition$1, int targetServer$1, KafkaServer server) {
        return server.metadataCache().getPartitionInfo(partition$1.topic(), partition$1.partition()).exists((Function1 & Serializable)partitionState -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$5(targetServer$1, partitionState)));
    }

    public static final /* synthetic */ boolean $anonfun$bounceServer$3(PreferredReplicaLeaderElectionCommandTest $this, TopicPartition partition$1, int targetServer$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)PreferredReplicaLeaderElectionCommandTest.$anonfun$bounceServer$4(partition$1, targetServer$1, server)));
    }

    public static final /* synthetic */ String $anonfun$bounceServer$6(TopicPartition partition$1) {
        return new StringBuilder(35).append("Replicas for partition ").append(partition$1).append(" not created").toString();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(KafkaServer p) {
        return p.kafkaController().isActive();
    }

    public static final /* synthetic */ Option $anonfun$awaitLeader$1(PreferredReplicaLeaderElectionCommandTest $this, TopicPartition topicPartition$1) {
        return ((KafkaServer)$this.servers().head()).metadataCache().getPartitionInfo(topicPartition$1.topic(), topicPartition$1.partition()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.leader()));
    }

    public static final /* synthetic */ String $anonfun$awaitLeader$3(TopicPartition topicPartition$1) {
        return new StringBuilder(44).append("Timed out waiting to find current leader of ").append(topicPartition$1).toString();
    }
}

