/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.BrokerMetadataCheckpoint$;
import kafka.server.MetaProperties;
import kafka.server.MetaProperties$;
import kafka.server.RawMetaProperties;
import kafka.server.RawMetaProperties$;
import kafka.server.ZkMetaProperties;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005y4AAE\n\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0013!\u0003BB\u0017\u0001A\u0003%Q\u0005C\u0003/\u0001\u0011\u0005q\u0006C\u0003A\u0001\u0011\u0005q\u0006C\u0003C\u0001\u0011\u0005q\u0006C\u0003E\u0001\u0011\u0005q\u0006C\u0003G\u0001\u0011\u0005q\u0006C\u0003I\u0001\u0011\u0005q\u0006C\u0003K\u0001\u0011\u0005q\u0006C\u0003M\u0001\u0011\u0005q\u0006C\u0003O\u0001\u0011%q\nC\u0003]\u0001\u0011\u0005q\u0006C\u0003_\u0001\u0011\u0005q\u0006C\u0003a\u0001\u0011\u0005q\u0006C\u0003c\u0001\u0011\u0005q\u0006C\u0003e\u0001\u0011%QM\u0001\u000fCe>\\WM]'fi\u0006$\u0017\r^1DQ\u0016\u001c7\u000e]8j]R$Vm\u001d;\u000b\u0005Q)\u0012AB:feZ,'OC\u0001\u0017\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t1#A\bdYV\u001cH/\u001a:JI\n\u000b7/\u001a\u001c5+\u0005)\u0003C\u0001\u0014,\u001b\u00059#B\u0001\u0015*\u0003\u0011a\u0017M\\4\u000b\u0003)\nAA[1wC&\u0011Af\n\u0002\u0007'R\u0014\u0018N\\4\u0002!\rdWo\u001d;fe&#')Y:fmQ\u0002\u0013a\u0007;fgR\u0014V-\u00193XSRDgj\u001c8Fq&\u001cH/\u001a8u\r&dW\rF\u00011!\tQ\u0012'\u0003\u000237\t!QK\\5uQ\t!A\u0007\u0005\u00026}5\taG\u0003\u00028q\u0005\u0019\u0011\r]5\u000b\u0005eR\u0014a\u00026va&$XM\u001d\u0006\u0003wq\nQA[;oSRT\u0011!P\u0001\u0004_J<\u0017BA 7\u0005\u0011!Vm\u001d;\u0002=Q,7\u000f^\"sK\u0006$XMW6NKR\fG-\u0019;b!J|\u0007/\u001a:uS\u0016\u001c\bFA\u00035\u0003!\"Xm\u001d;QCJ\u001cXMU1x\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t/&$\bn\\;u-\u0016\u00148/[8oQ\t1A'\u0001\u0013uKN$(+Y<Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5J]Z\fG.\u001b3Ce>\\WM]%eQ\t9A'\u0001\u000fuKN$8I]3bi\u0016lU\r^1eCR\f\u0007K]8qKJ$\u0018.Z:)\u0005!!\u0014\u0001\n;fgRlU\r^1Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5NSN\u001c\u0018N\\4WKJ\u001c\u0018n\u001c8)\u0005%!\u0014a\n;fgRlU\r^1Qe>\u0004XM\u001d;jKN\fE\u000e\\8xg\"+\u00070\u00128d_\u0012,G-V+J\tND#A\u0003\u001b\u0002MQ,7\u000f^'fi\u0006\u0004&o\u001c9feRLWm],ji\"tuN\\+vS\u0012\u001cE.^:uKJLE\r\u000b\u0002\fi\u0005i2m\u001c8gSJlg+\u00197jI\u001a{'/T3uCB\u0013x\u000e]3si&,7\u000f\u0006\u00021!\")\u0011\u000b\u0004a\u0001%\u0006I1\r\\;ti\u0016\u0014\u0018\n\u001a\t\u0003'js!\u0001\u0016-\u0011\u0005U[R\"\u0001,\u000b\u0005];\u0012A\u0002\u001fs_>$h(\u0003\u0002Z7\u00051\u0001K]3eK\u001aL!\u0001L.\u000b\u0005e[\u0012!\n;fgRlU\r^1Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5NSN\u001c\u0018N\\4Ce>\\WM]%eQ\tiA'A\u0015uKN$X*\u001a;b!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i\u001b&\u001c8/\u001b8h\u0007>tGO]8mY\u0016\u0014\u0018\n\u001a\u0015\u0003\u001dQ\nQ\b^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018-\u00118e\u001f\u001a4G.\u001b8f\t&\u00148oV5uQ:{g.\u001a=jgR,g\u000e\u001e#je\u0016\u001cGo\u001c:jKND#a\u0004\u001b\u0002aQ,7\u000f^$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\u0006sGm\u00144gY&tW\rR5sg&;gn\u001c:f\u001b&\u001c8/\u001b8hQ\t\u0001B'\u0001\u0015uKN$X)\u001c9us\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018-\u00118e\u001f\u001a4G.\u001b8f\t&\u00148\u000f\u0006\u00031M:L\b\"B4\u0012\u0001\u0004A\u0017A\u00027pO\u0012K'\u000f\u0005\u0002jY6\t!N\u0003\u0002lS\u0005\u0011\u0011n\\\u0005\u0003[*\u0014AAR5mK\")q.\u0005a\u0001a\u0006\u0019R\r\u001f9fGR,Gm\u00144gY&tW\rR5sgB\u0019\u0011O\u001e5\u000f\u0005I$hBA+t\u0013\u0005a\u0012BA;\u001c\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001e=\u0003\u0007M+\u0017O\u0003\u0002v7!)!0\u0005a\u0001w\u0006i\u0011n\u001a8pe\u0016l\u0015n]:j]\u001e\u0004\"A\u0007?\n\u0005u\\\"a\u0002\"p_2,\u0017M\u001c")
public class BrokerMetadataCheckpointTest {
    private final String clusterIdBase64;

    private String clusterIdBase64() {
        return this.clusterIdBase64;
    }

    @Test
    public void testReadWithNonExistentFile() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)new BrokerMetadataCheckpoint(new File("path/that/does/not/exist")).read());
    }

    @Test
    public void testCreateZkMetadataProperties() {
        ZkMetaProperties meta = new ZkMetaProperties("7bc79ca1-9746-42a3-a35a-efb3cde44492", 3);
        Properties properties = meta.toProperties();
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertEquals((int)0, (int)parsed.version());
        Assertions.assertEquals((Object)new Some((Object)meta.clusterId()), (Object)parsed.clusterId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)meta.brokerId())), (Object)parsed.brokerId());
    }

    @Test
    public void testParseRawMetaPropertiesWithoutVersion() {
        int brokerId = 1;
        String clusterId = "7bc79ca1-9746-42a3-a35a-efb3cde44492";
        Properties properties = new Properties();
        properties.put(RawMetaProperties$.MODULE$.BrokerIdKey(), Integer.toString(brokerId));
        properties.put(RawMetaProperties$.MODULE$.ClusterIdKey(), clusterId);
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)parsed.brokerId());
        Assertions.assertEquals((Object)new Some((Object)clusterId), (Object)parsed.clusterId());
        Assertions.assertEquals((int)0, (int)parsed.version());
    }

    @Test
    public void testRawPropertiesWithInvalidBrokerId() {
        Properties properties = new Properties();
        properties.put(RawMetaProperties$.MODULE$.BrokerIdKey(), "oof");
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertThrows(RuntimeException.class, () -> parsed.brokerId());
    }

    @Test
    public void testCreateMetadataProperties() {
        this.confirmValidForMetaProperties(this.clusterIdBase64());
    }

    @Test
    public void testMetaPropertiesWithMissingVersion() {
        RawMetaProperties properties = new RawMetaProperties(new Properties());
        properties.clusterId_$eq(this.clusterIdBase64());
        properties.nodeId_$eq(1);
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testMetaPropertiesAllowsHexEncodedUUIDs() {
        String clusterId = "7bc79ca1-9746-42a3-a35a-efb3cde44492";
        this.confirmValidForMetaProperties(clusterId);
    }

    @Test
    public void testMetaPropertiesWithNonUuidClusterId() {
        String clusterId = "not a valid uuid";
        this.confirmValidForMetaProperties(clusterId);
    }

    private void confirmValidForMetaProperties(String clusterId) {
        MetaProperties meta = new MetaProperties(clusterId, 5);
        RawMetaProperties properties = new RawMetaProperties(meta.toProperties());
        MetaProperties meta2 = MetaProperties$.MODULE$.parse(properties);
        Assertions.assertEquals((Object)meta, (Object)meta2);
    }

    @Test
    public void testMetaPropertiesWithMissingBrokerId() {
        RawMetaProperties properties = new RawMetaProperties(new Properties());
        properties.version_$eq(1);
        properties.clusterId_$eq(this.clusterIdBase64());
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testMetaPropertiesWithMissingControllerId() {
        RawMetaProperties properties = new RawMetaProperties(new Properties());
        properties.version_$eq(1);
        properties.clusterId_$eq(this.clusterIdBase64());
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testGetBrokerMetadataAndOfflineDirsWithNonexistentDirectories() {
        File invalidDir = TestUtils.tempFile((String)"blah");
        try {
            this.testEmptyGetBrokerMetadataAndOfflineDirs(invalidDir, (scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{invalidDir}))), true);
            this.testEmptyGetBrokerMetadataAndOfflineDirs(invalidDir, (scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{invalidDir}))), false);
        }
        finally {
            Utils.delete((File)invalidDir);
        }
    }

    @Test
    public void testGetBrokerMetadataAndOfflineDirsIgnoreMissing() {
        File file;
        File file2;
        File file3 = file2 = TestUtils.tempDirectory(null, null);
        file2 = null;
        File file4 = file = file3;
        file = null;
        File tempDir = file4;
        try {
            this.testEmptyGetBrokerMetadataAndOfflineDirs(tempDir, (scala.collection.immutable.Seq<File>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true);
            Assertions.assertThrows(RuntimeException.class, () -> BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tempDir.getAbsolutePath()})), false));
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testEmptyGetBrokerMetadataAndOfflineDirs(File logDir, scala.collection.immutable.Seq<File> expectedOfflineDirs, boolean ignoreMissing) {
        void var5_5;
        void var6_6;
        Tuple2 tuple2 = BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{logDir.getAbsolutePath()})), ignoreMissing);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RawMetaProperties metaProperties = (RawMetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        Assertions.assertEquals((Object)expectedOfflineDirs.map((Function1 & Serializable)x$2 -> x$2.getAbsolutePath()), (Object)var6_6);
        Assertions.assertEquals((Object)new Properties(), (Object)var5_5.props());
    }

    public BrokerMetadataCheckpointTest() {
        this.clusterIdBase64 = "H3KKO4NTRPaCWtEmm3vW7A";
    }
}

