/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAq\u0001\b\u0001C\u0002\u0013\u0005Q\u0004\u0003\u0004'\u0001\u0001\u0006IA\b\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0011\u0019!\u0004\u0001)A\u0005S!)Q\u0007\u0001C\u0001m!)\u0001\n\u0001C\u0001\u0013\")!\r\u0001C\u0001m!)A\r\u0001C\u0001K\")Q\u000f\u0001C\u0001m!)q\u000f\u0001C\u0001m!)\u0011\u0010\u0001C\u0005u\"9\u00111\u0002\u0001\u0005\n\u00055!A\u0006'jgR|eMZ:fiN\u0014V-];fgR$Vm\u001d;\u000b\u0005A\t\u0012AB:feZ,'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\b\n\u0005ay!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003\u0015!x\u000e]5d+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001*!\tQ#'D\u0001,\u0015\taS&\u0001\u0004d_6lwN\u001c\u0006\u0003%9R!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO&\u00111g\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u001ai\u0016\u001cH\u000fT5ti>3gm]3ug\u0016\u0013(o\u001c:D_\u0012,7\u000fF\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;)\u0005\u0019q\u0004CA G\u001b\u0005\u0001%BA!C\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0012\u000bqA[;qSR,'O\u0003\u0002Fa\u0005)!.\u001e8ji&\u0011q\t\u0011\u0002\u0005)\u0016\u001cH/A\u000ebgN,'\u000f\u001e*fgB|gn]3FeJ|'OR8s\u000bB|7\r\u001b\u000b\u0005o)\u0013v\u000bC\u0003L\u000f\u0001\u0007A*A\u0003feJ|'\u000f\u0005\u0002N!6\taJ\u0003\u0002PW\u0005A\u0001O]8u_\u000e|G.\u0003\u0002R\u001d\n1QI\u001d:peNDQaU\u0004A\u0002Q\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\t\u0003qUK!AV\u001d\u0003\u0007%sG\u000fC\u0003Y\u000f\u0001\u0007\u0011,\u0001\ndkJ\u0014XM\u001c;MK\u0006$WM]#q_\u000eD\u0007c\u0001.^?6\t1L\u0003\u0002]E\u0005!Q\u000f^5m\u0013\tq6L\u0001\u0005PaRLwN\\1m!\ty\u0002-\u0003\u0002bA\t9\u0011J\u001c;fO\u0016\u0014\u0018A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0005?\u0003M1W\r^2i\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i)\u00111GN\u001c9\u0011\ta:\u0017\u000eV\u0005\u0003Qf\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u001dk\u0013\tY\u0017H\u0001\u0003M_:<\u0007\"B7\n\u0001\u0004!\u0016\u0001C:feZ,'/\u00133\t\u000b=L\u0001\u0019A5\u0002\u0013QLW.Z:uC6\u0004\b\"B9\n\u0001\u0004\u0011\u0018a\u0002<feNLwN\u001c\t\u0003qML!\u0001^\u001d\u0003\u000bMCwN\u001d;\u0002?Q,7\u000f\u001e*fgB|gn]3J]\u000edW\u000fZ3t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\u000b}\u0005)D/Z:u%\u0016\u001c\bo\u001c8tK\u0012+g-Y;mi>3gm]3u\u0003:$G*Z1eKJ,\u0005o\\2i\r>\u0014\u0018\t\u001c7WKJ\u001c\u0018n\u001c8tQ\tYa(A\nbgN,'\u000f\u001e*fgB|gn]3FeJ|'\u000f\u0006\u00038wrl\b\"B&\r\u0001\u0004a\u0005\"B*\r\u0001\u0004!\u0006\"\u0002@\r\u0001\u0004y\u0018a\u0002:fcV,7\u000f\u001e\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0016\u0002\u0011I,\u0017/^3tiNLA!!\u0003\u0002\u0004\t\u0011B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\r\u0005=\u0011QCA\r!\u0011\t\t!!\u0005\n\t\u0005M\u00111\u0001\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\u0007\u0003/i\u0001\u0019\u0001+\u0002\u00111,\u0017\rZ3s\u0013\u0012DQA`\u0007A\u0002}\u0004")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Test
    public void testListOffsetsErrorCodes() {
        List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0)}))).asJava())}))).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), new Properties());
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$3))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{listOffsetPartition}))).asJava())}))).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    public Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        List targetTimes = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsTopic[]{new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ListOffsetsRequestData.ListOffsetsPartition[]{new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp)}))).asJava())}))).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        ListOffsetsResponse response = this.sendRequest(serverId, request);
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$fetchOffsetAndEpoch$1(this, x$4))).get()).partitions()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$fetchOffsetAndEpoch$2(this, x$5))).get();
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple2.mcJI.sp(-1L, partitionData.leaderEpoch());
            }
            return new Tuple2.mcJI.sp(Predef$.MODULE$.Long2long((Long)CollectionConverters$.MODULE$.ListHasAsScala(partitionData.oldStyleOffsets()).asScala().head()), partitionData.leaderEpoch());
        }
        return new Tuple2.mcJI.sp(partitionData.offset(), partitionData.leaderEpoch());
    }

    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, -1);
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), this.partition(), firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaServer>)this.servers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -1L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, -1);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                return;
            }
            if (version >= 4) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetAndEpoch$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$4) {
        String string = x$4.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetAndEpoch$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$5) {
        return x$5.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        CollectionConverters$.MODULE$.ListHasAsScala(topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

