/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.util.Properties;
import kafka.server.metadata.CachedConfigRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000592A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013\tQ2)Y2iK\u0012\u001cuN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018\u0010V3ti*\u0011q\u0001C\u0001\t[\u0016$\u0018\rZ1uC*\u0011\u0011BC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\f\u0011\u0005]\u0001Q\"\u0001\u0004\u0002'Q,7\u000f^#naRL(+\u001a9pg&$xN]=\u0015\u0003i\u0001\"aD\u000e\n\u0005q\u0001\"\u0001B+oSRD#A\u0001\u0010\u0011\u0005}AS\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013aA1qS*\u00111\u0005J\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)c%A\u0003kk:LGOC\u0001(\u0003\ry'oZ\u0005\u0003S\u0001\u0012A\u0001V3ti\u0006\u0019B/Z:u'\u0016$(I]8lKJ\u001cuN\u001c4jO\"\u00121AH\u0001\u0013i\u0016\u001cHoU3u)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002\u0005=\u0001")
public class CachedConfigRepositoryTest {
    @Test
    public void testEmptyRepository() {
        CachedConfigRepository repository = new CachedConfigRepository();
        Assertions.assertEquals((Object)new Properties(), (Object)repository.brokerConfig(0));
        Assertions.assertEquals((Object)new Properties(), (Object)repository.topicConfig("foo"));
    }

    @Test
    public void testSetBrokerConfig() {
        CachedConfigRepository repository = new CachedConfigRepository();
        int brokerId0 = 0;
        repository.setBrokerConfig(brokerId0, "foo", null);
        Assertions.assertEquals((Object)new Properties(), (Object)repository.brokerConfig(0));
        int brokerId1 = 1;
        repository.setBrokerConfig(brokerId1, "foo", "bar");
        Properties brokerProperties = new Properties();
        brokerProperties.put("foo", "bar");
        Assertions.assertEquals((Object)brokerProperties, (Object)repository.brokerConfig(brokerId1));
        Properties brokerProperties2 = new Properties();
        brokerProperties2.put("foo", "bar");
        brokerProperties2.put("foo2", "baz");
        repository.setBrokerConfig(brokerId1, "foo2", "baz");
        Assertions.assertEquals((Object)brokerProperties2, (Object)repository.brokerConfig(brokerId1));
        repository.setBrokerConfig(brokerId1, "foo2", null);
        Assertions.assertEquals((Object)brokerProperties, (Object)repository.brokerConfig(brokerId1));
    }

    @Test
    public void testSetTopicConfig() {
        CachedConfigRepository repository = new CachedConfigRepository();
        String topic0 = "topic0";
        repository.setTopicConfig(topic0, "foo", null);
        Assertions.assertEquals((Object)new Properties(), (Object)repository.brokerConfig(0));
        String topic1 = "topic1";
        repository.setTopicConfig(topic1, "foo", "bar");
        Properties topicProperties = new Properties();
        topicProperties.put("foo", "bar");
        Assertions.assertEquals((Object)topicProperties, (Object)repository.topicConfig(topic1));
        Properties topicProperties2 = new Properties();
        topicProperties2.put("foo", "bar");
        topicProperties2.put("foo2", "baz");
        repository.setTopicConfig(topic1, "foo2", "baz");
        Assertions.assertEquals((Object)topicProperties2, (Object)repository.topicConfig(topic1));
        repository.setTopicConfig(topic1, "foo2", null);
        Assertions.assertEquals((Object)topicProperties, (Object)repository.topicConfig(topic1));
    }
}

