/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.RackAwareMode;
import kafka.api.BaseProducerSendTest;
import kafka.api.BaseProducerSendTest$callback$1$;
import kafka.api.BaseProducerSendTest$callback$3$;
import kafka.controller.ReplicaAssignment;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rh!B\u0012%\u0003\u0003I\u0003\"\u0002\u0019\u0001\t\u0003\t\u0004\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0003#\u0001\u0001\u0004\u0005\r\u0011\"\u0003F\u0011%I\u0006\u00011AA\u0002\u0013%!\fC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005\r\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011C9\t\ri\u0004\u0001\u0015!\u0003s\u0011\u001dY\bA1A\u0005\nqDq!!\u0001\u0001A\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u0006!9\u0011Q\u0005\u0001\u0005\u0012\u0005\u001d\u0002\"CA0\u0001E\u0005I\u0011CA1\u0011%\t9\bAI\u0001\n#\t\t\u0007C\u0005\u0002z\u0001\t\n\u0011\"\u0005\u0002b!I\u00111\u0010\u0001\u0012\u0002\u0013E\u0011Q\u0010\u0005\n\u0003\u0003\u0003\u0011\u0013!C\t\u0003\u0007C\u0011\"a\"\u0001#\u0003%\t\"a!\t\u000f\u0005%\u0005\u0001\"\u0005\u0002\f\"9\u0011q\u0012\u0001\u0005\u0002\u0005\u0015\u0001bBAM\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003;\u0003A\u0011AA\u0003\u0011\u001d\t\t\u000b\u0001C\t\u0003GC\u0011\"!,\u0001#\u0003%\t\"!\u0019\t\u0013\u0005=\u0006!%A\u0005\u0012\u0005\r\u0005bBAY\u0001\u0011E\u00111\u0017\u0005\b\u0003\u0017\u0004A\u0011AA\u0003\u0011\u001d\ty\r\u0001C\u0001\u0003\u000bAq!a5\u0001\t\u0003\t)\u0001C\u0004\u0002X\u0002!\t!!\u0002\t\u000f\u0005m\u0007\u0001\"\u0001\u0002\u0006!9\u0011q\u001c\u0001\u0005\u0002\u0005\u0015!\u0001\u0006\"bg\u0016\u0004&o\u001c3vG\u0016\u00148+\u001a8e)\u0016\u001cHO\u0003\u0002&M\u0005\u0019\u0011\r]5\u000b\u0003\u001d\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\u0011QFJ\u0001\fS:$Xm\u001a:bi&|g.\u0003\u00020Y\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u00111\u0007A\u0007\u0002I\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u00017!\r9DHP\u0007\u0002q)\u0011\u0011HO\u0001\u000bG>dG.Z2uS>t'\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uB$aA*fcB\u0011qHQ\u0007\u0002\u0001*\u0011\u0011IJ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\r\u0003%aC&bM.\f7i\u001c8gS\u001e\f\u0001bY8ogVlWM]\u000b\u0002\rB!q\t\u0015*S\u001b\u0005A%B\u0001#J\u0015\tQ5*A\u0004dY&,g\u000e^:\u000b\u0005\u001db%BA'O\u0003\u0019\t\u0007/Y2iK*\tq*A\u0002pe\u001eL!!\u0015%\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\r\u0019FKV\u0007\u0002u%\u0011QK\u000f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'^K!\u0001\u0017\u001e\u0003\t\tKH/Z\u0001\rG>t7/^7fe~#S-\u001d\u000b\u00037z\u0003\"a\u0015/\n\u0005uS$\u0001B+oSRDqa\u0018\u0003\u0002\u0002\u0003\u0007a)A\u0002yIE\n\u0011bY8ogVlWM\u001d\u0011\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A2\u0011\u0007\u0011<\u0017.D\u0001f\u0015\t1\u0007(A\u0004nkR\f'\r\\3\n\u0005!,'A\u0002\"vM\u001a,'\u000f\u0005\u0003k[J\u0013V\"A6\u000b\u00051L\u0015\u0001\u00039s_\u0012,8-\u001a:\n\u00059\\'!D&bM.\f\u0007K]8ek\u000e,'/\u0001\u0006qe>$WoY3sg\u0002\nQ\u0001^8qS\u000e,\u0012A\u001d\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fA\u0001\\1oO*\tq/\u0001\u0003kCZ\f\u0017BA=u\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\n!B\\;n%\u0016\u001cwN\u001d3t+\u0005i\bCA*\u007f\u0013\ty(HA\u0002J]R\f1B\\;n%\u0016\u001cwN\u001d3tA\u0005)1/\u001a;VaR\t1\fK\u0002\r\u0003\u0013\u0001B!a\u0003\u0002\u00185\u0011\u0011Q\u0002\u0006\u0004K\u0005=!\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u00169\u000bQA[;oSRLA!!\u0007\u0002\u000e\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!DA\u0010!\u0011\tY!!\t\n\t\u0005\r\u0012Q\u0002\u0002\n\u0003\u001a$XM]#bG\"\fab\u0019:fCR,\u0007K]8ek\u000e,'\u000fF\bj\u0003S\t\t%!\u0012\u0002J\u00055\u0013\u0011KA.\u0011\u001d\tYC\u0004a\u0001\u0003[\t!B\u0019:pW\u0016\u0014H*[:u!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003gQTBAA\u001b\u0015\r\t9\u0004K\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\"(\u0001\u0004Qe\u0016$WMZ\u0005\u0004s\u0006}\"bAA\u001eu!A\u00111\t\b\u0011\u0002\u0003\u0007Q0\u0001\u0005mS:<WM]'t\u0011!\t9E\u0004I\u0001\u0002\u0004i\u0018!\u00053fY&4XM]=US6,w.\u001e;Ng\"A\u00111\n\b\u0011\u0002\u0003\u0007Q0A\u0005cCR\u001c\u0007nU5{K\"I\u0011q\n\b\u0011\u0002\u0003\u0007\u0011QF\u0001\u0010G>l\u0007O]3tg&|g\u000eV=qK\"I\u00111\u000b\b\u0011\u0002\u0003\u0007\u0011QK\u0001\u000b[\u0006D(\t\\8dW6\u001b\bcA*\u0002X%\u0019\u0011\u0011\f\u001e\u0003\t1{gn\u001a\u0005\n\u0003;r\u0001\u0013!a\u0001\u0003+\n!BY;gM\u0016\u00148+\u001b>f\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003GR3!`A3W\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA9u\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00141\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001G2sK\u0006$X\r\u0015:pIV\u001cWM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u00021\r\u0014X-\u0019;f!J|G-^2fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u0000)\"\u0011QFA3\u0003a\u0019'/Z1uKB\u0013x\u000eZ;dKJ$C-\u001a4bk2$HEN\u000b\u0003\u0003\u000bSC!!\u0016\u0002f\u0005A2M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001c\u0002!I,w-[:uKJ\u0004&o\u001c3vG\u0016\u0014HcA5\u0002\u000e\")A.\u0006a\u0001S\u0006qA/Z:u'\u0016tGm\u00144gg\u0016$\bf\u0001\f\u0002\u0014B!\u00111BAK\u0013\u0011\t9*!\u0004\u0003\tQ+7\u000f^\u0001(i\u0016\u001cHoU3oI\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0018\u0003'\u000b!\u0006^3tiN+g\u000e\u001a(p]\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<WmV5uQ\u000e\u0013X-\u0019;f)&lW\rK\u0002\u0019\u0003'\u000bQb]3oI\u0006sGMV3sS\u001aLHcB.\u0002&\u0006\u001d\u0016\u0011\u0016\u0005\u0006Yf\u0001\r!\u001b\u0005\bwf\u0001\n\u00111\u0001~\u0011%\tY+\u0007I\u0001\u0002\u0004\t)&A\u0005uS6,w.\u001e;Ng\u000692/\u001a8e\u0003:$g+\u001a:jMf$C-\u001a4bk2$HEM\u0001\u0018g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=%I\u00164\u0017-\u001e7uIM\nac]3oI\u0006sGMV3sS\u001aLH+[7fgR\fW\u000e\u001d\u000b\u00067\u0006U\u0016q\u0017\u0005\u0006Yr\u0001\r!\u001b\u0005\b\u0003sc\u0002\u0019AA^\u00035!\u0018.\\3ti\u0006l\u0007\u000fV=qKB!\u0011QXAd\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017A\u0002:fG>\u0014HMC\u0002\u0002F.\u000baaY8n[>t\u0017\u0002BAe\u0003\u007f\u0013Q\u0002V5nKN$\u0018-\u001c9UsB,\u0017!\u0003;fgR\u001cEn\\:fQ\ri\u00121S\u0001\u0014i\u0016\u001cHoU3oIR{\u0007+\u0019:uSRLwN\u001c\u0015\u0004=\u0005M\u0015\u0001\u000b;fgR\u001cVM\u001c3CK\u001a|'/Z!oI\u00063G/\u001a:QCJ$\u0018\u000e^5p]\u0016C\b/\u00198tS>t\u0007fA\u0010\u0002\u0014\u0006IA/Z:u\r2,8\u000f\u001b\u0015\u0004A\u0005M\u0015\u0001\u000b;fgR\u001cEn\\:f/&$\bNW3s_RKW.Z8vi\u001a\u0013x.\\\"bY2,'\u000f\u00165sK\u0006$\u0007fA\u0011\u0002\u0014\u0006AC/Z:u\u00072|7/Z,ji\"TVM]8US6,w.\u001e;Ge>l7+\u001a8eKJ$\u0006N]3bI\"\u001a!%a%")
public abstract class BaseProducerSendTest
extends KafkaServerTestHarness {
    private KafkaConsumer<byte[], byte[]> consumer;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final String topic;
    private final int kafka$api$BaseProducerSendTest$$numRecords;

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Map map;
        Properties overridingProps = new Properties();
        int numServers = 2;
        overridingProps.put(KafkaConfig$.MODULE$.NumPartitionsProp(), Integer.toString(4));
        String x$2 = this.zkConnect();
        Some x$4 = new Some((Object)this.securityProtocol());
        Option<File> x$5 = this.trustStoreFile();
        Option<Properties> x$6 = this.serverSaslProperties();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Map map2 = map = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        map = null;
        Map x$12 = map2;
        int n = 1;
        boolean bl6 = false;
        int n2 = 1;
        short s = 1;
        int n3 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(numServers, x$2, false, bl, (Option<SecurityProtocol>)x$4, x$5, x$6, bl2, bl3, bl4, bl5, (Map<Object, String>)x$12, n, bl6, n2, s, n3).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, overridingProps));
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    private Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    public String topic() {
        return this.topic;
    }

    public int kafka$api$BaseProducerSendTest$$numRecords() {
        return this.kafka$api$BaseProducerSendTest$$numRecords;
    }

    @Override
    @BeforeEach
    public void setUp() {
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        String string;
        String string2;
        super.setUp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String string3 = string2 = "group";
        string2 = null;
        String x$3 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$4 = string4;
        boolean bl = true;
        boolean bl2 = false;
        int n = 500;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$3, x$4, bl, bl2, n, SecurityProtocol.PLAINTEXT, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.consumer().close();
        this.producers().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        super.tearDown();
    }

    public KafkaProducer<byte[], byte[]> createProducer(String brokerList, int lingerMs, int deliveryTimeoutMs, int batchSize, String compressionType, long maxBlockMs, long bufferSize) {
        ByteArraySerializer byteArraySerializer;
        ByteArraySerializer byteArraySerializer2;
        SecurityProtocol x$3 = this.securityProtocol();
        Option<File> x$4 = this.trustStoreFile();
        Option<Properties> x$5 = this.clientSaslProperties();
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        int n3 = 20000;
        ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
        byteArraySerializer2 = null;
        ByteArraySerializer x$14 = byteArraySerializer3;
        ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
        byteArraySerializer = null;
        ByteArraySerializer x$15 = byteArraySerializer4;
        boolean bl = false;
        KafkaProducer producer = TestUtils$.MODULE$.createProducer(brokerList, n, maxBlockMs, bufferSize, n2, deliveryTimeoutMs, lingerMs, batchSize, compressionType, n3, x$3, x$4, x$5, x$14, x$15, bl);
        return this.registerProducer(producer);
    }

    public int createProducer$default$2() {
        return 0;
    }

    public int createProducer$default$3() {
        return 120000;
    }

    public int createProducer$default$4() {
        return 16384;
    }

    public String createProducer$default$5() {
        return "none";
    }

    public long createProducer$default$6() {
        return 60000L;
    }

    public long createProducer$default$7() {
        return 0x100000L;
    }

    public KafkaProducer<byte[], byte[]> registerProducer(KafkaProducer<byte[], byte[]> producer) {
        this.producers().$plus$eq(producer);
        return producer;
    }

    @Test
    public void testSendOffset() {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)0L, (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 0");
            ProducerRecord record1 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), (Object)"key".getBytes(StandardCharsets.UTF_8), null);
            Assertions.assertEquals((long)1L, (long)((RecordMetadata)producer.send(record1, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 1");
            ProducerRecord record2 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)2L, (long)((RecordMetadata)producer.send(record2, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 2");
            ProducerRecord record3 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            Assertions.assertEquals((long)3L, (long)((RecordMetadata)producer.send(record3, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)"Should have offset 3");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$4 -> producer.send(record0, (Callback)this.callback$2(callback$module, partition)));
            Assertions.assertEquals((long)((long)this.kafka$api$BaseProducerSendTest$$numRecords() + 4L), (long)((RecordMetadata)producer.send(record0, (Callback)this.callback$2(callback$module, partition)).get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords() + 4).toString());
        }
    }

    @Test
    public void testSendCompressedMessageWithCreateTime() {
        String x$1 = this.brokerList();
        int x$5 = this.createProducer$default$4();
        long x$6 = this.createProducer$default$6();
        long x$7 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, Integer.MAX_VALUE, Integer.MAX_VALUE, x$5, "gzip", x$6, x$7);
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithCreateTime() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
        this.sendAndVerifyTimestamp(producer, TimestampType.CREATE_TIME);
    }

    public void sendAndVerify(KafkaProducer<byte[], byte[]> producer, int numRecords, long timeoutMs) {
        int partition = 0;
        try {
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            IndexedSeq futures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), numRecords).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerify$1(this, partition, producer, BoxesRunTime.unboxToInt((Object)i)));
            producer.close(Duration.ofMillis(timeoutMs));
            int lastOffset = BoxesRunTime.unboxToInt((Object)futures.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(offset, future) -> BoxesRunTime.boxToInteger((int)BaseProducerSendTest.$anonfun$sendAndVerify$2(this, partition, BoxesRunTime.unboxToInt((Object)offset), future))));
            Assertions.assertEquals((int)numRecords, (int)lastOffset);
        }
        finally {
            producer.close();
        }
    }

    public int sendAndVerify$default$2() {
        return this.kafka$api$BaseProducerSendTest$$numRecords();
    }

    public long sendAndVerify$default$3() {
        return 20000L;
    }

    public void sendAndVerifyTimestamp(KafkaProducer<byte[], byte[]> producer, TimestampType timestampType) {
        LazyRef callback$module = new LazyRef();
        int partition = 0;
        long baseTimestamp = 123456L;
        long startTime = System.currentTimeMillis();
        try {
            Properties topicProps = new Properties();
            TimestampType timestampType2 = timestampType;
            TimestampType timestampType3 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType2 != null ? !timestampType2.equals(timestampType3) : timestampType3 != null)) {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "LogAppendTime");
            } else {
                topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampTypeProp(), "CreateTime");
            }
            this.createTopic(this.topic(), 1, 2, topicProps);
            IndexedSeq recordAndFutures = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$1(this, partition, baseTimestamp, producer, callback$module, timestampType, startTime, BoxesRunTime.unboxToInt((Object)i)));
            producer.close(Duration.ofSeconds(20L));
            recordAndFutures.foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$sendAndVerifyTimestamp$2(timestampType, startTime, x0$1);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset(), (String)new StringBuilder(47).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).append(" but only successfully sent ").append(this.callback$4(callback$module, timestampType, baseTimestamp, startTime, partition).offset()).toString());
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testClose() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
            ProducerRecord record0 = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(StandardCharsets.UTF_8), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$5 -> producer.send(record0));
            Future response0 = producer.send(record0);
            producer.close();
            Assertions.assertTrue((boolean)response0.isDone(), (String)"The last message should be acked before producer is shutdown");
            Assertions.assertEquals((long)this.kafka$api$BaseProducerSendTest$$numRecords(), (long)((RecordMetadata)response0.get()).offset(), (String)new StringBuilder(19).append("Should have offset ").append(this.kafka$api$BaseProducerSendTest$$numRecords()).toString());
        }
    }

    @Test
    public void testSendToPartition() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            int partition = 1;
            long now = System.currentTimeMillis();
            ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), Predef$.MODULE$.long2Long(now), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$6 -> (RecordMetadata)x$6.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$4(this, partition, x$7);
                return BoxedUnit.UNIT;
            });
            this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
            ((IterableOnceOps)TestUtils$.MODULE$.consumeRecords(this.consumer(), this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
                BaseProducerSendTest.$anonfun$testSendToPartition$5(this, partition, now, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Test
    public void testSendBeforeAndAfterPartitionExpansion() {
        String x$1 = this.brokerList();
        int x$3 = this.createProducer$default$2();
        int x$4 = this.createProducer$default$3();
        int x$5 = this.createProducer$default$4();
        String x$6 = this.createProducer$default$5();
        long x$7 = this.createProducer$default$7();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$3, x$4, x$5, x$6, 5000L, x$7);
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition0 = 0;
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$8 -> (RecordMetadata)x$8.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$9 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$4(this, partition0, x$9);
            return BoxedUnit.UNIT;
        });
        int partition1 = 1;
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)"value".getBytes(StandardCharsets.UTF_8))).get());
        Assertions.assertEquals(TimeoutException.class, e.getCause().getClass());
        Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)assignment);
            return tuple2;
        });
        AdminZkClient qual$1 = this.adminZkClient();
        String x$102 = this.topic();
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode x$82 = qual$2.getBrokerMetadatas$default$1();
        Option x$92 = qual$2.getBrokerMetadatas$default$2();
        Seq x$122 = qual$2.getBrokerMetadatas(x$82, x$92);
        Option x$14 = qual$1.addPartitions$default$5();
        boolean x$15 = qual$1.addPartitions$default$6();
        qual$1.addPartitions(x$102, existingAssignment, x$122, 2, x$14, x$15);
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), this.topic(), 0, 15000L);
        TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), this.topic(), 1, 15000L);
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition1), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$10 -> (RecordMetadata)x$10.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$11 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$10(this, partition1, x$11);
            return BoxedUnit.UNIT;
        });
        ((IterableOps)((IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition0), null, (Object)new StringBuilder(5).append("value").append(BoxesRunTime.unboxToInt((Object)i)).toString().getBytes(StandardCharsets.UTF_8)))).map((Function1 & Serializable)x$12 -> (RecordMetadata)x$12.get(30L, TimeUnit.SECONDS))).zip((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(this.kafka$api$BaseProducerSendTest$$numRecords()), 2 * this.kafka$api$BaseProducerSendTest$$numRecords()))).withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable)x$13 -> {
            BaseProducerSendTest.$anonfun$testSendBeforeAndAfterPartitionExpansion$14(this, partition0, x$13);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFlush() {
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());){
            this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
            ProducerRecord record = new ProducerRecord(this.topic(), (Object)"value".getBytes(StandardCharsets.UTF_8));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$17 -> {
                IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)x$14 -> producer.send(record));
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testFlush$3(x$15))), (String)"No request is complete.");
                producer.flush();
                Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isDone())), (String)"All requests are complete.");
            });
        }
    }

    @Test
    public void testCloseWithZeroTimeoutFromCallerThread() {
        this.createTopic(this.topic(), 2, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record0 = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$20 -> {
            KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, this.createProducer$default$4(), this.createProducer$default$5(), this.createProducer$default$6(), this.createProducer$default$7());
            IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)x$18 -> producer.send(record0));
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$3(x$19))), (String)"No request is complete.");
            producer.close(Duration.ZERO);
            responses.foreach((Function1 & Serializable)future -> {
                BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromCallerThread$4(future);
                return BoxedUnit.UNIT;
            });
            Assertions.assertEquals((int)0, (int)this.consumer().poll(Duration.ofMillis(50L)).count(), (String)"Fetch response should have no message returned.");
        });
    }

    @Test
    public void testCloseWithZeroTimeoutFromSenderThread() {
        this.createTopic(this.topic(), 1, 2, this.createTopic$default$4());
        int partition = 0;
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.topic(), partition)}))).asJava());
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)"value".getBytes(StandardCharsets.UTF_8));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 50).foreach((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$1(this, record, BoxesRunTime.unboxToInt((Object)i)));
    }

    private final /* synthetic */ BaseProducerSendTest$callback$1$ callback$lzycompute$1(LazyRef callback$module$1, int partition$1) {
        synchronized (callback$module$1) {
            BaseProducerSendTest$callback$1$ baseProducerSendTest$callback$1$ = callback$module$1.initialized() ? (BaseProducerSendTest$callback$1$)callback$module$1.value() : (BaseProducerSendTest$callback$1$)callback$module$1.initialize((Object)new BaseProducerSendTest$callback$1$(this, partition$1));
            return baseProducerSendTest$callback$1$;
        }
    }

    private final BaseProducerSendTest$callback$1$ callback$2(LazyRef callback$module$1, int partition$1) {
        if (callback$module$1.initialized()) {
            return (BaseProducerSendTest$callback$1$)callback$module$1.value();
        }
        return this.callback$lzycompute$1(callback$module$1, partition$1);
    }

    public static final /* synthetic */ Future $anonfun$sendAndVerify$1(BaseProducerSendTest $this, int partition$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$2), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return producer$2.send(record);
    }

    public static final /* synthetic */ int $anonfun$sendAndVerify$2(BaseProducerSendTest $this, int partition$2, int offset, Future future) {
        RecordMetadata recordMetadata = (RecordMetadata)future.get();
        Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
        Assertions.assertEquals((int)partition$2, (int)recordMetadata.partition());
        Assertions.assertEquals((long)offset, (long)recordMetadata.offset());
        return offset + 1;
    }

    private final /* synthetic */ BaseProducerSendTest$callback$3$ callback$lzycompute$2(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        synchronized (callback$module$2) {
            BaseProducerSendTest$callback$3$ baseProducerSendTest$callback$3$ = callback$module$2.initialized() ? (BaseProducerSendTest$callback$3$)callback$module$2.value() : (BaseProducerSendTest$callback$3$)callback$module$2.initialize((Object)new BaseProducerSendTest$callback$3$(this, timestampType$1, baseTimestamp$1, startTime$1, partition$3));
            return baseProducerSendTest$callback$3$;
        }
    }

    private final BaseProducerSendTest$callback$3$ callback$4(LazyRef callback$module$2, TimestampType timestampType$1, long baseTimestamp$1, long startTime$1, int partition$3) {
        if (callback$module$2.initialized()) {
            return (BaseProducerSendTest$callback$3$)callback$module$2.value();
        }
        return this.callback$lzycompute$2(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3);
    }

    public static final /* synthetic */ Tuple2 $anonfun$sendAndVerifyTimestamp$1(BaseProducerSendTest $this, int partition$3, long baseTimestamp$1, KafkaProducer producer$3, LazyRef callback$module$2, TimestampType timestampType$1, long startTime$1, int i) {
        ProducerRecord record = new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition$3), Predef$.MODULE$.long2Long(baseTimestamp$1 + (long)i), (Object)new StringBuilder(3).append("key").append(i).toString().getBytes(StandardCharsets.UTF_8), (Object)new StringBuilder(5).append("value").append(i).toString().getBytes(StandardCharsets.UTF_8));
        return new Tuple2((Object)record, (Object)producer$3.send(record, (Callback)$this.callback$4(callback$module$2, timestampType$1, baseTimestamp$1, startTime$1, partition$3)));
    }

    public static final /* synthetic */ void $anonfun$sendAndVerifyTimestamp$2(TimestampType timestampType$1, long startTime$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ProducerRecord record = (ProducerRecord)x0$1._1();
            RecordMetadata recordMetadata = (RecordMetadata)((Future)x0$1._2()).get();
            TimestampType timestampType = timestampType$1;
            TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertTrue((recordMetadata.timestamp() >= startTime$1 && recordMetadata.timestamp() <= System.currentTimeMillis() ? 1 : 0) != 0);
                return;
            }
            Assertions.assertEquals((Long)record.timestamp(), (long)recordMetadata.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$4(BaseProducerSendTest $this, int partition$4, Tuple2 x$7) {
        if (x$7 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$7._1();
            Assertions.assertEquals((long)x$7._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition$4, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendToPartition$5(BaseProducerSendTest $this, int partition$4, long now$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord record = (ConsumerRecord)x0$1._1();
            int i = x0$1._2$mcI$sp();
            Assertions.assertEquals((Object)$this.topic(), (Object)record.topic());
            Assertions.assertEquals((int)partition$4, (int)record.partition());
            Assertions.assertEquals((long)i, (long)record.offset());
            Assertions.assertNull((Object)record.key());
            Assertions.assertEquals((Object)new StringBuilder(5).append("value").append(i + 1).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((long)now$1, (long)record.timestamp());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$4(BaseProducerSendTest $this, int partition0$1, Tuple2 x$9) {
        if (x$9 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$9._1();
            Assertions.assertEquals((long)x$9._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$10(BaseProducerSendTest $this, int partition1$1, Tuple2 x$11) {
        if (x$11 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$11._1();
            Assertions.assertEquals((long)x$11._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition1$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testSendBeforeAndAfterPartitionExpansion$14(BaseProducerSendTest $this, int partition0$1, Tuple2 x$13) {
        if (x$13 != null) {
            RecordMetadata recordMetadata = (RecordMetadata)x$13._1();
            Assertions.assertEquals((long)x$13._2$mcI$sp(), (long)recordMetadata.offset());
            Assertions.assertEquals((Object)$this.topic(), (Object)recordMetadata.topic());
            Assertions.assertEquals((int)partition0$1, (int)recordMetadata.partition());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFlush$3(Future x$15) {
        return !x$15.isDone();
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromCallerThread$3(Future x$19) {
        return !x$19.isDone();
    }

    public static final /* synthetic */ void $anonfun$testCloseWithZeroTimeoutFromCallerThread$4(Future future) {
        ExecutionException e = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> future.get());
        Assertions.assertEquals(KafkaException.class, e.getCause().getClass());
    }

    public static final /* synthetic */ Future $anonfun$testCloseWithZeroTimeoutFromSenderThread$2(BaseProducerSendTest $this, KafkaProducer producer$9, ProducerRecord record$2, int i) {
        public class Kafka_api_BaseProducerSendTest$CloseCallback$1
        implements Callback {
            private final KafkaProducer<byte[], byte[]> producer;
            private final boolean sendRecords;
            private final /* synthetic */ BaseProducerSendTest $outer;
            private final ProducerRecord record$2;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (this.sendRecords) {
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.kafka$api$BaseProducerSendTest$$numRecords()).foreach((Function1 & Serializable)x$21 -> Kafka_api_BaseProducerSendTest$CloseCallback$1.$anonfun$onCompletion$1(this, BoxesRunTime.unboxToInt((Object)x$21)));
                }
                this.producer.close(Duration.ZERO);
                this.producer.close();
            }

            public static final /* synthetic */ Future $anonfun$onCompletion$1(Kafka_api_BaseProducerSendTest$CloseCallback$1 $this, int x$21) {
                return $this.producer.send($this.record$2);
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_api_BaseProducerSendTest$CloseCallback$1(KafkaProducer<byte[], byte[]> producer, boolean sendRecords) {
                void var4_4;
                this.producer = producer;
                this.sendRecords = sendRecords;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$2 = var4_4;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onCompletion$1$adapted(kafka.api.BaseProducerSendTest$CloseCallback$1 java.lang.Object )}, serializedLambda);
            }
        }
        return producer$9.send(record$2, (Callback)new Kafka_api_BaseProducerSendTest$CloseCallback$1($this, producer$9, i == 0, record$2));
    }

    public static final /* synthetic */ boolean $anonfun$testCloseWithZeroTimeoutFromSenderThread$3(Future x$22) {
        return !x$22.isDone();
    }

    public static final /* synthetic */ Seq $anonfun$testCloseWithZeroTimeoutFromSenderThread$1(BaseProducerSendTest $this, ProducerRecord record$2, int i2) {
        Seq<ConsumerRecord<byte[], byte[]>> seq;
        try (KafkaProducer<byte[], byte[]> producer = $this.createProducer($this.brokerList(), Integer.MAX_VALUE, Integer.MAX_VALUE, $this.createProducer$default$4(), $this.createProducer$default$5(), $this.createProducer$default$6(), $this.createProducer$default$7());){
            IndexedSeq responses = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.kafka$api$BaseProducerSendTest$$numRecords()).map((Function1 & Serializable)i -> BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$2($this, producer, record$2, BoxesRunTime.unboxToInt((Object)i)));
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)BaseProducerSendTest.$anonfun$testCloseWithZeroTimeoutFromSenderThread$3(x$22))), (String)"No request is complete.");
            producer.flush();
            Assertions.assertTrue((boolean)responses.forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isDone())), (String)"All requests are complete.");
            seq = TestUtils$.MODULE$.pollUntilAtLeastNumRecords($this.consumer(), $this.kafka$api$BaseProducerSendTest$$numRecords(), 15000L);
        }
        return seq;
    }

    public BaseProducerSendTest() {
        this.topic = "topic";
        this.kafka$api$BaseProducerSendTest$$numRecords = 100;
    }
}

