/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseFetchRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rBQ!\n\u0001\u0005\u0002\u0019BQA\u000f\u0001\u0005\u0002\u0019BQ\u0001\u0010\u0001\u0005\u0002\u0019BQA\u0010\u0001\u0005\u0002\u0019BQ\u0001\u0011\u0001\u0005\u0002\u0019BQA\u0011\u0001\u0005\n\rCQ!\u0013\u0001\u0005\u0002\u0019BQa\u0013\u0001\u0005\u0002\u0019BQ!\u0014\u0001\u0005\n9CQ\u0001\u0015\u0001\u0005\u0002\u0019BQA\u0015\u0001\u0005\u0002\u0019BQ\u0001\u0016\u0001\u0005\nUCQa\u0016\u0001\u0005\naCQ\u0001\u001c\u0001\u0005\u0002\u0019BQA\u001c\u0001\u0005\u0002\u0019BQ\u0001\u001d\u0001\u0005\u0002\u0019BQA\u001d\u0001\u0005\u0002\u0019BQ\u0001\u001e\u0001\u0005\u0002\u0019BQA\u001e\u0001\u0005\u0002\u0019BQ\u0001\u001f\u0001\u0005\neD\u0011\"!\n\u0001#\u0003%I!a\n\u0003!\u0019+Go\u00195SKF,Xm\u001d;UKN$(BA\r\u001b\u0003\u0019\u0019XM\u001d<fe*\t1$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0002CA\u0010!\u001b\u0005A\u0012BA\u0011\u0019\u0005Q\u0011\u0015m]3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003?\u0001\ta\u0006^3ti\n\u0013xn[3s%\u0016\u001c\b/Z2ugB\u000b'\u000f^5uS>t7o\u0014:eKJ\fe\u000eZ*ju\u0016d\u0015.\\5ugR\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0003V]&$\bF\u0001\u0002/!\ty\u0003(D\u00011\u0015\t\t$'A\u0002ba&T!a\r\u001b\u0002\u000f),\b/\u001b;fe*\u0011QGN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0002$\u0001\u0002+fgR\f1\u0005^3ti\u001a+Go\u00195SKF,Xm\u001d;Wi]KG\u000f\u001b*fC\u0012\u001cu.\\7jiR,G\r\u000b\u0002\u0004]\u0005aB/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e+p\u001d>t'+\u001a9mS\u000e\f\u0007F\u0001\u0003/\u0003y!Xm\u001d;MCN$h)\u001a;dQ\u0016$W\t]8dQZ\u000bG.\u001b3bi&|g\u000e\u000b\u0002\u0006]\u0005\tC/Z:u\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"4\u0016\r\\5eCRLwN\u001c,2e!\u0012aAL\u0001 G\",7m\u001b'bgR4U\r^2iK\u0012,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tGCA\u0014E\u0011\u0015)u\u00011\u0001G\u0003\u001d1XM]:j_:\u0004\"\u0001K$\n\u0005!K#!B*i_J$\u0018A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0005/\u0003u!Xm\u001d;DkJ\u0014XM\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o-F\u0012\u0004FA\u0005/\u0003m\u0019\u0007.Z2l\u0007V\u0014(/\u001a8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]R\u0011qe\u0014\u0005\u0006\u000b*\u0001\rAR\u0001&i\u0016\u001cH/\u00129pG\"4\u0016\r\\5eCRLwN\\,ji\"LgNR3uG\"\u001cVm]:j_:D#a\u0003\u0018\u0002QQ,7\u000f^#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8XSRD\u0017N\u001c$fi\u000eD7+Z:tS>tg+\r\u001a)\u00051q\u0013AJ2iK\u000e\\W\t]8dQZ\u000bG.\u001b3bi&|gnV5uQ&tg)\u001a;dQN+7o]5p]R\u0011qE\u0016\u0005\u0006\u000b6\u0001\rAR\u0001\u0019m\u0016\u0014\u0018NZ=GKR\u001c\u0007nU3tg&|g.\u0012:s_J\u001cH#B\u0014ZI&\\\u0007\"\u0002.\u000f\u0001\u0004Y\u0016A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u00039\nl\u0011!\u0018\u0006\u0003=~\u000baaY8n[>t'BA\u000ea\u0015\t\tg'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Gv\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003f\u001d\u0001\u0007a-A\u0006mK\u0006$WM]#q_\u000eD\u0007C\u0001\u0015h\u0013\tA\u0017FA\u0002J]RDQA\u001b\bA\u0002\u0019\f1\u0003Z3ti&t\u0017\r^5p]\n\u0013xn[3s\u0013\u0012DQ!\u0012\bA\u0002\u0019\u000bq\u0005^3ti\u0012{wO\\\"p]Z,'o]5p]^KG\u000f[\"p]:,7\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u0012qBL\u00017i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gN\u0012:p[\n\u000bGo\u00195fIR{WK\u001c2bi\u000eDW\r\u001a*fgB,7\r^:PM\u001a\u001cX\r\u001e\u0015\u0003!9\n!\u0007^3ti\u000e\u0013X-\u0019;f\u0013:\u001c'/Z7f]R\fGNR3uG\"<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NLe.\u0012:s_J4\u0016G\r\u0015\u0003#9\n!\u0005^3ti\u001a+Go\u00195XSRD\u0007+\u0019:uSRLwN\\:XSRD\u0017\nZ#se>\u0014\bF\u0001\n/\u0003]!Xm\u001d;['R$7i\\7qe\u0016\u001c8/\u001a3U_BL7\r\u000b\u0002\u0014]\u0005IB/Z:u5N#HmQ8naJ,7o]3e%\u0016\u001cwN\u001d3tQ\t!b&\u0001\ndQ\u0016\u001c7NR3uG\"\u0014Vm\u001d9p]N,G\u0003D\u0014{\u0003\u000b\t)\"!\u0007\u0002\u001e\u0005\u0005\u0002\"B>\u0016\u0001\u0004a\u0018AE3ya\u0016\u001cG/\u001a3QCJ$\u0018\u000e^5p]N\u0004B!`A\u000176\taP\u0003\u0002\u0000S\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\raPA\u0002TKFDq!a\u0002\u0016\u0001\u0004\tI!A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB/\u0002\u0011I,\u0017/^3tiNLA!a\u0005\u0002\u000e\tia)\u001a;dQJ+7\u000f]8og\u0016Da!a\u0006\u0016\u0001\u00041\u0017!E7bqB\u000b'\u000f^5uS>t')\u001f;fg\"1\u00111D\u000bA\u0002\u0019\f\u0001#\\1y%\u0016\u001c\bo\u001c8tK\nKH/Z:\t\r\u0005}Q\u00031\u0001g\u0003]qW/\\'fgN\fw-Z:QKJ\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002$U\u0001\n\u00111\u0001G\u0003=\u0011Xm\u001d9p]N,g+\u001a:tS>t\u0017\u0001H2iK\u000e\\g)\u001a;dQJ+7\u000f]8og\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0003SQ3ARA\u0016W\t\ti\u0003\u0005\u0003\u00020\u0005eRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001cS\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0012\u0011\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class FetchRequestTest
extends BaseFetchRequestTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        void createFetchRequest$1_version;
        FetchRequest fetchRequest;
        FetchRequest fetchRequest2;
        void createFetchRequest$1_version2;
        FetchRequest fetchRequest3;
        FetchRequest fetchRequest4;
        FetchRequest fetchRequest5;
        FetchRequest fetchRequest6;
        FetchRequest fetchRequest7;
        FetchRequest fetchRequest8;
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$1 -> x$1.swap())).asJava();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new Serializable(null, leaderId){
            private static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        });
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        short s = ApiKeys.FETCH.latestVersion();
        scala.collection.immutable.Map createFetchRequest$1_offsetMap = FetchRequestTest.createFetchRequest$default$2$1();
        FetchRequest fetchRequest9 = fetchRequest8 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions1, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap, s);
        Object var38_17 = null;
        fetchRequest8 = null;
        FetchRequest fetchRequest1 = fetchRequest9;
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$3 = FetchRequestTest.createFetchRequest$default$2$1();
        short createFetchRequest$1_version3 = 12;
        FetchRequest fetchRequest10 = fetchRequest7 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions1, (scala.collection.immutable.Map<TopicPartition, Object>)x$3, createFetchRequest$1_version3);
        fetchRequest7 = null;
        FetchRequest fetchRequest1V12 = fetchRequest10;
        FetchResponse fetchResponse1V12 = this.sendFetchRequest(leaderId, fetchRequest1V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Vector shuffledTopicPartitions2 = (Vector)((IterableOps)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)partitionsWithLargeMessages);
        short s2 = ApiKeys.FETCH.latestVersion();
        scala.collection.immutable.Map createFetchRequest$1_offsetMap2 = FetchRequestTest.createFetchRequest$default$2$1();
        FetchRequest fetchRequest11 = fetchRequest6 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions2, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap2, s2);
        Object var43_28 = null;
        fetchRequest6 = null;
        FetchRequest fetchRequest22 = fetchRequest11;
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest22);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition, ApiKeys.FETCH.latestVersion());
        scala.collection.immutable.Map x$6 = FetchRequestTest.createFetchRequest$default$2$1();
        short createFetchRequest$1_version4 = 12;
        FetchRequest fetchRequest12 = fetchRequest5 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions2, (scala.collection.immutable.Map<TopicPartition, Object>)x$6, createFetchRequest$1_version4);
        fetchRequest5 = null;
        FetchRequest fetchRequest2V12 = fetchRequest12;
        FetchResponse fetchResponse2V12 = this.sendFetchRequest(leaderId, fetchRequest2V12);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2V12, maxPartitionBytes, maxResponseBytes, messagesPerPartition, (short)12);
        Seq shuffledTopicPartitions3 = (Seq)new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        short s3 = ApiKeys.FETCH.latestVersion();
        scala.collection.immutable.Map createFetchRequest$1_offsetMap3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))}));
        FetchRequest fetchRequest13 = fetchRequest4 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions3, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap3, s3);
        Object var48_39 = null;
        fetchRequest4 = null;
        FetchRequest fetchRequest32 = fetchRequest13;
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest32);
        int n = 12;
        scala.collection.immutable.Map createFetchRequest$1_offsetMap4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))}));
        FetchRequest fetchRequest14 = fetchRequest3 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions3, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap4, (short)createFetchRequest$1_version2);
        Object var50_44 = null;
        fetchRequest3 = null;
        FetchRequest fetchRequest3V12 = fetchRequest14;
        FetchResponse fetchResponse3V12 = this.sendFetchRequest(leaderId, fetchRequest3V12);
        this.evaluateResponse3$1(fetchResponse3, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        this.evaluateResponse3$1(fetchResponse3V12, (short)12, topicNames, shuffledTopicPartitions3, maxResponseBytes, partitionWithLargeMessage1, maxPartitionBytes);
        Seq shuffledTopicPartitions4 = (Seq)new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$)).$plus$plus((IterableOnce)random.shuffle((IterableOnce)partitionsWithoutLargeMessages, BuildFrom$.MODULE$.buildFromIterableOps()));
        short s4 = ApiKeys.FETCH.latestVersion();
        scala.collection.immutable.Map createFetchRequest$1_offsetMap5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))}));
        FetchRequest fetchRequest15 = fetchRequest2 = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions4, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap5, s4);
        Object var54_50 = null;
        fetchRequest2 = null;
        FetchRequest fetchRequest42 = fetchRequest15;
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest42);
        int n2 = 12;
        scala.collection.immutable.Map createFetchRequest$1_offsetMap6 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))}));
        FetchRequest fetchRequest16 = fetchRequest = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicPartition>)shuffledTopicPartitions4, (scala.collection.immutable.Map<TopicPartition, Object>)createFetchRequest$1_offsetMap6, (short)createFetchRequest$1_version);
        Object var56_55 = null;
        fetchRequest = null;
        FetchRequest fetchRequest4V12 = fetchRequest16;
        FetchResponse fetchResponse4V12 = this.sendFetchRequest(leaderId, fetchRequest4V12);
        this.evaluateResponse4$1(fetchResponse4, ApiKeys.FETCH.latestVersion(), topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
        this.evaluateResponse4$1(fetchResponse4V12, (short)12, topicNames, shuffledTopicPartitions4, partitionWithLargeMessage2, maxResponseBytes);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestV4WithReadCommitted() {
        void var3_3;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$7 -> x$7.swap())).asJava();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)4, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData(topicNames, (short)4).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaBroker>)this.servers(), new Properties());
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$9 -> x$9.swap())).asJava();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$2(leader, x$10)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
        FetchRequest oldFetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponseData.PartitionData oldPartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, oldFetchRequest).responseData(topicNames, (short)12).get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)oldPartitionData.errorCode());
    }

    @Test
    public void testLastFetchedEpochValidation() {
        this.checkLastFetchedEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testLastFetchedEpochValidationV12() {
        this.checkLastFetchedEpochValidation((short)12);
    }

    private void checkLastFetchedEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$11 -> x$11.swap())).asJava();
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topic, Uuid.ZERO_UUID), fetchOffset, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), Optional.of(Predef$.MODULE$.int2Integer(firstLeaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData(topicNames, version).get(topicPartition);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)0L, (long)FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData));
        Assertions.assertTrue((boolean)FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData));
        FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
        Assertions.assertEquals((int)firstLeaderEpoch, (int)divergingEpoch.epoch());
        Assertions.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @Test
    public void testCurrentEpochValidation() {
        this.checkCurrentEpochValidation(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testCurrentEpochValidationV12() {
        this.checkCurrentEpochValidation((short)12);
    }

    private void checkCurrentEpochValidation(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition, topic, version);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition, topic, version);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        this.checkEpochValidationWithinFetchSession(ApiKeys.FETCH.latestVersion());
    }

    @Test
    public void testEpochValidationWithinFetchSessionV12() {
        this.checkEpochValidationWithinFetchSession((short)12);
    }

    private void checkEpochValidationWithinFetchSession(short version) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaBroker>)this.servers(), new Properties()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId, version);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId, version);
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId, short version) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$13 -> x$13.swap())).asJava();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(topicIds.getOrDefault(topicPartition.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, topicIds, version, sessionId, destinationBrokerId, topicNames);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        void var2_2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$15 -> x$15.swap())).asJava();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$5 = new StringSerializer();
        ByteArraySerializer x$6 = new ByteArraySerializer();
        int n2 = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n4 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$152 = none$4;
        boolean bl = false;
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, n2, l, l2, n3, Integer.MAX_VALUE, Integer.MAX_VALUE, batchSize, x$11, n4, x$13, (Option<File>)x$14, (Option<Properties>)x$152, x$5, x$6, bl);){
            indexedSeq = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 1000).map(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$2$adapted(producer, (TopicPartition)var2_2, bytes, arg_0));
        }
        indexedSeq.foreach((Function1 & Serializable)x$17 -> (RecordMetadata)x$17.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 15).foreach(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$4$adapted(this, version, msgValueLen, (TopicPartition)var2_2, n, batchSize, arg_0));
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)((FetchResponse)this.fetch$1(version, batchSize, false, (TopicPartition)var2_2, n, batchSize).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        })).responseData(topicNames, version).get(var2_2);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Buffer batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala().toBuffer();
        Assertions.assertEquals((int)3, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        void var9_19;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int n = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n2 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n3 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n, l, l2, 5, 60000, 30000, n2, x$11, n3, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, bl));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n4 = tuple2._2$mcI$sp();
        String topic = var9_19.topic();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$20 -> x$20.swap())).asJava();
        IndexedSeq firstBatchFutures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)));
        this.producer().flush();
        IndexedSeq secondBatchFutures = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$3(this, topic, BoxesRunTime.unboxToInt((Object)i)));
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable)x$21 -> (RecordMetadata)x$21.get());
        secondBatchFutures.foreach((Function1 & Serializable)x$22 -> (RecordMetadata)x$22.get());
        this.check$1(3L, (short)1, 3L, 22, (byte)0, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(15L, (short)1, 15L, 10, (byte)0, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(3L, (short)3, 3L, 22, (byte)1, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(15L, (short)3, 15L, 10, (byte)1, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(3L, (short)4, 0L, 2, (byte)2, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(15L, (short)4, 10L, 1, (byte)2, (TopicPartition)var9_19, n4, topicNames);
        this.check$1(10L, (short)4, 10L, 1, (byte)2, (TopicPartition)var9_19, n4, topicNames);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInErrorV12() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava();
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1, bar0})), FetchMetadata.INITIAL, (Seq)package$.MODULE$.Nil());
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() > 0 ? 1 : 0) != 0, (String)"Expected the broker to create a new incremental fetch session");
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        LinkedHashMap responseData1 = resp1.responseData(topicNames, (short)12);
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
        FetchRequest req2 = this.createFetchRequest$2((Seq)package$.MODULE$.Nil(), new FetchMetadata(resp1.sessionId(), 1), (Seq)package$.MODULE$.Nil());
        FetchResponse resp2 = this.sendFetchRequest(0, req2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId(), (String)"Expected the broker to continue the incremental fetch session");
        LinkedHashMap responseData2 = resp2.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData2.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData2.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData2.containsKey(bar0));
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)responseData2.get(bar0)).errorCode());
        this.createTopicWithAssignment("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.createTopicWithAssignment$default$3());
        FetchRequest req3 = this.createFetchRequest$2((Seq)package$.MODULE$.Nil(), new FetchMetadata(resp1.sessionId(), 2), (Seq)package$.MODULE$.Nil());
        FetchResponse resp3 = this.sendFetchRequest(0, req3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        LinkedHashMap responseData3 = resp3.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData3.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData3.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData3.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData3.get(bar0)).errorCode());
        FetchRequest req4 = this.createFetchRequest$2((Seq)package$.MODULE$.Nil(), new FetchMetadata(resp1.sessionId(), 3), (Seq)package$.MODULE$.Nil());
        FetchResponse resp4 = this.sendFetchRequest(0, req4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        LinkedHashMap responseData4 = resp4.responseData(topicNames, (short)12);
        Assertions.assertFalse((boolean)responseData4.containsKey(foo0));
        Assertions.assertFalse((boolean)responseData4.containsKey(foo1));
        Assertions.assertFalse((boolean)responseData4.containsKey(bar0));
    }

    @Test
    public void testFetchWithPartitionsWithIdError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopicWithAssignment("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})))}))), this.createTopicWithAssignment$default$3());
        scala.collection.immutable.Map topicIdsWithUnknown = (scala.collection.immutable.Map)this.getTopicIds().$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)Uuid.randomUuid())})));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = FetchRequestTest.createFetchRequest$3(FetchRequestTest.createPartitionMap$1(Integer.MAX_VALUE, (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, foo1, bar0})), Predef$.MODULE$.Map().empty(), topicIdsWithUnknown), FetchMetadata.INITIAL, (Seq)package$.MODULE$.Nil());
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        java.util.Map topicNames1 = CollectionConverters$.MODULE$.MapHasAsJava((Map)topicIdsWithUnknown.map((Function1 & Serializable)x$23 -> x$23.swap())).asJava();
        LinkedHashMap responseData1 = resp1.responseData(topicNames1, ApiKeys.FETCH.latestVersion());
        Assertions.assertTrue((boolean)responseData1.containsKey(foo0));
        Assertions.assertTrue((boolean)responseData1.containsKey(foo1));
        Assertions.assertTrue((boolean)responseData1.containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData1.get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData1.get(bar0)).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedTopic() {
        void var3_3;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$25 -> x$25.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int n2 = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        int n4 = 30000;
        int n5 = 0;
        int n6 = 16384;
        String string2 = string = "none";
        string = null;
        String x$11 = string2;
        int n7 = 20000;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$13 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$14 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$15 = none$4;
        boolean bl = false;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, n2, l, l2, n3, n4, n5, n6, x$11, n7, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$2, x$3, bl));
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)9).get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data0.errorCode());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)10).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data1.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data1).size());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(ApiKeys.FETCH.latestVersion(), ApiKeys.FETCH.latestVersion(), -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data2).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedRecords() {
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        void var3_3;
        None$ none$3;
        None$ none$4;
        SecurityProtocol securityProtocol2;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$27 -> x$27.swap())).asJava();
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$2 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int n2 = -1;
        long l = 60000L;
        long l2 = 0x100000L;
        int n3 = Integer.MAX_VALUE;
        int n4 = 30000;
        int n5 = 0;
        int n6 = 16384;
        int n7 = 20000;
        SecurityProtocol securityProtocol3 = securityProtocol2 = SecurityProtocol.PLAINTEXT;
        securityProtocol2 = null;
        SecurityProtocol x$13 = securityProtocol3;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$14 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$15 = none$6;
        boolean bl = false;
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, n2, l, l2, n3, n4, n5, n6, x$2, n7, x$13, (Option<File>)x$14, (Option<Properties>)x$15, x$3, x$4, bl);
        producer1.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = this.bootstrapServers(this.bootstrapServers$default$1());
        String x$18 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int n8 = -1;
        long l3 = 60000L;
        long l4 = 0x100000L;
        int n9 = Integer.MAX_VALUE;
        int n10 = 30000;
        int n11 = 0;
        int n12 = 16384;
        int n13 = 20000;
        SecurityProtocol securityProtocol4 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$29 = securityProtocol4;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$30 = none$7;
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$31 = none$8;
        boolean bl2 = false;
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, n8, l3, l4, n9, n10, n11, n12, x$18, n13, x$29, (Option<File>)x$30, (Option<Properties>)x$31, x$19, x$20, bl2);
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData(topicNames, (short)1).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data0.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData(topicNames, (short)1).get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data1.errorCode());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData(topicNames, (short)3).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponseData.PartitionData data3 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req3).responseData(topicNames, (short)1).get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data3.errorCode());
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data4 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req4).responseData(topicNames, (short)10).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data4.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data4).size());
        FetchRequest req5 = (FetchRequest)new FetchRequest.Builder(0, ApiKeys.FETCH.latestVersion(), -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data5 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req5).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data5.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data5).size());
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition, short responseVersion) {
        java.util.Map topicNames = CollectionConverters$.MODULE$.MapHasAsJava((Map)this.getTopicIds().map((Function1 & Serializable)x$28 -> x$28.swap())).asJava();
        LinkedHashMap responseData = fetchResponse.responseData(topicNames, responseVersion);
        Assertions.assertEquals(expectedPartitions, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$2(responseData, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (int)responseBufferSize.elem);
        Assertions.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private short checkFetchResponse$default$6() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, short version, int maxResponseBytes$1, int maxPartitionBytes$1) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$1, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap, version);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    private static final short createFetchRequest$default$3$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(FetchRequestTest $this, FetchResponseData.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)$this.records(partitionData).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final void evaluateResponse3$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions3$1, int maxResponseBytes$1, TopicPartition partitionWithLargeMessage1$1, int maxPartitionBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions3$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().values().map((Function1 & Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$3(this, partitionData)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes$1 ? 1 : 0) != 0);
        FetchResponseData.PartitionData partitionData2 = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage1$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData2.errorCode());
        Assertions.assertTrue((partitionData2.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData2).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size3 <= maxResponseBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes$1).toString());
        Assertions.assertTrue((size3 > maxPartitionBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes$1).toString());
        Assertions.assertTrue((maxPartitionBytes$1 < partitionData2.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse3$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    private final void evaluateResponse4$1(FetchResponse response, short version, java.util.Map topicNames$1, Seq shuffledTopicPartitions4$1, TopicPartition partitionWithLargeMessage2$1, int maxResponseBytes$1) {
        LinkedHashMap responseData = response.responseData(topicNames$1, version);
        Assertions.assertEquals((Object)shuffledTopicPartitions4$1, (Object)CollectionConverters$.MODULE$.SetHasAsScala(responseData.keySet()).asScala().toSeq());
        scala.collection.immutable.Seq nonEmptyPartitions = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)responseData).asScala().toSeq().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponseData.PartitionData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)x1._2();
                    if (BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponseData.PartitionData> x1) {
                FetchResponseData.PartitionData partitionData;
                boolean bl = x1 != null && BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.$outer.records(partitionData = (FetchResponseData.PartitionData)x1._2()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$4)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$4) {
                return x$4.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$4) {
                return x$4.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        });
        Assertions.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2$1, (List)Nil$.MODULE$), (Object)nonEmptyPartitions);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData.get(partitionWithLargeMessage2$1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.records(partitionData).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size4 > maxResponseBytes$1 ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes$1).toString());
        Assertions.assertTrue((maxResponseBytes$1 < partitionData.records().sizeInBytes() ? 1 : 0) != 0);
    }

    private static final short evaluateResponse4$default$2$1() {
        return ApiKeys.FETCH.latestVersion();
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$2(int leader$1, KafkaServer x$10) {
        return x$10.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1, String topic$1, short version$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds()).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$12 -> x$12.swap())).asJava();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(topicIds.getOrDefault(topic$1, Uuid.ZERO_UUID), 0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$1, (int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData(topicNames, version$1).get(topicPartition$1);
        Assertions.assertEquals((short)error.code(), (short)partitionData.errorCode());
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, java.util.Map topicIds$1, short version$2, int sessionId$1, int destinationBrokerId$1, java.util.Map topicNames$2) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(topicIds$1.getOrDefault(topicPartition$2.topic(), Uuid.ZERO_UUID), 0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)version$2, (int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData(topicNames$2, version$2).get(topicPartition$2);
        Assertions.assertEquals((short)expectedError.code(), (short)partitionData.errorCode());
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)version, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assertions.assertTrue((size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0, (String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString());
                some = None$.MODULE$;
            } else {
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl())));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$2, int i) {
        return $this.producer().send(new ProducerRecord(topic$2, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$3(FetchRequestTest $this, String topic$2, int i) {
        return $this.producer().send(new ProducerRecord(topic$2, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3, java.util.Map topicNames$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)requestVersion, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$4), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(leaderId$3, fetchRequest).responseData(topicNames$3, requestVersion).get(topicPartition$4);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
            Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
            batches = CollectionConverters$.MODULE$.IterableHasAsScala(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala().toBuffer();
            RecordBatch batch = (RecordBatch)batches.head();
            Assertions.assertEquals((byte)expectedMagic, (byte)batch.magic());
            Assertions.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assertions.assertEquals((int)expectedNumBatches, (int)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)12, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final FetchRequest createFetchRequest$3(LinkedHashMap fetchData, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, (java.util.Map)fetchData).removed(CollectionConverters$.MODULE$.SeqHasAsJava(toForget).asJava()).metadata(metadata).build();
    }

    private static final LinkedHashMap createPartitionMap$1(int maxPartitionBytes, Seq topicPartitions, scala.collection.immutable.Map offsetMap, scala.collection.immutable.Map topicIdsWithUnknown$1) {
        LinkedHashMap partitionMap = new LinkedHashMap();
        topicPartitions.foreach((Function1 & Serializable)tp -> partitionMap.put(tp, new FetchRequest.PartitionData((Uuid)topicIdsWithUnknown$1.getOrElse((Object)tp.topic(), (Function0 & Serializable)() -> Uuid.ZERO_UUID), BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$2(LinkedHashMap responseData$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$3, TopicPartition tp) {
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)responseData$1.get(tp);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Records records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData);
        responseBufferSize$1.elem += records.sizeInBytes();
        Buffer batches = CollectionConverters$.MODULE$.IterableHasAsScala(records.batches()).asScala().toBuffer();
        Assertions.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)batches.map((Function1 & Serializable)x$29 -> BoxesRunTime.boxToInteger((int)x$29.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertEquals((int)0, (int)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertTrue((batchesSize <= maxPartitionBytes$3 ? 1 : 0) != 0);
            Assertions.assertEquals((int)maxPartitionBytes$3, (int)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString());
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString());
        }
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionWithConnectionFailure$2$adapted(KafkaProducer producer$1, TopicPartition topicPartition$3, byte[] bytes$1, Object x$16) {
        return producer$1.send(new ProducerRecord(topicPartition$3.topic(), Predef$.MODULE$.int2Integer(topicPartition$3.partition()), (Object)"key", (Object)bytes$1));
    }

    public static final /* synthetic */ Option $anonfun$testDownConversionWithConnectionFailure$4$adapted(FetchRequestTest $this, short version$3, int msgValueLen$1, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1, Object x$18) {
        return $this.fetch$1(version$3, msgValueLen$1 * 1000, true, topicPartition$3, leaderId$2, batchSize$1);
    }
}

