/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.Fetching$;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t]f\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013%q\t\u0003\u0004T\u0001\u0001\u0006I\u0001\u0013\u0005\b)\u0002\u0011\r\u0011\"\u0003H\u0011\u0019)\u0006\u0001)A\u0005\u0011\"9a\u000b\u0001b\u0001\n\u00139\u0005BB,\u0001A\u0003%\u0001\nC\u0004Y\u0001\t\u0007I\u0011B-\t\ru\u0003\u0001\u0015!\u0003[\u0011\u001dq\u0006A1A\u0005\neCaa\u0018\u0001!\u0002\u0013Q\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007a\u0002\u0001\u000b\u0011\u00022\t\u000fE\u0004!\u0019!C\u0005e\"1\u0011\u0010\u0001Q\u0001\nMDqA\u001f\u0001C\u0002\u0013%1\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"!\n\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003SA\u0001\"a\u000e\u0001A\u0003%\u00111\u0006\u0005\n\u0003s\u0001!\u0019!C\u0005\u0003wA\u0001\"!\u0013\u0001A\u0003%\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011%\t\u0019\bAI\u0001\n\u0013\t)\bC\u0004\u0002\f\u0002!\t!!$\t\u000f\u0005-\u0006\u0001\"\u0001\u0002\u000e\"9\u0011Q\u0017\u0001\u0005\u0002\u00055\u0005bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u00033\u0004A\u0011AAG\u0011\u001d\ti\u000e\u0001C\u0001\u0003\u001bCq!!9\u0001\t\u0003\ti\tC\u0004\u0002f\u0002!I!a:\t\u0013\u0005m\b!%A\u0005\n\u0005U\u0004bBA\u007f\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0005\u0003\u0001A\u0011AAG\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u001bCqA!\u0003\u0001\t\u0003\ti\tC\u0004\u0003\u000e\u0001!\t!!$\t\u000f\tE\u0001\u0001\"\u0001\u0002\u000e\"9!Q\u0003\u0001\u0005\u0002\u00055\u0005b\u0002B\r\u0001\u0011\u0005\u0011Q\u0012\u0005\b\u0005;\u0001A\u0011AAG\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003\u001bCqA!\n\u0001\t\u0003\ti\tC\u0004\u0003*\u0001!\t!!$\t\u000f\t5\u0002\u0001\"\u0001\u0002\u000e\"9!\u0011\u0007\u0001\u0005\n\tM\u0002b\u0002B\u0019\u0001\u0011%!q\r\u0005\b\u0005\u007f\u0002A\u0011\u0002BA\u0011\u001d\u00119\t\u0001C\u0001\u0005\u0013CqA!,\u0001\t\u0013\u0011yK\u0001\rSKBd\u0017nY1GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a+fgRT!a\u000e\u001d\u0002\rM,'O^3s\u0015\u0005I\u0014!B6bM.\f7\u0001A\n\u0003\u0001q\u0002\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001E!\t)\u0005!D\u00017\u0003\u0011!\u0018\u0007\u001d\u0019\u0016\u0003!\u0003\"!S)\u000e\u0003)S!a\u0013'\u0002\r\r|W.\\8o\u0015\tITJ\u0003\u0002O\u001f\u00061\u0011\r]1dQ\u0016T\u0011\u0001U\u0001\u0004_J<\u0017B\u0001*K\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ\u0001^\u0019qa\u0001\nA\u0001^\u0019qc\u0005)A/\r92A\u0005!AO\r92\u0003\u0015!(\u0007]\u0019!\u0003!!x\u000e]5d\u0013\u0012\fT#\u0001.\u0011\u0005%[\u0016B\u0001/K\u0005\u0011)V/\u001b3\u0002\u0013Q|\u0007/[2JIF\u0002\u0013\u0001\u0003;pa&\u001c\u0017\n\u001a\u001a\u0002\u0013Q|\u0007/[2JIJ\u0002\u0013\u0001\u0003;pa&\u001c\u0017\nZ:\u0016\u0003\t\u0004Ba\u00194i56\tAM\u0003\u0002f}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u001d$'aA'baB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\u0005Y\u0006twMC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=T'AB*ue&tw-A\u0005u_BL7-\u00133tA\u0005q!M]8lKJ,e\u000e\u001a)pS:$X#A:\u0011\u0005Q<X\"A;\u000b\u0005YD\u0014aB2mkN$XM]\u0005\u0003qV\u0014aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\bce>\\WM]#oIB{\u0017N\u001c;!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/F\u0001}!\t)U0\u0003\u0002\u007fm\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00049beRLG/[8o'R\fG/Z:\u0016\u0005\u0005\u0015\u0001CBA\u0004\u0003\u001b\t\t\"\u0004\u0002\u0002\n)\u0019\u00111\u00027\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001f\tIA\u0001\u0003MSN$\b\u0003BA\n\u0003?qA!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033Q\u0015aB7fgN\fw-Z\u0005\u0005\u0003;\t9\"A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f\u0017\u0002BA\u0011\u0003G\u0011A$\u00169eCR,W*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0002\u001e\u0005]\u0011\u0001\u00059beRLG/[8o'R\fG/Z:!\u0003U)\b\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR,\"!a\u000b\u0011\t\u00055\u00121G\u0007\u0003\u0003_Q1!!\rK\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001b\u0003_\u0011Q#\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH/\u0001\fva\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;!\u00035iW\r^1eCR\f7)Y2iKV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)\u0019\u00111\t\u001c\u0002\u00115,G/\u00193bi\u0006LA!a\u0012\u0002B\ty!l['fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002#%t\u0017\u000e^5bY\u001a+Go\u00195Ti\u0006$X\r\u0006\u0005\u0002P\u0005U\u0013qLA5!\r)\u0015\u0011K\u0005\u0004\u0003'2$!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\"9\u0011q\u000b\rA\u0002\u0005e\u0013a\u0002;pa&\u001c\u0017\n\u001a\t\u0005{\u0005m#,C\u0002\u0002^y\u0012aa\u00149uS>t\u0007bBA11\u0001\u0007\u00111M\u0001\fM\u0016$8\r[(gMN,G\u000fE\u0002>\u0003KJ1!a\u001a?\u0005\u0011auN\\4\t\u0013\u0005-\u0004\u0004%AA\u0002\u00055\u0014a\u00037fC\u0012,'/\u00129pG\"\u00042!PA8\u0013\r\t\tH\u0010\u0002\u0004\u0013:$\u0018aG5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002x)\"\u0011QNA=W\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0013Ut7\r[3dW\u0016$'bAAC}\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0015q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aB2mK\u0006tW\u000f\u001d\u000b\u0003\u0003\u001f\u00032!PAI\u0013\r\t\u0019J\u0010\u0002\u0005+:LG\u000fK\u0002\u001b\u0003/\u0003B!!'\u0002(6\u0011\u00111\u0014\u0006\u0005\u0003;\u000by*A\u0002ba&TA!!)\u0002$\u00069!.\u001e9ji\u0016\u0014(bAAS\u001f\u0006)!.\u001e8ji&!\u0011\u0011VAN\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0015tQ>,H\u000eZ*f]\u0012d\u0015\r^3tiJ+\u0017/^3tiZ+'o]5p]N\u0014\u0015\u0010R3gCVdG\u000fK\u0002\u001c\u0003_\u0003B!!'\u00022&!\u00111WAN\u0005\u0011!Vm\u001d;\u0002}Q,7\u000f\u001e$fi\u000eDG*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u\u0013\u001ad\u0015m\u001d;Fa>\u001c\u0007\u000eR3gS:,GMR8s'>lW\rU1si&$\u0018n\u001c8tQ\ra\u0012qV\u0001\u0016CN\u001cXM\u001d;QCJ$\u0018\u000e^5p]N#\u0018\r^3t))\ty)!0\u0002H\u0006E\u0017Q\u001b\u0005\b\u0003\u007fk\u0002\u0019AAa\u0003\u001d1W\r^2iKJ\u00042!RAb\u0013\r\t)M\u000e\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011\u001d\tI-\ba\u0001\u0003\u0017\fQc\u001d5pk2$')\u001a*fC\u0012Lhi\u001c:GKR\u001c\u0007\u000eE\u0002>\u0003\u001bL1!a4?\u0005\u001d\u0011un\u001c7fC:Dq!a5\u001e\u0001\u0004\tY-A\u000btQ>,H\u000e\u001a\"f)J,hnY1uS:<Gj\\4\t\u000f\u0005]W\u00041\u0001\u0002L\u0006y1\u000f[8vY\u0012\u0014U\rR3mCf,G-A\u0013tQ>,H\u000e\u001a%b]\u0012dW-\u0012=dKB$\u0018n\u001c8Ge>l'\t\\8dW&twmU3oI\"\u001aa$a,\u0002\u0007NDw.\u001e7e\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"|eNR5sgR4U\r^2i\u001f:d\u00170\u00134MK\u0006$WM]#q_\u000eD7J\\8x]R{'i\u001c;i\u0013\n\u0004(G\u000e\u0015\u0004?\u0005=\u0016\u0001O:i_VdGMT8u\r\u0016$8\r\u001b'fC\u0012,'/\u00129pG\"|eNR5sgR4U\r^2i/&$\b\u000e\u0016:v]\u000e\fG/Z(o\r\u0016$8\r\u001b\u0015\u0004A\u0005=\u0016A\t<fe&4\u0017PR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007\u000e\u0006\u0004\u0002\u0010\u0006%\u0018q\u001f\u0005\b\u0003W\f\u0003\u0019AAw\u0003\rI'\r\u001d\t\u0005\u0003_\f\u00190\u0004\u0002\u0002r*\u0019\u0011Q\u0014\u001d\n\t\u0005U\u0018\u0011\u001f\u0002\u000b\u0003BLg+\u001a:tS>t\u0007\"CA}CA\u0005\t\u0019AA7\u0003=)\u0007o\\2i\r\u0016$8\r[\"pk:$\u0018\u0001\f<fe&4\u0017PR3uG\"dU-\u00193fe\u0016\u0003xn\u00195P]\u001aK'o\u001d;GKR\u001c\u0007\u000e\n3fM\u0006,H\u000e\u001e\u00133\u0003Q\u001a\bn\\;mIR\u0013XO\\2bi\u0016$vn\u00144gg\u0016$8\u000b]3dS\u001aLW\rZ%o\u000bB|7\r[(gMN,GOU3ta>t7/\u001a\u0015\u0004G\u0005=\u0016!T:i_VdG\r\u0016:v]\u000e\fG/\u001a+p\u001f\u001a47/\u001a;Ta\u0016\u001c\u0017NZ5fI&sW\t]8dQ>3gm]3u%\u0016\u001c\bo\u001c8tK&3gi\u001c7m_^,'\u000fS1t\u001d>luN]3Fa>\u001c\u0007n\u001d\u0015\u0004I\u0005=\u0016AS:i_VdGMR3uG\"dU-\u00193fe\u0016\u0003xn\u00195TK\u000e|g\u000e\u001a+j[\u0016Le\rT3bI\u0016\u0014(+\u001a9mS\u0016\u001cx+\u001b;i\u000bB|7\r\u001b(pi.swn\u001e8U_\u001a{G\u000e\\8xKJD3!JAX\u0003\u0005\u001b\bn\\;mIR\u0013XO\\2bi\u0016Le\rT3bI\u0016\u0014(+\u001a9mS\u0016\u001cx+\u001b;i\t&4XM]4j]\u001e,\u0005o\\2i\u001d>$8J\\8x]R{gi\u001c7m_^,'\u000fK\u0002'\u0003_\u000b1g\u001d5pk2$Wk]3MK\u0006$WM]#oI>3gm]3u\u0013\u001aLe\u000e^3s\u0005J|7.\u001a:WKJ\u001c\u0018n\u001c8CK2|wO\r\u0019)\u0007\u001d\ny+\u0001!tQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_&s\u0017\u000e^5bY\u001a+Go\u00195PM\u001a\u001cX\r^%g\u0019\u0016\fG-\u001a:SKR,(O\\:V]\u0012,g-\u001b8fI>3gm]3uQ\rA\u0013qV\u00012g\"|W\u000f\u001c3Q_2d\u0017J\u001c3fM&t\u0017\u000e^3ms&3G*Z1eKJ\u0014V\r^;s]N\fe._#yG\u0016\u0004H/[8oQ\rI\u0013qV\u0001,g\"|W\u000f\u001c3N_Z,\u0007+\u0019:uSRLwN\\:PkR|e\r\u0016:v]\u000e\fG/\u001b8h\u0019><7\u000b^1uK\"\u001a!&a,\u0002qMDw.\u001e7e\r&dG/\u001a:QCJ$\u0018\u000e^5p]Nl\u0015\rZ3MK\u0006$WM\u001d#ve&tw\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\"\u001a1&a,\u0002\u0011NDw.\u001e7e\u0007\u0006$8\r[#yG\u0016\u0004H/[8o\rJ|WN\u00117pG.LgnZ*f]\u0012<\u0006.\u001a8TQV$H/\u001b8h\t><hNU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$\u0007f\u0001\u0017\u00020\u000613\u000f[8vY\u0012,\u0006\u000fZ1uKJ+\u0017m]:jO:lWM\u001c;CsR,7/\u00138NKR\u0014\u0018nY:)\u00075\ny+\u0001$tQ>,H\u000e\u001a(piV\u0003H-\u0019;f%\u0016\f7o]5h]6,g\u000e\u001e\"zi\u0016\u001c\u0018J\\'fiJL7m],iK:tuNU3bgNLwM\\7f]R\u001c\u0018J\u001c)s_\u001e\u0014Xm]:)\u00079\ny+\u0001\buKN$()^5mI\u001a+Go\u00195)\u0007=\ny+A\u0011oK^|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014\b+\u0019:uSRLwN\u001c*fgVdG\u000f\u0006\u0005\u00036\tu#\u0011\rB2!\u0011\u00119Da\u0016\u000f\t\te\"1\u000b\b\u0005\u0005w\u0011\tF\u0004\u0003\u0003>\t=c\u0002\u0002B \u0005\u001brAA!\u0011\u0003L9!!1\tB%\u001b\t\u0011)EC\u0002\u0003Hi\na\u0001\u0010:p_Rt\u0014\"\u0001)\n\u00059{\u0015BA\u001dN\u0013\tYE*C\u0002\u0002\u001a)KAA!\u0016\u0002\u0018\u0005\u0001sJ\u001a4tKR4uN\u001d'fC\u0012,'/\u00129pG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0011IFa\u0017\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi*!!QKA\f\u0011\u0019\u0011y\u0006\ra\u0001\u0011\u0006\u0011A\u000f\u001d\u0005\b\u0003W\u0002\u0004\u0019AA7\u0011\u001d\u0011)\u0007\ra\u0001\u0003G\n\u0011\"\u001a8e\u001f\u001a47/\u001a;\u0015\u0015\tU\"\u0011\u000eB6\u0005w\u0012i\b\u0003\u0004\u0003`E\u0002\r\u0001\u0013\u0005\b\u0005[\n\u0004\u0019\u0001B8\u0003\u0015)'O]8s!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;\u0015\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0003z\tM$AB#se>\u00148\u000fC\u0004\u0002lE\u0002\r!!\u001c\t\u000f\t\u0015\u0014\u00071\u0001\u0002d\u0005q\u0012m]:feR\u0004&o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uC^CWM\u001c\u000b\u0005\u0003\u001f\u0013\u0019\tC\u0004\u0003\u0006J\u0002\r!a3\u0002\u001b%\u001c(+Z1tg&<g.\u001b8h\u0003\u0011\u0019H/\u001e2\u0015\u0011\u0005=%1\u0012BK\u0005?CqA!$4\u0001\u0004\u0011y)A\u0005qCJ$\u0018\u000e^5p]B\u0019AO!%\n\u0007\tMUOA\u0005QCJ$\u0018\u000e^5p]\"9!qS\u001aA\u0002\te\u0015A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0004\u000b\nm\u0015b\u0001BOm\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bb\u0002BQg\u0001\u0007!1U\u0001\u0004Y><\u0007\u0003\u0002BS\u0005Sk!Aa*\u000b\u0007\t\u0005\u0006(\u0003\u0003\u0003,\n\u001d&AC+oS\u001aLW\r\u001a'pO\u0006a2.\u00194lC\u000e{gNZ5h\u001d>$&/\u001e8dCR,wJ\u001c$fi\u000eDWC\u0001BY!\r)%1W\u0005\u0004\u0005k3$aC&bM.\f7i\u001c8gS\u001e\u0004")
public class ReplicaFetcherThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final TopicPartition t2p1 = new TopicPartition("topic2", 1);
    private final Uuid topicId1 = Uuid.randomUuid();
    private final Uuid topicId2 = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)this.topicId1()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)this.topicId2())}));
    private final BrokerEndPoint kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint = new BrokerEndPoint(0, "localhost", 1000);
    private final FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions = new FailedPartitions();
    private final java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic1").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0), new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName("topic2").setPartitionIndex(0).setControllerEpoch(0).setLeader(0).setLeaderEpoch(0)}))).asJava();
    private final UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 0, 0, 0L, this.partitionStates(), Collections.emptyList(), CollectionConverters$.MODULE$.MapHasAsJava(this.topicIds()).asJava()).build();
    private final ZkMetadataCache metadataCache = new ZkMetadataCache(0);

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private TopicPartition t2p1() {
        return this.t2p1;
    }

    private Uuid topicId1() {
        return this.topicId1;
    }

    private Uuid topicId2() {
        return this.topicId2;
    }

    private Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public BrokerEndPoint kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint() {
        return this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint;
    }

    public FailedPartitions kafka$server$ReplicaFetcherThreadTest$$failedPartitions() {
        return this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions;
    }

    private java.util.List<UpdateMetadataRequestData.UpdateMetadataPartitionState> partitionStates() {
        return this.partitionStates;
    }

    private UpdateMetadataRequest updateMetadataRequest() {
        return this.updateMetadataRequest;
    }

    private ZkMetadataCache metadataCache() {
        return this.metadataCache;
    }

    private InitialFetchState initialFetchState(Option<Uuid> topicId, long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$2 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(topicId, x$2, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$3() {
        return 1;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    @Test
    public void shouldSendLatestRequestVersionsByDefault() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((short)ApiKeys.FETCH.latestVersion(), (short)thread.fetchRequestVersion());
        Assertions.assertEquals((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (short)thread.offsetForLeaderEpochRequestVersion());
        Assertions.assertEquals((short)ApiKeys.LIST_OFFSETS.latestVersion(), (short)thread.listOffsetRequestVersion());
    }

    @Test
    public void testFetchLeaderEpochRequestIfLastEpochDefinedForSomePartitions() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        this.assertPartitionStates((AbstractFetcherThread)thread, false, true, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        this.assertPartitionStates((AbstractFetcherThread)thread, true, false, false);
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)3))).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
    }

    public void assertPartitionStates(AbstractFetcherThread fetcher, boolean shouldBeReadyForFetch, boolean shouldBeTruncatingLog, boolean shouldBeDelayed) {
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1(), this.t2p1()}))).foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$assertPartitionStates$1(fetcher, shouldBeReadyForFetch, shouldBeTruncatingLog, shouldBeDelayed, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldHandleExceptionFromBlockingSend() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        Mockito.when((Object)mockBlockingSend.sendRequest((AbstractRequest.Builder)ArgumentMatchers.any())).thenThrow(new Throwable[]{new NullPointerException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Map result = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend)).fetchEpochEndOffsets((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))), (Object)result, (String)"results from leader epoch request should have undefined offset");
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any());
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnlyIfLeaderEpochKnownToBothIbp26() {
        this.verifyFetchLeaderEpochOnFirstFetch((ApiVersion)KAFKA_2_6_IV0$.MODULE$, 1);
    }

    @Test
    public void shouldNotFetchLeaderEpochOnFirstFetchWithTruncateOnFetch() {
        this.verifyFetchLeaderEpochOnFirstFetch(ApiVersion$.MODULE$.latestVersion(), 0);
    }

    private void verifyFetchLeaderEpochOnFirstFetch(ApiVersion ibp, int epochFetchCount) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ibp.version());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        thread.doWork();
        Assertions.assertEquals((int)epochFetchCount, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
    }

    private int verifyFetchLeaderEpochOnFirstFetch$default$2() {
        return 1;
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponse() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 1L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpoch, 172L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)172)), (String)new StringBuilder(58).append("Expected ").append(this.t2p1()).append(" to truncate to offset 172 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToOffsetSpecifiedInEpochOffsetResponseIfFollowerHasNoMoreEpochs() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpochAtFollower = 5;
        int leaderEpochAtLeader = 4;
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 3L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpochAtFollower)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpochAtLeader)).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpochAtLeader, 156L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t2p1(), leaderEpochAtLeader, 202L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId2()), 0L, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)156)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 156 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)initialLEO)), (String)new StringBuilder(55).append("Expected ").append(this.t2p1()).append(" to truncate to offset ").append(initialLEO).append(" (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldFetchLeaderEpochSecondTimeIfLeaderRepliesWithEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 4, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 4, 143L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.fetchCount());
        java.util.Map nextOffsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 3, 101L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 3, 102L))}))).asJava();
        mockNetwork.setOffsetsForNextResponse(nextOffsets);
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertTrue((mockNetwork.lastUsedOffsetForLeaderEpochVersion() >= 3 ? 1 : 0) != 0, (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)2, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)102)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 102 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)101)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 101 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        ObjectRef latestLogEpoch = ObjectRef.create((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)115L));
        Mockito.when((Object)log.latestEpoch()).thenAnswer(x$1 -> (Option)latestLogEpoch$1.elem);
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(149L, 4)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(129L, 2)));
        Mockito.when((Object)log.endOffsetForEpoch(2)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(119L, 1)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(Collections.emptyMap(), this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread(this, config, replicaManager, quota, mockNetwork){

            public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
                return None$.MODULE$;
            }
        };
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialLEO, 1))})));
        scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.t1p0(), this.t1p1()}));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$2(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(140L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(4).setEndOffset(141L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = new Some((Object)BoxesRunTime.boxToInteger((int)4));
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)140)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 140 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)141)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 141 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$3(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(130L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(131L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)3, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)4))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)129)), (String)new StringBuilder(57).append("Expected to truncate to offset 129 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(thread, tp);
            return BoxedUnit.UNIT;
        });
        mockNetwork.setFetchPartitionDataForNextResponse((Map<TopicPartition, FetchResponseData.PartitionData>)((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p0().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(120L))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)ReplicaFetcherThreadTest.partitionData$1(this.t1p1().partition(), new FetchResponseData.EpochEndOffset().setEpoch(2).setEndOffset(121L)))}))));
        mockNetwork.setIdsForNextResponse(this.topicIds());
        latestLogEpoch.elem = None$.MODULE$;
        thread.doWork();
        Assertions.assertEquals((int)0, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)4, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)6))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)119)), (String)new StringBuilder(57).append("Expected to truncate to offset 119 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        partitions.foreach((Function1 & Serializable)tp -> {
            ReplicaFetcherThreadTest.$anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(thread, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void shouldUseLeaderEndOffsetIfInterBrokerVersionBelow20() {
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "0.11.0");
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialLEO = 200;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(4)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)log.endOffsetForEpoch(3)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(120L, 3)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsets = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, 155L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), -1, 143L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsets, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)1, (int)mockNetwork.fetchCount());
        Assertions.assertEquals((int)0, (int)mockNetwork.lastUsedOffsetForLeaderEpochVersion(), (String)"OffsetsForLeaderEpochRequest version.");
        thread.doWork();
        Assertions.assertEquals((int)1, (int)mockNetwork.epochFetchCount());
        Assertions.assertEquals((int)2, (int)mockNetwork.fetchCount());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)155)), (String)new StringBuilder(58).append("Expected ").append(this.t1p0()).append(" to truncate to offset 155 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.ListHasAsScala(truncateToCapture.getAllValues()).asScala().contains((Object)BoxesRunTime.boxToInteger((int)143)), (String)new StringBuilder(58).append("Expected ").append(this.t1p1()).append(" to truncate to offset 143 (truncation offsets: ").append(truncateToCapture.getAllValues()).append(")").toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfLeaderReturnsUndefinedOffset() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int initialFetchOffset = 100;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialFetchOffset)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), -1, -1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), initialFetchOffset, 1))})));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldPollIndefinitelyIfLeaderReturnsAnyException() {
        ArgumentCaptor truncated = ArgumentCaptor.forClass(Long.TYPE);
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 5;
        int highWaterMark = 100;
        int initialLeo = 300;
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(highWaterMark)));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLeo, leaderEpoch)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLeo)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), Errors.NOT_LEADER_OR_FOLLOWER, -1, -1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), Errors.UNKNOWN_SERVER_ERROR, -1, -1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$2 -> thread.doWork());
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.never())).truncateTo(ArgumentMatchers.anyLong(), ArgumentMatchers.anyBoolean());
        offsetsReply.put(this.t1p0(), this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 156L));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncated.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)156L, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldMovePartitionsOutOfTruncatingLogState() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        int leaderEpoch = 4;
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        Mockito.when((Object)log.endOffsetForEpoch(leaderEpoch)).thenReturn((Object)new Some((Object)new OffsetAndEpoch(0L, leaderEpoch)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), leaderEpoch, 1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), leaderEpoch, 1L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$3 -> x$3.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Truncating$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$4 -> x$4.state()));
        thread.doWork();
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable)x$5 -> x$5.state()));
        Assertions.assertEquals((Object)Option$.MODULE$.apply((Object)Fetching$.MODULE$), (Object)thread.fetchState(this.t1p1()).map((Function1 & Serializable)x$6 -> x$6.state()));
        ((Partition)Mockito.verify((Object)partition, (VerificationMode)Mockito.times((int)2))).truncateTo(0L, false);
    }

    @Test
    public void shouldFilterPartitionsMadeLeaderDuringLeaderEpochRequest() {
        KafkaConfig config = this.kafkaConfigNoTruncateOnFetch();
        ArgumentCaptor truncateToCapture = ArgumentCaptor.forClass(Long.TYPE);
        int initialLEO = 100;
        ReplicationQuotaManager quota = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ReplicaAlterLogDirsManager replicaAlterLogDirsManager = (ReplicaAlterLogDirsManager)Mockito.mock(ReplicaAlterLogDirsManager.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)((long)initialLEO - 2L)));
        Mockito.when((Object)log.latestEpoch()).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)));
        Mockito.when((Object)log.endOffsetForEpoch(5)).thenReturn((Object)new Some((Object)new OffsetAndEpoch((long)initialLEO, 5)));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(initialLEO)));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)this.metadataCache());
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.logManager()).thenReturn((Object)logManager);
        Mockito.when((Object)replicaManager.replicaAlterLogDirsManager()).thenReturn((Object)replicaAlterLogDirsManager);
        this.stub(partition, replicaManager, log);
        java.util.Map offsetsReply = CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p0(), 5, 52L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.newOffsetForLeaderPartitionResult(this.t1p1(), 5, 49L))}))).asJava();
        ReplicaFetcherMockBlockingSend mockNetwork = new ReplicaFetcherMockBlockingSend(offsetsReply, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), (Time)new SystemTime());
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), (ReplicaQuota)quota, (Option)new Some((Object)mockNetwork));
        thread.addPartitions((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState((Option<Uuid>)new Some((Object)this.topicId1()), 0L, 1))})));
        TopicPartition partitionThatBecameLeader = this.t1p0();
        mockNetwork.setEpochRequestCallback((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> thread.removePartitions((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partitionThatBecameLeader}))));
        thread.doWork();
        ((Partition)Mockito.verify((Object)partition)).truncateTo(BoxesRunTime.unboxToLong((Object)truncateToCapture.capture()), ArgumentMatchers.anyBoolean());
        Assertions.assertEquals((long)49L, (long)BoxesRunTime.unboxToLong((Object)truncateToCapture.getValue()));
    }

    @Test
    public void shouldCatchExceptionFromBlockingSendWhenShuttingDownReplicaFetcherThread() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        mockBlockingSend.initiateClose();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalArgumentException()});
        mockBlockingSend.close();
        Mockito.when((Object)BoxedUnit.UNIT).thenThrow(new Throwable[]{new IllegalStateException()});
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), null, (Option)new Some((Object)mockBlockingSend));
        thread.start();
        thread.initiateShutdown();
        thread.awaitShutdown();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).initiateClose();
        ((BlockingSend)Mockito.verify((Object)mockBlockingSend)).close();
    }

    @Test
    public void shouldUpdateReassignmentBytesInMetrics() {
        this.assertProcessPartitionDataWhen(true);
    }

    @Test
    public void shouldNotUpdateReassignmentBytesInMetricsWhenNoReassignmentsInProgress() {
        this.assertProcessPartitionDataWhen(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBuildFetch() {
        void var22_22;
        void var14_14;
        TopicIdPartition tid1p0 = new TopicIdPartition(this.topicId1(), this.t1p0());
        TopicIdPartition tid1p1 = new TopicIdPartition(this.topicId1(), this.t1p1());
        TopicIdPartition tid2p1 = new TopicIdPartition(this.topicId2(), this.t2p1());
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn(Mockito.mock(BrokerTopicStats.class));
        Mockito.when((Object)replicaManager.localLogOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaQuota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), replicaQuota, (Option)new Some((Object)mockBlockingSend));
        int leaderEpoch = 1;
        Map partitionMap = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId2()), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch(partitionMap);
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Assertions.assertTrue((boolean)var14_14.isDefined());
        FetchRequest.Builder fetchRequestBuilder = ((AbstractFetcherThread.ReplicaFetch)var14_14.get()).fetchRequest();
        Map partitionDataMap = (Map)partitionMap.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState state = (PartitionFetchState)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            return tuple2;
        });
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap).asJava(), (Object)fetchRequestBuilder.fetchData());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.replaced().size());
        Assertions.assertEquals((int)0, (int)fetchRequestBuilder.removed().size());
        LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> responseData = new LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData>();
        responseData.put(tid1p0, new FetchResponseData.PartitionData());
        responseData.put(tid1p1, new FetchResponseData.PartitionData());
        responseData.put(tid2p1, new FetchResponseData.PartitionData());
        FetchResponse fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)123, responseData);
        thread.fetchSessionHandler().handleResponse(fetchResponse, ApiKeys.FETCH.latestVersion());
        Uuid newTopicId = Uuid.randomUuid();
        Map partitionMap2 = (Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState((Option)new Some((Object)this.topicId1()), 155L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t2p1()), (Object)new PartitionFetchState((Option)new Some((Object)newTopicId), 160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))}));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetch(partitionMap2);
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt2 = (Option)resultWithPartitions2.result();
        Map partitionDataMap2 = (Map)((MapOps)partitionMap2.drop(1)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            PartitionFetchState state = (PartitionFetchState)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)tp, (Object)new FetchRequest.PartitionData((Uuid)state.topicId().get(), state.fetchOffset(), 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(state.currentLeaderEpoch())), Optional.empty()));
            return tuple2;
        });
        Assertions.assertTrue((boolean)var22_22.isDefined());
        FetchRequest.Builder fetchRequestBuilder2 = ((AbstractFetcherThread.ReplicaFetch)var22_22.get()).fetchRequest();
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.MapHasAsJava(partitionDataMap2).asJava(), (Object)fetchRequestBuilder2.fetchData());
        Assertions.assertEquals(Collections.singletonList(tid2p1), (Object)fetchRequestBuilder2.replaced());
        Assertions.assertEquals(Collections.singletonList(tid1p0), (Object)fetchRequestBuilder2.removed());
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, int leaderEpoch, long endOffset) {
        return this.newOffsetForLeaderPartitionResult(tp, Errors.NONE, leaderEpoch, endOffset);
    }

    private OffsetForLeaderEpochResponseData.EpochEndOffset newOffsetForLeaderPartitionResult(TopicPartition tp, Errors error, int leaderEpoch, long endOffset) {
        return new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()).setLeaderEpoch(leaderEpoch).setEndOffset(endOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void assertProcessPartitionDataWhen(boolean isReassigning) {
        MemoryRecords memoryRecords;
        MemoryRecords memoryRecords2;
        void withRecords_records;
        void withRecords_timestampType;
        MemoryRecords memoryRecords3;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        BlockingSend mockBlockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isReassigning())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isAddingLocalReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)isReassigning));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Mockito.when((Object)replicaManager.brokerTopicStats()).thenReturn((Object)brokerTopicStats);
        ReplicaQuota replicaQuota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        ReplicaFetcherThread thread = new ReplicaFetcherThread("bob", 0, this.kafka$server$ReplicaFetcherThreadTest$$brokerEndPoint(), config, this.kafka$server$ReplicaFetcherThreadTest$$failedPartitions(), replicaManager, new Metrics(), (Time)new SystemTime(), replicaQuota, (Option)new Some((Object)mockBlockingSend));
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(1000L, "foo".getBytes(StandardCharsets.UTF_8))};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords4 = memoryRecords3 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        timestampType = null;
        memoryRecords3 = null;
        MemoryRecords memoryRecords5 = memoryRecords2 = memoryRecords4;
        memoryRecords2 = null;
        MemoryRecords memoryRecords6 = memoryRecords = memoryRecords5;
        Object var13_12 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords6;
        FetchResponseData.PartitionData partitionData = new FetchResponseData.PartitionData().setPartitionIndex(this.t1p0().partition()).setLastStableOffset(0L).setLogStartOffset(0L).setRecords((BaseRecords)records);
        thread.processPartitionData(this.t1p0(), 0L, partitionData);
        if (isReassigning) {
            Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        } else {
            Assertions.assertEquals((long)0L, (long)((Meter)brokerTopicStats.allTopicsStats().reassignmentBytesInPerSec().get()).count());
        }
        Assertions.assertEquals((long)records.sizeInBytes(), (long)((Meter)brokerTopicStats.allTopicsStats().replicationBytesInRate().get()).count());
    }

    public void stub(Partition partition, ReplicaManager replicaManager, UnifiedLog log) {
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p0())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t1p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p1())).thenReturn((Object)partition);
        Mockito.when((Object)replicaManager.localLogOrException(this.t2p1())).thenReturn((Object)log);
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t2p1())).thenReturn((Object)partition);
    }

    private KafkaConfig kafkaConfigNoTruncateOnFetch() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), KAFKA_2_6_IV0$.MODULE$.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    public static final /* synthetic */ void $anonfun$assertPartitionStates$1(AbstractFetcherThread fetcher$1, boolean shouldBeReadyForFetch$1, boolean shouldBeTruncatingLog$1, boolean shouldBeDelayed$1, TopicPartition tp) {
        Assertions.assertTrue((boolean)fetcher$1.fetchState(tp).isDefined());
        PartitionFetchState fetchState = (PartitionFetchState)fetcher$1.fetchState(tp).get();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeReadyForFetch$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isReadyForFetch()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeReadyForFetch$1 ? " NOT" : "")).append(" be ready for fetching").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeTruncatingLog$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isTruncating()), (String)new StringBuilder(39).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeTruncatingLog$1 ? " NOT" : "")).append(" be truncating its log").toString());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)shouldBeDelayed$1), (Object)BoxesRunTime.boxToBoolean((boolean)fetchState.isDelayed()), (String)new StringBuilder(28).append("Partition ").append(tp).append(" should").append((Object)(!shouldBeDelayed$1 ? " NOT" : "")).append(" be delayed").toString());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$2(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    private static final FetchResponseData.PartitionData partitionData$1(int partition, FetchResponseData.EpochEndOffset divergingEpoch) {
        return new FetchResponseData.PartitionData().setPartitionIndex(partition).setLastStableOffset(0L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch);
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$3(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$4(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public static final /* synthetic */ void $anonfun$shouldTruncateIfLeaderRepliesWithDivergingEpochNotKnownToFollower$5(ReplicaFetcherThread thread$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Fetching$.MODULE$, (Object)((PartitionFetchState)thread$1.fetchState(tp).get()).state());
    }

    public ReplicaFetcherThreadTest() {
        this.metadataCache().updateMetadata(0, this.updateMetadataRequest());
    }
}

