/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0005\r%b\u0001\u0002!B\u0001\u0019C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000f\u0001B\u0001B\u0003%a\r\u0003\u0005v\u0001\t\u0015\r\u0011\"\u0001w\u0011%\t\t\u0002\u0001B\u0001B\u0003%q\u000f\u0003\u0006\u0002\u0014\u0001\u0011)\u0019!C\u0001\u0003+A!\"!\b\u0001\u0005\u0003\u0005\u000b\u0011BA\f\u0011)\ty\u0002\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011%\tY\u0004\u0001a\u0001\n\u0013\ti\u0004C\u0005\u0002@\u0001\u0001\r\u0011\"\u0003\u0002B!9\u0011Q\n\u0001!B\u0013\u0001\u0007BCA,\u0001\t\u0007I\u0011A!\u0002Z!A\u0011\u0011\r\u0001!\u0002\u0013\tY\u0006C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007\u0003\u0006\u0002p\u0001\u0011\r\u0011\"\u0001B\u0003cB\u0001B!\u0012\u0001A\u0003%\u00111\u000f\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011!\u0011Y\u0006\u0001C\u0001\u0003\nu\u0003b\u0002B0\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0005C\u0002A\u0011AAt\u0011\u001d\u0011\u0019\u0007\u0001C!\u0005KBqA!\u001c\u0001\t\u0003\u0012y\u0007C\u0004\u0003|\u0001!\tE! \t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"9!1\u0012\u0001\u0005\u0002\t5\u0005\"\u0003BO\u0001E\u0005I\u0011\u0001BP\u0011\u001d\u0011)\f\u0001C\u0001\u0005oCqAa1\u0001\t\u0003\u0011)\rC\u0004\u0003L\u0002!\tA!4\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"9!Q\u001c\u0001\u0005\u0002\t}\u0007b\u0002Bv\u0001\u0011\u0005!Q\u001e\u0005\n\u0005o\u0004\u0011\u0013!C\u0001\u0005sDqA!@\u0001\t\u0003\u0011y\u0010\u0003\u0005\u0004\n\u0001!\taQA\u001f\u0011!\u0019Y\u0001\u0001C\u0001\u0003\nucaBAB\u0001\u0001\t\u0015Q\u0011\u0005\u000b\u0003\u001b;#\u0011!Q\u0001\n\u0005=\u0005bBA\u0016O\u0011\u0005\u0011Q\u0013\u0005\b\u00033;C\u0011KAN\u0011%\tIk\nb\u0001\n\u0003\tY\u000b\u0003\u0005\u00024\u001e\u0002\u000b\u0011BAW\u0011%\t)l\na\u0001\n\u0003\t9\fC\u0005\u0002@\u001e\u0002\r\u0011\"\u0001\u0002B\"A\u0011QY\u0014!B\u0013\tI\fC\u0005\u0002J\u001e\u0002\r\u0011\"\u0001\u0002L\"I\u00111[\u0014A\u0002\u0013\u0005\u0011Q\u001b\u0005\t\u00033<\u0003\u0015)\u0003\u0002N\"9\u0011Q\\\u0014\u0005\n\u0005}\u0007bBAsO\u0011\u0005\u0013q\u001d\u0005\b\u0003S<C\u0011BAv\u0011\u001d\t\u0019p\nC\u0005\u0003WDqA!\u0002(\t\u0013\u00119\u0001C\u0004\u0003\u0014\u001d\"\tA!\u0006\b\u000f\r5\u0011\t#\u0001\u0004\u0010\u00191\u0001)\u0011E\u0001\u0007#Aq!a\u000b;\t\u0003\u0019\u0019\u0002C\u0005\u0004\u0016i\u0012\r\u0011\"\u0001\u0004\u0018!A11\u0004\u001e!\u0002\u0013\u0019I\u0002C\u0004\u0004\u001ei\"\taa\b\t\u0013\r\r\"(%A\u0005\u0002\r\u0015\"A\u0003'pO\u000ecW-\u00198fe*\u0011!iQ\u0001\u0004Y><'\"\u0001#\u0002\u000b-\fgm[1\u0004\u0001M)\u0001aR'T3B\u0011\u0001jS\u0007\u0002\u0013*\t!*A\u0003tG\u0006d\u0017-\u0003\u0002M\u0013\n1\u0011I\\=SK\u001a\u0004\"AT)\u000e\u0003=S!\u0001U\"\u0002\u000bU$\u0018\u000e\\:\n\u0005I{%a\u0002'pO\u001eLgn\u001a\t\u0003)^k\u0011!\u0016\u0006\u0003-\u000e\u000bq!\\3ue&\u001c7/\u0003\u0002Y+\n\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\u0011\u0005ikV\"A.\u000b\u0005q\u001b\u0015AB:feZ,'/\u0003\u0002_7\n!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\fQ\"\u001b8ji&\fGnQ8oM&<\u0007CA1c\u001b\u0005\t\u0015BA2B\u00055\u0019E.Z1oKJ\u001cuN\u001c4jO\u00069An\\4ESJ\u001cX#\u00014\u0011\u0007\u001dTG.D\u0001i\u0015\tI\u0017*\u0001\u0006d_2dWm\u0019;j_:L!a\u001b5\u0003\u0007M+\u0017\u000f\u0005\u0002ne6\taN\u0003\u0002pa\u0006\u0011\u0011n\u001c\u0006\u0002c\u0006!!.\u0019<b\u0013\t\u0019hN\u0001\u0003GS2,\u0017\u0001\u00037pO\u0012K'o\u001d\u0011\u0002\t1|wm]\u000b\u0002oB)a\n\u001f>\u0002\f%\u0011\u0011p\u0014\u0002\u0005!>|G\u000eE\u0002|\u0003\u000fi\u0011\u0001 \u0006\u0003{z\faaY8n[>t'B\u0001#\u0000\u0015\u0011\t\t!a\u0001\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)!A\u0002pe\u001eL1!!\u0003}\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042!YA\u0007\u0013\r\ty!\u0011\u0002\u000b+:Lg-[3e\u0019><\u0017!\u00027pON\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u0002\u0018A\u0019!,!\u0007\n\u0007\u0005m1L\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\\\u0001\u0016Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7!\u0003\u0011!\u0018.\\3\u0011\t\u0005\r\u0012qE\u0007\u0003\u0003KQ!\u0001\u0015?\n\t\u0005%\u0012Q\u0005\u0002\u0005)&lW-\u0001\u0004=S:LGO\u0010\u000b\r\u0003_\t\t$a\r\u00026\u0005]\u0012\u0011\b\t\u0003C\u0002AQaX\u0005A\u0002\u0001DQ\u0001Z\u0005A\u0002\u0019DQ!^\u0005A\u0002]Dq!a\u0005\n\u0001\u0004\t9\u0002C\u0005\u0002 %\u0001\n\u00111\u0001\u0002\"\u000511m\u001c8gS\u001e,\u0012\u0001Y\u0001\u000bG>tg-[4`I\u0015\fH\u0003BA\"\u0003\u0013\u00022\u0001SA#\u0013\r\t9%\u0013\u0002\u0005+:LG\u000f\u0003\u0005\u0002L-\t\t\u00111\u0001a\u0003\rAH%M\u0001\bG>tg-[4!Q\ra\u0011\u0011\u000b\t\u0004\u0011\u0006M\u0013bAA+\u0013\nAao\u001c7bi&dW-\u0001\bdY\u0016\fg.\u001a:NC:\fw-\u001a:\u0016\u0005\u0005m\u0003cA1\u0002^%\u0019\u0011qL!\u0003#1{wm\u00117fC:,'/T1oC\u001e,'/A\bdY\u0016\fg.\u001a:NC:\fw-\u001a:!\u0003%!\bN]8ui2,'/\u0006\u0002\u0002hA\u0019a*!\u001b\n\u0007\u0005-tJA\u0005UQJ|G\u000f\u001e7fe\u0006QA\u000f\u001b:piRdWM\u001d\u0011\u0002\u0011\rdW-\u00198feN,\"!a\u001d\u0011\r\u0005U\u00141PA@\u001b\t\t9HC\u0002\u0002z!\fq!\\;uC\ndW-\u0003\u0003\u0002~\u0005]$aC!se\u0006L()\u001e4gKJ\u00042!!!(\u001b\u0005\u0001!!D\"mK\u0006tWM\u001d+ie\u0016\fGmE\u0002(\u0003\u000f\u00032ATAE\u0013\r\tYi\u0014\u0002\u0013'\",H\u000fZ8x]\u0006\u0014G.\u001a+ie\u0016\fG-\u0001\u0005uQJ,\u0017\rZ%e!\rA\u0015\u0011S\u0005\u0004\u0003'K%aA%oiR!\u0011qPAL\u0011\u001d\ti)\u000ba\u0001\u0003\u001f\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\t\ti\n\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\r\t\u0019\u000b]\u0001\u0005Y\u0006tw-\u0003\u0003\u0002(\u0006\u0005&AB*ue&tw-A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u00055\u0006cA1\u00020&\u0019\u0011\u0011W!\u0003\u000f\rcW-\u00198fe\u0006A1\r\\3b]\u0016\u0014\b%A\u0005mCN$8\u000b^1ugV\u0011\u0011\u0011\u0018\t\u0004C\u0006m\u0016bAA_\u0003\na1\t\\3b]\u0016\u00148\u000b^1ug\u0006iA.Y:u'R\fGo]0%KF$B!a\u0011\u0002D\"I\u00111\n\u0018\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u000bY\u0006\u001cHo\u0015;biN\u0004\u0003fA\u0018\u0002R\u0005\tB.Y:u!J,7\t\\3b]N#\u0018\r^:\u0016\u0005\u00055\u0007cA1\u0002P&\u0019\u0011\u0011[!\u0003\u001bA\u0013Xm\u00117fC:\u001cF/\u0019;t\u0003Ua\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo]0%KF$B!a\u0011\u0002X\"I\u00111J\u0019\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0013Y\u0006\u001cH\u000f\u0015:f\u00072,\u0017M\\*uCR\u001c\b\u0005K\u00023\u0003#\n\u0011b\u00195fG.$uN\\3\u0015\t\u0005\r\u0013\u0011\u001d\u0005\u0007\u0003G\u001c\u0004\u0019\u0001>\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\u00061Am\\,pe.$\"!a\u0011\u0002)Q\u0014\u0018p\u00117fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8h)\t\ti\u000fE\u0002I\u0003_L1!!=J\u0005\u001d\u0011un\u001c7fC:\f\u0011c\u00197fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8hQ\u00151\u0014q\u001fB\u0002!\u0015A\u0015\u0011`A\u007f\u0013\r\tY0\u0013\u0002\u0007i\"\u0014xn^:\u0011\u0007\u0005\fy0C\u0002\u0003\u0002\u0005\u0013A\u0003T8h\u00072,\u0017M\\5oO\u0016C8-\u001a9uS>t7EAA\u007f\u0003!\u0019G.Z1o\u0019><G\u0003BA\"\u0005\u0013AqAa\u00038\u0001\u0004\u0011i!A\u0005dY\u0016\fg.\u00192mKB\u0019\u0011Ma\u0004\n\u0007\tE\u0011I\u0001\u0006M_\u001e$vn\u00117fC:\f1B]3d_J$7\u000b^1ugRa\u00111\tB\f\u00057\u0011\u0019D!\u0010\u0003B!9!\u0011\u0004\u001dA\u0002\u0005=\u0015AA5e\u0011\u001d\u0011i\u0002\u000fa\u0001\u0005?\tAA\\1nKB!!\u0011\u0005B\u0018\u001d\u0011\u0011\u0019Ca\u000b\u0011\u0007\t\u0015\u0012*\u0004\u0002\u0003()\u0019!\u0011F#\u0002\rq\u0012xn\u001c;?\u0013\r\u0011i#S\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d&\u0011\u0007\u0006\u0004\u0005[I\u0005b\u0002B\u001bq\u0001\u0007!qG\u0001\u0005MJ|W\u000eE\u0002I\u0005sI1Aa\u000fJ\u0005\u0011auN\\4\t\u000f\t}\u0002\b1\u0001\u00038\u0005\u0011Ao\u001c\u0005\b\u0005\u0007B\u0004\u0019AA]\u0003\u0015\u0019H/\u0019;t\u0003%\u0019G.Z1oKJ\u001c\b%A\u000bnCb|e/\u001a:DY\u0016\fg.\u001a:UQJ,\u0017\rZ:\u0015\t\u0005=%1\n\u0005\b\u0005\u001b\u001a\u0002\u0019\u0001B(\u0003\u00051\u0007c\u0002%\u0003R\u0005}$QK\u0005\u0004\u0005'J%!\u0003$v]\u000e$\u0018n\u001c82!\rA%qK\u0005\u0004\u00053J%A\u0002#pk\ndW-A\beK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u+\t\ty)A\u0004ti\u0006\u0014H/\u001e9\u0002\u0011MDW\u000f\u001e3po:\fQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003hA)qM!\u001b\u0003 %\u0019!1\u000e5\u0003\u0007M+G/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u00111\tB9\u0011\u001d\u0011\u0019\b\u0007a\u0001\u0005k\n\u0011B\\3x\u0007>tg-[4\u0011\u0007i\u00139(C\u0002\u0003zm\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t\u0019Ea \u0003\u0004\"9!\u0011Q\rA\u0002\tU\u0014!C8mI\u000e{gNZ5h\u0011\u001d\u0011\u0019(\u0007a\u0001\u0005k\nQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA\"\u0005\u0013Ca!a9\u001b\u0001\u0004Q\u0018!E;qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugR1\u00111\tBH\u0005'CaA!%\u001c\u0001\u0004a\u0017a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0005+[\u0002\u0013!a\u0001\u0005/\u000b\u0011\u0003]1si&$\u0018n\u001c8U_J+Wn\u001c<f!\u0011A%\u0011\u0014>\n\u0007\tm\u0015J\u0001\u0004PaRLwN\\\u0001\u001ckB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0005&\u0006\u0002BL\u0005G[#A!*\u0011\t\t\u001d&\u0011W\u0007\u0003\u0005SSAAa+\u0003.\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005_K\u0015AC1o]>$\u0018\r^5p]&!!1\u0017BU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0013C2$XM]\"iK\u000e\\\u0007o\\5oi\u0012K'\u000f\u0006\u0005\u0002D\te&1\u0018B`\u0011\u0019\t\u0019/\ba\u0001u\"1!QX\u000fA\u00021\fAb]8ve\u000e,Gj\\4ESJDaA!1\u001e\u0001\u0004a\u0017A\u00033fgRdun\u001a#je\u0006\u0019\u0002.\u00198eY\u0016dun\u001a#je\u001a\u000b\u0017\u000e\\;sKR!\u00111\tBd\u0011\u001d\u0011IM\ba\u0001\u0005?\t1\u0001Z5s\u0003]i\u0017-\u001f2f)J,hnY1uK\u000eCWmY6q_&tG\u000f\u0006\u0005\u0002D\t='\u0011\u001bBj\u0011\u0019\u0011\tj\ba\u0001Y\"1\u00111]\u0010A\u0002iDqA!6 \u0001\u0004\u00119$\u0001\u0004pM\u001a\u001cX\r^\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t\u0019Ea7\t\r\u0005\r\b\u00051\u0001{\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$B!a\u0011\u0003b\"9!1]\u0011A\u0002\t\u0015\u0018a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\t\u001d\u00149O_\u0005\u0004\u0005SD'\u0001C%uKJ\f'\r\\3\u0002\u0019\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3\u0015\u0011\u00055(q\u001eBy\u0005gDa!a9#\u0001\u0004Q\bb\u0002BkE\u0001\u0007!q\u0007\u0005\n\u0005k\u0014\u0003\u0013!a\u0001\u0005o\t\u0011\"\\1y/\u0006LG/T:\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"Aa?+\t\t]\"1U\u0001'a\u0006,8/Z\"mK\u0006t\u0017N\\4G_JtuN\\\"p[B\f7\r^3e!\u0006\u0014H/\u001b;j_:\u001cHCAB\u0001!\u00159'q]B\u0002!\u0019A5Q\u0001>\u0002\f%\u00191qA%\u0003\rQ+\b\u000f\\33\u00035\u0019WO\u001d:f]R\u001cuN\u001c4jO\u0006a1\r\\3b]\u0016\u00148i\\;oi\u0006QAj\\4DY\u0016\fg.\u001a:\u0011\u0005\u0005T4C\u0001\u001eH)\t\u0019y!A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\re\u0001#B4\u0003j\u0005u\u0015A\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm\u001d\u0011\u0002\u001b\rdW-\u00198fe\u000e{gNZ5h)\r\u00017\u0011\u0005\u0005\b\u0003wq\u0004\u0019\u0001B;\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u00111q\u0005\u0016\u0005\u0003C\u0011\u0019\u000b")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    public static CleanerConfig cleanerConfig(KafkaConfig config) {
        return LogCleaner$.MODULE$.cleanerConfig(config);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    private int maxOverCleanerThreads(Function1<CleanerThread, Object> f) {
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isThreadFailed()));
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting the log cleaner");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            CleanerThread cleaner = new CleanerThread(i);
            this.cleaners().$plus$eq((Object)cleaner);
            cleaner.start();
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down the log cleaner.");
        this.cleaners().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        int numThreads = LogCleaner$.MODULE$.cleanerConfig(newConfig).numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException("Log cleaner threads should be at least 1");
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringBuilder(74).append("Log cleaner threads cannot be reduced to less than half the current value ").append(currentThreads).toString());
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringBuilder(78).append("Log cleaner threads cannot be increased to more than double the current value ").append(currentThreads).toString());
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir, Option<TopicPartition> partitionToRemove) {
        Option<Tuple2<TopicPartition, Object>> x$3 = this.cleanerManager().updateCheckpoints$default$2();
        this.cleanerManager().updateCheckpoints(dataDir, x$3, partitionToRemove);
    }

    public Option<TopicPartition> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        this.cleanerManager().resumeCleaning(topicPartitions);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    public static final /* synthetic */ double $anonfun$new$2(CleanerThread x$1) {
        return x$1.lastStats().bufferUtilization();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$1() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$2(x$1));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) * 100;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$3() {
        ArrayBuffer stats = (ArrayBuffer)this.cleaners().map((Function1 & Serializable)x$2 -> x$2.lastStats());
        double recopyRate = (double)BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.bytesWritten())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)stats.iterator().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.bytesRead())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
        return (int)((double)100 * recopyRate);
    }

    public static final /* synthetic */ double $anonfun$new$8(CleanerThread x$5) {
        return x$5.lastStats().elapsedSecs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$7() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$8(x$5));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread))))));
    }

    public static final /* synthetic */ double $anonfun$new$10(CleanerThread x$6) {
        return x$6.lastPreCleanStats().maxCompactionDelayMs();
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$9() {
        Function1 & Serializable maxOverCleanerThreads_f = (Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)LogCleaner.$anonfun$new$10(x$6));
        return (int)BoxesRunTime.unboxToDouble((Object)this.cleaners().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable)(max, thread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.max(BoxesRunTime.unboxToDouble((Object)max), BoxesRunTime.unboxToDouble((Object)maxOverCleanerThreads_f.apply((Object)thread)))))) / 1000;
    }

    public final /* synthetic */ int kafka$log$LogCleaner$$$anonfun$new$11() {
        return this.deadThreadCount();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable)x$9 -> x$9 >= offset$1));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$3();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleaner$$$anonfun$new$9();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public final int value() {
                LogCleaner logCleaner = this.$outer;
                if (logCleaner == null) {
                    throw null;
                }
                return logCleaner.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            if (!this.tryCleanFilthiestLog()) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().maintainUncleanablePartitions();
        }

        private boolean tryCleanFilthiestLog() {
            try {
                return this.cleanFilthiestLog();
            }
            catch (LogCleaningException e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(87).append("Unexpected exception thrown when cleaning log ").append(e.log()).append(". Marking its partition (").append(e.log().topicPartition()).append(") as uncleanable").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(e.log().parentDir(), e.log().topicPartition());
                return false;
            }
        }

        private boolean cleanFilthiestLog() throws LogCleaningException {
            boolean bl;
            PreCleanStats preCleanStats = new PreCleanStats();
            Option<LogToClean> ltc = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
            if (None$.MODULE$.equals(ltc)) {
                bl = false;
            } else if (ltc instanceof Some) {
                boolean bl2;
                LogToClean cleanable = (LogToClean)((Some)ltc).value();
                this.lastPreCleanStats_$eq(preCleanStats);
                try {
                    this.cleanLog(cleanable);
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    boolean bl3 = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl3) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                    }
                    throw throwable;
                }
                bl = bl2;
            } else {
                throw new MatchError(ltc);
            }
            Iterable<Tuple2<TopicPartition, UnifiedLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            try {
                deletable.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanFilthiestLog$1(x0$1)));
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1 & Serializable)x$10 -> (TopicPartition)x$10._1())));
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private void cleanLog(LogToClean cleanable) {
            long startOffset;
            long endOffset = startOffset = cleanable.firstDirtyOffset();
            try {
                try {
                    void var9_6;
                    void var7_5;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) {
                        throw new MatchError(null);
                    }
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    endOffset = var7_5;
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), startOffset, (long)var7_5, (CleanerStats)var9_6);
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (IOException e) {
                    String logDirectory = cleanable.log().parentDir();
                    String msg = new StringBuilder(54).append("Failed to clean up log for ").append(cleanable.topicPartition()).append(" in dir ").append(logDirectory).append(" due to IOException").toString();
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)(Function0 & Serializable)() -> msg, e);
                }
            }
            finally {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().parentDirFile(), endOffset);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder(0).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / stats.elapsedSecs() / (double)0x100000))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)((double)stats.mapBytesRead() / (double)0x100000 / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000 / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesRead() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)stats.bytesWritten() / (double)0x100000)), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)(Function0 & Serializable)() -> message);
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.lastPreCleanStats().maxCompactionDelayMs())})));
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanFilthiestLog$1(Tuple2 x0$1) {
            int n;
            if (x0$1 != null) {
                UnifiedLog log = (UnifiedLog)x0$1._2();
                try {
                    n = log.deleteOldSegments();
                }
                catch (Throwable throwable) {
                    boolean bl = throwable instanceof ThreadShutdownException ? true : throwable instanceof ControlThrowable;
                    if (bl) {
                        throw throwable;
                    }
                    if (throwable instanceof Exception) {
                        Exception exception = (Exception)throwable;
                        throw new LogCleaningException(log, exception.getMessage(), exception);
                    }
                    throw throwable;
                }
            } else {
                throw new MatchError(null);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder(25).append("kafka-log-cleaner-thread-").append(threadId).toString(), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(Time.SYSTEM);
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

