/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import kafka.server.BrokerFeatures;
import kafka.server.FeatureCacheUpdateException;
import kafka.server.FinalizedFeaturesAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.metadata.VersionRange;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005m4AAD\b\u0001)!A\u0011\u0005\u0001BC\u0002\u0013%!\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u001da\u0003\u00011A\u0005\n5Bq\u0001\u000e\u0001A\u0002\u0013%Q\u0007\u0003\u0004<\u0001\u0001\u0006KA\f\u0005\u0006\u0001\u0002!\t!\f\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\r\u0002!\ta\u0012\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\u0006#\u0002!\tA\u0015\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006g\u0002!I\u0001\u001e\u0002\u0016\r&t\u0017\r\\5{K\u00124U-\u0019;ve\u0016\u001c\u0015m\u00195f\u0015\t\u0001\u0012#\u0001\u0004tKJ4XM\u001d\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\t\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001j\"a\u0002'pO\u001eLgnZ\u0001\u000fEJ|7.\u001a:GK\u0006$XO]3t+\u0005\u0019\u0003C\u0001\u0013&\u001b\u0005y\u0011B\u0001\u0014\u0010\u00059\u0011%o\\6fe\u001a+\u0017\r^;sKN\fqB\u0019:pW\u0016\u0014h)Z1ukJ,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)Z\u0003C\u0001\u0013\u0001\u0011\u0015\t3\u00011\u0001$\u0003A1W-\u0019;ve\u0016\u001c\u0018I\u001c3Fa>\u001c\u0007.F\u0001/!\r1r&M\u0005\u0003a]\u0011aa\u00149uS>t\u0007C\u0001\u00133\u0013\t\u0019tBA\rGS:\fG.\u001b>fI\u001a+\u0017\r^;sKN\fe\u000eZ#q_\u000eD\u0017\u0001\u00064fCR,(/Z:B]\u0012,\u0005o\\2i?\u0012*\u0017\u000f\u0006\u00027sA\u0011acN\u0005\u0003q]\u0011A!\u00168ji\"9!(BA\u0001\u0002\u0004q\u0013a\u0001=%c\u0005\tb-Z1ukJ,7/\u00118e\u000bB|7\r\u001b\u0011)\u0005\u0019i\u0004C\u0001\f?\u0013\tytC\u0001\u0005w_2\fG/\u001b7f\u0003\r9W\r^\u0001\bSN,U\u000e\u001d;z+\u0005\u0019\u0005C\u0001\fE\u0013\t)uCA\u0004C_>dW-\u00198\u0002+]\f\u0017\u000e^+oi&dW\t]8dQ>\u0013H\u000b\u001b:poR\u0019a\u0007S'\t\u000b%K\u0001\u0019\u0001&\u0002!5Lg.\u0012=qK\u000e$X\rZ#q_\u000eD\u0007C\u0001\fL\u0013\tauC\u0001\u0003M_:<\u0007\"\u0002(\n\u0001\u0004Q\u0015!\u0003;j[\u0016|W\u000f^'t\u0003\u0015\u0019G.Z1s)\u00051\u0014!D;qI\u0006$Xm\u0014:UQJ|w\u000fF\u00027'\u0016DQ\u0001V\u0006A\u0002U\u000ba\u0002\\1uKN$h)Z1ukJ,7\u000fE\u0002WA\nl\u0011a\u0016\u0006\u00031f\u000bqAZ3biV\u0014XM\u0003\u0002[7\u000611m\\7n_:T!A\u0005/\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0005\u0003C^\u0013\u0001BR3biV\u0014Xm\u001d\t\u0003-\u000eL!\u0001Z,\u0003+\u0019Kg.\u00197ju\u0016$g+\u001a:tS>t'+\u00198hK\")am\u0003a\u0001\u0015\u0006YA.\u0019;fgR,\u0005o\\2i\u0003\u0019)\b\u000fZ1uKR\u0019a'[9\t\u000b)d\u0001\u0019A6\u0002\u001b\u0019,\u0017\r^;sKN$U\r\u001c;b!\taw.D\u0001n\u0015\tq7,A\u0003j[\u0006<W-\u0003\u0002q[\nia)Z1ukJ,7\u000fR3mi\u0006DQA\u001d\u0007A\u0002)\u000bQ\u0003[5hQ\u0016\u001cH/T3uC\u0012\fG/Y(gMN,G/A\rxC&$XK\u001c;jY\u000e{g\u000eZ5uS>twJ\u001d+ie><Hc\u0001\u001cvu\")a/\u0004a\u0001o\u0006iq/Y5u\u0007>tG-\u001b;j_:\u00042A\u0006=D\u0013\tIxCA\u0005Gk:\u001cG/[8oa!)a*\u0004a\u0001\u0015\u0002")
public class FinalizedFeatureCache
implements Logging {
    private final BrokerFeatures brokerFeatures;
    private volatile Option<FinalizedFeaturesAndEpoch> featuresAndEpoch;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private Option<FinalizedFeaturesAndEpoch> featuresAndEpoch() {
        return this.featuresAndEpoch;
    }

    private void featuresAndEpoch_$eq(Option<FinalizedFeaturesAndEpoch> x$1) {
        this.featuresAndEpoch = x$1;
    }

    public Option<FinalizedFeaturesAndEpoch> get() {
        return this.featuresAndEpoch();
    }

    public boolean isEmpty() {
        return this.featuresAndEpoch().isEmpty();
    }

    public void waitUntilEpochOrThrow(long minExpectedEpoch, long timeoutMs) {
        if (minExpectedEpoch < 0L) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Expected minExpectedEpoch >= 0, but ").append(minExpectedEpoch).append(" was provided.").toString());
        }
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Expected timeoutMs >= 0, but ").append(timeoutMs).append(" was provided.").toString());
        }
        long waitUntilConditionOrThrow_waitEndTimeNanos = System.nanoTime() + timeoutMs * 1000000L;
        synchronized (this) {
            while (!FinalizedFeatureCache.$anonfun$waitUntilEpochOrThrow$1(this, minExpectedEpoch)) {
                long waitUntilConditionOrThrow_nowNanos = System.nanoTime();
                if (waitUntilConditionOrThrow_nowNanos > waitUntilConditionOrThrow_waitEndTimeNanos) {
                    throw new TimeoutException(new StringBuilder(0).append(new StringBuilder(64).append("Timed out after waiting for ").append(timeoutMs).append("ms for required condition to be met.").toString()).append(new StringBuilder(17).append(" Current epoch: ").append(this.featuresAndEpoch().map((Function1 & Serializable)fe -> BoxesRunTime.boxToLong((long)fe.epoch())).getOrElse((Function0 & Serializable)() -> "<none>")).append(".").toString()).toString());
                }
                long waitUntilConditionOrThrow_sleepTimeMs = package$.MODULE$.max(1L, (waitUntilConditionOrThrow_waitEndTimeNanos - waitUntilConditionOrThrow_nowNanos) / 1000000L);
                this.wait(waitUntilConditionOrThrow_sleepTimeMs);
            }
            return;
        }
    }

    public void clear() {
        synchronized (this) {
            this.featuresAndEpoch_$eq((Option<FinalizedFeaturesAndEpoch>)Option$.MODULE$.empty());
            this.notifyAll();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> "Cleared cache");
    }

    public void updateOrThrow(Features<FinalizedVersionRange> latestFeatures, long latestEpoch) {
        FinalizedFeaturesAndEpoch latest = new FinalizedFeaturesAndEpoch(latestFeatures, latestEpoch);
        String existing = (String)this.featuresAndEpoch().map((Function1 & Serializable)item -> item.toString()).getOrElse((Function0 & Serializable)() -> "<empty>");
        if (this.featuresAndEpoch().isDefined() && ((FinalizedFeaturesAndEpoch)this.featuresAndEpoch().get()).epoch() > latest.epoch()) {
            String errorMsg = new StringBuilder(0).append(new StringBuilder(65).append("FinalizedFeatureCache update failed due to invalid epoch in new ").append(latest).append(".").toString()).append(new StringBuilder(34).append(" The existing cache contents are ").append(existing).append(".").toString()).toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        if (!this.brokerFeatures().incompatibleFeatures(latest.features()).empty()) {
            String errorMsg = new StringBuilder(63).append("FinalizedFeatureCache update failed since feature compatibility").append(new StringBuilder(48).append(" checks failed! Supported ").append(this.brokerFeatures().supportedFeatures()).append(" has incompatibilities").toString()).append(new StringBuilder(18).append(" with the latest ").append(latest).append(".").toString()).toString();
            throw new FeatureCacheUpdateException(errorMsg);
        }
        String logMsg = new StringBuilder(40).append("Updated cache from existing ").append(existing).append(" to latest ").append(latest).append(".").toString();
        synchronized (this) {
            this.featuresAndEpoch_$eq((Option<FinalizedFeaturesAndEpoch>)new Some((Object)latest));
            this.notifyAll();
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> logMsg);
    }

    public void update(FeaturesDelta featuresDelta, long highestMetadataOffset) {
        FinalizedFeaturesAndEpoch features = (FinalizedFeaturesAndEpoch)this.featuresAndEpoch().getOrElse((Function0 & Serializable)() -> new FinalizedFeaturesAndEpoch((Features<FinalizedVersionRange>)Features.emptyFinalizedFeatures(), -1L));
        HashMap newFeatures = new HashMap();
        newFeatures.putAll(features.features().features());
        featuresDelta.changes().entrySet().forEach(e -> {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric((Optional)e.getValue()));
            if (None$.MODULE$.equals(option)) {
                newFeatures.remove(e.getKey());
                return;
            }
            if (option instanceof Some) {
                VersionRange feature = (VersionRange)((Some)option).value();
                newFeatures.put(e.getKey(), new FinalizedVersionRange(feature.min(), feature.max()));
                return;
            }
            throw new MatchError((Object)option);
        });
        this.featuresAndEpoch_$eq((Option<FinalizedFeaturesAndEpoch>)new Some((Object)new FinalizedFeaturesAndEpoch((Features<FinalizedVersionRange>)Features.finalizedFeatures(Collections.unmodifiableMap(newFeatures)), highestMetadataOffset)));
    }

    private void waitUntilConditionOrThrow(Function0<Object> waitCondition, long timeoutMs) {
        if (timeoutMs < 0L) {
            throw new IllegalArgumentException(new StringBuilder(43).append("Expected timeoutMs >= 0, but ").append(timeoutMs).append(" was provided.").toString());
        }
        long waitEndTimeNanos = System.nanoTime() + timeoutMs * 1000000L;
        synchronized (this) {
            while (!waitCondition.apply$mcZ$sp()) {
                long nowNanos = System.nanoTime();
                if (nowNanos > waitEndTimeNanos) {
                    throw new TimeoutException(new StringBuilder(0).append(new StringBuilder(64).append("Timed out after waiting for ").append(timeoutMs).append("ms for required condition to be met.").toString()).append(new StringBuilder(17).append(" Current epoch: ").append(this.featuresAndEpoch().map((Function1 & Serializable)fe -> BoxesRunTime.boxToLong((long)fe.epoch())).getOrElse((Function0 & Serializable)() -> "<none>")).append(".").toString()).toString());
                }
                long sleepTimeMs = package$.MODULE$.max(1L, (waitEndTimeNanos - nowNanos) / 1000000L);
                this.wait(sleepTimeMs);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilEpochOrThrow$1(FinalizedFeatureCache $this, long minExpectedEpoch$1) {
        return $this.featuresAndEpoch().isDefined() && ((FinalizedFeaturesAndEpoch)$this.featuresAndEpoch().get()).epoch() >= minExpectedEpoch$1;
    }

    public FinalizedFeatureCache(BrokerFeatures brokerFeatures) {
        this.brokerFeatures = brokerFeatures;
        this.featuresAndEpoch = Option$.MODULE$.empty();
    }
}

