/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import kafka.api.ApiVersion$;
import kafka.cluster.EndPoint$;
import kafka.coordinator.group.OffsetConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.raft.RaftConfig;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;

public final class Defaults$ {
    public static final Defaults$ MODULE$ = new Defaults$();
    private static String LogMessageFormatVersion;
    private static final int ZkSessionTimeoutMs;
    private static final int ZkSyncTimeMs;
    private static final boolean ZkEnableSecureAcls;
    private static final int ZkMaxInFlightRequests;
    private static final boolean ZkSslClientEnable;
    private static final String ZkSslProtocol;
    private static final String ZkSslEndpointIdentificationAlgorithm;
    private static final boolean ZkSslCrlEnable;
    private static final boolean ZkSslOcspEnable;
    private static final boolean BrokerIdGenerationEnable;
    private static final int MaxReservedBrokerId;
    private static final int BrokerId;
    private static final int MessageMaxBytes;
    private static final int NumNetworkThreads;
    private static final int NumIoThreads;
    private static final int BackgroundThreads;
    private static final int QueuedMaxRequests;
    private static final int QueuedMaxRequestBytes;
    private static final int InitialBrokerRegistrationTimeoutMs;
    private static final int BrokerHeartbeatIntervalMs;
    private static final int BrokerSessionTimeoutMs;
    private static final int EmptyNodeId;
    private static final String AuthorizerClassName;
    private static final int Port;
    private static final String HostName;
    private static final String ListenerSecurityProtocolMap;
    private static final int SocketSendBufferBytes;
    private static final int SocketReceiveBufferBytes;
    private static final int SocketRequestMaxBytes;
    private static final int MaxConnectionsPerIp;
    private static final String MaxConnectionsPerIpOverrides;
    private static final int MaxConnections;
    private static final int MaxConnectionCreationRate;
    private static final long ConnectionsMaxIdleMs;
    private static final int RequestTimeoutMs;
    private static final Long ConnectionSetupTimeoutMs;
    private static final Long ConnectionSetupTimeoutMaxMs;
    private static final int FailedAuthenticationDelayMs;
    private static final int NumPartitions;
    private static final String LogDir;
    private static final int LogSegmentBytes;
    private static final int LogRollHours;
    private static final int LogRollJitterHours;
    private static final int LogRetentionHours;
    private static final long LogRetentionBytes;
    private static final long LogCleanupIntervalMs;
    private static final String Delete;
    private static final String Compact;
    private static final String LogCleanupPolicy;
    private static final int LogCleanerThreads;
    private static final double LogCleanerIoMaxBytesPerSecond;
    private static final long LogCleanerDedupeBufferSize;
    private static final int LogCleanerIoBufferSize;
    private static final double LogCleanerDedupeBufferLoadFactor;
    private static final int LogCleanerBackoffMs;
    private static final double LogCleanerMinCleanRatio;
    private static final boolean LogCleanerEnable;
    private static final long LogCleanerDeleteRetentionMs;
    private static final long LogCleanerMinCompactionLagMs;
    private static final long LogCleanerMaxCompactionLagMs;
    private static final int LogIndexSizeMaxBytes;
    private static final int LogIndexIntervalBytes;
    private static final long LogFlushIntervalMessages;
    private static final int LogDeleteDelayMs;
    private static final long LogFlushSchedulerIntervalMs;
    private static final int LogFlushOffsetCheckpointIntervalMs;
    private static final int LogFlushStartOffsetCheckpointIntervalMs;
    private static final boolean LogPreAllocateEnable;
    private static final String LogMessageTimestampType;
    private static final long LogMessageTimestampDifferenceMaxMs;
    private static final int NumRecoveryThreadsPerDataDir;
    private static final boolean AutoCreateTopicsEnable;
    private static final int MinInSyncReplicas;
    private static final boolean MessageDownConversionEnable;
    private static final int ControllerSocketTimeoutMs;
    private static final int ControllerMessageQueueSize;
    private static final int DefaultReplicationFactor;
    private static final long ReplicaLagTimeMaxMs;
    private static final int ReplicaSocketTimeoutMs;
    private static final int ReplicaSocketReceiveBufferBytes;
    private static final int ReplicaFetchMaxBytes;
    private static final int ReplicaFetchWaitMaxMs;
    private static final int ReplicaFetchMinBytes;
    private static final int ReplicaFetchResponseMaxBytes;
    private static final int NumReplicaFetchers;
    private static final int ReplicaFetchBackoffMs;
    private static final long ReplicaHighWatermarkCheckpointIntervalMs;
    private static final int FetchPurgatoryPurgeIntervalRequests;
    private static final int ProducerPurgatoryPurgeIntervalRequests;
    private static final int DeleteRecordsPurgatoryPurgeIntervalRequests;
    private static final boolean AutoLeaderRebalanceEnable;
    private static final int LeaderImbalancePerBrokerPercentage;
    private static final int LeaderImbalanceCheckIntervalSeconds;
    private static final boolean UncleanLeaderElectionEnable;
    private static final String InterBrokerSecurityProtocol;
    private static final String InterBrokerProtocolVersion;
    private static final int ControlledShutdownMaxRetries;
    private static final int ControlledShutdownRetryBackoffMs;
    private static final boolean ControlledShutdownEnable;
    private static final int GroupMinSessionTimeoutMs;
    private static final int GroupMaxSessionTimeoutMs;
    private static final int GroupInitialRebalanceDelayMs;
    private static final int GroupMaxSize;
    private static final int OffsetMetadataMaxSize;
    private static final int OffsetsLoadBufferSize;
    private static final short OffsetsTopicReplicationFactor;
    private static final int OffsetsTopicPartitions;
    private static final int OffsetsTopicSegmentBytes;
    private static final int OffsetsTopicCompressionCodec;
    private static final int OffsetsRetentionMinutes;
    private static final long OffsetsRetentionCheckIntervalMs;
    private static final int OffsetCommitTimeoutMs;
    private static final short OffsetCommitRequiredAcks;
    private static final int TransactionalIdExpirationMs;
    private static final int TransactionsMaxTimeoutMs;
    private static final int TransactionsTopicMinISR;
    private static final int TransactionsLoadBufferSize;
    private static final short TransactionsTopicReplicationFactor;
    private static final int TransactionsTopicPartitions;
    private static final int TransactionsTopicSegmentBytes;
    private static final int TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    private static final int TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    private static final int MaxIncrementalFetchSessionCacheSlots;
    private static final int FetchMaxBytes;
    private static final long ProducerQuotaBytesPerSecondDefault;
    private static final long ConsumerQuotaBytesPerSecondDefault;
    private static final int NumQuotaSamples;
    private static final int QuotaWindowSizeSeconds;
    private static final int NumReplicationQuotaSamples;
    private static final int ReplicationQuotaWindowSizeSeconds;
    private static final int NumAlterLogDirsReplicationQuotaSamples;
    private static final int AlterLogDirsReplicationQuotaWindowSizeSeconds;
    private static final int NumControllerQuotaSamples;
    private static final int ControllerQuotaWindowSizeSeconds;
    private static final int TransactionalIdExpirationMsDefault;
    private static final boolean DeleteTopicEnable;
    private static final String CompressionType;
    private static final int MaxIdMapSnapshots;
    private static final int MetricNumSamples;
    private static final int MetricSampleWindowMs;
    private static final String MetricReporterClasses;
    private static final String MetricRecordingLevel;
    private static final String KafkaMetricReporterClasses;
    private static final int KafkaMetricsPollingIntervalSeconds;
    private static final String SslProtocol;
    private static final String SslEnabledProtocols;
    private static final String SslKeystoreType;
    private static final String SslTruststoreType;
    private static final String SslKeyManagerAlgorithm;
    private static final String SslTrustManagerAlgorithm;
    private static final String SslEndpointIdentificationAlgorithm;
    private static final String SslClientAuthentication;
    private static final String[] SslClientAuthenticationValidValues;
    private static final String SslPrincipalMappingRules;
    private static final long ConnectionsMaxReauthMsDefault;
    private static final String SaslMechanismInterBrokerProtocol;
    private static final List<String> SaslEnabledMechanisms;
    private static final String SaslKerberosKinitCmd;
    private static final double SaslKerberosTicketRenewWindowFactor;
    private static final double SaslKerberosTicketRenewJitter;
    private static final long SaslKerberosMinTimeBeforeRelogin;
    private static final List<String> SaslKerberosPrincipalToLocalRules;
    private static final double SaslLoginRefreshWindowFactor;
    private static final double SaslLoginRefreshWindowJitter;
    private static final short SaslLoginRefreshMinPeriodSeconds;
    private static final short SaslLoginRefreshBufferSeconds;
    private static final long DelegationTokenMaxLifeTimeMsDefault;
    private static final long DelegationTokenExpiryTimeMsDefault;
    private static final long DelegationTokenExpiryCheckIntervalMsDefault;
    private static final String PasswordEncoderCipherAlgorithm;
    private static final int PasswordEncoderKeyLength;
    private static final int PasswordEncoderIterations;
    private static final List<String> QuorumVoters;
    private static final int QuorumElectionTimeoutMs;
    private static final int QuorumFetchTimeoutMs;
    private static final int QuorumElectionBackoffMs;
    private static final int QuorumLingerMs;
    private static final int QuorumRequestTimeoutMs;
    private static final int QuorumRetryBackoffMs;
    private static volatile boolean bitmap$0;

    static {
        ZkSessionTimeoutMs = 18000;
        ZkSyncTimeMs = 2000;
        ZkEnableSecureAcls = false;
        ZkMaxInFlightRequests = 10;
        ZkSslClientEnable = false;
        ZkSslProtocol = "TLSv1.2";
        ZkSslEndpointIdentificationAlgorithm = "HTTPS";
        ZkSslCrlEnable = false;
        ZkSslOcspEnable = false;
        BrokerIdGenerationEnable = true;
        MaxReservedBrokerId = 1000;
        BrokerId = -1;
        MessageMaxBytes = 0x10000C;
        NumNetworkThreads = 3;
        NumIoThreads = 8;
        BackgroundThreads = 10;
        QueuedMaxRequests = 500;
        QueuedMaxRequestBytes = -1;
        InitialBrokerRegistrationTimeoutMs = 60000;
        BrokerHeartbeatIntervalMs = 2000;
        BrokerSessionTimeoutMs = 9000;
        EmptyNodeId = -1;
        AuthorizerClassName = "";
        Port = 9092;
        HostName = new String("");
        ListenerSecurityProtocolMap = ((IterableOnceOps)EndPoint$.MODULE$.DefaultSecurityProtocolMap().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            ListenerName listenerName = (ListenerName)x0$1._1();
            SecurityProtocol securityProtocol = (SecurityProtocol)x0$1._2();
            String string = new StringBuilder(1).append(listenerName.value()).append(":").append(securityProtocol.name).toString();
            return string;
        })).mkString(",");
        SocketSendBufferBytes = 102400;
        SocketReceiveBufferBytes = 102400;
        SocketRequestMaxBytes = 0x6400000;
        MaxConnectionsPerIp = Integer.MAX_VALUE;
        MaxConnectionsPerIpOverrides = "";
        MaxConnections = Integer.MAX_VALUE;
        MaxConnectionCreationRate = Integer.MAX_VALUE;
        ConnectionsMaxIdleMs = 600000L;
        RequestTimeoutMs = 30000;
        ConnectionSetupTimeoutMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MS;
        ConnectionSetupTimeoutMaxMs = CommonClientConfigs.DEFAULT_SOCKET_CONNECTION_SETUP_TIMEOUT_MAX_MS;
        FailedAuthenticationDelayMs = 100;
        NumPartitions = 1;
        LogDir = "/tmp/kafka-logs";
        LogSegmentBytes = 0x40000000;
        LogRollHours = 168;
        LogRollJitterHours = 0;
        LogRetentionHours = 168;
        LogRetentionBytes = -1L;
        LogCleanupIntervalMs = 300000L;
        Delete = "delete";
        Compact = "compact";
        LogCleanupPolicy = MODULE$.Delete();
        LogCleanerThreads = 1;
        LogCleanerIoMaxBytesPerSecond = Double.MAX_VALUE;
        LogCleanerDedupeBufferSize = 0x8000000L;
        LogCleanerIoBufferSize = 524288;
        LogCleanerDedupeBufferLoadFactor = 0.9;
        LogCleanerBackoffMs = 15000;
        LogCleanerMinCleanRatio = 0.5;
        LogCleanerEnable = true;
        LogCleanerDeleteRetentionMs = 86400000L;
        LogCleanerMinCompactionLagMs = 0L;
        LogCleanerMaxCompactionLagMs = Long.MAX_VALUE;
        LogIndexSizeMaxBytes = 0xA00000;
        LogIndexIntervalBytes = 4096;
        LogFlushIntervalMessages = Long.MAX_VALUE;
        LogDeleteDelayMs = 60000;
        LogFlushSchedulerIntervalMs = Long.MAX_VALUE;
        LogFlushOffsetCheckpointIntervalMs = 60000;
        LogFlushStartOffsetCheckpointIntervalMs = 60000;
        LogPreAllocateEnable = false;
        LogMessageTimestampType = "CreateTime";
        LogMessageTimestampDifferenceMaxMs = Long.MAX_VALUE;
        NumRecoveryThreadsPerDataDir = 1;
        AutoCreateTopicsEnable = true;
        MinInSyncReplicas = 1;
        MessageDownConversionEnable = true;
        ControllerSocketTimeoutMs = MODULE$.RequestTimeoutMs();
        ControllerMessageQueueSize = Integer.MAX_VALUE;
        DefaultReplicationFactor = 1;
        ReplicaLagTimeMaxMs = 30000L;
        ReplicaSocketTimeoutMs = 30000;
        ReplicaSocketReceiveBufferBytes = 65536;
        ReplicaFetchMaxBytes = 0x100000;
        ReplicaFetchWaitMaxMs = 500;
        ReplicaFetchMinBytes = 1;
        ReplicaFetchResponseMaxBytes = 0xA00000;
        NumReplicaFetchers = 1;
        ReplicaFetchBackoffMs = 1000;
        ReplicaHighWatermarkCheckpointIntervalMs = 5000L;
        FetchPurgatoryPurgeIntervalRequests = 1000;
        ProducerPurgatoryPurgeIntervalRequests = 1000;
        DeleteRecordsPurgatoryPurgeIntervalRequests = 1;
        AutoLeaderRebalanceEnable = true;
        LeaderImbalancePerBrokerPercentage = 10;
        LeaderImbalanceCheckIntervalSeconds = 300;
        UncleanLeaderElectionEnable = false;
        InterBrokerSecurityProtocol = SecurityProtocol.PLAINTEXT.toString();
        InterBrokerProtocolVersion = ApiVersion$.MODULE$.latestVersion().toString();
        ControlledShutdownMaxRetries = 3;
        ControlledShutdownRetryBackoffMs = 5000;
        ControlledShutdownEnable = true;
        GroupMinSessionTimeoutMs = 6000;
        GroupMaxSessionTimeoutMs = 1800000;
        GroupInitialRebalanceDelayMs = 3000;
        GroupMaxSize = Integer.MAX_VALUE;
        OffsetMetadataMaxSize = OffsetConfig$.MODULE$.DefaultMaxMetadataSize();
        OffsetsLoadBufferSize = OffsetConfig$.MODULE$.DefaultLoadBufferSize();
        OffsetsTopicReplicationFactor = OffsetConfig$.MODULE$.DefaultOffsetsTopicReplicationFactor();
        OffsetsTopicPartitions = OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions();
        OffsetsTopicSegmentBytes = OffsetConfig$.MODULE$.DefaultOffsetsTopicSegmentBytes();
        OffsetsTopicCompressionCodec = OffsetConfig$.MODULE$.DefaultOffsetsTopicCompressionCodec().codec();
        OffsetsRetentionMinutes = 10080;
        OffsetsRetentionCheckIntervalMs = OffsetConfig$.MODULE$.DefaultOffsetsRetentionCheckIntervalMs();
        OffsetCommitTimeoutMs = OffsetConfig$.MODULE$.DefaultOffsetCommitTimeoutMs();
        OffsetCommitRequiredAcks = OffsetConfig$.MODULE$.DefaultOffsetCommitRequiredAcks();
        TransactionalIdExpirationMs = TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
        TransactionsMaxTimeoutMs = TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
        TransactionsTopicMinISR = TransactionLog$.MODULE$.DefaultMinInSyncReplicas();
        TransactionsLoadBufferSize = TransactionLog$.MODULE$.DefaultLoadBufferSize();
        TransactionsTopicReplicationFactor = TransactionLog$.MODULE$.DefaultReplicationFactor();
        TransactionsTopicPartitions = TransactionLog$.MODULE$.DefaultNumPartitions();
        TransactionsTopicSegmentBytes = TransactionLog$.MODULE$.DefaultSegmentBytes();
        TransactionsAbortTimedOutTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
        TransactionsRemoveExpiredTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
        MaxIncrementalFetchSessionCacheSlots = 1000;
        FetchMaxBytes = 0x3700000;
        ProducerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaDefault();
        ConsumerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaDefault();
        NumQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        QuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        NumReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        ReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        NumAlterLogDirsReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        AlterLogDirsReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        NumControllerQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        ControllerQuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        TransactionalIdExpirationMsDefault = 604800000;
        DeleteTopicEnable = true;
        CompressionType = "producer";
        MaxIdMapSnapshots = 2;
        MetricNumSamples = 2;
        MetricSampleWindowMs = 30000;
        MetricReporterClasses = "";
        MetricRecordingLevel = Sensor.RecordingLevel.INFO.toString();
        KafkaMetricReporterClasses = "";
        KafkaMetricsPollingIntervalSeconds = 10;
        SslProtocol = SslConfigs.DEFAULT_SSL_PROTOCOL;
        SslEnabledProtocols = SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS;
        SslKeystoreType = "JKS";
        SslTruststoreType = "JKS";
        SslKeyManagerAlgorithm = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
        SslTrustManagerAlgorithm = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
        SslEndpointIdentificationAlgorithm = "https";
        SslClientAuthentication = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
        SslClientAuthenticationValidValues = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(SslClientAuth.VALUES).asScala().map((Function1 & Serializable)v -> v.toString().toLowerCase(Locale.ROOT))).asJava().toArray(new String[0]);
        SslPrincipalMappingRules = "DEFAULT";
        ConnectionsMaxReauthMsDefault = 0L;
        SaslMechanismInterBrokerProtocol = "GSSAPI";
        SaslEnabledMechanisms = BrokerSecurityConfigs.DEFAULT_SASL_ENABLED_MECHANISMS;
        SaslKerberosKinitCmd = "/usr/bin/kinit";
        SaslKerberosTicketRenewWindowFactor = 0.8;
        SaslKerberosTicketRenewJitter = 0.05;
        SaslKerberosMinTimeBeforeRelogin = 60000L;
        SaslKerberosPrincipalToLocalRules = BrokerSecurityConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
        SaslLoginRefreshWindowFactor = 0.8;
        SaslLoginRefreshWindowJitter = 0.05;
        SaslLoginRefreshMinPeriodSeconds = (short)60;
        SaslLoginRefreshBufferSeconds = (short)300;
        DelegationTokenMaxLifeTimeMsDefault = 604800000L;
        DelegationTokenExpiryTimeMsDefault = 86400000L;
        DelegationTokenExpiryCheckIntervalMsDefault = 3600000L;
        PasswordEncoderCipherAlgorithm = "AES/CBC/PKCS5Padding";
        PasswordEncoderKeyLength = 128;
        PasswordEncoderIterations = 4096;
        QuorumVoters = RaftConfig.DEFAULT_QUORUM_VOTERS;
        QuorumElectionTimeoutMs = 1000;
        QuorumFetchTimeoutMs = 2000;
        QuorumElectionBackoffMs = 1000;
        QuorumLingerMs = 25;
        QuorumRequestTimeoutMs = 2000;
        QuorumRetryBackoffMs = 20;
    }

    public int ZkSessionTimeoutMs() {
        return ZkSessionTimeoutMs;
    }

    public int ZkSyncTimeMs() {
        return ZkSyncTimeMs;
    }

    public boolean ZkEnableSecureAcls() {
        return ZkEnableSecureAcls;
    }

    public int ZkMaxInFlightRequests() {
        return ZkMaxInFlightRequests;
    }

    public boolean ZkSslClientEnable() {
        return ZkSslClientEnable;
    }

    public String ZkSslProtocol() {
        return ZkSslProtocol;
    }

    public String ZkSslEndpointIdentificationAlgorithm() {
        return ZkSslEndpointIdentificationAlgorithm;
    }

    public boolean ZkSslCrlEnable() {
        return ZkSslCrlEnable;
    }

    public boolean ZkSslOcspEnable() {
        return ZkSslOcspEnable;
    }

    public boolean BrokerIdGenerationEnable() {
        return BrokerIdGenerationEnable;
    }

    public int MaxReservedBrokerId() {
        return MaxReservedBrokerId;
    }

    public int BrokerId() {
        return BrokerId;
    }

    public int MessageMaxBytes() {
        return MessageMaxBytes;
    }

    public int NumNetworkThreads() {
        return NumNetworkThreads;
    }

    public int NumIoThreads() {
        return NumIoThreads;
    }

    public int BackgroundThreads() {
        return BackgroundThreads;
    }

    public int QueuedMaxRequests() {
        return QueuedMaxRequests;
    }

    public int QueuedMaxRequestBytes() {
        return QueuedMaxRequestBytes;
    }

    public int InitialBrokerRegistrationTimeoutMs() {
        return InitialBrokerRegistrationTimeoutMs;
    }

    public int BrokerHeartbeatIntervalMs() {
        return BrokerHeartbeatIntervalMs;
    }

    public int BrokerSessionTimeoutMs() {
        return BrokerSessionTimeoutMs;
    }

    public int EmptyNodeId() {
        return EmptyNodeId;
    }

    public String AuthorizerClassName() {
        return AuthorizerClassName;
    }

    public int Port() {
        return Port;
    }

    public String HostName() {
        return HostName;
    }

    public String ListenerSecurityProtocolMap() {
        return ListenerSecurityProtocolMap;
    }

    public int SocketSendBufferBytes() {
        return SocketSendBufferBytes;
    }

    public int SocketReceiveBufferBytes() {
        return SocketReceiveBufferBytes;
    }

    public int SocketRequestMaxBytes() {
        return SocketRequestMaxBytes;
    }

    public int MaxConnectionsPerIp() {
        return MaxConnectionsPerIp;
    }

    public String MaxConnectionsPerIpOverrides() {
        return MaxConnectionsPerIpOverrides;
    }

    public int MaxConnections() {
        return MaxConnections;
    }

    public int MaxConnectionCreationRate() {
        return MaxConnectionCreationRate;
    }

    public long ConnectionsMaxIdleMs() {
        return ConnectionsMaxIdleMs;
    }

    public int RequestTimeoutMs() {
        return RequestTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMs() {
        return ConnectionSetupTimeoutMs;
    }

    public Long ConnectionSetupTimeoutMaxMs() {
        return ConnectionSetupTimeoutMaxMs;
    }

    public int FailedAuthenticationDelayMs() {
        return FailedAuthenticationDelayMs;
    }

    public int NumPartitions() {
        return NumPartitions;
    }

    public String LogDir() {
        return LogDir;
    }

    public int LogSegmentBytes() {
        return LogSegmentBytes;
    }

    public int LogRollHours() {
        return LogRollHours;
    }

    public int LogRollJitterHours() {
        return LogRollJitterHours;
    }

    public int LogRetentionHours() {
        return LogRetentionHours;
    }

    public long LogRetentionBytes() {
        return LogRetentionBytes;
    }

    public long LogCleanupIntervalMs() {
        return LogCleanupIntervalMs;
    }

    public String Delete() {
        return Delete;
    }

    public String Compact() {
        return Compact;
    }

    public String LogCleanupPolicy() {
        return LogCleanupPolicy;
    }

    public int LogCleanerThreads() {
        return LogCleanerThreads;
    }

    public double LogCleanerIoMaxBytesPerSecond() {
        return LogCleanerIoMaxBytesPerSecond;
    }

    public long LogCleanerDedupeBufferSize() {
        return LogCleanerDedupeBufferSize;
    }

    public int LogCleanerIoBufferSize() {
        return LogCleanerIoBufferSize;
    }

    public double LogCleanerDedupeBufferLoadFactor() {
        return LogCleanerDedupeBufferLoadFactor;
    }

    public int LogCleanerBackoffMs() {
        return LogCleanerBackoffMs;
    }

    public double LogCleanerMinCleanRatio() {
        return LogCleanerMinCleanRatio;
    }

    public boolean LogCleanerEnable() {
        return LogCleanerEnable;
    }

    public long LogCleanerDeleteRetentionMs() {
        return LogCleanerDeleteRetentionMs;
    }

    public long LogCleanerMinCompactionLagMs() {
        return LogCleanerMinCompactionLagMs;
    }

    public long LogCleanerMaxCompactionLagMs() {
        return LogCleanerMaxCompactionLagMs;
    }

    public int LogIndexSizeMaxBytes() {
        return LogIndexSizeMaxBytes;
    }

    public int LogIndexIntervalBytes() {
        return LogIndexIntervalBytes;
    }

    public long LogFlushIntervalMessages() {
        return LogFlushIntervalMessages;
    }

    public int LogDeleteDelayMs() {
        return LogDeleteDelayMs;
    }

    public long LogFlushSchedulerIntervalMs() {
        return LogFlushSchedulerIntervalMs;
    }

    public int LogFlushOffsetCheckpointIntervalMs() {
        return LogFlushOffsetCheckpointIntervalMs;
    }

    public int LogFlushStartOffsetCheckpointIntervalMs() {
        return LogFlushStartOffsetCheckpointIntervalMs;
    }

    public boolean LogPreAllocateEnable() {
        return LogPreAllocateEnable;
    }

    private String LogMessageFormatVersion$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                LogMessageFormatVersion = this.InterBrokerProtocolVersion();
                bitmap$0 = true;
            }
        }
        return LogMessageFormatVersion;
    }

    public String LogMessageFormatVersion() {
        if (!bitmap$0) {
            return this.LogMessageFormatVersion$lzycompute();
        }
        return LogMessageFormatVersion;
    }

    public String LogMessageTimestampType() {
        return LogMessageTimestampType;
    }

    public long LogMessageTimestampDifferenceMaxMs() {
        return LogMessageTimestampDifferenceMaxMs;
    }

    public int NumRecoveryThreadsPerDataDir() {
        return NumRecoveryThreadsPerDataDir;
    }

    public boolean AutoCreateTopicsEnable() {
        return AutoCreateTopicsEnable;
    }

    public int MinInSyncReplicas() {
        return MinInSyncReplicas;
    }

    public boolean MessageDownConversionEnable() {
        return MessageDownConversionEnable;
    }

    public int ControllerSocketTimeoutMs() {
        return ControllerSocketTimeoutMs;
    }

    public int ControllerMessageQueueSize() {
        return ControllerMessageQueueSize;
    }

    public int DefaultReplicationFactor() {
        return DefaultReplicationFactor;
    }

    public long ReplicaLagTimeMaxMs() {
        return ReplicaLagTimeMaxMs;
    }

    public int ReplicaSocketTimeoutMs() {
        return ReplicaSocketTimeoutMs;
    }

    public int ReplicaSocketReceiveBufferBytes() {
        return ReplicaSocketReceiveBufferBytes;
    }

    public int ReplicaFetchMaxBytes() {
        return ReplicaFetchMaxBytes;
    }

    public int ReplicaFetchWaitMaxMs() {
        return ReplicaFetchWaitMaxMs;
    }

    public int ReplicaFetchMinBytes() {
        return ReplicaFetchMinBytes;
    }

    public int ReplicaFetchResponseMaxBytes() {
        return ReplicaFetchResponseMaxBytes;
    }

    public int NumReplicaFetchers() {
        return NumReplicaFetchers;
    }

    public int ReplicaFetchBackoffMs() {
        return ReplicaFetchBackoffMs;
    }

    public long ReplicaHighWatermarkCheckpointIntervalMs() {
        return ReplicaHighWatermarkCheckpointIntervalMs;
    }

    public int FetchPurgatoryPurgeIntervalRequests() {
        return FetchPurgatoryPurgeIntervalRequests;
    }

    public int ProducerPurgatoryPurgeIntervalRequests() {
        return ProducerPurgatoryPurgeIntervalRequests;
    }

    public int DeleteRecordsPurgatoryPurgeIntervalRequests() {
        return DeleteRecordsPurgatoryPurgeIntervalRequests;
    }

    public boolean AutoLeaderRebalanceEnable() {
        return AutoLeaderRebalanceEnable;
    }

    public int LeaderImbalancePerBrokerPercentage() {
        return LeaderImbalancePerBrokerPercentage;
    }

    public int LeaderImbalanceCheckIntervalSeconds() {
        return LeaderImbalanceCheckIntervalSeconds;
    }

    public boolean UncleanLeaderElectionEnable() {
        return UncleanLeaderElectionEnable;
    }

    public String InterBrokerSecurityProtocol() {
        return InterBrokerSecurityProtocol;
    }

    public String InterBrokerProtocolVersion() {
        return InterBrokerProtocolVersion;
    }

    public int ControlledShutdownMaxRetries() {
        return ControlledShutdownMaxRetries;
    }

    public int ControlledShutdownRetryBackoffMs() {
        return ControlledShutdownRetryBackoffMs;
    }

    public boolean ControlledShutdownEnable() {
        return ControlledShutdownEnable;
    }

    public int GroupMinSessionTimeoutMs() {
        return GroupMinSessionTimeoutMs;
    }

    public int GroupMaxSessionTimeoutMs() {
        return GroupMaxSessionTimeoutMs;
    }

    public int GroupInitialRebalanceDelayMs() {
        return GroupInitialRebalanceDelayMs;
    }

    public int GroupMaxSize() {
        return GroupMaxSize;
    }

    public int OffsetMetadataMaxSize() {
        return OffsetMetadataMaxSize;
    }

    public int OffsetsLoadBufferSize() {
        return OffsetsLoadBufferSize;
    }

    public short OffsetsTopicReplicationFactor() {
        return OffsetsTopicReplicationFactor;
    }

    public int OffsetsTopicPartitions() {
        return OffsetsTopicPartitions;
    }

    public int OffsetsTopicSegmentBytes() {
        return OffsetsTopicSegmentBytes;
    }

    public int OffsetsTopicCompressionCodec() {
        return OffsetsTopicCompressionCodec;
    }

    public int OffsetsRetentionMinutes() {
        return OffsetsRetentionMinutes;
    }

    public long OffsetsRetentionCheckIntervalMs() {
        return OffsetsRetentionCheckIntervalMs;
    }

    public int OffsetCommitTimeoutMs() {
        return OffsetCommitTimeoutMs;
    }

    public short OffsetCommitRequiredAcks() {
        return OffsetCommitRequiredAcks;
    }

    public int TransactionalIdExpirationMs() {
        return TransactionalIdExpirationMs;
    }

    public int TransactionsMaxTimeoutMs() {
        return TransactionsMaxTimeoutMs;
    }

    public int TransactionsTopicMinISR() {
        return TransactionsTopicMinISR;
    }

    public int TransactionsLoadBufferSize() {
        return TransactionsLoadBufferSize;
    }

    public short TransactionsTopicReplicationFactor() {
        return TransactionsTopicReplicationFactor;
    }

    public int TransactionsTopicPartitions() {
        return TransactionsTopicPartitions;
    }

    public int TransactionsTopicSegmentBytes() {
        return TransactionsTopicSegmentBytes;
    }

    public int TransactionsAbortTimedOutTransactionsCleanupIntervalMS() {
        return TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    }

    public int TransactionsRemoveExpiredTransactionsCleanupIntervalMS() {
        return TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    }

    public int MaxIncrementalFetchSessionCacheSlots() {
        return MaxIncrementalFetchSessionCacheSlots;
    }

    public int FetchMaxBytes() {
        return FetchMaxBytes;
    }

    public long ProducerQuotaBytesPerSecondDefault() {
        return ProducerQuotaBytesPerSecondDefault;
    }

    public long ConsumerQuotaBytesPerSecondDefault() {
        return ConsumerQuotaBytesPerSecondDefault;
    }

    public int NumQuotaSamples() {
        return NumQuotaSamples;
    }

    public int QuotaWindowSizeSeconds() {
        return QuotaWindowSizeSeconds;
    }

    public int NumReplicationQuotaSamples() {
        return NumReplicationQuotaSamples;
    }

    public int ReplicationQuotaWindowSizeSeconds() {
        return ReplicationQuotaWindowSizeSeconds;
    }

    public int NumAlterLogDirsReplicationQuotaSamples() {
        return NumAlterLogDirsReplicationQuotaSamples;
    }

    public int AlterLogDirsReplicationQuotaWindowSizeSeconds() {
        return AlterLogDirsReplicationQuotaWindowSizeSeconds;
    }

    public int NumControllerQuotaSamples() {
        return NumControllerQuotaSamples;
    }

    public int ControllerQuotaWindowSizeSeconds() {
        return ControllerQuotaWindowSizeSeconds;
    }

    public int TransactionalIdExpirationMsDefault() {
        return TransactionalIdExpirationMsDefault;
    }

    public boolean DeleteTopicEnable() {
        return DeleteTopicEnable;
    }

    public String CompressionType() {
        return CompressionType;
    }

    public int MaxIdMapSnapshots() {
        return MaxIdMapSnapshots;
    }

    public int MetricNumSamples() {
        return MetricNumSamples;
    }

    public int MetricSampleWindowMs() {
        return MetricSampleWindowMs;
    }

    public String MetricReporterClasses() {
        return MetricReporterClasses;
    }

    public String MetricRecordingLevel() {
        return MetricRecordingLevel;
    }

    public String KafkaMetricReporterClasses() {
        return KafkaMetricReporterClasses;
    }

    public int KafkaMetricsPollingIntervalSeconds() {
        return KafkaMetricsPollingIntervalSeconds;
    }

    public String SslProtocol() {
        return SslProtocol;
    }

    public String SslEnabledProtocols() {
        return SslEnabledProtocols;
    }

    public String SslKeystoreType() {
        return SslKeystoreType;
    }

    public String SslTruststoreType() {
        return SslTruststoreType;
    }

    public String SslKeyManagerAlgorithm() {
        return SslKeyManagerAlgorithm;
    }

    public String SslTrustManagerAlgorithm() {
        return SslTrustManagerAlgorithm;
    }

    public String SslEndpointIdentificationAlgorithm() {
        return SslEndpointIdentificationAlgorithm;
    }

    public String SslClientAuthentication() {
        return SslClientAuthentication;
    }

    public String[] SslClientAuthenticationValidValues() {
        return SslClientAuthenticationValidValues;
    }

    public String SslPrincipalMappingRules() {
        return SslPrincipalMappingRules;
    }

    public long ConnectionsMaxReauthMsDefault() {
        return ConnectionsMaxReauthMsDefault;
    }

    public String SaslMechanismInterBrokerProtocol() {
        return SaslMechanismInterBrokerProtocol;
    }

    public List<String> SaslEnabledMechanisms() {
        return SaslEnabledMechanisms;
    }

    public String SaslKerberosKinitCmd() {
        return SaslKerberosKinitCmd;
    }

    public double SaslKerberosTicketRenewWindowFactor() {
        return SaslKerberosTicketRenewWindowFactor;
    }

    public double SaslKerberosTicketRenewJitter() {
        return SaslKerberosTicketRenewJitter;
    }

    public long SaslKerberosMinTimeBeforeRelogin() {
        return SaslKerberosMinTimeBeforeRelogin;
    }

    public List<String> SaslKerberosPrincipalToLocalRules() {
        return SaslKerberosPrincipalToLocalRules;
    }

    public double SaslLoginRefreshWindowFactor() {
        return SaslLoginRefreshWindowFactor;
    }

    public double SaslLoginRefreshWindowJitter() {
        return SaslLoginRefreshWindowJitter;
    }

    public short SaslLoginRefreshMinPeriodSeconds() {
        return SaslLoginRefreshMinPeriodSeconds;
    }

    public short SaslLoginRefreshBufferSeconds() {
        return SaslLoginRefreshBufferSeconds;
    }

    public long DelegationTokenMaxLifeTimeMsDefault() {
        return DelegationTokenMaxLifeTimeMsDefault;
    }

    public long DelegationTokenExpiryTimeMsDefault() {
        return DelegationTokenExpiryTimeMsDefault;
    }

    public long DelegationTokenExpiryCheckIntervalMsDefault() {
        return DelegationTokenExpiryCheckIntervalMsDefault;
    }

    public String PasswordEncoderCipherAlgorithm() {
        return PasswordEncoderCipherAlgorithm;
    }

    public int PasswordEncoderKeyLength() {
        return PasswordEncoderKeyLength;
    }

    public int PasswordEncoderIterations() {
        return PasswordEncoderIterations;
    }

    public List<String> QuorumVoters() {
        return QuorumVoters;
    }

    public int QuorumElectionTimeoutMs() {
        return QuorumElectionTimeoutMs;
    }

    public int QuorumFetchTimeoutMs() {
        return QuorumFetchTimeoutMs;
    }

    public int QuorumElectionBackoffMs() {
        return QuorumElectionBackoffMs;
    }

    public int QuorumLingerMs() {
        return QuorumLingerMs;
    }

    public int QuorumRequestTimeoutMs() {
        return QuorumRequestTimeoutMs;
    }

    public int QuorumRetryBackoffMs() {
        return QuorumRetryBackoffMs;
    }

    private Defaults$() {
    }
}

