/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005u4AAD\b\u0001)!A1\u0006\u0001BC\u0002\u0013\u0005A\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u0003.\u0011!A\u0004A!b\u0001\n\u0003I\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011\u001d\u0003!Q1A\u0005\u0002!C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005#\")!\r\u0001C\u0001G\"9!\u000e\u0001b\u0001\n\u0013Y\u0007BB8\u0001A\u0003%A\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003s\u0001\u0011\u00053\u000fC\u0003z\u0001\u0011\u0005#P\u0001\tUQJ|G\u000f\u001e7fI\u000eC\u0017M\u001c8fY*\u0011\u0001#E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003I\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001+u)\u0003C\u0001\f\u001c\u001b\u00059\"B\u0001\r\u001a\u0003\u0011a\u0017M\\4\u000b\u0003i\tAA[1wC&\u0011Ad\u0006\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005y\u0019S\"A\u0010\u000b\u0005\u0001\n\u0013AC2p]\u000e,(O]3oi*\u0011!%G\u0001\u0005kRLG.\u0003\u0002%?\t9A)\u001a7bs\u0016$\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0012\u0003\u0015)H/\u001b7t\u0013\tQsEA\u0004M_\u001e<\u0017N\\4\u0002\u000fI,\u0017/^3tiV\tQ\u0006\u0005\u0002/i9\u0011qFM\u0007\u0002a)\u0011\u0011'E\u0001\b]\u0016$xo\u001c:l\u0013\t\u0019\u0004'\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005U2$a\u0002*fcV,7\u000f\u001e\u0006\u0003gA\n\u0001B]3rk\u0016\u001cH\u000fI\u0001\u0005i&lW-F\u0001;!\tYD)D\u0001=\u0015\tASH\u0003\u0002?\u007f\u000511m\\7n_:T!A\u0005!\u000b\u0005\u0005\u0013\u0015AB1qC\u000eDWMC\u0001D\u0003\ry'oZ\u0005\u0003\u000br\u0012A\u0001V5nK\u0006)A/[7fA\u0005qA\u000f\u001b:piRdW\rV5nK6\u001bX#A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\u0007%sG/A\buQJ|G\u000f\u001e7f)&lW-T:!\u0003e\u0019\u0007.\u00198oK2$\u0006N]8ui2LgnZ\"bY2\u0014\u0017mY6\u0011\t)\u0013FkX\u0005\u0003'.\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0005UkfB\u0001,3\u001d\t9FL\u0004\u0002Y76\t\u0011L\u0003\u0002['\u00051AH]8pizJ\u0011AE\u0005\u0003cEI!A\u0018\u001c\u0003\u0011I+7\u000f]8og\u0016\u0004\"A\u00131\n\u0005\u0005\\%\u0001B+oSR\fa\u0001P5oSRtD#\u00023gO\"L\u0007CA3\u0001\u001b\u0005y\u0001\"B\u0016\t\u0001\u0004i\u0003\"\u0002\u001d\t\u0001\u0004Q\u0004\"B$\t\u0001\u0004I\u0005\"\u0002)\t\u0001\u0004\t\u0016\u0001D3oIRKW.\u001a(b]>\u001cX#\u00017\u0011\u0005)k\u0017B\u00018L\u0005\u0011auN\\4\u0002\u001b\u0015tG\rV5nK:\u000bgn\\:!\u0003Qqw\u000e^5gsRC'o\u001c;uY&tw\rR8oKR\tq,\u0001\u0005hKR$U\r\\1z)\taG\u000fC\u0003v\u0019\u0001\u0007a/\u0001\u0003v]&$\bC\u0001\u0010x\u0013\tAxD\u0001\u0005US6,WK\\5u\u0003%\u0019w.\u001c9be\u0016$v\u000e\u0006\u0002Jw\")A0\u0004a\u0001;\u0005\tA\r")
public class ThrottledChannel
implements Delayed,
Logging {
    private final RequestChannel.Request request;
    private final Time time;
    private final int throttleTimeMs;
    private final Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback;
    private final long endTimeNanos;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel.Request request() {
        return this.request;
    }

    public Time time() {
        return this.time;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    private long endTimeNanos() {
        return this.endTimeNanos;
    }

    public void notifyThrottlingDone() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Channel throttled for: ").append(this.throttleTimeMs()).append(" ms").toString());
        this.channelThrottlingCallback.apply((Object)new RequestChannel.EndThrottlingResponse(this.request()));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTimeNanos() - this.time().nanoseconds(), TimeUnit.NANOSECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        ThrottledChannel other = (ThrottledChannel)d;
        return Long.compare(this.endTimeNanos(), other.endTimeNanos());
    }

    public ThrottledChannel(RequestChannel.Request request, Time time, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        this.request = request;
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.channelThrottlingCallback = channelThrottlingCallback;
        this.endTimeNanos = time.nanoseconds() + TimeUnit.MILLISECONDS.toNanos(throttleTimeMs);
        channelThrottlingCallback.apply((Object)new RequestChannel.StartThrottlingResponse(request));
    }
}

