/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.AppendOrigin$Coordinator$;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.UncompressedCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.FetchLogEnd$;
import kafka.server.ReplicaManager;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rUs!\u0002!B\u0011\u0003Ae!\u0002&B\u0011\u0003Y\u0005\"\u0002*\u0002\t\u0003\u0019\u0006b\u0002+\u0002\u0005\u0004%\t!\u0016\u0005\u00073\u0006\u0001\u000b\u0011\u0002,\t\u000fi\u000b!\u0019!C\u0001+\"11,\u0001Q\u0001\nYCq\u0001X\u0001C\u0002\u0013\u0005Q\u000b\u0003\u0004^\u0003\u0001\u0006IA\u0016\u0005\b=\u0006\u0011\r\u0011\"\u0001V\u0011\u0019y\u0016\u0001)A\u0005-\"9\u0001-\u0001b\u0001\n\u0003\t\u0007BB7\u0002A\u0003%!\rC\u0004o\u0003\t\u0007I\u0011A1\t\r=\f\u0001\u0015!\u0003c\r\u0011Q\u0015\t\u00019\t\u0011]|!\u0011!Q\u0001\nYC\u0001\u0002_\b\u0003\u0002\u0003\u0006I!\u001f\u0005\ty>\u0011\t\u0011)A\u0005{\"Q\u0011qA\b\u0003\u0002\u0003\u0006I!!\u0003\t\u0015\u0005=qB!A!\u0002\u0013\t\t\u0002\u0003\u0006\u0002*=\u0011\t\u0011)A\u0005\u0003WAaAU\b\u0005\u0002\u0005URABA#\u001f\u0001\t9\u0005C\u0005\u0002l=\u0011\r\u0011\"\u0003\u0002n!A\u0011qQ\b!\u0002\u0013\ty\u0007C\u0005\u0002\n>\u0011\r\u0011\"\u0003\u0002\f\"A\u0011\u0011T\b!\u0002\u0013\ti\t\u0003\u0006\u0002\u001c>\u0011\r\u0011\"\u0001B\u0003;C\u0001\"!.\u0010A\u0003%\u0011q\u0014\u0005\u000b\u0003o{!\u0019!C\u0001\u0003\u0006e\u0006\u0002CAd\u001f\u0001\u0006I!a/\t\u0017\u0005%w\u00021AA\u0002\u0013%\u00111\u001a\u0005\f\u0003'|\u0001\u0019!a\u0001\n\u0013\t)\u000eC\u0006\u0002\\>\u0001\r\u0011!Q!\n\u00055\u0007BCAo\u001f\u0001\u0007\t\u0019!C\u0005+\"Y\u0011q\\\bA\u0002\u0003\u0007I\u0011BAq\u0011)\t)o\u0004a\u0001\u0002\u0003\u0006KA\u0016\u0005\n\u0003_|!\u0019!C\u0005\u0003cD\u0001\"!?\u0010A\u0003%\u00111\u001f\u0005\t\u0003w|A\u0011A!\u0002~\"9!qA\b\u0005\u0002\t%\u0001b\u0002B\u0012\u001f\u0011%!Q\u0005\u0005\b\u0005oyA\u0011\u0002B\u001d\u0011\u001d\u0011ye\u0004C\u0005\u0005#B\u0001Ba\t\u0010\t\u0003\t%q\r\u0005\b\u0005SzA\u0011\u0002B6\u0011\u001d\u0011)i\u0004C\u0001\u0005OBqAa\"\u0010\t\u0003\u0011I\tC\u0004\u0003.>!\tAa,\t\u000f\tUv\u0002\"\u0003\u00038\"9!\u0011Y\b\u0005\u0002\t\r\u0007b\u0002Be\u001f\u0011\u0005!1\u001a\u0005\b\u0005+|A\u0011\u0001Bl\u0011\u001d\u0011Yn\u0004C\u0005\u0005;D\u0001Ba;\u0010\t\u0003\t%Q\u001e\u0005\b\u0005s|A\u0011\u0001B~\u0011\u001d\u0019Ia\u0004C\u0001\u0007\u0017Aqa!\u0003\u0010\t\u0003\u0019y\u0001C\u0004\u0004\u0016=!IAa\u001a\t\u000f\r]q\u0002\"\u0001\u0004\u001a!I11G\b\u0012\u0002\u0013\u00051Q\u0007\u0005\b\u0007\u0017zA\u0011AB'\u0011\u001d\u0019\u0019f\u0004C\u0001\u0005O\nq\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3NC:\fw-\u001a:\u000b\u0005\t\u001b\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001R#\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\r\u0006)1.\u00194lC\u000e\u0001\u0001CA%\u0002\u001b\u0005\t%a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s'\t\tA\n\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJ\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u000bq\u0004R3gCVdG\u000f\u0016:b]N\f7\r^5p]Nl\u0015\r\u001f+j[\u0016|W\u000f^'t+\u00051\u0006CA'X\u0013\tAfJA\u0002J]R\f\u0001\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]Nl\u0015\r\u001f+j[\u0016|W\u000f^'tA\u0005\u0011C)\u001a4bk2$HK]1og\u0006\u001cG/[8oC2LE-\u0012=qSJ\fG/[8o\u001bN\f1\u0005R3gCVdG\u000f\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ#ya&\u0014\u0018\r^5p]6\u001b\b%\u0001\u0016EK\u001a\fW\u000f\u001c;BE>\u0014H\u000fV5nK\u0012|U\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001c\u0018J\u001c;feZ\fG.T:\u0002W\u0011+g-Y;mi\u0006\u0013wN\u001d;US6,GmT;u)J\fgn]1di&|gn]%oi\u0016\u0014h/\u00197Ng\u0002\na\u0006R3gCVdGOU3n_Z,W\t\u001f9je\u0016$GK]1og\u0006\u001cG/[8oC2LEm]%oi\u0016\u0014h/\u00197Ng\u0006yC)\u001a4bk2$(+Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7/\u00138uKJ4\u0018\r\\'tA\u0005aQ*\u001a;sS\u000e\u001cxI]8vaV\t!\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003K:k\u0011A\u001a\u0006\u0003O\u001e\u000ba\u0001\u0010:p_Rt\u0014BA5O\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%t\u0015!D'fiJL7m]$s_V\u0004\b%\u0001\bM_\u0006$G+[7f'\u0016t7o\u001c:\u0002\u001f1{\u0017\r\u001a+j[\u0016\u001cVM\\:pe\u0002\u001a2a\u0004'r!\t\u0011X/D\u0001t\u0015\t!X)A\u0003vi&d7/\u0003\u0002wg\n9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\bC\u0001:{\u0013\tY8OA\u0005TG\",G-\u001e7fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bc\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u0015\u000baa]3sm\u0016\u0014\u0018bAA\u0003\u007f\nq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw\rE\u0002J\u0003\u0017I1!!\u0004B\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0003\u0002\u0014\u0005\u0015RBAA\u000b\u0015\r!\u0018q\u0003\u0006\u0005\u00033\tY\"\u0001\u0004d_6lwN\u001c\u0006\u0004\r\u0006u!\u0002BA\u0010\u0003C\ta!\u00199bG\",'BAA\u0012\u0003\ry'oZ\u0005\u0005\u0003O\t)B\u0001\u0003US6,\u0017aB7fiJL7m\u001d\t\u0005\u0003[\t\t$\u0004\u0002\u00020)!\u0011\u0011FA\f\u0013\u0011\t\u0019$a\f\u0003\u000f5+GO]5dgRq\u0011qGA\u001d\u0003w\ti$a\u0010\u0002B\u0005\r\u0003CA%\u0010\u0011\u00159h\u00031\u0001W\u0011\u0015Ah\u00031\u0001z\u0011\u0015ah\u00031\u0001~\u0011\u001d\t9A\u0006a\u0001\u0003\u0013Aq!a\u0004\u0017\u0001\u0004\t\t\u0002C\u0004\u0002*Y\u0001\r!a\u000b\u0003-M+g\u000e\u001a+y]6\u000b'o[3sg\u000e\u000bG\u000e\u001c2bG.\u0004B\"TA%-\u00065\u0013\u0011LA0\u0003KJ1!a\u0013O\u0005%1UO\\2uS>tG\u0007\u0005\u0003\u0002P\u0005USBAA)\u0015\u0011\t\u0019&a\u0006\u0002\u0011I,\u0017/^3tiNLA!a\u0016\u0002R\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u0007%\u000bY&C\u0002\u0002^\u0005\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u00042!SA1\u0013\r\t\u0019'\u0011\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rE\u0002N\u0003OJ1!!\u001bO\u0005\u0011)f.\u001b;\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005=\u0004\u0003BA9\u0003\u0007k!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0007CR|W.[2\u000b\t\u0005e\u00141P\u0001\u000bG>t7-\u001e:sK:$(\u0002BA?\u0003\u007f\nA!\u001e;jY*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006M$!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$H/\u001b8h\t><h\u000eI\u0001\ngR\fG/\u001a'pG.,\"!!$\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#SA!a%\u0002x\u0005)An\\2lg&!\u0011qSAI\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017AC:uCR,Gj\\2lA\u0005\tBn\\1eS:<\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005}\u0005CBAQ\u0003W\u000by+\u0004\u0002\u0002$*!\u0011QUAT\u0003\u001diW\u000f^1cY\u0016T1!!+O\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\u000b\u0019KA\u0002TKR\u00042!SAY\u0013\r\t\u0019,\u0011\u0002#)J\fgn]1di&|g\u000eU1si&$\u0018n\u001c8B]\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0002%1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7\u000fI\u0001\u0019iJ\fgn]1di&|g.T3uC\u0012\fG/Y\"bG\",WCAA^!\u001d\t\t+!0W\u0003\u0003LA!a0\u0002$\n\u0019Q*\u00199\u0011\u0007%\u000b\u0019-C\u0002\u0002F\u0006\u0013Q\u0003\u0016=o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3F]R\u0014\u00180A\rue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013A\n:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiV\u0011\u0011Q\u001a\t\u0005\u001b\u0006=g+C\u0002\u0002R:\u0013\u0011BR;oGRLwN\u001c\u0019\u0002UI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtGo\u0018\u0013fcR!\u0011QMAl\u0011%\tI.IA\u0001\u0002\u0004\ti-A\u0002yIE\nqE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005qBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u0001#iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R|F%Z9\u0015\t\u0005\u0015\u00141\u001d\u0005\t\u00033$\u0013\u0011!a\u0001-\u0006yBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011)\u0007\u0015\nI\u000fE\u0002N\u0003WL1!!<O\u0005!1x\u000e\\1uS2,\u0017a\u00059beRLG/[8o\u0019>\fGmU3og>\u0014XCAAz!\u0011\ti#!>\n\t\u0005]\u0018q\u0006\u0002\u0007'\u0016t7o\u001c:\u0002)A\f'\u000f^5uS>tGj\\1e'\u0016t7o\u001c:!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\t)'a@\u0003\u0004!1!\u0011\u0001\u0015A\u0002Y\u000b1\u0002]1si&$\u0018n\u001c8JI\"1!Q\u0001\u0015A\u0002Y\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)QLW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\t\u0011Y\u0001\u0005\u0004\u0003\u000e\t]!Q\u0004\b\u0005\u0005\u001f\u0011\u0019BD\u0002f\u0005#I\u0011aT\u0005\u0004\u0005+q\u0015a\u00029bG.\fw-Z\u0005\u0005\u00053\u0011YB\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011)B\u0014\t\u0004\u0013\n}\u0011b\u0001B\u0011\u0003\n\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006i\"/Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0004\u0002f\t\u001d\"1\u0007\u0005\b\u0005SQ\u0003\u0019\u0001B\u0016\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]B!!Q\u0006B\u0018\u001b\t\t9\"\u0003\u0003\u00032\u0005]!A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005kQ\u0003\u0019AAa\u0003U!\bP\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\fAb\u001d5pk2$W\t\u001f9je\u0016$bAa\u000f\u0003B\t\u0015\u0003cA'\u0003>%\u0019!q\b(\u0003\u000f\t{w\u000e\\3b]\"9!1I\u0016A\u0002\u0005e\u0013a\u0003;y]6+G/\u00193bi\u0006DqAa\u0012,\u0001\u0004\u0011I%A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\t\u0004\u001b\n-\u0013b\u0001B'\u001d\n!Aj\u001c8h\u0003Ui\u0017-\u001f2f\u0003B\u0004XM\u001c3FqBL'/\u0019;j_:$\u0002Ba\u000f\u0003T\tU#Q\r\u0005\b\u0005\u0007b\u0003\u0019AA-\u0011\u001d\u00119\u0006\fa\u0001\u00053\naB]3d_J$7OQ;jY\u0012,'\u000f\u0005\u0003\u0003\\\t\u0005TB\u0001B/\u0015\u0011\u0011y&a\u0006\u0002\rI,7m\u001c:e\u0013\u0011\u0011\u0019G!\u0018\u0003)5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0005VLG\u000eZ3s\u0011\u001d\u00119\u0005\fa\u0001\u0005\u0013\"\"!!\u001a\u0002S]\u0014\u0018\u000e^3U_6\u00147\u000f^8oKN4uN]#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)!\t)G!\u001c\u0003p\tm\u0004b\u0002B\u0015]\u0001\u0007!1\u0006\u0005\b\u0005cr\u0003\u0019\u0001B:\u0003M)\u0007\u0010]5sK\u00124uN\u001d)beRLG/[8o!\u0019\u0011iAa\u0006\u0003vA\u0019\u0011Ja\u001e\n\u0007\te\u0014I\u0001\u0016Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0007>|'\u000fZ5oCR|'/\u00129pG\"\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\tud\u00061\u0001\u0003\u0000\u0005\u0001Bo\\7cgR|g.\u001a*fG>\u0014Hm\u001d\t\u0005\u00057\u0012\t)\u0003\u0003\u0003\u0004\nu#!D'f[>\u0014\u0018PU3d_J$7/A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\f1cZ3u)J\fgn]1di&|gn\u0015;bi\u0016$BAa#\u0003*BA!Q\u0002BG\u0005#\u0013i*\u0003\u0003\u0003\u0010\nm!AB#ji\",'\u000f\u0005\u0003\u0003\u0014\neUB\u0001BK\u0015\u0011\u00119*a\u0006\u0002\u0011A\u0014x\u000e^8d_2LAAa'\u0003\u0016\n1QI\u001d:peN\u0004R!\u0014BP\u0005GK1A!)O\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011J!*\n\u0007\t\u001d\u0016I\u0001\u0010D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG\r\u0016=o\u001b\u0016$\u0018\rZ1uC\"1!1\u0016\u0019A\u0002\t\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u001faV$HK]1og\u0006\u001cG/[8o'R\fG/Z%g\u001d>$X\t_5tiN$BA!-\u00034BA!Q\u0002BG\u0005#\u0013\u0019\u000bC\u0004\u0003DE\u0002\r!!\u0017\u0002=\u001d,G/\u00118e\u001b\u0006L(-Z!eIR\u0013\u0018M\\:bGRLwN\\*uCR,GC\u0002BF\u0005s\u0013Y\f\u0003\u0004\u0003,J\u0002\rA\u0019\u0005\b\u0005{\u0013\u0004\u0019\u0001B`\u0003U\u0019'/Z1uK\u0012$\u0006P\\'fi\u0006$\u0017\r^1PaR\u0004R!\u0014BP\u00033\nAD^1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000f\u0006\u0003\u0003<\t\u0015\u0007B\u0002Bdg\u0001\u0007a+\u0001\u0007uq:$\u0016.\\3pkRl5/A\fue\u0006t7/Y2uS>tGk\u001c9jG\u000e{gNZ5hgV\u0011!Q\u001a\t\u0005\u0005\u001f\u0014\t.\u0004\u0002\u0002|%!!1[A>\u0005)\u0001&o\u001c9feRLWm]\u0001\ra\u0006\u0014H/\u001b;j_:4uN\u001d\u000b\u0004-\ne\u0007B\u0002BVk\u0001\u0007!-A\fm_\u0006$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uCR1!q\u001cBs\u0005S\u0004bA\u001dBqE\u0006e\u0013b\u0001Brg\n!\u0001k\\8m\u0011\u001d\u00119O\u000ea\u0001\u0005W\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0003\u0006Y\u0002\rAV\u0001\u001dC\u0012$Gj\\1eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8t)>\u001c\u0015m\u00195f)!\t)Ga<\u0003t\nU\bB\u0002Byo\u0001\u0007a+A\tuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:DaA!\u00028\u0001\u00041\u0006b\u0002B|o\u0001\u0007!q\\\u0001\u0013Y>\fG-\u001a3Ue\u0006t7/Y2uS>t7/\u0001\u0013m_\u0006$GK]1og\u0006\u001cG/[8og\u001a{'\u000f\u0016=o)>\u0004\u0018n\u0019)beRLG/[8o)!\t)G!@\u0003\u0000\u000e\u0005\u0001B\u0002B\u0001q\u0001\u0007a\u000b\u0003\u0004\u0003\u0006a\u0002\rA\u0016\u0005\b\u0007\u0007A\u0004\u0019AB\u0003\u00039\u0019XM\u001c3Uq:l\u0015M]6feN\u00042aa\u0002\u0018\u001b\u0005y\u0011A\n:f[>4X\r\u0016:b]N\f7\r^5p]N4uN\u001d+y]R{\u0007/[2QCJ$\u0018\u000e^5p]R!\u0011QMB\u0007\u0011\u0019\u0011\t!\u000fa\u0001-R1\u0011QMB\t\u0007'AaA!\u0001;\u0001\u00041\u0006B\u0002B\u0003u\u0001\u0007a+\u0001\u0018wC2LG-\u0019;f)J\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]RL5o\u0015;bE2,\u0017AF1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4\u0015\u0019\u0005\u001541DB\u000f\u0007?\u0019\u0019c!\f\t\r\t-F\b1\u0001c\u0011\u0019\u0011)\u0001\u0010a\u0001-\"91\u0011\u0005\u001fA\u0002\u0005}\u0013a\u00038fo6+G/\u00193bi\u0006Dqa!\n=\u0001\u0004\u00199#\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB9Qj!\u000b\u0003\u0012\u0006\u0015\u0014bAB\u0016\u001d\nIa)\u001e8di&|g.\r\u0005\n\u0007_a\u0004\u0013!a\u0001\u0007c\tAB]3uef|e.\u0012:s_J\u0004r!TB\u0015\u0005#\u0013Y$\u0001\u0011baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000eT8hI\u0011,g-Y;mi\u0012*TCAB\u001cU\u0011\u0019\td!\u000f,\u0005\rm\u0002\u0003BB\u001f\u0007\u000fj!aa\u0010\u000b\t\r\u000531I\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0012O\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0013\u001ayDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqa\u001d;beR,\b\u000f\u0006\u0004\u0002f\r=3\u0011\u000b\u0005\b\u0003\u0013t\u0004\u0019AAg\u0011\u001d\u0011)I\u0010a\u0001\u0005w\t\u0001b\u001d5vi\u0012|wO\u001c")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        scala.collection.mutable.Iterable iterable;
        long now = this.time.milliseconds();
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    public void removeExpiredTransactionalIds() {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            this.replicaManager.appendRecords(this.config.requestTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition), (Object)tombstoneRecords)}))), (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responses -> {
                $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
                return BoxedUnit.UNIT;
            }, this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8());
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.removeExpiredTransactionalIds(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.config.removeExpiredTransactionalIdsIntervalMs(), this.scheduler.schedule$default$5());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable)x$3 -> (CoordinatorEpochAndTxnMetadata)x$3.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        Lock inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        props.put(LogConfig$.MODULE$.CompressionTypeProp(), UncompressedCodec$.MODULE$.name());
        props.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        props.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)None$.MODULE$);
        Option<Log> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            Log log = (Log)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    Lock inReadLock_inLock_lock = this.stateLock().readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    Object var15_14 = null;
                    Object var16_15 = null;
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchLogEnd$.MODULE$, true);
                    readAtLeastOneRecord = fetchDataInfo.records().sizeInBytes() > 0;
                    Records records = fetchDataInfo.records();
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().foreach((Function1 & Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(loadedTransactions, currOffset, batch, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return BoxedUnit.UNIT;
        });
    }

    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var8_6 = null;
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.schedule(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.loadTransactions$1(Predef$.MODULE$.long2Long(scheduleStartMs), topicPartition, coordinatorEpoch, partitionAndLeaderEpoch, sendTxnMarkers), this.scheduler.schedule$default$3(), this.scheduler.schedule$default$4(), this.scheduler.schedule$default$5());
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError) {
        keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        timestamp = this.time.milliseconds();
        var16_9 = new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)};
        withRecords_compressionType = TransactionLog$.MODULE$.EnforcedCompressionType();
        withRecords_magic = 2;
        var20_12 = TimestampType.CREATE_TIME;
        withRecords_initialOffset = 0L;
        var20_12 = null;
        var15_10 = null;
        var16_9 = null;
        records = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        inReadLock_inLock_lock = this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            block10: {
                block9: {
                    var21_18 = false;
                    var22_19 = null;
                    var23_20 = this.getTransactionState(transactionalId);
                    if (!(var23_20 instanceof Left)) break block9;
                    $anonfun$appendTransactionToLog$13_err = (Errors)((Left)var23_20).value();
                    (BoxedUnit)responseCallback.apply((Object)$anonfun$appendTransactionToLog$13_err);
                    break block10;
                }
                if (!(var23_20 instanceof Right)) ** GOTO lbl-1000
                var21_18 = true;
                var22_19 = (Right)var23_20;
                var25_22 = (Option)var22_19.value();
                if (None$.MODULE$.equals(var25_22)) {
                    (BoxedUnit)responseCallback.apply((Object)Errors.NOT_COORDINATOR);
                } else if (var21_18 && (var26_23 = (Option)var22_19.value()) instanceof Some) {
                    $anonfun$appendTransactionToLog$13_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var26_23).value();
                    if (BoxesRunTime.unboxToBoolean($anonfun$appendTransactionToLog$13_epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$appendTransactionToLog$14(kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 ), ()Z)((CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$13_epochAndMetadata, (int)coordinatorEpoch, responseCallback)))) {
                        this.replicaManager.appendRecords(newMetadata.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$appendTransactionToLog$15$adapted(kafka.coordinator.transaction.TransactionStateManager org.apache.kafka.common.TopicPartition java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int scala.Function1 scala.Function1 scala.collection.Map ), (Lscala/collection/Map;)Ljava/lang/Object;)((TransactionStateManager)this, (TopicPartition)topicPartition, (String)transactionalId, (TxnTransitMetadata)newMetadata, (int)coordinatorEpoch, retryOnError, responseCallback), this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8());
                        this.trace((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$16(kafka.coordinator.transaction.TxnTransitMetadata java.lang.String int ), ()Ljava/lang/String;)((TxnTransitMetadata)newMetadata, (String)transactionalId, (int)coordinatorEpoch));
                    }
                } else {
                    throw new MatchError(var23_20);
                }
            }
            var22_19 = null;
            var23_20 = null;
            var24_21 = null;
            var25_22 = null;
            var26_23 = null;
            var27_24 = null;
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$7));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (Ongoing$.MODULE$.equals(transactionState)) {
                return txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ scala.collection.mutable.Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (scala.collection.mutable.Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (IterableOnce)((IterableOps)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            Integer maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(package$.MODULE$.min(16384, Predef$.MODULE$.Integer2int(maxBatchSize))), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)Predef$.MODULE$.Integer2int(maxBatchSize));
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                    expired.clear();
                    recordsBuilder.elem = null;
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired.toSeq(), ((MemoryRecordsBuilder)recordsBuilder.elem).build());
                expired.clear();
                recordsBuilder.elem = null;
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(156).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        $this.transactionMetadataCache().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        Lock inReadLock_inLock_lock = $this.stateLock().readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        responses.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$4) {
        return x$4.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$4)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable)() -> createdTxnMetadata)));
            return scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable)x$5 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$5)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        }
        throw new MatchError((Object)option);
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable)() -> "Transaction state log's key should not be null");
        String transactionalId = TransactionLog$.MODULE$.readTxnRecordKey(record.key()).transactionalId();
        Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
        if (None$.MODULE$.equals(option)) {
            TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
        } else if (option instanceof Some) {
            TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
            loadedTransactions$1.put(transactionalId, txnMetadata);
        } else {
            throw new MatchError(option);
        }
        currOffset$1.elem = batch$1.nextOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    return txnMetadata.inLock((Function0 & Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError(null);
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition$3).append(" at epoch ").append(coordinatorEpoch$3).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition$3).append(" in ").append(totalLoadingTimeMs).append(" milliseconds, of which ").append(schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
        Lock inWriteLock_inLock_lock = this.stateLock().writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            if (this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
                this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions);
                ListBuffer $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion = new ListBuffer();
                loadedTransactions.foreach((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        String transactionalId = (String)x0$1._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                        return txnMetadata.inLock((Function0 & Serializable)() -> {
                            TransactionState transactionState = txnMetadata.state();
                            if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                            }
                            return BoxedUnit.UNIT;
                        });
                    }
                    throw new MatchError(null);
                });
                this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
                $anonfun$loadTransactionsForTxnTopicPartition$4_transactionsPendingForCompletion.foreach((Function1 & Serializable)txnTransitMetadata -> {
                    sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                    return BoxedUnit.UNIT;
                });
            }
            Object var15_11 = null;
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        Object var13_10 = null;
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition$3).append(" for coordinator epoch ").append(coordinatorEpoch$3).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$6) {
        return x$6.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((IterableOnce)$this.loadingPartitions().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$6))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var11_10 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            err = (Errors)((Left)var15_15).value();
                            this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var23_23 instanceof Left) {
                error = (Errors)((Left)var23_23).value();
                this.info((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                $this.replicaManager.appendRecords(newMetadata$1.txnTimeoutMs(), TransactionLog$.MODULE$.EnforcedRequiredAcks(), true, AppendOrigin$Coordinator$.MODULE$, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
                    $this.updateCacheCallback$1(responseStatus, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1);
                    return BoxedUnit.UNIT;
                }, $this.replicaManager.appendRecords$default$7(), $this.replicaManager.appendRecords$default$8());
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$7) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        void add_stat;
        void add_metricName;
        void add_stat2;
        void add_metricName2;
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        Sensor sensor = this.partitionLoadSensor();
        Max max = new Max();
        MetricName metricName = metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec");
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName2, (MeasurableStat)add_stat2, null);
        metricName = null;
        max = null;
        Sensor sensor2 = this.partitionLoadSensor();
        Avg avg = new Avg();
        MetricName metricName2 = metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec");
        if (sensor2 == null) {
            throw null;
        }
        sensor2.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
    }
}

