/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.ApiMessageAndVersion;
import org.apache.kafka.metalog.MetaLogManager;
import org.apache.kafka.raft.metadata.MetaLogRaftShim;
import org.apache.kafka.raft.metadata.MetadataRecordSerde;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\u001d:\u0001yB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"A\u0001\r\u0001B\u0001B\u0003%\u0011\rC\u0003p\u0001\u0011\u0005\u0001\u000f\u0003\u0006v\u0001A\u0005\t1!Q\u0001\nYD\u0011\"!\u0002\u0001\u0005\u0004%I!a\u0002\t\u000f\u0005%\u0001\u0001)A\u0005s\"I\u00111\u0002\u0001C\u0002\u0013%\u0011Q\u0002\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003}\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\u000b\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA\u0013\u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA)\u0011%\tY\u0007\u0001b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002|\u0001\u0001\u000b\u0011BA8\u0011%\ti\b\u0001b\u0001\n\u0013\ty\b\u0003\u0005\u0002\n\u0002\u0001\u000b\u0011BAA\u0011%\tY\t\u0001b\u0001\n\u0013\ti\t\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAH\u0011\u001d\tI\n\u0001C!\u00037Cq!a)\u0001\t\u0003\nY\nC\u0004\u0002&\u0002!\t%a'\b\u000f\u0005\u001d\u0016\b#\u0001\u0002*\u001a1\u0001(\u000fE\u0001\u0003WCaa\u001c\u000e\u0005\u0002\u00055\u0006\"CAX5\t\u0007I\u0011AAY\u0011!\t\u0019L\u0007Q\u0001\n\u0005\u0005\u0003\"CA[5\t\u0007I\u0011AA\\\u0011!\t\tM\u0007Q\u0001\n\u0005ef!CAb5A\u0005\u0019\u0013EAc\u000f\u001d\u0011iD\u0007EA\u0003W4q!!3\u001b\u0011\u0003\u000bY\r\u0003\u0004pE\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003[\u0014\u0013\u0011!C!\u0003cC\u0011\"a<#\u0003\u0003%\t!!=\t\u0013\u0005e(%!A\u0005\u0002\u0005m\b\"\u0003B\u0003E\u0005\u0005I\u0011\tB\u0004\u0011%\u0011yAIA\u0001\n\u0003\u0011\t\u0002C\u0005\u0003\u001c\t\n\t\u0011\"\u0011\u0003\u001e!I!q\u0004\u0012\u0002\u0002\u0013\u0005#\u0011\u0005\u0005\n\u0005G\u0011\u0013\u0011!C\u0005\u0005K9qAa\u0010\u001b\u0011\u0003\u0013\u0019DB\u0004\u0003.iA\tIa\f\t\r=lC\u0011\u0001B\u0019\u0011%\ti/LA\u0001\n\u0003\n\t\fC\u0005\u0002p6\n\t\u0011\"\u0001\u0002r\"I\u0011\u0011`\u0017\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u000bi\u0013\u0011!C!\u0005\u000fA\u0011Ba\u0004.\u0003\u0003%\tA!\u000f\t\u0013\tmQ&!A\u0005B\tu\u0001\"\u0003B\u0010[\u0005\u0005I\u0011\tB\u0011\u0011%\u0011\u0019#LA\u0001\n\u0013\u0011)\u0003C\u0004\u0003Bi!\tAa\u0011\u0003\u001f-\u000bgm[1SC\u001a$8+\u001a:wKJT!AO\u001e\u0002\rM,'O^3s\u0015\u0005a\u0014!B6bM.\f7\u0001A\n\u0005\u0001}*\u0015\n\u0005\u0002A\u00076\t\u0011IC\u0001C\u0003\u0015\u00198-\u00197b\u0013\t!\u0015I\u0001\u0004B]f\u0014VM\u001a\t\u0003\r\u001ek\u0011!O\u0005\u0003\u0011f\u0012aaU3sm\u0016\u0014\bC\u0001&N\u001b\u0005Y%B\u0001'<\u0003\u0015)H/\u001b7t\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\r\r|gNZ5h!\t1\u0015+\u0003\u0002Ss\tY1*\u00194lC\u000e{gNZ5h\u0003\u0011!\u0018.\\3\u0011\u0005UsV\"\u0001,\u000b\u00051;&B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011AH\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`-\n!A+[7f\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010E\u0002AE\u0012L!aY!\u0003\r=\u0003H/[8o!\t)GN\u0004\u0002gUB\u0011q-Q\u0007\u0002Q*\u0011\u0011.P\u0001\u0007yI|w\u000e\u001e \n\u0005-\f\u0015A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a[!\u0002\rqJg.\u001b;?)\u0011\t(o\u001d;\u0011\u0005\u0019\u0003\u0001\"B(\u0005\u0001\u0004\u0001\u0006\"B*\u0005\u0001\u0004!\u0006\"\u00021\u0005\u0001\u0004\t\u0017a\u0001=%cA!\u0001i^=}\u0013\tA\u0018I\u0001\u0004UkBdWM\r\t\u0003\rjL!a_\u001d\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB!Q0!\u0001e\u001b\u0005q(BA@B\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u0007q(aA*fc\u0006IQ.\u001a;b!J|\u0007o]\u000b\u0002s\u0006QQ.\u001a;b!J|\u0007o\u001d\u0011\u0002\u0017=4g\r\\5oK\u0012K'o]\u000b\u0002y\u0006aqN\u001a4mS:,G)\u001b:tA\u00059Q.\u001a;sS\u000e\u001cXCAA\u000b!\u0011\t9\"a\u0007\u000e\u0005\u0005e!bAA\t/&!\u0011QDA\r\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\t)\u0003\u0005\u0004\u0002(\u0005U\u0012\u0011H\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005=\u0012\u0011G\u0001\u0005kRLGN\u0003\u0002\u00024\u0005!!.\u0019<b\u0013\u0011\t9$!\u000b\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0004\u0002<\u0005u\u0012\u0011I\u0007\u0003\u0003[IA!a\u0010\u0002.\t!A*[:u!\u0011\t\u0019%!\u0013\u000e\u0005\u0005\u0015#\u0002BA$\u0003c\tA\u0001\\1oO&\u0019Q.!\u0012\u0002;\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sK\u0002\n1B]1gi6\u000bg.Y4feV\u0011\u0011\u0011\u000b\t\u0007\u0003'\nI&!\u0018\u000e\u0005\u0005U#bAA,w\u0005!!/\u00194u\u0013\u0011\tY&!\u0016\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\r\u0014,\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\t9'!\u0019\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!\u0003-iW\r^1M_\u001e\u001c\u0006.[7\u0016\u0005\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\t\u0005\r\u0014Q\u000f\u0006\u0004\u0003/J\u0016\u0002BA=\u0003g\u0012q\"T3uC2{wMU1giNC\u0017.\\\u0001\r[\u0016$\u0018\rT8h'\"LW\u000eI\u0001\u0007EJ|7.\u001a:\u0016\u0005\u0005\u0005\u0005\u0003\u0002!c\u0003\u0007\u00032ARAC\u0013\r\t9)\u000f\u0002\r\u0005J|7.\u001a:TKJ4XM]\u0001\bEJ|7.\u001a:!\u0003)\u0019wN\u001c;s_2dWM]\u000b\u0003\u0003\u001f\u0003B\u0001\u00112\u0002\u0012B\u0019a)a%\n\u0007\u0005U\u0015H\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006Y1m\u001c8ue>dG.\u001a:!\u0003\u001d\u0019H/\u0019:ukB$\"!!(\u0011\u0007\u0001\u000by*C\u0002\u0002\"\u0006\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<feB\u0011aIG\n\u00035}\"\"!!+\u0002\u001b5+G/\u00193bi\u0006$v\u000e]5d+\t\t\t%\u0001\bNKR\fG-\u0019;b)>\u0004\u0018n\u0019\u0011\u0002#5+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0002:B!\u00111XA_\u001b\u00059\u0016bAA`/\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AE'fi\u0006$\u0017\r^1QCJ$\u0018\u000e^5p]\u0002\u00121\u0002\u0015:pG\u0016\u001c8OU8mKN\u0011\u0001eP\u0015\u0004A\tj#A\u0003\"s_.,'OU8mKNA!ePAg\u0003#\f9\u000eE\u0002\u0002P\u0002j\u0011A\u0007\t\u0004\u0001\u0006M\u0017bAAk\u0003\n9\u0001K]8ek\u000e$\b\u0003BAm\u0003GtA!a7\u0002`:\u0019q-!8\n\u0003\tK1!!9B\u0003\u001d\u0001\u0018mY6bO\u0016LA!!:\u0002h\na1+\u001a:jC2L'0\u00192mK*\u0019\u0011\u0011]!\u0015\u0005\u0005-\bcAAhE\u0005i\u0001O]8ek\u000e$\bK]3gSb\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a=\u0011\u0007\u0001\u000b)0C\u0002\u0002x\u0006\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!@\u0003\u0004A\u0019\u0001)a@\n\u0007\t\u0005\u0011IA\u0002B]fD\u0001\"\u001e\u0014\u0002\u0002\u0003\u0007\u00111_\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0002\t\u0006{\n-\u0011Q`\u0005\u0004\u0005\u001bq(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0005\u0003\u001aA\u0019\u0001I!\u0006\n\u0007\t]\u0011IA\u0004C_>dW-\u00198\t\u0011UD\u0013\u0011!a\u0001\u0003{\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003g\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0003\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\n\u0011\t\u0005\r#\u0011F\u0005\u0005\u0005W\t)E\u0001\u0004PE*,7\r\u001e\u0002\u000f\u0007>tGO]8mY\u0016\u0014(k\u001c7f'!is(!4\u0002R\u0006]GC\u0001B\u001a!\r\ty-\f\u000b\u0005\u0003{\u00149\u0004\u0003\u0005vc\u0005\u0005\t\u0019AAz)\u0011\u0011\u0019Ba\u000f\t\u0011U\u001c\u0014\u0011!a\u0001\u0003{\f!B\u0011:pW\u0016\u0014(k\u001c7f\u00039\u0019uN\u001c;s_2dWM\u001d*pY\u0016\f\u0011#\u001b8ji&\fG.\u001b>f\u0019><G)\u001b:t)\r1(Q\t\u0005\u0006\u001f^\u0002\r\u0001\u0015")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple2 x$1;
    private final MetaProperties metaProps;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final CompletableFuture<List<String>> controllerQuorumVotersFuture;
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final MetaLogRaftShim metaLogShim;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<MetaProperties, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private CompletableFuture<List<String>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private MetaLogRaftShim metaLogShim() {
        return this.metaLogShim;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.raftManager().startup();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.raftManager().shutdown();
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$6 -> {
            x$6.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public KafkaRaftServer(KafkaConfig config, Time time, Option<String> threadNamePrefix) {
        this.config = config;
        this.time = time;
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple2<MetaProperties, Seq<String>> tuple2 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        this.x$1 = new Tuple2((Object)metaProps, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.offlineDirs = (Seq)this.x$1._2();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId().toString());
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(config.quorumVoters());
        this.raftManager = new KafkaRaftManager(this.metaProps(), config, new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), time, this.metrics(), threadNamePrefix);
        this.metaLogShim = new MetaLogRaftShim(this.raftManager().kafkaRaftClient(), config.nodeId());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(config, this.metaProps(), (MetaLogManager)this.metaLogShim(), time, this.metrics(), threadNamePrefix, this.offlineDirs(), this.controllerQuorumVotersFuture(), Server$.MODULE$.SUPPORTED_FEATURES())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.metaProps(), config, (MetaLogManager)this.metaLogShim(), this.raftManager(), time, this.metrics(), threadNamePrefix, this.controllerQuorumVotersFuture())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

