/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.LeaderAndIsr$;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataImage;
import kafka.server.metadata.MetadataImageBuilder;
import kafka.server.metadata.MetadataPartition;
import kafka.server.metadata.MetadataPartition$;
import kafka.server.metadata.RaftMetadataCache$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0015x!B\u0015+\u0011\u0003\td!B\u001a+\u0011\u0003!\u0004\"B\u001e\u0002\t\u0003a\u0004\"B\u001f\u0002\t\u0003q\u0004\"B>\u0002\t\u0003ah!B\u001a+\u0001\u0005-\u0001BCA\u0011\u000b\t\u0015\r\u0011\"\u0001\u0002$!I\u0011QE\u0003\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\u0007w\u0015!\t!a\n\t\u0013\u00055RA1A\u0005\n\u0005=\u0002\u0002CA%\u000b\u0001\u0006I!!\r\t\u0013\u0005-S\u00011A\u0005\n\u00055\u0003\"CA+\u000b\u0001\u0007I\u0011BA,\u0011!\ti&\u0002Q!\n\u0005=\u0003\"CA4\u000b\t\u0007I\u0011BA5\u0011!\t9(\u0002Q\u0001\n\u0005-\u0004bBA=\u000b\u0011%\u00111\u0010\u0005\b\u0003[+A\u0011AAX\u0011\u001d\t\t,\u0002C\u0005\u0003gCq!!;\u0006\t\u0013\tY\u000fC\u0004\u0002v\u0016!I!a>\t\u000f\t%Q\u0001\"\u0011\u0003\f!I!1F\u0003\u0012\u0002\u0013\u0005!Q\u0006\u0005\n\u0005\u0007*\u0011\u0013!C\u0001\u0005[AqA!\u0012\u0006\t\u0003\u00129\u0005C\u0004\u0003J\u0015!\tEa\u0013\t\u000f\tUS\u0001\"\u0011\u0003X!9!1L\u0003\u0005B\tu\u0003b\u0002B5\u000b\u0011\u0005#1\u000e\u0005\b\u0005_*A\u0011\tB9\u0011\u001d\u0011I(\u0002C!\u0005wBqA!!\u0006\t\u0003\u0012\u0019\tC\u0004\u0003\f\u0016!\tE!$\t\u000f\tmU\u0001\"\u0011\u0003\u001e\"9!qT\u0003\u0005B\t\u0005\u0006b\u0002BX\u000b\u0011\u0005!\u0011\u0017\u0005\b\u0005g+A\u0011\u0001B[\u0011\u001d\u0011Y,\u0002C!\u0005{CqA!6\u0006\t\u0003\u00129\u000eC\u0004\u0003V\u0016!\tEa7\t\u000f\u0005MU\u0001\"\u0001\u0003`\u0006\t\"+\u00194u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u0005-b\u0013\u0001C7fi\u0006$\u0017\r^1\u000b\u00055r\u0013AB:feZ,'OC\u00010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AM\u0001\u000e\u0003)\u0012\u0011CU1gi6+G/\u00193bi\u0006\u001c\u0015m\u00195f'\t\tQ\u0007\u0005\u00027s5\tqGC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQtG\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\n1C]3n_Z,\u0007+\u0019:uSRLwN\\%oM>$Ba\u0010\"umB\u0011a\u0007Q\u0005\u0003\u0003^\u0012qAQ8pY\u0016\fg\u000eC\u0003D\u0007\u0001\u0007A)A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t!\u0011)%\nT,\u000e\u0003\u0019S!a\u0012%\u0002\u000f5,H/\u00192mK*\u0011\u0011jN\u0001\u000bG>dG.Z2uS>t\u0017BA&G\u0005%\te.\u001f*fM6\u000b\u0007\u000f\u0005\u0002N):\u0011aJ\u0015\t\u0003\u001f^j\u0011\u0001\u0015\u0006\u0003#B\na\u0001\u0010:p_Rt\u0014BA*8\u0003\u0019\u0001&/\u001a3fM&\u0011QK\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M;\u0004cA#Y5&\u0011\u0011L\u0012\u0002\b\u0019>tw-T1q!\tY\u0016O\u0004\u0002]]:\u0011Ql\u001b\b\u0003=\"t!a\u00184\u000f\u0005\u0001\u001cgBA(b\u0013\u0005\u0011\u0017aA8sO&\u0011A-Z\u0001\u0007CB\f7\r[3\u000b\u0003\tL!aL4\u000b\u0005\u0011,\u0017BA5k\u0003\u0019\u0019w.\\7p]*\u0011qfZ\u0005\u0003Y6\fq!\\3tg\u0006<WM\u0003\u0002jU&\u0011q\u000e]\u0001\u001a+B$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u\t\u0006$\u0018M\u0003\u0002m[&\u0011!o\u001d\u0002\u001d+B$\u0017\r^3NKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0015\ty\u0007\u000fC\u0003v\u0007\u0001\u0007A*A\u0003u_BL7\rC\u0003x\u0007\u0001\u0007\u00010A\u0006qCJ$\u0018\u000e^5p]&#\u0007C\u0001\u001cz\u0013\tQxGA\u0002J]R\f\u0001$\u00193e\u001fJ,\u0006\u000fZ1uKB\u000b'\u000f^5uS>t\u0017J\u001c4p)%i\u0018\u0011AA\u0002\u0003\u000b\t9\u0001\u0005\u00027}&\u0011qp\u000e\u0002\u0005+:LG\u000fC\u0003D\t\u0001\u0007A\tC\u0003v\t\u0001\u0007A\nC\u0003x\t\u0001\u0007\u0001\u0010\u0003\u0004\u0002\n\u0011\u0001\rAW\u0001\ngR\fG/Z%oM>\u001cb!B\u001b\u0002\u000e\u0005U\u0001\u0003BA\b\u0003#i\u0011\u0001L\u0005\u0004\u0003'a#!D'fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0003\u0002\u0018\u0005uQBAA\r\u0015\r\tYBL\u0001\u0006kRLGn]\u0005\u0005\u0003?\tIBA\u0004M_\u001e<\u0017N\\4\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001_\u0001\nEJ|7.\u001a:JI\u0002\"B!!\u000b\u0002,A\u0011!'\u0002\u0005\u0007\u0003CA\u0001\u0019\u0001=\u0002\t1|7m[\u000b\u0003\u0003c\u0001B!a\r\u0002F5\u0011\u0011Q\u0007\u0006\u0005\u0003o\tI$A\u0003m_\u000e\\7O\u0003\u0003\u0002<\u0005u\u0012AC2p]\u000e,(O]3oi*!\u0011qHA!\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u00026\ti!+Z3oiJ\fg\u000e\u001e'pG.\fQ\u0001\\8dW\u0002\nQbX2veJ,g\u000e^%nC\u001e,WCAA(!\r\u0011\u0014\u0011K\u0005\u0004\u0003'R#!D'fi\u0006$\u0017\r^1J[\u0006<W-A\t`GV\u0014(/\u001a8u\u00136\fw-Z0%KF$2!`A-\u0011%\tY\u0006DA\u0001\u0002\u0004\ty%A\u0002yIE\nabX2veJ,g\u000e^%nC\u001e,\u0007\u0005K\u0002\u000e\u0003C\u00022ANA2\u0013\r\t)g\u000e\u0002\tm>d\u0017\r^5mK\u0006\t2\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0016\u0005\u0005-\u0004\u0003BA7\u0003gj!!a\u001c\u000b\u0007\u0005Ed&\u0001\u0006d_:$(o\u001c7mKJLA!!\u001e\u0002p\t\t2\u000b^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:\u0002%M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'\u000fI\u0001\u0019[\u0006L(-\u001a$jYR,'/\u00117jm\u0016\u0014V\r\u001d7jG\u0006\u001cHCCA?\u0003#\u000b)*!'\u0002*B1\u0011qPAA\u0003\u000bk!!!\u0010\n\t\u0005\r\u0015Q\b\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002\b\u00065UBAAE\u0015\u0011\tY)!\u0011\u0002\t1\fgnZ\u0005\u0005\u0003\u001f\u000bIIA\u0004J]R,w-\u001a:\t\u000f\u0005M\u0005\u00031\u0001\u0002P\u0005)\u0011.\\1hK\"9\u0011q\u0013\tA\u0002\u0005u\u0014a\u00022s_.,'o\u001d\u0005\b\u00037\u0003\u0002\u0019AAO\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR[\u00069a.\u001a;x_J\\\u0017\u0002BAT\u0003C\u0013A\u0002T5ti\u0016tWM\u001d(b[\u0016Da!a+\u0011\u0001\u0004y\u0014A\u00074jYR,'/\u00168bm\u0006LG.\u00192mK\u0016sG\r]8j]R\u001c\u0018\u0001D2veJ,g\u000e^%nC\u001e,GCAA(\u0003Q9W\r\u001e)beRLG/[8o\u001b\u0016$\u0018\rZ1uCRa\u0011QWAn\u0003;\fy.!9\u0002fB)a'a.\u0002<&\u0019\u0011\u0011X\u001c\u0003\r=\u0003H/[8o!\u0019\ti,a2\u0002N:!\u0011qXAb\u001d\ry\u0015\u0011Y\u0005\u0002q%\u0019\u0011QY\u001c\u0002\u000fA\f7m[1hK&!\u0011\u0011ZAf\u0005!IE/\u001a:bi>\u0014(bAAcoA!\u0011qZAk\u001d\ra\u0016\u0011[\u0005\u0004\u0003'\u0004\u0018\u0001F'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002X\u0006e'!G'fi\u0006$\u0017\r^1SKN\u0004xN\\:f!\u0006\u0014H/\u001b;j_:T1!a5q\u0011\u001d\t\u0019J\u0005a\u0001\u0003\u001fBQ!\u001e\nA\u00021Cq!a'\u0013\u0001\u0004\ti\n\u0003\u0004\u0002dJ\u0001\raP\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8\u000f\u0003\u0004\u0002hJ\u0001\raP\u0001\u001aKJ\u0014xN]+oCZ\f\u0017\u000e\\1cY\u0016d\u0015n\u001d;f]\u0016\u00148/\u0001\tiCN\fE.\u001b<f\u000b:$\u0007o\\5oiR9q(!<\u0002p\u0006M\bbBAJ'\u0001\u0007\u0011q\n\u0005\u0007\u0003c\u001c\u0002\u0019\u0001=\u0002\u0005%$\u0007bBAN'\u0001\u0007\u0011QT\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$\u0002\"!?\u0003\u0004\t\u0015!q\u0001\t\u0006m\u0005]\u00161 \t\u0005\u0003{\fy0D\u0001n\u0013\r\u0011\t!\u001c\u0002\u0005\u001d>$W\rC\u0004\u0002\u0014R\u0001\r!a\u0014\t\r\u0005EH\u00031\u0001y\u0011\u001d\tY\n\u0006a\u0001\u0003;\u000b\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\t5!1\u0004B\u0013\u0005O\u0011I\u0003\u0005\u0004\u0003\u0010\tE!QC\u0007\u0002\u0011&\u0019!1\u0003%\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002P\n]\u0011\u0002\u0002B\r\u00033\u0014Q#T3uC\u0012\fG/\u0019*fgB|gn]3U_BL7\rC\u0004\u0003\u001eU\u0001\rAa\b\u0002\rQ|\u0007/[2t!\u0015\u0011yA!\tM\u0013\r\u0011\u0019\u0003\u0013\u0002\u0004'\u0016$\bbBAN+\u0001\u0007\u0011Q\u0014\u0005\t\u0003G,\u0002\u0013!a\u0001\u007f!A\u0011q]\u000b\u0011\u0002\u0003\u0007q(\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u00030)\u001aqH!\r,\u0005\tM\u0002\u0003\u0002B\u001b\u0005\u007fi!Aa\u000e\u000b\t\te\"1H\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u00108\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0003\u00129DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ\nAbZ3u\u00032dGk\u001c9jGN$\"Aa\b\u0002!\u001d,G/\u00117m!\u0006\u0014H/\u001b;j_:\u001cHC\u0001B'!\u0019\u0011yA!\t\u0003PA!\u0011Q B)\u0013\r\u0011\u0019&\u001c\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Q9W\r\u001e(p]\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgR!!q\u0004B-\u0011\u001d\u0011iB\u0007a\u0001\u0005?\tabZ3u\u00032Lg/\u001a\"s_.,'\u000f\u0006\u0003\u0003`\t\u001d\u0004#\u0002\u001c\u00028\n\u0005\u0004c\u0001\u001a\u0003d%\u0019!Q\r\u0016\u0003\u001d5+G/\u00193bi\u0006\u0014%o\\6fe\"1\u0011\u0011E\u000eA\u0002a\fqbZ3u\u00032Lg/\u001a\"s_.,'o]\u000b\u0003\u0005[\u0002bAa\u0004\u0003\u0012\t\u0005\u0014\u0001E4fiB\u000b'\u000f^5uS>t\u0017J\u001c4p)\u0019\u0011\u0019H!\u001e\u0003xA!a'a.[\u0011\u0015)X\u00041\u0001M\u0011\u00159X\u00041\u0001y\u00035qW/\u001c)beRLG/[8ogR!!Q\u0010B@!\u00111\u0014q\u0017=\t\u000bUt\u0002\u0019\u0001'\u00025\u001d,G\u000fU1si&$\u0018n\u001c8MK\u0006$WM]#oIB|\u0017N\u001c;\u0015\u0011\u0005e(Q\u0011BD\u0005\u0013CQ!^\u0010A\u00021CQa^\u0010A\u0002aDq!a' \u0001\u0004\ti*\u0001\u000fhKR\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-\u00128ea>Lg\u000e^:\u0015\r\t=%Q\u0013BM!\u0019i%\u0011\u0013=\u0002|&\u0019!1\u0013,\u0003\u00075\u000b\u0007\u000fC\u0004\u0003\u0018\u0002\u0002\rAa\u0014\u0002\u0005Q\u0004\bbBANA\u0001\u0007\u0011QT\u0001\u0010O\u0016$8i\u001c8ue>dG.\u001a:JIV\u0011!QP\u0001\u0013O\u0016$8\t\\;ti\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0003$\n%&Q\u0016\t\u0005\u0003{\u0014)+C\u0002\u0003(6\u0014qa\u00117vgR,'\u000f\u0003\u0004\u0003,\n\u0002\r\u0001T\u0001\nG2,8\u000f^3s\u0013\u0012Dq!a'#\u0001\u0004\ti*A\fti\u0006$Xm\u00115b]\u001e,GK]1dK\u0016s\u0017M\u00197fIR\tq(A\nm_\u001e\u001cF/\u0019;f\u0007\"\fgnZ3Ue\u0006\u001cW\rF\u0002~\u0005oCaA!/%\u0001\u0004a\u0015aA:ue\u0006qQ\u000f\u001d3bi\u0016lU\r^1eCR\fGC\u0002B`\u0005\u0003\u0014)\r\u0005\u0004\u0003\u0010\tE!q\n\u0005\u0007\u0005\u0007,\u0003\u0019\u0001=\u0002\u001b\r|'O]3mCRLwN\\%e\u0011\u001d\u00119-\na\u0001\u0005\u0013\fqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0003L\nEWB\u0001Bg\u0015\r\u0011y-\\\u0001\te\u0016\fX/Z:ug&!!1\u001bBg\u0005U)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0014V-];fgR\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0004\u007f\te\u0007\"B;'\u0001\u0004aEcA \u0003^\"9!qS\u0014A\u0002\t=CcA?\u0003b\"9!1\u001d\u0015A\u0002\u0005=\u0013\u0001\u00038fo&k\u0017mZ3")
public class RaftMetadataCache
implements MetadataCache,
Logging {
    private final int brokerId;
    private final ReentrantLock lock;
    private volatile MetadataImage _currentImage;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        RaftMetadataCache$.MODULE$.addOrUpdatePartitionInfo(partitionStates, topic, partitionId, stateInfo);
    }

    public static boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId) {
        return RaftMetadataCache$.MODULE$.removePartitionInfo(partitionStates, topic, partitionId);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private MetadataImage _currentImage() {
        return this._currentImage;
    }

    private void _currentImage_$eq(MetadataImage x$1) {
        this._currentImage = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataImage image, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(package$.MODULE$.min(image.brokers().aliveBrokers().size(), brokers.size()));
        CollectionConverters$.MODULE$.ListHasAsScala(brokers).asScala().foreach((Function1 & Serializable)brokerId -> {
            if (this.hasAliveEndpoint(image, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    public MetadataImage currentImage() {
        return this._currentImage();
    }

    private Option<Iterator<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataImage image, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        Iterator<MetadataPartition> partitionsIterator = image.partitions().topicPartitions(topic);
        if (!partitionsIterator.hasNext()) {
            return None$.MODULE$;
        }
        return new Some((Object)partitionsIterator.map((Function1 & Serializable)partition -> {
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(image, partition.replicas(), listenerName, errorUnavailableEndpoints);
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(image, partition.isr(), listenerName, errorUnavailableEndpoints);
            Option<Node> maybeLeader = this.getAliveEndpoint(image, partition.leaderId(), listenerName);
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors;
                if (image.aliveBroker(partition.leaderId()).isEmpty()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(partition.toTopicPartition()).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(partition.toTopicPartition()).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(partition.leaderId()).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(partition.partitionIndex()).setLeaderId(-1).setLeaderEpoch(partition.leaderEpoch()).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(partition.offlineReplicas());
            }
            if (maybeLeader instanceof Some) {
                Errors errors;
                Node leader = (Node)((Some)maybeLeader).value();
                if (filteredReplicas.size() < partition.replicas().size()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(partition.toTopicPartition()).append(": replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                    errors = Errors.REPLICA_NOT_AVAILABLE;
                } else if (filteredIsr.size() < partition.isr().size()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(partition.toTopicPartition()).append(": in sync replica information not available for ").append("following brokers ").append(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.isr()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                    errors = Errors.REPLICA_NOT_AVAILABLE;
                } else {
                    errors = Errors.NONE;
                }
                Errors error = errors;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex(partition.partitionIndex()).setLeaderId(leader.id()).setLeaderEpoch(partition.leaderEpoch()).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(partition.offlineReplicas());
            }
            throw new MatchError(maybeLeader);
        }));
    }

    private boolean hasAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return image.brokers().aliveBroker(id).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RaftMetadataCache.$anonfun$hasAliveEndpoint$1(listenerName, x$1)));
    }

    private Option<Node> getAliveEndpoint(MetadataImage image, int id, ListenerName listenerName) {
        return image.brokers().aliveBroker(id).flatMap((Function1 & Serializable)x$2 -> x$2.endpoints().get((Object)listenerName.value()));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataImage image = this._currentImage();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(image, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)image.topicNameToId((String)topic).getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions(CollectionConverters$.MODULE$.BufferHasAsJava(partitionMetadata.toBuffer()).asJava())));
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return this._currentImage().partitions().allTopicNames();
    }

    @Override
    public Set<TopicPartition> getAllPartitions() {
        return this._currentImage().partitions().allPartitions().map((Function1 & Serializable)partition -> partition.toTopicPartition()).toSet();
    }

    @Override
    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.diff(this._currentImage().partitions().allTopicNames());
    }

    @Override
    public Option<MetadataBroker> getAliveBroker(int brokerId) {
        return this._currentImage().brokers().aliveBroker(brokerId);
    }

    @Override
    public Seq<MetadataBroker> getAliveBrokers() {
        return this._currentImage().brokers().aliveBrokers();
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this._currentImage().partitions().topicPartition(topic, partitionId).map((Function1 & Serializable)partition -> new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(partition.topicName()).setPartitionIndex(partition.partitionIndex()).setControllerEpoch(-1).setLeader(partition.leaderId()).setLeaderEpoch(partition.leaderEpoch()).setIsr(partition.isr()).setZkVersion(-1));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this._currentImage().partitions().numTopicPartitions(topic);
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        return image.partitions().topicPartition(topic, partitionId).map((Function1 & Serializable)partition -> {
            Option<MetadataBroker> option = image.aliveBroker(partition.leaderId());
            if (option instanceof Some) {
                return (Node)((MetadataBroker)((Some)option).value()).endpoints().getOrElse((Object)listenerName.value(), (Function0 & Serializable)() -> Node.noNode());
            }
            if (None$.MODULE$.equals(option)) {
                return Node.noNode();
            }
            throw new MatchError(option);
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        return (scala.collection.immutable.Map)image.partitions().topicPartition(tp.topic(), tp.partition()).map((Function1 & Serializable)partition -> (scala.collection.immutable.Map)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)replicaId -> {
            Node node;
            Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
            Option<MetadataBroker> option = image.aliveBroker(Predef$.MODULE$.Integer2int(replicaId));
            if (option instanceof Some) {
                node = (Node)((MetadataBroker)((Some)option).value()).endpoints().getOrElse((Object)listenerName.value(), (Function0 & Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError(option);
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)RaftMetadataCache.$anonfun$getPartitionReplicaEndpoints$4(pair)))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this._currentImage().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataImage image = this._currentImage();
        HashMap nodes = new HashMap();
        image.brokers().aliveBrokers().foreach((Function1 & Serializable)node -> {
            RaftMetadataCache.$anonfun$getClusterMetadata$1(listenerName, nodes, node);
            return BoxedUnit.UNIT;
        });
        ArrayList partitionInfos = new ArrayList();
        HashSet internalTopics = new HashSet();
        image.partitions().allPartitions().foreach((Function1 & Serializable)partition -> {
            partitionInfos.add(new PartitionInfo(partition.topicName(), partition.partitionIndex(), RaftMetadataCache.node$2(Predef$.MODULE$.int2Integer(partition.leaderId()), nodes), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.replicas()).asScala().map((Function1 & Serializable)id -> RaftMetadataCache.node$2(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.isr()).asScala().map((Function1 & Serializable)id -> RaftMetadataCache.node$2(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partition.offlineReplicas()).asScala().map((Function1 & Serializable)id -> RaftMetadataCache.node$2(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class))));
            if (Topic.isInternal((String)partition.topicName())) {
                return BoxesRunTime.boxToBoolean((boolean)internalTopics.add(partition.topicName()));
            }
            return BoxedUnit.UNIT;
        });
        return new Cluster(clusterId, nodes.values(), partitionInfos, Collections.emptySet(), internalTopics, RaftMetadataCache.node$2(BoxesRunTime.unboxToInt((Object)image.controllerId().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -1)), nodes));
    }

    public boolean stateChangeTraceEnabled() {
        return this.stateChangeLogger().isTraceEnabled();
    }

    public void logStateChangeTrace(String str) {
        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> str);
    }

    @Override
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest request) {
        Buffer buffer;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            buffer = RaftMetadataCache.$anonfun$updateMetadata$1(this, request, correlationId);
        }
        finally {
            inLock_lock.unlock();
        }
        return buffer;
    }

    @Override
    public boolean contains(String topic) {
        return this._currentImage().partitions().contains(topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this._currentImage().partitions().topicPartition(tp.topic(), tp.partition()).isDefined();
    }

    public void image(MetadataImage newImage) {
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            this._currentImage_$eq(newImage);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasAliveEndpoint$1(ListenerName listenerName$3, MetadataBroker x$1) {
        return x$1.endpoints().contains((Object)listenerName$3.value());
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$4(Tuple2 pair) {
        if (pair != null) {
            return !((Node)pair._2()).isEmpty();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$getClusterMetadata$1(ListenerName listenerName$8, HashMap nodes$1, MetadataBroker node) {
        if (!node.fenced()) {
            node.endpoints().get((Object)listenerName$8.value()).foreach((Function1 & Serializable)x$3 -> nodes$1.put(Predef$.MODULE$.int2Integer(node.id()), x$3));
            return;
        }
    }

    private static final Node node$2(Integer id, HashMap nodes$1) {
        return (Node)Option$.MODULE$.apply(nodes$1.get(id)).getOrElse((Function0 & Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    private static final MetadataBroker toMetadataBroker$1(UpdateMetadataRequestData.UpdateMetadataBroker broker) {
        scala.collection.immutable.Map endpoints = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(broker.endpoints()).asScala().map((Function1 & Serializable)endpoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)endpoint.listener()), (Object)new Node(broker.id(), endpoint.host(), endpoint.port())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return new MetadataBroker(broker.id(), broker.rack(), (Map<String, Node>)endpoints, false);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$3(MetadataImage image$6, MetadataImageBuilder builder$1, IdentityHashMap found$1, UpdateMetadataRequestData.UpdateMetadataBroker brokerInfo) {
        MetadataBroker newBroker = RaftMetadataCache.toMetadataBroker$1(brokerInfo);
        Option<MetadataBroker> option = image$6.brokers().get(brokerInfo.id());
        if (None$.MODULE$.equals(option)) {
            builder$1.brokersBuilder().add(newBroker);
            return;
        }
        if (option instanceof Some) {
            MetadataBroker existingBroker = (MetadataBroker)((Some)option).value();
            found$1.put(existingBroker, BoxesRunTime.boxToBoolean((boolean)true));
            if (!existingBroker.equals(newBroker)) {
                builder$1.brokersBuilder().add(newBroker);
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(IdentityHashMap found$1, MetadataImageBuilder builder$1, MetadataBroker broker) {
        if (!found$1.containsKey(broker)) {
            builder$1.brokersBuilder().remove(broker.id());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(MetadataImageBuilder builder$1, MetadataPartition newPartition$1, Uuid topicId) {
        builder$1.partitionsBuilder().addUuidMapping(newPartition$1.topicName(), topicId);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$6(RaftMetadataCache $this, boolean traceEnabled$1, UpdateMetadataRequest request$1, int correlationId$1, MetadataImageBuilder builder$1, Buffer deleted$1, IntRef numDeleted$1, scala.collection.immutable.Map topicIds$1, IntRef numAdded$1, UpdateMetadataRequestData.UpdateMetadataPartitionState partition) {
        if (partition.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
            if (traceEnabled$1) {
                $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(125).append("Deleted partition ").append(partition.topicName()).append("-").append(partition.partitionIndex()).append(" ").append("from metadata cache in response to UpdateMetadata request sent by ").append("controller ").append(request$1.controllerId()).append(" epoch ").append(request$1.controllerEpoch()).append(" ").append("with correlation id ").append(correlationId$1).toString());
            }
            builder$1.partitionsBuilder().remove(partition.topicName(), partition.partitionIndex());
            deleted$1.$plus$eq((Object)new TopicPartition(partition.topicName(), partition.partitionIndex()));
            ++numDeleted$1.elem;
            return;
        }
        Option<MetadataPartition> prevPartition = builder$1.partition(partition.topicName(), partition.partitionIndex());
        MetadataPartition newPartition = MetadataPartition$.MODULE$.apply(prevPartition, partition);
        if (traceEnabled$1) {
            $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(134).append("Cached leader info ").append(newPartition).append(" in response to ").append("UpdateMetadata request sent by controller ").append(request$1).append(".controllerId epoch ").append(request$1).append(".controllerEpoch with correlation id ").append(correlationId$1).toString());
        }
        builder$1.partitionsBuilder().set(newPartition);
        topicIds$1.get((Object)newPartition.topicName()).foreach((Function1 & Serializable)topicId -> {
            RaftMetadataCache.$anonfun$updateMetadata$9(builder$1, newPartition, topicId);
            return BoxedUnit.UNIT;
        });
        ++numAdded$1.elem;
    }

    public static final /* synthetic */ Buffer $anonfun$updateMetadata$1(RaftMetadataCache $this, UpdateMetadataRequest request$1, int correlationId$1) {
        MetadataImage image = $this._currentImage();
        MetadataImageBuilder builder = new MetadataImageBuilder($this.brokerId(), $this.logger().underlying(), image);
        builder.controllerId((Option<Object>)(request$1.controllerId() < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)request$1.controllerId()))));
        IdentityHashMap found = new IdentityHashMap(image.numAliveBrokers());
        CollectionConverters$.MODULE$.IteratorHasAsScala(request$1.liveBrokers().iterator()).asScala().foreach((Function1 & Serializable)brokerInfo -> {
            RaftMetadataCache.$anonfun$updateMetadata$3(image, builder, found, brokerInfo);
            return BoxedUnit.UNIT;
        });
        image.brokers().iterator().foreach((Function1 & Serializable)broker -> {
            RaftMetadataCache.$anonfun$updateMetadata$4(found, builder, broker);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map topicIds = CollectionConverters$.MODULE$.IteratorHasAsScala(request$1.topicStates().iterator()).asScala().map((Function1 & Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic.topicName()), (Object)topic.topicId())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
        IntRef numDeleted = IntRef.create((int)0);
        IntRef numAdded = IntRef.create((int)0);
        Buffer deleted = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        CollectionConverters$.MODULE$.IteratorHasAsScala(request$1.partitionStates().iterator()).asScala().foreach((Function1 & Serializable)partition -> {
            RaftMetadataCache.$anonfun$updateMetadata$6($this, traceEnabled, request$1, correlationId$1, builder, deleted, numDeleted, topicIds, numAdded, partition);
            return BoxedUnit.UNIT;
        });
        $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(147).append("Add ").append(numAdded$1.elem).append(" partitions and deleted ").append(numDeleted$1.elem).append(" ").append("partitions to the metadata cache in response to UpdateMetadata request sent by ").append("controller ").append(request$1.controllerId()).append(" epoch ").append(request$1.controllerEpoch()).append(" with ").append("correlation id ").append(correlationId$1).toString());
        $this._currentImage_$eq(builder.build());
        return deleted;
    }

    public RaftMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.lock = new ReentrantLock();
        this._currentImage = new MetadataImage();
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }
}

