/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.api.Request$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcherBlockingSend;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005q4A!\u0005\n\u0005/!Ia\u0004\u0001B\u0001B\u0003%q\u0004\f\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011!Y\u0005A!A!\u0002\u0013a\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002'\t\u0011E\u0003!\u0011!Q\u0001\n1C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u0019\"AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003Z\u0011!\t\u0007A!A!\u0002\u0013a\u0005\"\u00022\u0001\t\u0003\u0019\u0007bB9\u0001\u0005\u0004%IA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000b]\u0004A\u0011\t=\u0003\u001dI+\u0007\u000f\\5dC\u001a+Go\u00195fe*\u00111\u0003F\u0001\u0006i>|Gn\u001d\u0006\u0002+\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\tYB#A\u0003vi&d7/\u0003\u0002\u001e5\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003\u0011q\u0017-\\3\u0011\u0005\u0001JcBA\u0011(!\t\u0011S%D\u0001$\u0015\t!c#\u0001\u0004=e>|GO\u0010\u0006\u0002M\u0005)1oY1mC&\u0011\u0001&J\u0001\u0007!J,G-\u001a4\n\u0005)Z#AB*ue&twM\u0003\u0002)K%\u0011a\u0004H\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003_]j\u0011\u0001\r\u0006\u0003cI\naaY8n[>t'BA\u000b4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\u0002$\u0001\u0002(pI\u0016\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004w\u0001\u001beB\u0001\u001f?\u001d\t\u0011S(C\u0001'\u0013\tyT%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0013%\u0001C%uKJ\f'\r\\3\u000b\u0005}*\u0003CA\u0018E\u0013\t)\u0005G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001bI,\u0007\u000f\\5dC\n+hMZ3s!\tA\u0015*D\u0001\u0013\u0013\tQ%CA\u0007SKBd\u0017nY1Ck\u001a4WM]\u0001\u000eg>\u001c7.\u001a;US6,w.\u001e;\u0011\u00055sU\"A\u0013\n\u0005=+#aA%oi\u0006\u00012o\\2lKR\u0014UO\u001a4feNK'0Z\u0001\nM\u0016$8\r[*ju\u0016\fq!\\1y/\u0006LG/\u0001\u0005nS:\u0014\u0015\u0010^3t\u00039!wNV3sS\u001aL7-\u0019;j_:\u0004\"!\u0014,\n\u0005]+#a\u0002\"p_2,\u0017M\\\u0001\u000fG>t7/^7fe\u000e{gNZ5h!\tQv,D\u0001\\\u0015\taV,\u0001\u0003vi&d'\"\u00010\u0002\t)\fg/Y\u0005\u0003An\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%1W\r^2iKJLE-\u0001\u0004=S:LGO\u0010\u000b\u000eI\u00164w\r[5kW2lgn\u001c9\u0011\u0005!\u0003\u0001\"\u0002\u0010\u000e\u0001\u0004y\u0002\"B\u0017\u000e\u0001\u0004q\u0003\"B\u001d\u000e\u0001\u0004Q\u0004\"\u0002$\u000e\u0001\u00049\u0005\"B&\u000e\u0001\u0004a\u0005\"\u0002)\u000e\u0001\u0004a\u0005\"B)\u000e\u0001\u0004a\u0005\"\u0002*\u000e\u0001\u0004a\u0005\"B*\u000e\u0001\u0004a\u0005\"\u0002+\u000e\u0001\u0004)\u0006\"\u0002-\u000e\u0001\u0004I\u0006\"B1\u000e\u0001\u0004a\u0015!\u00044fi\u000eDWI\u001c3q_&tG/F\u0001t!\tAE/\u0003\u0002v%\tQ\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014(\t\\8dW&twmU3oI\u0006qa-\u001a;dQ\u0016sG\r]8j]R\u0004\u0013A\u00023p/>\u00148\u000eF\u0001z!\ti%0\u0003\u0002|K\t!QK\\5u\u0001")
public class ReplicaFetcher
extends ShutdownableThread {
    private final Node sourceBroker;
    private final Iterable<TopicPartition> topicPartitions;
    private final ReplicaBuffer replicaBuffer;
    private final int fetchSize;
    private final int maxWait;
    private final int minBytes;
    private final boolean doVerification;
    private final ReplicaFetcherBlockingSend fetchEndpoint;

    private ReplicaFetcherBlockingSend fetchEndpoint() {
        return this.fetchEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block7: {
            block6: {
                void forReplica_minBytes;
                void forReplica_maxWait;
                void forReplica_replicaId;
                fetcherBarrier = this.replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.replicaBuffer.getVerificationBarrier();
                LinkedHashMap requestMap = new LinkedHashMap();
                this.topicPartitions.foreach((Function1 & Serializable)topicPartition -> requestMap.put(topicPartition, new FetchRequest.PartitionData($this.replicaBuffer.getOffset((TopicPartition)topicPartition), 0L, $this.fetchSize, Optional.empty())));
                int n = this.minBytes;
                int n2 = this.maxWait;
                int n3 = Request$.MODULE$.DebuggingConsumerId();
                short forReplica_allowedVersion = ApiKeys.FETCH.latestVersion();
                FetchRequest.Builder fetchRequestBuilder = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap);
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Issuing fetch request ");
                FetchResponse fetchResponse = null;
                try {
                    fetchResponse = (FetchResponse)this.fetchEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequestBuilder).responseBody();
                }
                finally {
                    if (fetchResponse != null) {
                    }
                    break block6;
                }
                fetchResponse.responseData().forEach((tp, partitionData) -> $this.replicaBuffer.addFetchedData((TopicPartition)tp, $this.sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)partitionData));
                break block7;
            }
            FetchResponse.PartitionData emptyResponse = new FetchResponse.PartitionData(Errors.NONE, -1L, -1L, -1L, null, (BaseRecords)MemoryRecords.EMPTY);
            this.topicPartitions.foreach((Function1 & Serializable)topicAndPartition -> {
                this.replicaBuffer.addFetchedData(topicAndPartition, this.sourceBroker.id(), (FetchResponse.PartitionData<MemoryRecords>)emptyResponse);
                return BoxedUnit.UNIT;
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Done fetching");
        fetcherBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Ready for verification");
        if (this.doVerification) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Do verification");
            this.replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)(Function1 & Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            this.replicaBuffer.createNewFetcherBarrier();
            this.replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Created new barrier");
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Done verification");
    }

    public ReplicaFetcher(String name, Node sourceBroker, Iterable<TopicPartition> topicPartitions, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification, Properties consumerConfig, int fetcherId) {
        this.sourceBroker = sourceBroker;
        this.topicPartitions = topicPartitions;
        this.replicaBuffer = replicaBuffer;
        this.fetchSize = fetchSize;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.doVerification = doVerification;
        super(name, true);
        this.fetchEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, new ConsumerConfig(consumerConfig), new Metrics(), Time.SYSTEM, fetcherId, new StringBuilder(16).append("broker-").append(Request$.MODULE$.DebuggingConsumerId()).append("-fetcher-").append(fetcherId).toString());
    }
}

