/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005U2A!\u0002\u0004\u0001\u0017!)\u0001\u0003\u0001C\u0001#!)1\u0003\u0001C))!)Q\u0005\u0001C\u0001M!)1\u0007\u0001C\u0001M\tq3i\u001c8tk6,'oV5uQ2+w-Y2z\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;J]R,wM]1uS>tG+Z:u\u0015\t9\u0001\"A\u0002ba&T\u0011!C\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\ta!\u0003\u0002\u0010\r\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#\u0001\n\u0011\u00055\u0001\u0011a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0003V]&$\b\"\u0002\u000f\u0003\u0001\u0004i\u0012A\u00039s_B,'\u000f^5fgB\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005kRLGNC\u0001#\u0003\u0011Q\u0017M^1\n\u0005\u0011z\"A\u0003)s_B,'\u000f^5fg\u0006\u0019B/Z:u\u001f\u001a47/\u001a;t\r>\u0014H+[7fgR\tQ\u0003\u000b\u0002\u0004QA\u0011\u0011&M\u0007\u0002U)\u0011qa\u000b\u0006\u0003Y5\nqA[;qSR,'O\u0003\u0002/_\u0005)!.\u001e8ji*\t\u0001'A\u0002pe\u001eL!A\r\u0016\u0003\tQ+7\u000f^\u0001\u001ci\u0016\u001cH/R1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;PM\u001a\u001cX\r^:)\u0005\u0011A\u0003")
public class ConsumerWithLegacyMessageFormatIntegrationTest
extends AbstractConsumerTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
    }

    @Test
    public void testOffsetsForTimes() {
        int numParts = 2;
        String topic1 = "part-test-topic-1";
        String topic2 = "part-test-topic-2";
        String topic3 = "part-test-topic-3";
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, numParts, 1, this.createTopic$default$4());
        this.createTopic(topic2, numParts, 1, props);
        this.createTopic(topic3, numParts, 1, this.createTopic$default$4());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertThrows(IllegalArgumentException.class, () -> consumer.offsetsForTimes(Collections.singletonMap(new TopicPartition(topic1, 0), Predef$.MODULE$.long2Long(-1L))));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        HashMap timestampsToSearch = new HashMap();
        IntRef i = IntRef.create((int)0);
        ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1, topic2, topic3}))).foreach((Function1 & Serializable)topic -> {
            ConsumerWithLegacyMessageFormatIntegrationTest.$anonfun$testOffsetsForTimes$2(this, numParts, producer, timestampsToSearch, i, topic);
            return BoxedUnit.UNIT;
        });
        Map timestampOffsets = consumer.offsetsForTimes(timestampsToSearch);
        OffsetAndTimestamp timestampTopic1P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 0));
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.offset());
        Assertions.assertEquals((long)0L, (long)timestampTopic1P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P0.leaderEpoch());
        OffsetAndTimestamp timestampTopic1P1 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic1, 1));
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.offset());
        Assertions.assertEquals((long)20L, (long)timestampTopic1P1.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic1P1.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 0)), (String)"null should be returned when message format is 0.9.0");
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic2, 1)), (String)"null should be returned when message format is 0.9.0");
        OffsetAndTimestamp timestampTopic3P0 = (OffsetAndTimestamp)timestampOffsets.get(new TopicPartition(topic3, 0));
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.offset());
        Assertions.assertEquals((long)80L, (long)timestampTopic3P0.timestamp());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)0)), (Object)timestampTopic3P0.leaderEpoch());
        Assertions.assertNull(timestampOffsets.get(new TopicPartition(topic3, 1)));
    }

    @Test
    public void testEarliestOrLatestOffsets() {
        String topic0 = "topicWithNewMessageFormat";
        String topic1 = "topicWithOldMessageFormat";
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.createTopicAndSendRecords(producer, topic0, 2, 100);
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        this.createTopic(topic1, 1, 1, props);
        this.sendRecords(producer, 100, new TopicPartition(topic1, 0), this.sendRecords$default$4());
        TopicPartition t0p0 = new TopicPartition(topic0, 0);
        TopicPartition t0p1 = new TopicPartition(topic0, 1);
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        java.util.Set partitions = CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{t0p0, t0p1, t1p0}))).asJava();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Map earliests = consumer.beginningOffsets((Collection)partitions);
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p0)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t0p1)));
        Assertions.assertEquals((long)0L, (Long)((Long)earliests.get(t1p0)));
        Map latests = consumer.endOffsets((Collection)partitions);
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p0)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t0p1)));
        Assertions.assertEquals((long)100L, (Long)((Long)latests.get(t1p0)));
    }

    public static final /* synthetic */ void $anonfun$testOffsetsForTimes$2(ConsumerWithLegacyMessageFormatIntegrationTest $this, int numParts$1, KafkaProducer producer$1, HashMap timestampsToSearch$1, IntRef i$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numParts$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic, part);
            $this.sendRecords((KafkaProducer<byte[], byte[]>)producer$1, 100, tp, 0L);
            timestampsToSearch$1.put(tp, Predef$.MODULE$.long2Long((long)(i$1.elem * 20)));
            ++i$1.elem;
        });
    }
}

