/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.junit.jupiter.api.Assertions;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEw!\u0002/^\u0011\u0003\u0001g!\u00022^\u0011\u0003\u0019\u0007\"\u00026\u0002\t\u0003Y\u0007b\u00027\u0002\u0005\u0004%I!\u001c\u0005\u0007m\u0006\u0001\u000b\u0011\u00028\t\u000f]\f!\u0019!C\u0001q\"1A0\u0001Q\u0001\neDQ!`\u0001\u0005\u0002yDq!a\t\u0002\t\u0003\t)C\u0002\u0004\u00020\u0005\u0001\u0015\u0011\u0007\u0005\u000b\u0003\u0017J!Q3A\u0005\u0002\u00055\u0003BCA(\u0013\tE\t\u0015!\u0003\u0002\u0010!I\u0011\u0011K\u0005\u0003\u0016\u0004%\t\u0001\u001f\u0005\n\u0003'J!\u0011#Q\u0001\neD\u0011\"!\u0016\n\u0005+\u0007I\u0011\u0001=\t\u0013\u0005]\u0013B!E!\u0002\u0013I\bBCA-\u0013\tU\r\u0011\"\u0001\u0002\\!Q\u00111M\u0005\u0003\u0012\u0003\u0006I!!\u0018\t\u0013\u0005\u0015\u0014B!f\u0001\n\u0003A\b\"CA4\u0013\tE\t\u0015!\u0003z\u0011%\tI'\u0003BK\u0002\u0013\u0005\u0001\u0010C\u0005\u0002l%\u0011\t\u0012)A\u0005s\"1!.\u0003C\u0001\u0003[B\u0011\"a\u001f\n\u0005\u0004%\t!a\u0017\t\u0011\u0005u\u0014\u0002)A\u0005\u0003;B\u0011\"a \n\u0003\u0003%\t!!!\t\u0013\u0005=\u0015\"%A\u0005\u0002\u0005E\u0005\"CAT\u0013E\u0005I\u0011AAU\u0011%\ti+CI\u0001\n\u0003\tI\u000bC\u0005\u00020&\t\n\u0011\"\u0001\u00022\"I\u0011QW\u0005\u0012\u0002\u0013\u0005\u0011\u0011\u0016\u0005\n\u0003oK\u0011\u0013!C\u0001\u0003SC\u0001\"!/\n\u0003\u0003%\t%\u001c\u0005\t\u0003wK\u0011\u0011!C\u0001q\"I\u0011QX\u0005\u0002\u0002\u0013\u0005\u0011q\u0018\u0005\n\u0003\u0017L\u0011\u0011!C!\u0003\u001bD\u0011\"a7\n\u0003\u0003%\t!!8\t\u0013\u0005\u001d\u0018\"!A\u0005B\u0005%\b\"CAw\u0013\u0005\u0005I\u0011IAx\u0011%\t\t0CA\u0001\n\u0003\n\u0019\u0010C\u0005\u0002v&\t\t\u0011\"\u0011\u0002x\u001eI!qH\u0001\u0002\u0002#\u0005!\u0011\t\u0004\n\u0003_\t\u0011\u0011!E\u0001\u0005\u0007BaA\u001b\u0016\u0005\u0002\tU\u0003\"CAyU\u0005\u0005IQIAz\u0011%\u00119FKA\u0001\n\u0003\u0013I\u0006C\u0005\u0003h)\n\t\u0011\"!\u0003j!I!1\u0010\u0016\u0002\u0002\u0013%!Q\u0010\u0004\u0007\u0005\u000b\u000b\u0001Aa\"\t\r)\u0004D\u0011\u0001BQ\u0011!\u0011)\u000b\rb\u0001\n\u0003i\u0007b\u0002BTa\u0001\u0006IA\u001c\u0005\t\u0005S\u0003\u0004\u0019!C\u0001[\"I!1\u0016\u0019A\u0002\u0013\u0005!Q\u0016\u0005\b\u0005c\u0003\u0004\u0015)\u0003o\u0011!\u0011\u0019\f\rb\u0001\n\u0003A\bb\u0002B[a\u0001\u0006I!\u001f\u0005\n\u0005o\u0003\u0004\u0019!C\u0001\u0005sC\u0011Ba21\u0001\u0004%\tA!3\t\u0011\t5\u0007\u0007)Q\u0005\u0005wC\u0011Ba41\u0005\u0004%\tA!5\t\u0011\t\u001d\b\u0007)A\u0005\u0005'D\u0011B!;1\u0005\u0004%\tA!5\t\u0011\t-\b\u0007)A\u0005\u0005'D\u0011B!<1\u0001\u0004%\tAa<\t\u0013\r-\u0001\u00071A\u0005\u0002\r5\u0001\u0002CB\ta\u0001\u0006KA!=\t\u000f\rM\u0001\u0007\"\u0001\u0004\u0016!91Q\u0004\u0019\u0005B\t5\u0002bBA\u0012a\u0011\u00051q\u0004\u0005\b\u0007O\u0001D\u0011AB\u0015\u0011\u001d\u0019i\u0003\rC\u0001\u0007_Aqa!\u00141\t\u0003\u0011i\u0003C\u0004\u0004PA\"\ta!\u0015\t\u000f\ru\u0003\u0007\"\u0001\u0004`!91Q\u000f\u0019\u0005\u0002\r]\u0004bBB@a\u0011\u00051\u0011\u0011\u0005\b\u0007/\u0003D\u0011ABM\u0011\u001d\u0019i\n\rC\u0001\u0007?Cqaa,1\t\u0003\u0011i\u0003C\u0004\u00042B\"Iaa-\t\u000f\r\r\u0007\u0007\"\u0001\u0004F\u001a1!\u0011A\u0001\u0001\u0005\u0007AaA\u001b*\u0005\u0002\t\u0015\u0001\"\u0003B\u0004%\n\u0007I\u0011\u0002B\u0005\u0011!\u00119B\u0015Q\u0001\n\t-\u0001b\u0002B\r%\u0012\u0005!1\u0004\u0005\b\u0005?\u0011F\u0011\u0001B\u0011\u0011\u001d\u0011YC\u0015C\u0001\u0005[AqAa\fS\t\u0003\u0011i\u0003C\u0004\u00032I#\tAa\r\t\u000f\t\u0015\"\u000b\"\u0001\u0003:\u0005A\"+\u001a9mS\u000e\fG/[8o#V|G/Y:UKN$(+[4\u000b\u0003y\u000bQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002b\u00035\tQL\u0001\rSKBd\u0017nY1uS>t\u0017+^8uCN$Vm\u001d;SS\u001e\u001c\"!\u00013\u0011\u0005\u0015DW\"\u00014\u000b\u0003\u001d\fQa]2bY\u0006L!!\u001b4\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001-A\u0002eSJ,\u0012A\u001c\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u0006!A-\u001b:!\u0003\u0005YW#A=\u0011\u0005\u0015T\u0018BA>g\u0005\rIe\u000e^\u0001\u0003W\u0002\nA!\\1j]R\u0019q0!\u0002\u0011\u0007\u0015\f\t!C\u0002\u0002\u0004\u0019\u0014A!\u00168ji\"9\u0011qA\u0004A\u0002\u0005%\u0011\u0001B1sON\u0004R!ZA\u0006\u0003\u001fI1!!\u0004g\u0005\u0015\t%O]1z!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+1WBAA\f\u0015\r\tIbX\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ua-\u0001\u0004Qe\u0016$WMZ\u0005\u0004k\u0006\u0005\"bAA\u000fM\u0006\u0019!/\u001e8\u0015\u000f}\f9#a?\u0003<!9\u0011\u0011\u0006\u0005A\u0002\u0005-\u0012AB2p]\u001aLw\rE\u0002\u0002.%i\u0011!\u0001\u0002\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0014\r%!\u00171GA\u001d!\r)\u0017QG\u0005\u0004\u0003o1'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003w\t)E\u0004\u0003\u0002>\u0005\u0005c\u0002BA\u000b\u0003\u007fI\u0011aZ\u0005\u0004\u0003\u00072\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\nIE\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002D\u0019\fAA\\1nKV\u0011\u0011qB\u0001\u0006]\u0006lW\rI\u0001\bEJ|7.\u001a:t\u0003!\u0011'o\\6feN\u0004\u0013A\u00039beRLG/[8og\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003!!\bN]8ui2,WCAA/!\r)\u0017qL\u0005\u0004\u0003C2'\u0001\u0002'p]\u001e\f\u0011\u0002\u001e5s_R$H.\u001a\u0011\u0002!5\u001cxm\u001d)feB\u000b'\u000f^5uS>t\u0017!E7tON\u0004VM\u001d)beRLG/[8oA\u00059Qn]4TSj,\u0017\u0001C7tONK'0\u001a\u0011\u0015\u001d\u0005-\u0012qNA9\u0003g\n)(a\u001e\u0002z!9\u00111\n\fA\u0002\u0005=\u0001BBA)-\u0001\u0007\u0011\u0010\u0003\u0004\u0002VY\u0001\r!\u001f\u0005\b\u000332\u0002\u0019AA/\u0011\u0019\t)G\u0006a\u0001s\"1\u0011\u0011\u000e\fA\u0002e\fa\u0003^1sO\u0016$()\u001f;fgB+'O\u0011:pW\u0016\u0014XJQ\u0001\u0018i\u0006\u0014x-\u001a;CsR,7\u000fU3s\u0005J|7.\u001a:N\u0005\u0002\nAaY8qsRq\u00111FAB\u0003\u000b\u000b9)!#\u0002\f\u00065\u0005\"CA&3A\u0005\t\u0019AA\b\u0011!\t\t&\u0007I\u0001\u0002\u0004I\b\u0002CA+3A\u0005\t\u0019A=\t\u0013\u0005e\u0013\u0004%AA\u0002\u0005u\u0003\u0002CA33A\u0005\t\u0019A=\t\u0011\u0005%\u0014\u0004%AA\u0002e\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0014*\"\u0011qBAKW\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0013Ut7\r[3dW\u0016$'bAAQM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00161\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WS3!_AK\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00024*\"\u0011QLAK\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t-a2\u0011\u0007\u0015\f\u0019-C\u0002\u0002F\u001a\u00141!\u00118z\u0011!\tIMIA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002PB1\u0011\u0011[Al\u0003\u0003l!!a5\u000b\u0007\u0005Ug-\u0001\u0006d_2dWm\u0019;j_:LA!!7\u0002T\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ty.!:\u0011\u0007\u0015\f\t/C\u0002\u0002d\u001a\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002J\u0012\n\t\u00111\u0001\u0002B\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rq\u00171\u001e\u0005\t\u0003\u0013,\u0013\u0011!a\u0001s\u0006A\u0001.Y:i\u0007>$W\rF\u0001z\u0003!!xn\u0015;sS:<G#\u00018\u0002\r\u0015\fX/\u00197t)\u0011\ty.!?\t\u0013\u0005%\u0007&!AA\u0002\u0005\u0005\u0007bBA\u007f\u0011\u0001\u0007\u0011q`\u0001\bU>,(O\\1m!\r\tiC\u0015\u0002\b\u0015>,(O\\1m'\t\u0011F\r\u0006\u0002\u0002\u0000\u0006\u0019An\\4\u0016\u0005\t-\u0001\u0003\u0002B\u0007\u0005'i!Aa\u0004\u000b\u0007\tE!/\u0001\u0002j_&!!Q\u0003B\b\u0005\u00111\u0015\u000e\\3\u0002\t1|w\rI\u0001\u0010CB\u0004XM\u001c3U_*{WO\u001d8bYR\u0019qP!\b\t\u000f\u0005%b\u000b1\u0001\u0002,\u0005Y\u0011\r\u001d9f]\u0012\u001c\u0005.\u0019:u)\u0015y(1\u0005B\u0014\u0011\u001d\u0011)c\u0016a\u0001\u0003\u001f\tA\u0001]1uQ\"9!\u0011F,A\u0002\u0005}\u0017!\u00024jeN$\u0018A\u00025fC\u0012,'\u000fF\u0001\u0000\u0003\u00191wn\u001c;fe\u00061\u0011\r\u001d9f]\u0012$2a B\u001b\u0011\u001d\u00119D\u0017a\u0001\u0003\u001f\tq!\\3tg\u0006<W\r\u0006\u0002\u0002\u0010!9!Q\b\u0005A\u0002\u0005}\u0017!\u00063jgBd\u0017-_\"iCJ$8o\u00148TGJ,WM\\\u0001\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0011\u0007\u00055\"fE\u0003+\u0005\u000b\u0012\t\u0006\u0005\b\u0003H\t5\u0013qB=z\u0003;J\u00180a\u000b\u000e\u0005\t%#b\u0001B&M\u00069!/\u001e8uS6,\u0017\u0002\u0002B(\u0005\u0013\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\u0011iAa\u0015\n\t\u0005\u001d#q\u0002\u000b\u0003\u0005\u0003\nQ!\u00199qYf$b\"a\u000b\u0003\\\tu#q\fB1\u0005G\u0012)\u0007C\u0004\u0002L5\u0002\r!a\u0004\t\r\u0005ES\u00061\u0001z\u0011\u0019\t)&\fa\u0001s\"9\u0011\u0011L\u0017A\u0002\u0005u\u0003BBA3[\u0001\u0007\u0011\u0010\u0003\u0004\u0002j5\u0002\r!_\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YGa\u001e\u0011\u000b\u0015\u0014iG!\u001d\n\u0007\t=dM\u0001\u0004PaRLwN\u001c\t\fK\nM\u0014qB=z\u0003;J\u00180C\u0002\u0003v\u0019\u0014a\u0001V;qY\u00164\u0004\"\u0003B=]\u0005\u0005\t\u0019AA\u0016\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005\u007f\u00022a\u001cBA\u0013\r\u0011\u0019\t\u001d\u0002\u0007\u001f\nTWm\u0019;\u0003\u0015\u0015C\b/\u001a:j[\u0016tGoE\u00031\u0005\u0013\u0013)\n\u0005\u0003\u0003\f\nEUB\u0001BG\u0015\r\u0011y)X\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tM%Q\u0012\u0002\u0012#V|'/^7UKN$\b*\u0019:oKN\u001c\b\u0003\u0002BL\u0005;k!A!'\u000b\u0007\tmU,A\u0003vi&d7/\u0003\u0003\u0003 \ne%a\u0002'pO\u001eLgn\u001a\u000b\u0003\u0005G\u00032!!\f1\u0003%!x\u000e]5d\u001d\u0006lW-\u0001\u0006u_BL7MT1nK\u0002\na\"\u001a=qKJLW.\u001a8u\u001d\u0006lW-\u0001\nfqB,'/[7f]Rt\u0015-\\3`I\u0015\fHcA@\u00030\"A\u0011\u0011Z\u001b\u0002\u0002\u0003\u0007a.A\bfqB,'/[7f]Rt\u0015-\\3!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u000fM,'O^3sgV\u0011!1\u0018\t\u0007\u0003#\u0014iL!1\n\t\t}\u00161\u001b\u0002\u0004'\u0016\f\b\u0003\u0002BF\u0005\u0007LAA!2\u0003\u000e\nY1*\u00194lCN+'O^3s\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0007}\u0014Y\rC\u0005\u0002Jj\n\t\u00111\u0001\u0003<\u0006A1/\u001a:wKJ\u001c\b%A\u0006mK\u0006$WM\u001d*bi\u0016\u001cXC\u0001Bj!\u001d\u0011)Na7z\u0005?l!Aa6\u000b\t\te\u00171[\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iNa6\u0003\u00075\u000b\u0007\u000fE\u0003f\u0003\u0017\u0011\t\u000fE\u0002f\u0005GL1A!:g\u0005\u0019!u.\u001e2mK\u0006aA.Z1eKJ\u0014\u0016\r^3tA\u0005iam\u001c7m_^,'OU1uKN\faBZ8mY><XM\u001d*bi\u0016\u001c\b%A\u0006bI6Lgn\u00117jK:$XC\u0001By!\u0011\u0011\u0019pa\u0002\u000e\u0005\tU(\u0002\u0002B|\u0005s\fQ!\u00193nS:TAAa?\u0003~\u000691\r\\5f]R\u001c(b\u00010\u0003\u0000*!1\u0011AB\u0002\u0003\u0019\t\u0007/Y2iK*\u00111QA\u0001\u0004_J<\u0017\u0002BB\u0005\u0005k\u0014Q!\u00113nS:\fq\"\u00193nS:\u001cE.[3oi~#S-\u001d\u000b\u0004\u007f\u000e=\u0001\"CAe\u0003\u0006\u0005\t\u0019\u0001By\u00031\tG-\\5o\u00072LWM\u001c;!\u00031\u0019H/\u0019:u\u0005J|7.\u001a:t)\ry8q\u0003\u0005\b\u00073\u0019\u0005\u0019AB\u000e\u0003%\u0011'o\\6fe&#7\u000fE\u0003\u0002R\nu\u00160\u0001\u0005uK\u0006\u0014Hi\\<o)\u001dy8\u0011EB\u0012\u0007KAq!!\u000bF\u0001\u0004\tY\u0003C\u0004\u0002~\u0016\u0003\r!a@\t\u000f\tuR\t1\u0001\u0002`\u00069b/\u00197jI\u0006$X-\u00117m\u001f\u001a47/\u001a;t\u001b\u0006$8\r\u001b\u000b\u0004\u007f\u000e-\u0002bBA\u0015\r\u0002\u0007\u00111F\u0001\nY><w*\u001e;qkR$ra`B\u0019\u0007g\u0019Y\u0004C\u0004\u0002*\u001d\u0003\r!a\u000b\t\u000f\rUr\t1\u0001\u00048\u0005A!/\u001a9mS\u000e\f7\u000fE\u0004\u0002R\u000ee\u0012pa\u0007\n\t\tu\u00171\u001b\u0005\b\u0007{9\u0005\u0019AB \u00035qWm^!tg&<g.\\3oiBA\u0011\u0011[B\u001d\u0007\u0003\u001aY\u0002\u0005\u0003\u0004D\r%SBAB#\u0015\u0011\u00199E!@\u0002\r\r|W.\\8o\u0013\u0011\u0019Ye!\u0012\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006ir/Y5u\r>\u0014(+Z1tg&<g.\\3oiR{7i\\7qY\u0016$X-A\u0006sK:$WM]\"iCJ$H#C@\u0004T\r]3\u0011LB.\u0011\u001d\u0019)&\u0013a\u0001\u0005'\fA\u0001Z1uC\"9\u00111J%A\u0002\u0005=\u0001bBA\u007f\u0013\u0002\u0007\u0011q \u0005\b\u0005{I\u0005\u0019AAp\u0003Qi\u0017-\u001f2f\t&\u001c\b\u000f\\1z\u001f:\u001c6M]3f]R)qp!\u0019\u0004d!9!Q\b&A\u0002\u0005}\u0007bBB3\u0015\u0002\u00071qM\u0001\u0006G\"\f'\u000f\u001e\t\u0005\u0007S\u001a\t(\u0004\u0002\u0004l)!1QMB7\u0015\u0011\u0019yga\u0001\u0002\u000b)4'/Z3\n\t\rM41\u000e\u0002\u000b\u0015\u001a\u0013X-Z\"iCJ$\u0018aC<sSR,Gk\u001c$jY\u0016$ra`B=\u0007w\u001ai\bC\u0004\u0002L-\u0003\r!a\u0004\t\u000f\u0005u8\n1\u0001\u0002\u0000\"91QM&A\u0002\r\u001d\u0014aC2sK\u0006$Xm\u00115beR$baa\u001a\u0004\u0004\u000e\u0015\u0005bBA&\u0019\u0002\u0007\u0011q\u0002\u0005\b\u0007\u000fc\u0005\u0019ABE\u0003\u001d!\u0017\r^1tKR\u0004Baa#\u0004\u00146\u00111Q\u0012\u0006\u0005\u0007\u001f\u001b\t*\u0001\u0002ys*!1QKB7\u0013\u0011\u0019)j!$\u0003%aK6+\u001a:jKN\u001cu\u000e\u001c7fGRLwN\\\u0001\u000fC\u0012$G)\u0019;b)>\u001c\u0005.\u0019:u)\u0011\u0019Iia'\t\u000f\rUS\n1\u0001\u0003T\u00061!/Z2pe\u0012$\u0002b!)\u0004$\u000e\u001d61\u0016\t\u0006K\n5$q\u001c\u0005\b\u0007Ks\u0005\u0019\u0001Bj\u0003\u0015\u0011\u0018\r^3t\u0011\u0019\u0019IK\u0014a\u0001s\u0006A!M]8lKJLE\rC\u0004\u0004.:\u0003\rA!9\u0002\u0017\r,(O]3oiJ\u000bG/Z\u0001\u0011aJLg\u000e\u001e*bi\u0016lU\r\u001e:jGN\fA\"\\3bgV\u0014X\r\u001a*bi\u0016$bA!9\u00046\u000ee\u0006bBB\\!\u0002\u0007!\u0011Y\u0001\u0007EJ|7.\u001a:\t\u000f\rm\u0006\u000b1\u0001\u0004>\u00069!/\u001a9UsB,\u0007\u0003\u0002BF\u0007\u007fKAa!1\u0003\u000e\nI\u0011+^8uCRK\b/Z\u0001\u0005UN|g\u000e\u0006\u0003\u0002\u0010\r\u001d\u0007bBBe#\u0002\u000711Z\u0001\u0006i>\u0004\u0018n\u0019\t\u0006K\u000e5\u0017qB\u0005\u0004\u0007\u001f4'A\u0003\u001fsKB,\u0017\r^3e}\u0001")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
        ReplicationQuotasTestRig$.MODULE$.run(config, journal, displayChartsOnScreen);
    }

    public static void main(String[] args) {
        ReplicationQuotasTestRig$.MODULE$.main(args);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends QuorumTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        private Admin adminClient = null;

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public Admin adminClient() {
            return this.adminClient;
        }

        public void adminClient_$eq(Admin x$1) {
            this.adminClient = x$1;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            Predef$.MODULE$.println((Object)"Starting Brokers");
            this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)brokerIds.map((Function1 & Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1))).map((Function1 & Serializable)c -> {
                void createServer_time;
                Time time;
                Time time2 = time = Time.SYSTEM;
                time = null;
                Time time3 = time2;
                KafkaConfig createServer_config = KafkaConfig$.MODULE$.fromProps(c);
                TestUtils$ createServer_this = TestUtils$.MODULE$;
                None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
                return createServer_this.createServer(createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false);
            })));
            TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), 15000L);
            String brokerList = TestUtils$.MODULE$.bootstrapServers(this.servers(), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            this.adminClient_$eq(Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)scala.collection.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)brokerList)}))).asJava()));
        }

        @Override
        public void tearDown() {
            Utils.closeQuietly((AutoCloseable)this.adminClient(), (String)"adminClient");
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        /*
         * WARNING - void declaration
         */
        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            void var10_10;
            this.experimentName_$eq(config.name());
            Range.Inclusive brokers = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(100), 100 + config.brokers());
            IntRef count = IntRef.create((int)0);
            int shift = Math.round((float)config.brokers() / 2.0f);
            scala.collection.immutable.Map replicas = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), config.partitions()).map((Function1 & Serializable)partition -> Experiment.$anonfun$run$1(count, shift, config, BoxesRunTime.unboxToInt((Object)partition))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            Predef$.MODULE$.println((Object)"Writing Data");
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), config.msgsPerPartition()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), config.partitions()).foreach((Function1 & Serializable)partition -> producer.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)partition)), null, (Object)new byte[config.msgSize()]))));
            Predef$.MODULE$.println((Object)"Generating Reassignment");
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.adminClient(), this.json((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), brokers.mkString(","), true);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map newAssignment = (Map)tuple2._1();
            Predef$.MODULE$.println((Object)"Starting Reassignment");
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.adminClient(), false, new String(ReassignPartitionsZNode$.MODULE$.encode((Map)var10_10), StandardCharsets.UTF_8), config.throttle(), -1L, 10000L, Time.SYSTEM);
            this.waitForReassignmentToComplete();
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString());
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)var10_10);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString());
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            Map actual = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(17).append("The replicas are ").append(((IterableOps)replicas.toSeq().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString())).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int k = x0$1._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
                return tuple2;
            })).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                int k = x0$2._1$mcI$sp();
                ReplicaAssignment v = (ReplicaAssignment)x0$2._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)v.replicas());
                return tuple2;
            })).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString());
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString());
        }

        public void waitForReassignmentToComplete() {
            long waitUntilTrue_pause = 1000L;
            long waitUntilTrue_waitTimeMs = 3600000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!Experiment.$anonfun$waitForReassignmentToComplete$1(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Partition reassignments didn't complete.");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), waitUntilTrue_pause));
            }
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString());
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            if (displayChartsOnScreen) {
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            return ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)BoxesRunTime.boxToInteger((int)brokerId), (Function0 & Serializable)() -> (double[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()));
            leaderRatesBroker = (double[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.doubleArrayOps(leaderRatesBroker), (Object)new double[]{currentRate}, (ClassTag)ClassTag$.MODULE$.Double());
            return rates.put((Object)BoxesRunTime.boxToInteger((int)brokerId), (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            if (CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().contains((Object)metricName)) {
                return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)CollectionConverters$.MODULE$.MapHasAsScala(broker.metrics().metrics()).asScala().apply((Object)metricName)).metricValue());
            }
            return -1.0;
        }

        public String json(scala.collection.immutable.Seq<String> topic) {
            String topicStr = ((IterableOnceOps)topic.map((Function1 & Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString())).mkString(",");
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(IntRef count$1, int shift$1, ExperimentDef config$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        public static final /* synthetic */ Tuple2 $anonfun$run$1(IntRef count$1, int shift$1, ExperimentDef config$1, int partition) {
            int[] nArray = new int[1];
            ++count$1.elem;
            nArray[0] = 100 + (count$1.elem + shift$1) % config$1.brokers();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(nArray)));
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), config$2.partitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partitionId -> {
                boolean x$22;
                TopicPartition x$1;
                LogManager qual$1 = broker.getLogManager();
                long offset = BoxesRunTime.unboxToLong((Object)qual$1.getLog(x$1 = new TopicPartition($this.topicName(), partitionId), x$22 = qual$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.logEndOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
                if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                    throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
                }
            });
        }

        public static final /* synthetic */ boolean $anonfun$waitForReassignmentToComplete$1(Experiment $this) {
            $this.printRateMetrics();
            return ((java.util.Map)$this.adminClient().listPartitionReassignments().reassignments().get()).isEmpty();
        }

        public static final /* synthetic */ String $anonfun$waitForReassignmentToComplete$2() {
            return "Partition reassignments didn't complete.";
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                double[] values = (double[])x0$1._2();
                XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
                IntRef x = IntRef.create((int)0);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(values), (Function1)(JFunction1.mcVD.sp & Serializable)value -> {
                    series.add((double)x$5.elem, value);
                    ++x$5.elem;
                });
                dataset$1.addSeries(series);
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
            if (broker.config().brokerId() == 100) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
            }
            $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
            if (leaderRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
            }
            double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
            $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
            if (followerRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }
    }

    public static class ExperimentDef
    implements Product,
    Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.brokers());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.partitions());
                }
                case 3: {
                    return BoxesRunTime.boxToLong((long)this.throttle());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.msgsPerPartition());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger((int)this.msgSize());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "brokers";
                }
                case 2: {
                    return "partitions";
                }
                case 3: {
                    return "throttle";
                }
                case 4: {
                    return "msgsPerPartition";
                }
                case 5: {
                    return "msgSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.name())), (int)this.brokers()), (int)this.partitions()), (int)Statics.longHash((long)this.throttle())), (int)this.msgsPerPartition()), (int)this.msgSize()), (int)6);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            Product.$init$((Product)this);
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$1 = config.throttle();
            double arg$macro$2 = config.msgsPerPartition();
            double arg$macro$3 = config.msgSize();
            String message = new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(11).append("\n\n<h3>").append(config.name()).append("</h3>").toString()).append(new java.lang.StringBuilder(18).append("<p>- BrokerCount: ").append(config.brokers()).toString()).append(new java.lang.StringBuilder(21).append("<p>- PartitionCount: ").append(config.partitions()).toString()).append(StringOps$.MODULE$.format$extension("<p>- Throttle: %,.0f MB/s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}))).append(StringOps$.MODULE$.format$extension("<p>- MsgCount: %,.0f ", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$2)}))).append(StringOps$.MODULE$.format$extension("<p>- MsgSize: %,.0f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$3)}))).append(new java.lang.StringBuilder(32).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString()).toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            if (first) {
                message.append("<p><p>");
            }
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            if (!first) {
                message.append("<p><p>");
            }
            this.append(message.toString());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, stream, message){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

