/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.ClientRecordDeletion$;
import kafka.log.Defaults$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogLoader$;
import kafka.log.LogLoaderTest;
import kafka.log.LogLoaderTest$;
import kafka.log.LogLoaderTest$SimulateError$2$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.OffsetIndex;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rEa\u0001\u0002&L\u0001ACQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001A\u0002\u0013\u0005A\fC\u0004d\u0001\u0001\u0007I\u0011\u00013\t\r)\u0004\u0001\u0015)\u0003^\u0011\u001dY\u0007A1A\u0005\u00021Da\u0001\u001d\u0001!\u0002\u0013i\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000f]\u0004!\u0019!C\u0001e\"1\u0001\u0010\u0001Q\u0001\nMDq!\u001f\u0001C\u0002\u0013\u0005!\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B>\t\u0011\u0005%\u0001A1A\u0005\u0002iDq!a\u0003\u0001A\u0003%1\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002 \u0001!\t!!\t\t\u000f\u0005u\u0002\u0001\"\u0001\u0002\"!9\u0011q\t\u0001\u0005\u0002\u0005\u0005\u0002bBA)\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003+\u0002A\u0011AA\u0011\u0011\u001d\tI\u0006\u0001C\u0005\u00037B\u0011\"a-\u0001#\u0003%I!!.\t\u0013\u0005-\u0007!%A\u0005\n\u00055\u0007\"CAi\u0001E\u0005I\u0011BAg\u0011%\t\u0019\u000eAI\u0001\n\u0013\t)\u000eC\u0005\u0002Z\u0002\t\n\u0011\"\u0003\u0002\\\"I\u0011q\u001c\u0001\u0012\u0002\u0013%\u0011\u0011\u001d\u0005\n\u0003K\u0004\u0011\u0013!C\u0005\u0003CD\u0011\"a:\u0001#\u0003%I!!9\t\u0013\u0005%\b!%A\u0005\n\u0005-\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057A\u0011Ba\u0016\u0001#\u0003%IA!\u0017\t\u0013\tu\u0003!%A\u0005\n\t}\u0003\"\u0003B2\u0001E\u0005I\u0011BAg\u0011%\u0011)\u0007AI\u0001\n\u0013\u00119\u0007C\u0004\u0003l\u0001!IA!\u001c\t\u000f\t%\u0005\u0001\"\u0001\u0002\"!9!Q\u0012\u0001\u0005\u0002\u0005\u0005\u0002b\u0002BI\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0005+\u0003A\u0011AA\u0011\u0011\u001d\u0011I\n\u0001C\u0001\u0003CAqA!(\u0001\t\u0003\t\t\u0003C\u0004\u0003\"\u0002!\t!!\t\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002\"!9!\u0011\u0016\u0001\u0005\u0002\u0005\u0005\u0002b\u0002BW\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0005c\u0003A\u0011AA\u0011\u0011\u001d\u0011)\f\u0001C\u0001\u0003CAqA!/\u0001\t\u0003\t\t\u0003C\u0004\u0003>\u0002!\t!!\t\t\u000f\t\u0005\u0007\u0001\"\u0001\u0002\"!9!Q\u0019\u0001\u0005\u0002\u0005\u0005\u0002b\u0002Be\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0005\u001b\u0004A\u0011AA\u0011\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0003CAqA!6\u0001\t\u0003\t\t\u0003C\u0004\u0003Z\u0002!\t!!\t\t\u000f\tu\u0007\u0001\"\u0001\u0002\"!9!\u0011\u001d\u0001\u0005\u0002\u0005\u0005\u0002b\u0002Bs\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0005S\u0004A\u0011AA\u0011\u0011\u001d\u0011i\u000f\u0001C\u0001\u0003CAqA!=\u0001\t\u0003\t\t\u0003C\u0004\u0003v\u0002!\t!!\t\t\u000f\te\b\u0001\"\u0001\u0002\"!9!Q \u0001\u0005\u0002\u0005\u0005\u0002bBB\u0001\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0007\u000b\u0001A\u0011AA\u0011\u0011\u001d\u0019I\u0001\u0001C\u0001\u0003CAqa!\u0004\u0001\t\u0003\t\tCA\u0007M_\u001edu.\u00193feR+7\u000f\u001e\u0006\u0003\u00196\u000b1\u0001\\8h\u0015\u0005q\u0015!B6bM.\f7\u0001A\n\u0003\u0001E\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001Z!\tQ\u0006!D\u0001L\u0003\u0019\u0019wN\u001c4jOV\tQ\f\u0005\u0002_C6\tqL\u0003\u0002a\u001b\u000611/\u001a:wKJL!AY0\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000bG>tg-[4`I\u0015\fHCA3i!\t\u0011f-\u0003\u0002h'\n!QK\\5u\u0011\u001dI7!!AA\u0002u\u000b1\u0001\u001f\u00132\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0001C\u0019:pW\u0016\u0014Hk\u001c9jGN#\u0018\r^:\u0016\u00035\u0004\"A\u00188\n\u0005=|&\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003E\u0011'o\\6feR{\u0007/[2Ti\u0006$8\u000fI\u0001\u0018[\u0006DHK]1og\u0006\u001cG/[8o)&lWm\\;u\u001bN,\u0012a\u001d\t\u0003%RL!!^*\u0003\u0007%sG/\u0001\rnCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\n\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\u0006QR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u00051A/\u001c9ESJ,\u0012a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018AA5p\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\t[>\u001c7\u000eV5nKV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC'\u0002\u000bU$\u0018\u000e\\:\n\t\u0005m\u0011Q\u0003\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002K\"\u001a\u0011#!\n\u0011\t\u0005\u001d\u0012\u0011H\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005\u0019\u0011\r]5\u000b\t\u0005=\u0012\u0011G\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t\u0019$!\u000e\u0002\u000b),h.\u001b;\u000b\u0005\u0005]\u0012aA8sO&!\u00111HA\u0015\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u001a!#!\u0011\u0011\t\u0005\u001d\u00121I\u0005\u0005\u0003\u000b\nICA\u0005BMR,'/R1dQ\u00061C/Z:u\u0019><'+Z2pm\u0016\u0014\u00180S:DC2dW\rZ+q_:\u0014%o\\6fe\u000e\u0013\u0018m\u001d5)\u0007M\tY\u0005\u0005\u0003\u0002(\u00055\u0013\u0002BA(\u0003S\u0011A\u0001V3ti\u0006\u0019D/Z:u!J|G-^2feNs\u0017\r]:i_R\u001c(+Z2pm\u0016\u0014\u00180\u00114uKJ,fn\u00197fC:\u001c\u0006.\u001e;e_^tg+\r\u0015\u0004)\u0005-\u0013!\u0012;fgR\u0004&o\u001c3vG\u0016\u00148K\\1qg\"|Go\u001d*fG>4XM]=BMR,'/\u00168dY\u0016\fgn\u00155vi\u0012|wO\\\"veJ,g\u000e^'fgN\fw-\u001a$pe6\fG\u000fK\u0002\u0016\u0003\u0017\n\u0011b\u0019:fCR,Gj\\4\u00151\u0005u\u00131MA4\u0003_\n\t(a\u001f\u0002\u0000\u0005%\u0015\u0011UAR\u0003K\u000bI\u000bE\u0002[\u0003?J1!!\u0019L\u0005))f.\u001b4jK\u0012dun\u001a\u0005\u0007\u0003K2\u0002\u0019A>\u0002\u0007\u0011L'\u000f\u0003\u0004\\-\u0001\u0007\u0011\u0011\u000e\t\u00045\u0006-\u0014bAA7\u0017\nIAj\\4D_:4\u0017n\u001a\u0005\bWZ\u0001\n\u00111\u0001n\u0011%\t\u0019H\u0006I\u0001\u0002\u0004\t)(\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0011\u0007I\u000b9(C\u0002\u0002zM\u0013A\u0001T8oO\"I\u0011Q\u0010\f\u0011\u0002\u0003\u0007\u0011QO\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0013\u0005\u0005e\u0003%AA\u0002\u0005\r\u0015!C:dQ\u0016$W\u000f\\3s!\u0011\t\u0019\"!\"\n\t\u0005\u001d\u0015Q\u0003\u0002\n'\u000eDW\rZ;mKJD\u0011\"a#\u0017!\u0003\u0005\r!!$\u0002\tQLW.\u001a\t\u0005\u0003\u001f\u000bi*\u0004\u0002\u0002\u0012*!\u0011qCAJ\u0015\u0011\t)*a&\u0002\r\r|W.\\8o\u0015\rq\u0015\u0011\u0014\u0006\u0005\u00037\u000b)$\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003?\u000b\tJ\u0001\u0003US6,\u0007bB9\u0017!\u0003\u0005\ra\u001d\u0005\boZ\u0001\n\u00111\u0001t\u0011!\t9K\u0006I\u0001\u0002\u0004\u0019\u0018a\t9s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|gn\u00115fG.Le\u000e^3sm\u0006dWj\u001d\u0005\n\u0003W3\u0002\u0013!a\u0001\u0003[\u000b\u0011\u0003\\1tiNCW\u000f\u001e3po:\u001cE.Z1o!\r\u0011\u0016qV\u0005\u0004\u0003c\u001b&a\u0002\"p_2,\u0017M\\\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0003oS3!\\A]W\t\tY\f\u0005\u0003\u0002>\u0006\u001dWBAA`\u0015\u0011\t\t-a1\u0002\u0013Ut7\r[3dW\u0016$'bAAc'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0017q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\"TCAAhU\u0011\t)(!/\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001b\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\u0005]'\u0006BAB\u0003s\u000b1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uI]*\"!!8+\t\u00055\u0015\u0011X\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$H\u0005O\u000b\u0003\u0003GT3a]A]\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u0013:\u0003Q\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00132a\u0005!2M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cE*\"!!<+\t\u00055\u0016\u0011X\u0001\u001cGJ,\u0017\r^3M_\u001e<\u0016\u000e\u001e5PM\u001a\u001cX\r^(wKJ4Gn\\<\u0015\t\u0005M\u0018q \t\b%\u0006U\u0018QLA}\u0013\r\t9p\u0015\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007i\u000bY0C\u0002\u0002~.\u0013!\u0002T8h'\u0016<W.\u001a8u\u0011\u001d\u0011\t\u0001\ta\u0001\u0003S\n\u0011\u0002\\8h\u0007>tg-[4\u0002\u001fI,7m\u001c<fe\u0006sGm\u00115fG.$b!!\u0018\u0003\b\t%\u0001BB.\"\u0001\u0004\tI\u0007C\u0004\u0003\f\u0005\u0002\rA!\u0004\u0002\u0019\u0015D\b/Z2uK\u0012\\U-_:\u0011\r\t=!QCA;\u001b\t\u0011\tBC\u0002\u0003\u0014M\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119B!\u0005\u0003\u0011%#XM]1cY\u0016\fqd]5oO2,Go\u001c8SK\u000e|'\u000fZ:XSRDG*Z1eKJ,\u0005o\\2i)A\u0011iB!\u000b\u0003:\tu\"\u0011\tB#\u0005\u001f\u0012\u0019\u0006\u0005\u0003\u0003 \t\u0015RB\u0001B\u0011\u0015\u0011\u0011\u0019#a%\u0002\rI,7m\u001c:e\u0013\u0011\u00119C!\t\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0011YC\ta\u0001\u0005[\tQA^1mk\u0016\u0004RA\u0015B\u0018\u0005gI1A!\rT\u0005\u0015\t%O]1z!\r\u0011&QG\u0005\u0004\u0005o\u0019&\u0001\u0002\"zi\u0016D\u0011Ba\u000f#!\u0003\u0005\rA!\f\u0002\u0007-,\u0017\u0010\u0003\u0004\u0003@\t\u0002\ra]\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000eC\u0004\u0003D\t\u0002\r!!\u001e\u0002\r=4gm]3u\u0011%\u00119E\tI\u0001\u0002\u0004\u0011I%A\u0003d_\u0012,7\r\u0005\u0003\u0003 \t-\u0013\u0002\u0002B'\u0005C\u0011qbQ8naJ,7o]5p]RK\b/\u001a\u0005\n\u0005#\u0012\u0003\u0013!a\u0001\u0003k\n\u0011\u0002^5nKN$\u0018-\u001c9\t\u0013\tU#\u0005%AA\u0002\tM\u0012AC7bO&\u001cg+\u00197vK\u0006I3/\u001b8hY\u0016$xN\u001c*fG>\u0014Hm],ji\"dU-\u00193fe\u0016\u0003xn\u00195%I\u00164\u0017-\u001e7uII*\"Aa\u0017+\t\t5\u0012\u0011X\u0001*g&tw\r\\3u_:\u0014VmY8sIN<\u0016\u000e\u001e5MK\u0006$WM]#q_\u000eDG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u0005$\u0006\u0002B%\u0003s\u000b\u0011f]5oO2,Go\u001c8SK\u000e|'\u000fZ:XSRDG*Z1eKJ,\u0005o\\2iI\u0011,g-Y;mi\u00122\u0014!K:j]\u001edW\r^8o%\u0016\u001cwN\u001d3t/&$\b\u000eT3bI\u0016\u0014X\t]8dQ\u0012\"WMZ1vYR$s'\u0006\u0002\u0003j)\"!1GA]\u0003E\"Xm\u001d;Qe>$WoY3s':\f\u0007o\u001d5piN\u0014VmY8wKJL\u0018I\u001a;feVs7\r\\3b]NCW\u000f\u001e3po:$2!\u001aB8\u0011\u001d\u0011\th\na\u0001\u0005g\nA#\\3tg\u0006<WMR8s[\u0006$h+\u001a:tS>t\u0007\u0003\u0002B;\u0005\u0007sAAa\u001e\u0003\u0000A\u0019!\u0011P*\u000e\u0005\tm$b\u0001B?\u001f\u00061AH]8pizJ1A!!T\u0003\u0019\u0001&/\u001a3fM&!!Q\u0011BD\u0005\u0019\u0019FO]5oO*\u0019!\u0011Q*\u0002gQ,7\u000f^*lSBdu.\u00193j]\u001eLe-R7qif\u0004&o\u001c3vG\u0016\u00148\u000b^1uK\n+gm\u001c:f)J,hnY1uS>t\u0007f\u0001\u0015\u0002L\u0005\tD/Z:u%\u0016\u001cwN^3s\u0003\u001a$XM\u001d(p]6{gn\u001c;p]&\u001c7i\\8sI&t\u0017\r^8s\u000bB|7\r[,sSR,\u0007fA\u0015\u0002L\u0005iD/Z:u'.L\u0007\u000f\u0016:v]\u000e\fG/Z!oIJ+Gn\\1e\u0013\u001a|E\u000eZ'fgN\fw-\u001a$pe6\fG/\u00118e\u001d>\u001cE.Z1o'\",H\u000fZ8x]\"\u001a!&a\u0013\u0002wQ,7\u000f^*lSB$&/\u001e8dCR,\u0017I\u001c3SK2|\u0017\rZ%g\u001f2$W*Z:tC\u001e,gi\u001c:nCR\fe\u000eZ\"mK\u0006t7\u000b[;uI><h\u000eK\u0002,\u0003\u0017\n1\b^3tiN[\u0017\u000e\u001d+sk:\u001c\u0017\r^3B]\u0012\u0014V\r\\8bI&3g*Z<NKN\u001c\u0018mZ3G_Jl\u0017\r^!oI\u000ecW-\u00198TQV$Hm\\<oQ\ra\u00131J\u0001.i\u0016\u001cH\u000fT8bIB\u0013x\u000eZ;dKJ\u001c\u0018I\u001a;fe\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t\u001b&$7+Z4nK:$\bfA\u0017\u0002L\u0005!D/Z:u\u0019>\fG-\u001b8h\u0019><7*Z3qg2\u000b'oZ3tiN#(/Y=Qe>$WoY3s'R\fG/Z*oCB\u001c\bn\u001c;)\u00079\nY%\u0001\u0017uKN$Hj\\1e!J|G-^2feN\fe\r^3s\t\u0016dW\r^3SK\u000e|'\u000fZ:P]N+w-\\3oi\"\u001aq&a\u0013\u0002=Q,7\u000f\u001e'pOJ+7m\u001c<feN$vnQ8se\u0016\u001cGo\u00144gg\u0016$\bf\u0001\u0019\u0002L\u0005\u0001B/Z:u\u0013:$W\r\u001f*fEVLG\u000e\u001a\u0015\u0004c\u0005-\u0013A\t;fgR\u0014VMY;jY\u0012$\u0016.\\3J]\u0012,\u0007PR8s\u001f2$W*Z:tC\u001e,7\u000fK\u00023\u0003\u0017\nq\u0003^3ti\u000e{'O];qi&sG-\u001a=SK\n,\u0018\u000e\u001c3)\u0007M\nY%\u0001\u0011uKN$(i\\4vg&sG-\u001a=TK\u001elWM\u001c;t\u0003J,'+Z7pm\u0016$\u0007f\u0001\u001b\u0002L\u00051B/Z:u%\u0016|\u0007/\u001a8UQ\u0016tGK];oG\u0006$X\rK\u00026\u0003\u0017\nA\u0004^3ti>\u0003XM\u001c#fY\u0016$Xm](cg>dW\r^3GS2,7\u000fK\u00027\u0003\u0017\na\u0002^3ti\u000e{'O];qi2{w\rK\u00028\u0003\u0017\nA\u0004^3ti>3XM]\"p[B\f7\r^3e\u0019><'+Z2pm\u0016\u0014\u0018\u0010K\u00029\u0003\u0017\nA\b^3ti2+\u0017\rZ3s\u000bB|7\r[\"bG\",7\t\\3be\u0016$\u0017I\u001a;feN#\u0018\r^5d\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;E_^twM]1eK\"\u001a\u0011(a\u0013\u0002OQ,7\u000f^(wKJ\u001cu.\u001c9bGR,G\rT8h%\u0016\u001cwN^3ss6+H\u000e^5SK\u000e|'\u000f\u001a\u0015\u0004u\u0005-\u0013!\u000b;fgR|e/\u001a:D_6\u0004\u0018m\u0019;fI2{wMU3d_Z,'/_'vYRL'+Z2pe\u00124\u0016\u0007K\u0002<\u0003\u0017\nq\u0005^3tiJ+7m\u001c<fef|emU3h[\u0016tGoV5uQ>3gm]3u\u001fZ,'O\u001a7po\"\u001aA(a\u0013\u0002OQ,7\u000f\u001e*fG>4XM]=BMR,'o\u0011:bg\"$UO]5oON\u0003H.\u001b;QQ\u0006\u001cX-\r\u0015\u0004{\u0005-\u0013a\n;fgR\u0014VmY8wKJL\u0018I\u001a;fe\u000e\u0013\u0018m\u001d5EkJLgnZ*qY&$\b\u000b[1tKJB3APA&\u0003\u001d\"Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCNDG)\u001e:j]\u001e\u001c\u0006\u000f\\5u!\"\f7/Z\u001a)\u0007}\nY%A\u0014uKN$(+Z2pm\u0016\u0014\u00180\u00114uKJ\u001c%/Y:i\tV\u0014\u0018N\\4Ta2LG\u000f\u00155bg\u0016$\u0004f\u0001!\u0002L\u00059C/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eR;sS:<7\u000b\u001d7jiBC\u0017m]36Q\r\t\u00151J\u0001\u0016i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7fQ\r\u0011\u00151J\u0001\u001ei\u0016\u001cH\u000fT8h%\u0016\u001cwN^3sg\u001a{'\u000fT3bI\u0016\u0014X\t]8dQ\"\u001a1)a\u0013\u0002AQ,7\u000f\u001e$vY2$&/\u00198tC\u000e$\u0018n\u001c8J]\u0012,\u0007PU3d_Z,'/\u001f\u0015\u0004\t\u0006-\u0013A\u0007;fgR\u0014VmY8wKJ|e\u000e\\=MCN$8+Z4nK:$\bfA#\u0002L\u0005)C/Z:u%\u0016\u001cwN^3s\u0019\u0006\u001cHoU3h[\u0016tGoV5uQ:{7K\\1qg\"|Go\u001d\u0015\u0004\r\u0006-\u0013A\t;fgRdunZ#oI2+7o\u001d+iC:\u001cF/\u0019:u\u0003\u001a$XM\u001d*f_B,g\u000eK\u0002H\u0003\u0017\nq\t^3ti\u000e{'O];qi\u0016$Gj\\4SK\u000e|g/\u001a:z\t>,7OT8u\t\u0016dW\r^3Qe>$WoY3s'R\fG/Z*oCB\u001c\bn\u001c;t!>\u001cHOU3d_Z,'/\u001f\u0015\u0004\u0011\u0006-\u0013!\t;fgR\u0014VmY8wKJ<\u0016\u000e\u001e5F[B$\u00180Q2uSZ,7+Z4nK:$\bfA%\u0002L\u0001")
public class LogLoaderTest {
    private KafkaConfig config = null;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final int maxTransactionTimeoutMs;
    private final int maxProducerIdExpirationMs;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime mockTime = new MockTime();

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        None$ none$4;
        boolean bl = true;
        boolean bl2 = true;
        None$ none$5 = none$4 = None$.MODULE$;
        none$4 = null;
        None$ x$6 = none$5;
        None$ none$6 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$7 = none$6;
        None$ none$7 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$7;
        boolean bl3 = true;
        boolean bl4 = false;
        int n = TestUtils$.MODULE$.RandomPort();
        boolean bl5 = false;
        int n2 = TestUtils$.MODULE$.RandomPort();
        boolean bl6 = false;
        int n3 = TestUtils$.MODULE$.RandomPort();
        None$ none$8 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$16 = none$8;
        int n4 = 1;
        boolean bl7 = false;
        int n5 = 1;
        short s = 1;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", bl, bl2, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl3, bl4, n, bl5, n2, bl6, n3, (Option<String>)x$16, n4, bl7, n5, s);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogRecoveryIsCalledUponBrokerCrash() {
        LogManager logManager;
        LogManager logManager2;
        File file;
        File file2;
        File file3;
        LazyRef SimulateError$module = new LazyRef();
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File logDir = file6;
        Properties logProps = new Properties();
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        scala.collection.immutable.Seq logDirs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{logDir}));
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        MockTime time = new MockTime();
        BooleanRef cleanShutdownInterceptedValue = BooleanRef.create((boolean)false);
        if (this.SimulateError$3(SimulateError$module) == null) {
            throw null;
        }
        public class Kafka_log_LogLoaderTest$SimulateError$1
        implements Product,
        Serializable {
            private boolean hasError;
            private final /* synthetic */ LogLoaderTest $outer;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public boolean hasError() {
                return this.hasError;
            }

            public void hasError_$eq(boolean x$1) {
                this.hasError = x$1;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1 copy(boolean hasError) {
                return new Kafka_log_LogLoaderTest$SimulateError$1(this.$outer, hasError);
            }

            public boolean copy$default$1() {
                return this.hasError();
            }

            public String productPrefix() {
                return "SimulateError";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToBoolean((boolean)this.hasError());
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "hasError";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)"SimulateError".hashCode()), (int)(this.hasError() ? 1231 : 1237)), (int)1);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean equals(Object x$1) {
                block3: {
                    block2: {
                        if (this == x$1) break block2;
                        boolean bl = x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
                        if (!bl) break block3;
                        Kafka_log_LogLoaderTest$SimulateError$1 var3_3 = (Kafka_log_LogLoaderTest$SimulateError$1)x$1;
                        if (!(this.hasError() == var3_3.hasError())) break block3;
                    }
                    return true;
                }
                return false;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1(LogLoaderTest $outer, boolean hasError) {
                this.hasError = hasError;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        Kafka_log_LogLoaderTest$SimulateError$1 simulateError = this.SimulateError$3(SimulateError$module).apply(false);
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        File cleanShutdownFile = new File(logDir, LogLoader$.MODULE$.CleanShutdownFile());
        LogManager logManager3 = logManager2 = new LogManager(this, logDirs, logConfig, maxTransactionTimeoutMs, maxProducerIdExpirationMs, time, simulateError, cleanShutdownInterceptedValue){
            private final /* synthetic */ LogLoaderTest $outer;
            private final Kafka_log_LogLoaderTest$SimulateError$1 simulateError$1;
            private final BooleanRef cleanShutdownInterceptedValue$1;
            private final int maxProducerIdExpirationMs$1;
            private final MockTime time$1;
            private final LogConfig logConfig$1;

            public UnifiedLog loadLog(File logDir, boolean hadCleanShutdown, Map<TopicPartition, Object> recoveryPoints, Map<TopicPartition, Object> logStartOffsets, LogConfig defaultConfig, Map<String, LogConfig> topicConfigs) {
                TopicPartition topicPartition;
                if (this.simulateError$1.hasError()) {
                    throw new RuntimeException("Simulated error");
                }
                this.cleanShutdownInterceptedValue$1.elem = hadCleanShutdown;
                TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(logDir);
                topicPartition = null;
                TopicPartition topicPartition3 = topicPartition2;
                LogConfig config = (LogConfig)topicConfigs.getOrElse((Object)topicPartition3.topic(), (Function0 & Serializable)() -> defaultConfig);
                long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)recoveryPoints.getOrElse((Object)topicPartition3, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                long logStartOffset = BoxesRunTime.unboxToLong((Object)logStartOffsets.getOrElse((Object)topicPartition3, (Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(topicPartition3);
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(logDir, topicPartition3, logDirFailureChannel, config.recordVersion(), "");
                ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition3, logDir, this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs$1, (Time)this.time$1);
                LoadedLogOffsets offsets = new LogLoader(logDir, topicPartition3, config, (Scheduler)this.time$1.scheduler(), (Time)this.time$1, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, logRecoveryPoint, leaderEpochCache, producerStateManager).load();
                LocalLog localLog = new LocalLog(logDir, this.logConfig$1, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), topicPartition3, logDirFailureChannel);
                return new UnifiedLog(offsets.logStartOffset(), localLog, this.$outer.brokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
            }
            {
                String string;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulateError$1 = simulateError$1;
                this.cleanShutdownInterceptedValue$1 = cleanShutdownInterceptedValue$1;
                this.maxProducerIdExpirationMs$1 = maxProducerIdExpirationMs$1;
                this.time$1 = time$1;
                this.logConfig$1 = logConfig$1;
                int n = 1;
                long l = 0x400000L;
                double d = 0.9;
                int n2 = 0x100000;
                int n3 = 0x2000000;
                double d2 = Double.MAX_VALUE;
                long l2 = 15000L;
                String string2 = string = "MD5";
                string = null;
                String x$9 = string2;
                super((Seq)logDirs$1.map((Function1)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final File apply(File x$1) {
                        return x$1.getAbsoluteFile();
                    }
                }), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))), (ConfigRepository)new MockConfigRepository(), logConfig$1, new CleanerConfig(n, l, d, n2, n3, d2, l2, false, x$9), 4, 1000L, 10000L, 10000L, 1000L, maxTransactionTimeoutMs$1, maxProducerIdExpirationMs$1, $outer.config().interBrokerProtocolVersion(), (Scheduler)time$1.scheduler(), new BrokerTopicStats(), new LogDirFailureChannel(logDirs$1.size()), (Time)time$1, $outer.config().usesTopicId());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loadLog$1(kafka.log.LogConfig ), $anonfun$loadLog$2(), $anonfun$loadLog$3()}, serializedLambda);
            }
        };
        logManager2 = null;
        LogManager logManager4 = logManager3;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = logManager4.getOrCreateLog$default$3();
        logManager4.getOrCreateLog(topicPartition, true, x$4, (Option)x$3);
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        cleanShutdownInterceptedValue.elem = false;
        LogConfig defaultConfig = logManager4.currentDefaultConfig();
        logManager4.loadLogs(defaultConfig, logManager4.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertTrue((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        cleanShutdownInterceptedValue.elem = true;
        defaultConfig = logManager4.currentDefaultConfig();
        logManager4.loadLogs(defaultConfig, logManager4.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        logManager4.shutdown();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        simulateError.hasError_$eq(true);
        LogManager logManager5 = logManager = new /* invalid duplicate definition of identical inner class */;
        logManager = null;
        LogManager logManager6 = logManager5;
        None$ x$7 = None$.MODULE$;
        boolean x$8 = logManager6.getOrCreateLog$default$3();
        logManager6.getOrCreateLog(topicPartition, true, x$8, (Option)x$7);
        Assertions.assertThrows(RuntimeException.class, () -> {
            LogConfig defaultConfig = logManager6.currentDefaultConfig();
            logManager6.loadLogs(defaultConfig, logManager6.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        });
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not have existed");
        simulateError.hasError_$eq(false);
        cleanShutdownInterceptedValue.elem = true;
        LogConfig defaultConfig2 = logManager6.currentDefaultConfig();
        logManager6.loadLogs(defaultConfig2, logManager6.fetchTopicConfigOverrides(defaultConfig2, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value for clean shutdown flag");
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownV1() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.minSupportedFor(RecordVersion.V1).version());
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownCurrentMessageFormat() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(ApiVersion$.MODULE$.latestVersion().version());
    }

    private UnifiedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean) {
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, lastShutdownClean, (Option<Uuid>)None$.MODULE$, true);
    }

    private BrokerTopicStats createLog$default$3() {
        return this.brokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLog$default$7() {
        return this.mockTime();
    }

    private int createLog$default$8() {
        return this.maxTransactionTimeoutMs();
    }

    private int createLog$default$9() {
        return this.maxProducerIdExpirationMs();
    }

    private int createLog$default$10() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    private boolean createLog$default$11() {
        return true;
    }

    private Tuple2<UnifiedLog, LogSegment> createLogWithOffsetOverflow(LogConfig logConfig) {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.logDir());
        File x$1 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$4 = brokerTopicStats2;
        long l = 0L;
        Scheduler x$6 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$7 = mockTime2;
        int n = this.maxTransactionTimeoutMs();
        int n2 = this.maxProducerIdExpirationMs();
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        boolean bl = true;
        UnifiedLog log = this.createLog(x$1, logConfig, x$4, l, Long.MAX_VALUE, x$6, (Time)x$7, n, n2, n3, bl);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        return new Tuple2((Object)log, (Object)segmentWithOverflow);
    }

    private UnifiedLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.logDir(), config, expectedKeys, this.brokerTopicStats(), (Time)this.mockTime(), this.mockTime().scheduler());
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords singletonRecordsWithLeaderEpoch(byte[] value, byte[] key, int leaderEpoch, long offset, CompressionType codec, long timestamp, byte magicValue) {
        MemoryRecordsBuilder memoryRecordsBuilder;
        void builder_isTransactional;
        void builder_baseSequence;
        void builder_producerEpoch;
        void builder_logAppendTime;
        MemoryRecordsBuilder memoryRecordsBuilder2;
        scala.collection.immutable.Seq records = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(timestamp, key, value)}));
        ByteBuffer buf = ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)records).asJava()));
        long l = this.mockTime().milliseconds();
        TimestampType builder_timestampType = TimestampType.CREATE_TIME;
        boolean bl = false;
        int n = -1;
        int n2 = -1;
        long builder_producerId = -1L;
        MemoryRecordsBuilder memoryRecordsBuilder3 = memoryRecordsBuilder2 = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)builder_timestampType, (long)offset, (long)builder_logAppendTime, (long)builder_producerId, (short)builder_producerEpoch, (int)builder_baseSequence, (boolean)builder_isTransactional, (boolean)false, (int)leaderEpoch);
        memoryRecordsBuilder2 = null;
        MemoryRecordsBuilder memoryRecordsBuilder4 = memoryRecordsBuilder = memoryRecordsBuilder3;
        Object var13_11 = null;
        memoryRecordsBuilder = null;
        MemoryRecordsBuilder builder = memoryRecordsBuilder4;
        records.foreach((Function1 & Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private byte[] singletonRecordsWithLeaderEpoch$default$2() {
        return null;
    }

    private CompressionType singletonRecordsWithLeaderEpoch$default$5() {
        return CompressionType.NONE;
    }

    private long singletonRecordsWithLeaderEpoch$default$6() {
        return -1L;
    }

    private byte singletonRecordsWithLeaderEpoch$default$7() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private void testProducerSnapshotsRecoveryAfterUncleanShutdown(String messageFormatVersion) {
        void var14_11;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "640");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((UnifiedLog)log.elem).oldestProducerSnapshotOffset());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertTrue((((UnifiedLog)log.elem).logSegments().size() >= 5 ? 1 : 0) != 0);
        Vector segmentOffsets = (Vector)((UnifiedLog)log.elem).logSegments().toVector().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.baseOffset()));
        long activeSegmentOffset = BoxesRunTime.unboxToLong((Object)segmentOffsets.last());
        long offsetForSegmentAfterRecoveryPoint = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 3));
        long offsetForRecoveryPointSegment = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 4));
        Tuple2 tuple2 = segmentOffsets.toSet().partition((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> x$3 < offsetForRecoveryPointSegment);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set segOffsetsBeforeRecovery = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set segOffsetsAfterRecovery = (scala.collection.immutable.Set)tuple2._2();
        long recoveryPoint = offsetForRecoveryPointSegment + 1L;
        Assertions.assertTrue((recoveryPoint < offsetForSegmentAfterRecoveryPoint ? 1 : 0) != 0);
        ((UnifiedLog)log.elem).close();
        scala.collection.mutable.Set segmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set recoveredSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSegmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSnapshotOffsets = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        if (logConfig.messageFormatVersion().$less((Object)KAFKA_0_11_0_IV0$.MODULE$)) {
            expectedSegmentsWithReads.$plus$eq((Object)BoxesRunTime.boxToLong((long)activeSegmentOffset));
            expectedSnapshotOffsets.$plus$plus$eq((IterableOnce)((IterableOnceOps)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.baseOffset()))).toVector().takeRight(2).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset())));
        } else {
            void var13_10;
            expectedSegmentsWithReads.$plus$plus$eq((IterableOnce)var13_10.$plus$plus((IterableOnce)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset}))));
            expectedSnapshotOffsets.$plus$plus$eq((IterableOnce)((IterableOnceOps)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()))).toVector().takeRight(4).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset())));
        }
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 2)));
        log.elem = this.createLogWithInterceptedReads$1(offsetForRecoveryPointSegment, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)expectedSegmentsWithReads, (Object)segmentsWithReads.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset())));
        Assertions.assertEquals((Object)var14_11, (Object)recoveredSegments.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset())));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
        segmentsWithReads.clear();
        recoveredSegments.clear();
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(offsetForRecoveryPointSegment);
        log.elem = this.createLogWithInterceptedReads$1(recoveryPoint, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset})), (Object)segmentsWithReads.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset())));
        Assertions.assertEquals((Object)var14_11, (Object)recoveredSegments.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset())));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testSkipLoadingIfEmptyProducerStateBeforeTruncation() {
        TopicPartition topicPartition;
        int maxTransactionTimeoutMs = 60000;
        int maxProducerIdExpirationMs = 300000;
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxProducerIdExpirationMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxProducerIdExpirationMs));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        File parseTopicPartitionName_dir = this.logDir();
        TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        Object var12_4 = null;
        topicPartition = null;
        TopicPartition topicPartition3 = topicPartition2;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        LogConfig config = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition3);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition3, logDirFailureChannel, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition3, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, segments, 0L, 0L, leaderEpochCache, stateManager).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition3, logDirFailureChannel);
        UnifiedLog log = new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((scala.collection.immutable.Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).truncateAndReload(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L), ArgumentMatchers.anyLong());
        Mockito.reset((Object[])new ProducerStateManager[]{stateManager});
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(2L);
        Mockito.reset((Object[])new ProducerStateManager[]{stateManager});
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)2L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        log.truncateTo(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).truncateAndReload(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1L), ArgumentMatchers.anyLong());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
    }

    @Test
    public void testRecoverAfterNonMonotonicCoordinatorEpochWrite() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        long producerId = 1L;
        int coordinatorEpoch = 5;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$6 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 0x500000, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        short epoch = (short)0;
        long firstAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, firstAppendTimestamp, coordinatorEpoch, 0);
        Assertions.assertEquals((long)firstAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        int maxProducerIdExpirationMs = 3600000;
        this.mockTime().sleep(maxProducerIdExpirationMs);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.producerStateManager().lastEntry(producerId));
        long secondAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, secondAppendTimestamp, coordinatorEpoch - 1, 0);
        log.close();
        File x$11 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$15 = brokerTopicStats2;
        long l6 = 0L;
        Scheduler x$17 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$18 = mockTime2;
        int n4 = this.maxTransactionTimeoutMs();
        int n5 = this.maxProducerIdExpirationMs();
        int n6 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log = this.createLog(x$11, logConfig, x$15, l6, 0L, x$17, (Time)x$18, n4, n5, n6, false);
        Assertions.assertEquals((long)secondAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        log.close();
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndNoCleanShutdown() {
        TopicPartition topicPartition;
        int maxTransactionTimeoutMs = 60000;
        int maxProducerIdExpirationMs = 300000;
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxProducerIdExpirationMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxProducerIdExpirationMs));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        File parseTopicPartitionName_dir = this.logDir();
        TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        Object var11_4 = null;
        topicPartition = null;
        TopicPartition topicPartition3 = topicPartition2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition3);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition3, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition3, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, false, segments, 0L, 0L, leaderEpochCache, stateManager).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition3, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((scala.collection.immutable.Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndCleanShutdown() {
        TopicPartition topicPartition;
        int maxTransactionTimeoutMs = 60000;
        int maxProducerIdExpirationMs = 300000;
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxProducerIdExpirationMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxProducerIdExpirationMs));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        File parseTopicPartitionName_dir = this.logDir();
        TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        Object var11_4 = null;
        topicPartition = null;
        TopicPartition topicPartition3 = topicPartition2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition3);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition3, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition3, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, leaderEpochCache, stateManager).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition3, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((scala.collection.immutable.Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
    }

    @Test
    public void testSkipTruncateAndReloadIfNewMessageFormatAndCleanShutdown() {
        TopicPartition topicPartition;
        int maxTransactionTimeoutMs = 60000;
        int maxProducerIdExpirationMs = 300000;
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxProducerIdExpirationMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxProducerIdExpirationMs));
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        File parseTopicPartitionName_dir = this.logDir();
        TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        Object var11_4 = null;
        topicPartition = null;
        TopicPartition topicPartition3 = topicPartition2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition3);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition3, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition3, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, leaderEpochCache, stateManager).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition3, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((scala.collection.immutable.Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsMidSegment() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        CompressionType compressionType;
        CompressionType compressionType2;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$6 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 10240, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        List x$11 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes())}));
        byte by = 2;
        CompressionType compressionType3 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$16 = compressionType3;
        long l6 = 0L;
        int n4 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, by, x$16, pid1, epoch, 0, l6, n4), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        List x$19 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes())}));
        byte by2 = 2;
        CompressionType compressionType4 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$24 = compressionType4;
        long l7 = 0L;
        int n5 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, by2, x$24, pid2, epoch, 0, l7, n5), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$31 = brokerTopicStats2;
        long l8 = 0L;
        Scheduler x$33 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$34 = mockTime2;
        int n6 = this.maxTransactionTimeoutMs();
        int n7 = this.maxProducerIdExpirationMs();
        int n8 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, 1L, l8, x$33, (Time)x$34, n6, n7, n8, false);
        Assertions.assertEquals((int)2, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedLastSeqOpt);
    }

    @Test
    public void testLoadingLogKeepsLargestStrayProducerStateSnapshot() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        CompressionType compressionType;
        CompressionType compressionType2;
        CompressionType compressionType3;
        CompressionType compressionType4;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$7 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 10240, 60000L, 0L, l2, x$7, n, n2, n3, 0L);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        long pid1 = 1L;
        short epoch = (short)0;
        List x$112 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("a".getBytes())}));
        byte by = 2;
        CompressionType compressionType5 = compressionType4 = CompressionType.NONE;
        compressionType4 = null;
        CompressionType x$16 = compressionType5;
        long l3 = 0L;
        int n4 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$112, by, x$16, pid1, epoch, 0, l3, n4), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        List x$19 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("b".getBytes())}));
        byte by2 = 2;
        CompressionType compressionType6 = compressionType3 = CompressionType.NONE;
        compressionType3 = null;
        CompressionType x$24 = compressionType6;
        long l4 = 0L;
        int n5 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, by2, x$24, pid1, epoch, 1, l4, n5), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        List x$27 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("c".getBytes())}));
        byte by3 = 2;
        CompressionType compressionType7 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$32 = compressionType7;
        long l5 = 0L;
        int n6 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$27, by3, x$32, pid1, epoch, 2, l5, n6), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        List x$35 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("d".getBytes())}));
        byte by4 = 2;
        CompressionType compressionType8 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$40 = compressionType8;
        long l6 = 0L;
        int n7 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, by4, x$40, pid1, epoch, 3, l6, n7), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.close();
        Assertions.assertEquals((int)log.logSegments().size(), (int)3);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.offset()))).sorted((Ordering)Ordering.Long$.MODULE$));
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).toPath(), new FileAttribute[0]);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset()))).sorted((Ordering)Ordering.Long$.MODULE$));
        File x$43 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$46 = brokerTopicStats2;
        long l7 = 0L;
        long l8 = 0L;
        Scheduler x$49 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$50 = mockTime2;
        int n8 = this.maxTransactionTimeoutMs();
        int n9 = this.maxProducerIdExpirationMs();
        int n10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        this.createLog(x$43, logConfig, x$46, l7, l8, x$49, (Time)x$50, n8, n9, n10, false);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqOps)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset()))).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsOnSegment() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        CompressionType compressionType;
        CompressionType compressionType2;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$6 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 10240, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        List x$11 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes())}));
        byte by = 2;
        CompressionType compressionType3 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$16 = compressionType3;
        long l6 = 0L;
        int n4 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, by, x$16, pid1, epoch, 0, l6, n4), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        List x$19 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes())}));
        byte by2 = 2;
        CompressionType compressionType4 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$24 = compressionType4;
        long l7 = 0L;
        int n5 = -1;
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, by2, x$24, pid2, epoch, 0, l7, n5), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$31 = brokerTopicStats2;
        long l8 = 0L;
        Scheduler x$33 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$34 = mockTime2;
        int n6 = this.maxTransactionTimeoutMs();
        int n7 = this.maxProducerIdExpirationMs();
        int n8 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, 1L, l8, x$33, (Time)x$34, n6, n7, n8, false);
        Assertions.assertEquals((int)1, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedEntryOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedEntryOpt);
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        MockTime mockTime2;
        BrokerTopicStats brokerTopicStats2;
        String string;
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, segmentSize, l2, l3, l4, x$8, n, indexInterval, 4096, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testLogRecoversToCorrectOffset$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        long lastIndexOffset = ((UnifiedLog)log.elem).activeSegment().offsetIndex().lastOffset();
        int numIndexEntries = ((UnifiedLog)log.elem).activeSegment().offsetIndex().entries();
        long lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        long lastTimeIndexOffset = ((UnifiedLog)log.elem).logEndOffset() - 1L;
        long lastTimeIndexTimestamp = ((UnifiedLog)log.elem).activeSegment().largestTimestamp();
        int numTimeIndexEntries = ((UnifiedLog)log.elem).activeSegment().timeIndex().entries() + (((UnifiedLog)log.elem).activeSegment().timeIndex().lastEntry().offset() == ((UnifiedLog)log.elem).logEndOffset() - 1L ? 0 : 1);
        ((UnifiedLog)log.elem).close();
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats3 = brokerTopicStats2 = this.brokerTopicStats();
        brokerTopicStats2 = null;
        BrokerTopicStats x$25 = brokerTopicStats3;
        long l6 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime3 = mockTime2 = this.mockTime();
        mockTime2 = null;
        MockTime x$28 = mockTime3;
        int n2 = this.maxTransactionTimeoutMs();
        int n3 = this.maxProducerIdExpirationMs();
        int n4 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$21, logConfig, x$25, l6, lastOffset, x$27, (Time)x$28, n2, n3, n4, false);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
        int recoveryPoint = 10;
        File x$32 = this.logDir();
        long x$34 = recoveryPoint;
        BrokerTopicStats brokerTopicStats4 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$36 = brokerTopicStats4;
        long l7 = 0L;
        Scheduler x$38 = this.createLog$default$6();
        MockTime mockTime4 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$39 = mockTime4;
        int n5 = this.maxTransactionTimeoutMs();
        int n6 = this.maxProducerIdExpirationMs();
        int n7 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$32, logConfig, x$36, l7, x$34, x$38, (Time)x$39, n5, n6, n7, false);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, recoveryPoint, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).flush(false);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        int numMessages = 200;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$7 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 200, l2, l3, l4, x$7, n, 1, n2, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$14 -> x$14.lazyOffsetIndex().file());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$15 -> x$15.lazyTimeIndex().file());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.delete()));
        timeIndexFiles.foreach((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.delete()));
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$24 = brokerTopicStats2;
        long l6 = 0L;
        long l7 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$28 = mockTime2;
        int n3 = this.maxTransactionTimeoutMs();
        int n4 = this.maxProducerIdExpirationMs();
        int n5 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$21, logConfig, x$24, l6, l7, x$27, (Time)x$28, n3, n4, n5, false);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).offsetIndex().entries() > 0 ? 1 : 0) != 0, (String)"The index should have been rebuilt");
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).timeIndex().entries() > 0 ? 1 : 0) != 0, (String)"The time index should have been rebuilt");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)((UnifiedLog)log$3.elem).read((long)i, 100, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$3.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$3.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$3.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testRebuildTimeIndexForOldMessages() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        int numMessages = 200;
        int segmentSize = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$18 -> x$18.lazyTimeIndex().file());
        ((UnifiedLog)log.elem).close();
        timeIndexFiles.foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$3(file);
            return BoxedUnit.UNIT;
        });
        File x$11 = this.logDir();
        long x$13 = numMessages + 1;
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$15 = brokerTopicStats2;
        long l = 0L;
        Scheduler x$17 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$182 = mockTime2;
        int n = this.maxTransactionTimeoutMs();
        int n2 = this.maxProducerIdExpirationMs();
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$11, logConfig, x$15, l, x$13, x$17, (Time)x$182, n, n2, n3, false);
        ((IterableOnceOps)((UnifiedLog)log.elem).logSegments().init()).foreach((Function1 & Serializable)segment -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$4(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCorruptIndexRebuild() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        int numMessages = 200;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$7 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 200, l2, l3, l4, x$7, n, 1, n2, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testCorruptIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$19 -> x$19.lazyOffsetIndex().file());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable)x$20 -> x$20.lazyTimeIndex().file());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$4(file);
            return BoxedUnit.UNIT;
        });
        timeIndexFiles.foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$5(file);
            return BoxedUnit.UNIT;
        });
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$24 = brokerTopicStats2;
        long l6 = 0L;
        long l7 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$28 = mockTime2;
        int n3 = this.maxTransactionTimeoutMs();
        int n4 = this.maxProducerIdExpirationMs();
        int n5 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$21, logConfig, x$24, l6, l7, x$27, (Time)x$28, n3, n4, n5, false);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)((UnifiedLog)log$5.elem).read((long)i, 100, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$5.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$5.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$5.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        String string;
        void timeIndexFile_suffix;
        void timeIndexFile_offset;
        File file;
        String string2;
        void offsetIndexFile_suffix;
        void offsetIndexFile_offset;
        File file2;
        String string3;
        void timeIndexFile_suffix2;
        void timeIndexFile_offset2;
        File file3;
        String string4;
        void offsetIndexFile_suffix2;
        void offsetIndexFile_offset2;
        File file4;
        String string5;
        String string6 = string5 = "";
        string5 = null;
        String string7 = string6;
        long l = 0L;
        File offsetIndexFile_dir = this.logDir();
        File file5 = file4 = LocalLog$.MODULE$.offsetIndexFile(offsetIndexFile_dir, (long)offsetIndexFile_offset2, (String)offsetIndexFile_suffix2);
        Object var9_4 = null;
        string7 = null;
        file4 = null;
        File bogusIndex1 = file5;
        String string8 = string4 = "";
        string4 = null;
        String string9 = string8;
        long l2 = 0L;
        File timeIndexFile_dir = this.logDir();
        File file6 = file3 = LocalLog$.MODULE$.timeIndexFile(timeIndexFile_dir, (long)timeIndexFile_offset2, (String)timeIndexFile_suffix2);
        Object var14_10 = null;
        string9 = null;
        file3 = null;
        File bogusTimeIndex1 = file6;
        String string10 = string3 = "";
        string3 = null;
        String string11 = string10;
        long l3 = 5L;
        File offsetIndexFile_dir2 = this.logDir();
        File file7 = file2 = LocalLog$.MODULE$.offsetIndexFile(offsetIndexFile_dir2, (long)offsetIndexFile_offset, (String)offsetIndexFile_suffix);
        Object var19_16 = null;
        string11 = null;
        file2 = null;
        File bogusIndex2 = file7;
        String string12 = string2 = "";
        string2 = null;
        String string13 = string12;
        long l4 = 5L;
        File timeIndexFile_dir2 = this.logDir();
        File file8 = file = LocalLog$.MODULE$.timeIndexFile(timeIndexFile_dir2, (long)timeIndexFile_offset, (String)timeIndexFile_suffix);
        Object var24_22 = null;
        string13 = null;
        file = null;
        File bogusTimeIndex2 = file8;
        bogusIndex2.createNewFile();
        bogusTimeIndex2.createNewFile();
        int x$1 = this.createRecords$1().sizeInBytes() * 5;
        long l5 = Defaults$.MODULE$.SegmentMs();
        long l6 = Defaults$.MODULE$.RetentionMs();
        long l7 = Defaults$.MODULE$.RetentionSize();
        long l8 = Defaults$.MODULE$.SegmentJitterMs();
        String string14 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string14;
        int n = Defaults$.MODULE$.MaxMessageSize();
        long l9 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l5, x$1, l6, l7, l8, x$8, n, 1, 1000, l9);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        ((LogSegment)log.logSegments().toSeq().head()).offsetIndex();
        ((LogSegment)log.logSegments().toSeq().head()).timeIndex();
        Assertions.assertTrue((bogusIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first index file should have been replaced with a larger file");
        Assertions.assertTrue((bogusTimeIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first time index file should have been replaced with a larger file");
        Assertions.assertFalse((boolean)bogusIndex2.exists(), (String)"The second index file should have been deleted.");
        Assertions.assertFalse((boolean)bogusTimeIndex2.exists(), (String)"The second time index file should have been deleted.");
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable)x$21 -> log.appendAsLeader(this.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        int x$1 = this.createRecords$2().sizeInBytes() * 5;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, x$1, l2, l3, l4, x$8, n, 10000, 1000, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$22 -> LogLoaderTest.$anonfun$testReopenThenTruncate$1(this, log, BoxesRunTime.unboxToInt((Object)x$22)));
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$19 = brokerTopicStats2;
        long l6 = 0L;
        long l7 = 0L;
        Scheduler x$222 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$23 = mockTime2;
        int n2 = this.maxTransactionTimeoutMs();
        int n3 = this.maxProducerIdExpirationMs();
        int n4 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$16, logConfig, x$19, l6, l7, x$222, (Time)x$23, n2, n3, n4, false);
        ((UnifiedLog)log.elem).truncateTo(3L);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"All but one segment should be deleted.");
        Assertions.assertEquals((long)3L, (long)((UnifiedLog)log.elem).logEndOffset(), (String)"Log end offset should be 3.");
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        int x$1 = this.createRecords$3().sizeInBytes() * 5;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionSize();
        long l3 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$7 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        long l4 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, x$1, 999L, l2, l3, x$7, n, n2, 1000, l4);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$23 -> LogLoaderTest.$anonfun$testOpenDeletesObsoleteFiles$1(this, log, BoxesRunTime.unboxToInt((Object)x$23)));
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).deleteOldSegments();
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$19 = brokerTopicStats2;
        long l5 = 0L;
        long l6 = 0L;
        Scheduler x$22 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$232 = mockTime2;
        int n3 = this.maxTransactionTimeoutMs();
        int n4 = this.maxProducerIdExpirationMs();
        int n5 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$16, logConfig, x$19, l5, l6, x$22, (Time)x$232, n3, n4, n5, false);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"The deleted segments should be gone.");
    }

    @Test
    public void testCorruptLog() {
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$27 -> {
            MockTime mockTime;
            this.logDir().mkdirs();
            ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
            int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)x$24 -> LogLoaderTest.$anonfun$testCorruptLog$2(this, log, BoxesRunTime.unboxToInt((Object)x$24)));
            List records = ((IterableOnceOps)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable)x$25 -> CollectionConverters$.MODULE$.IterableHasAsScala(x$25.log().records()).asScala().toList())).toList();
            ((UnifiedLog)log.elem).close();
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().lazyOffsetIndex().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            File x$16 = this.logDir();
            BrokerTopicStats x$18 = this.brokerTopicStats();
            Scheduler x$22 = this.createLog$default$6();
            MockTime mockTime2 = mockTime = this.mockTime();
            mockTime = null;
            MockTime x$23 = mockTime2;
            int n = this.maxTransactionTimeoutMs();
            int n2 = this.maxProducerIdExpirationMs();
            int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
            log.elem = this.createLog(x$16, logConfig, x$18, 0L, recoveryPoint, x$22, (Time)x$23, n, n2, n3, false);
            Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset());
            List recovered = ((IterableOnceOps)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable)x$26 -> CollectionConverters$.MODULE$.IterableHasAsScala(x$26.log().records()).asScala().toList())).toList();
            Assertions.assertEquals((int)records.size(), (int)recovered.size());
            records.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Record expected = (Record)records.apply(i);
                Record actual = (Record)recovered.apply(i);
                Assertions.assertEquals((Object)expected.key(), (Object)actual.key(), (String)"Keys not equal");
                Assertions.assertEquals((Object)expected.value(), (Object)actual.value(), (String)"Values not equal");
                Assertions.assertEquals((long)expected.timestamp(), (long)actual.timestamp(), (String)"Timestamps not equal");
            });
            Utils.delete((File)this.logDir());
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOverCompactedLogRecovery() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        MemoryRecords memoryRecords2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        void withRecords_compressionType3;
        MemoryRecords memoryRecords3;
        void withRecords_records4;
        void withRecords_partitionLeaderEpoch4;
        void withRecords_compressionType4;
        MemoryRecords memoryRecords4;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords5 = memoryRecords4 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withRecords_records4);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords4 = null;
        MemoryRecords set1 = memoryRecords5;
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes())};
        boolean bl2 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = (long)Integer.MAX_VALUE + 2L;
        MemoryRecords memoryRecords6 = memoryRecords3 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        compressionType2 = null;
        simpleRecordArray2 = null;
        memoryRecords3 = null;
        MemoryRecords set2 = memoryRecords6;
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("v4".getBytes(), "k4".getBytes())};
        boolean bl3 = false;
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset3 = (long)Integer.MAX_VALUE + 3L;
        MemoryRecords memoryRecords7 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        compressionType3 = null;
        simpleRecordArray3 = null;
        memoryRecords2 = null;
        MemoryRecords set3 = memoryRecords7;
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes())};
        boolean bl4 = false;
        CompressionType compressionType4 = CompressionType.NONE;
        long withRecords_initialOffset4 = (long)Integer.MAX_VALUE + 4L;
        MemoryRecords memoryRecords8 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset4, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType4 = null;
        simpleRecordArray4 = null;
        memoryRecords = null;
        MemoryRecords set4 = memoryRecords8;
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        Object[] indexFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecovery$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFiles), (Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecovery$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testLeaderEpochCacheClearedAfterStaticMessageFormatDowngrade() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("foo".getBytes())}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.latestEpoch());
        log.close();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "1000");
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), "65536");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig downgradedLogConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$11 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$14 = brokerTopicStats2;
        long l6 = 0L;
        long l7 = 0L;
        Scheduler x$17 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$18 = mockTime2;
        int n2 = this.maxTransactionTimeoutMs();
        int n3 = this.maxProducerIdExpirationMs();
        int n4 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reopened = this.createLog(x$11, downgradedLogConfig, x$14, l6, l7, x$17, (Time)x$18, n2, n3, n4, false);
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
        reopened.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{new SimpleRecord("bar".getBytes())}))), RecordVersion.V1.value, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1), 5, reopened.appendAsLeader$default$3(), reopened.appendAsLeader$default$4(), reopened.appendAsLeader$default$5());
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOverCompactedLogRecoveryMultiRecord() {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        MemoryRecords memoryRecords;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        MemoryRecords memoryRecords2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        void withRecords_compressionType3;
        MemoryRecords memoryRecords3;
        void withRecords_records4;
        void withRecords_partitionLeaderEpoch4;
        void withRecords_compressionType4;
        MemoryRecords memoryRecords4;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())};
        boolean bl = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = 0L;
        MemoryRecords memoryRecords5 = memoryRecords4 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType4, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch4, (boolean)false, (SimpleRecord[])withRecords_records4);
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords4 = null;
        MemoryRecords set1 = memoryRecords5;
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())};
        boolean bl2 = false;
        CompressionType compressionType2 = CompressionType.GZIP;
        long withRecords_initialOffset2 = (long)Integer.MAX_VALUE + 2L;
        MemoryRecords memoryRecords6 = memoryRecords3 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3);
        compressionType2 = null;
        simpleRecordArray2 = null;
        memoryRecords3 = null;
        MemoryRecords set2 = memoryRecords6;
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())};
        boolean bl3 = false;
        CompressionType compressionType3 = CompressionType.GZIP;
        long withRecords_initialOffset3 = (long)Integer.MAX_VALUE + 4L;
        MemoryRecords memoryRecords7 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2);
        compressionType3 = null;
        simpleRecordArray3 = null;
        memoryRecords2 = null;
        MemoryRecords set3 = memoryRecords7;
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())};
        boolean bl4 = false;
        CompressionType compressionType4 = CompressionType.GZIP;
        long withRecords_initialOffset4 = (long)Integer.MAX_VALUE + 6L;
        MemoryRecords memoryRecords8 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset4, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records);
        compressionType4 = null;
        simpleRecordArray4 = null;
        memoryRecords = null;
        MemoryRecords set4 = memoryRecords8;
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        Object[] indexFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFiles), (Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOverCompactedLogRecoveryMultiRecordV1() {
        MemoryRecords memoryRecords;
        void withRecords_records;
        void withRecords_compressionType;
        void withRecords_initialOffset;
        MemoryRecords memoryRecords2;
        MemoryRecords memoryRecords3;
        void withRecords_records2;
        void withRecords_compressionType2;
        void withRecords_initialOffset2;
        MemoryRecords memoryRecords4;
        MemoryRecords memoryRecords5;
        void withRecords_records3;
        void withRecords_compressionType3;
        void withRecords_initialOffset3;
        MemoryRecords memoryRecords6;
        MemoryRecords memoryRecords7;
        void withRecords_records4;
        void withRecords_compressionType4;
        void withRecords_initialOffset4;
        MemoryRecords memoryRecords8;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long l6 = 0L;
        byte withRecords_magic = 1;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords9 = memoryRecords8 = MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset4, (CompressionType)withRecords_compressionType4, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records4);
        Object var45_15 = null;
        memoryRecords8 = null;
        MemoryRecords memoryRecords10 = memoryRecords7 = memoryRecords9;
        compressionType = null;
        simpleRecordArray = null;
        memoryRecords7 = null;
        MemoryRecords set1 = memoryRecords10;
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())};
        CompressionType compressionType2 = CompressionType.GZIP;
        long l7 = (long)Integer.MAX_VALUE + 2L;
        byte withRecords_magic2 = 1;
        TimestampType withRecords_timestampType2 = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords11 = memoryRecords6 = MemoryRecords.withRecords((byte)withRecords_magic2, (long)withRecords_initialOffset3, (CompressionType)withRecords_compressionType3, (TimestampType)withRecords_timestampType2, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records3);
        Object var47_23 = null;
        memoryRecords6 = null;
        MemoryRecords memoryRecords12 = memoryRecords5 = memoryRecords11;
        compressionType2 = null;
        simpleRecordArray2 = null;
        memoryRecords5 = null;
        MemoryRecords set2 = memoryRecords12;
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())};
        CompressionType compressionType3 = CompressionType.GZIP;
        long l8 = (long)Integer.MAX_VALUE + 4L;
        byte withRecords_magic3 = 1;
        TimestampType withRecords_timestampType3 = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords13 = memoryRecords4 = MemoryRecords.withRecords((byte)withRecords_magic3, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType2, (TimestampType)withRecords_timestampType3, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records2);
        Object var49_31 = null;
        memoryRecords4 = null;
        MemoryRecords memoryRecords14 = memoryRecords3 = memoryRecords13;
        compressionType3 = null;
        simpleRecordArray3 = null;
        memoryRecords3 = null;
        MemoryRecords set3 = memoryRecords14;
        SimpleRecord[] simpleRecordArray4 = new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())};
        CompressionType compressionType4 = CompressionType.GZIP;
        long l9 = (long)Integer.MAX_VALUE + 6L;
        byte withRecords_magic4 = 1;
        TimestampType withRecords_timestampType4 = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords15 = memoryRecords2 = MemoryRecords.withRecords((byte)withRecords_magic4, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType4, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var51_39 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords16 = memoryRecords = memoryRecords15;
        compressionType4 = null;
        simpleRecordArray4 = null;
        memoryRecords = null;
        MemoryRecords set4 = memoryRecords16;
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)3L, (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 4L).exists());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        log.close();
        Object[] indexFiles = (File[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(file)));
        Assertions.assertEquals((int)3, (int)indexFiles.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(indexFiles), (Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryOfSegmentWithOffsetOverflow() {
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        recoveredLog.logSegments().foreach(arg_0 -> LogLoaderTest.$anonfun$testRecoveryOfSegmentWithOffsetOverflow$1((UnifiedLog)var4_12, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase1() {
        void var5_13;
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        int numSegmentsInitial = var4_12.logSegments().size();
        var4_12.splitOverflowedSegment((LogSegment)var5_13).reverse().foreach((Function1 & Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(segment)));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(file))).foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase2() {
        void var5_13;
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        int numSegmentsInitial = var4_12.logSegments().size();
        List newSegments = var4_12.splitOverflowedSegment((LogSegment)var5_13);
        newSegments.reverse().foreach((Function1 & Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(newSegments, segment)));
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(file))).foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase3() {
        void var5_13;
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        int numSegmentsInitial = var4_12.logSegments().size();
        var4_12.splitOverflowedSegment((LogSegment)var5_13).reverse().foreach((Function1 & Serializable)segment -> {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(file))).foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(file);
            return BoxedUnit.UNIT;
        });
        var5_13.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        var4_12.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase4() {
        void var5_13;
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        int numSegmentsInitial = var4_12.logSegments().size();
        var4_12.splitOverflowedSegment((LogSegment)var5_13).reverse().foreach((Function1 & Serializable)x$32 -> {
            x$32.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(file))).foreach((Function1 & Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(file);
            return BoxedUnit.UNIT;
        });
        var5_13.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase5() {
        void var5_13;
        void var4_12;
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        int n = Defaults$.MODULE$.SegmentSize();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n2 = Defaults$.MODULE$.MaxMessageSize();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, n, l2, l3, l4, x$8, n2, 1, n3, 1000L);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var4_12);
        int numSegmentsInitial = var4_12.logSegments().size();
        ((LogSegment)var4_12.splitOverflowedSegment((LogSegment)var5_13).last()).changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        var5_13.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    @Test
    public void testCleanShutdownFile() {
        String string;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 1000, l2, l3, l4, x$8, 65536, 1, n, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable)x$34 -> LogLoaderTest.$anonfun$testCleanShutdownFile$1(this, log, BoxesRunTime.unboxToInt((Object)x$34)));
        ((UnifiedLog)log.elem).close();
        long recoveryPoint = ((UnifiedLog)log.elem).logEndOffset();
        log.elem = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        Assertions.assertEquals((long)recoveryPoint, (long)((UnifiedLog)log.elem).logEndOffset());
    }

    @Test
    public void testLogRecoversForLeaderEpoch() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        CompressionType compressionType;
        CompressionType compressionType2;
        CompressionType compressionType3;
        CompressionType compressionType4;
        UnifiedLog log = this.createLog(this.logDir(), LogConfig$.MODULE$.apply(), this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        LeaderEpochFileCache leaderEpochCache = (LeaderEpochFileCache)log.leaderEpochCache().get();
        byte[] x$1 = "random".getBytes();
        CompressionType compressionType5 = compressionType4 = CompressionType.NONE;
        compressionType4 = null;
        CompressionType x$5 = compressionType5;
        long l = -1L;
        byte by = 2;
        MemoryRecords firstBatch = this.singletonRecordsWithLeaderEpoch(x$1, null, 1, 0L, x$5, l, by);
        log.appendAsFollower(firstBatch);
        byte[] x$8 = "random".getBytes();
        CompressionType compressionType6 = compressionType3 = CompressionType.NONE;
        compressionType3 = null;
        CompressionType x$12 = compressionType6;
        long l2 = -1L;
        byte by2 = 2;
        MemoryRecords secondBatch = this.singletonRecordsWithLeaderEpoch(x$8, null, 2, 1L, x$12, l2, by2);
        log.appendAsFollower(secondBatch);
        byte[] x$15 = "random".getBytes();
        CompressionType compressionType7 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$19 = compressionType7;
        long l3 = -1L;
        byte by3 = 2;
        MemoryRecords thirdBatch = this.singletonRecordsWithLeaderEpoch(x$15, null, 2, 2L, x$19, l3, by3);
        log.appendAsFollower(thirdBatch);
        byte[] x$22 = "random".getBytes();
        CompressionType compressionType8 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$26 = compressionType8;
        long l4 = -1L;
        byte by4 = 2;
        MemoryRecords fourthBatch = this.singletonRecordsWithLeaderEpoch(x$22, null, 3, 3L, x$26, l4, by4);
        log.appendAsFollower(fourthBatch);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        leaderEpochCache.truncateFromEnd(2L);
        Assertions.assertNotEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        log.close();
        File x$29 = this.logDir();
        LogConfig x$30 = LogConfig$.MODULE$.apply();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$32 = brokerTopicStats2;
        long l5 = 0L;
        long l6 = 0L;
        Scheduler x$35 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$36 = mockTime2;
        int n = this.maxTransactionTimeoutMs();
        int n2 = this.maxProducerIdExpirationMs();
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog recoveredLog = this.createLog(x$29, x$30, x$32, l5, l6, x$35, (Time)x$36, n, n2, n3, false);
        LeaderEpochFileCache recoveredLeaderEpochCache = (LeaderEpochFileCache)recoveredLog.leaderEpochCache().get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)recoveredLeaderEpochCache.epochEntries());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFullTransactionIndexRecovery() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        void appendTransactionalAsLeader_time;
        Function1<Object, BoxedUnit> function1;
        void appendTransactionalAsLeader_time2;
        Function1<Object, BoxedUnit> function12;
        void appendTransactionalAsLeader_time3;
        Function1<Object, BoxedUnit> function13;
        void appendTransactionalAsLeader_time4;
        Function1<Object, BoxedUnit> function14;
        String string2;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$6 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 640, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        MockTime mockTime2 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function15 = function14 = appendTransactionalAsLeader_this.appendIdempotentAsLeader(log, pid1, epoch, (Time)appendTransactionalAsLeader_time4, true);
        Object var39_19 = null;
        mockTime2 = null;
        function14 = null;
        Function1<Object, BoxedUnit> appendPid1 = function15;
        MockTime mockTime3 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this2 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function16 = function13 = appendTransactionalAsLeader_this2.appendIdempotentAsLeader(log, pid2, epoch, (Time)appendTransactionalAsLeader_time3, true);
        Object var42_23 = null;
        mockTime3 = null;
        function13 = null;
        Function1<Object, BoxedUnit> appendPid2 = function16;
        MockTime mockTime4 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this3 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function17 = function12 = appendTransactionalAsLeader_this3.appendIdempotentAsLeader(log, pid3, epoch, (Time)appendTransactionalAsLeader_time2, true);
        Object var45_27 = null;
        mockTime4 = null;
        function12 = null;
        Function1<Object, BoxedUnit> appendPid3 = function17;
        MockTime mockTime5 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this4 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function18 = function1 = appendTransactionalAsLeader_this4.appendIdempotentAsLeader(log, pid4, epoch, (Time)appendTransactionalAsLeader_time, true);
        Object var48_31 = null;
        mockTime5 = null;
        function1 = null;
        Function1<Object, BoxedUnit> appendPid4 = function18;
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        log.logSegments().foreach((Function1 & Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testFullTransactionIndexRecovery$1(segment)));
        log.close();
        long l6 = Defaults$.MODULE$.SegmentMs();
        long l7 = Defaults$.MODULE$.RetentionMs();
        long l8 = Defaults$.MODULE$.RetentionSize();
        long l9 = Defaults$.MODULE$.SegmentJitterMs();
        String string4 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$16 = string4;
        int n4 = Defaults$.MODULE$.MaxMessageSize();
        int n5 = Defaults$.MODULE$.IndexInterval();
        int n6 = Defaults$.MODULE$.MaxIndexSize();
        long l10 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(l6, 5120, l7, l8, l9, x$16, n4, n5, n6, l10);
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$24 = brokerTopicStats2;
        long l11 = 0L;
        long l12 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime6 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$28 = mockTime6;
        int n7 = this.maxTransactionTimeoutMs();
        int n8 = this.maxProducerIdExpirationMs();
        int n9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$24, l11, l12, x$27, (Time)x$28, n7, n8, n9, false);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(pid1, 0L, 29L, 8L), new AbortedTxn(pid2, 8L, 74L, 36L)})), abortedTransactions);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverOnlyLastSegment() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        void appendTransactionalAsLeader_time;
        Function1<Object, BoxedUnit> function1;
        void appendTransactionalAsLeader_time2;
        Function1<Object, BoxedUnit> function12;
        void appendTransactionalAsLeader_time3;
        Function1<Object, BoxedUnit> function13;
        void appendTransactionalAsLeader_time4;
        Function1<Object, BoxedUnit> function14;
        String string2;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$6 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 640, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        MockTime mockTime2 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function15 = function14 = appendTransactionalAsLeader_this.appendIdempotentAsLeader(log, pid1, epoch, (Time)appendTransactionalAsLeader_time4, true);
        Object var42_19 = null;
        mockTime2 = null;
        function14 = null;
        Function1<Object, BoxedUnit> appendPid1 = function15;
        MockTime mockTime3 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this2 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function16 = function13 = appendTransactionalAsLeader_this2.appendIdempotentAsLeader(log, pid2, epoch, (Time)appendTransactionalAsLeader_time3, true);
        Object var45_23 = null;
        mockTime3 = null;
        function13 = null;
        Function1<Object, BoxedUnit> appendPid2 = function16;
        MockTime mockTime4 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this3 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function17 = function12 = appendTransactionalAsLeader_this3.appendIdempotentAsLeader(log, pid3, epoch, (Time)appendTransactionalAsLeader_time2, true);
        Object var48_27 = null;
        mockTime4 = null;
        function12 = null;
        Function1<Object, BoxedUnit> appendPid3 = function17;
        MockTime mockTime5 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this4 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function18 = function1 = appendTransactionalAsLeader_this4.appendIdempotentAsLeader(log, pid4, epoch, (Time)appendTransactionalAsLeader_time, true);
        Object var51_31 = null;
        mockTime5 = null;
        function1 = null;
        Function1<Object, BoxedUnit> appendPid4 = function18;
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        long l6 = Defaults$.MODULE$.SegmentMs();
        long l7 = Defaults$.MODULE$.RetentionMs();
        long l8 = Defaults$.MODULE$.RetentionSize();
        long l9 = Defaults$.MODULE$.SegmentJitterMs();
        String string4 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$16 = string4;
        int n4 = Defaults$.MODULE$.MaxMessageSize();
        int n5 = Defaults$.MODULE$.IndexInterval();
        int n6 = Defaults$.MODULE$.MaxIndexSize();
        long l10 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(l6, 5120, l7, l8, l9, x$16, n4, n5, n6, l10);
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$25 = brokerTopicStats2;
        long l11 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime6 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$28 = mockTime6;
        int n7 = this.maxTransactionTimeoutMs();
        int n8 = this.maxProducerIdExpirationMs();
        int n9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, l11, recoveryPoint, x$27, (Time)x$28, n7, n8, n9, false);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(pid1, 0L, 29L, 8L), new AbortedTxn(pid2, 8L, 74L, 36L)})), abortedTransactions);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverLastSegmentWithNoSnapshots() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        String string;
        void appendTransactionalAsLeader_time;
        Function1<Object, BoxedUnit> function1;
        void appendTransactionalAsLeader_time2;
        Function1<Object, BoxedUnit> function12;
        void appendTransactionalAsLeader_time3;
        Function1<Object, BoxedUnit> function13;
        void appendTransactionalAsLeader_time4;
        Function1<Object, BoxedUnit> function14;
        String string2;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string3 = string2 = Defaults$.MODULE$.CleanupPolicy();
        string2 = null;
        String x$6 = string3;
        int n = Defaults$.MODULE$.MaxMessageSize();
        int n2 = Defaults$.MODULE$.IndexInterval();
        int n3 = Defaults$.MODULE$.MaxIndexSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, 640, l2, l3, l4, x$6, n, n2, n3, l5);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true);
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        MockTime mockTime2 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function15 = function14 = appendTransactionalAsLeader_this.appendIdempotentAsLeader(log, pid1, epoch, (Time)appendTransactionalAsLeader_time4, true);
        Object var42_19 = null;
        mockTime2 = null;
        function14 = null;
        Function1<Object, BoxedUnit> appendPid1 = function15;
        MockTime mockTime3 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this2 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function16 = function13 = appendTransactionalAsLeader_this2.appendIdempotentAsLeader(log, pid2, epoch, (Time)appendTransactionalAsLeader_time3, true);
        Object var45_23 = null;
        mockTime3 = null;
        function13 = null;
        Function1<Object, BoxedUnit> appendPid2 = function16;
        MockTime mockTime4 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this3 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function17 = function12 = appendTransactionalAsLeader_this3.appendIdempotentAsLeader(log, pid3, epoch, (Time)appendTransactionalAsLeader_time2, true);
        Object var48_27 = null;
        mockTime4 = null;
        function12 = null;
        Function1<Object, BoxedUnit> appendPid3 = function17;
        MockTime mockTime5 = this.mockTime();
        LogTestUtils$ appendTransactionalAsLeader_this4 = LogTestUtils$.MODULE$;
        Function1<Object, BoxedUnit> function18 = function1 = appendTransactionalAsLeader_this4.appendIdempotentAsLeader(log, pid4, epoch, (Time)appendTransactionalAsLeader_time, true);
        Object var51_31 = null;
        mockTime5 = null;
        function1 = null;
        Function1<Object, BoxedUnit> appendPid4 = function18;
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), 0, 0);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), 0, 0);
        LogTestUtils$.MODULE$.deleteProducerSnapshotFiles(this.logDir());
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        long l6 = Defaults$.MODULE$.SegmentMs();
        long l7 = Defaults$.MODULE$.RetentionMs();
        long l8 = Defaults$.MODULE$.RetentionSize();
        long l9 = Defaults$.MODULE$.SegmentJitterMs();
        String string4 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$16 = string4;
        int n4 = Defaults$.MODULE$.MaxMessageSize();
        int n5 = Defaults$.MODULE$.IndexInterval();
        int n6 = Defaults$.MODULE$.MaxIndexSize();
        long l10 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(l6, 5120, l7, l8, l9, x$16, n4, n5, n6, l10);
        File x$21 = this.logDir();
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$25 = brokerTopicStats2;
        long l11 = 0L;
        Scheduler x$27 = this.createLog$default$6();
        MockTime mockTime6 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$28 = mockTime6;
        int n7 = this.maxTransactionTimeoutMs();
        int n8 = this.maxProducerIdExpirationMs();
        int n9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, l11, recoveryPoint, x$27, (Time)x$28, n7, n8, n9, false);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(pid1, 0L, 29L, 8L), new AbortedTxn(pid2, 8L, 74L, 36L)})), abortedTransactions);
    }

    @Test
    public void testLogEndLessThanStartAfterReopen() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(Defaults$.MODULE$.SegmentMs(), Defaults$.MODULE$.SegmentSize(), Defaults$.MODULE$.RetentionMs(), Defaults$.MODULE$.RetentionSize(), Defaults$.MODULE$.SegmentJitterMs(), Defaults$.MODULE$.CleanupPolicy(), Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.IndexInterval(), Defaults$.MODULE$.MaxIndexSize(), Defaults$.MODULE$.FileDeleteDelayMs());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testLogEndLessThanStartAfterReopen$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)6, (int)((UnifiedLog)log.elem).logSegments().size());
        int startOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)startOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((((UnifiedLog)log.elem).logEndOffset() > ((UnifiedLog)log.elem).logStartOffset() ? 1 : 0) != 0);
        LogSegment segmentToForceTruncation = (LogSegment)((IterableOps)((UnifiedLog)log.elem).logSegments().take(2)).last();
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = startOffset;
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$11 = brokerTopicStats2;
        long l = 0L;
        Scheduler x$13 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$14 = mockTime2;
        int n = this.maxTransactionTimeoutMs();
        int n2 = this.maxProducerIdExpirationMs();
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, l, x$13, (Time)x$14, n, n2, n3, false);
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment onlySegment = (LogSegment)((UnifiedLog)log.elem).logSegments().head();
        Assertions.assertEquals((long)startOffset, (long)onlySegment.baseOffset());
        Assertions.assertTrue((boolean)onlySegment.log().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyOffsetIndex().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyTimeIndex().file().exists());
    }

    @Test
    public void testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(Defaults$.MODULE$.SegmentMs(), Defaults$.MODULE$.SegmentSize(), Defaults$.MODULE$.RetentionMs(), Defaults$.MODULE$.RetentionSize(), Defaults$.MODULE$.SegmentJitterMs(), Defaults$.MODULE$.CleanupPolicy(), Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.IndexInterval(), Defaults$.MODULE$.MaxIndexSize(), Defaults$.MODULE$.FileDeleteDelayMs());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)10, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)0L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        int newLogStartOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)newLogStartOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment segmentToForceTruncation = (LogSegment)((IterableOps)((UnifiedLog)log.elem).logSegments().take(2)).last();
        Assertions.assertEquals((long)1L, (long)segmentToForceTruncation.baseOffset());
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = newLogStartOffset;
        BrokerTopicStats brokerTopicStats2 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$11 = brokerTopicStats2;
        long l = 0L;
        Scheduler x$13 = this.createLog$default$6();
        MockTime mockTime2 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$14 = mockTime2;
        int n = this.maxTransactionTimeoutMs();
        int n2 = this.maxProducerIdExpirationMs();
        int n3 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, l, x$13, (Time)x$14, n, n2, n3, false);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logEndOffset());
        IndexedSeq offsetsWithSnapshotFiles = (IndexedSeq)((IndexedSeqOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable)offset -> SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)BoxesRunTime.unboxToInt((Object)offset)))).filter((Function1 & Serializable)snapshotFile -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(snapshotFile)))).map((Function1 & Serializable)x$35 -> BoxesRunTime.boxToLong((long)x$35.offset()));
        IndexedSeq inMemorySnapshotFiles = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), 5).flatMap((Function1 & Serializable)offset -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$6(log, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertTrue((boolean)offsetsWithSnapshotFiles.isEmpty(), (String)new StringBuilder(76).append("Found offsets with producer state snapshot files: ").append(offsetsWithSnapshotFiles).append(" while none were expected.").toString());
        Assertions.assertTrue((boolean)inMemorySnapshotFiles.isEmpty(), (String)new StringBuilder(73).append("Found in-memory producer state snapshot files: ").append(inMemorySnapshotFiles).append(" while none were expected.").toString());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((long)newLogStartOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        ListBuffer offsetsWithMissingSnapshotFiles = (ListBuffer)ListBuffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(5), 10).foreach((Function1 & Serializable)offset -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$9(log, offsetsWithMissingSnapshotFiles, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertTrue((boolean)offsetsWithMissingSnapshotFiles.isEmpty(), (String)new StringBuilder(58).append("Found offsets with missing producer state snapshot files: ").append(offsetsWithMissingSnapshotFiles).toString());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list()), (Function1 & Serializable)x$36 -> BoxesRunTime.boxToBoolean((boolean)x$36.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()))), (String)"Expected no files to be present with the deleted file suffix");
    }

    @Test
    public void testRecoverWithEmptyActiveSegment() {
        MockTime mockTime;
        BrokerTopicStats brokerTopicStats;
        MockTime mockTime2;
        BrokerTopicStats brokerTopicStats2;
        String string;
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        long l = Defaults$.MODULE$.SegmentMs();
        long l2 = Defaults$.MODULE$.RetentionMs();
        long l3 = Defaults$.MODULE$.RetentionSize();
        long l4 = Defaults$.MODULE$.SegmentJitterMs();
        String string2 = string = Defaults$.MODULE$.CleanupPolicy();
        string = null;
        String x$8 = string2;
        int n = Defaults$.MODULE$.MaxMessageSize();
        long l5 = Defaults$.MODULE$.FileDeleteDelayMs();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(l, segmentSize, l2, l3, l4, x$8, n, indexInterval, 4096, l5);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.brokerTopicStats(), 0L, 0L, this.createLog$default$6(), (Time)this.mockTime(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), true));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testRecoverWithEmptyActiveSegment$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        UnifiedLog qual$2 = (UnifiedLog)log.elem;
        Option x$21 = qual$2.roll$default$1();
        qual$2.roll(x$21);
        ((UnifiedLog)log.elem).flush(false);
        Assertions.assertThrows(NoSuchFileException.class, () -> ((UnifiedLog)log$14.elem).activeSegment().sanityCheck(true));
        long lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        ((UnifiedLog)log.elem).closeHandlers();
        File x$22 = this.logDir();
        BrokerTopicStats brokerTopicStats3 = brokerTopicStats2 = this.brokerTopicStats();
        brokerTopicStats2 = null;
        BrokerTopicStats x$26 = brokerTopicStats3;
        long l6 = 0L;
        Scheduler x$28 = this.createLog$default$6();
        MockTime mockTime3 = mockTime2 = this.mockTime();
        mockTime2 = null;
        MockTime x$29 = mockTime3;
        int n2 = this.maxTransactionTimeoutMs();
        int n3 = this.maxProducerIdExpirationMs();
        int n4 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$22, logConfig, x$26, l6, lastOffset, x$28, (Time)x$29, n2, n3, n4, false);
        Assertions.assertEquals((long)lastOffset, (long)((UnifiedLog)log.elem).recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((int)0, (int)((UnifiedLog)log.elem).activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable)i -> LogLoaderTest.$anonfun$testRecoverWithEmptyActiveSegment$3(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        UnifiedLog qual$4 = (UnifiedLog)log.elem;
        Option x$43 = qual$4.roll$default$1();
        qual$4.roll(x$43);
        Assertions.assertThrows(NoSuchFileException.class, () -> ((UnifiedLog)log$14.elem).activeSegment().sanityCheck(true));
        ((UnifiedLog)log.elem).flush(true);
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        File x$44 = this.logDir();
        BrokerTopicStats brokerTopicStats4 = brokerTopicStats = this.brokerTopicStats();
        brokerTopicStats = null;
        BrokerTopicStats x$48 = brokerTopicStats4;
        long l7 = 0L;
        Scheduler x$50 = this.createLog$default$6();
        MockTime mockTime4 = mockTime = this.mockTime();
        mockTime = null;
        MockTime x$51 = mockTime4;
        int n5 = this.maxTransactionTimeoutMs();
        int n6 = this.maxProducerIdExpirationMs();
        int n7 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        log.elem = this.createLog(x$44, logConfig, x$48, l7, lastOffset, x$50, (Time)x$51, n5, n6, n7, false);
        Assertions.assertEquals((long)lastOffset, (long)((UnifiedLog)log.elem).recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)(2 * numMessages), (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((int)0, (int)((UnifiedLog)log.elem).activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        ((UnifiedLog)log.elem).close();
    }

    private final /* synthetic */ LogLoaderTest$SimulateError$2$ SimulateError$lzycompute$1(LazyRef SimulateError$module$1) {
        synchronized (SimulateError$module$1) {
            LogLoaderTest$SimulateError$2$ logLoaderTest$SimulateError$2$ = SimulateError$module$1.initialized() ? (LogLoaderTest$SimulateError$2$)SimulateError$module$1.value() : (LogLoaderTest$SimulateError$2$)SimulateError$module$1.initialize((Object)new LogLoaderTest$SimulateError$2$(this));
            return logLoaderTest$SimulateError$2$;
        }
    }

    private final LogLoaderTest$SimulateError$2$ SimulateError$3(LazyRef SimulateError$module$1) {
        if (SimulateError$module$1.initialized()) {
            return (LogLoaderTest$SimulateError$2$)SimulateError$module$1.value();
        }
        return this.SimulateError$lzycompute$1(SimulateError$module$1);
    }

    private final LogManager interceptedLogManager$1(LogConfig logConfig, scala.collection.immutable.Seq logDirs, SimulateError.1 simulateError, int maxTransactionTimeoutMs$1, int maxProducerIdExpirationMs$1, MockTime time$1, BooleanRef cleanShutdownInterceptedValue$1) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(LogLoaderTest $this, ObjectRef log$1, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$1.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
    }

    private final UnifiedLog createLogWithInterceptedReads$1(long recoveryPoint, scala.collection.mutable.Set segmentsWithReads$1, scala.collection.mutable.Set recoveredSegments$1, LogConfig logConfig$2) {
        TopicPartition topicPartition;
        int maxTransactionTimeoutMs = 300000;
        int maxProducerIdExpirationMs = 3600000;
        File parseTopicPartitionName_dir = this.logDir();
        TopicPartition topicPartition2 = topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(parseTopicPartitionName_dir);
        Object var15_7 = null;
        topicPartition = null;
        TopicPartition topicPartition3 = topicPartition2;
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogSegments interceptedLogSegments = new LogSegments(this, topicPartition3, segmentsWithReads$1, recoveredSegments$1){
            private final /* synthetic */ LogLoaderTest $outer;
            public final scala.collection.mutable.Set segmentsWithReads$1;
            public final scala.collection.mutable.Set recoveredSegments$1;

            public LogSegment add(LogSegment segment) {
                LogSegment wrapper = new LogSegment(this, segment){
                    private final /* synthetic */ $anon$2 $outer;

                    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
                        this.$outer.segmentsWithReads$1.$plus$eq((Object)((Object)this));
                        return super.read(startOffset, maxSize, maxPosition, minOneMessage);
                    }

                    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
                        this.$outer.recoveredSegments$1.$plus$eq((Object)((Object)this));
                        return super.recover(producerStateManager, leaderEpochCache);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(segment$1.log(), segment$1.lazyOffsetIndex(), segment$1.lazyTimeIndex(), segment$1.txnIndex(), segment$1.baseOffset(), segment$1.indexIntervalBytes(), segment$1.rollJitterMs(), (Time)$outer.kafka$log$LogLoaderTest$$anon$$$outer().mockTime());
                    }
                };
                return super.add(wrapper);
            }

            public /* synthetic */ LogLoaderTest kafka$log$LogLoaderTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentsWithReads$1 = segmentsWithReads$1;
                this.recoveredSegments$1 = recoveredSegments$1;
                super(topicPartition$1);
            }
        };
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition3, logDirFailureChannel, logConfig$2.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition3, this.logDir(), maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.mockTime());
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition3, logConfig$2, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, interceptedLogSegments, 0L, recoveryPoint, leaderEpochCache, producerStateManager).load();
        LocalLog localLog = new LocalLog(this.logDir(), logConfig$2, interceptedLogSegments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition3, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogRecoversToCorrectOffset$1(LogLoaderTest $this, ObjectRef log$2, int messageSize$1, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$1 = (UnifiedLog)log$2.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)messageSize$1);
        byArray = null;
        byte[] x$11 = byArray2;
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$14 = compressionType2;
        byte by = 2;
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, null, x$14, x$12, by);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20);
    }

    private static final void verifyRecoveredLog$1(UnifiedLog log, long expectedRecoveryPoint, int numMessages$1, long lastIndexOffset$1, int numIndexEntries$1, long lastTimeIndexTimestamp$1, long lastTimeIndexOffset$1, int numTimeIndexEntries$1) {
        Assertions.assertEquals((long)expectedRecoveryPoint, (long)log.recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages$1, (long)log.logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages$1).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((long)lastIndexOffset$1, (long)log.activeSegment().offsetIndex().lastOffset(), (String)"Should have same last index offset as before.");
        Assertions.assertEquals((int)numIndexEntries$1, (int)log.activeSegment().offsetIndex().entries(), (String)"Should have same number of index entries as before.");
        Assertions.assertEquals((long)lastTimeIndexTimestamp$1, (long)log.activeSegment().timeIndex().lastEntry().timestamp(), (String)"Should have same last time index timestamp");
        Assertions.assertEquals((long)lastTimeIndexOffset$1, (long)log.activeSegment().timeIndex().lastEntry().offset(), (String)"Should have same last time index offset");
        Assertions.assertEquals((int)numTimeIndexEntries$1, (int)log.activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testIndexRebuild$1(LogLoaderTest $this, ObjectRef log$3, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$1 = (UnifiedLog)log$3.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)10);
        byArray = null;
        byte[] x$11 = byArray2;
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$14 = compressionType2;
        byte by = 2;
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, null, x$14, x$12, by);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRebuildTimeIndexForOldMessages$1(LogLoaderTest $this, ObjectRef log$4, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$1 = (UnifiedLog)log$4.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)10);
        byArray = null;
        byte[] x$1 = byArray2;
        long x$2 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$5 = compressionType2;
        MemoryRecords x$6 = TestUtils$.MODULE$.singletonRecords(x$1, null, x$5, x$2, (byte)1);
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        ApiVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$6, 0, x$8, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$3(File file) {
        Files.delete(file.toPath());
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$4(LogSegment segment) {
        Assertions.assertEquals((int)0, (int)segment.timeIndex().entries(), (String)"The time index should be empty");
        Assertions.assertEquals((long)0L, (long)segment.lazyTimeIndex().file().length(), (String)"The time index file size should be 0");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptIndexRebuild$1(LogLoaderTest $this, ObjectRef log$5, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$1 = (UnifiedLog)log$5.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)10);
        byArray = null;
        byte[] x$11 = byArray2;
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$14 = compressionType2;
        byte by = 2;
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, null, x$14, x$12, by);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20);
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$4(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$5(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    private final MemoryRecords createRecords$1() {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    private final MemoryRecords createRecords$2() {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testReopenThenTruncate$1(LogLoaderTest $this, ObjectRef log$7, int x$22) {
        UnifiedLog qual$1 = (UnifiedLog)log$7.elem;
        MemoryRecords x$11 = $this.createRecords$2();
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, 0, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$3() {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds() - 1000L;
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testOpenDeletesObsoleteFiles$1(LogLoaderTest $this, ObjectRef log$8, int x$23) {
        UnifiedLog qual$1 = (UnifiedLog)log$8.elem;
        MemoryRecords x$11 = $this.createRecords$3();
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, 0, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$4() {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptLog$2(LogLoaderTest $this, ObjectRef log$9, int x$24) {
        UnifiedLog qual$1 = (UnifiedLog)log$9.elem;
        MemoryRecords x$11 = $this.createRecords$4();
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, 0, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecovery$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecovery$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))), -1, true);
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecord$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecord$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))), -1, true);
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))), -1, true);
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$testRecoveryOfSegmentWithOffsetOverflow$1(UnifiedLog log$10, LogSegment segment) {
        return (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> log$10.splitOverflowedSegment(segment));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(LogSegment segment) {
        segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)true);
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(List newSegments$1, LogSegment segment) {
        LogSegment logSegment = segment;
        Object object = newSegments$1.last();
        if (logSegment == null ? object != null : !logSegment.equals(object)) {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        } else {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        }
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)true);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]), (boolean)true);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(File file) {
        Utils.delete((File)file);
    }

    private final MemoryRecords createRecords$5() {
        CompressionType compressionType;
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$4 = compressionType2;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, by);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleanShutdownFile$1(LogLoaderTest $this, ObjectRef log$11, int x$34) {
        UnifiedLog qual$1 = (UnifiedLog)log$11.elem;
        MemoryRecords x$11 = $this.createRecords$5();
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        ApiVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, 0, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testFullTransactionIndexRecovery$1(LogSegment segment) {
        segment.offsetIndex().deleteIfExists();
        return segment.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testLogEndLessThanStartAfterReopen$1(LogLoaderTest $this, ObjectRef log$12, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$12.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$12.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$13.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        ApiVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, 0, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$13.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(SnapshotFile snapshotFile) {
        return snapshotFile.file().exists();
    }

    public static final /* synthetic */ Option $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$6(ObjectRef log$13, int offset) {
        return ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$3 = (UnifiedLog)log$13.elem;
        MemoryRecords x$18 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SimpleRecord[]{record}))), (byte)2, CompressionType.NONE, -1L, (short)-1, -1, 0L, -1);
        AppendOrigin x$20 = qual$3.appendAsLeader$default$3();
        ApiVersion x$21 = qual$3.appendAsLeader$default$4();
        RequestLocal x$22 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$18, 0, x$20, x$21, x$22);
        UnifiedLog qual$4 = (UnifiedLog)log$13.elem;
        Option x$23 = qual$4.roll$default$1();
        return qual$4.roll(x$23);
    }

    public static final /* synthetic */ Object $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$9(ObjectRef log$13, ListBuffer offsetsWithMissingSnapshotFiles$1, int offset) {
        Option snapshotFile = ((UnifiedLog)log$13.elem).producerStateManager().snapshotFileForOffset((long)offset);
        if (snapshotFile.isEmpty() || !((SnapshotFile)snapshotFile.get()).file().exists()) {
            return offsetsWithMissingSnapshotFiles$1.append((Object)BoxesRunTime.boxToLong((long)Int$.MODULE$.int2long(offset)));
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRecoverWithEmptyActiveSegment$1(LogLoaderTest $this, ObjectRef log$14, int messageSize$2, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$1 = (UnifiedLog)log$14.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)messageSize$2);
        byArray = null;
        byte[] x$11 = byArray2;
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$14 = compressionType2;
        byte by = 2;
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, null, x$14, x$12, by);
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        ApiVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, 0, x$18, x$19, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRecoverWithEmptyActiveSegment$3(LogLoaderTest $this, ObjectRef log$14, int messageSize$2, int i) {
        CompressionType compressionType;
        byte[] byArray;
        UnifiedLog qual$3 = (UnifiedLog)log$14.elem;
        byte[] byArray2 = byArray = TestUtils.randomBytes((int)messageSize$2);
        byArray = null;
        byte[] x$33 = byArray2;
        long x$34 = $this.mockTime().milliseconds() + (long)(i * 10);
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$36 = compressionType2;
        byte by = 2;
        MemoryRecords x$38 = TestUtils$.MODULE$.singletonRecords(x$33, null, x$36, x$34, by);
        AppendOrigin x$40 = qual$3.appendAsLeader$default$3();
        ApiVersion x$41 = qual$3.appendAsLeader$default$4();
        RequestLocal x$42 = qual$3.appendAsLeader$default$5();
        return qual$3.appendAsLeader(x$38, 0, x$40, x$41, x$42);
    }

    public LogLoaderTest() {
        this.maxTransactionTimeoutMs = 300000;
        this.maxProducerIdExpirationMs = 3600000;
    }
}

