/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.BOTH, brokers=1)
@ScalaSignature(bytes="\u0006\u0005Q4A\u0001D\u0007\u0001%!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0003=\u0001\u0011\u0005Q\bC\u0003F\u0001\u0011\u0005Q\bC\u0003N\u0001\u0011\u0005Q\bC\u0003S\u0001\u0011\u0005Q\bC\u0003U\u0001\u0011\u0005Q\bC\u0003W\u0001\u0011\u0005Q\bC\u0003Y\u0001\u0011\u0005Q\bC\u0003[\u0001\u0011\u0005QH\u0001\fBa&4VM]:j_:\u001c(+Z9vKN$H+Z:u\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0014!\t!R#D\u0001\u000e\u0013\t1RB\u0001\u0010BEN$(/Y2u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3ti\u000691\r\\;ti\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0010\u0003\u0011!Xm\u001d;\n\u0005uQ\"aD\"mkN$XM]%ogR\fgnY3\u0002\rqJg.\u001b;?)\t\u0001\u0013\u0005\u0005\u0002\u0015\u0001!)qC\u0001a\u00011\u0005)1/\u001a;vaR\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\u0005+:LG\u000fC\u0003,\u0007\u0001\u0007A&\u0001\u0004d_:4\u0017n\u001a\t\u000335J!A\f\u000e\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5hQ\t\u0019\u0001\u0007\u0005\u00022u5\t!G\u0003\u00024i\u0005\u0019\u0011\r]5\u000b\u0005U2\u0014a\u00026va&$XM\u001d\u0006\u0003oa\nQA[;oSRT\u0011!O\u0001\u0004_J<\u0017BA\u001e3\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0017i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiR\tA\u0005\u000b\u0002\u0005\u007fA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!IG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001#B\u0005-\u0019E.^:uKJ$Vm\u001d;\u0002cQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0006N]8vO\"\u001cuN\u001c;s_2\u0004F.\u00198f\u0019&\u001cH/\u001a8fe\"\"QaP$I\u0003-\u0019G.^:uKJ$\u0016\u0010]3%\u0003%K!AS&\u0002\u0005i[%B\u0001'B\u0003\u0011!\u0016\u0010]3\u0002_Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0006N]8vO\"\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:)\t\u0019yti\u0014\u0013\u0002!&\u0011\u0011kS\u0001\u0006\u0017J\u000be\tV\u0001-i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3ti^KG\u000f[+ogV\u0004\bo\u001c:uK\u00124VM]:j_:D#aB \u0002EQ,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR4\u0016\r\\5eCRLwN\u001c,1Q\tAq(A\u001fuKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tg\u000b\r+ie>,x\r[\"p]R\u0014x\u000e\u001c)mC:,G*[:uK:,'\u000f\u000b\u0003\n\u007f\u001dC\u0015a\u000f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;WC2LG-\u0019;j_:4\u0006\u0007\u00165s_V<\u0007nQ8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8fe\"\"!bP$P\u0003\t\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$h+\u00197jI\u0006$\u0018n\u001c8Wg!\u00121b\u0010\u0015\u0007\u0001u;\u0005m\u00193\u0011\u0005\u0001s\u0016BA0B\u0005M\u0019E.^:uKJ$Vm\u001d;EK\u001a\fW\u000f\u001c;tI\u0005\t\u0017B\u00012L\u0003\u0011\u0011u\n\u0016%\u0002\u000f\t\u0014xn[3sgv\t\u0011\u0001\u000b\u0003\u0001M2l\u0007CA4k\u001b\u0005A'BA53\u0003%)\u0007\u0010^3og&|g.\u0003\u0002lQ\nQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u00039\u001c\u0013a\u001c\t\u0003aJl\u0011!\u001d\u0006\u0003oiI!a]9\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\u0002")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @BeforeEach
    public void setup(ClusterConfig config) {
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTest
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2());
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get());
    }

    @ClusterTest
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2());
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

