/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005]4Aa\b\u0011\u0001K!)A\u0006\u0001C\u0001[!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0004B\u0002!\u0001A\u0003%!\u0007C\u0004B\u0001\t\u0007I\u0011A\u0019\t\r\t\u0003\u0001\u0015!\u00033\u0011\u001d\u0019\u0005A1A\u0005\u0002EBa\u0001\u0012\u0001!\u0002\u0013\u0011\u0004bB#\u0001\u0005\u0004%\t!\r\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001a\t\u000f\u001d\u0003!\u0019!C\u0001c!1\u0001\n\u0001Q\u0001\nIBq!\u0013\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u0004K\u0001\u0001\u0006IA\r\u0005\b\u0017\u0002\u0011\r\u0011\"\u00012\u0011\u0019a\u0005\u0001)A\u0005e!9Q\n\u0001b\u0001\n\u0003\t\u0004B\u0002(\u0001A\u0003%!\u0007C\u0004P\u0001\t\u0007I\u0011A\u0019\t\rA\u0003\u0001\u0015!\u00033\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015\u0019\u0007\u0001\"\u0001S\u0011\u0015)\u0007\u0001\"\u0001S\u0011\u00159\u0007\u0001\"\u0001S\u0011\u0015I\u0007\u0001\"\u0001S\u0011\u0015Y\u0007\u0001\"\u0001S\u0011\u0015i\u0007\u0001\"\u0001S\u0011\u0015y\u0007\u0001\"\u0001S\u0011\u0015\t\b\u0001\"\u0001S\u0011\u0015\u0019\b\u0001\"\u0001S\u0011\u0015)\b\u0001\"\u0001S\u0005M\u0019uN\\:pY\u0016\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\t#%A\u0003u_>d7OC\u0001$\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0014\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u00020\u00015\t\u0001%A\nce>\\WM\u001d'jgR4\u0016\r\\5e\u0003J<7/F\u00013!\r93'N\u0005\u0003i!\u0012Q!\u0011:sCf\u0004\"AN\u001f\u000f\u0005]Z\u0004C\u0001\u001d)\u001b\u0005I$B\u0001\u001e%\u0003\u0019a$o\\8u}%\u0011A\bK\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=Q\u0005!\"M]8lKJd\u0015n\u001d;WC2LG-\u0011:hg\u0002\n\u0001DY8piN$(/\u00199TKJ4XM\u001d,bY&$\u0017I]4t\u0003e\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014h+\u00197jI\u0006\u0013xm\u001d\u0011\u0002\u0017%tg/\u00197jI\u0006\u0013xm]\u0001\rS:4\u0018\r\\5e\u0003J<7\u000fI\u0001\u0018E>|Go\u001d;sCB\u001cVM\u001d<fe>3XM\u001d:jI\u0016\f\u0001DY8piN$(/\u00199TKJ4XM](wKJ\u0014\u0018\u000eZ3!\u0003A\u0019G.[3oi&#wJ^3se&$W-A\tdY&,g\u000e^%e\u001fZ,'O]5eK\u0002\n\u0011GY1uG\"\u001c\u0016N_3Pm\u0016\u0014(/\u001b3eK:\u0014\u00150T1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:WC2,X-\u0001\u001acCR\u001c\u0007nU5{K>3XM\u001d:jI\u0012,gNQ=NCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fgZ\u000bG.^3!\u0003-\u0012Go\u00195TSj,7+\u001a;B]\u0012l\u0015\r\u001f)beRLG/[8o\u001b\u0016lwN]=CsR,7OT8u'\u0016$\u0018\u0001\f2uG\"\u001c\u0016N_3TKR\fe\u000eZ'bqB\u000b'\u000f^5uS>tW*Z7pef\u0014\u0015\u0010^3t\u001d>$8+\u001a;!\u00031\u0012\u0017\r^2i'&TXMT8u'\u0016$\u0018I\u001c3NCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fgN+G/A\u0017cCR\u001c\u0007nU5{K:{GoU3u\u0003:$W*\u0019=QCJ$\u0018\u000e^5p]6+Wn\u001c:z\u0005f$Xm]*fi\u0002\n\u0001CY1uG\"\u001c\u0016N_3EK\u001a\fW\u000f\u001c;\u0002#\t\fGo\u00195TSj,G)\u001a4bk2$\b%\u0001\u000euKN$h+\u00197jI\u000e{gNZ5hg\n\u0013xn[3s\u0019&\u001cH\u000fF\u0001T!\t9C+\u0003\u0002VQ\t!QK\\5uQ\t!r\u000b\u0005\u0002YC6\t\u0011L\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0005qk\u0016a\u00026va&$XM\u001d\u0006\u0003=~\u000bQA[;oSRT\u0011\u0001Y\u0001\u0004_J<\u0017B\u00012Z\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001c(i\\8ugR\u0014\u0018\r]*feZ,'\u000f\u000b\u0002\u0016/\u0006\u0011B/Z:u\u0013:4\u0018\r\\5e\u0007>tg-[4tQ\t1r+\u0001\tuKN$\b+\u0019:tK.+\u0017\u0010\u0015:pa\"\u0012qcV\u0001\u001ci\u0016\u001cHOQ8piN$(/\u00199TKJ4XM](wKJ\u0014\u0018\u000eZ3)\u0005a9\u0016\u0001\u0006;fgR\u001cE.[3oi&#wJ^3se&$W\r\u000b\u0002\u001a/\u0006\u0019B/Z:u\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JI\"\u0012!dV\u00016i\u0016\u001cHOQ1uG\"\u001c\u0016N_3Pm\u0016\u0014(/\u001b3eK:\u0014\u00150T1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:WC2,X\r\u000b\u0002\u001c/\u0006\u0001D/Z:u\u0005\u0006$8\r[*ju\u0016\u001cV\r^!oI6\u000b\u0007\u0010U1si&$\u0018n\u001c8NK6|'/\u001f\"zi\u0016\u001chj\u001c;TKRD#\u0001H,\u0002)Q,7\u000f\u001e#fM\u0006,H\u000e\u001e\"bi\u000eD7+\u001b>fQ\tir+\u0001\u0019uKN$()\u0019;dQNK'0\u001a(piN+G/\u00118e\u001b\u0006D\b+\u0019:uSRLwN\\'f[>\u0014\u0018PQ=uKN\u001cV\r\u001e\u0015\u0003=]\u0003")
public class ConsoleProducerTest {
    private final String[] brokerListValidArgs = new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"};
    private final String[] bootstrapServerValidArgs = new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"};
    private final String[] invalidArgs = new String[]{"--t", "t3"};
    private final String[] bootstrapServerOverride = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"};
    private final String[] clientIdOverride = new String[]{"--broker-list", "localhost:1001", "--topic", "t3", "--producer-property", "client.id=producer-1"};
    private final String[] batchSizeOverriddenByMaxPartitionMemoryBytesValue = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123", "--max-partition-memory-bytes", "456"};
    private final String[] btchSizeSetAndMaxPartitionMemoryBytesNotSet = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123"};
    private final String[] batchSizeNotSetAndMaxPartitionMemoryBytesSet = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--max-partition-memory-bytes", "456"};
    private final String[] batchSizeDefault = new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"};

    public String[] brokerListValidArgs() {
        return this.brokerListValidArgs;
    }

    public String[] bootstrapServerValidArgs() {
        return this.bootstrapServerValidArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    public String[] bootstrapServerOverride() {
        return this.bootstrapServerOverride;
    }

    public String[] clientIdOverride() {
        return this.clientIdOverride;
    }

    public String[] batchSizeOverriddenByMaxPartitionMemoryBytesValue() {
        return this.batchSizeOverriddenByMaxPartitionMemoryBytesValue;
    }

    public String[] btchSizeSetAndMaxPartitionMemoryBytesNotSet() {
        return this.btchSizeSetAndMaxPartitionMemoryBytesNotSet;
    }

    public String[] batchSizeNotSetAndMaxPartitionMemoryBytesSet() {
        return this.batchSizeNotSetAndMaxPartitionMemoryBytesSet;
    }

    public String[] batchSizeDefault() {
        return this.batchSizeDefault;
    }

    @Test
    public void testValidConfigsBrokerList() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1001", "localhost:1002"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testValidConfigsBootstrapServer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1003", "localhost:1004"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testInvalidConfigs() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ConsoleProducerTest.$anonfun$testInvalidConfigs$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleProducer.ProducerConfig(this.invalidArgs()));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Predef$.MODULE$.assert(string != null && string.equals(string2));
        Predef$.MODULE$.assert(reader.parseKey());
    }

    @Test
    public void testBootstrapServerOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList("localhost:1002"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testClientIdOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.clientIdOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"producer-1", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"console-producer", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testBatchSizeOverriddenByMaxPartitionMemoryBytesValue() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeOverriddenByMaxPartitionMemoryBytesValue());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeSetAndMaxPartitionMemoryBytesNotSet() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.btchSizeSetAndMaxPartitionMemoryBytesNotSet());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)123, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testDefaultBatchSize() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeDefault());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)16384, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeNotSetAndMaxPartitionMemoryBytesSet() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeNotSetAndMaxPartitionMemoryBytesSet());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testInvalidConfigs$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }
}

