/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.test.junit.RaftClusterInvocationContext;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.CreateClusterLinksRequest;
import org.apache.kafka.common.requests.CreateClusterLinksResponse;
import org.apache.kafka.common.requests.DeleteClusterLinksRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h\u0001B\b\u0011\u0001]AQA\b\u0001\u0005\u0002}AQA\t\u0001\u0005\u0002\rBQ!\u0010\u0001\u0005\u0002yBQ\u0001\u0016\u0001\u0005\u0002UCQ!\u001b\u0001\u0005\u0002)DQ!\u001c\u0001\u0005\u00029Dq!a\u0016\u0001\t\u0003\tI\u0006C\u0005\u0002r\u0001\t\n\u0011\"\u0001\u0002t!I\u0011q\u0011\u0001\u0012\u0002\u0013\u0005\u00111\u000f\u0005\b\u0003\u0013\u0003A\u0011AAF\u0011\u001d\tI\n\u0001C\u0001\u00037C\u0011\"a.\u0001#\u0003%\t!!/\t\u0013\u0005u\u0006!%A\u0005\u0002\u0005}\u0006\"CAb\u0001E\u0005I\u0011AAc\u0005\u0011\u001aE.^:uKJd\u0015N\\6D_:$(o\u001c7mKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\t\u0013\u0003\u0011a\u0017N\\6\u000b\u0005M!\u0012!B6bM.\f'\"A\u000b\u0002\u0017%tG/Z4sCRLwN\\\u0002\u0001'\t\u0001\u0001\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003A\tQa]3ukB$\"\u0001J\u0014\u0011\u0005e)\u0013B\u0001\u0014\u001b\u0005\u0011)f.\u001b;\t\u000b!\u0012\u0001\u0019A\u0015\u0002\u001b\rdWo\u001d;fe\u000e{gNZ5h!\tQc&D\u0001,\u0015\taS&\u0001\u0003uKN$(\"A\n\n\u0005=Z#!D\"mkN$XM]\"p]\u001aLw\r\u000b\u0002\u0003cA\u0011!gO\u0007\u0002g)\u0011A'N\u0001\u0004CBL'B\u0001\u001c8\u0003\u001dQW\u000f]5uKJT!\u0001O\u001d\u0002\u000b),h.\u001b;\u000b\u0003i\n1a\u001c:h\u0013\ta4G\u0001\u0006CK\u001a|'/Z#bG\"\fa\u0003^3ti\u000ecWo\u001d;fe2Kgn[\"p]\u001aLwm\u001d\u000b\u0003I}BQ\u0001Q\u0002A\u0002\u0005\u000bqb\u00197vgR,'/\u00138ti\u0006t7-\u001a\t\u0003U\tK!aQ\u0016\u0003\u001f\rcWo\u001d;fe&s7\u000f^1oG\u0016D\u0003bA#L\u0019F\u00136K\u0015\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011.\n!\"\u00198o_R\fG/[8o\u0013\tQuIA\u0006DYV\u001cH/\u001a:UKN$\u0018aC2mkN$XM\u001d+za\u0016$\u0013!T\u0005\u0003\u001d>\u000bQa\u0013*B\rRS!\u0001U$\u0002\tQK\b/Z\u0001\bEJ|7.\u001a:t;\u0005\t\u0011aC2p]R\u0014x\u000e\u001c7feN\f\u0001\u0004^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016d\u0015N\\6t)\t!c\u000bC\u0003A\t\u0001\u0007q\u000b\u0005\u0002YK:\u0011\u0011L\u0019\b\u00035\u0006t!a\u00171\u000f\u0005q{V\"A/\u000b\u0005y3\u0012A\u0002\u001fs_>$h(C\u0001\u0014\u0013\taS&\u0003\u00029W%\u00111\rZ\u0001\u001d%\u00064Go\u00117vgR,'/\u00138w_\u000e\fG/[8o\u0007>tG/\u001a=u\u0015\tA4&\u0003\u0002gO\n\u0019\"+\u00194u\u00072,8\u000f^3s\u0013:\u001cH/\u00198dK*\u00111\r\u001a\u0015\t\t\u0015[E*\u0015*T%\u0006yB/Z:u'>,(oY3J]&$\u0018.\u0019;fI2Kgn[\"sK\u0006$\u0018n\u001c8\u0015\u0005\u0011Z\u0007\"\u0002!\u0006\u0001\u00049\u0006\u0006C\u0003F\u00172\u000b&k\u0015*\u0002?M,g\u000eZ\"p]R\u0014x\u000e\u001c7fe\u000e\u0013X-\u0019;f\u00072,8\u000f^3s\u0019&t7\u000eF\u0003p\u0003\u0017\t9\u0005\u0005\u0003qi^ThBA9s!\ta&$\u0003\u0002t5\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\u00075\u000b\u0007O\u0003\u0002t5A\u0011\u0001\u000f_\u0005\u0003sZ\u0014aa\u0015;sS:<\u0007cA>\u0002\b5\tAP\u0003\u0002~}\u0006A\u0001O]8u_\u000e|GNC\u0002\u0000\u0003\u0003\taaY8n[>t'bA\n\u0002\u0004)\u0019\u0011QA\u001d\u0002\r\u0005\u0004\u0018m\u00195f\u0013\r\tI\u0001 \u0002\u0007\u000bJ\u0014xN]:\t\u000f\u00055a\u00011\u0001\u0002\u0010\u0005AA.\u001b8l\t\u0006$\u0018\r\u0005\u0004\u0002\u0012\u0005m\u0011\u0011\u0005\b\u0005\u0003'\t9BD\u0002]\u0003+I\u0011aG\u0005\u0004\u00033Q\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyBA\u0002TKFT1!!\u0007\u001b!\u0011\t\u0019#!\u0011\u000f\t\u0005\u0015\u00121\b\b\u0005\u0003O\t9D\u0004\u0003\u0002*\u0005Ub\u0002BA\u0016\u0003gqA!!\f\u000229\u0019A,a\f\n\u0003iJ1!!\u0002:\u0013\r\u0019\u00121A\u0005\u0004\u007f\u0006\u0005\u0011bAA\u001d}\u00069Q.Z:tC\u001e,\u0017\u0002BA\u001f\u0003\u007f\tQd\u0011:fCR,7\t\\;ti\u0016\u0014H*\u001b8lgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003sq\u0018\u0002BA\"\u0003\u000b\u0012\u0011\"\u00128uef$\u0015\r^1\u000b\t\u0005u\u0012q\b\u0005\b\u0003\u00132\u0001\u0019AA&\u0003)\u0019wN\u001c;s_2dWM\u001d\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011K\u0017\u0002\u000f9,Go^8sW&!\u0011QKA(\u00051\u0019vnY6fiN+'O^3s\u0003U\u0019XM\u001c3EK2,G/Z\"mkN$XM\u001d'j].$\u0012b\\A.\u0003C\n\u0019'!\u001c\t\u000f\u0005us\u00011\u0001\u0002`\u0005IA.\u001b8l\u001d\u0006lWm\u001d\t\u0006\u0003#\tYb\u001e\u0005\b\u0003\u0013:\u0001\u0019AA&\u0011%\t)g\u0002I\u0001\u0002\u0004\t9'\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010E\u0002\u001a\u0003SJ1!a\u001b\u001b\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u001c\b!\u0003\u0005\r!a\u001a\u0002\u000b\u0019|'oY3\u0002?M,g\u000e\u001a#fY\u0016$Xm\u00117vgR,'\u000fT5oW\u0012\"WMZ1vYR$3'\u0006\u0002\u0002v)\"\u0011qMA<W\t\tI\b\u0005\u0003\u0002|\u0005\rUBAA?\u0015\u0011\ty(!!\u0002\u0013Ut7\r[3dW\u0016$'B\u0001%\u001b\u0013\u0011\t))! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0010tK:$G)\u001a7fi\u0016\u001cE.^:uKJd\u0015N\\6%I\u00164\u0017-\u001e7uIQ\n\u0001c]3oI\u0006cG/\u001a:D_:4\u0017nZ:\u0015\u000f=\fi)!%\u0002\u0018\"1\u0011q\u0012\u0006A\u0002]\f\u0001\u0002\\5oW:\u000bW.\u001a\u0005\b\u0003'S\u0001\u0019AAK\u0003\u001d\u0019wN\u001c4jON\u0004B\u0001\u001d;xo\"9\u0011\u0011\n\u0006A\u0002\u0005-\u0013aC2mkN$XM\u001d'j].$\"\"!\t\u0002\u001e\u0006}\u00151UAS\u0011\u0019\tyi\u0003a\u0001o\"A\u0011\u0011U\u0006\u0011\u0002\u0003\u0007q/A\u0005dYV\u001cH/\u001a:JI\"I\u00111S\u0006\u0011\u0002\u0003\u0007\u0011Q\u0013\u0005\n\u0003O[\u0001\u0013!a\u0001\u0003S\u000ba\u0001\\5oW&#\u0007#B\r\u0002,\u0006=\u0016bAAW5\t1q\n\u001d;j_:\u0004B!!-\u000246\ta0C\u0002\u00026z\u0014A!V;jI\u0006)2\r\\;ti\u0016\u0014H*\u001b8lI\u0011,g-Y;mi\u0012\u0012TCAA^U\r9\u0018qO\u0001\u0016G2,8\u000f^3s\u0019&t7\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tM\u000b\u0003\u0002\u0016\u0006]\u0014!F2mkN$XM\u001d'j].$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fTC!!+\u0002x!:\u0001!a3\u0002X\u0006e\u0007\u0003BAg\u0003'l!!a4\u000b\u0007\u0005E7'A\u0005fqR,gn]5p]&!\u0011Q[Ah\u0005))\u0005\u0010^3oI^KG\u000f[\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u00037\u001c#!!8\u0011\t\u0005}\u0017\u0011]\u0007\u0002I&\u0019\u00111\u001d3\u0003+\rcWo\u001d;feR+7\u000f^#yi\u0016t7/[8og\u0002")
public class ClusterLinkControllerIntegrationTest {
    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        Assumptions.assumeFalse((boolean)clusterConfig.clusterType().equals((Object)Type.KRAFT), (String)"ClusterLinking and KRaft Integration tests are disabled for CP 7.2");
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testClusterLinkConfigs(ClusterInstance clusterInstance) {
        Map<String, Errors> results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        Object[] objectArray = new CreateClusterLinksRequestData.EntryData[1];
        Map x$2 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:0")}));
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        objectArray[0] = this.clusterLink("test-link", x$3, (Map<String, String>)x$2, x$4);
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendAlterConfigs("test-link", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"bar")}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testCreateAndDeleteLinks(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        Object[] objectArray = new CreateClusterLinksRequestData.EntryData[1];
        Some x$2 = new Some((Object)Uuid.randomUuid());
        String x$3 = this.clusterLink$default$2();
        Map<String, String> x$4 = this.clusterLink$default$3();
        objectArray[0] = this.clusterLink("test-link", x$3, x$4, (Option<Uuid>)x$2);
        Map<String, Errors> results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map configs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)ClusterLinkConfig.LinkMode.Destination.toString())}));
        Object[] objectArray2 = new CreateClusterLinksRequestData.EntryData[1];
        Some x$7 = new Some((Object)Uuid.randomUuid());
        String x$8 = this.clusterLink$default$2();
        objectArray2[0] = this.clusterLink("test-link", x$8, (Map<String, String>)configs, (Option<Uuid>)x$7);
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)"badMode")}));
        Object[] objectArray3 = new CreateClusterLinksRequestData.EntryData[1];
        String x$11 = this.clusterLink$default$2();
        Option<Uuid> x$12 = this.clusterLink$default$4();
        objectArray3[0] = this.clusterLink("test-link", x$11, (Map<String, String>)badConfigs, x$12);
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateClusterLinksRequestData.EntryData[]{this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4())}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateClusterLinksRequestData.EntryData[]{this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4())}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_EXISTS, (Object)results.apply((Object)"test-link"));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$1(clusterInstance)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-link", "not-a-link"}))), clusterInstance.activeController(), true, this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-link", "not-a-link"}))), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-link", "not-a-link"}))), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.CLUSTER_LINK_NOT_FOUND, (Object)results.apply((Object)"not-a-link"));
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreateClusterLinksRequestData.EntryData[]{this.clusterLink("test-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4()), this.clusterLink("another-link", this.clusterLink$default$2(), this.clusterLink$default$3(), this.clusterLink$default$4())}))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        results = this.sendDeleteClusterLink((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test-link", "another-link"}))), clusterInstance.activeController(), this.sendDeleteClusterLink$default$3(), this.sendDeleteClusterLink$default$4());
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"test-link"));
        Assertions.assertEquals((Object)Errors.NONE, (Object)results.apply((Object)"another-link"));
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$3(clusterInstance)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)ClusterLinkControllerIntegrationTest.$anonfun$testCreateAndDeleteLinks$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
    }

    @ClusterTest(clusterType=Type.KRAFT, brokers=1, controllers=1)
    public void testSourceInitiatedLinkCreation(RaftClusterInvocationContext.RaftClusterInstance clusterInstance) {
        Map configs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)ClusterLinkConfig.LinkMode.Source.toString())}));
        Object[] objectArray = new CreateClusterLinksRequestData.EntryData[1];
        String x$3 = this.clusterLink$default$2();
        Option<Uuid> x$4 = this.clusterLink$default$4();
        objectArray[0] = this.clusterLink("test-link", x$3, (Map<String, String>)configs, x$4);
        Map<String, Errors> results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_REQUEST, (Object)results.apply((Object)"test-link"));
        Map badConfigs = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig.linkModeProp), (Object)"badMode")}));
        Object[] objectArray2 = new CreateClusterLinksRequestData.EntryData[1];
        Some x$7 = new Some((Object)Uuid.randomUuid());
        String x$8 = this.clusterLink$default$2();
        objectArray2[0] = this.clusterLink("test-link", x$8, (Map<String, String>)badConfigs, (Option<Uuid>)x$7);
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
        Object[] objectArray3 = new CreateClusterLinksRequestData.EntryData[1];
        Some x$11 = new Some((Object)Uuid.randomUuid());
        String x$12 = this.clusterLink$default$2();
        objectArray3[0] = this.clusterLink("test-link", x$12, (Map<String, String>)configs, (Option<Uuid>)x$11);
        results = this.sendControllerCreateClusterLink((scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), clusterInstance.activeController());
        Assertions.assertEquals((Object)Errors.INVALID_CONFIG, (Object)results.apply((Object)"test-link"));
    }

    public Map<String, Errors> sendControllerCreateClusterLink(scala.collection.immutable.Seq<CreateClusterLinksRequestData.EntryData> linkData, SocketServer controller) {
        CreateClusterLinksRequestData data = new CreateClusterLinksRequestData().setEntries(CollectionConverters$.MODULE$.SeqHasAsJava(linkData).asJava()).setTimeoutMs(Integer.MAX_VALUE);
        CreateClusterLinksRequest request = (CreateClusterLinksRequest)new CreateClusterLinksRequest.Builder(data).build();
        CreateClusterLinksResponse response = (CreateClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(CreateClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().entries()).asScala().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Errors> sendDeleteClusterLink(scala.collection.immutable.Seq<String> linkNames, SocketServer controller, boolean validateOnly, boolean force) {
        DeleteClusterLinksRequest request = (DeleteClusterLinksRequest)new DeleteClusterLinksRequest.Builder((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(linkNames).asJava(), validateOnly, force, Integer.MAX_VALUE).build();
        DeleteClusterLinksResponse response = (DeleteClusterLinksResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(DeleteClusterLinksResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response.data().entries()).asScala().map((Function1 & Serializable)entry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)entry.linkName()), (Object)Errors.forCode((short)entry.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public boolean sendDeleteClusterLink$default$3() {
        return false;
    }

    public boolean sendDeleteClusterLink$default$4() {
        return false;
    }

    public Map<String, Errors> sendAlterConfigs(String linkName, Map<String, String> configs, SocketServer controller) {
        ConfigResource resource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, linkName);
        IncrementalAlterConfigsRequest request = (IncrementalAlterConfigsRequest)new IncrementalAlterConfigsRequest.Builder(Collections.singleton(resource), Collections.singletonMap(resource, CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)configs.map((Function1 & Serializable)x0$1 -> {
            String value;
            String key;
            block3: {
                block2: {
                    if (x0$1 == null) break block2;
                    key = (String)x0$1._1();
                    value = (String)x0$1._2();
                    if (key != null && value != null) break block3;
                }
                throw new MatchError(x0$1);
            }
            AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(key, value), AlterConfigOp.OpType.SET);
            return alterConfigOp;
        })).asJavaCollection()), false).build();
        IncrementalAlterConfigsResponse response2 = (IncrementalAlterConfigsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, controller, ListenerName.normalised((String)"controller"), ClassTag$.MODULE$.apply(IncrementalAlterConfigsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(response2.data().responses()).asScala().map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.resourceName()), (Object)Errors.forCode((short)response.errorCode())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public CreateClusterLinksRequestData.EntryData clusterLink(String linkName, String clusterId, Map<String, String> configs, Option<Uuid> linkId) {
        return new CreateClusterLinksRequestData.EntryData().setLinkName(linkName).setLinkId((Uuid)linkId.getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID)).setClusterId(clusterId).setConfigs(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)configs.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            CreateClusterLinksRequestData.ConfigData configData = new CreateClusterLinksRequestData.ConfigData().setKey(k).setValue(v);
            return configData;
        })).toList()).asJava());
    }

    public String clusterLink$default$2() {
        return "source-cluster";
    }

    public Map<String, String> clusterLink$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<Uuid> clusterLink$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$1(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$2() {
        return "Broker never saw new cluster link";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAndDeleteLinks$3(RaftClusterInvocationContext.RaftClusterInstance clusterInstance$1) {
        return !clusterInstance$1.metadataImage().get(BoxesRunTime.boxToInteger((int)0)).clusterLinks().clusterLink("test-link").isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateAndDeleteLinks$4() {
        return "Broker never saw cluster link get deleted";
    }
}

