/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001B\u0006\r\u0001MAQ\u0001\b\u0001\u0005\u0002uAQ\u0001\t\u0001\u0005B\u0005BQ\u0001\u000b\u0001\u0005B%BQa\u000e\u0001\u0005\u0002aBQ!\u0019\u0001\u0005\u0002\tDQa\u001a\u0001\u0005\u0002!DQ!\u001c\u0001\u0005\u00029DQa\u001d\u0001\u0005\u0002QDQ!\u001f\u0001\u0005\u0002iDaa \u0001\u0005\u0002\u0005\u0005!A\u0006#jg\u0006\u0014G.\u001a+jKJ\u001cFo\u001c:bO\u0016$Vm\u001d;\u000b\u00055q\u0011\u0001\u0002;jKJT!a\u0004\t\u0002\u000b-\fgm[1\u000b\u0003E\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]\u000e\u00011C\u0001\u0001\u0015!\t)\"$D\u0001\u0017\u0015\t9\u0002$A\u0003ti\u0006$XM\u0003\u0002\u000e3)\tq\"\u0003\u0002\u001c-\t\t\")Y:f)&,'o\u0015;bi\u0016$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005q\u0002CA\u0010\u0001\u001b\u0005a\u0011a\u00032s_.,'oQ8v]R,\u0012A\t\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0004\u0013:$\u0018a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\tQS\u0006\u0005\u0002$W%\u0011A\u0006\n\u0002\u0005+:LG\u000fC\u0003/\u0007\u0001\u0007q&\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002i\u0005!!.\u0019<b\u0013\t1\u0014G\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0006^3ti\u001a+Go\u00195SKF,Xm\u001d;XSRDG+[3sK\u0012\u001cFo\u001c:bO\u0016$\u0015n]1cY\u0016$GC\u0001\u0016:\u0011\u0015QD\u00011\u0001<\u0003\u0019\tXo\u001c:v[B\u0011Ah\u0011\b\u0003{\u0005\u0003\"A\u0010\u0013\u000e\u0003}R!\u0001\u0011\n\u0002\rq\u0012xn\u001c;?\u0013\t\u0011E%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"%Q\u0011!q)\u0016,\u0011\u0005!\u001bV\"A%\u000b\u0005)[\u0015\u0001\u00039s_ZLG-\u001a:\u000b\u00051k\u0015A\u00029be\u0006l7O\u0003\u0002O\u001f\u00069!.\u001e9ji\u0016\u0014(B\u0001)R\u0003\u0015QWO\\5u\u0015\u0005\u0011\u0016aA8sO&\u0011A+\u0013\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0003]\u000b\u0013\u0001W\u0001\u0003u.DC\u0001\u0002._?B\u00111\fX\u0007\u0002\u0017&\u0011Ql\u0013\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f\u0013\u0001Y\u0001\u0019w\u0012L7\u000f\u001d7bs:\u000bW.Z?/cV|'/^7>wBj\u0018A\u000b;fgR\fE\r\u001a(foJ+\u0007\u000f\\5dC^KG\u000f\u001b+jKJ,Gm\u0015;pe\u0006<W\rR5tC\ndW\r\u001a\u000b\u0003U\rDQAO\u0003A\u0002mBC!B$VK2\nq\u000b\u000b\u0003\u00065z{\u0016\u0001\u000b;fgR\u0014V\r\u001d7jG\u0006$\u0018n\u001c8XSRDG+[3sK\u0012\u001cFo\u001c:bO\u0016$\u0015n]1cY\u0016$GC\u0001\u0016j\u0011\u0015Qd\u00011\u0001<Q\u00111q)V6-\u0003]CCA\u0002._?\u0006AC/Z:u\t\u0016dW\r^3U_BL7mV5uQRKWM]3e'R|'/Y4f\t&\u001c\u0018M\u00197fIR\u0011!f\u001c\u0005\u0006u\u001d\u0001\ra\u000f\u0015\u0005\u000f\u001d+\u0016\u000fL\u0001XQ\u00119!LX0\u0002SQ,7\u000f\u001e'pOJ+G/\u001a8uS>tw+\u001b;i)&,'/\u001a3Ti>\u0014\u0018mZ3ESN\f'\r\\3e)\tQS\u000fC\u0003;\u0011\u0001\u00071\b\u000b\u0003\t\u000fV;H&A,)\t!QflX\u0001Ai\u0016\u001cH\u000fT8h%\u0016$XM\u001c;j_:\fe\r^3s)&,'/\u001a3ECR\f\u0017j\u001d#fY\u0016$X\rZ!oIRKWM]3e'R|'/Y4f\t&\u001c\u0018M\u00197fIR\u0011!f\u001f\u0005\u0006u%\u0001\ra\u000f\u0015\u0005\u0013\u001d+V\u0010L\u0001XQ\u0011I!LX0\u0002gQ,7\u000f\u001e#fY\u0016$\u0018n\u001c8UCN\\7\u000b^1uK6\u000b7\r[5oK^CWM\u001c+jKJ\u001cFo\u001c:bO\u0016$\u0015n]1cY\u0016$Gc\u0001\u0016\u0002\u0004!)!H\u0003a\u0001w!*!bR+\u0002\b1\nq\u000b\u000b\u0003\u000b5z{\u0006")
public class DisableTierStorageTest
extends BaseTierStateTest {
    @Override
    public int brokerCount() {
        return 5;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "true");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testFetchRequestWithTieredStorageDisabled(String quorum) {
        void var4_4;
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var3_3, (int)var4_4);
        this.waitForHotSetRetentionToKickIn((List<Object>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{var3_3, var4_4}))));
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier enabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        AbstractLog leaderLog = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$2(leaderLog)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
        this.switchLeader((int)var3_3, (int)var4_4);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled and new leader elected");
        this.fetchTieredAndLocalDataAndValidate((int)var4_4, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.switchLeader((int)var4_4, (int)var3_3);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Fetch with tier disabled and new leader elected (that has since been rolled)");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var4_4)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testAddNewReplicaWithTieredStorageDisabled(String quorum) {
        void var3_3;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        this.appendMessagesToLeaderAndWaitUntilTiered((int)var3_3, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId((int)var3_3).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$1(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$2(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        int replica3 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica3);
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$3(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        int replica4 = this.addReplicaToAssignment((int)var3_3);
        this.waitForReplicaToGetInSync((int)var3_3, replica4);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testReplicationWithTieredStorageDisabled(String quorum) {
        Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topicName(), 1, 3, this.props(), this.createTopic$default$5());
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        int replica1 = BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        Seq followers = (Seq)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getPartitionOrException(this.topicPartition()).assignmentState().replicas().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$2 -> x$2 != replica1);
        followers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)follower -> this.killBroker(follower));
        this.appendMessagesToLeaderAndWaitUntilTiered(replica1, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(replica1).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$3(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.head()), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.head()));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$5(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        this.restartDeadBroker(BoxesRunTime.unboxToInt((Object)followers.apply(1)), this.restartDeadBroker$default$2());
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.apply(1)));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDeleteTopicWithTieredStorageDisabled(String quorum) {
        String topic1 = "foo";
        String topic2 = "bar";
        TopicPartition topicPartition1 = new TopicPartition(topic1, 0);
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic1, 1, 1, this.props(), this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition1);
        AbstractLog topic1Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).replicaManager().getLog(topicPartition1).get();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic2, 1, 1, this.props(), this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(topicPartition2);
        AbstractLog topic2Log = (AbstractLog)((KafkaBroker)this.brokerForId(topic2LeaderId).get()).replicaManager().getLog(topicPartition2).get();
        int numMessages = 100;
        IntRef totalMessages1 = IntRef.create((int)0);
        while (topic1Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic1, numMessages, -1);
            totalMessages1.elem += numMessages;
        }
        IntRef totalMessages2 = IntRef.create((int)0);
        while (topic2Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), topic2, numMessages, -1);
            totalMessages2.elem += numMessages;
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$1(this, topic1Log, totalMessages1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 60000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$3(this, topic2Log, totalMessages2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        List<TierLogSegment> tieredSegments1 = this.tierLogSegments(topic1Log);
        List<TierLogSegment> tieredSegments2 = this.tierLogSegments(topic2Log);
        ConfluentAdmin adminClient = this.createConfluentAdminClient(this.createConfluentAdminClient$default$1());
        DeleteTopicsResult future1 = adminClient.deleteTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic1}))).asJavaCollection());
        this.changeTopicConfig("confluent.tier.enable", "false", topic2);
        long l3 = 200L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$5(topic2Log)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), (long)waitUntilTrue_pause));
        }
        DeleteTopicsResult future2 = adminClient.deleteTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic2}))).asJavaCollection());
        future1.all().get(30000L, TimeUnit.MILLISECONDS);
        future2.all().get(30000L, TimeUnit.MILLISECONDS);
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(topic1LeaderId).get()).tierObjectStoreOpt().get();
        this.verifyTieredSegmentsDeleted(topic1, objStore, tieredSegments1);
        this.verifyTieredSegmentsDeleted(topic2, objStore, tieredSegments2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testLogRetentionWithTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        ObjectRef topic = ObjectRef.create((Object)"");
        ((IterableOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"false", "true"}))).zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$3 -> {
            DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$2(this, topic, numMessages, x$3);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled(String quorum) {
        int numMessages = 100;
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 1, this.props(), this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        LogManager qual$1 = ((KafkaBroker)this.brokerForId(leaderId).get()).logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(x$1, x$2).get();
        while (log.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        }
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 30000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        this.changeTopicConfig("confluent.tier.enable", "false", this.topicName());
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 30000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
        long currentNumMessages = log.logEndOffset();
        long lastTieredOffset = log.tierPartitionState().endOffset();
        String desiredRetentionSizeBytes = Long.toString(log.size());
        while (log.logEndOffset() < currentNumMessages * 3L) {
            TestUtils$.MODULE$.generateAndProduceMessages(this.brokers().toSeq(), this.topicName(), numMessages, -1);
        }
        List segmentsNotTiered = log.localLogSegments(lastTieredOffset + 1L, log.logEndOffset()).toList();
        this.changeTopicConfig("retention.bytes", desiredRetentionSizeBytes, this.topicName());
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs3 = 30000L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(log, segmentsNotTiered)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs3) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs3), l3));
        }
        long l4 = 100L;
        long waitUntilTrue_waitTimeMs4 = 30000L;
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs4) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs4), l4));
        }
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs5 = 60000L;
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs5) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs5), l5));
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testDeletionTaskStateMachineWhenTierStorageDisabled(String quorum) {
        this.props().put("retention.bytes", "-1");
        this.props().put("retention.ms", "-1");
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicPartition().topic(), 1, 1, this.props(), this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        this.waitUntilLogCreatedOnBrokers(this.topicPartition());
        AbstractLog log = (AbstractLog)((KafkaBroker)this.brokerForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.brokerForId(leaderId).get()).tierObjectStoreOpt().get();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        List<TierLogSegment> tieredSegments = this.tierLogSegments(log);
        this.changeTopicConfig("retention.ms", "100", this.changeTopicConfig$default$3());
        this.verifyTieredSegmentsDeleted(this.topicPartition().topic(), objStore, tieredSegments);
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 10000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestWithTieredStorageDisabled$2(AbstractLog leaderLog$1) {
        return !leaderLog$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testFetchRequestWithTieredStorageDisabled$3() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$1(AbstractLog log$1) {
        return log$1.logStartOffset() < log$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$2(AbstractLog log$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$1.logStartOffset()).append(" localLogStartOffset ").append(log$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$3(AbstractLog log$1) {
        return !log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$4() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$3(AbstractLog log$2) {
        return log$2.logStartOffset() < log$2.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$4(AbstractLog log$2) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$2.logStartOffset()).append(" localLogStartOffset ").append(log$2.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$5(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$1(DisableTierStorageTest $this, AbstractLog topic1Log$1, IntRef totalMessages1$1) {
        return topic1Log$1.logEndOffset() == (long)totalMessages1$1.elem && $this.tierLogSegments(topic1Log$1).size() >= topic1Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$2() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$3(DisableTierStorageTest $this, AbstractLog topic2Log$1, IntRef totalMessages2$1) {
        return topic2Log$1.logEndOffset() == (long)totalMessages2$1.elem && $this.tierLogSegments(topic2Log$1).size() >= topic2Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$4() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$5(AbstractLog topic2Log$1) {
        return !topic2Log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$4(Partition partition$1) {
        return partition$1.log().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$5(Partition partition$1) {
        return new StringBuilder(34).append("log did not resolve for partition ").append(partition$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$6(Partition partition$1) {
        return ((AbstractLog)partition$1.log().get()).tierPartitionState().numSegments() >= ((AbstractLog)partition$1.log().get()).numberOfSegments() - 1 && ((AbstractLog)partition$1.log().get()).localLogStartOffset() > Predef$.MODULE$.Long2long((Long)((AbstractLog)partition$1.log().get()).tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$7() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$8(Partition partition$1) {
        return !((AbstractLog)partition$1.log().get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$9() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$10(LongRef expectedLogStartOffset$1, Partition partition$1) {
        return expectedLogStartOffset$1.elem == partition$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$11(Partition partition$1, LongRef expectedLogStartOffset$1) {
        return new StringBuilder(46).append("Unexpected log start offset: ").append(partition$1.logStartOffset()).append(" Expected value: ").append(expectedLogStartOffset$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testLogRetentionWithTieredStorageDisabled$2(DisableTierStorageTest $this, ObjectRef topic$1, int numMessages$1, Tuple2 x$3) {
        if (x$3 != null) {
            long retentionSizeBytes;
            String configVal = (String)x$3._1();
            int index = x$3._2$mcI$sp();
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Testing topic created with config.TierEnable = ").append(configVal).toString());
            $this.props().put("confluent.tier.enable", configVal);
            topic$1.elem = new StringBuilder(1).append($this.topicName()).append("-").append(index).toString();
            int leaderId = BoxesRunTime.unboxToInt((Object)$this.createTopic((String)topic$1.elem, 1, 1, $this.props(), $this.createTopic$default$5()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            $this.waitUntilLogCreatedOnBrokers((String)topic$1.elem, 0);
            Partition partition = ((KafkaBroker)$this.brokerForId(leaderId).get()).replicaManager().getPartitionOrException(new TopicPartition((String)topic$1.elem, 0));
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$4(partition)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$5(partition));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            while (((AbstractLog)partition.log().get()).numberOfSegments() < 4) {
                TestUtils$.MODULE$.generateAndProduceMessages($this.brokers().toSeq(), (String)topic$1.elem, numMessages$1, -1);
            }
            LongRef expectedLogStartOffset = LongRef.create((long)0L);
            String string = configVal;
            String string2 = "true";
            if (string != null && string.equals(string2)) {
                long l3 = 100L;
                long waitUntilTrue_waitTimeMs = 30000L;
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$6(partition)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$7());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l3));
                }
                $this.changeTopicConfig("confluent.tier.enable", "false", (String)topic$1.elem);
                long l4 = 100L;
                long waitUntilTrue_waitTimeMs2 = 30000L;
                long waitUntilTrue_startTime3 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$8(partition)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs2) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$9());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), l4));
                }
                List<TierLogSegment> tieredSegments = $this.tierLogSegments((AbstractLog)partition.log().get());
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((TierLogSegment)tieredSegments.head()).size() + 1);
                expectedLogStartOffset.elem = ((TierLogSegment)tieredSegments.apply(1)).baseOffset();
            } else {
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().head()).size() + 1);
                expectedLogStartOffset.elem = ((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().toList().apply(1)).baseOffset();
            }
            $this.changeTopicConfig("retention.bytes", Long.toString(retentionSizeBytes), (String)topic$1.elem);
            long l5 = 10L;
            long waitUntilTrue_waitTimeMs = 60000L;
            long waitUntilTrue_startTime4 = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$10(expectedLogStartOffset, partition)) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$11(partition, expectedLogStartOffset));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(AbstractLog log$3) {
        return log$3.tierPartitionState().numSegments() >= log$3.numberOfSegments() - 1 && log$3.localLogStartOffset() > Predef$.MODULE$.Long2long((Long)log$3.tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(AbstractLog log$3) {
        return !log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(AbstractLog log$3, List segmentsNotTiered$1) {
        return log$3.logStartOffset() >= ((LogSegment)segmentsNotTiered$1.apply(1)).baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6() {
        return "Timed out waiting for retention to delete some local segments";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(AbstractLog log$3) {
        return log$3.localLogStartOffset() == log$3.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(AbstractLog log$3) {
        return new StringBuilder(39).append("LogStartOffset ").append(log$3.logStartOffset()).append(" != localLogStartOffset ").append(log$3.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(AbstractLog log$3) {
        return !log$3.tierPartitionState().startOffset().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10() {
        return "FirstTieredOffset is defined after all tiered segments are deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(AbstractLog log$4) {
        return !log$4.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(AbstractLog log$4) {
        return log$4.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4() {
        return "Timed out waiting for all tiered segments to delete";
    }
}

