/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0005q4AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0003q\u0002BB\u0014\u0001A\u0003%q\u0004C\u0004)\u0001\t\u0007I\u0011A\u0015\t\rA\u0002\u0001\u0015!\u0003+\u0011\u0015\t\u0004\u0001\"\u00113\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015Q\b\u0001\"\u0003|\u0005}!\u0016.\u001a:U_BL7-T1oC\u001e,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u00195\tA\u0001^5fe*\u0011abD\u0001\u0006W\u000647.\u0019\u0006\u0002!\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q9R\"A\u000b\u000b\u0005A1\"\"\u0001\b\n\u0005a)\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005Y\u0011aD8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\tU$\u0018\u000e\u001c\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0001c\u001c<feJLG-\u001b8h!J|\u0007o\u001d\u0011\u0002\r1|w\rR5s+\u0005Q\u0003CA\u0016/\u001b\u0005a#BA\u0017$\u0003\tIw.\u0003\u00020Y\t!a)\u001b7f\u0003\u001dawn\u001a#je\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002gA\u0019A'O\u001e\u000e\u0003UR!AN\u001c\u0002\u0015\r|G\u000e\\3di&|gNC\u00019\u0003\u0015\u00198-\u00197b\u0013\tQTGA\u0002TKF\u0004\"\u0001P \u000e\u0003uR!A\u0010\f\u0002\rM,'O^3s\u0013\t\u0001UHA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0006;fgR$\u0016.\u001a:U_BL7-T1oC\u001e,'\u000f\u0006\u0002D\u000fB\u0011A)R\u0007\u0002o%\u0011ai\u000e\u0002\u0005+:LG\u000fC\u0003I\u000f\u0001\u0007\u0011*\u0001\u0004rk>\u0014X/\u001c\t\u0003\u0015Fs!aS(\u0011\u00051;T\"A'\u000b\u00059\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002Qo\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001v\u0007\u000b\u0003\b+\u000e$\u0007C\u0001,b\u001b\u00059&B\u0001-Z\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u0001.\\\u0003\u0019\u0001\u0018M]1ng*\u0011A,X\u0001\bUV\u0004\u0018\u000e^3s\u0015\tqv,A\u0003kk:LGOC\u0001a\u0003\ry'oZ\u0005\u0003E^\u00131BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cH&A3\"\u0003\u0019\f!A_6)\t\u001dAG.\u001c\t\u0003S*l\u0011!W\u0005\u0003Wf\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003\u0011q\u0017-\\3\"\u00039\f\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0003]\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e^\"p]\u001aLw\rF\u0001r!\u0011\u0001#/\u0013;\n\u0005M\f#aA'baB\u0011Q\u000f_\u0007\u0002m*\u0011qoI\u0001\u0005Y\u0006tw-\u0003\u0002zm\n1qJ\u00196fGR\f1$Y:tKJ$H+[3s'R\fG/\u001a+pa&\u001c7i\u001c8gS\u001e\u001cH#A\"")
public class TierTopicManagerIntegrationTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final File logDir;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public File logDir() {
        return this.logDir;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), false, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk"})
    public void testTierTopicManager(String quorum) {
        TierTopicManager tierTopicManager = (TierTopicManager)((KafkaBroker)this.brokers().last()).tierTopicManagerOpt().get();
        LogManager logManager = ((KafkaBroker)this.brokers().last()).logManager();
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("cleanup.policy", "delete");
        while (!tierTopicManager.isReady()) {
            Thread.sleep(5L);
        }
        this.assertTierStateTopicConfigs();
        String topic1 = "foo";
        int x$4 = this.createTopic$default$3();
        ListenerName x$5 = this.createTopic$default$5();
        this.createTopic(topic1, 2, x$4, properties, x$5);
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        TierPartitionState tierPartitionState1 = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        TopicIdPartition topicIdPartition1 = (TopicIdPartition)tierPartitionState1.topicIdPartition().get();
        CompletableFuture<TierPartitionState.AppendResult> result1 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result1.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        CompletableFuture<TierPartitionState.AppendResult> result2 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 200, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)result2.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        Assertions.assertEquals((int)1, (int)tierPartitionState1.numSegments());
        String topic2 = "topic2";
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        String x$6 = topicPartition2.topic();
        int x$8 = this.createTopic$default$2();
        int x$9 = this.createTopic$default$3();
        ListenerName x$10 = this.createTopic$default$5();
        this.createTopic(x$6, x$8, x$9, properties, x$10);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$4(logManager, topicPartition2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
        }
        TierPartitionState tierPartitionState2 = ((AbstractLog)logManager.getLog(topicPartition2, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        long l5 = 100L;
        long waitUntilTrue_waitTimeMs = 500L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$7(tierPartitionState1, tierPartitionState2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l5));
        }
        TierPartitionState originalState = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertEquals((int)1, (int)originalState.numSegments());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createAdminClientConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        config.put("request.timeout.ms", "20000");
        return var1_1;
    }

    private void assertTierStateTopicConfigs() {
        AdminClient adminClient;
        java.util.Map<String, Object> create_conf = this.createAdminClientConfig();
        AdminClient adminClient2 = adminClient = (AdminClient)Admin.create(create_conf);
        Object var6_1 = null;
        adminClient = null;
        ObjectRef result = ObjectRef.create(null);
        try (AdminClient client = adminClient2;){
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$1(result, client)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)result.elem).entries()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$3(x$4))).get()).value());
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)result.elem).entries()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$4(x$5))).get()).value());
        Assertions.assertEquals((Object)"delete", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)result.elem).entries()).asScala().find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$5(x$6))).get()).value());
        Assertions.assertEquals((Object)"false", (Object)((ConfigEntry)CollectionConverters$.MODULE$.CollectionHasAsScala(((Config)result.elem).entries()).asScala().find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$6(x$7))).get()).value());
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        Option partitionState = logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).map((Function1 & Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$3() {
        return "Did not become leader for TierPartitionState.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$4(LogManager logManager$1, TopicPartition topicPartition2$1) {
        Option partitionState = logManager$1.getLog(topicPartition2$1, logManager$1.getLog$default$2()).map((Function1 & Serializable)x$3 -> x$3.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$6() {
        return "Did not become leader for TierPartitionState topic2.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$7(TierPartitionState tierPartitionState1$1, TierPartitionState tierPartitionState2$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState1$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            TierPartitionStatus tierPartitionStatus3 = tierPartitionState2$1.status();
            TierPartitionStatus tierPartitionStatus4 = TierPartitionStatus.ONLINE;
            if (!(tierPartitionStatus3 != null ? !tierPartitionStatus3.equals(tierPartitionStatus4) : tierPartitionStatus4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$8() {
        return "tierTopicManager consumers catchingUp timed out";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$1(ObjectRef result$1, AdminClient client$1) {
        try {
            ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "_confluent-tier-state");
            result$1.elem = (Config)((KafkaFuture)client$1.describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
            return true;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw ee.getCause();
        }
    }

    public static final /* synthetic */ String $anonfun$assertTierStateTopicConfigs$2() {
        return "timed waiting to find tier state topic";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$3(ConfigEntry x$4) {
        String string = x$4.name();
        String string2 = "retention.bytes";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$4(ConfigEntry x$5) {
        String string = x$5.name();
        String string2 = "retention.ms";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$5(ConfigEntry x$6) {
        String string = x$6.name();
        String string2 = "cleanup.policy";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$6(ConfigEntry x$7) {
        String string = x$7.name();
        String string2 = "unclean.leader.election.enable";
        return string != null && string.equals(string2);
    }

    public TierTopicManagerIntegrationTest() {
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogCleanupPolicyProp(), "compact");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.logDir = TestUtils.tempDirectory(null, null);
    }
}

