/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.tier.management;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kafka.cluster.Partition;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.quota.QuotaCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.metadata.BrokerMetadataPublisher;
import kafka.server.metadata.ClientQuotaMetadataManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator;
import kafka.tier.backupobjectlifecycle.BackupObjectLifecycleManagerCoordinator$;
import kafka.tier.backupobjectlifecycle.TierTopicReader;
import kafka.tier.backupobjectlifecycle.TierTopicReaderConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.AclsImage;
import org.apache.kafka.image.BrokerReplicaExclusionsImage;
import org.apache.kafka.image.ClientQuotasImage;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.ClusterLinksImage;
import org.apache.kafka.image.ConfigurationsImage;
import org.apache.kafka.image.FeaturesImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.ProducerIdsImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MetadataEncryptor;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.metadata.NoOpMetadataEncryptor;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000f\u001e\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004;\u0001\u0001\u0006Ia\r\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019\u0001\u0005\u0001)A\u0005{!9\u0011\t\u0001b\u0001\n\u0003\u0011\u0005BB&\u0001A\u0003%1\tC\u0004M\u0001\t\u0007I\u0011A'\t\rE\u0003\u0001\u0015!\u0003O\u0011\u001d\u0011\u0006A1A\u0005\u0002MCaa\u0018\u0001!\u0002\u0013!\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007c\u0002\u0001\u000b\u0011\u00022\t\u000fI\u0004!\u0019!C\u0001g\"1a\u0010\u0001Q\u0001\nQD\u0001b \u0001C\u0002\u0013\u0005\u0011\u0011\u0001\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\u0018!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011Q\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u00028!9\u00111\t\u0001\u0005\u0002\u0005\u0015\u0003bBA2\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003[\u0002A\u0011AA#\u0011\u001d\t\t\b\u0001C\u0001\u0003\u000bBq!!\u001e\u0001\t\u0003\t)\u0005C\u0004\u0002z\u0001!\t!!\u0012\u0003Y\t\u000b7m[;q\u001f\nTWm\u0019;MS\u001a,7-_2mK6\u000bg.Y4fe\u000e{wN\u001d3j]\u0006$xN\u001d+fgR\u001c(B\u0001\u0010 \u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003A\u0005\nA\u0001^5fe*\u0011!eI\u0001\u0006W\u000647.\u0019\u0006\u0002I\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00021\u00015\tQ$\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003M\u0002\"\u0001\u000e\u001d\u000e\u0003UR!AN\u001c\u0002\rM,'O^3s\u0015\u0005\u0011\u0013BA\u001d6\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u000eS:$XM\u001d8bY\u0006#W.\u001b8\u0016\u0003u\u0002\"\u0001\u000e \n\u0005}*$!D%oi\u0016\u0014h.\u00197BI6Lg.\u0001\bj]R,'O\\1m\u0003\u0012l\u0017N\u001c\u0011\u0002\u000bA\u0014x\u000e]:\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0006Qe>\u0004XM\u001d;jKN\fa\u0001\u001d:paN\u0004\u0013AB2p]\u001aLw-F\u0001O!\t!t*\u0003\u0002Qk\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\n\u0011b\u00197vgR,'/\u00133\u0016\u0003Q\u0003\"!\u0016/\u000f\u0005YS\u0006CA,*\u001b\u0005A&BA-&\u0003\u0019a$o\\8u}%\u00111,K\u0001\u0007!J,G-\u001a4\n\u0005us&AB*ue&twM\u0003\u0002\\S\u0005Q1\r\\;ti\u0016\u0014\u0018\n\u001a\u0011\u0002A%tG/\u001a:Ce>\\WM]\"mS\u0016tGoQ8oM&<7oU;qa2LWM]\u000b\u0002EB\u00191M\u001a5\u000e\u0003\u0011T!!Z#\u0002\u0011\u0019,hn\u0019;j_:L!a\u001a3\u0003\u0011M+\b\u000f\u001d7jKJ\u0004B\u0001R5UW&\u0011!.\u0012\u0002\u0004\u001b\u0006\u0004\bC\u00017p\u001b\u0005i'B\u00018H\u0003\u0011a\u0017M\\4\n\u0005Al'AB(cU\u0016\u001cG/A\u0011j]R,'O\u0011:pW\u0016\u00148\t\\5f]R\u001cuN\u001c4jON\u001cV\u000f\u001d9mS\u0016\u0014\b%\u0001\nuS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u001fB$X#\u0001;\u0011\u0007!*x/\u0003\u0002wS\t1q\n\u001d;j_:\u0004\"\u0001\u001f?\u000e\u0003eT!A_>\u0002\u000bM$xN]3\u000b\u0005\u0001:\u0014BA?z\u0005=!\u0016.\u001a:PE*,7\r^*u_J,\u0017a\u0005;jKJ|%M[3diN#xN]3PaR\u0004\u0013a\u0005;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u001fB$XCAA\u0002!\u0011AS/!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003|\u0003\u0015!x\u000e]5d\u0013\u0011\ty!!\u0003\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\u0018\u0001\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u001fB$\b%\u0001\u0003uS6,WCAA\f!\u0011\tI\"!\f\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tQ!\u001e;jYNTA!!\t\u0002$\u000511m\\7n_:T1AIA\u0013\u0015\u0011\t9#!\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tY#A\u0002pe\u001eLA!a\f\u0002\u001c\t!A+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\"!a\u000e\u0011\t\u0005e\u0012QH\u0007\u0003\u0003wQA!a\r\u0002 %!\u0011qHA\u001e\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\ti\u0016\f'\u000fZ8x]R\u0011\u0011q\t\t\u0004Q\u0005%\u0013bAA&S\t!QK\\5uQ\r1\u0012q\n\t\u0005\u0003#\ny&\u0004\u0002\u0002T)!\u0011QKA,\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\nY&A\u0004kkBLG/\u001a:\u000b\t\u0005u\u0013\u0011F\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003C\n\u0019FA\u0005BMR,'/R1dQ\u0006qA/Z:u\u001f:,E.Z2uS>t\u0007fA\f\u0002hA!\u0011\u0011KA5\u0013\u0011\tY'a\u0015\u0003\tQ+7\u000f^\u0001\u0012i\u0016\u001cHo\u00148SKNLwM\\1uS>t\u0007f\u0001\r\u0002h\u0005yA/Z:u%\u0016\u001cwN\u001c4jOV\u0014X\rK\u0002\u001a\u0003O\nQ\b^3ti\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014hj\u001c;jM&,7\u000fT5gK\u000eLH.Z'b]\u0006<WM]\"p_J$\u0017N\\1u_JD3AGA4\u0003A\"Xm\u001d;US\u0016\u0014Hk\u001c9jGJ+\u0017\rZ3s\u000bb\u001cG.\u001e3fg6+GO]5dgJ+\u0007o\u001c:uK\u0012\u001cuN\u001c4jO\"\u001a1$a\u001a")
public class BackupObjectLifecycleManagerCoordinatorTests {
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final InternalAdmin internalAdmin = (InternalAdmin)Mockito.mock(InternalAdmin.class);
    private final Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
    private final KafkaConfig config;
    private final String clusterId;
    private final Supplier<Map<String, Object>> interBrokerClientConfigsSupplier;
    private final Option<TierObjectStore> tierObjectStoreOpt;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final Time time;
    private final Metrics metrics;

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public InternalAdmin internalAdmin() {
        return this.internalAdmin;
    }

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Supplier<Map<String, Object>> interBrokerClientConfigsSupplier() {
        return this.interBrokerClientConfigsSupplier;
    }

    public Option<TierObjectStore> tierObjectStoreOpt() {
        return this.tierObjectStoreOpt;
    }

    public Option<TierTopicManager> tierTopicManagerOpt() {
        return this.tierTopicManagerOpt;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    @AfterEach
    public void teardown() {
        Mockito.framework().clearInlineMocks();
    }

    @Test
    public void testOnElection() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
    }

    @Test
    public void testOnResignation() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        coordinator.onElection(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.onResignation(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER() + 1);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.onResignation(BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
    }

    @Test
    public void testReconfigure() {
        BackupObjectLifecycleManagerCoordinator coordinator = new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics());
        TopicPartition tp = new TopicPartition("_confluent-tier-state", BackupObjectLifecycleManagerCoordinator$.MODULE$.PARTITION_TO_CO_LOCATE_BACKUP_OBJECT_LIFECYCLE_MANAGER());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)this.replicaManager().getPartitionOrError(tp)).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
        this.props().setProperty("confluent.clm.enabled", "false");
        KafkaConfig configWithCLMDisabled = new KafkaConfig((Map)this.props());
        this.props().setProperty("confluent.clm.enabled", "true");
        KafkaConfig configWithCLMEnabled = new KafkaConfig((Map)this.props());
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.reconfigure(configWithCLMDisabled, configWithCLMEnabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.reconfigure(configWithCLMEnabled, configWithCLMEnabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isDefined());
        coordinator.reconfigure(configWithCLMEnabled, configWithCLMDisabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
        coordinator.reconfigure(configWithCLMDisabled, configWithCLMDisabled);
        Predef$.MODULE$.assert(coordinator.customLifecycleManager().isEmpty());
    }

    @Test
    public void testBrokerMetadataPublisherNotifiesLifecyleManagerCoordinator() {
        KRaftMetadataCache metadataCache = (KRaftMetadataCache)Mockito.mock(KRaftMetadataCache.class);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.allLogs()).thenReturn(package$.MODULE$.List().apply((Seq)Nil$.MODULE$));
        GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
        TransactionCoordinator txnCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
        ClientQuotaMetadataManager clientQuotaMetadataManager = (ClientQuotaMetadataManager)Mockito.mock(ClientQuotaMetadataManager.class);
        FinalizedFeatureCache featureCache = (FinalizedFeatureCache)Mockito.mock(FinalizedFeatureCache.class);
        scala.collection.immutable.Map dynamicConfigHandlers = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        Some tieredCoordinator = new Some(Mockito.mock(TierDeletedPartitionsCoordinator.class));
        Some quotaCoordinatorOpt = new Some(Mockito.mock(QuotaCoordinator.class));
        ClusterLinkDisabled.LinkManager clusterLinkManager = new ClusterLinkDisabled.LinkManager();
        Some backupObjectLifecycleManagerCoordinatorOpt = new Some((Object)new BackupObjectLifecycleManagerCoordinator(this.replicaManager(), this.config(), this.clusterId(), this.interBrokerClientConfigsSupplier(), this.tierObjectStoreOpt(), this.tierTopicManagerOpt(), () -> this.internalAdmin(), this.time(), this.metrics()));
        BrokerMetadataPublisher publisher = new BrokerMetadataPublisher(this.config(), metadataCache, logManager, this.replicaManager(), groupCoordinator, txnCoordinator, clientQuotaMetadataManager, featureCache, dynamicConfigHandlers, (Option)tieredCoordinator, (Option)backupObjectLifecycleManagerCoordinatorOpt, (Option)quotaCoordinatorOpt, (Option)None$.MODULE$, (Option)new Some((Object)clusterLinkManager));
        int localId = 1;
        int[] replicas = new int[]{localId, 2, 0};
        Uuid topicId = Uuid.fromString((String)"0hHJ3X5ZQ-CFfQ5xgpj90w");
        PartitionRegistration partitionRegistration = new PartitionRegistration(replicas, replicas, Replicas.NONE, Replicas.NONE, replicas[1], LeaderRecoveryState.RECOVERED, 1, 1);
        HashMap<Integer, PartitionRegistration> partitionMap = new HashMap<Integer, PartitionRegistration>();
        partitionMap.put(Predef$.MODULE$.int2Integer(0), partitionRegistration);
        partitionMap.put(Predef$.MODULE$.int2Integer(1), partitionRegistration);
        ArrayBuffer topics = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        topics.$plus$eq((Object)new TopicImage("_confluent-tier-state", topicId, partitionMap, null));
        HashMap topicsById = new HashMap();
        HashMap topicsByName = new HashMap();
        topics.foreach((Function1 & Serializable)topic -> {
            topicsById.put(topic.id(), topic);
            return topicsByName.put(topic.name(), topic);
        });
        HashMap topicNamesByTenant = new HashMap();
        HashMap topicsByLinkId = new HashMap();
        TopicsImage topicsImage = new TopicsImage(topicsById, topicsByName, topicNamesByTenant, topicsByLinkId);
        MetadataImage metadataImage = new MetadataImage(new OffsetAndEpoch(100L, 100), FeaturesImage.EMPTY, ClusterImage.EMPTY, topicsImage, ConfigurationsImage.EMPTY, ClientQuotasImage.EMPTY, ProducerIdsImage.EMPTY, AclsImage.EMPTY, ClusterLinksImage.EMPTY, BrokerReplicaExclusionsImage.EMPTY, (MetadataEncryptor)NoOpMetadataEncryptor.INSTANCE);
        MetadataDelta metadataDelta = new MetadataDelta(metadataImage, x$1 -> null, new MetadataEncryptorFactory(Collections.emptyMap()));
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(1).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(1).setLeader(localId + 1));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId + 1));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isDefined());
        ArrayList<Integer> removingReplicas = new ArrayList<Integer>();
        removingReplicas.add(Predef$.MODULE$.int2Integer(localId));
        ArrayList<Integer> addingReplicas = new ArrayList<Integer>();
        addingReplicas.add(Predef$.MODULE$.int2Integer(3));
        metadataDelta.replay(new PartitionChangeRecord().setTopicId(topicId).setPartitionId(0).setLeader(localId + 1).setRemovingReplicas(removingReplicas).setAddingReplicas(addingReplicas));
        publisher.publish(metadataDelta, metadataImage);
        Predef$.MODULE$.assert(((BackupObjectLifecycleManagerCoordinator)backupObjectLifecycleManagerCoordinatorOpt.get()).customLifecycleManager().isEmpty());
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testTierTopicReaderExcludesMetricsReportedConfig() {
        clientConfigs = new HashMap<String, String>();
        clientConfigs.put("bootstrap", "127.0.0.1");
        clientConfigs.put("metric.reporters", "blah");
        consumerProps = TierTopicReader.getProperties((TierTopicReaderConfig)new TierTopicReaderConfig((Supplier<Map>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$1(java.util.HashMap ), ()Ljava/util/Map;)(clientConfigs), this.clusterId(), 0, 50, 50L, Collections.nCopies(50, Predef$.MODULE$.long2Long(0L)), Predef$.MODULE$.long2Long(10000L), (Consumer<Long>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$2(java.lang.Long ), (Ljava/lang/Long;)V)(), (Supplier<Boolean>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$3(), ()Ljava/lang/Boolean;)(), (Supplier<Boolean>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$4(), ()Ljava/lang/Boolean;)(), (Time)new MockTime(), 10, (Supplier<Integer>)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$5(), ()Ljava/lang/Integer;)()));
        if (!consumerProps.containsKey("bootstrap")) ** GOTO lbl-1000
        v0 = consumerProps.get("bootstrap");
        var3_3 = "127.0.0.1";
        if (v0 != null && v0.equals(var3_3)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        Predef$.MODULE$.assert(consumerProps.containsKey("metric.reporters") == false);
    }

    public static final /* synthetic */ Map $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$1(HashMap clientConfigs$1) {
        return clientConfigs$1;
    }

    public static final /* synthetic */ void $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$2(Long x$2) {
    }

    public static final /* synthetic */ Boolean $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$3() {
        return Predef$.MODULE$.boolean2Boolean(true);
    }

    public static final /* synthetic */ Boolean $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$4() {
        return Predef$.MODULE$.boolean2Boolean(false);
    }

    public static final /* synthetic */ Integer $anonfun$testTierTopicReaderExcludesMetricsReportedConfig$5() {
        return Predef$.MODULE$.int2Integer(10);
    }

    public BackupObjectLifecycleManagerCoordinatorTests() {
        this.props().setProperty("confluent.tier.feature", "true");
        this.props().setProperty("node.id", "1");
        this.config = new KafkaConfig((Map)this.props());
        this.clusterId = "Test";
        this.interBrokerClientConfigsSupplier = () -> new HashMap();
        this.tierObjectStoreOpt = new Some(Mockito.mock(TierObjectStore.class));
        this.tierTopicManagerOpt = new Some(Mockito.mock(TierTopicManager.class));
        this.time = (Time)Mockito.mock(Time.class);
        this.metrics = new Metrics();
    }
}

