/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import kafka.admin.AclCommand;
import kafka.admin.AclCommand$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestUtils;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r%b\u0001\u0002#F\u0001)CQa\u0016\u0001\u0005\u0002aCqa\u0017\u0001A\u0002\u0013\u0005A\fC\u0004o\u0001\u0001\u0007I\u0011A8\t\rY\u0004\u0001\u0015)\u0003^\u0011\u001d9\bA1A\u0005\naDq!!\u0005\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016!A\u0011q\u0005\u0001!\u0002\u0013\t9\u0002C\u0005\u0002*\u0001\u0011\r\u0011\"\u0003\u0002,!A\u0011q\b\u0001!\u0002\u0013\ti\u0003C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011q\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T!A\u0011\u0011\r\u0001!\u0002\u0013\t)\u0006C\u0005\u0002d\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011\u0011\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000e\u0001!\u0002\u0013\t9\u0007C\u0005\u0002p\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011\u0011\u000f\u0001!\u0002\u0013\t9\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002f!A\u0011Q\u000f\u0001!\u0002\u0013\t9\u0007C\u0005\u0002x\u0001\u0011\r\u0011\"\u0003\u0002z!A\u0011Q\u0013\u0001!\u0002\u0013\tY\bC\u0005\u0002\u0018\u0002\u0011\r\u0011\"\u0003\u0002\u001a\"A\u0011\u0011\u0017\u0001!\u0002\u0013\tY\nC\u0004\u00024\u0002!I!!.\t\u0013\u0005-\u0007!%A\u0005\n\u00055\u0007\"CAr\u0001\t\u0007I\u0011BAs\u0011!\t9\u000f\u0001Q\u0001\n\u0005]\u0006\"CAu\u0001\t\u0007I\u0011BAv\u0011!\t\u0019\u0010\u0001Q\u0001\n\u00055\bbCA{\u0001\u0001\u0007\t\u0019!C\u0005\u0003oD1B!\u0002\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\b!Y!1\u0002\u0001A\u0002\u0003\u0005\u000b\u0015BA}\u0011-\u0011i\u0001\u0001a\u0001\u0002\u0004%IAa\u0004\t\u0017\tE\u0001\u00011AA\u0002\u0013%!1\u0003\u0005\f\u0005/\u0001\u0001\u0019!A!B\u0013\ty\tC\u0006\u0003\u001a\u0001\u0001\r\u00111A\u0005\n\t=\u0001b\u0003B\u000e\u0001\u0001\u0007\t\u0019!C\u0005\u0005;A1B!\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010\"9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B$\u0001\u0011\u0005#\u0011\n\u0005\b\u0005'\u0002A\u0011\u0001B%\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005\u0013BqA!\u0019\u0001\t\u0013\u0011\u0019\u0007C\u0005\u0003|\u0001\t\n\u0011\"\u0003\u0003~!9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u00119\u000b\u0001C\u0001\u0005\u0013BqAa+\u0001\t\u0003\u0011I\u0005C\u0004\u00030\u0002!\tA!\u0013\t\u000f\tM\u0006\u0001\"\u0003\u00036\"9!\u0011\u0018\u0001\u0005\u0002\t%\u0003b\u0002B_\u0001\u0011\u0005!\u0011\n\u0005\b\u0005\u0003\u0004A\u0011\u0002Bb\u0011\u001d\u00119\r\u0001C\u0001\u0005\u0013BqAa3\u0001\t\u0003\u0011I\u0005C\u0004\u0003P\u0002!\tA!\u0013\t\u000f\tM\u0007\u0001\"\u0003\u0003V\"9!Q\u001c\u0001\u0005\n\t}\u0007\"\u0003B\u0000\u0001E\u0005I\u0011BB\u0001\u0011\u001d\u0019)\u0001\u0001C\u0005\u0007\u000fAqaa\u0003\u0001\t\u0013\u0019iA\u0001\bBG2\u001cu.\\7b]\u0012$Vm\u001d;\u000b\u0005\u0019;\u0015!B1e[&t'\"\u0001%\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aS)\u0011\u00051{U\"A'\u000b\u00059;\u0015AB:feZ,'/\u0003\u0002Q\u001b\n\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0011\u0005I+V\"A*\u000b\u0005Q;\u0015!B;uS2\u001c\u0018B\u0001,T\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A-\u0011\u0005i\u0003Q\"A#\u0002\u000fM,'O^3sgV\tQ\fE\u0002_Q.t!aX3\u000f\u0005\u0001\u001cW\"A1\u000b\u0005\tL\u0015A\u0002\u001fs_>$h(C\u0001e\u0003\u0015\u00198-\u00197b\u0013\t1w-A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u0011L!!\u001b6\u0003\u0007M+\u0017O\u0003\u0002gOB\u0011A\n\\\u0005\u0003[6\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0001H\u000f\u0005\u0002re6\tq-\u0003\u0002tO\n!QK\\5u\u0011\u001d)8!!AA\u0002u\u000b1\u0001\u001f\u00132\u0003!\u0019XM\u001d<feN\u0004\u0013!\u00039sS:\u001c\u0017\u000e]1m+\u0005I\bc\u0001>\u0002\u000e5\t1P\u0003\u0002}{\u0006!\u0011-\u001e;i\u0015\tqx0\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0011\t\t!a\u0001\u0002\r\r|W.\\8o\u0015\rA\u0015Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\t1a\u001c:h\u0013\r\tya\u001f\u0002\u000f\u0017\u000647.\u0019)sS:\u001c\u0017\u000e]1m\u0003)\u0001(/\u001b8dSB\fG\u000eI\u0001\u0006+N,'o]\u000b\u0003\u0003/\u0001R!!\u0007\u0002$el!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nS6lW\u000f^1cY\u0016T1!!\th\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\tYBA\u0002TKR\fa!V:feN\u0004\u0013!\u0002%pgR\u001cXCAA\u0017!\u0019\tI\"a\t\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001\u00027b]\u001eT!!!\u000f\u0002\t)\fg/Y\u0005\u0005\u0003{\t\u0019D\u0001\u0004TiJLgnZ\u0001\u0007\u0011>\u001cHo\u001d\u0011\u0002!\u0005cGn\\<I_N$8i\\7nC:$WCAA#!\u0015\t\u0018qIA\u0018\u0013\r\tIe\u001a\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0012\u00032dwn\u001e%pgR\u001cu.\\7b]\u0012\u0004\u0013a\u0004#f]fDun\u001d;D_6l\u0017M\u001c3\u0002!\u0011+g.\u001f%pgR\u001cu.\\7b]\u0012\u0004\u0013aD\"mkN$XM\u001d*fg>,(oY3\u0016\u0005\u0005U\u0003\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005ms0\u0001\u0005sKN|WO]2f\u0013\u0011\ty&!\u0017\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\f\u0001c\u00117vgR,'OU3t_V\u00148-\u001a\u0011\u0002\u001dQ{\u0007/[2SKN|WO]2fgV\u0011\u0011q\r\t\u0007\u00033\t\u0019#!\u0016\u0002\u001fQ{\u0007/[2SKN|WO]2fg\u0002\nab\u0012:pkB\u0014Vm]8ve\u000e,7/A\bHe>,\bOU3t_V\u00148-Z:!\u0003a!&/\u00198tC\u000e$\u0018n\u001c8bY&#'+Z:pkJ\u001cWm]\u0001\u001a)J\fgn]1di&|g.\u00197JIJ+7o\\;sG\u0016\u001c\b%\u0001\bU_.,gNU3t_V\u00148-Z:\u0002\u001fQ{7.\u001a8SKN|WO]2fg\u0002\n\u0011CU3t_V\u00148-\u001a+p\u0007>lW.\u00198e+\t\tY\b\u0005\u0005\u0002\u001a\u0005u\u0014\u0011QAH\u0013\u0011\ty(a\u0007\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002\u0004\u0006-\u0015Q\u000b\b\u0005\u0003\u000b\u000b9\t\u0005\u0002aO&\u0019\u0011\u0011R4\u0002\rA\u0013X\rZ3g\u0013\u0011\t)#!$\u000b\u0007\u0005%u\rE\u0003r\u0003\u000f\n\t\n\u0005\u0003\u0002\u0004\u0006M\u0015\u0002BA\u001f\u0003\u001b\u000b!CU3t_V\u00148-\u001a+p\u0007>lW.\u00198eA\u0005!\"+Z:pkJ\u001cW\rV8Pa\u0016\u0014\u0018\r^5p]N,\"!a'\u0011\u0011\u0005e\u0011QPAA\u0003;\u0003r!]AP\u0003G\u000by)C\u0002\u0002\"\u001e\u0014a\u0001V;qY\u0016\u0014\u0004CBAB\u0003\u0017\u000b)\u000b\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYk`\u0001\u0004C\u000ed\u0017\u0002BAX\u0003S\u0013A\"Q2m\u001fB,'/\u0019;j_:\fQCU3t_V\u00148-\u001a+p\u001fB,'/\u0019;j_:\u001c\b%\u0001\fQe>$WoY3s%\u0016\u001cx.\u001e:dKR{\u0017i\u00197t)\u0011\t9,!1\u0011\u0011\u0005e\u0011QPAA\u0003s\u0003b!a!\u0002\f\u0006m\u0006\u0003BAT\u0003{KA!a0\u0002*\n\u0011\u0012iY2fgN\u001cuN\u001c;s_2,e\u000e\u001e:z\u0011%\t\u0019-\bI\u0001\u0002\u0004\t)-A\tf]\u0006\u0014G.Z%eK6\u0004x\u000e^3oG\u0016\u00042!]Ad\u0013\r\tIm\u001a\u0002\b\u0005>|G.Z1o\u0003\u0001\u0002&o\u001c3vG\u0016\u0014(+Z:pkJ\u001cW\rV8BG2\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005='\u0006BAc\u0003#\\#!a5\u0011\t\u0005U\u0017q\\\u0007\u0003\u0003/TA!!7\u0002\\\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;<\u0017AC1o]>$\u0018\r^5p]&!\u0011\u0011]Al\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mgV\u0011\u0011qW\u0001\u0018\u0007>t7/^7feJ+7o\\;sG\u0016$v.Q2mg\u0002\n1cQ7e)>\u0014Vm]8ve\u000e,7\u000fV8BG2,\"!!<\u0011\u0011\u0005e\u0011QPAH\u0003_\u0004\u0002\"a!\u0002r\u0006\u0005\u0015\u0011X\u0005\u0005\u0003\u007f\ni)\u0001\u000bD[\u0012$vNU3t_V\u00148-Z:U_\u0006\u001bG\u000eI\u0001\fEJ|7.\u001a:Qe>\u00048/\u0006\u0002\u0002zB!\u00111 B\u0001\u001b\t\tiP\u0003\u0003\u0002\u0000\u0006]\u0012\u0001B;uS2LAAa\u0001\u0002~\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001f\t\u0014xn[3s!J|\u0007o]0%KF$2\u0001\u001dB\u0005\u0011!)H%!AA\u0002\u0005e\u0018\u0001\u00042s_.,'\u000f\u0015:paN\u0004\u0013A\u0002>l\u0003J<7/\u0006\u0002\u0002\u0010\u0006Q!p[!sON|F%Z9\u0015\u0007A\u0014)\u0002\u0003\u0005vO\u0005\u0005\t\u0019AAH\u0003\u001dQ8.\u0011:hg\u0002\n\u0011\"\u00193nS:\f%oZ:\u0002\u001b\u0005$W.\u001b8Be\u001e\u001cx\fJ3r)\r\u0001(q\u0004\u0005\tk*\n\t\u00111\u0001\u0002\u0010\u0006Q\u0011\rZ7j]\u0006\u0013xm\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0007A\u00149\u0003C\u0004\u0003*1\u0002\rAa\u000b\u0002\u0011Q,7\u000f^%oM>\u0004BA!\f\u0003<5\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$A\u0002ba&TAA!\u000e\u00038\u00059!.\u001e9ji\u0016\u0014(\u0002\u0002B\u001d\u0003\u0013\tQA[;oSRLAA!\u0010\u00030\tAA+Z:u\u0013:4w\u000eK\u0002-\u0005\u0003\u0002BA!\f\u0003D%!!Q\tB\u0018\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\t\u0001\u000fK\u0002.\u0005\u001b\u0002BA!\f\u0003P%!!\u0011\u000bB\u0018\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\ruKN$\u0018i\u00197DY&<\u0016\u000e\u001e5BkRDwN]5{KJD3A\fB,!\u0011\u0011iC!\u0017\n\t\tm#q\u0006\u0002\u0005)\u0016\u001cH/\u0001\fuKN$\u0018i\u00197DY&<\u0016\u000e\u001e5BI6Lg.\u0011)JQ\ry#qK\u0001\rGJ,\u0017\r^3TKJ4XM\u001d\u000b\u0004a\n\u0015\u0004\"\u0003B4aA\u0005\t\u0019\u0001B5\u00035\u0019w.\\7b]\u0012\u001cuN\u001c4jOB)\u0011Oa\u001b\u0003p%\u0019!QN4\u0003\r=\u0003H/[8o!\u0011\u0011\tHa\u001e\u000e\u0005\tM$\u0002\u0002B;\u0003o\t!![8\n\t\te$1\u000f\u0002\u0005\r&dW-\u0001\fde\u0016\fG/Z*feZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yH\u000b\u0003\u0003j\u0005E\u0017\u0001C2bY2l\u0015-\u001b8\u0015\t\t\u0015%q\u0011\t\bc\u0006}\u0015\u0011SAI\u0011\u001d\u0011II\ra\u0001\u0003\u001f\u000bA!\u0019:hg\u0006QA/Z:u\u0003\u000ed7\t\\5\u0015\u0007A\u0014y\tC\u0004\u0003\u0012N\u0002\r!a$\u0002\u000f\rlG-\u0011:hg\u0006!\u0012m]:feR|U\u000f\u001e9vi\u000e{g\u000e^1j]N$\u0012\u0002\u001dBL\u00057\u0013yJa)\t\u000f\teE\u00071\u0001\u0002\u0012\u00061\u0001O]3gSbDqA!(5\u0001\u0004\t\t)A\u0005sKN|WO]2fg\"9!\u0011\u0015\u001bA\u0002\u0005=\u0015a\u0003:fg>,(oY3D[\u0012DqA!*5\u0001\u0004\t\t*\u0001\u0004pkR\u0004X\u000f^\u0001&i\u0016\u001cH\u000f\u0015:pIV\u001cWM]\"p]N,X.\u001a:DY&<\u0016\u000e\u001e5BkRDwN]5{KJD3!\u000eB,\u0003\r\"Xm\u001d;Qe>$WoY3s\u0007>t7/^7fe\u000ec\u0017nV5uQ\u0006#W.\u001b8B!&C3A\u000eB,\u0003Y!Xm\u001d;BG2\u001cE.[,ji\"\u001cE.[3oi&#\u0007fA\u001c\u0003X\u00059B/Z:u!J|G-^2fe\u000e{gn];nKJ\u001cE.\u001b\u000b\u0004a\n]\u0006b\u0002BIq\u0001\u0007\u0011qR\u0001*i\u0016\u001cH/Q2mg>s\u0007K]3gSb,GMU3t_V\u00148-Z:XSRD\u0017)\u001e;i_JL'0\u001a:)\u0007e\u00129&A\u0014uKN$\u0018i\u00197t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cWm],ji\"\fE-\\5o\u0003BK\u0005f\u0001\u001e\u0003X\u0005YB/Z:u\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dKN$2\u0001\u001dBc\u0011\u001d\u0011\tj\u000fa\u0001\u0003\u001f\u000bQ\u0004^3ti&sg/\u00197jI\u0006+H\u000f[8sSj,'\u000f\u0015:pa\u0016\u0014H/\u001f\u0015\u0004y\t]\u0013\u0001\u0005;fgR\u0004\u0016\r\u001e;fe:$\u0016\u0010]3tQ\ri$qK\u0001\u0014i\u0016\u001cHo\u00117vgR,'\u000fT5oW\u0006\u001bGn\u001d\u0015\u0004}\t]\u0013A\u0003;fgR\u0014V-\\8wKR9\u0001Oa6\u0003Z\nm\u0007b\u0002BI\u007f\u0001\u0007\u0011q\u0012\u0005\b\u0005;{\u0004\u0019AAA\u0011\u001d\u0011\tk\u0010a\u0001\u0003\u001f\u000bqbZ3u\u0003\u000edGk\\\"p[6\fg\u000e\u001a\u000b\t\u0005C\u0014\u0019O!<\u0003rB9\u0011/a(\u0002:\u0006=\u0005b\u0002Bs\u0001\u0002\u0007!q]\u0001\u000fa\u0016\u0014X.[:tS>tG+\u001f9f!\u0011\t9K!;\n\t\t-\u0018\u0011\u0016\u0002\u0012\u0003\u000ed\u0007+\u001a:nSN\u001c\u0018n\u001c8UsB,\u0007b\u0002Bx\u0001\u0002\u0007\u00111U\u0001\u000b_B,'/\u0019;j_:\u001c\b\"\u0003Bz\u0001B\u0005\t\u0019\u0001B{\u0003\u001da\u0017N\\6JIN\u0004b!a!\u0002\f\n]\b\u0003\u0002B}\u0005wl\u0011a`\u0005\u0004\u0005{|(\u0001B+vS\u0012\f\u0011dZ3u\u0003\u000edGk\\\"p[6\fg\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0001\u0016\u0005\u0005k\f\t.\u0001\u0004hKR\u001cU\u000e\u001a\u000b\u0005\u0003\u001f\u001bI\u0001C\u0004\u0003f\n\u0003\rAa:\u0002\u001d]LG\u000f[!vi\"|'/\u001b>feR\u00111q\u0002\u000b\u0004a\u000eE\u0001bBB\n\u0007\u0002\u00071QC\u0001\u0002MB1\u0011oa\u0006\u0004\u001cAL1a!\u0007h\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0004\u001e\r\u0015RBAB\u0010\u0015\u0011\u0019\tca\t\u0002\u0015\u0005,H\u000f[8sSj,'OC\u0002O\u0003\u0007IAaa\n\u0004 \tQ\u0011)\u001e;i_JL'0\u001a:")
public class AclCommandTest
extends QuorumTestHarness {
    private scala.collection.immutable.Seq<KafkaServer> servers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    private final KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private final Set<KafkaPrincipal> Users = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaPrincipal[]{SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), this.principal(), SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \\\" \\\\ \\< \\> \\; ')")}));
    private final Set<String> Hosts = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"host1", "host2"}));
    private final String[] AllowHostCommand = new String[]{"--allow-host", "host1", "--allow-host", "host2"};
    private final String[] DenyHostCommand = new String[]{"--deny-host", "host1", "--deny-host", "host2"};
    private final ResourcePattern ClusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final Set<ResourcePattern> TopicResources = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> GroupResources = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TransactionalIdResources = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL)}));
    private final Set<ResourcePattern> TokenResources = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL)}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new String[]{"--topic", "test-1", "--topic", "test-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new String[]{"--cluster"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new String[]{"--group", "testGroup-1", "--group", "testGroup-2"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new String[]{"--transactional-id", "t0", "--transactional-id", "t1"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new String[]{"--delegation-token", "token1", "--delegation-token", "token2"})}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER})), (Object)new String[]{"--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE})), (Object)new String[]{"--operation", "Read", "--operation", "Describe", "--operation", "Delete"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE})), (Object)new String[]{"--operation", "Describe", "--operation", "Write"})), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TokenResources()), (Object)new Tuple2(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE})), (Object)new String[]{"--operation", "Describe"}))}));
    private final scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.GroupResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5()))}));
    private final scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer"}), this.ProducerResourceToAcls(this.ProducerResourceToAcls$default$1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent"}), this.ProducerResourceToAcls(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--consumer"}), this.ConsumerResourceToAcls()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$1 -> {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$1._1();
        Set v = (Set)x0$1._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(false).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new String[]{"--producer", "--idempotent", "--consumer"}), (Object)this.ConsumerResourceToAcls().map((Function1 & Serializable)x0$2 -> {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        Set k = (Set)x0$2._1();
        Set v = (Set)x0$2._2();
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v.$plus$plus((IterableOnce)this.ProducerResourceToAcls(true).getOrElse((Object)k, (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())));
        return tuple2;
    }))}));
    private Properties brokerProps;
    private String[] zkArgs;
    private String[] adminArgs;

    public scala.collection.immutable.Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private Set<KafkaPrincipal> Users() {
        return this.Users;
    }

    private Set<String> Hosts() {
        return this.Hosts;
    }

    private String[] AllowHostCommand() {
        return this.AllowHostCommand;
    }

    private String[] DenyHostCommand() {
        return this.DenyHostCommand;
    }

    private ResourcePattern ClusterResource() {
        return this.ClusterResource;
    }

    private Set<ResourcePattern> TopicResources() {
        return this.TopicResources;
    }

    private Set<ResourcePattern> GroupResources() {
        return this.GroupResources;
    }

    private Set<ResourcePattern> TransactionalIdResources() {
        return this.TransactionalIdResources;
    }

    private Set<ResourcePattern> TokenResources() {
        return this.TokenResources;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, String[]> ResourceToCommand() {
        return this.ResourceToCommand;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Tuple2<Set<AclOperation>, String[]>> ResourceToOperations() {
        return this.ResourceToOperations;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ProducerResourceToAcls(boolean enableIdempotence) {
        return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TopicResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TransactionalIdResources()), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.WRITE, AclOperation.DESCRIBE})), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}))), (Object)AclCommand$.MODULE$.getAcls(this.Users(), AclPermissionType.ALLOW, (Set)((IterableOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{enableIdempotence ? new Some((Object)AclOperation.IDEMPOTENT_WRITE) : None$.MODULE$}))).flatten(Predef$.MODULE$.$conforms()), this.Hosts(), AclCommand$.MODULE$.getAcls$default$5()))}));
    }

    private boolean ProducerResourceToAcls$default$1() {
        return false;
    }

    private scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>> ConsumerResourceToAcls() {
        return this.ConsumerResourceToAcls;
    }

    private scala.collection.immutable.Map<String[], scala.collection.immutable.Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CmdToResourcesToAcl() {
        return this.CmdToResourcesToAcl;
    }

    private Properties brokerProps() {
        return this.brokerProps;
    }

    private void brokerProps_$eq(Properties x$1) {
        this.brokerProps = x$1;
    }

    private String[] zkArgs() {
        return this.zkArgs;
    }

    private void zkArgs_$eq(String[] x$1) {
        this.zkArgs = x$1;
    }

    private String[] adminArgs() {
        return this.adminArgs;
    }

    private void adminArgs_$eq(String[] x$1) {
        this.adminArgs = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.brokerProps_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        this.brokerProps().put(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), AclAuthorizer.class.getName());
        this.brokerProps().put(AclAuthorizer$.MODULE$.SuperUsersProp(), "User:ANONYMOUS");
        this.zkArgs_$eq(new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString()});
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testAclCliWithAuthorizer() {
        this.testAclCli(this.zkArgs());
    }

    @Test
    public void testAclCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclCli(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void createServer(Option<File> commandConfig) {
        void createServer_time;
        void createServer_config;
        Time time;
        Object[] objectArray = new KafkaServer[1];
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(this.brokerProps());
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        Object var7_6 = null;
        Object var4_5 = null;
        kafkaConfig = null;
        time3 = null;
        objectArray[0] = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Object[] adminArgs = new String[]{"--bootstrap-server", TestUtils$.MODULE$.bootstrapServers(this.servers(), listenerName)};
        if (commandConfig.isDefined()) {
            adminArgs = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(adminArgs), (Object)new String[]{"--command-config", ((File)commandConfig.get()).getAbsolutePath()}, ClassTag$.MODULE$.apply(String.class));
        }
        this.adminArgs_$eq((String[])adminArgs);
    }

    private Option<File> createServer$default$1() {
        return None$.MODULE$;
    }

    private Tuple2<String, String> callMain(String[] args) {
        JFunction0.mcV.sp & Serializable grabConsoleOutputAndError_f = (JFunction0.mcV.sp & Serializable)() -> AclCommand$.MODULE$.main(args);
        ByteArrayOutputStream grabConsoleOutputAndError_out = new ByteArrayOutputStream();
        ByteArrayOutputStream grabConsoleOutputAndError_err = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutputAndError_out, (Function0)((JFunction0.mcV.sp & Serializable)() -> TestUtils$.$anonfun$grabConsoleOutputAndError$1(grabConsoleOutputAndError_err, (Function0)grabConsoleOutputAndError_f)));
        }
        finally {
            Console$.MODULE$.out().flush();
            Console$.MODULE$.err().flush();
        }
        return new Tuple2((Object)grabConsoleOutputAndError_out.toString(), (Object)grabConsoleOutputAndError_err.toString());
    }

    private void testAclCli(String[] cmdArgs) {
        this.ResourceToCommand().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> {
            AclCommandTest.$anonfun$testAclCli$2(this, cmdArgs, x$7);
            return BoxedUnit.UNIT;
        });
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, String[] resourceCmd, String output) {
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$assertOutputContains$1(this, resourceCmd, prefix, output, resource);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testProducerConsumerCliWithAuthorizer() {
        this.testProducerConsumerCli(this.zkArgs());
    }

    @Test
    public void testProducerConsumerCliWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testProducerConsumerCli(this.adminArgs());
    }

    @Test
    public void testAclCliWithClientId() {
        File file;
        File file2 = file = TestUtils.tempFile();
        file = null;
        File adminClientConfig = file2;
        PrintWriter pw = new PrintWriter(adminClientConfig);
        pw.println("client.id=my-client");
        pw.close();
        this.createServer((Option<File>)new Some((Object)adminClientConfig));
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        Level previousLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, Level.WARN);
        try {
            this.testAclCli(this.adminArgs());
        }
        finally {
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(AppInfoParser.class, previousLevel);
            LogCaptureAppender$.MODULE$.unregister(appender);
        }
        Assertions.assertFalse((boolean)appender.getMessages().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$testAclCliWithClientId$1(e))).isDefined(), (String)"There should be no warnings about multiple registration of mbeans");
    }

    private void testProducerConsumerCli(String[] cmdArgs) {
        this.CmdToResourcesToAcl().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$12 -> {
            AclCommandTest.$anonfun$testProducerConsumerCli$2(this, cmdArgs, x$12);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAuthorizer() {
        this.testAclsOnPrefixedResources(this.zkArgs());
    }

    @Test
    public void testAclsOnPrefixedResourcesWithAdminAPI() {
        this.createServer((Option<File>)None$.MODULE$);
        this.testAclsOnPrefixedResources(this.adminArgs());
    }

    /*
     * WARNING - void declaration
     */
    private void testAclsOnPrefixedResources(String[] cmdArgs) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        void withAuthorizer_fromProps_doLog2;
        KafkaConfig kafkaConfig2;
        String[] cmd = new String[]{"--allow-principal", this.principal().toString(), "--producer", "--topic", "Test-", "--resource-pattern-type", "Prefixed"};
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = this.brokerProps();
        KafkaConfig kafkaConfig3 = kafkaConfig2 = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog2);
        Object var6_4 = null;
        kafkaConfig2 = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig3;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$1(this, (Authorizer)withAuthorizer_authZ);
        }
        Object var3_6 = null;
        Object var4_7 = null;
        this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        boolean bl2 = false;
        Properties withAuthorizer_fromProps_props2 = this.brokerProps();
        KafkaConfig kafkaConfig4 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props2, (boolean)withAuthorizer_fromProps_doLog);
        Object var12_10 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig2 = kafkaConfig4;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig2.originals());
            AclCommandTest.$anonfun$testAclsOnPrefixedResources$2((Authorizer)withAuthorizer_authZ);
        }
    }

    @Test
    public void testInvalidAuthorizerProperty() {
        String[] args = new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect ").append(this.zkConnect()).toString()};
        AclCommand.AuthorizerService aclCommandService = new AclCommand.AuthorizerService(AclAuthorizer.class.getName(), new AclCommand.AclCommandOptions(args));
        Assertions.assertThrows(IllegalArgumentException.class, () -> aclCommandService.listAcls());
    }

    @Test
    public void testPatternTypes() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$13) -> AclCommandTest.$anonfun$testPatternTypes$1(BoxesRunTime.unboxToInt((Object)status), x$13);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var2_1 = null;
        try {
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])PatternType.values()), (Function1 & Serializable)patternType -> {
                AclCommandTest.$anonfun$testPatternTypes$3(this, patternType);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testClusterLinkAcls() {
        this.createServer((Option<File>)None$.MODULE$);
        String[] cmdArgs = this.adminArgs();
        Uuid link1 = Uuid.randomUuid();
        Uuid link2 = Uuid.randomUuid();
        Uuid local = Uuid.ZERO_UUID;
        Set<ResourcePattern> link1Resources = this.TopicResources();
        Set<ResourcePattern> link2Resources = this.GroupResources();
        Set multiLinkResources = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ResourcePattern[]{this.ClusterResource()}));
        scala.collection.immutable.Map linkIdMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(link1Resources), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(link2Resources), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)multiLinkResources), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Uuid[]{link1, link2, local})))}));
        linkIdMap.keySet().foreach((Function1 & Serializable)resources -> {
            AclCommandTest.$anonfun$testClusterLinkAcls$1(this, linkIdMap, cmdArgs, local, resources);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void testRemove(String[] cmdArgs, Set<ResourcePattern> resources, String[] resourceCmd) {
        void var6_6;
        void var5_5;
        Tuple2<String, String> tuple2 = this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs), (Object)resourceCmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--remove", ClassTag$.MODULE$.apply(String.class))), (Object)"--force", ClassTag$.MODULE$.apply(String.class)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String out = (String)tuple2._1();
        String err = (String)tuple2._2();
        Assertions.assertEquals((Object)"", (Object)var5_5);
        Assertions.assertEquals((Object)"", (Object)var6_6);
        resources.foreach((Function1 & Serializable)resource -> {
            AclCommandTest.$anonfun$testRemove$1(this, resource);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Set<AccessControlEntry>, String[]> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations, Set<Uuid> linkIds) {
        return new Tuple2((Object)AclCommand$.MODULE$.getAcls(this.Users(), permissionType, operations, this.Hosts(), linkIds), (Object)this.getCmd(permissionType));
    }

    private Set<Uuid> getAclToCommand$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    private String[] getCmd(AclPermissionType permissionType) {
        AclPermissionType aclPermissionType = permissionType;
        AclPermissionType aclPermissionType2 = AclPermissionType.ALLOW;
        String principalCmd = !(aclPermissionType != null ? !aclPermissionType.equals(aclPermissionType2) : aclPermissionType2 != null) ? "--allow-principal" : "--deny-principal";
        AclPermissionType aclPermissionType3 = permissionType;
        AclPermissionType aclPermissionType4 = AclPermissionType.ALLOW;
        String[] cmd2 = !(aclPermissionType3 != null ? !aclPermissionType3.equals(aclPermissionType4) : aclPermissionType4 != null) ? this.AllowHostCommand() : this.DenyHostCommand();
        return (String[])this.Users().foldLeft((Object)cmd2, (Function2 & Serializable)(cmd, user) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmd), (Object)new String[]{principalCmd, user.toString()}, ClassTag$.MODULE$.apply(String.class)));
    }

    /*
     * WARNING - void declaration
     */
    private void withAuthorizer(Function1<Authorizer, BoxedUnit> f) {
        void fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties fromProps_props = this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)fromProps_props, (boolean)fromProps_doLog);
        Object var5_3 = null;
        kafkaConfig = null;
        KafkaConfig kafkaConfig3 = kafkaConfig2;
        try (AclAuthorizer authZ = new AclAuthorizer();){
            authZ.configure(kafkaConfig3.originals());
            f.apply((Object)authZ);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$4(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var6_4 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testAclCli$3(AclCommandTest $this, Set resources$1, String[] cmdArgs$1, String[] resourceCmd$1, AclPermissionType permissionType) {
        void var14_14;
        void var13_13;
        void var7_7;
        void var11_11;
        void var10_10;
        void var8_8;
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources$1);
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(permissionType, (Set<AclOperation>)((Set)operationToCmd._1()), $this.getAclToCommand$default$3());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2<String, String> tuple22 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)var8_8, ClassTag$.MODULE$.apply(String.class))), (Object)resourceCmd$1, ClassTag$.MODULE$.apply(String.class))), operationToCmd._2(), ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var10_10);
        Assertions.assertEquals((Object)"", (Object)var11_11);
        resources$1.foreach(arg_0 -> AclCommandTest.$anonfun$testAclCli$4$adapted($this, (Set)var7_7, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$1), (Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources$1, resourceCmd$1, (String)var13_13);
        Assertions.assertEquals((Object)"", (Object)var14_14);
        $this.testRemove(cmdArgs$1, (Set<ResourcePattern>)resources$1, resourceCmd$1);
    }

    public static final /* synthetic */ void $anonfun$testAclCli$2(AclCommandTest $this, String[] cmdArgs$1, Tuple2 x$7) {
        if (x$7 != null) {
            Set resources = (Set)x$7._1();
            String[] resourceCmd = (String[])x$7._2();
            ((IterableOnceOps)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclPermissionType[]{AclPermissionType.ALLOW, AclPermissionType.DENY}))).foreach((Function1 & Serializable)permissionType -> {
                AclCommandTest.$anonfun$testAclCli$3($this, resources, cmdArgs$1, resourceCmd, permissionType);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$assertOutputContains$2(String x$8) {
        return !x$8.startsWith("--");
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$3(String prefix$1, String resourceType$1, String output$1, String name) {
        String expected = new StringBuilder(75).append(prefix$1).append(" for resource `ResourcePattern(resourceType=").append(resourceType$1).append(", name=").append(name).append(", patternType=LITERAL)`:").toString();
        Assertions.assertTrue((boolean)output$1.contains(expected), (String)new StringBuilder(26).append("Substring ").append(expected).append(" not in output:\n").append(output$1).toString());
    }

    public static final /* synthetic */ void $anonfun$assertOutputContains$1(AclCommandTest $this, String[] resourceCmd$2, String prefix$1, String output$1, ResourcePattern resource) {
        Object[] objectArray;
        String resourceType = resource.resourceType().toString();
        if (resource.equals($this.ClusterResource())) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = "kafka-cluster";
        } else {
            objectArray = (Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])resourceCmd$2), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclCommandTest.$anonfun$assertOutputContains$2(x$8)));
        }
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(objectArray), (Function1 & Serializable)name -> {
            AclCommandTest.$anonfun$assertOutputContains$3(prefix$1, resourceType, output$1, name);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testAclCliWithClientId$1(LoggingEvent e) {
        Level level = e.getLevel();
        Level level2 = Level.WARN;
        if (!(level != null ? !level.equals(level2) : level2 != null) && e.getThrowableInformation() != null) {
            String string = e.getThrowableInformation().getThrowable().getClass().getName();
            String string2 = InstanceAlreadyExistsException.class.getName();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$6(AclCommandTest $this, Set acls$2, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var6_4 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$5(AclCommandTest $this, Tuple2 x$11) {
        if (x$11 != null) {
            Set resources = (Set)x$11._1();
            Set acls = (Set)x$11._2();
            resources.foreach((Function1 & Serializable)resource -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$6($this, acls, resource);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testProducerConsumerCli$2(AclCommandTest $this, String[] cmdArgs$2, Tuple2 x$12) {
        if (x$12 != null) {
            String[] cmd = (String[])x$12._1();
            scala.collection.immutable.Map resourcesToAcls = (scala.collection.immutable.Map)x$12._2();
            Object[] resourceCommand = (String[])((IterableOnceOps)resourcesToAcls.keys().map($this.ResourceToCommand())).foldLeft(Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), (Function2 & Serializable)(x$9, x$10) -> (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])x$9), x$10, ClassTag$.MODULE$.apply(String.class)));
            $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$2), (Object)$this.getCmd(AclPermissionType.ALLOW), ClassTag$.MODULE$.apply(String.class))), (Object)resourceCommand, ClassTag$.MODULE$.apply(String.class))), (Object)cmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
            resourcesToAcls.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$11 -> {
                AclCommandTest.$anonfun$testProducerConsumerCli$5($this, x$11);
                return BoxedUnit.UNIT;
            });
            $this.testRemove(cmdArgs$2, (Set<ResourcePattern>)((IterableOnceOps)resourcesToAcls.keys().flatten(Predef$.MODULE$.$conforms())).toSet(), (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(resourceCommand), (Object)cmd, ClassTag$.MODULE$.apply(String.class)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$1(AclCommandTest $this, Authorizer authorizer) {
        AccessControlEntry writeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry($this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl, describeAcl, createAcl}))), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ void $anonfun$testAclsOnPrefixedResources$2(Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL), AccessControlEntryFilter.ANY);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED), AccessControlEntryFilter.ANY);
    }

    public static final /* synthetic */ Nothing$ $anonfun$testPatternTypes$1(int status, Option x$13) {
        if (status == 1) {
            throw new RuntimeException("Exiting command");
        }
        throw new AssertionError((Object)new StringBuilder(28).append("Unexpected exit with status ").append(status).toString());
    }

    private final void verifyPatternType$1(String[] cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
            return;
        }
        Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
    }

    public static final /* synthetic */ void $anonfun$testPatternTypes$3(AclCommandTest $this, PatternType patternType) {
        String[] addCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--allow-principal", $this.principal().toString(), "--producer", "--topic", "Test", "--add", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(addCmd, patternType.isSpecific());
        String[] listCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--list", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(listCmd, !patternType.equals(PatternType.UNKNOWN));
        String[] removeCmd = (String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])$this.zkArgs()), (Object)new String[]{"--topic", "Test", "--force", "--remove", "--resource-pattern-type", patternType.toString()}, ClassTag$.MODULE$.apply(String.class));
        $this.verifyPatternType$1(removeCmd, !patternType.equals(PatternType.UNKNOWN));
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$4(Set acls$3, scala.collection.immutable.Seq linkIds$1, ResourcePattern resource$3, Authorizer authorizer) {
        Set linkAcls = (Set)acls$3.map((Function1 & Serializable)acl -> SecurityUtils.aceWithClusterLinkIds((AccessControlEntry)acl, (Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)linkIds$1).asJava()));
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)linkAcls, authorizer, resource$3, AccessControlEntryFilter.ANY);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$3(AclCommandTest $this, Set acls$3, scala.collection.immutable.Seq linkIds$1, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var7_5 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            AclCommandTest.$anonfun$testClusterLinkAcls$4(acls$3, linkIds$1, resource, (Authorizer)withAuthorizer_authZ);
        }
    }

    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$6(Uuid local$1, String listOut$1, Uuid linkId) {
        Uuid uuid = linkId;
        String linkIdString = !(uuid != null ? !uuid.equals(local$1) : local$1 != null) ? "LocalCluster" : linkId.toString();
        Assertions.assertTrue((boolean)listOut$1.contains(linkIdString), (String)new StringBuilder(40).append("Link-id '").append(linkIdString).append("' not included in list output: ").append(listOut$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testClusterLinkAcls$1(AclCommandTest $this, scala.collection.immutable.Map linkIdMap$1, String[] cmdArgs$3, Uuid local$1, Set resources) {
        void var17_17;
        void var16_16;
        void var10_10;
        void var14_14;
        void var13_13;
        void var11_11;
        String[] resourceCmd = (String[])$this.ResourceToCommand().apply((Object)resources);
        Tuple2 operationToCmd = (Tuple2)$this.ResourceToOperations().apply((Object)resources);
        scala.collection.immutable.Seq linkIds = (scala.collection.immutable.Seq)linkIdMap$1.apply((Object)resources);
        String[] linkIdCmd = (String[])((IterableOnceOps)linkIds.flatMap((Function1 & Serializable)id -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--link-id", id.toString()})))).toArray(ClassTag$.MODULE$.apply(String.class));
        Tuple2<Set<AccessControlEntry>, String[]> tuple2 = $this.getAclToCommand(AclPermissionType.ALLOW, (Set<AclOperation>)((Set)operationToCmd._1()), $this.getAclToCommand$default$3());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Set acls = (Set)tuple2._1();
        String[] cmd = (String[])tuple2._2();
        Tuple2<String, String> tuple22 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3), (Object)var11_11, ClassTag$.MODULE$.apply(String.class))), (Object)resourceCmd, ClassTag$.MODULE$.apply(String.class))), operationToCmd._2(), ClassTag$.MODULE$.apply(String.class))), (Object)linkIdCmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--add", ClassTag$.MODULE$.apply(String.class)));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        String addOut = (String)tuple22._1();
        String addErr = (String)tuple22._2();
        $this.assertOutputContains("Adding ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)var13_13);
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)var13_13);
        Assertions.assertEquals((Object)"", (Object)var14_14);
        resources.foreach(arg_0 -> AclCommandTest.$anonfun$testClusterLinkAcls$3$adapted($this, (Set)var10_10, linkIds, arg_0));
        Tuple2<String, String> tuple23 = $this.callMain((String[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3), (Object)linkIdCmd, ClassTag$.MODULE$.apply(String.class))), (Object)"--list", ClassTag$.MODULE$.apply(String.class)));
        if (tuple23 == null) {
            throw new MatchError(null);
        }
        String listOut = (String)tuple23._1();
        String listErr = (String)tuple23._2();
        $this.assertOutputContains("Current ACLs", (Set<ResourcePattern>)resources, resourceCmd, (String)var16_16);
        linkIds.foreach(arg_0 -> AclCommandTest.$anonfun$testClusterLinkAcls$6$adapted(local$1, (String)var16_16, arg_0));
        Assertions.assertEquals((Object)"", (Object)var17_17);
        $this.testRemove((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])cmdArgs$3), (Object)linkIdCmd, ClassTag$.MODULE$.apply(String.class)), (Set<ResourcePattern>)resources, resourceCmd);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testRemove$1(AclCommandTest $this, ResourcePattern resource) {
        void withAuthorizer_fromProps_doLog;
        KafkaConfig kafkaConfig;
        boolean bl = false;
        Properties withAuthorizer_fromProps_props = $this.brokerProps();
        KafkaConfig kafkaConfig2 = kafkaConfig = new KafkaConfig((Map)withAuthorizer_fromProps_props, (boolean)withAuthorizer_fromProps_doLog);
        Object var5_3 = null;
        kafkaConfig = null;
        KafkaConfig withAuthorizer_kafkaConfig = kafkaConfig2;
        try (AclAuthorizer withAuthorizer_authZ = new AclAuthorizer();){
            withAuthorizer_authZ.configure(withAuthorizer_kafkaConfig.originals());
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), (Authorizer)withAuthorizer_authZ, resource, AccessControlEntryFilter.ANY);
        }
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$1$adapted(AclCommandTest $this, Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$1($this, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclsOnPrefixedResources$2$adapted(Authorizer authorizer) {
        AclCommandTest.$anonfun$testAclsOnPrefixedResources$2(authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$5$adapted(Set acls$1, ResourcePattern resource$1, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$1, authorizer, resource$1, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testAclCli$4$adapted(AclCommandTest $this, Set acls$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testAclCli$4($this, acls$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testProducerConsumerCli$7$adapted(Set acls$2, ResourcePattern resource$2, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)acls$2, authorizer, resource$2, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$4$adapted(Set acls$3, scala.collection.immutable.Seq linkIds$1, ResourcePattern resource$3, Authorizer authorizer) {
        AclCommandTest.$anonfun$testClusterLinkAcls$4(acls$3, linkIds$1, resource$3, authorizer);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$3$adapted(AclCommandTest $this, Set acls$3, scala.collection.immutable.Seq linkIds$1, ResourcePattern resource) {
        AclCommandTest.$anonfun$testClusterLinkAcls$3($this, acls$3, linkIds$1, resource);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testClusterLinkAcls$6$adapted(Uuid local$1, String listOut$1, Uuid linkId) {
        AclCommandTest.$anonfun$testClusterLinkAcls$6(local$1, listOut$1, linkId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testRemove$2$adapted(ResourcePattern resource$4, Authorizer authorizer) {
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Predef$.MODULE$.Set().empty(), authorizer, resource$4, AccessControlEntryFilter.ANY);
        return BoxedUnit.UNIT;
    }
}

