/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.AbstractLog;
import kafka.log.Defaults$;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u000e\u001c\u0001\u0001BQ!\r\u0001\u0005\u0002IBq\u0001\u000e\u0001A\u0002\u0013\u0005Q\u0007C\u0004B\u0001\u0001\u0007I\u0011\u0001\"\t\r%\u0003\u0001\u0015)\u00037\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015I\u0006\u0001\"\u0001L\u0011\u0015q\u0006\u0001\"\u0001L\u0011\u0015\u0001\u0007\u0001\"\u0001L\u0011\u0015\u0011\u0007\u0001\"\u0001L\u0011\u0015!\u0007\u0001\"\u0001L\u0011\u00151\u0007\u0001\"\u0001L\u0011\u0015A\u0007\u0001\"\u0001L\u0011\u0015Q\u0007\u0001\"\u0001L\u0011\u0015a\u0007\u0001\"\u0001L\u0011\u0015q\u0007\u0001\"\u0001L\u0011\u0015\u0001\b\u0001\"\u0001L\u0011\u0015\u0011\b\u0001\"\u0001L\u0011\u0015!\b\u0001\"\u0001L\u0011\u00151\b\u0001\"\u0001L\u0011\u0015A\b\u0001\"\u0001L\u0011\u0015Q\b\u0001\"\u0001L\u0011\u0015a\b\u0001\"\u0001L\u0011\u0015q\b\u0001\"\u0001L\u0011\u0019\t\t\u0001\u0001C\u0001\u0017\"1\u0011Q\u0001\u0001\u0005\u0002-\u0013\u0011#\u00113nS:T6n\u00117jK:$H+Z:u\u0015\taR$A\u0003bI6LgNC\u0001\u001f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0011([A\u0011!%J\u0007\u0002G)\u0011A%H\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0019\u001a#!E)v_J,X\u000eV3ti\"\u000b'O\\3tgB\u0011\u0001fK\u0007\u0002S)\u0011!&H\u0001\u0006kRLGn]\u0005\u0003Y%\u0012q\u0001T8hO&tw\r\u0005\u0002/_5\t1$\u0003\u000217\ti!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#A\u001a\u0011\u00059\u0002\u0011aB:feZ,'o]\u000b\u0002mA\u0019q\u0007\u0010 \u000e\u0003aR!!\u000f\u001e\u0002\u0015\r|G\u000e\\3di&|gNC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti\u0004HA\u0002TKF\u0004\"AI \n\u0005\u0001\u001b#aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u00111i\u0012\t\u0003\t\u0016k\u0011AO\u0005\u0003\rj\u0012A!\u00168ji\"9\u0001jAA\u0001\u0002\u00041\u0014a\u0001=%c\u0005A1/\u001a:wKJ\u001c\b%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0019\u0005FA\u0003N!\tqu+D\u0001P\u0015\t\u0001\u0016+A\u0002ba&T!AU*\u0002\u000f),\b/\u001b;fe*\u0011A+V\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002-\u0006\u0019qN]4\n\u0005a{%!C!gi\u0016\u0014X)Y2i\u0003m!Xm\u001d;NC:,\u0018\r\u001c*fa2L7-Y!tg&<g.\\3oi\"\u0012aa\u0017\t\u0003\u001drK!!X(\u0003\tQ+7\u000f^\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e\u001c%/Z1uS>t\u0017J\u001c.LQ\t91,\u0001\u0010uKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:<\u0016\u000e\u001e5D_2d\u0017n]5p]\"\u0012\u0001bW\u0001 i\u0016\u001cH/T1sW\u0016$G)\u001a7fi&|g\u000eV8qS\u000e\u001c%/Z1uS>t\u0007FA\u0005\\\u0003\u0005\"Xm\u001d;N_\u000e\\W\rZ\"p]\u000e,(O]3oiR{\u0007/[2De\u0016\fG/[8oQ\tQ1,A\u000euKN$8i\u001c8dkJ\u0014XM\u001c;U_BL7m\u0011:fCRLwN\u001c\u0015\u0003\u0017m\u000b!\u0003^3tiR{\u0007/[2JIV\u0003xM]1eK\"\u0012AbW\u0001\u0015i\u0016\u001cH\u000fV8qS\u000eLE\rR8x]\u001e\u0014\u0018\rZ3)\u00055Y\u0016a\u0004;fgR$v\u000e]5d\u000bbL7\u000f^:)\u00059Y\u0016!\u0005;fgRtU/\u001c)beRLG/[8og\"\u0012qbW\u0001\u0016i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\t\u00012,A\u001buKN$\u0018\t\u001a3QCJ$\u0018\u000e^5p]^KG\u000f\u001b(p!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e(p\u0003N\u001c\u0018n\u001a8nK:$\bFA\t\\\u0003]\"Xm\u001d;BI\u0012\u0004\u0016M\u001d;ji&|gnV5uQ:{\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi^KG\u000f[!tg&<g.\\3oi\"\u0012!cW\u0001=i\u0016\u001cH/\u00113e!\u0006\u0014H/\u001b;j_:<\u0016\u000e\u001e5QY\u0006\u001cW-\\3oi\u000e{gn\u001d;sC&tGOT8QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\u000b\u0002\u00147\u0006qD/Z:u\u0003\u0012$\u0007+\u0019:uSRLwN\\,ji\"\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u/&$\b\u000eU1si&$\u0018n\u001c8BgNLwM\\7f]RD#\u0001F.\u0002uQ,7\u000f^!eIB\u000b'\u000f^5uS>tw+\u001b;i%\u0016\u0004H.[2b!2\f7-Z7f]R\u001cuN\\:ue\u0006Lg\u000e\u001e(piN\u000bG/[:gS\u0016$\u0007FA\u000b\\\u0003m\"Xm\u001d;BI\u0012\u0004\u0016M\u001d;ji&|gnV5uQ>\u00137/\u001a:wKJ\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u\u001d>$8+\u0019;jg\u001aLW\r\u001a\u0015\u0003-m\u000b1e\u001d5pk2$\u0007K]8qC\u001e\fG/\u001a#z]\u0006l\u0017n\u0019\"s_.,'oQ8oM&<7\u000f\u000b\u0002\u00187\u0006YB/Z:u\u0005>|Go\u001d;sCB\u001cE.[3oi&#7i\u001c8gS\u001eD#\u0001G.\u0002-Q,7\u000f^$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uCND#!G.")
public class AdminZkClientTest
extends QuorumTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), true);
        super.tearDown();
    }

    @Test
    public void testManualReplicaAssignment() {
        List brokers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$1 = this.adminZkClient();
            Map x$3 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$4 = qual$1.createTopicWithAssignment$default$4();
            boolean x$5 = qual$1.createTopicWithAssignment$default$5();
            boolean x$6 = qual$1.createTopicWithAssignment$default$6();
            Option x$7 = qual$1.createTopicWithAssignment$default$7();
            qual$1.createTopicWithAssignment("test", topicConfig, x$3, x$4, x$5, x$6, x$7);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Map x$10 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$11 = qual$2.createTopicWithAssignment$default$4();
            boolean x$12 = qual$2.createTopicWithAssignment$default$5();
            boolean x$13 = qual$2.createTopicWithAssignment$default$6();
            Option x$14 = qual$2.createTopicWithAssignment$default$7();
            qual$2.createTopicWithAssignment("test", topicConfig, x$10, x$11, x$12, x$13, x$14);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            Map x$17 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$18 = qual$3.createTopicWithAssignment$default$4();
            boolean x$19 = qual$3.createTopicWithAssignment$default$5();
            boolean x$20 = qual$3.createTopicWithAssignment$default$6();
            Option x$21 = qual$3.createTopicWithAssignment$default$7();
            qual$3.createTopicWithAssignment("test", topicConfig, x$17, x$18, x$19, x$20, x$21);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$4 = this.adminZkClient();
            Map x$24 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$25 = qual$4.createTopicWithAssignment$default$4();
            boolean x$26 = qual$4.createTopicWithAssignment$default$5();
            boolean x$27 = qual$4.createTopicWithAssignment$default$6();
            Option x$28 = qual$4.createTopicWithAssignment$default$7();
            qual$4.createTopicWithAssignment("test", topicConfig, x$24, x$25, x$26, x$27, x$28);
        });
        Assertions.assertThrows(InvalidReplicaAssignmentException.class, () -> {
            AdminZkClient qual$5 = this.adminZkClient();
            Map x$31 = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)-1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)Seq$.MODULE$.empty()))}));
            boolean x$32 = qual$5.createTopicWithAssignment$default$4();
            boolean x$33 = qual$5.createTopicWithAssignment$default$5();
            boolean x$34 = qual$5.createTopicWithAssignment$default$6();
            Option x$35 = qual$5.createTopicWithAssignment$default$7();
            qual$5.createTopicWithAssignment("test", topicConfig, x$31, x$32, x$33, x$34, x$35);
        });
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty()))}));
        AdminZkClient qual$6 = this.adminZkClient();
        boolean x$39 = qual$6.createTopicWithAssignment$default$4();
        boolean x$40 = qual$6.createTopicWithAssignment$default$5();
        boolean x$41 = qual$6.createTopicWithAssignment$default$6();
        Option x$42 = qual$6.createTopicWithAssignment$default$7();
        qual$6.createTopicWithAssignment("test", topicConfig, assignment, x$39, x$40, x$41, x$42);
        Map found = this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"})));
        Assertions.assertEquals((Object)assignment, (Object)found.apply((Object)"test"));
    }

    @Test
    public void testTopicCreationInZK() {
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty()))}));
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)10)), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)11)), (Object)BoxesRunTime.boxToInteger((int)1))}));
        String topic = "test";
        Properties topicConfig = new Properties();
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        AdminZkClient qual$1 = this.adminZkClient();
        boolean x$4 = qual$1.createTopicWithAssignment$default$4();
        boolean x$5 = qual$1.createTopicWithAssignment$default$5();
        boolean x$6 = qual$1.createTopicWithAssignment$default$6();
        Option x$7 = qual$1.createTopicWithAssignment$default$7();
        qual$1.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$4, x$5, x$6, x$7);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        Map actualReplicaMap = (Map)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).apply((Object)topic);
        Assertions.assertEquals((int)expectedReplicaAssignment.size(), (int)actualReplicaMap.size());
        actualReplicaMap.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$1 -> {
            AdminZkClientTest.$anonfun$testTopicCreationInZK$2(expectedReplicaAssignment, x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertThrows(TopicExistsException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            boolean x$11 = qual$2.createTopicWithAssignment$default$4();
            boolean x$12 = qual$2.createTopicWithAssignment$default$5();
            boolean x$13 = qual$2.createTopicWithAssignment$default$6();
            Option x$14 = qual$2.createTopicWithAssignment$default$7();
            qual$2.createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment, x$11, x$12, x$13, x$14);
        });
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, 3, 1, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertThrows(InvalidTopicException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Properties x$12 = qual$2.createTopic$default$4();
            RackAwareMode x$13 = qual$2.createTopic$default$5();
            boolean x$14 = qual$2.createTopic$default$6();
            boolean x$15 = qual$2.createTopic$default$7();
            Option x$16 = qual$2.createTopic$default$8();
            qual$2.createTopic(collidingTopic, 3, 1, x$12, x$13, x$14, x$15, x$16);
        });
    }

    @Test
    public void testMarkedDeletionTopicCreation() {
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        String topic = new TopicPartition("test", 0).topic();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.isTopicMarkedForDeletion(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testMockedConcurrentTopicCreation() {
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)zkMock.topicExists(topic))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)zkMock.getAllTopicsInCluster(false)).thenReturn(Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"})));
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions.assertThrows(TopicExistsException.class, () -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)new .colon.colon((JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (List)Nil$.MODULE$)), (int)15000L);
    }

    @Test
    public void testTopicIdUpgrade() {
        String topic = "topic";
        String topicLegacy = "topicWithLegacyId";
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic, topicLegacy}));
        Seq brokerMetadata = (Seq)TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option)None$.MODULE$));
        this.zkClient().createControllerEpochRaw(1);
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$42 = qual$1.createTopic$default$4();
        RackAwareMode x$52 = qual$1.createTopic$default$5();
        boolean x$62 = qual$1.createTopic$default$6();
        boolean x$72 = qual$1.createTopic$default$7();
        Option x$82 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, 3, 1, x$42, x$52, x$62, x$72, x$82);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$12 = qual$2.createTopic$default$4();
        RackAwareMode x$13 = qual$2.createTopic$default$5();
        boolean x$14 = qual$2.createTopic$default$6();
        boolean x$15 = qual$2.createTopic$default$7();
        Option x$16 = qual$2.createTopic$default$8();
        qual$2.createTopic(topicLegacy, 3, 1, x$12, x$13, x$14, x$15, x$16);
        scala.collection.immutable.Set replicaAssignments = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacy = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignments.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$2(topicLegacy, x$2)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOther = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignments.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$3(topic, x$3)))).head();
        Map legacyTopicIds = this.zkClient().getLegacyTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacy.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacy.topicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOther.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOther.topicId().isEmpty());
        Assertions.assertTrue((boolean)legacyTopicIds.get((Object)topicLegacy).isEmpty());
        Assertions.assertTrue((boolean)legacyTopicIds.get((Object)topic).isEmpty());
        this.zkClient().setTopicIds((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicZNode.TopicIdReplicaAssignment[]{replicaAssignmentWithLegacy})), 0, true);
        scala.collection.immutable.Set replicaAssignmentsSetId = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacySetId = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsSetId.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$4(topicLegacy, x$4)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherSetId = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsSetId.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$5(topic, x$5)))).head();
        Map legacyTopicIdsSetId = this.zkClient().getLegacyTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacySetId.legacyTopicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacySetId.topicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherSetId.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherSetId.topicId().isEmpty());
        Assertions.assertTrue((boolean)legacyTopicIdsSetId.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)legacyTopicIdsSetId.get((Object)topic).isEmpty());
        AdminZkClient qual$3 = this.adminZkClient();
        Map x$18 = (Map)replicaAssignmentWithLegacySetId.assignment().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp.partition()), (Object)assignment);
            return tuple2;
        });
        Option x$21 = qual$3.addPartitions$default$5();
        boolean x$22 = qual$3.addPartitions$default$6();
        Option x$23 = qual$3.addPartitions$default$7();
        Option x$24 = qual$3.addPartitions$default$8();
        qual$3.addPartitions(topicLegacy, x$18, brokerMetadata, 4, x$21, x$22, x$23, x$24);
        AdminZkClient qual$4 = this.adminZkClient();
        Map x$26 = (Map)replicaAssignmentOtherSetId.assignment().map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp.partition()), (Object)assignment);
            return tuple2;
        });
        Option x$29 = qual$4.addPartitions$default$5();
        boolean x$30 = qual$4.addPartitions$default$6();
        Option x$31 = qual$4.addPartitions$default$7();
        Option x$32 = qual$4.addPartitions$default$8();
        qual$4.addPartitions(topic, x$26, brokerMetadata, 4, x$29, x$30, x$31, x$32);
        scala.collection.immutable.Set replicaAssignmentsNewPart = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacyNewPart = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsNewPart.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$8(topicLegacy, x$6)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherNewPart = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsNewPart.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$9(topic, x$7)))).head();
        Map legacyTopicIdsNewPart = this.zkClient().getLegacyTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyNewPart.legacyTopicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyNewPart.topicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherNewPart.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherNewPart.topicId().isEmpty());
        Assertions.assertTrue((boolean)legacyTopicIdsNewPart.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)legacyTopicIdsNewPart.get((Object)topic).isEmpty());
        this.zkClient().setTopicIds((Set)replicaAssignmentsNewPart, 0, false);
        scala.collection.immutable.Set replicaAssignmentsUpgrade = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacyUpgrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgrade.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$10(topicLegacy, x$8)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherUpgrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgrade.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$11(topic, x$9)))).head();
        Map topicIdsUpgrade = this.zkClient().getTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgrade.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgrade.topicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgrade.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgrade.topicId().isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgrade.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgrade.get((Object)topic).isDefined());
        AdminZkClient qual$5 = this.adminZkClient();
        Map x$34 = (Map)replicaAssignmentWithLegacyUpgrade.assignment().map((Function1 & Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp.partition()), (Object)assignment);
            return tuple2;
        });
        Option x$37 = qual$5.addPartitions$default$5();
        boolean x$38 = qual$5.addPartitions$default$6();
        Option x$39 = qual$5.addPartitions$default$7();
        Option x$40 = qual$5.addPartitions$default$8();
        qual$5.addPartitions(topicLegacy, x$34, brokerMetadata, 5, x$37, x$38, x$39, x$40);
        AdminZkClient qual$6 = this.adminZkClient();
        Map x$422 = (Map)replicaAssignmentOtherUpgrade.assignment().map((Function1 & Serializable)x0$4 -> {
            if (x0$4 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$4._1();
            ReplicaAssignment assignment = (ReplicaAssignment)x0$4._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp.partition()), (Object)assignment);
            return tuple2;
        });
        Option x$45 = qual$6.addPartitions$default$5();
        boolean x$46 = qual$6.addPartitions$default$6();
        Option x$47 = qual$6.addPartitions$default$7();
        Option x$48 = qual$6.addPartitions$default$8();
        qual$6.addPartitions(topic, x$422, brokerMetadata, 5, x$45, x$46, x$47, x$48);
        scala.collection.immutable.Set replicaAssignmentsUpgradeNewPart = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacyUpgradeNewPart = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgradeNewPart.filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$14(topicLegacy, x$10)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherUpgradeNewPart = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgradeNewPart.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdUpgrade$15(topic, x$11)))).head();
        Map topicIdsUpgradeNewPart = this.zkClient().getTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgradeNewPart.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgradeNewPart.topicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgradeNewPart.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgradeNewPart.topicId().isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgradeNewPart.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgradeNewPart.get((Object)topic).isDefined());
    }

    @Test
    public void testTopicIdDowngrade() {
        String topic = "topic";
        String topicLegacy = "topicWithLegacyId";
        scala.collection.immutable.Set topics = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic, topicLegacy}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4})))).map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), (Option)None$.MODULE$));
        this.zkClient().createControllerEpochRaw(1);
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, 3, 1, x$4, x$5, x$6, x$7, x$8);
        AdminZkClient qual$2 = this.adminZkClient();
        Properties x$122 = qual$2.createTopic$default$4();
        RackAwareMode x$132 = qual$2.createTopic$default$5();
        boolean x$142 = qual$2.createTopic$default$6();
        boolean x$152 = qual$2.createTopic$default$7();
        Option x$162 = qual$2.createTopic$default$8();
        qual$2.createTopic(topicLegacy, 3, 1, x$122, x$132, x$142, x$152, x$162);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacy = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics).filter((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$2(topicLegacy, x$12)))).head();
        this.zkClient().setTopicIds((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicZNode.TopicIdReplicaAssignment[]{replicaAssignmentWithLegacy})), 0, true);
        scala.collection.immutable.Set replicaAssignmentsSetId = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacySetId = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsSetId.filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$3(topicLegacy, x$13)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherSetId = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsSetId.filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$4(topic, x$14)))).head();
        Map legacyTopicIdsSetId = this.zkClient().getLegacyTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacySetId.legacyTopicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacySetId.topicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherSetId.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherSetId.topicId().isEmpty());
        Assertions.assertTrue((boolean)legacyTopicIdsSetId.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)legacyTopicIdsSetId.get((Object)topic).isEmpty());
        this.zkClient().setTopicIds((Set)replicaAssignmentsSetId, 0, false);
        scala.collection.immutable.Set replicaAssignmentsUpgrade = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacyUpgrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgrade.filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$5(topicLegacy, x$15)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherUpgrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsUpgrade.filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$6(topic, x$16)))).head();
        Map topicIdsUpgrade = this.zkClient().getTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgrade.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyUpgrade.topicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgrade.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherUpgrade.topicId().isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgrade.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)topicIdsUpgrade.get((Object)topic).isDefined());
        Assertions.assertEquals((Object)legacyTopicIdsSetId.get((Object)topicLegacy), (Object)topicIdsUpgrade.get((Object)topicLegacy));
        this.zkClient().setTopicIds((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicZNode.TopicIdReplicaAssignment[]{replicaAssignmentWithLegacyUpgrade})), 0, true);
        scala.collection.immutable.Set replicaAssignmentsDowngrade = this.zkClient().getReplicaAssignmentAndTopicIdForTopics(topics);
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentWithLegacyDowngrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsDowngrade.filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$7(topicLegacy, x$17)))).head();
        TopicZNode.TopicIdReplicaAssignment replicaAssignmentOtherDowngrade = (TopicZNode.TopicIdReplicaAssignment)((IterableOps)replicaAssignmentsDowngrade.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClientTest.$anonfun$testTopicIdDowngrade$8(topic, x$18)))).head();
        Map legacyTopicIdsDowngrade = this.zkClient().getLegacyTopicIdsForTopics(topics);
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyDowngrade.legacyTopicId().isDefined());
        Assertions.assertTrue((boolean)replicaAssignmentWithLegacyDowngrade.topicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherDowngrade.legacyTopicId().isEmpty());
        Assertions.assertTrue((boolean)replicaAssignmentOtherDowngrade.topicId().isDefined());
        Assertions.assertTrue((boolean)legacyTopicIdsDowngrade.get((Object)topicLegacy).isDefined());
        Assertions.assertTrue((boolean)legacyTopicIdsDowngrade.get((Object)topic).isEmpty());
        Assertions.assertEquals((Object)legacyTopicIdsSetId.get((Object)topicLegacy), (Object)legacyTopicIdsDowngrade.get((Object)topicLegacy));
    }

    @Test
    public void testTopicExists() {
        String topic = "testTopic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        Assertions.assertFalse((boolean)this.adminZkClient().topicExists(topic));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, 3, 3, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertTrue((boolean)this.adminZkClient().topicExists(topic));
    }

    @Test
    public void testNumPartitions() {
        String topic = "testTopic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        Assertions.assertFalse((boolean)this.adminZkClient().topicExists(topic));
        Assertions.assertEquals((Object)this.adminZkClient().numPartitions(topic), (Object)None$.MODULE$);
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, 5, 3, x$4, x$5, x$6, x$7, x$8);
        Assertions.assertTrue((boolean)this.adminZkClient().topicExists(topic));
        Assertions.assertEquals((int)BoxesRunTime.unboxToInt((Object)this.adminZkClient().numPartitions(topic).get()), (int)5);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        KafkaServer kafkaServer;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        int partitions = 3;
        String topic = "my-topic";
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        Object var17_7 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var14_6 = null;
        kafkaConfig = null;
        time3 = null;
        kafkaServer = null;
        KafkaServer server = kafkaServer4;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topic, partitions, 1, x$4, x$5, x$6, x$7, x$8);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assertions.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void testAddPartitionWithNoPlacementConstraintNoAssignment() {
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 3, props, x$5, x$6, x$7, x$8);
        AdminZkClient qual$2 = this.adminZkClient();
        None$ x$13 = None$.MODULE$;
        boolean x$14 = qual$2.addPartitions$default$6();
        Option x$15 = qual$2.addPartitions$default$7();
        Option x$16 = qual$2.addPartitions$default$8();
        Map partitionAssignment = qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)x$13, x$14, x$15, x$16);
        Assertions.assertEquals((int)3, (int)partitionAssignment.size());
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$19 -> x$19.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            AdminZkClientTest.$anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$3(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$20 -> x$20.observers())).foreach((Function1 & Serializable)observers -> {
            AdminZkClientTest.$anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$5(observers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddPartitionWithNoPlacementConstraintWithAssignment() {
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithNoPlacementConstraintWithAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 3, props, x$5, x$6, x$7, x$8);
        Map newReplicaAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1})), (Seq)Seq$.MODULE$.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)9)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2})), (Seq)Seq$.MODULE$.empty()))}));
        AdminZkClient qual$2 = this.adminZkClient();
        Some x$13 = new Some((Object)newReplicaAssignment);
        boolean x$14 = qual$2.addPartitions$default$6();
        Option x$15 = qual$2.addPartitions$default$7();
        Option x$16 = qual$2.addPartitions$default$8();
        Map partitionAssignment = qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 10, (Option)x$13, x$14, x$15, x$16);
        Assertions.assertEquals((Object)existingAssignment.$plus$plus((IterableOnce)newReplicaAssignment), (Object)partitionAssignment);
    }

    @Test
    public void testAddPartitionWithPlacementConstraintNoPartitionAssignment() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}"));
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}))))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 4, props, x$5, x$6, x$7, x$8);
        AdminZkClient qual$2 = this.adminZkClient();
        None$ x$13 = None$.MODULE$;
        Option x$16 = qual$2.addPartitions$default$8();
        Map partitionAssignment = qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)x$13, false, topicPlacement, x$16);
        Assertions.assertEquals((int)3, (int)partitionAssignment.size());
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$21 -> x$21.replicas())).foreach((Function1 & Serializable)assignedBrokers -> {
            AdminZkClientTest.$anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$3(assignedBrokers);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)partitionAssignment.values().map((Function1 & Serializable)x$22 -> x$22.observers())).foreach((Function1 & Serializable)observers -> {
            AdminZkClientTest.$anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$7(observers);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAddPartitionWithPlacementConstraintWithPartitionAssignment() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 2,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}"));
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 5, 6})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6}))))}));
        Map newAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 7, 8})), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}))))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithPlacementConstraintWithPartitionAssignment$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 4, props, x$5, x$6, x$7, x$8);
        AdminZkClient qual$2 = this.adminZkClient();
        Some x$13 = new Some((Object)newAssignment);
        Option x$16 = qual$2.addPartitions$default$8();
        Map partitionAssignment = qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 2, (Option)x$13, false, topicPlacement, x$16);
        Assertions.assertEquals((Object)existingAssignment.$plus$plus((IterableOnce)newAssignment), (Object)partitionAssignment);
    }

    @Test
    public void testAddPartitionWithReplicaPlacementConstraintNotSatisfied() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 6,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 2,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}"));
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7), (Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7}))))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithReplicaPlacementConstraintNotSatisfied$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 4, props, x$5, x$6, x$7, x$8);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            None$ x$13 = None$.MODULE$;
            Option x$16 = qual$2.addPartitions$default$8();
            qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)x$13, false, topicPlacement, x$16);
        });
    }

    @Test
    public void testAddPartitionWithObserverPlacementConstraintNotSatisfied() {
        String placementJson = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n                          | \"version\": 1,\n                          |  \"replicas\": [{\n                          |      \"count\": 3,\n                          |      \"constraints\": {\n                          |        \"rack\": \"rack-1\"\n                          |      }\n                          |    }\n                          |  ],\n                          |  \"observers\": [{\n                          |    \"count\": 6,\n                          |    \"constraints\": {\n                          |      \"rack\": \"rack-2\"\n                          |    }\n                          |  }]\n                          |}"));
        Option topicPlacement = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.parse((String)placementJson)));
        Map existingAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)ReplicaAssignment$.MODULE$.apply((Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 10), (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(4), 10)))}));
        IndexedSeq brokers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)id -> AdminZkClientTest.$anonfun$testAddPartitionWithObserverPlacementConstraintNotSatisfied$1(BoxesRunTime.unboxToInt((Object)id)));
        String topicName = "test-topic";
        TestUtils$.MODULE$.createBrokersInZk((Seq<BrokerMetadata>)brokers, this.zkClient());
        Properties props = new Properties();
        props.setProperty("confluent.placement.constraints", placementJson);
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        boolean x$6 = qual$1.createTopic$default$6();
        boolean x$7 = qual$1.createTopic$default$7();
        Option x$8 = qual$1.createTopic$default$8();
        qual$1.createTopic(topicName, 1, 4, props, x$5, x$6, x$7, x$8);
        Assertions.assertThrows(InvalidConfigurationException.class, () -> {
            AdminZkClient qual$2 = this.adminZkClient();
            None$ x$13 = None$.MODULE$;
            Option x$16 = qual$2.addPartitions$default$8();
            qual$2.addPartitions(topicName, existingAssignment, (Seq)brokers, 3, (Option)x$13, false, topicPlacement, x$16);
        });
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        int staticLeaderLimit = 555;
        int staticFollowerLimit = 444;
        TopicPartition sampleTp = new TopicPartition("t", 0);
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1, 0).map((Function1 & Serializable)properties -> {
            properties.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Integer.toString(staticLeaderLimit));
            properties.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue());
            properties.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Integer.toString(staticFollowerLimit));
            return properties;
        })).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).map((Function1 & Serializable)x$23 -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            return createServer_this.createServer((KafkaConfig)x$23, createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        })));
        this.checkConfig$2(staticLeaderLimit, staticFollowerLimit, true, false, sampleTp);
        long leaderLimit = 1000000L;
        long followerLimit = 1000001L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(leaderLimit)), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue()), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(followerLimit))})));
        this.checkConfig$2(leaderLimit, followerLimit, true, false, sampleTp);
        long newLeaderLimit = leaderLimit * 2L;
        long newFollowerLimit = followerLimit * 2L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(newLeaderLimit)), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue()), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(newFollowerLimit)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue())})));
        this.checkConfig$2(newLeaderLimit, newFollowerLimit, true, true, sampleTp);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(brokerId));
            Assertions.assertEquals((long)newLeaderLimit, (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configInZk.getProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp()))));
            Assertions.assertEquals((long)newFollowerLimit, (long)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(configInZk.getProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp()))));
            Assertions.assertEquals((Object)ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue(), (Object)configInZk.getProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
            Assertions.assertEquals((Object)ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue(), (Object)configInZk.getProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp()));
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(staticLeaderLimit, staticFollowerLimit, true, false, sampleTp);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBootstrapClientIdConfig() {
        KafkaServer kafkaServer;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer2;
        Time time;
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assertions.assertEquals((int)1, (int)configInZk.size(), (String)"Must have 1 overridden client config");
        Assertions.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        Time time2 = time = Time.SYSTEM;
        time = null;
        Time time3 = time2;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
        KafkaServer kafkaServer3 = kafkaServer2 = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, 1, true);
        Object var8_8 = null;
        kafkaServer2 = null;
        KafkaServer kafkaServer4 = kafkaServer = kafkaServer3;
        Object var5_7 = null;
        kafkaConfig = null;
        time3 = null;
        kafkaServer = null;
        KafkaServer server = kafkaServer4;
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assertions.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    @Test
    public void testGetBrokerMetadatas() {
        Range.Inclusive brokerList = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 5);
        Map rackInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)brokerList.filterNot((Function1)rackInfo.keySet())));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$2);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToInteger((int)x$24.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(brokerList.size(), (Function0 & Serializable)() -> None$.MODULE$), (Object)processedMetadatas1.map((Function1 & Serializable)x$25 -> x$25.rack()));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$3 = RackAwareMode.Safe$.MODULE$;
        Option x$4 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$3, x$4);
        Assertions.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)x$26.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().fill(brokerList.size(), (Function0 & Serializable)() -> None$.MODULE$), (Object)processedMetadatas2.map((Function1 & Serializable)x$27 -> x$27.rack()));
        Assertions.assertThrows(AdminOperationException.class, () -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        });
        List partialList = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assertions.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToInteger((int)x$28.id())));
        Assertions.assertEquals((Object)partialList.map((Function1)rackInfo), (Object)processedMetadatas3.flatMap((Function1 & Serializable)x$29 -> x$29.rack()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        boolean x$12 = qual$4.createTopic$default$6();
        boolean x$13 = qual$4.createTopic$default$7();
        Option x$14 = qual$4.createTopic$default$8();
        qual$4.createTopic("foo", numPartitions, 2, x$11, (RackAwareMode)x$10, x$12, x$13, x$14);
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})));
        Assertions.assertEquals((int)numPartitions, (int)assignment.size());
    }

    public static final /* synthetic */ void $anonfun$testTopicCreationInZK$2(Map expectedReplicaAssignment$1, Tuple2 x$1) {
        if (x$1 != null) {
            int key = x$1._1$mcI$sp();
            ReplicaAssignment value = (ReplicaAssignment)x$1._2();
            Assertions.assertEquals((Object)expectedReplicaAssignment$1.apply((Object)BoxesRunTime.boxToInteger((int)key)), (Object)value);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Assertions.assertEquals((int)1, (int)partitionReplicaAssignment.replicas().size(), (String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$4, Properties props$1) {
        void var9_9;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            boolean x$6 = qual$1.createTopic$default$6();
            boolean x$7 = qual$1.createTopic$default$7();
            Option x$8 = qual$1.createTopic$default$8();
            qual$1.createTopic(topic$4, 3, 1, props$1, x$5, x$6, x$7, x$8);
        }
        catch (TopicExistsException topicExistsException) {}
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$4}))).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assertions.assertEquals((int)3, (int)var9_9.size());
        var9_9.foreach((Function1 & Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$4);
        Assertions.assertEquals((Object)props$1, (Object)savedProps);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$2(String topicLegacy$1, TopicZNode.TopicIdReplicaAssignment x$2) {
        return x$2.topic().equals(topicLegacy$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$3(String topic$5, TopicZNode.TopicIdReplicaAssignment x$3) {
        return x$3.topic().equals(topic$5);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$4(String topicLegacy$1, TopicZNode.TopicIdReplicaAssignment x$4) {
        return x$4.topic().equals(topicLegacy$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$5(String topic$5, TopicZNode.TopicIdReplicaAssignment x$5) {
        return x$5.topic().equals(topic$5);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$8(String topicLegacy$1, TopicZNode.TopicIdReplicaAssignment x$6) {
        return x$6.topic().equals(topicLegacy$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$9(String topic$5, TopicZNode.TopicIdReplicaAssignment x$7) {
        return x$7.topic().equals(topic$5);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$10(String topicLegacy$1, TopicZNode.TopicIdReplicaAssignment x$8) {
        return x$8.topic().equals(topicLegacy$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$11(String topic$5, TopicZNode.TopicIdReplicaAssignment x$9) {
        return x$9.topic().equals(topic$5);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$14(String topicLegacy$1, TopicZNode.TopicIdReplicaAssignment x$10) {
        return x$10.topic().equals(topicLegacy$1);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdUpgrade$15(String topic$5, TopicZNode.TopicIdReplicaAssignment x$11) {
        return x$11.topic().equals(topic$5);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$2(String topicLegacy$2, TopicZNode.TopicIdReplicaAssignment x$12) {
        return x$12.topic().equals(topicLegacy$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$3(String topicLegacy$2, TopicZNode.TopicIdReplicaAssignment x$13) {
        return x$13.topic().equals(topicLegacy$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$4(String topic$6, TopicZNode.TopicIdReplicaAssignment x$14) {
        return x$14.topic().equals(topic$6);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$5(String topicLegacy$2, TopicZNode.TopicIdReplicaAssignment x$15) {
        return x$15.topic().equals(topicLegacy$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$6(String topic$6, TopicZNode.TopicIdReplicaAssignment x$16) {
        return x$16.topic().equals(topic$6);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$7(String topicLegacy$2, TopicZNode.TopicIdReplicaAssignment x$17) {
        return x$17.topic().equals(topicLegacy$2);
    }

    public static final /* synthetic */ boolean $anonfun$testTopicIdDowngrade$8(String topic$6, TopicZNode.TopicIdReplicaAssignment x$18) {
        return x$18.topic().equals(topic$6);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), Integer.toString(messageSize));
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), Long.toString(retentionMs));
        props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assertions.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assertions.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assertions.assertEquals((Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])expected.split(","))), (Object)CollectionConverters$.MODULE$.ListHasAsScala(actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$7, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), partitions$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)part -> {
            TopicPartition tp = new TopicPartition(topic$7, part);
            LogManager qual$1 = server$1.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Option log = qual$1.getLog(tp, x$2);
            Assertions.assertTrue((boolean)log.isDefined());
            Assertions.assertEquals((long)retentionMs$1, (Long)((AbstractLog)log.get()).config().retentionMs());
            Assertions.assertEquals((int)messageSize$1, (Integer)((AbstractLog)log.get()).config().maxMessageSize());
            AdminZkClientTest.checkList$1(((AbstractLog)log.get()).config().LeaderReplicationThrottledReplicas(), throttledLeaders$1);
            AdminZkClientTest.checkList$1(((AbstractLog)log.get()).config().FollowerReplicationThrottledReplicas(), throttledFollowers$1);
            Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)quotaManagerIsThrottled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server$1.quotaManagers().leader().isThrottled(tp)));
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$7, KafkaServer server$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$7, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$3(Seq assignedBrokers) {
        Assertions.assertEquals((int)3, (int)assignedBrokers.toSet().size());
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionWithNoPlacementConstraintNoAssignment$5(Seq observers) {
        Assertions.assertTrue((boolean)observers.isEmpty(), (String)observers.mkString(","));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithNoPlacementConstraintWithAssignment$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$3(Seq assignedBrokers) {
        Assertions.assertEquals((int)4, (int)assignedBrokers.toSet().size());
        ((IterableOnceOps)assignedBrokers.take(2)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 0 && brokerId <= 4 ? 1 : 0) != 0));
        ((IterableOnceOps)assignedBrokers.slice(2, 4)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Assertions.assertTrue((brokerId >= 5 && brokerId <= 9 ? 1 : 0) != 0));
    }

    public static final /* synthetic */ void $anonfun$testAddPartitionWithPlacementConstraintNoPartitionAssignment$7(Seq observers) {
        Assertions.assertTrue((boolean)observers.forall((Function1)(JFunction1.mcZI.sp & Serializable)observerId -> observerId >= 5 && observerId <= 9), (String)observers.mkString(","));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithPlacementConstraintWithPartitionAssignment$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithReplicaPlacementConstraintNotSatisfied$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$testAddPartitionWithObserverPlacementConstraintNotSatisfied$1(int id) {
        String rack = new StringBuilder(5).append("rack-").append(id / 5 + 1).toString();
        return new BrokerMetadata(id, (Option)new Some((Object)rack));
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$5(long leaderLimit$1, boolean leaderThrottleEnabled$1, TopicPartition sampleTp$1, long followerLimit$1, boolean followerThrottleEnabled$1, KafkaServer server) {
        Assertions.assertEquals((long)leaderLimit$1, (long)server.quotaManagers().leader().upperBound(), (String)"Leader Quota Manager was not updated with throttled rate");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)leaderThrottleEnabled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server.quotaManagers().leader().isThrottled(sampleTp$1)), (String)"Leader Quota Manager was not updated with throttled replicas");
        Assertions.assertEquals((long)followerLimit$1, (long)server.quotaManagers().follower().upperBound(), (String)"Follower Quota Manager was not updated with throttled rate");
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)followerThrottleEnabled$1), (Object)BoxesRunTime.boxToBoolean((boolean)server.quotaManagers().follower().isThrottled(sampleTp$1)), (String)"Follower Quota Manager was not updated with throttled replicas");
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(AdminZkClientTest $this, long leaderLimit$1, boolean leaderThrottleEnabled$1, TopicPartition sampleTp$1, long followerLimit$1, boolean followerThrottleEnabled$1) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$5(leaderLimit$1, leaderThrottleEnabled$1, sampleTp$1, followerLimit$1, followerThrottleEnabled$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long leaderLimit, long followerLimit, boolean leaderThrottleEnabled, boolean followerThrottleEnabled, TopicPartition sampleTp$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(this, leaderLimit, leaderThrottleEnabled, sampleTp$1, followerLimit, followerThrottleEnabled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var14_11 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += scala.math.package$.MODULE$.min(l2, 1000L);
                continue;
            }
            break;
        }
    }
}

