/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import kafka.admin.TopicCommand;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001B\t\u0013\u0001]AQA\b\u0001\u0005\u0002}AqA\t\u0001C\u0002\u0013%1\u0005\u0003\u0004-\u0001\u0001\u0006I\u0001\n\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0011\u0019)\u0005\u0001)A\u0005_!)a\t\u0001C\u0005\u000f\")\u0001\u000e\u0001C\u0005S\")Q\u000f\u0001C\u0001m\"1\u00111\u0002\u0001\u0005\u0002YDa!a\u0004\u0001\t\u00031\bBBA\n\u0001\u0011\u0005a\u000f\u0003\u0004\u0002\u0018\u0001!\tA\u001e\u0005\u0007\u00037\u0001A\u0011\u0001<\t\r\u0005}\u0001\u0001\"\u0001w\u0011\u0019\t\u0019\u0003\u0001C\u0001m\"1\u0011q\u0005\u0001\u0005\u0002Y\u0014Qe\u00142tKJ4XM]!xCJ,\u0007+\u0019:uSRLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:$Vm\u001d;\u000b\u0005M!\u0012!B1e[&t'\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0012!\u0002;pa&\u001cW#\u0001\u0013\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013\u0001\u00027b]\u001eT\u0011!K\u0001\u0005U\u00064\u0018-\u0003\u0002,M\t11\u000b\u001e:j]\u001e\fa\u0001^8qS\u000e\u0004\u0013!\u00028pI\u0016\u001cX#A\u0018\u0011\tA*tGO\u0007\u0002c)\u0011!gM\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u000e\u000e\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u00027c\t\u0019Q*\u00199\u0011\u0005eA\u0014BA\u001d\u001b\u0005\rIe\u000e\u001e\t\u0003w\rk\u0011\u0001\u0010\u0006\u0003{y\naaY8n[>t'BA\u000b@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011c$\u0001\u0002(pI\u0016\faA\\8eKN\u0004\u0013!\u00049beRLG/[8o\u0013:4w\u000e\u0006\u0003I\u0017Bk\u0006CA\u001eJ\u0013\tQEH\u0001\nU_BL7\rU1si&$\u0018n\u001c8J]\u001a|\u0007\"\u0002'\u0007\u0001\u0004i\u0015A\u00027fC\u0012,'\u000fE\u0002\u001a\u001d^J!a\u0014\u000e\u0003\r=\u0003H/[8o\u0011\u0015\tf\u00011\u0001S\u0003\rI7O\u001d\t\u0004'j;dB\u0001+Y!\t)&$D\u0001W\u0015\t9f#\u0001\u0004=e>|GOP\u0005\u00033j\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\r\u0019V\r\u001e\u0006\u00033jAQA\u0018\u0004A\u0002}\u000b\u0011b\u001c2tKJ4XM]:\u0011\u0007\u0001,wG\u0004\u0002bG:\u0011QKY\u0005\u00027%\u0011AMG\u0001\ba\u0006\u001c7.Y4f\u0013\t1wM\u0001\u0003MSN$(B\u00013\u001b\u0003M\u0019wN\u001c4jO^KG\u000f\u001b)mC\u000e,W.\u001a8u)\tQ\u0017\u000f\u0005\u0002l_6\tAN\u0003\u0002\u0014[*\u0011aNP\u0001\bG2LWM\u001c;t\u0013\t\u0001HN\u0001\u0004D_:4\u0017n\u001a\u0005\u0006e\u001e\u0001\ra]\u0001\na2\f7-Z7f]R\u0004\"a\u0015;\n\u0005-b\u0016!\r;fgRtun\u00142tKJ4XM]:JMBc\u0017mY3nK:$8i\u001c8tiJ\f\u0017N\u001c;O_R\u001cuN\u001c4jOV\u0014X\r\u001a\u000b\u0002oB\u0011\u0011\u0004_\u0005\u0003sj\u0011A!\u00168ji\"\u0012\u0001b\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018aA1qS*!\u0011\u0011AA\u0002\u0003\u001dQW\u000f]5uKJT1!!\u0002B\u0003\u0015QWO\\5u\u0013\r\tI! \u0002\u0005)\u0016\u001cH/\u0001\u0016uKN$hj\\(cg\u0016\u0014h/\u001a:t\u0013\u001a\u0004F.Y2f[\u0016tGoQ8ogR\u0014\u0018-\u001b8u\u0013NtU\u000f\u001c7)\u0005%Y\u0018\u0001\r;fgR|%m]3sm\u0016\u00148oV5uQ>sG.\u001f*fa2L7-Y\"p]N$(/Y5oi\u000e{gNZ5hkJ,G\r\u000b\u0002\u000bw\u00069C/Z:u\u001f\n\u001cXM\u001d<feNl\u0015\r^2iS:<wJY:feZ,'oQ8ogR\u0014\u0018-\u001b8uQ\tY10A\u0016uKN$xJY:feZ,'o]\"b]>sG._'bi\u000eDwJY:feZ,'oQ8ogR\u0014\u0018-\u001b8uQ\ta10\u0001\u0010uKN$\u0018j\u001d:SKBd\u0017nY1t\u0003J,gj\u001c;PEN,'O^3sg\"\u0012Qb_\u0001#i\u0016\u001cHo\u00144gY&tWMU3qY&\u001c\u0017m]!sK:{Go\u00142tKJ4XM]:)\u00059Y\u0018\u0001\u0011;fgRL5/\u00168eKJ\u0014V\r\u001d7jG\u0006$X\rZ,iK:\u0014V\r\u001d7jG\u0006\u001cuN\\:ue\u0006Lg\u000e^'bi\u000eD\u0017N\\4Ce>\\WM\u001d(pi&s\u0017j\u001d:)\u0005=Y\u0018a\u000f;fgRtu\u000eT5wK>\u00137/\u001a:wKJ\u001c\u0018JZ\"veJ,g\u000e\u001e'fC\u0012,'/T1uG\",7o\u00142tKJ4XM]\"p]N$(/Y5oi\"\u0012\u0001c\u001f")
public class ObserverAwarePartitionDescriptionTest {
    private final String topic;
    private final Map<Object, Node> nodes = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new Node(0, "localhost", 9092, "r1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Node(1, "localhost", 9093, "r1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Node(2, "localhost", 9094, "r2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new Node(3, "localhost", 9095, "r2"))}));

    private String topic() {
        return this.topic;
    }

    private Map<Object, Node> nodes() {
        return this.nodes;
    }

    private TopicPartitionInfo partitionInfo(Option<Object> leader, scala.collection.immutable.Set<Object> isr, List<Object> observers) {
        return TopicPartitionInfo.ofReplicasAndObservers((int)0, (Node)((Node)leader.map(this.nodes()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.nodes().values().toList()).asJava(), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((MapOps)this.nodes().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ObserverAwarePartitionDescriptionTest.$anonfun$partitionInfo$1(observers, x0$1)))).values().toList()).asJava(), (java.util.List)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((MapOps)this.nodes().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ObserverAwarePartitionDescriptionTest.$anonfun$partitionInfo$2(isr, x0$2)))).values().toList()).asJava());
    }

    private Config configWithPlacement(String placement) {
        return new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("confluent.placement.constraints", placement)}))).asJava());
    }

    @Test
    public void testNoObserversIfPlacementConstraintNotConfigured() {
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)package$.MODULE$.List().empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Some config = new Some((Object)new Config((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().empty()).asJava()));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)config, false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)desc.observerIds());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testNoObserversIfPlacementConstraintIsNull() {
        Config config = this.configWithPlacement(null);
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)package$.MODULE$.List().empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)desc.observerIds());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversWithOnlyReplicaConstraintConfigured() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)package$.MODULE$.List().empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)desc.observerIds());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversMatchingObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        List observers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)observers, (Object)desc.observerIds());
        Assertions.assertFalse((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testObserversCanOnlyMatchObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r3\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)package$.MODULE$.List().empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertTrue((boolean)desc.observerIds().isEmpty());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testIsrReplicasAreNotObservers() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        List observers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)observers, (Object)desc.observerIds());
        Assertions.assertFalse((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testOfflineReplicasAreNotObservers() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
        List observers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)observers, (Object)desc.observerIds());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testIsUnderReplicatedWhenReplicaConstraintMatchingBrokerNotInIsr() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        List observers = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)observers);
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertEquals((Object)observers, (Object)desc.observerIds());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    @Test
    public void testNoLiveObserversIfCurrentLeaderMatchesObserverConstraint() {
        Config config = this.configWithPlacement("{\"version\":1,\"replicas\":[{\"count\": 1, \"constraints\":{\"rack\":\"r1\"}}],\"observers\":[{\"count\": 1, \"constraints\":{\"rack\":\"r2\"}}]}");
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
        TopicPartitionInfo info = this.partitionInfo((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (scala.collection.immutable.Set<Object>)isr, (List<Object>)package$.MODULE$.List().empty());
        scala.collection.immutable.Set liveBrokerIds = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        TopicCommand.PartitionDescription desc = new TopicCommand.PartitionDescription(this.topic(), info, (Option)new Some((Object)config), false, (Option)None$.MODULE$, (Set)liveBrokerIds);
        Assertions.assertTrue((boolean)desc.observerIds().isEmpty());
        Assertions.assertTrue((boolean)desc.isUnderReplicated());
    }

    public static final /* synthetic */ boolean $anonfun$partitionInfo$1(List observers$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int k = x0$1._1$mcI$sp();
        boolean bl = observers$1.contains((Object)BoxesRunTime.boxToInteger((int)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$partitionInfo$2(scala.collection.immutable.Set isr$1, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        int k = x0$2._1$mcI$sp();
        boolean bl = isr$1.contains((Object)BoxesRunTime.boxToInteger((int)k));
        return bl;
    }

    public ObserverAwarePartitionDescriptionTest() {
        this.topic = "foo";
    }
}

