/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.common.AdminCommandFailedException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0005\u0005Ee\u0001\u0002\u0014(\u00011BQa\r\u0001\u0005\u0002QBQa\u000e\u0001\u0005\u0002aBQ!\u0013\u0001\u0005\u0002aBQA\u0014\u0001\u0005\u0002aBQa\u0015\u0001\u0005\u0002aBQ!\u0016\u0001\u0005\u0002aBQa\u0016\u0001\u0005\u0002aBQ!\u0017\u0001\u0005\niCQa\u001a\u0001\u0005\n!DQA\u001b\u0001\u0005\u0002aBQ\u0001\u001c\u0001\u0005\u0002aBQA\u001c\u0001\u0005\u0002aBQ\u0001\u001d\u0001\u0005\u0002aBQA\u001d\u0001\u0005\u0002aBQ\u0001\u001e\u0001\u0005\u0002aBQA\u001e\u0001\u0005\u0002aBQ\u0001\u001f\u0001\u0005\u0002aBQA\u001f\u0001\u0005\u0002aBQ\u0001 \u0001\u0005\u0002aBQA \u0001\u0005\u0002aBa!!\u0001\u0001\t\u0003A\u0004BBA\u0003\u0001\u0011\u0005\u0001\b\u0003\u0004\u0002\n\u0001!\t\u0001\u000f\u0005\u0007\u0003\u001b\u0001A\u0011\u0001\u001d\t\r\u0005E\u0001\u0001\"\u00019\u0011\u0019\t)\u0002\u0001C\u0001q!1\u0011\u0011\u0004\u0001\u0005\u0002aBa!!\b\u0001\t\u0003A\u0004BBA\u0011\u0001\u0011\u0005\u0001\b\u0003\u0004\u0002&\u0001!\t\u0001\u000f\u0005\u0007\u0003S\u0001A\u0011\u0001\u001d\t\u000f\u00055\u0002\u0001\"\u0003\u00020!1\u0011\u0011\n\u0001\u0005\u0002aBq!!\u0014\u0001\t\u0013\ty\u0005\u0003\u0004\u0002r\u0001!\t\u0001\u000f\u0005\b\u0003k\u0002A\u0011AA<\u0011\u0019\t\t\t\u0001C\u0001q\tQ\"+Z1tg&<g\u000eU1si&$\u0018n\u001c8t+:LG\u000fV3ti*\u0011\u0001&K\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002U\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001.!\tq\u0013'D\u00010\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a0\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000e\t\u0003m\u0001i\u0011aJ\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002sA\u0011aFO\u0005\u0003w=\u0012A!\u00168ji\"\u0012!!\u0010\t\u0003}\u001dk\u0011a\u0010\u0006\u0003\u0001\u0006\u000b1!\u00199j\u0015\t\u00115)A\u0004kkBLG/\u001a:\u000b\u0005\u0011+\u0015!\u00026v]&$(\"\u0001$\u0002\u0007=\u0014x-\u0003\u0002I\u007f\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#aA&\u0011\u0005yb\u0015BA'@\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000euKN$8i\\7qCJ,Gk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u000b\u0002\u0005!B\u0011a(U\u0005\u0003%~\u0012A\u0001V3ti\u0006\tC/Z:u\u0007>l\u0007/\u0019:f)>\u0004\u0018n\u0019)beRLG/[8o%\u0016\u0004H.[2bg\"\u0012Q\u0001U\u0001$i\u0016\u001cH\u000fU1si&$\u0018n\u001c8SK\u0006\u001c8/[4o'R\fG/Z:U_N#(/\u001b8hQ\t1\u0001+\u0001\u0019uKN$\b+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8Ti\u0006$Xm\u001d+p'R\u0014\u0018N\\4XSRDwJY:feZ,'o\u001d\u0015\u0003\u000fA\u000b\u0011\"\u00193e)>\u0004\u0018nY:\u0015\u0005eZ\u0006\"\u0002/\t\u0001\u0004i\u0016aC1e[&t7\t\\5f]R\u0004\"AX3\u000e\u0003}S!\u0001\u000b1\u000b\u0005\u0005\u0014\u0017aB2mS\u0016tGo\u001d\u0006\u0003U\rT!\u0001Z#\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t1wLA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003Y\tG\r\u001a+pa&\u001c7oV5uQ>\u00137/\u001a:wKJ\u001cHCA\u001dj\u0011\u0015a\u0016\u00021\u0001^\u0003\r\"Xm\u001d;GS:$\u0007+\u0019:uSRLwN\u001c*fCN\u001c\u0018n\u001a8nK:$8\u000b^1uKND#A\u0003)\u00021Q,7\u000f\u001e$j]\u0012dun\u001a#je6{g/Z*uCR,7\u000f\u000b\u0002\f!\u0006iB/Z:u%\u0016\u0004H.[2b\u001b>4Xm\u0015;bi\u0016\u001cHk\\*ue&tw\r\u000b\u0002\r!\u0006IB/Z:u\u000f\u0016$(+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;tQ\ti\u0001+\u0001\u0013uKN$x)\u001a;SKBd\u0017nY1B]\u0012|%m]3sm\u0016\u0014\u0018i]:jO:lWM\u001c;tQ\tq\u0001+\u0001\u000fuKN$x)\u001a;Ce>\\WM\u001d*bG.LeNZ8s[\u0006$\u0018n\u001c8)\u0005=\u0001\u0016a\b;fgR\u0004\u0016M]:f\u000f\u0016tWM]1uK\u0006\u001b8/[4o[\u0016tG/\u0011:hg\"\u0012\u0001\u0003U\u00011i\u0016\u001cHoR3oKJ\fG/Z!tg&<g.\\3oi\u001a\u000b\u0017\u000e\\:XSRDw.\u001e;F]>,x\r\u001b*fa2L7-Y:)\u0005E\u0001\u0016\u0001\r;fgR<UM\\3sCR,\u0017i]:jO:lWM\u001c;XSRD\u0017J\u001c<bY&$\u0007+\u0019:uSRLwN\\:GC&d7\u000f\u000b\u0002\u0013!\u0006YC/Z:u\u000f\u0016tWM]1uK\u0006\u001b8/[4o[\u0016tGoV5uQ&s7m\u001c8tSN$XM\u001c;SC\u000e\\7\u000f\u000b\u0002\u0014!\u00061C/Z:u\u000f\u0016tWM]1uK\u0006\u001b8/[4o[\u0016tGoV5uQ\u001a+w/\u001a:Ce>\\WM]:)\u0005Q\u0001\u0016!\f;fgR\u001cUO\u001d:f]R\u0004\u0016M\u001d;ji&|gNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8u)>\u001cFO]5oO\"\u0012Q\u0003U\u0001;i\u0016\u001cHoQ;se\u0016tG\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R<\u0016\u000e\u001e5PEN,'O^3sgR{7\u000b\u001e:j]\u001eD#A\u0006)\u0002\u0017Q,7\u000f^'pm\u0016l\u0015\r\u001d\u0015\u0003/A\u000ba\u0004^3tiB\u000b'o]3Fq\u0016\u001cW\u000f^3BgNLwM\\7f]R\f%oZ:)\u0005a\u0001\u0016a\u000b;fgR\u0004\u0016M]:f\u000bb,7-\u001e;f\u0003N\u001c\u0018n\u001a8nK:$\u0018I]4t/&$\bn\u00142tKJ4XM]:)\u0005e\u0001\u0016!\n;fgR,\u00050Z2vi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3QCJ$\u0018\u000e^5p]N4\u0015-\u001b7tQ\tQ\u0002+A\u0012uKN$X\t_3dkR,w+\u001b;i\u0013:4\u0018\r\\5e\u0005J|7.\u001a:JI\u001a\u000b\u0017\u000e\\:)\u0005m\u0001\u0016a\t;fgRlu\u000eZ5gs\n\u0013xn[3s\u0013:$XM\u001d\"s_.,'\u000f\u00165s_R$H.\u001a\u0015\u00039A\u000b\u0001\u0004^3ti6{G-\u001b4z\u0019><G)\u001b:UQJ|G\u000f\u001e7fQ\ti\u0002+\u0001\u000fuKN$8)\u001e:SK\u0006\u001c8/[4o[\u0016tGo\u001d+p'R\u0014\u0018N\\4)\u0005y\u0001\u0016!\u000b;fgR\u001cUO\u001d*fCN\u001c\u0018n\u001a8nK:$8\u000fV8TiJLgnZ,ji\"|%m]3sm\u0016\u00148\u000f\u000b\u0002 !\u0006Yb/\u001a:jMf\u0014%o\\6feRC'o\u001c;uY\u0016\u0014Vm];miN$r!OA\u0019\u0003w\t)\u0005C\u0004\u00024\u0001\u0002\r!!\u000e\u0002\r\r|gNZ5h!\rq\u0016qG\u0005\u0004\u0003sy&AB\"p]\u001aLw\rC\u0004\u0002>\u0001\u0002\r!a\u0010\u00027\u0015D\b/Z2uK\u0012Le\u000e^3s\u0005J|7.\u001a:UQJ|G\u000f\u001e7f!\rq\u0013\u0011I\u0005\u0004\u0003\u0007z#\u0001\u0002'p]\u001eDq!a\u0012!\u0001\u0004\ty$A\u0012fqB,7\r^3e%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie>$H\u000f\\3\u00021Q,7\u000f^'pI&4\u0017\u0010V8qS\u000e$\u0006N]8ui2,7\u000f\u000b\u0002\"!\u0006Qb/\u001a:jMf$v\u000e]5d)\"\u0014x\u000e\u001e;mKJ+7/\u001e7ugR9\u0011(!\u0015\u0002T\u00055\u0004bBA\u001aE\u0001\u0007\u0011Q\u0007\u0005\b\u0003+\u0012\u0003\u0019AA,\u0003Y)\u0007\u0010]3di\u0016$G*Z1eKJ$\u0006N]8ui2,\u0007\u0003BA-\u0003OrA!a\u0017\u0002dA\u0019\u0011QL\u0018\u000e\u0005\u0005}#bAA1W\u00051AH]8pizJ1!!\u001a0\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011NA6\u0005\u0019\u0019FO]5oO*\u0019\u0011QM\u0018\t\u000f\u0005=$\u00051\u0001\u0002X\u0005AR\r\u001f9fGR,GMR8mY><XM\u001d+ie>$H\u000f\\3\u0002/Q,7\u000f^!mi\u0016\u0014(+\u001a9mS\u000e\fGj\\4ESJ\u001c\bFA\u0012Q\u0003A\t7o]3siN#\u0018M\u001d;t/&$\b\u000eF\u0003:\u0003s\ni\bC\u0004\u0002|\u0011\u0002\r!a\u0016\u0002\rA\u0014XMZ5y\u0011\u001d\ty\b\na\u0001\u0003/\n1a\u001d;s\u0003u!Xm\u001d;Qe>\u0004\u0018mZ1uK&sg/\u00197jI*\u001bxN\\#se>\u0014\bFA\u0013QQ\u001d\u0001\u0011qQAG\u0003\u001f\u00032APAE\u0013\r\tYi\u0010\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\u0005a\u0004")
public class ReassignPartitionsUnitTest {
    @BeforeEach
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ReassignPartitionsUnitTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testCompareTopicPartitions() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("abc", 0), new TopicPartition("abc", 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitions(new TopicPartition("def", 0), new TopicPartition("abc", 1)));
    }

    @Test
    public void testCompareTopicPartitionReplicas() {
        Assertions.assertTrue((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("abc", 0, 1)));
        Assertions.assertFalse((boolean)ReassignPartitionsCommand$.MODULE$.compareTopicPartitionReplicas(new TopicPartitionReplica("def", 0, 0), new TopicPartitionReplica("cde", 0, 0)));
    }

    @Test
    public void testPartitionReassignStatesToString() {
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Status of partition reassignment:", "Reassignment of partition bar-0 is still in progress.", "Reassignment of partition foo-0 is complete.", "Reassignment of partition foo-1 is still in progress."})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.partitionReassignmentStatesToString((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), false))}))));
    }

    @Test
    public void testPartitionReassignStatesToStringWithObservers() {
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Status of partition reassignment:", "Reassignment of partition bar-0 is still in progress.", "Reassignment of partition foo-0 is complete.", "Reassignment of partition foo-1 is still in progress."})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.partitionReassignmentStatesToString((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4}))), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4}))), false))}))));
    }

    private void addTopics(MockAdminClient adminClient) {
        List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(0), Arrays.asList((Node)b.get(0), (Node)b.get(1), (Node)b.get(2)), Arrays.asList((Node)b.get(0), (Node)b.get(1))), new TopicPartitionInfo(1, (Node)b.get(1), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)))), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Node)b.get(2), (Node)b.get(3), (Node)b.get(0)), Arrays.asList((Node)b.get(2), (Node)b.get(3), (Node)b.get(0)))), Collections.emptyMap());
    }

    private void addTopicsWithObservers(MockAdminClient adminClient) {
        List b = adminClient.brokers();
        adminClient.addTopic(false, "foo", Arrays.asList(TopicPartitionInfo.ofReplicasAndObservers((int)0, (Node)((Node)b.get(0)), Arrays.asList((Node)b.get(0), (Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(0), (Node)b.get(1))), TopicPartitionInfo.ofReplicasAndObservers((int)1, (Node)((Node)b.get(1)), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(3)), Arrays.asList((Node)b.get(1), (Node)b.get(2)))), Collections.emptyMap());
        adminClient.addTopic(false, "bar", Arrays.asList(TopicPartitionInfo.ofReplicasAndObservers((int)0, (Node)((Node)b.get(2)), Arrays.asList((Node)b.get(2), (Node)b.get(3), (Node)b.get(0), (Node)b.get(1)), Arrays.asList((Node)b.get(0), (Node)b.get(1)), Arrays.asList((Node)b.get(2), (Node)b.get(3)))), Collections.emptyMap());
    }

    @Test
    public void testFindPartitionReassignmentStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            scala.collection.immutable.Map reassignmentResult = ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                Throwable v = (Throwable)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 0)), UnknownTopicOrPartitionException.class)})), (Object)reassignmentResult);
            Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicPartition("foo", 0), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), new Tuple2((Object)new TopicPartition("foo", 1), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))));
            scala.collection.immutable.Map cancelResult = ReassignPartitionsCommand$.MODULE$.cancelPartitionReassignments((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("quux", 2)}))).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$2._1();
                Throwable v = (Throwable)x0$2._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("quux", 2)), UnknownTopicOrPartitionException.class)})), (Object)cancelResult);
            Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.PartitionReassignmentState(new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), true))})), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)ReassignPartitionsCommand$.MODULE$.findPartitionReassignmentStates((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicPartition("foo", 0), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), new Tuple2((Object)new TopicPartition("foo", 1), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))));
        }
    }

    @Test
    public void testFindLogDirMoveStates() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Arrays.asList(Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"), Arrays.asList("/tmp/kafka-logs0", null))).build();){
            this.addTopics(adminClient);
            List b = adminClient.brokers();
            adminClient.addTopic(false, "quux", Arrays.asList(new TopicPartitionInfo(0, (Node)b.get(2), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)), Arrays.asList((Node)b.get(1), (Node)b.get(2), (Node)b.get(3)))), Collections.emptyMap());
            adminClient.alterReplicaLogDirs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)"/tmp/kafka-logs1")}))).asJava()).all().get();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs0"))})), (Object)ReassignPartitionsCommand$.MODULE$.findLogDirMoveStates((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)"/tmp/kafka-logs0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quuz", 0, 0)), (Object)"/tmp/kafka-logs0")}))));
        }
    }

    @Test
    public void testReplicaMoveStatesToString() {
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reassignment of replica bar-0-0 completed successfully.", "Reassignment of replica foo-0-0 is still in progress.", "Partition foo-1 on broker 0 is not being moved from log dir /tmp/kafka-logs0 to /tmp/kafka-logs1.", "Partition quux-0 cannot be found in any live log directory on broker 0.", "Partition quux-1 on broker 1 is being moved to log dir /tmp/kafka-logs2 instead of /tmp/kafka-logs1.", "Partition quux-2 is not found in any live log dir on broker 1. There is likely an offline log directory on the broker."})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.replicaMoveStatesToString((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("bar", 0, 0)), (Object)new ReassignPartitionsCommand.CompletedMoveState("/tmp/kafka-logs0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 1, 0)), (Object)new ReassignPartitionsCommand.CancelledMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 0, 0)), (Object)new ReassignPartitionsCommand.MissingReplicaMoveState("/tmp/kafka-logs1")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 1)), (Object)new ReassignPartitionsCommand.ActiveMoveState("/tmp/kafka-logs0", "/tmp/kafka-logs1", "/tmp/kafka-logs2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 2, 1)), (Object)new ReassignPartitionsCommand.MissingLogDirMoveState("/tmp/kafka-logs1"))}))));
    }

    @Test
    public void testGetReplicaAssignments() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForTopics((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))));
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForPartitions((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}))));
        }
    }

    @Test
    public void testGetReplicaAndObserverAssignments() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopicsWithObservers(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForTopics((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))));
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}))))})), (Object)ReassignPartitionsCommand$.MODULE$.getReplicaAssignmentForPartitions((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 0), new TopicPartition("bar", 0)}))));
        }
    }

    @Test
    public void testGetBrokerRackInformation() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList(new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack1"), new Node(2, "locahost", 9094, null))).build();){
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)new Some((Object)"rack0")), new BrokerMetadata(1, (Option)new Some((Object)"rack1"))})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), true));
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(0, (Option)None$.MODULE$), new BrokerMetadata(1, (Option)None$.MODULE$)})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), false));
            this.assertStartsWith("Not all brokers have rack information", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), true)).getMessage());
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BrokerMetadata[]{new BrokerMetadata(1, (Option)None$.MODULE$), new BrokerMetadata(2, (Option)None$.MODULE$)})), (Object)ReassignPartitionsCommand$.MODULE$.getBrokerMetadata((Admin)adminClient, (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), false));
        }
    }

    @Test
    public void testParseGenerateAssignmentArgs() {
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "1,1,2"), () -> "Expected to detect duplicate broker list entries").getMessage());
        this.assertStartsWith("Broker list contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4,5"), () -> "Expected to detect duplicate broker list entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 2, 3, 4})), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"));
        this.assertStartsWith("List of topics to reassign contains duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"foo\"}], \"version\":1}", "5,2,3,4"), () -> "Expected to detect duplicate topic entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 3, 4})), (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))), (Object)ReassignPartitionsCommand$.MODULE$.parseGenerateAssignmentArgs("{\"topics\": [{\"topic\": \"foo\"},{\"topic\": \"bar\"}], \"version\":1}", "5,3,4"));
    }

    @Test
    public void testGenerateAssignmentFailsWithoutEnoughReplicas() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Replication factor: 3 larger than available brokers: 2", Assertions.assertThrows(InvalidReplicationFactorException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", "0,1", false), () -> "Expected generateAssignment to fail").getMessage());
        }
    }

    @Test
    public void testGenerateAssignmentWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"quux\"}]}", "0,1", false), () -> "Expected generateAssignment to fail").getCause().getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithInconsistentRacks() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().brokers(Arrays.asList(new Node(0, "locahost", 9092, "rack0"), new Node(1, "locahost", 9093, "rack0"), new Node(2, "locahost", 9094, null), new Node(3, "locahost", 9095, "rack1"), new Node(4, "locahost", 9096, "rack1"), new Node(5, "locahost", 9097, "rack2"))).build();){
            void var3_3;
            this.addTopics(adminClient);
            this.assertStartsWith("Not all brokers have rack information.", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", true), () -> "Expected generateAssignment to fail").getMessage());
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"}]}", "0,1,2,3", false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map current = (Map)tuple2._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Object)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGenerateAssignmentWithFewerBrokers() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            void var4_4;
            void var5_5;
            this.addTopics(adminClient);
            scala.collection.immutable.Set goalBrokers = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 3}));
            Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment((Admin)adminClient, "{\"topics\":[{\"topic\":\"foo\"},{\"topic\":\"bar\"}]}", goalBrokers.mkString(","), false);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Map proposed = (Map)tuple2._1();
            Map current = (Map)tuple2._2();
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Object)var5_5);
            var4_4.values().foreach(arg_0 -> ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(goalBrokers, (Map)var4_4, arg_0));
        }
    }

    @Test
    public void testCurrentPartitionReplicaAssignmentToString() {
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition replica assignment", "", "{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", "", "Save this to use as the --reassignment-json-file option during rollback"})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.currentPartitionReplicaAssignmentToString((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))));
    }

    @Test
    public void testCurrentPartitionReplicaAssignmentWithObserversToString() {
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition replica assignment", "", "{\"version\":1,\"partitions\":[{\"topic\":\"bar\",\"partition\":0,\"observers\":[8],\"replicas\":[7,8],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"observers\":[5,6],\"replicas\":[4,5,6],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", "", "Save this to use as the --reassignment-json-file option during rollback"})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.currentPartitionReplicaAssignmentToString((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 9}))))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10, 11, 12})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))));
    }

    @Test
    public void testMoveMap() {
        scala.collection.mutable.Map moveMap = ReassignPartitionsCommand$.MODULE$.calculateProposedMoveMap((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(3)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(6), Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)), Arrays.asList(Predef$.MODULE$.int2Integer(7), Predef$.MODULE$.int2Integer(8)), Arrays.asList(Predef$.MODULE$.int2Integer(4), Predef$.MODULE$.int2Integer(5)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)new PartitionReassignment(Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(4)), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2))))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 5})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 2)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 3)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 4)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 5)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("baz", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})));
        Assertions.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6}))))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new ReassignPartitionsCommand.PartitionMove((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))))})))})), (Object)moveMap);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:1,0:2,0:3,1:4,1:5,1:6,2:1,2:2,3:1,3:2,4:1,4:2,5:1,5:2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:2,0:3,0:4")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateLeaderThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"0:5,1:7,1:8,2:3,2:4,3:5,3:6,4:3,5:3,5:4,5:5,5:6"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"0:1")})), (Object)ReassignPartitionsCommand$.MODULE$.calculateFollowerThrottles(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6, 7, 8})), (Object)ReassignPartitionsCommand$.MODULE$.calculateReassigningBrokers(moveMap));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2})), (Object)ReassignPartitionsCommand$.MODULE$.calculateMovingBrokers((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("quux", 0, 0), new TopicPartitionReplica("quux", 1, 2)}))));
    }

    @Test
    public void testParseExecuteAssignmentArgs() {
        this.assertStartsWith("Partition reassignment list cannot be empty", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[]}"), () -> "Expected to detect empty partition reassignment list").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"), () -> "Expected to detect a partition list with duplicate entries").getMessage());
        this.assertStartsWith("Partition reassignment contains duplicate topic partitions", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":0,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        this.assertStartsWith("Partition replica lists may not contain duplicate entries", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,0],\"log_dirs\":[\"/abc\",\"/def\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3],\"log_dirs\":[\"/abc\",\"/def\"]}]}"), () -> "Expected to detect a partition replica list with duplicate entries").getMessage());
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"));
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))})), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 1)), (Object)"/tmp/a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 2)), (Object)"/tmp/b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 3)), (Object)"/tmp/c")}))), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}"));
    }

    @Test
    public void testParseExecuteAssignmentArgsWithObservers() {
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5}))))})), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"observers\":[2,3],\"log_dirs\":[\"any\",\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[3,4,5],\"observers\":[5],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}"));
        Assertions.assertEquals((Object)new Tuple2(Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))))})), Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 1)), (Object)"/tmp/a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 2)), (Object)"/tmp/b"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 3)), (Object)"/tmp/c")}))), (Object)ReassignPartitionsCommand$.MODULE$.parseExecuteAssignmentArgs("{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[1,2,3],\"observers\":[3],\"log_dirs\":[\"/tmp/a\",\"/tmp/b\",\"/tmp/c\"]}]}"));
    }

    @Test
    public void testExecuteWithInvalidPartitionsFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(5).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Topic quux not found", Assertions.assertThrows(ExecutionException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"quux\",\"partition\":0,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", -1L, -1L, 10000L, Time.SYSTEM), () -> "Expected reassignment with non-existent topic to fail").getCause().getMessage());
        }
    }

    @Test
    public void testExecuteWithInvalidBrokerIdFails() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unknown broker id 4", Assertions.assertThrows(AdminCommandFailedException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{\"version\":1,\"partitions\":[{\"topic\":\"foo\",\"partition\":0,\"replicas\":[0,1],\"log_dirs\":[\"any\",\"any\"]},{\"topic\":\"foo\",\"partition\":1,\"replicas\":[2,3,4],\"log_dirs\":[\"any\",\"any\",\"any\"]}]}", -1L, -1L, 10000L, Time.SYSTEM), () -> "Expected reassignment with non-existent broker id to fail").getMessage());
        }
    }

    @Test
    public void testModifyBrokerInterBrokerThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 1000L);
            ReassignPartitionsCommand$.MODULE$.modifyInterBrokerThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3})), 100L);
            scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})).map((Function1 & Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyBrokerInterBrokerThrottle$1(BoxesRunTime.unboxToInt((Object)id)));
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), 100L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), 1000L, -1L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), 100L, -1L);
        }
    }

    @Test
    public void testModifyLogDirThrottle() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), 2000L);
            ReassignPartitionsCommand$.MODULE$.modifyLogDirThrottle((Admin)adminClient, (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 3})), -1L);
            scala.collection.immutable.Seq brokers = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3})).map((Function1 & Serializable)id -> ReassignPartitionsUnitTest.$anonfun$testModifyLogDirThrottle$1(BoxesRunTime.unboxToInt((Object)id)));
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)brokers).asJava()).all().get();
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(0)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(1)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(2)), -1L, 2000L);
            this.verifyBrokerThrottleResults((Config)results.get(brokers.apply(3)), -1L, -1L);
        }
    }

    @Test
    public void testCurReassignmentsToString() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
            scala.collection.immutable.Map reassignmentResult = ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 4, 2})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$)))}))).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                Throwable v = (Throwable)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignmentResult);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition reassignments:", "bar-0: replicas: 2,3,0. removing: 0.", "foo-0: replicas: 0,1,2. adding: 4.", "foo-1: replicas: 1,2,3. adding: 4,5. removing: 1,2."})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
        }
    }

    @Test
    public void testCurReassignmentsToStringWithObservers() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopicsWithObservers(adminClient);
            Assertions.assertEquals((Object)"No partition reassignments found.", (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
            scala.collection.immutable.Map reassignmentResult = ReassignPartitionsCommand$.MODULE$.alterPartitionReassignments((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 1)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("foo", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 4, 5})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 5})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("bar", 0)), (Object)new ReassignPartitionsCommand.Assignment((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1, 4})), (Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 4}))))}))).map((Function1 & Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition k = (TopicPartition)x0$1._1();
                Throwable v = (Throwable)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.getClass());
                return tuple2;
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)Nil$.MODULE$), (Object)reassignmentResult);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Current partition reassignments:", "bar-0: replicas: 2,3,0,1. adding: 4.", "foo-0: replicas: 0,1,2,3. adding: 4,5. removing: 3.", "foo-1: replicas: 1,2,3. adding: 4. removing: 3."})).mkString(System.lineSeparator()), (Object)ReassignPartitionsCommand$.MODULE$.curReassignmentsToString((Admin)adminClient));
        }
    }

    private void verifyBrokerThrottleResults(Config config, long expectedInterBrokerThrottle, long expectedReplicaAlterLogDirsThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        if (expectedInterBrokerThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLeaderThrottle(), (Function0 & Serializable)() -> ""));
            Assertions.assertEquals((Object)Long.toString(expectedInterBrokerThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelFollowerThrottle(), (Function0 & Serializable)() -> ""));
        }
        if (expectedReplicaAlterLogDirsThrottle >= 0L) {
            Assertions.assertEquals((Object)Long.toString(expectedReplicaAlterLogDirsThrottle), (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.brokerLevelLogDirThrottle(), (Function0 & Serializable)() -> ""));
        }
    }

    @Test
    public void testModifyTopicThrottles() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            ReassignPartitionsCommand$.MODULE$.modifyTopicThrottles((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)"leaderFoo"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"leaderBar")})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)"followerBar")})));
            scala.collection.immutable.Seq topics = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "foo"})).map((Function1 & Serializable)id -> new ConfigResource(ConfigResource.Type.TOPIC, id));
            java.util.Map results = (java.util.Map)adminClient.describeConfigs((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)topics).asJava()).all().get();
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(0)), "leaderBar", "followerBar");
            this.verifyTopicThrottleResults((Config)results.get(topics.apply(1)), "leaderFoo", "");
        }
    }

    private void verifyTopicThrottleResults(Config config, String expectedLeaderThrottle, String expectedFollowerThrottle) {
        HashMap configs = new HashMap();
        config.entries().forEach(entry -> configs.put((Object)entry.name(), (Object)entry.value()));
        Assertions.assertEquals((Object)expectedLeaderThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelLeaderThrottle(), (Function0 & Serializable)() -> ""));
        Assertions.assertEquals((Object)expectedFollowerThrottle, (Object)configs.getOrElse((Object)ReassignPartitionsCommand$.MODULE$.topicLevelFollowerThrottle(), (Function0 & Serializable)() -> ""));
    }

    @Test
    public void testAlterReplicaLogDirs() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).brokerLogDirs(Collections.nCopies(4, Arrays.asList("/tmp/kafka-logs0", "/tmp/kafka-logs1"))).build();){
            this.addTopics(adminClient);
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartitionReplica[]{new TopicPartitionReplica("foo", 0, 0)})), (Object)ReassignPartitionsCommand$.MODULE$.alterReplicaLogDirs((Admin)adminClient, (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("foo", 0, 0)), (Object)"/tmp/kafka-logs1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartitionReplica("quux", 1, 0)), (Object)"/tmp/kafka-logs1")}))));
        }
    }

    public void assertStartsWith(String prefix, String str) {
        Assertions.assertTrue((boolean)str.startsWith(prefix), (String)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Expected the string to start with %s, but it was %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{prefix, str})));
    }

    @Test
    public void testPropagateInvalidJsonError() {
        try (MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(4).build();){
            this.addTopics(adminClient);
            this.assertStartsWith("Unexpected character", Assertions.assertThrows(AdminOperationException.class, () -> ReassignPartitionsCommand$.MODULE$.executeAssignment((Admin)adminClient, false, "{invalid_json", -1L, -1L, 10000L, Time.SYSTEM)).getMessage());
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ void $anonfun$testGenerateAssignmentWithFewerBrokers$1(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, ReassignPartitionsCommand.Assignment assignment) {
        Assertions.assertTrue((boolean)assignment.replicas().forall((Function1)(JFunction1.mcZI.sp & Serializable)elem -> goalBrokers$1.contains((Object)BoxesRunTime.boxToInteger((int)elem))), (String)new StringBuilder(57).append("Proposed assignment ").append(proposed$1).append(" puts replicas on brokers other than ").append(goalBrokers$1).toString());
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyBrokerInterBrokerThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ ConfigResource $anonfun$testModifyLogDirThrottle$1(int id) {
        return new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(id));
    }

    public static final /* synthetic */ Object $anonfun$testGenerateAssignmentWithFewerBrokers$1$adapted(scala.collection.immutable.Set goalBrokers$1, Map proposed$1, ReassignPartitionsCommand.Assignment assignment) {
        ReassignPartitionsUnitTest.$anonfun$testGenerateAssignmentWithFewerBrokers$1(goalBrokers$1, proposed$1, assignment);
        return BoxedUnit.UNIT;
    }
}

