/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import kafka.admin.ReplicaStatusCommand$;
import kafka.admin.ReplicaStatusCommandTest$;
import kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.utils.json.DecodeJson;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r\u0005g\u0001\u00021b\u0005\u0019DQ!\u001c\u0001\u0005\u00029DQ!\u001d\u0001\u0005BIDq!a\u0001\u0001\t\u0013\t)\u0001C\u0004\u0002Z\u0001!I!a\u0017\u0007\r\u0005M\u0004\u0001QA;\u0011)\ti#\u0002BK\u0002\u0013\u0005\u0011Q\u0013\u0005\u000b\u0003/+!\u0011#Q\u0001\n\u0005=\u0002BCAM\u000b\tU\r\u0011\"\u0001\u0002\u001c\"Q\u0011QT\u0003\u0003\u0012\u0003\u0006I!!\u001b\t\u0015\u0005}UA!f\u0001\n\u0003\tY\n\u0003\u0006\u0002\"\u0016\u0011\t\u0012)A\u0005\u0003SB!\"a)\u0006\u0005+\u0007I\u0011AAS\u0011)\ti+\u0002B\tB\u0003%\u0011q\u0015\u0005\u000b\u0003_+!Q3A\u0005\u0002\u0005\u0015\u0006BCAY\u000b\tE\t\u0015!\u0003\u0002(\"Q\u00111W\u0003\u0003\u0016\u0004%\t!!*\t\u0015\u0005UVA!E!\u0002\u0013\t9\u000b\u0003\u0006\u00028\u0016\u0011)\u001a!C\u0001\u0003KC!\"!/\u0006\u0005#\u0005\u000b\u0011BAT\u0011)\tY,\u0002BK\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003{+!\u0011#Q\u0001\n\u0005\u001d\u0006BCA`\u000b\tU\r\u0011\"\u0001\u0002B\"Q\u0011qZ\u0003\u0003\u0012\u0003\u0006I!a1\t\u0015\u0005EWA!f\u0001\n\u0003\t\t\r\u0003\u0006\u0002T\u0016\u0011\t\u0012)A\u0005\u0003\u0007D!\"!6\u0006\u0005+\u0007I\u0011AAa\u0011)\t9.\u0002B\tB\u0003%\u00111\u0019\u0005\u000b\u00033,!Q3A\u0005\u0002\u0005\u0005\u0007BCAn\u000b\tE\t\u0015!\u0003\u0002D\"Q\u0011Q\\\u0003\u0003\u0016\u0004%\t!!&\t\u0015\u0005}WA!E!\u0002\u0013\ty\u0003\u0003\u0006\u0002b\u0016\u0011)\u001a!C\u0001\u0003GD!\"a:\u0006\u0005#\u0005\u000b\u0011BAs\u0011)\tI/\u0002BK\u0002\u0013\u0005\u0011\u0011\u0019\u0005\u000b\u0003W,!\u0011#Q\u0001\n\u0005\r\u0007BCAw\u000b\tU\r\u0011\"\u0001\u0002B\"Q\u0011q^\u0003\u0003\u0012\u0003\u0006I!a1\t\r5,A\u0011AAy\u0011%\u00119\"BA\u0001\n\u0003\u0011I\u0002C\u0005\u0003<\u0015\t\n\u0011\"\u0001\u0003>!I!1K\u0003\u0012\u0002\u0013\u0005!Q\u000b\u0005\n\u00053*\u0011\u0013!C\u0001\u0005+B\u0011Ba\u0017\u0006#\u0003%\tA!\u0018\t\u0013\t\u0005T!%A\u0005\u0002\tu\u0003\"\u0003B2\u000bE\u0005I\u0011\u0001B/\u0011%\u0011)'BI\u0001\n\u0003\u0011i\u0006C\u0005\u0003h\u0015\t\n\u0011\"\u0001\u0003^!I!\u0011N\u0003\u0012\u0002\u0013\u0005!1\u000e\u0005\n\u0005_*\u0011\u0013!C\u0001\u0005WB\u0011B!\u001d\u0006#\u0003%\tAa\u001b\t\u0013\tMT!%A\u0005\u0002\t-\u0004\"\u0003B;\u000bE\u0005I\u0011\u0001B\u001f\u0011%\u00119(BI\u0001\n\u0003\u0011I\bC\u0005\u0003~\u0015\t\n\u0011\"\u0001\u0003l!I!qP\u0003\u0012\u0002\u0013\u0005!1\u000e\u0005\n\u0005\u0003+\u0011\u0011!C!\u0005\u0007C\u0011B!#\u0006\u0003\u0003%\t!a'\t\u0013\t-U!!A\u0005\u0002\t5\u0005\"\u0003BM\u000b\u0005\u0005I\u0011\tBN\u0011%\u0011\u0019+BA\u0001\n\u0003\u0011)\u000bC\u0005\u0003*\u0016\t\t\u0011\"\u0011\u0003,\"I!qV\u0003\u0002\u0002\u0013\u0005#\u0011\u0017\u0005\n\u0005g+\u0011\u0011!C!\u0005kC\u0011Ba.\u0006\u0003\u0003%\tE!/\b\u0013\tu\u0006!!A\t\u0002\t}f!CA:\u0001\u0005\u0005\t\u0012\u0001Ba\u0011\u0019i'\t\"\u0001\u0003Z\"I!1\u0017\"\u0002\u0002\u0013\u0015#Q\u0017\u0005\n\u00057\u0014\u0015\u0011!CA\u0005;D\u0011Ba@C\u0003\u0003%\ti!\u0001\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!911\u0005\u0001\u0005\u0002\r\u0015\u0002bBB\u001f\u0001\u0011\u00051Q\u0005\u0005\b\u0007\u0003\u0002A\u0011AB\u0013\u0011\u001d\u0019)\u0005\u0001C\u0001\u0007KAqa!\u0013\u0001\t\u0003\u0019)\u0003C\u0004\u0004N\u0001!\ta!\n\t\u000f\rE\u0003\u0001\"\u0001\u0004&!91Q\u000b\u0001\u0005\u0002\r\u0015\u0002bBB-\u0001\u0011%11\f\u0005\b\u0007C\u0002A\u0011AB\u0013\u0011\u001d\u0019)\u0007\u0001C\u0001\u0007KAqa!\u001b\u0001\t\u0013\u0019Y\u0007C\u0004\u0004v\u0001!\ta!\n\t\u000f\re\u0004\u0001\"\u0001\u0004&!91Q\u0010\u0001\u0005\u0002\r\u0015\u0002bBBA\u0001\u0011\u00051Q\u0005\u0005\b\u0007\u000b\u0003A\u0011BBD\u0011\u001d\u0019y\t\u0001C\u0001\u0007KAqaa%\u0001\t\u0003\u0019)cB\u0004\u0004\u0018\u0006D\ta!'\u0007\r\u0001\f\u0007\u0012ABN\u0011\u0019iG\f\"\u0001\u0004\u001e\"91q\u0014/\u0005\u0002\r\u0005\u0006bBB^9\u0012\u00051Q\u0018\u0002\u0019%\u0016\u0004H.[2b'R\fG/^:D_6l\u0017M\u001c3UKN$(B\u00012d\u0003\u0015\tG-\\5o\u0015\u0005!\u0017!B6bM.\f7\u0001A\n\u0003\u0001\u001d\u0004\"\u0001[6\u000e\u0003%T!A[2\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003Y&\u0014acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0004\"\u0001\u001d\u0001\u000e\u0003\u0005\fqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002gB\u0019A/_>\u000e\u0003UT!A^<\u0002\u0015\r|G\u000e\\3di&|gNC\u0001y\u0003\u0015\u00198-\u00197b\u0013\tQXOA\u0002TKF\u0004\"\u0001`@\u000e\u0003uT!A`2\u0002\rM,'O^3s\u0013\r\t\t! \u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\nde\u0016\fG/\u001a+pa&\u001c\u0017I\u001c3XC&$H\u0003CA\u0004\u0003\u001f\tY#!\u0012\u0011\t\u0005%\u00111B\u0007\u0002o&\u0019\u0011QB<\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003#\u0019\u0001\u0019AA\n\u0003\u0019\u0019G.[3oiB!\u0011QCA\u0014\u001b\t\t9BC\u0002c\u00033QA!a\u0007\u0002\u001e\u000591\r\\5f]R\u001c(b\u00013\u0002 )!\u0011\u0011EA\u0012\u0003\u0019\t\u0007/Y2iK*\u0011\u0011QE\u0001\u0004_J<\u0017\u0002BA\u0015\u0003/\u00111\"\u00113nS:\u001cE.[3oi\"9\u0011QF\u0002A\u0002\u0005=\u0012!\u0002;pa&\u001c\u0007\u0003BA\u0019\u0003\u007fqA!a\r\u0002<A\u0019\u0011QG<\u000e\u0005\u0005]\"bAA\u001dK\u00061AH]8pizJ1!!\u0010x\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011IA\"\u0005\u0019\u0019FO]5oO*\u0019\u0011QH<\t\u000f\u0005\u001d3\u00011\u0001\u0002J\u0005ia.^7QCJ$\u0018\u000e^5p]N\u0004B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&\u0001\u0003mC:<'BAA*\u0003\u0011Q\u0017M^1\n\t\u0005]\u0013Q\n\u0002\b\u0013:$XmZ3s\u0003)\u0011XO\\\"p[6\fg\u000e\u001a\u000b\t\u0003_\ti&a\u001a\u0002p!9\u0011q\f\u0003A\u0002\u0005\u0005\u0014A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002\n\u0005\r\u0014qF\u0005\u0004\u0003K:(!B!se\u0006L\bbBA$\t\u0001\u0007\u0011\u0011\u000e\t\u0005\u0003\u0013\tY'C\u0002\u0002n]\u00141!\u00138u\u0011\u001d\t\t\b\u0002a\u0001\u0003C\nA!\u0019:hg\n\u0011\"+\u001a9mS\u000e\f7\u000b^1ukN,e\u000e\u001e:z'\u001d)\u0011qOA?\u0003\u0007\u0003B!!\u0003\u0002z%\u0019\u00111P<\u0003\r\u0005s\u0017PU3g!\u0011\tI!a \n\u0007\u0005\u0005uOA\u0004Qe>$Wo\u0019;\u0011\t\u0005\u0015\u0015q\u0012\b\u0005\u0003\u000f\u000bYI\u0004\u0003\u00026\u0005%\u0015\"\u0001=\n\u0007\u00055u/A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00151\u0013\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0004\u0003\u001b;XCAA\u0018\u0003\u0019!x\u000e]5dA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0003\u0003S\n!\u0002]1si&$\u0018n\u001c8!\u0003\u001d\u0011X\r\u001d7jG\u0006\f\u0001B]3qY&\u001c\u0017\rI\u0001\tSNdU-\u00193feV\u0011\u0011q\u0015\t\u0005\u0003\u0013\tI+C\u0002\u0002,^\u0014qAQ8pY\u0016\fg.A\u0005jg2+\u0017\rZ3sA\u0005Q\u0011n](cg\u0016\u0014h/\u001a:\u0002\u0017%\u001cxJY:feZ,'\u000fI\u0001\u000eSNL5O]#mS\u001eL'\r\\3\u0002\u001d%\u001c\u0018j\u001d:FY&<\u0017N\u00197fA\u00059\u0011n]%o\u0013N\u0014\u0018\u0001C5t\u0013:L5O\u001d\u0011\u0002\u0015%\u001c8)Y;hQR,\u0006/A\u0006jg\u000e\u000bWo\u001a5u+B\u0004\u0013!\u00057bgR\u001c\u0015-^4iiV\u0003H*Y4NgV\u0011\u00111\u0019\t\u0007\u0003\u0013\t)-!3\n\u0007\u0005\u001dwO\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0013\tY-C\u0002\u0002N^\u0014A\u0001T8oO\u0006\u0011B.Y:u\u0007\u0006,x\r\u001b;Va2\u000bw-T:!\u00039a\u0017m\u001d;GKR\u001c\u0007\u000eT1h\u001bN\fq\u0002\\1ti\u001a+Go\u00195MC\u001el5\u000fI\u0001\u000fY><7\u000b^1si>3gm]3u\u0003=awnZ*uCJ$xJ\u001a4tKR\u0004\u0013\u0001\u00047pO\u0016sGm\u00144gg\u0016$\u0018!\u00047pO\u0016sGm\u00144gg\u0016$\b%A\u0006mK\u0006$WM]#q_\u000eD\u0017\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0013aC7jeJ|'o\u0015;bi\u0016,\"!!:\u0011\r\u0005%\u0011QYA\u0018\u00031i\u0017N\u001d:peN#\u0018\r^3!\u0003Ui\u0017N\u001d:pe2\u000b7\u000f\u001e$fi\u000eDG+[7f\u001bN\fa#\\5se>\u0014H*Y:u\r\u0016$8\r\u001b+j[\u0016l5\u000fI\u0001\u001d[&\u0014(o\u001c:MCN$h)\u001a;dQ\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0003ui\u0017N\u001d:pe2\u000b7\u000f\u001e$fi\u000eD\u0007*[4i/\u0006$XM]7be.\u0004CCIAz\u0003o\fI0a?\u0002~\u0006}(\u0011\u0001B\u0002\u0005\u000b\u00119A!\u0003\u0003\f\t5!q\u0002B\t\u0005'\u0011)\u0002E\u0002\u0002v\u0016i\u0011\u0001\u0001\u0005\b\u0003[1\u0003\u0019AA\u0018\u0011\u001d\tIJ\na\u0001\u0003SBq!a('\u0001\u0004\tI\u0007C\u0004\u0002$\u001a\u0002\r!a*\t\u000f\u0005=f\u00051\u0001\u0002(\"9\u00111\u0017\u0014A\u0002\u0005\u001d\u0006bBA\\M\u0001\u0007\u0011q\u0015\u0005\b\u0003w3\u0003\u0019AAT\u0011\u001d\tyL\na\u0001\u0003\u0007Dq!!5'\u0001\u0004\t\u0019\rC\u0004\u0002V\u001a\u0002\r!a1\t\u000f\u0005eg\u00051\u0001\u0002D\"9\u0011Q\u001c\u0014A\u0002\u0005=\u0002bBAqM\u0001\u0007\u0011Q\u001d\u0005\b\u0003S4\u0003\u0019AAb\u0011\u001d\tiO\na\u0001\u0003\u0007\fAaY8qsR\u0011\u00131\u001fB\u000e\u0005;\u0011yB!\t\u0003$\t\u0015\"q\u0005B\u0015\u0005W\u0011iCa\f\u00032\tM\"Q\u0007B\u001c\u0005sA\u0011\"!\f(!\u0003\u0005\r!a\f\t\u0013\u0005eu\u0005%AA\u0002\u0005%\u0004\"CAPOA\u0005\t\u0019AA5\u0011%\t\u0019k\nI\u0001\u0002\u0004\t9\u000bC\u0005\u00020\u001e\u0002\n\u00111\u0001\u0002(\"I\u00111W\u0014\u0011\u0002\u0003\u0007\u0011q\u0015\u0005\n\u0003o;\u0003\u0013!a\u0001\u0003OC\u0011\"a/(!\u0003\u0005\r!a*\t\u0013\u0005}v\u0005%AA\u0002\u0005\r\u0007\"CAiOA\u0005\t\u0019AAb\u0011%\t)n\nI\u0001\u0002\u0004\t\u0019\rC\u0005\u0002Z\u001e\u0002\n\u00111\u0001\u0002D\"I\u0011Q\\\u0014\u0011\u0002\u0003\u0007\u0011q\u0006\u0005\n\u0003C<\u0003\u0013!a\u0001\u0003KD\u0011\"!;(!\u0003\u0005\r!a1\t\u0013\u00055x\u0005%AA\u0002\u0005\r\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005\u007fQC!a\f\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GMC\u0002\u0003N]\f!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]#\u0006BA5\u0005\u0003\nabY8qs\u0012\"WMZ1vYR$3'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t}#\u0006BAT\u0005\u0003\nabY8qs\u0012\"WMZ1vYR$S'\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%o\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012B\u0014AD2paf$C-\u001a4bk2$H%O\u000b\u0003\u0005[RC!a1\u0003B\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\n\u0004'A\bd_BLH\u0005Z3gCVdG\u000fJ\u00192\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\u0012\u0014aD2paf$C-\u001a4bk2$H%M\u001a\u0002\u001f\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cQ*\"Aa\u001f+\t\u0005\u0015(\u0011I\u0001\u0010G>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132k\u0005y1m\u001c9zI\u0011,g-Y;mi\u0012\nd'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u000b\u0003B!a\u0013\u0003\b&!\u0011\u0011IA'\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa$\u0003\u0016B!\u0011\u0011\u0002BI\u0013\r\u0011\u0019j\u001e\u0002\u0004\u0003:L\b\"\u0003BLu\u0005\u0005\t\u0019AA5\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0014\t\u0006i\n}%qR\u0005\u0004\u0005C+(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a*\u0003(\"I!q\u0013\u001f\u0002\u0002\u0003\u0007!qR\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0003\u0006\n5\u0006\"\u0003BL{\u0005\u0005\t\u0019AA5\u0003!A\u0017m\u001d5D_\u0012,GCAA5\u0003!!xn\u0015;sS:<GC\u0001BC\u0003\u0019)\u0017/^1mgR!\u0011q\u0015B^\u0011%\u00119\nQA\u0001\u0002\u0004\u0011y)\u0001\nSKBd\u0017nY1Ti\u0006$Xo]#oiJL\bcAA{\u0005N)!Ia1\u0003PB1#Q\u0019Bf\u0003_\tI'!\u001b\u0002(\u0006\u001d\u0016qUAT\u0003O\u000b\u0019-a1\u0002D\u0006\r\u0017qFAs\u0003\u0007\f\u0019-a=\u000e\u0005\t\u001d'b\u0001Beo\u00069!/\u001e8uS6,\u0017\u0002\u0002Bg\u0005\u000f\u0014!#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82mA!!\u0011\u001bBl\u001b\t\u0011\u0019N\u0003\u0003\u0003V\u0006E\u0013AA5p\u0013\u0011\t\tJa5\u0015\u0005\t}\u0016!B1qa2LHCIAz\u0005?\u0014\tOa9\u0003f\n\u001d(\u0011\u001eBv\u0005[\u0014yO!=\u0003t\nU(q\u001fB}\u0005w\u0014i\u0010C\u0004\u0002.\u0015\u0003\r!a\f\t\u000f\u0005eU\t1\u0001\u0002j!9\u0011qT#A\u0002\u0005%\u0004bBAR\u000b\u0002\u0007\u0011q\u0015\u0005\b\u0003_+\u0005\u0019AAT\u0011\u001d\t\u0019,\u0012a\u0001\u0003OCq!a.F\u0001\u0004\t9\u000bC\u0004\u0002<\u0016\u0003\r!a*\t\u000f\u0005}V\t1\u0001\u0002D\"9\u0011\u0011[#A\u0002\u0005\r\u0007bBAk\u000b\u0002\u0007\u00111\u0019\u0005\b\u00033,\u0005\u0019AAb\u0011\u001d\ti.\u0012a\u0001\u0003_Aq!!9F\u0001\u0004\t)\u000fC\u0004\u0002j\u0016\u0003\r!a1\t\u000f\u00055X\t1\u0001\u0002D\u00069QO\\1qa2LH\u0003BB\u0002\u0007\u0017\u0001b!!\u0003\u0002F\u000e\u0015\u0001\u0003JA\u0005\u0007\u000f\ty#!\u001b\u0002j\u0005\u001d\u0016qUAT\u0003O\u000b9+a1\u0002D\u0006\r\u00171YA\u0018\u0003K\f\u0019-a1\n\u0007\r%qOA\u0004UkBdW-\r\u001c\t\u0013\r5a)!AA\u0002\u0005M\u0018a\u0001=%a\u0005)\"/\u001e8D_6l\u0017M\u001c3QCJ\u001cXmT;uaV$HCCB\n\u00073\u0019Yb!\b\u0004 A1\u0011QQB\u000b\u0003gLAaa\u0006\u0002\u0014\n!A*[:u\u0011\u001d\tyf\u0012a\u0001\u0003CBq!a\u0012H\u0001\u0004\tI\u0007C\u0004\u0002r\u001d\u0003\r!!\u0019\t\u000f\r\u0005r\t1\u0001\u0002(\u0006\u0001R\r\u001f9fGRl\u0015N\u001d:pe&sgm\\\u0001\u001bi\u0016\u001cHOV3sE>\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0003\u000fA3\u0001SB\u0015!\u0011\u0019Yc!\u000f\u000e\u0005\r5\"\u0002BB\u0018\u0007c\t1!\u00199j\u0015\u0011\u0019\u0019d!\u000e\u0002\u000f),\b/\u001b;fe*!1qGA\u0012\u0003\u0015QWO\\5u\u0013\u0011\u0019Yd!\f\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHo\u00159fG&4\u0017.\u001a3U_BL7m\u001d\u0015\u0004\u0013\u000e%\u0012a\u0006;fgR\u001c\u0006/Z2jM&,G\rU1si&$\u0018n\u001c8tQ\rQ5\u0011F\u0001\u0010i\u0016\u001cH\u000fT3bI\u0016\u00148o\u00148ms\"\u001a1j!\u000b\u0002'Q,7\u000f\u001e'fC\u0012,'o]#yG2,H-\u001a3)\u00071\u001bI#A\tuKN$xJY:feZ,'o](oYfD3!TB\u0015\u0003U!Xm\u001d;PEN,'O^3sg\u0016C8\r\\;eK\u0012D3ATB\u0015\u00031!Xm\u001d;O_RLe.S:sQ\ry5\u0011F\u0001\u000eeVtG+Z:u\u001fV$\b/\u001e;\u0015\r\u0005\u001d1QLB0\u0011\u001d\t\t\b\u0015a\u0001\u0003CBqa!\tQ\u0001\u0004\t9+\u0001\u0006uKN$x*\u001e;qkRD3!UB\u0015\u0003]!Xm\u001d;PkR\u0004X\u000f^%oG2,H-Z'jeJ|'\u000fK\u0002S\u0007S\t1B];o)\u0016\u001cHOS:p]RA\u0011qAB7\u0007_\u001a\u0019\bC\u0004\u0002rM\u0003\r!!\u0019\t\u000f\rE4\u000b1\u0001\u0002(\u0006\tR\r\u001f9fGR\u001cE.^:uKJd\u0015N\\6\t\u000f\r\u00052\u000b1\u0001\u0002(\u0006AA/Z:u\u0015N|g\u000eK\u0002U\u0007S\tQ\u0003^3ti*\u001bxN\\%oG2,H-\u001a'j].,G\rK\u0002V\u0007S\tQ\u0003^3ti*\u001bxN\\%oG2,H-Z'jeJ|'\u000fK\u0002W\u0007S\tq\u0002^3ti6K7o]5oO\u0006\u0013xm\u001d\u0015\u0004/\u000e%\u0012a\u0004;fgRLeN^1mS\u0012\f%oZ:\u0015\r\u0005\u001d1\u0011RBF\u0011\u001d\t\t\b\u0017a\u0001\u0003CBqa!$Y\u0001\u0004\ty#\u0001\ffqB,7\r^3e\u000bJ\u0014xN\u001d)sK\u001aL\u0007p\u0015;s\u0003E!Xm\u001d;J]Z\fG.\u001b3U_BL7m\u001d\u0015\u00043\u000e%\u0012\u0001\u0007;fgRLeN^1mS\u0012\u0004\u0016M\u001d;ji&|gn]!sO\"\u001a!l!\u000b\u00021I+\u0007\u000f\\5dCN#\u0018\r^;t\u0007>lW.\u00198e)\u0016\u001cH\u000f\u0005\u0002q9N\u0019A,a\u001e\u0015\u0005\re\u0015\u0001D2sK\u0006$XmQ8oM&<G\u0003BBR\u0007_\u0003\u0002\"!\r\u0004&\u0006=2\u0011V\u0005\u0005\u0007O\u000b\u0019EA\u0002NCB\u0004B!a\u0013\u0004,&!1QVA'\u0005\u0019y%M[3di\"91\u0011\u00170A\u0002\rM\u0016aB:feZ,'o\u001d\t\u0005if\u001c)\fE\u0002}\u0007oK1a!/~\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002!\t|w\u000e^:ue\u0006\u00048+\u001a:wKJ\u001cH\u0003BA\u0018\u0007\u007fCqa!-`\u0001\u0004\u0019\u0019\f")
public final class ReplicaStatusCommandTest
extends KafkaServerTestHarness {
    private volatile ReplicaStatusCommandTest$ReplicaStatusEntry$ ReplicaStatusEntry$module;

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> servers) {
        return ReplicaStatusCommandTest$.MODULE$.createConfig(servers);
    }

    public ReplicaStatusCommandTest$ReplicaStatusEntry$ ReplicaStatusEntry() {
        if (this.ReplicaStatusEntry$module == null) {
            this.ReplicaStatusEntry$lzycompute$1();
        }
        return this.ReplicaStatusEntry$module;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$4 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"b")}));
        boolean bl = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$6 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$7 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$8 = none$6;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 1;
        boolean bl6 = false;
        int n2 = 1;
        short s = 1;
        int n3 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, x$2, false, bl, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, bl2, bl3, bl4, bl5, (Map<Object, String>)x$4, n, bl6, n2, s, n3).map((Function1 & Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            return KafkaConfig$.MODULE$.fromProps(config);
        });
    }

    private void createTopicAndWait(AdminClient client, String topic, Integer numPartitions) {
        NewTopic newTopic = new NewTopic(topic, Optional.of(numPartitions), Optional.empty());
        newTopic.configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)"{\n        \"version\":1,\n        \"replicas\":[{\n          \"count\": 2,\n          \"constraints\":{\"rack\":\"a\"}\n        }],\n        \"observers\":[{\n         \"count\": 1,\n         \"constraints\":{\"rack\":\"b\"}\n        }]\n      }")}))).asJava());
        client.createTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(numPartitions)).foreach((Function1 & Serializable)p -> TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topic, BoxesRunTime.unboxToInt((Object)p), 15000L));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicaStatusCommandTest.$anonfun$createTopicAndWait$2(client, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to create topic");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
    }

    private String runCommand(String[] topics, int numPartitions, String[] args) {
        String string;
        AdminClient adminClient;
        AdminClient adminClient2 = adminClient = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ReplicaStatusCommandTest$.MODULE$.createConfig((Seq<KafkaServer>)this.servers())).asJava());
        adminClient = null;
        try (AdminClient resource_resource = adminClient2;){
            string = ReplicaStatusCommandTest.$anonfun$runCommand$1(this, topics, numPartitions, args, resource_resource);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private List<ReplicaStatusEntry> runCommandParseOutput(String[] topics, int numPartitions, String[] args, boolean expectMirrorInfo) {
        String output = this.runCommand(topics, numPartitions, args);
        Scanner scanner = new Scanner(output);
        Assertions.assertTrue((boolean)scanner.hasNextLine());
        String mirrorScan = expectMirrorInfo ? "\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)" : "";
        scanner.findInLine(new StringBuilder(101).append("(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)").append(mirrorScan).toString());
        MatchResult topMatch = scanner.match();
        List headers = ReplicaStatusCommand$.MODULE$.headers(false, expectMirrorInfo);
        Assertions.assertTrue((topMatch.groupCount() == headers.size() ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), headers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            String string = topMatch.group(idx + 1);
            Object object = headers.apply(idx);
            Assertions.assertTrue((!(string != null ? !string.equals(object) : object != null) ? 1 : 0) != 0);
        });
        scanner.nextLine();
        Buffer result = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        String mirrorPattern = expectMirrorInfo ? "\\s+(\\S+)\\s+(-?[0-9]*)\\s+(-?[0-9]*)" : "";
        Pattern pattern = Pattern.compile(new StringBuilder(156).append("(\\S+)\\s+(\\d+)\\s+(\\d+)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(true|false)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(-?[0-9]+)\\s+(\\S+)").append(mirrorPattern).toString());
        while (scanner.hasNextLine()) {
            void var16_16;
            void var15_15;
            void var14_14;
            None$ none$;
            None$ none$2;
            None$ none$3;
            scanner.findInLine(pattern);
            MatchResult subMatch = scanner.match();
            Assertions.assertTrue((subMatch.groupCount() == headers.size() ? 1 : 0) != 0);
            if (expectMirrorInfo) {
                none$3 = ReplicaStatusCommandTest.toMirrorState$1(subMatch.group(14));
                none$2 = ReplicaStatusCommandTest.toMirrorLongOption$1(subMatch.group(15));
                none$ = ReplicaStatusCommandTest.toMirrorLongOption$1(subMatch.group(16));
            } else {
                none$3 = None$.MODULE$;
                none$2 = None$.MODULE$;
                none$ = None$.MODULE$;
            }
            None$ none$4 = none$;
            None$ none$5 = none$2;
            Option mirrorState = (Option)none$3;
            Option mirrorLastFetchTimeMs = (Option)none$5;
            Option mirrorLastFetchHighWatermark = (Option)none$4;
            result.$plus$eq((Object)new ReplicaStatusEntry(this, subMatch.group(1), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(subMatch.group(2))), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(subMatch.group(3))), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(4)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(5)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(6)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(7)), ReplicaStatusCommandTest.toBoolean$1(subMatch.group(8)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(9)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(10)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(11)), (Option<Object>)ReplicaStatusCommandTest.toLongOption$1(subMatch.group(12)), subMatch.group(13), (Option<String>)var14_14, (Option<Object>)var15_15, (Option<Object>)var16_16));
            scanner.nextLine();
        }
        return result.toList();
    }

    @Test
    public void testVerboseTopicPartitions() {
        Object[] topics = new String[]{"test-topic-1", "test-topic-2"};
        int numPartitions = 2;
        String output = this.runCommand((String[])topics, numPartitions, new String[]{"--verbose"});
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(topics), (Function1 & Serializable)topic -> {
            ReplicaStatusCommandTest.$anonfun$testVerboseTopicPartitions$1(this, numPartitions, output, topic);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)output.contains("IsLeader: true"));
        Assertions.assertTrue((boolean)output.contains("IsLeader: false"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: true"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: false"));
        Assertions.assertTrue((boolean)output.contains("IsIsrEligible: true"));
        Assertions.assertTrue((boolean)output.contains("IsIsrEligible: false"));
    }

    @Test
    public void testSpecifiedTopics() {
        String[] topics = new String[]{"test-topic-1", "test-topic-2", "test-topic-3"};
        String output = this.runCommand(topics, 1, new String[]{"--topics", new StringBuilder(1).append(topics[0]).append(",").append(topics[2]).toString(), "--verbose"});
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[0]).toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[1]).toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(7).append("Topic: ").append(topics[2]).toString()));
    }

    @Test
    public void testSpecifiedPartitions() {
        String[] topics = new String[]{"test-topic"};
        String output = this.runCommand(topics, 4, new String[]{"--partitions", "0,2-3", "--verbose"});
        Assertions.assertTrue((boolean)output.contains("Partition: 0"));
        Assertions.assertFalse((boolean)output.contains("Partition: 1"));
        Assertions.assertTrue((boolean)output.contains("Partition: 2"));
        Assertions.assertTrue((boolean)output.contains("Partition: 3"));
    }

    @Test
    public void testLeadersOnly() {
        String topic = "test-topic";
        String output = this.runCommand(new String[]{topic}, 1, new String[]{"--leaders", "--verbose"});
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertTrue((boolean)output.contains("IsLeader: true"));
        Assertions.assertFalse((boolean)output.contains("IsLeader: false"));
    }

    @Test
    public void testLeadersExcluded() {
        String topic = "test-topic";
        String output = this.runCommand(new String[]{topic}, 1, new String[]{"--leaders", "exclude", "--verbose"});
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(28).append("Topic: ").append(topic).append("\nPartition: 0\nReplica").toString()));
        Assertions.assertFalse((boolean)output.contains("IsLeader: true"));
        Assertions.assertTrue((boolean)output.contains("IsLeader: false"));
    }

    @Test
    public void testObserversOnly() {
        String topic = "test-topic";
        String output = this.runCommand(new String[]{topic}, 1, new String[]{"--observers", "--verbose"});
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertTrue((boolean)output.contains("IsObserver: true"));
        Assertions.assertFalse((boolean)output.contains("IsObserver: false"));
    }

    @Test
    public void testObserversExcluded() {
        String topic = "test-topic";
        String output = this.runCommand(new String[]{topic}, 1, new String[]{"--observers", "exclude", "--verbose"});
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic).append("\nPartition: 0\nReplica: 2").toString()));
        Assertions.assertFalse((boolean)output.contains("IsObserver: true"));
        Assertions.assertTrue((boolean)output.contains("IsObserver: false"));
    }

    @Test
    public void testNotInIsr() {
        AdminClient adminClient;
        String topic = "test-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map assignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})))}));
        AdminClient adminClient2 = adminClient = (AdminClient)Admin.create((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava(ReplicaStatusCommandTest$.MODULE$.createConfig((Seq<KafkaServer>)this.servers())).asJava());
        adminClient = null;
        try (AdminClient resource_resource = adminClient2;){
            ReplicaStatusCommandTest.$anonfun$testNotInIsr$1(this, topic, assignments, topicPartition, resource_resource);
        }
    }

    private void runTestOutput(String[] args, boolean expectMirrorInfo) {
        List<ReplicaStatusEntry> entries = this.runCommandParseOutput(new String[]{"test-topic-1", "test-topic-2"}, 2, args, expectMirrorInfo);
        Assertions.assertEquals((int)12, (int)entries.size());
        Set tpr = (Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Set leaders = (Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        entries.foreach((Function1 & Serializable)entry -> {
            ReplicaStatusCommandTest.$anonfun$runTestOutput$1(this, tpr, leaders, entry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testOutput() {
        this.runTestOutput((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)), false);
    }

    @Test
    public void testOutputIncludeMirror() {
        this.runTestOutput(new String[]{"--include-mirror"}, true);
    }

    /*
     * Unable to fully structure code
     */
    private void runTestJson(String[] args, boolean expectClusterLink, boolean expectMirrorInfo) {
        topics = new String[]{"test-topic-1", "test-topic-2"};
        jsonTopics = ((JsonValue)Json$.MODULE$.parseFull(this.runCommand(topics, 2, args)).get()).asJsonArray().iterator();
        headers = ReplicaStatusCommand$.MODULE$.headers(expectClusterLink, expectMirrorInfo);
        topicsCount = 0;
        while (jsonTopics.hasNext()) {
            jsonTopic = ((JsonValue)jsonTopics.next()).asJsonObject();
            ++topicsCount;
            v0 = topic = (String)jsonTopic.apply("Topic").to((DecodeJson)DecodeJson.DecodeString$.MODULE$);
            var10_10 = "test-topic-1";
            if (v0 != null && v0.equals(var10_10)) ** GOTO lbl-1000
            v1 = topic;
            var11_11 = "test-topic-2";
            if (v1 != null && v1.equals(var11_11)) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            Assertions.assertTrue((boolean)v2);
            partitionsCount = 0;
            jsonPartitions = jsonTopic.apply("Partitions").asJsonArray().iterator();
            while (jsonPartitions.hasNext()) {
                jsonPartition = ((JsonValue)jsonPartitions.next()).asJsonObject();
                ++partitionsCount;
                partition = BoxesRunTime.unboxToInt((Object)jsonPartition.apply("Partition").to((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
                Assertions.assertTrue((boolean)(partition == 0 || partition == 1));
                replicasCount = 0;
                jsonReplicas = jsonPartition.apply("Replicas").asJsonArray().iterator();
                while (jsonReplicas.hasNext()) {
                    jsonReplica = ((JsonValue)jsonReplicas.next()).asJsonObject();
                    ++replicasCount;
                    replica = BoxesRunTime.unboxToInt((Object)jsonReplica.apply("Replica").to((DecodeJson)DecodeJson.DecodeInt$.MODULE$));
                    Assertions.assertTrue((boolean)(replica >= 0 && replica <= 2));
                    RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(3), headers.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)V, $anonfun$runTestJson$1(kafka.utils.json.JsonObject scala.collection.immutable.List int ), (I)V)((JsonObject)jsonReplica, (List)headers));
                }
                Assertions.assertTrue((boolean)(replicasCount == 3));
            }
            Assertions.assertTrue((boolean)(partitionsCount == 2));
        }
        Assertions.assertTrue((boolean)(topicsCount == 2));
    }

    @Test
    public void testJson() {
        this.runTestJson(new String[]{"--json"}, false, false);
    }

    @Test
    public void testJsonIncludeLinked() {
        this.runTestJson(new String[]{"--json", "--include-linked"}, true, false);
    }

    @Test
    public void testJsonIncludeMirror() {
        this.runTestJson(new String[]{"--json", "--include-mirror"}, false, true);
    }

    @Test
    public void testMissingArgs() {
        try {
            ReplicaStatusCommand$.MODULE$.main(new String[]{"--topics", "test-topic"});
            Assertions.fail();
            return;
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)throwable.getMessage().startsWith("Missing required option(s)"));
            return;
        }
    }

    private void testInvalidArgs(String[] args, String expectedErrorPrefixStr) {
        try {
            ReplicaStatusCommand$.MODULE$.main((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.bootstrapServers(this.listenerName())}), (Object)args, ClassTag$.MODULE$.apply(String.class)));
            Assertions.fail();
            return;
        }
        catch (Throwable throwable) {
            Assertions.assertTrue((boolean)throwable.getMessage().startsWith(expectedErrorPrefixStr));
            return;
        }
    }

    @Test
    public void testInvalidTopics() {
        this.testInvalidArgs(new String[]{"--topics"}, "Option topics requires an argument");
        this.testInvalidArgs(new String[]{"--topics", ""}, "Topic name");
        this.testInvalidArgs(new String[]{"--topics", "."}, "Topic name");
        this.testInvalidArgs(new String[]{"--topics", "invalid-1:topic"}, "Topic name");
    }

    @Test
    public void testInvalidPartitionsArg() {
        this.testInvalidRange$1("2-1");
        this.testInvalidRange$1("1-3-5");
        this.testInvalidValue$1("");
        this.testInvalidValue$1("abc");
    }

    private final void ReplicaStatusEntry$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicaStatusEntry$module == null) {
                this.ReplicaStatusEntry$module = new ReplicaStatusCommandTest$ReplicaStatusEntry$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndWait$3(TopicPartitionInfo x$1) {
        return x$1.leader() != null;
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndWait$2(AdminClient client$1, String topic$1) {
        TopicDescription topicDescription = (TopicDescription)((java.util.Map)client$1.describeTopics((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava()).allTopicNames().get()).get(topic$1);
        boolean bl = topicDescription == null ? false : CollectionConverters$.MODULE$.ListHasAsScala(topicDescription.partitions()).asScala().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStatusCommandTest.$anonfun$createTopicAndWait$3(x$1)));
        return bl;
    }

    public static final /* synthetic */ String $anonfun$createTopicAndWait$4() {
        return "Failed to create topic";
    }

    public static final /* synthetic */ String $anonfun$runCommand$1(ReplicaStatusCommandTest $this, String[] topics$1, int numPartitions$1, String[] args$1, AdminClient client) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])topics$1), (Function1 & Serializable)x$2 -> {
            $this.createTopicAndWait(client, x$2, Predef$.MODULE$.int2Integer(numPartitions$1));
            return BoxedUnit.UNIT;
        });
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> ReplicaStatusCommand$.MODULE$.main((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", $this.bootstrapServers($this.listenerName())}), (Object)args$1, ClassTag$.MODULE$.apply(String.class)));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        return grabConsoleOutput_out.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean toBoolean$1(String value) {
        switch (value == null ? 0 : value.hashCode()) {
            case 3569038: {
                if (!"true".equals(value)) throw new MatchError((Object)value);
                return true;
            }
            case 97196323: {
                if (!"false".equals(value)) throw new MatchError((Object)value);
                return false;
            }
            default: {
                throw new MatchError((Object)value);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final long toLong$1(String value) {
        void var1_1;
        long num = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(value));
        Assertions.assertTrue((num >= 0L ? 1 : 0) != 0);
        return (long)var1_1;
    }

    private static final Option toLongOption$1(String value) {
        String string = value;
        String string2 = "-1";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)ReplicaStatusCommandTest.toLong$1(value)));
    }

    private static final Option toMirrorState$1(String value) {
        String string = value;
        String string2 = "-";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return new Some((Object)value);
    }

    private static final Option toMirrorLongOption$1(String value) {
        block3: {
            block2: {
                String string = value;
                String string2 = "-";
                if (string != null && string.equals(string2)) break block2;
                String string3 = value;
                String string4 = "-1";
                if (string3 == null || !string3.equals(string4)) break block3;
            }
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToLong((long)ReplicaStatusCommandTest.toLong$1(value)));
    }

    public static final /* synthetic */ void $anonfun$testVerboseTopicPartitions$1(ReplicaStatusCommandTest $this, int numPartitions$2, String output$1, String topic) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numPartitions$2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)partition -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), $this.servers().size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)replica -> {
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(7).append("Topic: ").append(topic).toString()));
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(11).append("Partition: ").append(partition).toString()));
            Assertions.assertTrue((boolean)output$1.contains(new StringBuilder(9).append("Replica: ").append(replica).toString()));
        }));
    }

    public static final /* synthetic */ void $anonfun$testNotInIsr$1(ReplicaStatusCommandTest $this, String topic$3, scala.collection.immutable.Map assignments$1, TopicPartition topicPartition$1, AdminClient client) {
        TestUtils$.MODULE$.createTopic($this.zkClient(), topic$3, (Map<Object, Seq<Object>>)assignments$1, (Seq<KafkaServer>)$this.servers());
        ((KafkaServer)$this.servers().apply(1)).shutdown();
        TestUtils$.MODULE$.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition$1}))), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}))));
        TestUtils$.MODULE$.waitForLeaderToBecome((Admin)client, topicPartition$1, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)0)));
        TestUtils$.MODULE$.produceMessage($this.servers(), topic$3, "message", (Long)null, 30000, 20000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> ReplicaStatusCommand$.MODULE$.main(new String[]{"--bootstrap-server", $this.bootstrapServers($this.listenerName()), "--leaders", "exclude", "--verbose"});
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertFalse((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic$3).append("\nPartition: 0\nReplica: 0").toString()));
        Assertions.assertFalse((boolean)output.contains("IsInIsr: true"));
        Assertions.assertTrue((boolean)output.contains(new StringBuilder(31).append("Topic: ").append(topic$3).append("\nPartition: 0\nReplica: 1").toString()));
        Assertions.assertTrue((boolean)output.contains("IsInIsr: false"));
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$2(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$3(ReplicaStatusEntry entry$1, long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)entry$1.isCaughtUp());
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$4(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$runTestOutput$5(long value) {
        Assertions.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Option $anonfun$runTestOutput$6(ReplicaStatusEntry entry$1, long logStartOffset) {
        return entry$1.logEndOffset().map((Function1)(JFunction1.mcVJ.sp & Serializable)logEndOffset -> Assertions.assertTrue((logStartOffset <= logEndOffset ? 1 : 0) != 0));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$runTestOutput$1(ReplicaStatusCommandTest $this, Set tpr$1, Set leaders$1, ReplicaStatusEntry entry) {
        v0 = entry.topic();
        var4_4 = "test-topic-1";
        if (v0 != null && v0.equals(var4_4)) ** GOTO lbl-1000
        v1 = entry.topic();
        var5_5 = "test-topic-2";
        if (v1 != null && v1.equals(var5_5)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Assertions.assertTrue((boolean)v2);
        Assertions.assertTrue((boolean)(entry.partition() == 0 || entry.partition() == 1));
        Assertions.assertTrue((boolean)(entry.replica() >= 0 && entry.replica() < $this.servers().size()));
        Assertions.assertTrue((boolean)tpr$1.add((Object)new StringBuilder(2).append(entry.topic()).append("-").append(entry.partition()).append("-").append(entry.replica()).toString()));
        if (entry.isLeader()) {
            Assertions.assertTrue((boolean)leaders$1.add((Object)new StringBuilder(1).append(entry.topic()).append("-").append(entry.partition()).toString()));
            Assertions.assertTrue((boolean)entry.isInIsr());
            Assertions.assertTrue((boolean)entry.isCaughtUp());
            Assertions.assertNotEquals((Object)"\"N/A\"", (Object)entry.leaderEpoch());
        } else {
            Assertions.assertEquals((Object)"\"N/A\"", (Object)entry.leaderEpoch());
        }
        if (entry.replica() == 2) {
            Assertions.assertTrue((boolean)entry.isObserver());
            Assertions.assertFalse((boolean)entry.isIsrEligible());
        } else {
            Assertions.assertFalse((boolean)entry.isObserver());
            Assertions.assertTrue((boolean)entry.isIsrEligible());
            Assertions.assertTrue((boolean)entry.isInIsr());
        }
        entry.lastCaughtUpLagMs().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$2(long ), (J)V)());
        entry.lastFetchLagMs().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$3(kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry long ), (J)V)((ReplicaStatusEntry)entry));
        entry.logStartOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$4(long ), (J)V)());
        entry.logEndOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (J)V, $anonfun$runTestOutput$5(long ), (J)V)());
        entry.logStartOffset().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$runTestOutput$6$adapted(kafka.admin.ReplicaStatusCommandTest$ReplicaStatusEntry java.lang.Object ), (Ljava/lang/Object;)Lscala/Option;)((ReplicaStatusEntry)entry));
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorState());
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorLastFetchTimeMs());
        Assertions.assertEquals((Object)None$.MODULE$, entry.mirrorLastFetchHighWatermark());
    }

    public static final /* synthetic */ void $anonfun$runTestJson$1(JsonObject jsonReplica$1, List headers$2, int idx) {
        Assertions.assertTrue((jsonReplica$1.apply((String)headers$2.apply(idx)) != null ? 1 : 0) != 0);
    }

    private final void testInvalidRange$1(String partitionStr) {
        this.testInvalidArgs(new String[]{"--partitions", partitionStr}, "Invalid partition range");
    }

    private final void testInvalidValue$1(String partitionStr) {
        this.testInvalidArgs(new String[]{"--partitions", partitionStr}, "Failed to parse partition");
    }

    public static final /* synthetic */ Object $anonfun$testNotInIsr$1$adapted(ReplicaStatusCommandTest $this, String topic$3, scala.collection.immutable.Map assignments$1, TopicPartition topicPartition$1, AdminClient client) {
        ReplicaStatusCommandTest.$anonfun$testNotInIsr$1($this, topic$3, assignments$1, topicPartition$1, client);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Option $anonfun$runTestOutput$6$adapted(ReplicaStatusEntry entry$1, Object logStartOffset) {
        return ReplicaStatusCommandTest.$anonfun$runTestOutput$6(entry$1, BoxesRunTime.unboxToLong((Object)logStartOffset));
    }

    public class ReplicaStatusEntry
    implements Product,
    Serializable {
        private final String topic;
        private final int partition;
        private final int replica;
        private final boolean isLeader;
        private final boolean isObserver;
        private final boolean isIsrEligible;
        private final boolean isInIsr;
        private final boolean isCaughtUp;
        private final Option<Object> lastCaughtUpLagMs;
        private final Option<Object> lastFetchLagMs;
        private final Option<Object> logStartOffset;
        private final Option<Object> logEndOffset;
        private final String leaderEpoch;
        private final Option<String> mirrorState;
        private final Option<Object> mirrorLastFetchTimeMs;
        private final Option<Object> mirrorLastFetchHighWatermark;
        public final /* synthetic */ ReplicaStatusCommandTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String topic() {
            return this.topic;
        }

        public int partition() {
            return this.partition;
        }

        public int replica() {
            return this.replica;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public boolean isObserver() {
            return this.isObserver;
        }

        public boolean isIsrEligible() {
            return this.isIsrEligible;
        }

        public boolean isInIsr() {
            return this.isInIsr;
        }

        public boolean isCaughtUp() {
            return this.isCaughtUp;
        }

        public Option<Object> lastCaughtUpLagMs() {
            return this.lastCaughtUpLagMs;
        }

        public Option<Object> lastFetchLagMs() {
            return this.lastFetchLagMs;
        }

        public Option<Object> logStartOffset() {
            return this.logStartOffset;
        }

        public Option<Object> logEndOffset() {
            return this.logEndOffset;
        }

        public String leaderEpoch() {
            return this.leaderEpoch;
        }

        public Option<String> mirrorState() {
            return this.mirrorState;
        }

        public Option<Object> mirrorLastFetchTimeMs() {
            return this.mirrorLastFetchTimeMs;
        }

        public Option<Object> mirrorLastFetchHighWatermark() {
            return this.mirrorLastFetchHighWatermark;
        }

        public ReplicaStatusEntry copy(String topic, int partition, int replica, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, Option<Object> lastCaughtUpLagMs, Option<Object> lastFetchLagMs, Option<Object> logStartOffset, Option<Object> logEndOffset, String leaderEpoch, Option<String> mirrorState, Option<Object> mirrorLastFetchTimeMs, Option<Object> mirrorLastFetchHighWatermark) {
            return new ReplicaStatusEntry(this.kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer(), topic, partition, replica, isLeader, isObserver, isIsrEligible, isInIsr, isCaughtUp, lastCaughtUpLagMs, lastFetchLagMs, logStartOffset, logEndOffset, leaderEpoch, mirrorState, mirrorLastFetchTimeMs, mirrorLastFetchHighWatermark);
        }

        public String copy$default$1() {
            return this.topic();
        }

        public Option<Object> copy$default$10() {
            return this.lastFetchLagMs();
        }

        public Option<Object> copy$default$11() {
            return this.logStartOffset();
        }

        public Option<Object> copy$default$12() {
            return this.logEndOffset();
        }

        public String copy$default$13() {
            return this.leaderEpoch();
        }

        public Option<String> copy$default$14() {
            return this.mirrorState();
        }

        public Option<Object> copy$default$15() {
            return this.mirrorLastFetchTimeMs();
        }

        public Option<Object> copy$default$16() {
            return this.mirrorLastFetchHighWatermark();
        }

        public int copy$default$2() {
            return this.partition();
        }

        public int copy$default$3() {
            return this.replica();
        }

        public boolean copy$default$4() {
            return this.isLeader();
        }

        public boolean copy$default$5() {
            return this.isObserver();
        }

        public boolean copy$default$6() {
            return this.isIsrEligible();
        }

        public boolean copy$default$7() {
            return this.isInIsr();
        }

        public boolean copy$default$8() {
            return this.isCaughtUp();
        }

        public Option<Object> copy$default$9() {
            return this.lastCaughtUpLagMs();
        }

        public String productPrefix() {
            return "ReplicaStatusEntry";
        }

        public int productArity() {
            return 16;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.topic();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.partition());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this.replica());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isLeader());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isObserver());
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isIsrEligible());
                }
                case 6: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isInIsr());
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean((boolean)this.isCaughtUp());
                }
                case 8: {
                    return this.lastCaughtUpLagMs();
                }
                case 9: {
                    return this.lastFetchLagMs();
                }
                case 10: {
                    return this.logStartOffset();
                }
                case 11: {
                    return this.logEndOffset();
                }
                case 12: {
                    return this.leaderEpoch();
                }
                case 13: {
                    return this.mirrorState();
                }
                case 14: {
                    return this.mirrorLastFetchTimeMs();
                }
                case 15: {
                    return this.mirrorLastFetchHighWatermark();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicaStatusEntry;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "topic";
                }
                case 1: {
                    return "partition";
                }
                case 2: {
                    return "replica";
                }
                case 3: {
                    return "isLeader";
                }
                case 4: {
                    return "isObserver";
                }
                case 5: {
                    return "isIsrEligible";
                }
                case 6: {
                    return "isInIsr";
                }
                case 7: {
                    return "isCaughtUp";
                }
                case 8: {
                    return "lastCaughtUpLagMs";
                }
                case 9: {
                    return "lastFetchLagMs";
                }
                case 10: {
                    return "logStartOffset";
                }
                case 11: {
                    return "logEndOffset";
                }
                case 12: {
                    return "leaderEpoch";
                }
                case 13: {
                    return "mirrorState";
                }
                case 14: {
                    return "mirrorLastFetchTimeMs";
                }
                case 15: {
                    return "mirrorLastFetchHighWatermark";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.topic())), (int)this.partition()), (int)this.replica()), (int)(this.isLeader() ? 1231 : 1237)), (int)(this.isObserver() ? 1231 : 1237)), (int)(this.isIsrEligible() ? 1231 : 1237)), (int)(this.isInIsr() ? 1231 : 1237)), (int)(this.isCaughtUp() ? 1231 : 1237)), (int)Statics.anyHash(this.lastCaughtUpLagMs())), (int)Statics.anyHash(this.lastFetchLagMs())), (int)Statics.anyHash(this.logStartOffset())), (int)Statics.anyHash(this.logEndOffset())), (int)Statics.anyHash((Object)this.leaderEpoch())), (int)Statics.anyHash(this.mirrorState())), (int)Statics.anyHash(this.mirrorLastFetchTimeMs())), (int)Statics.anyHash(this.mirrorLastFetchHighWatermark())), (int)16);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ReplicaStatusEntry)) return false;
            if (((ReplicaStatusEntry)x$1).kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer() != this.kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ReplicaStatusEntry replicaStatusEntry = (ReplicaStatusEntry)x$1;
            if (this.partition() != replicaStatusEntry.partition()) return false;
            if (this.replica() != replicaStatusEntry.replica()) return false;
            if (this.isLeader() != replicaStatusEntry.isLeader()) return false;
            if (this.isObserver() != replicaStatusEntry.isObserver()) return false;
            if (this.isIsrEligible() != replicaStatusEntry.isIsrEligible()) return false;
            if (this.isInIsr() != replicaStatusEntry.isInIsr()) return false;
            if (this.isCaughtUp() != replicaStatusEntry.isCaughtUp()) return false;
            String string = this.topic();
            String string2 = replicaStatusEntry.topic();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Object> option = this.lastCaughtUpLagMs();
            Option<Object> option2 = replicaStatusEntry.lastCaughtUpLagMs();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.lastFetchLagMs();
            Option<Object> option4 = replicaStatusEntry.lastFetchLagMs();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            Option<Object> option5 = this.logStartOffset();
            Option<Object> option6 = replicaStatusEntry.logStartOffset();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Object> option7 = this.logEndOffset();
            Option<Object> option8 = replicaStatusEntry.logEndOffset();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            String string3 = this.leaderEpoch();
            String string4 = replicaStatusEntry.leaderEpoch();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option9 = this.mirrorState();
            Option<String> option10 = replicaStatusEntry.mirrorState();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            Option<Object> option11 = this.mirrorLastFetchTimeMs();
            Option<Object> option12 = replicaStatusEntry.mirrorLastFetchTimeMs();
            if (option11 == null) {
                if (option12 != null) {
                    return false;
                }
            } else if (!option11.equals(option12)) return false;
            Option<Object> option13 = this.mirrorLastFetchHighWatermark();
            Option<Object> option14 = replicaStatusEntry.mirrorLastFetchHighWatermark();
            if (option13 == null) {
                if (option14 != null) {
                    return false;
                }
            } else if (!option13.equals(option14)) return false;
            if (!replicaStatusEntry.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReplicaStatusCommandTest kafka$admin$ReplicaStatusCommandTest$ReplicaStatusEntry$$$outer() {
            return this.$outer;
        }

        public ReplicaStatusEntry(ReplicaStatusCommandTest $outer, String topic, int partition, int replica, boolean isLeader, boolean isObserver, boolean isIsrEligible, boolean isInIsr, boolean isCaughtUp, Option<Object> lastCaughtUpLagMs, Option<Object> lastFetchLagMs, Option<Object> logStartOffset, Option<Object> logEndOffset, String leaderEpoch, Option<String> mirrorState, Option<Object> mirrorLastFetchTimeMs, Option<Object> mirrorLastFetchHighWatermark) {
            this.topic = topic;
            this.partition = partition;
            this.replica = replica;
            this.isLeader = isLeader;
            this.isObserver = isObserver;
            this.isIsrEligible = isIsrEligible;
            this.isInIsr = isInIsr;
            this.isCaughtUp = isCaughtUp;
            this.lastCaughtUpLagMs = lastCaughtUpLagMs;
            this.lastFetchLagMs = lastFetchLagMs;
            this.logStartOffset = logStartOffset;
            this.logEndOffset = logEndOffset;
            this.leaderEpoch = leaderEpoch;
            this.mirrorState = mirrorState;
            this.mirrorLastFetchTimeMs = mirrorLastFetchTimeMs;
            this.mirrorLastFetchHighWatermark = mirrorLastFetchHighWatermark;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

