/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u00115b\u0001\u0002%J\u00019CQa\u0018\u0001\u0005\u0002\u0001DQA\u0019\u0001\u0005B\rDqA\u001d\u0001C\u0002\u0013%1\u000f\u0003\u0004y\u0001\u0001\u0006I\u0001\u001e\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0011\u0019q\b\u0001)A\u0005w\"Qq\u0010\u0001a\u0001\u0002\u0004%I!!\u0001\t\u0017\u0005}\u0001\u00011AA\u0002\u0013%\u0011\u0011\u0005\u0005\f\u0003[\u0001\u0001\u0019!A!B\u0013\t\u0019\u0001C\u0006\u00020\u0001\u0001\r\u00111A\u0005\n\u0005E\u0002bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001bB1\"!\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00024!Y\u00111\u000b\u0001A\u0002\u0003\u0007I\u0011BA+\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%I!!\u001b\t\u0017\u00055\u0004\u00011A\u0001B\u0003&\u0011q\u000b\u0005\t\u0003_\u0002\u0001\u0015\"\u0003\u0002r!A\u0011Q\u0010\u0001!\n\u0013\ty\bC\u0005\u0002\n\u0002\t\n\u0011\"\u0003\u0002\f\"9\u0011\u0011\u0015\u0001\u0005B\u0005\r\u0006bBAc\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0003#\u0004A\u0011AAj\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013AqAa\u0005\u0001\t\u0003\u0011)\u0002C\u0004\u0003 \u0001!\tA!\t\t\u000f\t-\u0002\u0001\"\u0001\u0003.!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B\"\u0001\u0011\u0005!Q\t\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0005;BqAa\u001a\u0001\t\u0003\u0011I\u0007C\u0004\u0003t\u0001!\tA!\u001e\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!1\u0012\u0001\u0005\u0002\t5\u0005b\u0002BL\u0001\u0011\u0005!\u0011\u0014\u0005\b\u0005G\u0003A\u0011\u0001BS\u0011\u001d\u0011y\u000b\u0001C\u0001\u0005cCqAa/\u0001\t\u0003\u0011i\fC\u0004\u0003H\u0002!\tA!3\t\u000f\tM\u0007\u0001\"\u0001\u0003V\"9!q\u001c\u0001\u0005\u0002\t\u0005\bb\u0002Bv\u0001\u0011\u0005!Q\u001e\u0005\b\u0005o\u0004A\u0011\u0001B}\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0007\u000bAqaa\u0004\u0001\t\u0003\u0019\t\u0002C\u0004\u0004\u001c\u0001!\ta!\b\t\u000f\r\u001d\u0002\u0001\"\u0001\u0004*!911\u0007\u0001\u0005\u0002\rU\u0002bBB \u0001\u0011\u00051\u0011\t\u0005\b\u0007\u0017\u0002A\u0011AB'\u0011\u001d\u00199\u0006\u0001C\u0001\u00073Bqaa\u0019\u0001\t\u0003\u0019)\u0007C\u0004\u0004p\u0001!\ta!\u001d\t\u000f\rm\u0004\u0001\"\u0001\u0004~!91q\u0011\u0001\u0005\u0002\r%\u0005bBBJ\u0001\u0011\u0005\u0011q\u0019\u0005\b\u0007;\u0003A\u0011AAd\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0003\u000fDqa!*\u0001\t\u0003\t9\rC\u0004\u0004*\u0002!\t!a2\t\u000f\r5\u0006\u0001\"\u0001\u0002H\"91\u0011\u0017\u0001\u0005\u0002\u0005\u001d\u0007bBB[\u0001\u0011\u00051q\u0017\u0005\b\u0007\u0003\u0004A\u0011ABb\u0011\u001d\u0019i\r\u0001C\u0001\u0007\u001fDqa!7\u0001\t\u0003\u0019Y\u000eC\u0004\u0004f\u0002!\taa:\t\u000f\rE\b\u0001\"\u0001\u0004t\"91Q \u0001\u0005\u0002\r}\bb\u0002C\u0005\u0001\u0011\u0005A1\u0002\u0005\b\t+\u0001A\u0011\u0001C\f\u0011\u001d!\t\u0003\u0001C\u0001\tG\u00111\u0004V8qS\u000e\u001cu.\\7b]\u0012Le\u000e^3he\u0006$\u0018n\u001c8UKN$(B\u0001&L\u0003\u0015\tG-\\5o\u0015\u0005a\u0015!B6bM.\f7\u0001A\n\u0005\u0001=+6\f\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0017\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0013\t!\u0016K\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t1\u0016,D\u0001X\u0015\tA6*A\u0003vi&d7/\u0003\u0002[/\n9Aj\\4hS:<\u0007C\u0001/^\u001b\u0005I\u0015B\u00010J\u00055\u0011\u0016mY6Bo\u0006\u0014X\rV3ti\u00061A(\u001b8jiz\"\u0012!\u0019\t\u00039\u0002\tqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002IB\u0019QM\u001b7\u000e\u0003\u0019T!a\u001a5\u0002\u0015\r|G\u000e\\3di&|gNC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tYgMA\u0002TKF\u0004\"!\u001c9\u000e\u00039T!a\\&\u0002\rM,'O^3s\u0013\t\thNA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00048v[B\u000b'\u000f^5uS>t7/F\u0001u!\t)h/D\u0001i\u0013\t9\bNA\u0002J]R\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\reK\u001a\fW\u000f\u001c;SKBd\u0017nY1uS>tg)Y2u_J,\u0012a\u001f\t\u0003krL!! 5\u0003\u000bMCwN\u001d;\u00023\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\ri>\u0004\u0018nY*feZL7-Z\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u001a9!\u0011qAA\u000b\u001d\u0011\tI!a\u0005\u000f\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u0004N\u0003\u0019a$o\\8u}%\tA*\u0003\u0002K\u0017&\u0019\u0011qC%\u0002\u0019Q{\u0007/[2D_6l\u0017M\u001c3\n\t\u0005m\u0011Q\u0004\u0002\r)>\u0004\u0018nY*feZL7-\u001a\u0006\u0004\u0003/I\u0015\u0001\u0005;pa&\u001c7+\u001a:wS\u000e,w\fJ3r)\u0011\t\u0019#!\u000b\u0011\u0007U\f)#C\u0002\u0002(!\u0014A!\u00168ji\"I\u00111\u0006\u0005\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014!\u0004;pa&\u001c7+\u001a:wS\u000e,\u0007%A\u0006bI6Lgn\u00117jK:$XCAA\u001a!\u0011\t)$a\u0012\u000e\u0005\u0005]\"b\u0001&\u0002:)!\u00111HA\u001f\u0003\u001d\u0019G.[3oiNT1\u0001TA \u0015\u0011\t\t%a\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t)%A\u0002pe\u001eLA!!\u0013\u00028\t)\u0011\tZ7j]\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005=\u0003\"CA\u0016\u0017\u0005\u0005\t\u0019AA\u001a\u00031\tG-\\5o\u00072LWM\u001c;!\u00035!Xm\u001d;U_BL7MT1nKV\u0011\u0011q\u000b\t\u0005\u00033\n\tG\u0004\u0003\u0002\\\u0005u\u0003cAA\u0006Q&\u0019\u0011q\f5\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019'!\u001a\u0003\rM#(/\u001b8h\u0015\r\ty\u0006[\u0001\u0012i\u0016\u001cH\u000fV8qS\u000et\u0015-\\3`I\u0015\fH\u0003BA\u0012\u0003WB\u0011\"a\u000b\u000f\u0003\u0003\u0005\r!a\u0016\u0002\u001dQ,7\u000f\u001e+pa&\u001cg*Y7fA\u0005\u00112M]3bi\u0016\fe\u000eZ,bSR$v\u000e]5d)\u0011\t\u0019#a\u001d\t\u000f\u0005U\u0004\u00031\u0001\u0002x\u0005!q\u000e\u001d;t!\u0011\t)!!\u001f\n\t\u0005m\u0014Q\u0004\u0002\u0014)>\u0004\u0018nY\"p[6\fg\u000eZ(qi&|gn]\u0001\u0014o\u0006LGOR8s)>\u0004\u0018nY\"sK\u0006$X\r\u001a\u000b\u0007\u0003G\t\t)!\"\t\u000f\u0005\r\u0015\u00031\u0001\u0002X\u0005IAo\u001c9jG:\u000bW.\u001a\u0005\t\u0003\u000f\u000b\u0002\u0013!a\u0001i\u00069A/[7f_V$\u0018!H<bSR4uN\u001d+pa&\u001c7I]3bi\u0016$G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055%f\u0001;\u0002\u0010.\u0012\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001c\"\f!\"\u00198o_R\fG/[8o\u0013\u0011\ty*!&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0003tKR,\u0006\u000f\u0006\u0003\u0002$\u0005\u0015\u0006bBAT'\u0001\u0007\u0011\u0011V\u0001\u0005S:4w\u000e\u0005\u0003\u0002,\u0006eVBAAW\u0015\u0011\ty+!-\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u00024\u0006U\u0016a\u00026va&$XM\u001d\u0006\u0005\u0003o\u000b\u0019%A\u0003kk:LG/\u0003\u0003\u0002<\u00065&\u0001\u0003+fgRLeNZ8)\u0007M\ty\f\u0005\u0003\u0002,\u0006\u0005\u0017\u0002BAb\u0003[\u0013!BQ3g_J,W)Y2i\u0003\u0015\u0019Gn\\:f)\t\t\u0019\u0003K\u0002\u0015\u0003\u0017\u0004B!a+\u0002N&!\u0011qZAW\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0006uKN$8I]3bi\u0016$B!a\t\u0002V\"9\u0011q[\u000bA\u0002\u0005]\u0013AB9v_J,X\u000eK\u0004\u0016\u00037\fY/!<\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002f\u0006E\u0016A\u00029be\u0006l7/\u0003\u0003\u0002j\u0006}'a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0002p\u0006M\u0018EAAy\u0003\tQ8.\t\u0002\u0002v\u0006)1N]1gi\":Q#!?\u0003\u0002\t\r\u0001\u0003BA~\u0003{l!!a9\n\t\u0005}\u00181\u001d\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\u00028b[\u0016\f#A!\u0002\u00021m$\u0017n\u001d9mCft\u0015-\\3~]E,xN];n{m\u0004T0\u0001\fuKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;t)\u0011\t\u0019Ca\u0003\t\u000f\u0005]g\u00031\u0001\u0002X!:a#a7\u0002l\n=A\u0006BAx\u0003gDsAFA}\u0005\u0003\u0011\u0019!\u0001\u0011uKN$8I]3bi\u0016<\u0016\u000e\u001e5EK\u001a\fW\u000f\u001c;SKBd\u0017nY1uS>tG\u0003BA\u0012\u0005/Aq!a6\u0018\u0001\u0004\t9\u0006K\u0004\u0018\u00037\fYOa\u0007-\t\u0005=\u00181\u001f\u0015\b/\u0005e(\u0011\u0001B\u0002\u0003}!Xm\u001d;De\u0016\fG/Z,ji\"$UMZ1vYR\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003G\u0011\u0019\u0003C\u0004\u0002Xb\u0001\r!a\u0016)\u000fa\tY.a;\u0003(1\"\u0011q^AzQ\u001dA\u0012\u0011 B\u0001\u0005\u0007\tQ\u0003^3ti\u000e\u0013X-\u0019;f/&$\bnQ8oM&<7\u000f\u0006\u0003\u0002$\t=\u0002bBAl3\u0001\u0007\u0011q\u000b\u0015\b3\u0005m\u00171\u001eB\u001aY\u0011\ty/a=)\u000fe\tIP!\u0001\u0003\u0004\u0005YB/Z:u\u0007J,\u0017\r^3XQ\u0016t\u0017\t\u001c:fC\u0012LX\t_5tiN$B!a\t\u0003<!9\u0011q\u001b\u000eA\u0002\u0005]\u0003f\u0002\u000e\u0002\\\u0006-(q\b\u0017\u0005\u0003_\f\u0019\u0010K\u0004\u001b\u0003s\u0014\tAa\u0001\u0002UQ,7\u000f^\"sK\u0006$Xm\u00165f]\u0006c'/Z1es\u0016C\u0018n\u001d;t/&$\b.\u00134O_R,\u00050[:ugR!\u00111\u0005B$\u0011\u001d\t9n\u0007a\u0001\u0003/BsaGAn\u0003W\u0014Y\u0005\f\u0003\u0002p\u0006M\bfB\u000e\u0002z\n\u0005!1A\u0001 i\u0016\u001cHo\u0011:fCR,w+\u001b;i%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$H\u0003BA\u0012\u0005'Bq!a6\u001d\u0001\u0004\t9\u0006K\u0004\u001d\u00037\fYOa\u0016-\t\u0005=\u00181\u001f\u0015\b9\u0005e(\u0011\u0001B\u0002\u0003\u0019\"Xm\u001d;De\u0016\fG/Z,ji\"LeN^1mS\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u000b\u0005\u0003G\u0011y\u0006C\u0004\u0002Xv\u0001\r!a\u0016)\u000fu\tY.a;\u0003d1\"\u0011q^AzQ\u001di\u0012\u0011 B\u0001\u0005\u0007\tq\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;peR!\u00111\u0005B6\u0011\u001d\t9N\ba\u0001\u0003/BsAHAn\u0003W\u0014y\u0007\f\u0003\u0002p\u0006M\bf\u0002\u0010\u0002z\n\u0005!1A\u0001%i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u001d\u0016<\u0017\r^5wKB\u000b'\u000f^5uS>t7i\\;oiR!\u00111\u0005B<\u0011\u001d\t9n\ba\u0001\u0003/BsaHAn\u0003W\u0014Y\b\f\u0003\u0002p\u0006M\bfB\u0010\u0002z\n\u0005!1A\u0001\u001ci\u0016\u001cH/\u00138wC2LG\rV8qS\u000edUM^3m\u0007>tg-[4\u0015\t\u0005\r\"1\u0011\u0005\b\u0003/\u0004\u0003\u0019AA,Q\u001d\u0001\u00131\\Av\u0005\u000fcC!a<\u0002t\":\u0001%!?\u0003\u0002\t\r\u0011A\u0004;fgRd\u0015n\u001d;U_BL7m\u001d\u000b\u0005\u0003G\u0011y\tC\u0004\u0002X\u0006\u0002\r!a\u0016)\u000f\u0005\nY.a;\u0003\u00142\"\u0011q^AzQ\u001d\t\u0013\u0011 B\u0001\u0005\u0007\tQ\u0004^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ&s7\r\\;eK2K7\u000f\u001e\u000b\u0005\u0003G\u0011Y\nC\u0004\u0002X\n\u0002\r!a\u0016)\u000f\t\nY.a;\u0003 2\"\u0011q^AzQ\u001d\u0011\u0013\u0011 B\u0001\u0005\u0007\t\u0011\u0005^3ti2K7\u000f\u001e+pa&\u001c7oV5uQ\u0016C8\r\\;eK&sG/\u001a:oC2$B!a\t\u0003(\"9\u0011q[\u0012A\u0002\u0005]\u0003fB\u0012\u0002\\\u0006-(1\u0016\u0017\u0005\u0003_\f\u0019\u0010K\u0004$\u0003s\u0014\tAa\u0001\u0002/Q,7\u000f^!mi\u0016\u0014\b+\u0019:uSRLwN\\\"pk:$H\u0003BA\u0012\u0005gCq!a6%\u0001\u0004\t9\u0006K\u0004%\u00037\fYOa.-\t\u0005=\u00181\u001f\u0015\bI\u0005e(\u0011\u0001B\u0002\u0003M!Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u)\u0011\t\u0019Ca0\t\u000f\u0005]W\u00051\u0001\u0002X!:Q%a7\u0002l\n\rG\u0006BAx\u0003gDs!JA}\u0005\u0003\u0011\u0019!A\u001auKN$\u0018\t\u001c;fe\u0006\u001b8/[4o[\u0016tGoV5uQ6{'/Z!tg&<g.\\3oiRC\u0017M\u001c)beRLG/[8ogR!\u00111\u0005Bf\u0011\u001d\t9N\na\u0001\u0003/BsAJAn\u0003W\u0014y\r\f\u0003\u0002p\u0006M\bf\u0002\u0014\u0002z\n\u0005!1A\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]R$B!a\t\u0003X\"9\u0011q[\u0014A\u0002\u0005]\u0003fB\u0014\u0002\\\u0006-(1\u001c\u0017\u0005\u0003_\f\u0019\u0010K\u0004(\u0003s\u0014\tAa\u0001\u0002EQ,7\u000f^!mi\u0016\u0014x+\u001b;i\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u)\u0011\t\u0019Ca9\t\u000f\u0005]\u0007\u00061\u0001\u0002X!:\u0001&a7\u0002l\n\u001dH\u0006BAx\u0003gDs\u0001KA}\u0005\u0003\u0011\u0019!A\u000fuKN$\u0018\t\u001c;fe^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u)\u0011\t\u0019Ca<\t\u000f\u0005]\u0017\u00061\u0001\u0002X!:\u0011&a7\u0002l\nMH\u0006BAx\u0003gDs!KA}\u0005\u0003\u0011\u0019!A\u0015uKN$\u0018\t\u001c;fe^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:u/&$\b.\u00134Fq&\u001cHo\u001d\u000b\u0005\u0003G\u0011Y\u0010C\u0004\u0002X*\u0002\r!a\u0016)\u000f)\nY.a;\u0003\u00002\"\u0011q^AzQ\u001dQ\u0013\u0011 B\u0001\u0005\u0007\t\u0011\u0005^3ti\u000e\u0013X-\u0019;f\u00032$XM\u001d+pa&\u001cw+\u001b;i%\u0006\u001c7.Q<be\u0016$B!a\t\u0004\b!9\u0011q[\u0016A\u0002\u0005]\u0003fB\u0016\u0002\\\u0006-81\u0002\u0017\u0005\u0003_\f\u0019\u0010K\u0004,\u0003s\u0014\tAa\u0001\u0002_Q,7\u000f^\"p]\u001aLw\r\u0015:fg\u0016\u0014h/\u0019;j_:\f5M]8tgB\u000b'\u000f^5uS>t\u0017\t\u001c;fe\u0006$\u0018n\u001c8\u0015\t\u0005\r21\u0003\u0005\b\u0003/d\u0003\u0019AA,Q\u001da\u00131\\Av\u0007/aC!a<\u0002t\":A&!?\u0003\u0002\t\r\u0011!\u0005;fgR$v\u000e]5d\t\u0016dW\r^5p]R!\u00111EB\u0010\u0011\u001d\t9.\fa\u0001\u0003/Bs!LAn\u0003W\u001c\u0019\u0003\f\u0003\u0002p\u0006M\bfB\u0017\u0002z\n\u0005!1A\u0001\u0018i\u0016\u001cH\u000fR3mKR,\u0017J\u001c;fe:\fG\u000eV8qS\u000e$B!a\t\u0004,!9\u0011q\u001b\u0018A\u0002\u0005]\u0003f\u0002\u0018\u0002\\\u0006-8q\u0006\u0017\u0005\u0003_\f\u0019\u0010K\u0004/\u0003s\u0014\tAa\u0001\u0002=Q,7\u000f\u001e#fY\u0016$Xm\u00165f]R{\u0007/[2E_\u0016\u001ch\u000e^#ySN$H\u0003BA\u0012\u0007oAq!a60\u0001\u0004\t9\u0006K\u00040\u00037\fYoa\u000f-\t\u0005=\u00181\u001f\u0015\b_\u0005e(\u0011\u0001B\u0002\u0003)\"Xm\u001d;EK2,G/Z,iK:$v\u000e]5d\t>,7O\u001c;Fq&\u001cHoV5uQ&3W\t_5tiN$B!a\t\u0004D!9\u0011q\u001b\u0019A\u0002\u0005]\u0003f\u0002\u0019\u0002\\\u0006-8q\t\u0017\u0005\u0003_\f\u0019\u0010K\u00041\u0003s\u0014\tAa\u0001\u0002\u0019Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3\u0015\t\u0005\r2q\n\u0005\b\u0003/\f\u0004\u0019AA,Q\u001d\t\u00141\\Av\u0007'bC!a<\u0002t\":\u0011'!?\u0003\u0002\t\r\u0011\u0001\t;fgR$Um]2sS\n,w\u000b[3o)>\u0004\u0018n\u0019#pKNtG/\u0012=jgR$B!a\t\u0004\\!9\u0011q\u001b\u001aA\u0002\u0005]\u0003f\u0002\u001a\u0002\\\u0006-8q\f\u0017\u0005\u0003_\f\u0019\u0010K\u00043\u0003s\u0014\tAa\u0001\u0002YQ,7\u000f\u001e#fg\u000e\u0014\u0018NY3XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f^,ji\"Le-\u0012=jgR\u001cH\u0003BA\u0012\u0007OBq!a64\u0001\u0004\t9\u0006K\u00044\u00037\fYoa\u001b-\t\u0005=\u00181\u001f\u0015\bg\u0005e(\u0011\u0001B\u0002\u0003\u0005\"Xm\u001d;EKN\u001c'/\u001b2f+:\fg/Y5mC\ndW\rU1si&$\u0018n\u001c8t)\u0011\t\u0019ca\u001d\t\u000f\u0005]G\u00071\u0001\u0002X!:A'a7\u0002l\u000e]D\u0006BAx\u0003gDs\u0001NA}\u0005\u0003\u0011\u0019!A\u0013uKN$H)Z:de&\u0014W-\u00168eKJ\u0014V\r\u001d7jG\u0006$X\r\u001a)beRLG/[8ogR!\u00111EB@\u0011\u001d\t9.\u000ea\u0001\u0003/Bs!NAn\u0003W\u001c\u0019\t\f\u0003\u0002p\u0006M\bfB\u001b\u0002z\n\u0005!1A\u0001\"i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003G\u0019Y\tC\u0004\u0002XZ\u0002\r!a\u0016)\u000fY\nY.a;\u0004\u00102\"\u0011q^AzQ\u001d1\u0014\u0011 B\u0001\u0005\u0007\tA\u0005^3ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3PEN,'O^3s\u0007>,h\u000e\u001e\u0015\u0004o\r]\u0005\u0003BAV\u00073KAaa'\u0002.\n!A+Z:u\u0003\u001d\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.\u00138wC2LGmU=oGJ+\u0007\u000f\\5dC\u000e{WO\u001c;)\u0007a\u001a9*\u0001\u0014uKN$H)Z:de&\u0014WmV5uQ&sg/\u00197jINKhn\u0019*fa2L7-\u0019*bG.D3!OBL\u0003\r\"Xm\u001d;EKN\u001c'/\u001b2f/&$\b.\u00138wC2LGm\u00142tKJ4XM\u001d*bG.D3AOBL\u0003\t\"Xm\u001d;EKN\u001c'/\u001b2f/&$\bnU=oGJ+\u0007\u000f\\5dC>3g\r\\5oK\"\u001a1ha&\u0002?Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3XSRDwJY:feZ,'o\u00144gY&tW\rK\u0002=\u0007/\u000b\u0011\u0006^3ti\u0012+7o\u0019:jE\u0016<\u0016\u000e\u001e5D_J\u0014Xm\u0019;msBc\u0017mY3e!\u0006\u0014H/\u001b;j_:\u001c\bfA\u001f\u0004\u0018\u0006\tE/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn],iK:\u0014V-Y:tS\u001etW.\u001a8u\u0013NLe\u000e\u0015:pOJ,7o\u001d\u000b\u0005\u0003G\u0019I\fC\u0004\u0002Xz\u0002\r!a\u0016)\u000fy\nY.a;\u0004>2\"\u0011q^AzQ\u001dq\u0014\u0011 B\u0001\u0005\u0007\ta\u0004^3ti\u0012+7o\u0019:jE\u0016\fE/T5o\u0013N\u0014\b+\u0019:uSRLwN\\:\u0015\t\u0005\r2Q\u0019\u0005\b\u0003/|\u0004\u0019AA,Q\u001dy\u00141\\Av\u0007\u0013dC!a<\u0002t\":q(!?\u0003\u0002\t\r\u0011A\n;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001cX*\u001b=fIR!\u00111EBi\u0011\u001d\t9\u000e\u0011a\u0001\u0003/Bs\u0001QAn\u0003W\u001c)\u000e\f\u0003\u0002p\u0006M\bf\u0002!\u0002z\n\u0005!1A\u0001$i\u0016\u001cH\u000fR3tGJL'-\u001a*fa>\u0014Ho\u0014<feJLG\rZ3o\u0007>tg-[4t)\u0011\t\u0019c!8\t\u000f\u0005]\u0017\t1\u0001\u0002X!:\u0011)a7\u0002l\u000e\u0005H\u0006BAx\u0003gDs!QA}\u0005\u0003\u0011\u0019!\u0001\u0018uKN$H)Z:de&\u0014W-\u00118e\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i_V$\u0018J\u001c;fe:\fG\u000eV8qS\u000e\u001cH\u0003BA\u0012\u0007SDq!a6C\u0001\u0004\t9\u0006K\u0004C\u00037\fYo!<-\t\u0005=\u00181\u001f\u0015\b\u0005\u0006e(\u0011\u0001B\u0002\u0003q\"Xm\u001d;EKN\u001c'/\u001b2f\t>,7OT8u\r\u0006LGn\u00165f]2K7\u000f^5oOJ+\u0017m]:jO:lWM\u001c;JgVs\u0017-\u001e;i_JL'0\u001a3\u0015\t\u0005\r2Q\u001f\u0005\b\u0003/\u001c\u0005\u0019AA,Q\u001d\u0019\u00151\\Av\u0007sdC!a<\u0002t\":1)!?\u0003\u0002\t\r\u0011\u0001\t;fgR\u001c%/Z1uK^KG\u000f\u001b+pa&\u001cg*Y7f\u0007>dG.[:j_:$B!a\t\u0005\u0002!9\u0011q\u001b#A\u0002\u0005]\u0003f\u0002#\u0002\\\u0006-HQ\u0001\u0017\u0005\u0003_\f\u0019\u0010K\u0004E\u0003s\u0014\tAa\u0001\u0002wQ,7\u000f^\"sK\u0006$X\rV8qS\u000e$u.Z:O_R\u0014V\r\u001e:z)\"\u0014x\u000e\u001e;mS:<\u0017+^8uC\u0016C8-Z3eK\u0012,\u0005pY3qi&|g\u000e\u0006\u0003\u0002$\u00115\u0001bBAl\u000b\u0002\u0007\u0011q\u000b\u0015\b\u000b\u0006m\u00171\u001eC\tY\u0011\ty/a=)\u000f\u0015\u000bIP!\u0001\u0003\u0004\u0005YD/Z:u\t\u0016dW\r^3U_BL7\rR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8\u0015\t\u0005\rB\u0011\u0004\u0005\b\u0003/4\u0005\u0019AA,Q\u001d1\u00151\\Av\t;aC!a<\u0002t\":a)!?\u0003\u0002\t\r\u0011\u0001\u0011;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8\u0015\t\u0005\rBQ\u0005\u0005\b\u0003/<\u0005\u0019AA,Q\u001d9\u00151\\Av\tSaC!a<\u0002t\":q)!?\u0003\u0002\t\r\u0001")
public class TopicCommandIntegrationTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.TopicService topicService;
    private Admin adminClient;
    private String testTopicName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        String x$2 = this.zkConnectOrNull();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        int n2 = 0;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5, n2).map((Function1 & Serializable)props -> {
            props.put(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "1");
            return KafkaConfig$.MODULE$.fromProps(props);
        });
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.TopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.TopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), 10000);
    }

    private void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitForPartitionMetadata(this.brokers(), topicName, 0, timeout);
    }

    private int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo info) {
        super.setUp(info);
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_3 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        this.testTopicName_$eq(new StringBuilder(1).append(((Method)info.getTestMethod().get()).getName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @AfterEach
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreate(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaults(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultReplication(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)2);
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)this.defaultReplicationFactor());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithDefaultPartitions(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)partitions.size(), (int)this.numPartitions());
        Assertions.assertEquals((int)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (int)2);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithConfigs(String quorum) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertEquals((int)1000, (Integer)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExists(String quorum) {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions.assertThrows(TopicExistsException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWhenAlreadyExistsWithIfNotExists(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-not-exists"});
        this.createAndWaitTopic(createOpts);
        this.topicService().createTopic(createOpts);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithReplicaAssignment(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithInvalidReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", Integer.toString(32768), "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativeReplicationFactor(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithNegativePartitionCount(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidTopicLevelConfig(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions.assertThrows(ConfigException.class, () -> this.topicService().createTopic(createOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithIncludeList(String quorum) {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic(topic2, 2, (short)2), new NewTopic(topic3, 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        this.waitForTopicCreated(topic2, 10000);
        this.waitForTopicCreated(topic3, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertTrue((boolean)output.contains(topic2));
        Assertions.assertFalse((boolean)output.contains(topic3));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testListTopicsWithExcludeInternal(String quorum) {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic1, 2, (short)2), new NewTopic("__consumer_offsets", 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(topic1));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterPartitionCount(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignment(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testAlterAssignment$1(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).topicNameValues().get(this.testTopicName())).get();
        Assertions.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)CollectionConverters$.MODULE$.ListHasAsScala(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala().map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id())));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMoreAssignmentThanPartitions(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterAssignmentWithMorePartitionsThanAssignment(String quorum) {
        this.adminClient().createTopics(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(this.testTopicName(), 2, (short)2)}))).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWithInvalidPartitionCount(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions.assertThrows(ExecutionException.class, () -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicService topicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(apply_adminClient);
        Object var4_3 = null;
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        Assertions.assertThrows(IllegalArgumentException.class, () -> topicService3.alterTopic(alterOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testAlterWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1", "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateAlterTopicWithRackAware(String quorum) {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitions), "--replication-factor", Integer.toString(replicationFactor), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(alteredNumPartitions), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$3(this, alteredNumPartitions)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Timeout waiting for new assignment propagating to broker");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        assignment = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).get(this.testTopicName())).partitions()).asScala().map((Function1 & Serializable)info -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)info.partition())), CollectionConverters$.MODULE$.ListHasAsScala(info.replicas()).asScala().map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.id()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testConfigPreservationAcrossPartitionAlteration(String quorum) {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsOriginal), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        Config props = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)props.get(cleanupKey), (String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)props.get(cleanupKey).value(), (String)"Properties after creation have incorrect value");
        if (!this.isKRaftTest()) {
            this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        }
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", Integer.toString(numPartitionsModified), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Config newProps = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assertions.assertNotNull((Object)newProps.get(cleanupKey), (String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString());
        Assertions.assertEquals((Object)cleanupVal, (Object)newProps.get(cleanupKey).value(), (String)"Updated properties have incorrect value");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testTopicDeletion(String quorum) {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        if (!this.isKRaftTest()) {
            String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deletePath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), this.testTopicName(), 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteInternalTopic(String quorum) {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        if (!this.isKRaftTest()) {
            Assertions.assertFalse((boolean)this.zkClient().pathExists(deleteOffsetTopicPath), (String)"Delete path for topic shouldn't exist before deletion.");
        }
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClientOrNull(), "__consumer_offsets", 1, this.brokers());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExist(String quorum) {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().deleteTopic(deleteOpts));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribe(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)3, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExist(String quorum) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeWhenTopicDoesntExistWithIfExists(String quorum) {
        this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--if-exists"}));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnavailablePartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            TopicDescription testTopicDescription = (TopicDescription)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).allTopicNames().get()).asScala().apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDescription.partitions()).asScala().find((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$1(x$13))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$7(this));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var8_7 = null;
            Object var9_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitions(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBrokerById(0);
            Buffer aliveServers = (Buffer)this.brokers().filterNot((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$17)));
            if (this.isKRaftTest()) {
                TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, this.testTopicName(), 0, 15000L);
            } else {
                void waitForPartitionMetadataCondition_condition;
                void waitForPartitionMetadataCondition_partition;
                long l = 15000L;
                Function1 & Serializable intersect = (Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitions$2(x$18));
                boolean bl = false;
                String waitForPartitionMetadataCondition_topic = this.testTopicName();
                long l2 = 100L;
                long waitForPartitionMetadataCondition_waitUntilTrue_startTime = System.currentTimeMillis();
                while (!aliveServers.forall(arg_0 -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$2$adapted(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition, (Function1)waitForPartitionMetadataCondition_condition, arg_0))) {
                    if (System.currentTimeMillis() > waitForPartitionMetadataCondition_waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TestUtils$.$anonfun$waitForPartitionMetadataCondition$3(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition, l));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                UpdateMetadataRequestData.UpdateMetadataPartitionState cfr_ignored_0 = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)aliveServers.head()).metadataCache().getPartitionInfo(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition).getOrElse(() -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$4(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition));
                Object var4_6 = null;
                intersect = null;
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var11_9 = null;
            Object var12_10 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.brokers().filterNot((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$19)));
            if (this.isKRaftTest()) {
                TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, this.testTopicName(), 0, 15000L);
            } else {
                void waitForPartitionMetadataCondition_condition;
                void waitForPartitionMetadataCondition_partition;
                long l = 15000L;
                Function1 & Serializable intersect = (Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitions$2(x$20));
                boolean bl = false;
                String waitForPartitionMetadataCondition_topic = this.testTopicName();
                long l2 = 100L;
                long waitForPartitionMetadataCondition_waitUntilTrue_startTime = System.currentTimeMillis();
                while (!aliveServers.forall(arg_0 -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$2$adapted(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition, (Function1)waitForPartitionMetadataCondition_condition, arg_0))) {
                    if (System.currentTimeMillis() > waitForPartitionMetadataCondition_waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TestUtils$.$anonfun$waitForPartitionMetadataCondition$3(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition, l));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                UpdateMetadataRequestData.UpdateMetadataPartitionState cfr_ignored_0 = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)aliveServers.head()).metadataCache().getPartitionInfo(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition).getOrElse(() -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$4(waitForPartitionMetadataCondition_topic, (int)waitForPartitionMetadataCondition_partition));
                Object var5_7 = null;
                intersect = null;
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var12_10 = null;
            Object var13_11 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeWithInvalidObserverCount() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}"));
        String placementJson2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, AlterConfigOp.OpType.SET).all().get();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWithInvalidSyncReplicaCount() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}"));
        String placementJson2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack3\"\n        |    }\n        |  }]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, AlterConfigOp.OpType.SET).all().get();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWithInvalidSyncReplicaRack() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        String placementJson2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, AlterConfigOp.OpType.SET).all().get();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWithInvalidObserverRack() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        String placementJson2 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 1,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        Properties configUpdate = new Properties();
        configUpdate.setProperty("confluent.placement.constraints", placementJson2);
        TestUtils$.MODULE$.incrementalAlterTopicConfigs(this.adminClient(), this.testTopicName(), configUpdate, AlterConfigOp.OpType.SET).all().get();
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
    }

    @Test
    public void testDescribeWithSyncReplicaOffline() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    },\n        |    {\n        |      \"count\": 1,\n        |      \"constraints\": {\n        |        \"rack\": \"rack2\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandIntegrationTest.$anonfun$testDescribeWithSyncReplicaOffline$1(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    Assertions.fail((String)"--invalid-replica-placement-partitions did not return the correct topic after the broker was killed");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
            }
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeWithObserverOffline() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(5);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_3 = null;
            Object var5_4 = null;
            Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @Test
    public void testDescribeWithCorrectlyPlacedPartitions() {
        String placementJson1 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("{\n        | \"version\": 1,\n        |  \"replicas\": [{\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack1\"\n        |      }\n        |    }\n        |  ],\n        |  \"observers\": [{\n        |    \"count\": 2,\n        |    \"constraints\": {\n        |      \"rack\": \"rack2\"\n        |     }\n        |   },\n        |    {\n        |      \"count\": 2,\n        |      \"constraints\": {\n        |        \"rack\": \"rack3\"\n        |      }\n        |    }\n        |  ]\n        |}"));
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("confluent.placement.constraints", placementJson1);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty()).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var4_3 = null;
        Object var5_4 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((Object)"", (Object)rows[0]);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress(String quorum) {
        String string;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.brokers().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$21)));
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).allTopicNames().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)CollectionConverters$.MODULE$.ListHasAsScala(testTopicDesc.partitions()).asScala().head();
        Buffer replicasOfFirstPartition = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(firstPartition.replicas()).asScala().map((Function1 & Serializable)x$22 -> BoxesRunTime.boxToInteger((int)x$22.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(Predef$.MODULE$.int2Integer(targetReplica)))))).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Reassignment didn't add the second node");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var16_14 = null;
        Object var17_15 = null;
        Object[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(simpleDescribeOutputRows)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var19_18 = null;
        Object var20_19 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assertions.assertEquals((Object)"", (Object)underReplicatedOutput, (String)new StringBuilder(59).append("--under-replicated-partitions shouldn't return anything: '").append(underReplicatedOutput).append("'").toString());
        PartitionReassignment reassignments = (PartitionReassignment)((java.util.Map)this.adminClient().listPartitionReassignments(Collections.singleton(tp)).reassignments().get()).get(tp);
        Assertions.assertFalse((boolean)Option$.MODULE$.apply((Object)reassignments).forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(x$23))));
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAtMinIsrPartitions(String quorum) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var5_3 = null;
            Object var6_4 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assertions.assertEquals((int)1, (int)rows.length);
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeUnderMinIsrPartitionsMixed(String quorum) {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList(Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, 10000);
        this.waitForTopicCreated(notUnderMinIsrTopic, 10000);
        this.waitForTopicCreated(offlineTopic, 10000);
        this.waitForTopicCreated(fullyReplicatedTopic, 10000);
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.brokers().filterNot((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$24)));
            if (this.isKRaftTest()) {
                TestUtils$.MODULE$.waitForPartitionMetadata(aliveServers, underMinIsrTopic, 0, 15000L);
            } else {
                void waitForPartitionMetadataCondition_condition;
                void waitForPartitionMetadataCondition_condition2;
                long l = 15000L;
                Function1 & Serializable intersect = (Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$2(x$25));
                int waitForPartitionMetadataCondition_partition = 0;
                long l2 = 100L;
                long waitForPartitionMetadataCondition_waitUntilTrue_startTime = System.currentTimeMillis();
                while (!aliveServers.forall(arg_0 -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$2$adapted(underMinIsrTopic, waitForPartitionMetadataCondition_partition, (Function1)waitForPartitionMetadataCondition_condition2, arg_0))) {
                    if (System.currentTimeMillis() > waitForPartitionMetadataCondition_waitUntilTrue_startTime + l) {
                        Assertions.fail((String)TestUtils$.$anonfun$waitForPartitionMetadataCondition$3(underMinIsrTopic, waitForPartitionMetadataCondition_partition, l));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
                }
                UpdateMetadataRequestData.UpdateMetadataPartitionState cfr_ignored_0 = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)aliveServers.head()).metadataCache().getPartitionInfo(underMinIsrTopic, waitForPartitionMetadataCondition_partition).getOrElse(() -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$4(underMinIsrTopic, waitForPartitionMetadataCondition_partition));
                intersect = null;
                long l3 = 15000L;
                Function1 & Serializable intersect2 = (Function1 & Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$3(x$26));
                int waitForPartitionMetadataCondition_partition2 = 0;
                long l4 = 100L;
                long waitForPartitionMetadataCondition_waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!aliveServers.forall(arg_0 -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$2$adapted(offlineTopic, waitForPartitionMetadataCondition_partition2, (Function1)waitForPartitionMetadataCondition_condition, arg_0))) {
                    if (System.currentTimeMillis() > waitForPartitionMetadataCondition_waitUntilTrue_startTime2 + l3) {
                        Assertions.fail((String)TestUtils$.$anonfun$waitForPartitionMetadataCondition$3(offlineTopic, waitForPartitionMetadataCondition_partition2, l3));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l3), l4));
                }
                UpdateMetadataRequestData.UpdateMetadataPartitionState cfr_ignored_1 = (UpdateMetadataRequestData.UpdateMetadataPartitionState)((KafkaBroker)aliveServers.head()).metadataCache().getPartitionInfo(offlineTopic, waitForPartitionMetadataCondition_partition2).getOrElse(() -> TestUtils$.$anonfun$waitForPartitionMetadataCondition$4(offlineTopic, waitForPartitionMetadataCondition_partition2));
                intersect2 = null;
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var22_18 = null;
            Object var23_19 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assertions.assertEquals((int)2, (int)rows.length, (String)"not enough rows returned by --under-min-isr-partitions");
            Assertions.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assertions.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
        }
        finally {
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeReportOverriddenConfigs(String quorum) {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(config), (String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeAndListTopicsWithoutInternalTopics(String quorum) {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_2 = null;
        Object var4_3 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()), (String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString());
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assertions.assertTrue((boolean)output.contains(this.testTopicName()));
        Assertions.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized(String quorum) {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var6_2 = null;
        this.topicService_$eq(new TopicCommand.TopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(this.testTopicName(), 0)}))).asJava());
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), 10000);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        Object[] rows = grabConsoleOutput_out.toString().split("\n");
        Assertions.assertEquals((int)2, (int)ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps(rows)));
        Assertions.assertTrue((boolean)((String)rows[0]).startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateWithTopicNameCollision(String quorum) {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic("foo_bar", 1, (short)6))).all().get();
        this.waitForTopicCreated("foo_bar", 10000);
        Assertions.assertThrows(InvalidTopicException.class, () -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "foo.bar"})));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException(String quorum) {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService3.createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})));
        NewTopic expectedNewTopic = new NewTopic(this.testTopicName(), Optional.empty(), Optional.empty()).configs(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic}))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$27 -> !x$27.shouldRetryOnQuotaViolation()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException(String quorum) {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService3.deleteTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).deleteTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)new .colon.colon((Object)this.testTopicName(), (List)Nil$.MODULE$)).asJavaCollection()), (DeleteTopicsOptions)ArgumentMatchers.argThat(x$28 -> !x$28.shouldRetryOnQuotaViolation()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException(String quorum) {
        TopicCommand.TopicService topicService;
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService2 = topicService = new TopicCommand.TopicService(adminClient);
        topicService = null;
        TopicCommand.TopicService topicService3 = topicService2;
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.testTopicName());
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.testTopicName(), (TopicDescription)new TopicDescription(this.testTopicName(), false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any(Collection.class))).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.testTopicName(), (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService3.alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"})))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$29 -> ((NewPartitions)x$29.get(this.testTopicName())).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$30 -> !x$30.shouldRetryOnQuotaViolation()));
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$2(TopicCommandIntegrationTest $this, KafkaBroker x$7) {
        return x$7.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterPartitionCount$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterPartitionCount$2($this, x$7)));
    }

    public static final /* synthetic */ String $anonfun$testAlterPartitionCount$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$2(TopicCommandIntegrationTest $this, KafkaBroker x$8) {
        return x$8.metadataCache().getTopicPartitions($this.testTopicName()).size() == 3;
    }

    public static final /* synthetic */ boolean $anonfun$testAlterAssignment$1(TopicCommandIntegrationTest $this) {
        return $this.brokers().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testAlterAssignment$2($this, x$8)));
    }

    public static final /* synthetic */ String $anonfun$testAlterAssignment$3() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$4(TopicCommandIntegrationTest $this, int alteredNumPartitions$1, KafkaBroker x$11) {
        return x$11.metadataCache().getTopicPartitions($this.testTopicName()).size() == alteredNumPartitions$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateAlterTopicWithRackAware$3(TopicCommandIntegrationTest $this, int alteredNumPartitions$1) {
        return $this.brokers().forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testCreateAlterTopicWithRackAware$4($this, alteredNumPartitions$1, x$11)));
    }

    public static final /* synthetic */ String $anonfun$testCreateAlterTopicWithRackAware$5() {
        return "Timeout waiting for new assignment propagating to broker";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$13) {
        return x$13.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaBroker x$14) {
        return x$14.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandIntegrationTest $this, MetadataResponseData.MetadataResponseTopic x$15) {
        return x$15.name().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponseData.MetadataResponsePartition x$16) {
        return x$16.partitionIndex() == partitionOnBroker0$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandIntegrationTest $this, int partitionOnBroker0$1, boolean result, KafkaBroker server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        scala.collection.immutable.Set x$1;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)(x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}))), x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = CollectionConverters$.MODULE$.ListHasAsScala(((MetadataResponseData.MetadataResponseTopic)topicMetadatas.find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$15))).get()).partitions()).asScala().find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$16)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw new AssertionError((Object)"Partition metadata is not found in metadata cache");
        }
        if (!(testPartitionMetadata instanceof Some)) {
            throw new MatchError((Object)testPartitionMetadata);
        }
        MetadataResponseData.MetadataResponsePartition metadata = (MetadataResponseData.MetadataResponsePartition)((Some)testPartitionMetadata).value();
        boolean bl = result && metadata.errorCode() == Errors.LEADER_NOT_AVAILABLE.code();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandIntegrationTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.brokers().filterNot((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$3(x$14)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandIntegrationTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandIntegrationTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaBroker x$17) {
        return x$17.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$18) {
        return x$18.offlineReplicas().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaBroker x$19) {
        return x$19.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$20) {
        return x$20.offlineReplicas().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeWithSyncReplicaOffline$1(TopicCommandIntegrationTest $this) {
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> $this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--invalid-replica-placement-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        return grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append($this.testTopicName()).toString());
    }

    public static final /* synthetic */ String $anonfun$testDescribeWithSyncReplicaOffline$3() {
        return "--invalid-replica-placement-partitions did not return the correct topic after the broker was killed";
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaBroker x$21) {
        return x$21.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandIntegrationTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$7(PartitionReassignment x$23) {
        return x$23.addingReplicas().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaBroker x$24) {
        return x$24.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$2(UpdateMetadataRequestData.UpdateMetadataPartitionState x$25) {
        return x$25.offlineReplicas().size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$3(UpdateMetadataRequestData.UpdateMetadataPartitionState x$26) {
        return x$26.offlineReplicas().size() == 1;
    }

    public TopicCommandIntegrationTest() {
        this.numPartitions = 1;
    }
}

